/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef _LIST_OPTIONS_MODEL_H_
#define _LIST_OPTIONS_MODEL_H_

#include <QAbstractListModel>
#include <QList>

#include <RawImageInfo.h>

class KConfigGroup;

class ListOptionsModel : public QAbstractListModel {
  Q_OBJECT
  public:
    ListOptionsModel(  );
    virtual ~ListOptionsModel();
    virtual int rowCount ( const QModelIndex & parent = QModelIndex() ) const;    
    virtual QVariant data ( const QModelIndex & index, int role = Qt::DisplayRole ) const;
    virtual bool setData ( const QModelIndex & index, const QVariant & value, int role = Qt::EditRole );
    virtual Qt::ItemFlags flags ( const QModelIndex & index ) const;
  public:
    void saveOption( const QString& _name, const ProcessingOptions& _options, const QPixmap& _preview);
    void removeBookmarkAt( const QModelIndex & index );
    void changeRawImageInfo( RawImageInfoSP _info );
    void saveToConfigGroup( KConfigGroup& group ) const;
    void loadFromConfigGroup( const KConfigGroup& group );
  signals:
    void optionsChanged();
  private slots:
    void dataUpdated(int _index);
  private:
    bool hasOptionNamed( const QString& );
    void updateMapper();
  private:
    struct Private;
    Private* const d;
};

#endif
