/*
 * Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either 
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>. */

#ifndef _JOB_PREVIEW_H_
#define _JOB_PREVIEW_H_

#include <threadweaver/Job.h>

#include "RawImageInfo.h"

class PostProcessor;
class QImage;
class PreviewInfo;

namespace KDcrawIface {
  class RawDecodingSettings;
}

namespace ThreadWeaver {
  class Weaver;
}

class JobPreview : public ThreadWeaver::Job {
  Q_OBJECT
  public:
    JobPreview( RawImageInfoSP, int _priority = 10);
    virtual ~JobPreview();
    virtual int priority() const;
    static ThreadWeaver::Weaver* weaver();
  protected:
    virtual void run();    
  signals:
    void emitIntermediateData( uchar *data, uint w, uint h );
    void imageFinished(const PreviewInfo*);
  private:
    struct Private;
    Private* const d;
};

#endif
