#!/usr/bin/env perl

# For issue279: a conflict case resulting in "bug in get_extra" with old format repos
#               and "Malformed patch bundle" with darcs-2 repos.         

use lib 'lib/perl', '../tests/lib/perl';
use Test::More 'no_plan';
use Shell::Command;
use Test::Darcs;
use Shell::Command;
use File::Slurp;
use strict;
use warnings;

init_tmp_repo('--darcs-2');

write_file 'f', '0';
darcs "add f";
darcs "record -am 00";

for my $r (qw(a b c d)) {
    darcs "put $r";
    chdir $r;
    write_file 'f', $r;
    darcs "record -am 'patch:$r'";
    chdir '..';
}

chdir 'd';
darcs "pull -a ../a";
darcs "pull -a ../b";
darcs "pull -a ../c";
chdir "../c";
darcs "pull -a ../a";
darcs "pull -a ../b";
write_file 'f', "rc";
darcs "record -a -m 'rc'";
chdir "../d";

my $out = darcs "pull -a ../c";
unlike($out,qr/no remote changes/i,"avoid no remote changes");
unlike($out,qr/bug in get_extra/,"avoid bug in get_extra");
#diag $out;
