#!/bin/sh
set -ev

test $DARCS || DARCS=$PWD/../darcs

rm -rf temp1 temp2
mkdir temp1 temp2

cd temp2
$DARCS init

cd ../temp1
$DARCS init
touch foo bar
$DARCS add foo bar
$DARCS record -a -m add_foo_bar -A x
$DARCS mv foo zig
$DARCS mv bar foo
$DARCS mv zig bar
$DARCS record -a -m swap_foo_bar -A x
$DARCS send --author=me --output=funpatch --dont-sign -a ../temp2
cd ../temp2
$DARCS apply ../temp1/funpatch
cd ..
cmp temp2/bar temp2/bar
rm -rf temp2

mkdir temp2
cd temp2
$DARCS init
$DARCS apply < ../temp1/funpatch
cd ..
cmp temp2/bar temp2/bar


rm -rf temp1 temp2

