#!/bin/sh
set -ev

test $DARCS || DARCS=$PWD/../darcs
rm -rf temp
mkdir temp
cd temp
$DARCS init
date > temp.c
$DARCS add temp.c
$DARCS record --all -A test --patch-name=hi

mkdir d
$DARCS add d
$DARCS mv temp.c d/
$DARCS record --all -A test --patch-name=mvetc
cmp d/temp.c _darcs/current/d/temp.c

echo y/d/y | tr / \\012 | $DARCS unrecord
$DARCS whatsnew
cmp d/temp.c _darcs/current/temp.c

$DARCS record --all -A test --patch-name=again
cmp d/temp.c _darcs/current/d/temp.c

cd ..
rm -rf temp

