import System
import Workaround ( matchRegex, mkRegex )

import DarcsCommands
import DarcsArguments
import TheCommands ( the_commands )
import Autoconf ( darcs_version )

main :: IO ()
main = do
  args <- getArgs
  if length args /= 1
     then exitWith $ ExitFailure 1
     else return ()
  c <- preproc ["\\input{"++head args++"}"]
  putStr $ unlines c

preproc :: [String] -> IO [String]
preproc ("\\begin{code}":ss) = ignore ss
preproc (s:ss) = do
  rest <- preproc ss
  case matchRegex (mkRegex "^\\\\input\\{(.+)\\}$") s of
    Just (fn:_) -> do cs <- readFile fn
                      this <- preproc $ lines cs
                      return $ this ++ rest
    _ -> case matchRegex (mkRegex "^(.*)\\\\haskell\\{(.+)\\}(.*)$") s of
         Just (before:var:after:_) ->
             case break (=='_') var of
             (cn,"_help") -> return $ (before++gh cn++after):rest
             (cn,"_description") -> return $ (before++gd cn++after):rest
             ("darcs","_version") -> return $ (before++darcs_version++after):rest
             aack -> error $ show aack
         _ -> case matchRegex (mkRegex "^(.*)\\\\options\\{(.+)\\}(.*)$") s of
              Just (before:comm:after:_) ->
                  return $ (before++get_options comm++after):rest
              _ ->  case matchRegex (mkRegex "^(.*)\\\\example\\{(.+)\\}(.*)$") s of
                    Just (before:fn:after:_) -> do
                        filecont <- readFile fn
                        return $ (before++"\\begin{verbatim}"++
                                  filecont++"\\end{verbatim}"
                                  ++after):rest
                    _ -> return $ s : rest
preproc [] = return []

get_options :: String -> String
get_options comm = get_com_options $ get_c comm the_commands

get_c :: String -> [DarcsCommand] -> DarcsCommand
get_c comm (c:cs) | command_name c == comm = c
                  | otherwise = get_c comm cs
get_c comm [] = error $ "No such command:  "++comm

get_com_options :: DarcsCommand -> String
get_com_options c = options_latex $ command_darcsoptions c

ignore :: [String] -> IO [String]
ignore ("\\end{code}":ss) = preproc ss
ignore (_:ss) = ignore ss
ignore [] = return []

gh :: String -> String
gh cn = get_help cn the_commands
gd :: String -> String
gd cn = get_description cn the_commands

get_help :: String -> [DarcsCommand] -> String
get_help _ [] = "No help available!\n"
get_help cn (c:_) | command_name c == cn = command_help c
get_help cn (_:cs) = get_help cn cs

get_description :: String -> [DarcsCommand] -> String
get_description _ [] = "No description available!\n"
get_description cn (c:_) | command_name c == cn = command_description c
get_description cn (_:cs) = get_description cn cs

