/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/servfunc.h,v $
 * $Revision: 1.2 $
 * $Date: 2001/06/10 23:05:09 $
 * $Author: holsta $
 * $State: Exp $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#ifndef SERVFUNC_H
#define SERVFUNC_H

#include "list.h"

struct ServerSub {
  char *name;        /* complete name of the server */
  char *port;         /* which port to use */
  char *passwd;      /* password */
  time_t connect;    /* last/current connect time */
  time_t disconnect; /* latest disconnect time */
  long average;      /* average time connected */
  long numconnects;  /* number of connects, possibly including this */
  char *message;     /* previous exit line from the server */
  char *adder;       /* who added this server */
  long flags;        /* various, see defines below */
  time_t addtime;    /* when it was added */
  int id;            /* unique ID (don't save) */
};

#define SERV_DISABLED (1<<0) /* i.e for servers temporarily out of order
				NOTE: servers that are added in the .config
				file can't be deleted but always get
				disabled if deletion is attempted */
#define SERV_INCONFIG (1<<1) /* server is defined in the .config file    */
#define SERV_ENABLED  (1<<2) /* server should get enabled. This flag should
				not get stored, it should just be used as a
				flag to StatServ() */
typedef struct Server {
  struct Header h;
  struct ServerSub s;
} itemserv;

void ServInit(void);
void ServCleanup(void);
int ManAddServ(char *name, char *port, char *passwd, char *who, long flags);
int ManDelServ(char *from, char *line);
void ListServ(char *from, char *line);
void StatServ(char *from, int options, char *server, char *port);
int SaveServ(void);
void ConnectServ(itemserv *serv);
void DisconnectServ(char *fmt, ...);
itemserv *FindServ(char *, char *);
itemserv *NextServ(void);

#endif /* SERVFUNC_H */
