#ifdef RCS
static char rcsid[]="$Id: language.c,v 1.3 2001/07/08 23:42:46 holsta Exp $";
#endif
/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/language.c,v $
 * $Revision: 1.3 $
 * $Date: 2001/07/08 23:42:46 $
 * $Author: holsta $
 * $State: Exp $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#include "dancer.h"
#include "trio.h"
#include "strio.h"
#include "transfer.h"
#include "language.h"

/* defaultlang is preferred (global, public) language */
LangNum defaultlang = LANG_DEF;

/* The preferred language to use right now (set frequently) */
LangNum uselang = LANG_DEF;

struct Language {
  char *shortname;
  char *local;
  LangNum num;
};

/* ftp://ftp.informatik.uni-erlangen.de/pub/doc/ISO/ISO-639-summary */

struct Language language_names[] = {
  {"en", "English",    LANG_ENGLISH},
  {"da", "Dansk",      LANG_DANISH},
  {"sv", "Svenska",    LANG_SWEDISH},
  {"no", "Norsk",      LANG_NORWEGIAN},
  {"nl", "Nederlands", LANG_DUTCH},
  {"fr", "Franais",   LANG_FRENCH},
  {"de", "Deutsch",    LANG_GERMAN},
  {"es", "Espaol",    LANG_SPANISH},
  {"fi", "Suomi",      LANG_FINNISH}
};

void LanguageList(char *from)
{
  char buffer[MIDBUFFER]; /* Make sure this is big enough */
  int i;

  StrFormatMax(buffer, sizeof(buffer), GetText(msg_available_languages));
  for (i=0; i < sizeof(language_names)/sizeof(language_names[0]); i++) {
    StrFormatAppendMax(buffer, sizeof(buffer), "%s (%s) ",
                       language_names[i].local,
                       language_names[i].shortname);
  }
  Send(from, buffer);
}

LangNum LanguageNum(char *string)
{
  int i;

  for (i=0; i < sizeof(language_names)/sizeof(language_names[0]); i++) {
    if (StrEqual(language_names[i].shortname, string))
      return language_names[i].num;
  }
  for (i=0; i < sizeof(language_names)/sizeof(language_names[0]); i++) {
    if (StrEqualMax(language_names[i].local, StrLength(string), string))
      return language_names[i].num;
  }
  return defaultlang; /* no match, use default */
}

char *LanguageShort(LangNum lang)
{
  int i;

  for (i=0; i < sizeof(language_names)/sizeof(language_names[0]); i++) {
    if (language_names[i].num == lang)
      return language_names[i].shortname;
  }
  return LanguageShort(defaultlang); /* No match, use default */
}

char *LanguageLocal(LangNum lang)
{
  int i;

  for (i=0; i < sizeof(language_names)/sizeof(language_names[0]); i++) {
    if (language_names[i].num == lang)
      return language_names[i].local;
  }
  return LanguageLocal(defaultlang); /* No match, use default */
}

#define LENGTH_SHORTNAME 2

char *GetText(char *msg[])
{
  char *text;
  int i;

  for (i=0; (text = msg[i]); i++) {
    if (StrEqualCaseMax(language_names[uselang].shortname, LENGTH_SHORTNAME, text))
      return &text[LENGTH_SHORTNAME];
  }
  return GetDefaultText(msg);
}

char *GetDefaultText(char *msg[])
{
  char *text;
  int i;

  for (i=0; (text = msg[i]); i++) {
    if (StrEqualCaseMax(language_names[defaultlang].shortname, LENGTH_SHORTNAME, text))
      return &text[LENGTH_SHORTNAME];
  }
  return &msg[0][LENGTH_SHORTNAME]; /* Return the first string */
}


/* --- Strings ---------------------------------------------------- */

#if 0
char *msg_syntax_error[] = {
  "enSyntax error",
  "daSyntaks fejl",
  "svSyntaxfel",
  "noSyntaksfeil",
  "nlSyntax fout",
  "frErreur de syntaxe",
  "deSyntaxfehler",
  "esError de Sintaxis",
  "fiVirhe syntaksissa",
  NULL
};
#endif

char *msg_usage[] = {  /* command, syntax */
  "enUsage: %s %s",
  "daBrug: %s %s",
  "svAnvndning: %s %s",
  "noBruk: %s %s",
  "nlGebruik: %s %s",
  "frUtilisation: %s %s",
  "deSyntax: %s %s",
  "esUtiliza: %s %s",
  "fiKytt: %s %s",
  NULL
};

char *msg_not_implemented[] = {
  "enNot implemented yet",
  "daEndnu ikke implementeret",
  "svInte implementerat n",
  "noEnn ikke implementer",
  "nlNog niet ondersteund",
  "frPas implement encore",
  "deNoch nicht implementiert",
  "esAun no implementado",
  "fiEi implementoitu",
  NULL
};

char *msg_no_explaination[] = {
  "en*Shrug* I don't know",
  "da*Trkker p skuldrene* Aner det ikke",
  "sv*Rycker p axlarna* Har ingen aning",
  "no*Trekker p skuldrene* Ha'kke peiling",
  "nl*Uch* geen idee",
  "fr*Snif* Je ne sais pas",
  "de*Uhh* Ich wei nicht",
  "es*puff* no se",
  "fi*kohauttaa olkapitn* Ei aavistusta",
  NULL
};

char *msg_shutdown_in_progress[] = {
  "enShutdown in progress. Cannot accept commands",
  "daNedlukning i gang. Kan ikke udfre kommandoer",
  "svNedstngning p gng. Kan inte utfra ngra kommandon",
  "noNedstengning p gang. Kan ikke utfre noen kommandoer",
  "nlUitschakeling in voorbereiding. Kan geen kommandos accepteren",
  "frFermeture en cours. Peux pas accepter de commandes",
  "deHerunterfahren im Gang. Befehlsannahme nicht mglich",
  "esEn proceso de apagado. no puedo aceptar comandos",
  "fiAlasajo kynniss. En hyvksy en komentoja",
  NULL
};

char *msg_help_short[] = {
  "enI'm a %s bot. \"/msg %s CMD\" for a list of available commands",
  "daJeg er en %s IRC bot. \"/msg %s CMD\" for en liste af tilgngelige"
  " kommandoer",
  "svJag r en %s IRC bot. \"/msg %s CMD\" fr att f en lista med"
  " tillgngliga kommandon",
  "noJeg er en %s IRC bot. \"/msg %s CMD\" for  f ei liste over"
  " tilgjengelige kommandoer",
  "nlIk ben een %s bot. \"/msg %s CMD\" voor een lijst met beschikbare kommandos",
  "frJe suis un %s robot. \"/msg %s CMD\" pour une liste de commandes"
  " disponible",
  "deIch bin ein %s IRC-Bot. \"/msg %s CMD\" fr eine Liste aller verfgbaren",
  " Befehle",
/* rek2 */
  "esSoy un %s Bot. \"/msg %s CMD\" para unlistado de comandos existentes",
  "fiOlen %s botti. \"/msg %s CMD\" nytt listan kytettvisssi"
  " olevista komennoista",
  NULL
};

char *msg_help_help[] = {
  "enI'm a " VERSIONMSG " IRC bot.",
  "daJeg er en " VERSIONMSG " IRC bot.",
  "svJag r en " VERSIONMSG " IRC bot.",
  "noJeg er en " VERSIONMSG " IRC bot.",
  "nlIk ben een " VERSIONMSG " IRC bot.",
  "frJe suis un " VERSIONMSG " IRC robot.",
  "deIch bin ein " VERSIONMSG " IRC-Bot.",
  "esSoy un " VERSIONMSG " IRC bot.",
  "fiOlen " VERSIONMSG " IRC botti.",
  NULL
};

char *msg_help_syntax[] = {
  "enShows the syntax of a command. [<A>] means the argument <A> is"
  " optional. <A>|<B> means you can choose either <A> or <B>",

  "daViser syntaksen for en kommando. [<A>] betyder at argumentet <A> er"
  " valgfrit. <A>|<B> betyder at du kan vlge enten <A> eller <B>",

  "svVisar syntaxen av ett kommando. [<A>] betyder att argumentet <A> r"
  " valfritt. <A>|<B> betyder att du kan vlja antingen <A> eller <B>",

  "noViser syntaksen for en kommando. [<A>] betyr at argumentet <A> er"
  " valgfritt. <A>|<B> betyr at du kan velge enten <A> eller <B>",

  "nlToont de formulering van een kommando. [<A>] betekent het argument <A> is"
  "optioneel. <A>|<B> betekent dat <A> of <B> gekozen kunnen worden",

  "frMontre la syntaxe d'une commande. [<A>] veux dire que l'argument <A>"
  " est optionel. <A>|<B> veux dire que tu peux choisir sois <A> ou <B>",

  "deErlutert die Syntax eines Befehls. [<A>] bedeutet, da der Parameter"
  " <A> optional ist. <A>|<B> bedeutet, da zwischen <A> und <B> gewhlt"
  " werden kann",

  "esTe ensea la sintexis de un comando. [<A>] significa que el argumento <A> es"
  " opcional. <A>|<B> significa que puedes elegir entre <A> o <B>",

  "fiNytt komennon syntaksin. [<A>] tarkoittaa ett argumentti <A> on"
  " vaihtoehtoinen. <A>|<B> tarkoittaa ett voit valita joko <A> tai <B>",

  NULL
};

char *msg_help_explain[] = {
  "enExplains a certain subject. * and ? can be used as wildcards."
  " An ambiguous request returns all possible entries. -S searches"
  " the content of the explanations rather than the keywords",

  "daForklarer et bestemt emne. * og ? kan bruges som wildcard."
  " En tvetydig foresprgsel returnerer alle muligheder. -S sger"
  " i forklaringerne fremfor kun blandt ngleorderne",

  "svFrklarar ett viss mne. * och ? kan anvndas som wildcard."
  " En tvetydig begran visar alla mjligheter. -S sker i frklaringarna"
  " istllet fr bland de frklarade orden",

  "noForklarer et visst emne. * og ? kan brukes som jokere (wildcards(."
  " En tvetydig foresprsel viser alle muligheter. -S sker i forklaringene"
  " istedet for de forklarende ordene",

  "nlVerklaart een zeker onderwerp. * een ? kan gebruikt worden als wildcards."
  " Een ambitieuse vraag geeft alle mogelijkheden. -S zoekt"
  " de inhoud van de verklaring in plaats van de sleutelwoorden",

  "frExplique un certain sujet. * et ? peuvent-tre utiliser comme *joker*"
  " Une commande ambigue retourne toute les entre possible. -S cherche"
  " le contenu de cet explication et non les mots cls",

  "deErlutert ein bestimmtes Thema. * und ? knnen als Platzhalter gesetzt"
  " werden. Eine mehrdeutige Anfrage gibt alle in Frage kommenden Eintrge"
  " aus. -S durchsucht die Inhalte der Eluterungen anstelle der"
  " Schlagworte",

  "esExplica un sujeto en si.* y ? pueden ser usados como wildcards."
  " Una busqueda que devuelve todas las posibles entradas. -S busca"
  " el contenido de la explicacion en vez de sus  keyworkds",

  "fiSelitt tietyn aiheen. '*' ja '?' -merkkej voi kytt jokereina."
  " Mikli hakusana sisltyy useampaan avainsanaan, palautuu kaikki"
  " hakuun sopivat avainsanat. -S etsii selityksien sislt avainsanojen"
  " sijaan",

  NULL
};

char *msg_help_rules[] = {
  "enTells where/how the rules of this channel can be found",
  "daFortller hvor/hvordan kanalens regler kan findes",
  "svBerttar om kanalens regler eller var du kan hitta dem",
  "noForteller om kanalens regler eller hvor du kan finne dem",
  "nlVerklaart waar/hoe de regels van dit kanaal gevonden kunnen worden",
  "frDis ou/comment les rgles du canal peuvent tre trouver",
  "deErlutert, wo und wie die Regeln dieses Kanals gefunden werden knnen",
  "esTe dice donde/como las normal del canal pueden ser encontradas",
  "fiKertoo kanavan snnt, tai mist ja miten ne on lydettviss",
  NULL
};

char *msg_help_seen[] = {
  "enReports when <nick> was last seen on the channel. -M shows the"
  " most used and -R the most recent. -A shows all",
  "daFortller hvornr <nick> sidst er blevet set p kanalen. -M viser"
  " den mest brugte. -A viser alle",
  "svBerttar nr <nick> senast sgs i kanalen. -M visar den mest anvnda."
  " -A visar alla",
  "noForteller nr <nick> sist ble sett p kanalen. -M viser den mest brukte."
  " -A viser alle",
  "nlRapporteert wanneer <nick> het laatst gezien werd op het kanaal. -M toont de"
  " meest gebruikte. -A toont alles",
  "frRapporte quand <nick>  t vu la dernire fois sur le canal."
  " -M montre celui le plus utilis. -A montre tout",
  "deGibt aus, wann <nick> das letzte mal auf diesem Kanal gesehen wurde. -M"
  " gibt die am meisten gebrauchten aus, -A alle",
  "esTe dice la ultima vez que <nick> fue visto en el canal. -M te muestra"
  " el mas usado. -A te muestra todos",
  "fiKertoo milloin <nick> viimeksi nhtiin kanavalla. -M nytt eniten kytetyn"
  " osoitteen ja -R viimeisen kerran. -A nytt kaikki osoitteet",
  NULL
};

char *msg_help_sview[] = {
  "enViews your own or somebody else's status (latter requires"
  " level 20). -A displays all recognized accounts. -S is short output."
  " -R will try to display a registered nick with that name prior to anyone"
  " joined with the nick",

  "daViser din egen eller en andens status (sidstnvnte krver mindst"
  " niveau 20). -A viser alle registrerede konti. -S viser s lidt som"
  " muligt. -R viser oplysningerne om det registrerede nick fremfor nogen"
  " p kanalen med samme nick",

  "svVisar din egen eller andras status (det sistnmnda krver minst niv"
  " 20). -A visar alla registrerade konton. -S ger en liten utskrift. -R"
  " visar uppplysningar om den registrerade nicken istllet fr ngon p"
  " kanalen med samma nick",

  "noViser din egen eller andres status (det sistnevnte krever minst niv"
  " 20). -A viser alle registrerte konti. -S gir en liten utskrift. -R"
  " viser opplysninger om den registrerte nicken istedet for noen p"
  " kanalen med samme nick",

  "nlToont je eigen of iemand's anders zijn status (laatst genoemde vereist"
  " niveau 20). -A toont alle herkende accounts. -S is verkorte uitgave."
  " -R tracht een geregistreerde nick eerst te tonen in plaats van iemand"
  "die gejoined is met deze nick",

  "frMontre ton propre status ou celui d'un autre (besoin d'avoir niveau 20)"
  " -A montre tout les comptes reconnu. -S donne un petit rsum. -R vas essayer"
  " de montrer un nick enregistrer avec le nom avant que n'importe qui puisse"
  " joindre avec ce nick",

  "deGibt den eigenen Status oder den eines anderen Benutzers aus (letzteres"
  " erfordert Level 20). -A zeigt alle bekannten Eintrge. -S erzwingt eine"
  " kurze Ausgabe. -R versucht, einen bekannten nick anzuzeigen, bevor jemand"
  " mit diesem nick den Kanal betreten hat",

  "esTE esea tu estatus o el de otro (requiere nivel 20) -A te muestra todas"
  " las cuentas reconocidas. -S de un modo mas corto. -R tratara de ensearte"
  " el registro de nick deseado antes del ultimo que ha entrado con ese nick",

  "fiNytt sinun tai jonkun toisen henkiln statuksen (jlkimminen"
  " vaatii tason 20). -A nytt rekisteridyn kyttjn kaikki tunnetut"
  " kyttj@osoite maskit. -S antaa lyhyen tulosteen. -R yritt nytt"
  " ensisijaisesti rekisteridyn nikin tiedot ennen kanavalla mahdollisesti"
  " yhtaikaisesti olevan samannikkisen kyttjn tietoja",

  NULL
};

char *msg_help_cmd[] = {
  "enShows all commands that are available to you ('*' needs password,"
  " 'P' may be used in public, and 'S' may have its output redirected"
  " by SHOW)",

  "daViser alle kommandoer som du kan benytte ('*' krver password,"
  " 'P' kan bruges p kanalen og 'S' kan omdirigeres vha. SHOW)",

  "svVisar alla kommandon du kan anvnda. ('*' krver lsenord, 'P' kan"
  " anvndas i kanalen och 'S' kan f sin utskrift omdirigerad mha SHOW)",

  "noViser alle kommandoer du kan bruke. ('*' krever passord, 'P' kan"
  " brukes p kanalen og 'S' kan omdirigeres via SHOW)",

  "nlToont alle kommandos die voor jou beschikbaar zijn ('*' benodigt watchwoord,"
  " 'P' kan publiekelijk gebruikt worden, en 'S' kan de uitvoer omleiden door"
  " middel van SHOW)",

  "frMontre tout les commandes qui te sont accessibles ('*' a besoin d'un"
  " mot de passe, 'P' peut-tre utilis en public, et 'S' peut avoir la"
  " rponse redirige vers SHOW)",

  "deZeigt alle zur Verfgung stehenden Kommandos an ('*' bentigt ein"
  " Pawort, 'P' kann ffentlich gebraucht werden; die Ausgabe von 'S' kann"
  " mit SHOW umgeleitet werden)",

  "esTe muestra todos los comandos que estan disponibles para ti"
  " ('*' necesitas password, 'p' debe usarse en publico, y 'S' lo"
  " redireciona por SHOW)",

  "fiNytt kaikki kytettvisssi olevat komennot ('*' vaatii salasanan,"
  " 'P' mahdollistaa komentojen kytn julkisesti, ja 'S' komentojen"
  " tuloste voidaan ohjata SHOW komennolla)",

  NULL
};

char *msg_help_uptime[] = {
  "enShows how long ago I was started",
  "daViser hvor lnge siden jeg blev startet",
  "svVisar hur lnge sedan jag startade",
  "noViser hvor lenge det er siden jeg startet",
  "nlToont hoe lang geleden ik opgestart werd",
  "frMontre depuis quand j'ai t parti",
  "deGibt aus, wie lange der Start des Bots zurckliegt",
  "esTE muestra hace cuanto me he iniciado",
  "fiKertoo kuinka kauan sitten minut kynnistettiin",
  NULL
};

char *msg_help_split[] = {
  "enShows information about current or previous netsplit(s)",
  "daViser information om nuvrende og tidligere netdelinger (netsplit)",
  "svVisar information om nuvarande och tidigare ntdelningar (netsplit)",
  "noViser informasjon om nvrende og tidligere nettdelinger (netsplit)",
  "nlToont informatie omtrent huidige of vorige netsplit(s)",
  "frMontre l'information a propos du dernier ou le netsplit prsent",
  "deGibt Informationen ber aktuelle oder vergangene Netsplits aus",
  "esTe muestra informacion sobre el actual y previo netsplit(s)",
  "fiNytt tietoa tmnhetkisist tai aikaisemmista netspliteist",
  NULL
};

char *msg_help_tellme[] = {
  "enRelays the first unread messages. -A relays all at once",
  "daSender den frste ulste meddelse. -A sender alle p een gang",
  "svVisar det frsta olsta meddelandet. -A visar alla p en gng",
  "noViser den frste uleste meldinga. -A viser alle p en gang",
  "nlToont het eerste ongelezen bericht. -A toont alles in een keer",
  "frRelaye le premier message non-lu. -A les relaye tous en mme temps",
  "deZeigt die erste ungelesene Nachricht an. -A zeigt alle aus einmal",
  "esTe muestra el primer msg sin leer. -A te muestra todos",
  "fiNytt ensimmisen lukemattoman viestin. -A nytt kaikki kerralla",
  NULL
};

char *msg_help_alias[] = {
  "enLists the accepted aliases for <cmd>",
  "daViser en liste over aliaser for <cmd>",
  "svVisar en lista ver alias fr <cmd>",
  "noViser ei liste over aliaser for <cmd>",
  "nlToont de geaccepteerde aliassen voor <cmd>",
  "frListe les alias accept pour <cmd>",
  "deGibt eine Liste aller Aliase fr <cmd> aus",
  "esLista los alias validos para <cmd>",
  "fiNytt hyvksytyt aliakset komennolle <cmd>",
  NULL
};

char *msg_help_wholeft[] = {
  "enLists the people who left during a netsplit",
  "daViser de folk der forlod kanalen pga. en netdeling (netsplit)",
  "svVisar vilka som lmnade kanalen pga en ntdelning (netsplit)",
  "noViser hvem som forlot kanalen pga. en nettdeling (netsplit)",
  "nlToont de mensen die tijdens een netsplit weggingen",
  "frListe ceux qui ont quitt durant le netsplit",
  "deGibt eine Liste aller Personen aus, die den Kanal whrend eines"
  " Netsplits verlassen haben",
  "esLista la gente que ha salido durante el netsplit",
  "fiNytt listan ihmisist jotka poistuivat netsplitiss",
  NULL
};

char *msg_help_show[] = {
  "enShow the output from a given command to <nick>",
  "daViser outputtet fra en given kommando til <nick>",
  "svSkickar utskriften frn ett givet kommando till <nick>",
  "noViser utskriften fra en gitt kommando til <nick>",
  "nlToont de uitvoer van een gegeven kommando aan <nick>",
  "frMontre le rsultat d'une commande donn  <nick>",
  "deLeitet die Ausgabe eines Befehls an <nick> um",
  "esTe muestra la salida de un comando dado a <nick>",
  "fiOhjaa suoritettavan komennon tulosteen nikille <nick>",
  NULL
};

char *msg_help_pass[] = {
  "enVerify existence with password. Default password (if it never has been"
  " changed by you) is '%s'",

  "daVerificerer dig vha. password. Default password (hvis du aldrig har"
  " ndret det) er '%s'",

  "svVerifierar dig mha lsenord. Default lsenord (om du inte har ndrat"
  " det) r '%s'",

  "noVerifiserer deg vha. passord. Default passord (hvis du aldri har"
  " endret det) er '%s'",

  "nlVerifieert bestaan met wachtwoord. Standaard wachtwoord (indien je dit nooit"
  " veranderd hebt) is '%s'",

  "frVerifie l'existence avec un mot de passe. Le mot de passe par dfaut"
  " (s'il n'as jamais t chang par vous) est '%s'",

  "deBenutzerverifikation durch Passwort. Das Standardpawort, soweit nicht"
  " in der Konfigurationsdatei gendert, ist '%s'",

  "esVerifica la existencia de un password. password por defecto(si"
  " nunca ha sido cambiado por ti) es '%s'",

  "fiTodista henkilllisyytesi salasanan avulla. Oletusarvoisesti salasanasi"
  " on '%s', mikli et koskaan ole sit muutanut",

  NULL
};

char *msg_help_ident[] = {
  "enThis will let the bot recognize you from a new site. You MUST use your"
  " password so the bot knows it's really you. If you're using a different"
  " nickname than you were when you registered, you'll have to give your"
  " original nickname too",

  "daDette fr mig til at genkende dig fra et nyt sted. Du SKAL bruge dit"
  " password, s jeg virkeligt ved at det er dig. Hvis du bruger det andet"
  " nick end det du er registreret med, s skal du ogs angive det"
  " registrerede nick",

  "svDetta gr att botten knner igen dig frn ett nytt stlle. Du mste"
  " anvnda ditt lsenord s att botten vet att det verkligen r du. Om du"
  " anvnder ett annat nick n det du r registrerad med, mste du ange ditt"
  " registrerade nick ocks",

  "noDette lar boten kjenne deg igjen fra et nytt sted. Du m bruke ditt"
  " passord s boten vet at det virkelig er deg. Hvis du bruker et annet"
  " nick enn det du er registrert med, m du angi ditt registrerte nick og",

  "nlDit commmando laat de bot je herkennen vanaf een nieuwe site. Je MOET je"
  " wachtwoord gebruiken zodat de bot weet dat jij het echt bent. Als je een"
  " andere nickname gebruikt dan waarmee je geregistreerd staat, dien je ook"
  " je geregistreerde nickname te geven",

  "frPermettra au robot de te reconnatre d'un autre site. Tu DOIS utilis"
  " ton mot de passe pour permettre au robot de savoir si c'est bien toi."
  " Si tu utilise un nick diffrent que lorsque tu t'es enregistrer , tu "
  " devras donner ton nick original aussi",

  "deFgt dem eigenen Benutzereintrag eine neue Hostmaske hinzu. Das Pawort"
  " des entsprechenden Benutzereintrags mu angegeben werden. Wird ein"
  " anderer Nick benutzt, mu auch der dem Bot bekannte Nick mit angegeben"
  " werden",

  "esEste deja que el bot te reconozca desdee una procedencia nueva.Debes usar"
  " tu password para que el bot sepa que eres tu. si estas usando un nick "
  " diferente debes de mostrar tambien tu nick original",

  "fiTmn avulla saat botin tunnistamaan sinut uudesta osoitteesta. Sinun"
  " _tytyy_ kytt omaa salasanaasi jotta botti voi riittvll varmuudella"
  " tiet ett se todellakin olet sin. Jos kytt eri nikki kuin mill"
  " olet rekisterity, on sinun annettava se mys toisena argumenttina",

  NULL
};

char *msg_help_newpass[] = {
  "enSets a new password. You must verify yourself with your old one first."
  " See also PASS or OP",

  "daStter et nyt password. Du skal frst verificere dig med det gamle"
  " password. Se ogs PASS eller OP",

  "svStter ett nytt lsenord. Du mste frst verifiera dig med det gamla"
  " lsenordet. Se ocks PASS eller OP",

  "noSetter et nytt passord. Du m frst verifisere deg med det gamle"
  " passordet. Se ogs PASS eller OP",

  "nlZet een nieuw wachtwoord. Je dient je eerst herkenbaar te maken met je"
  " oude wachtwoord. Zie ook PASS of OP",

  "frDfini un nouveau mot de passe. Tu dois vrifier avec ton ancien avant."
  " Voir aussi PASS ou OP",

  "deSetzt ein neues Pawort. Zuvor ist eine Anmeldung mit dem alten Pawort"
  " notwendig. Siehe auch PASS und OP",

  "esDefine un nuevo password. Debes de verificarte primero con tu antiguo"
  " password. Para mas informacion mirar tambien PASS o OP",

  "fiVaihtaa salasanasi. Sinun on todistettava henkilllisyytesi ennen"
  " komennon kytt, katso PASS ja OP",

  NULL
};

char *msg_help_comment[] = {
  "enChanges user comment. 'comment none' removes your comment. To change"
  " someone elses comment with -n you must be LEVELEXPERT or greater",
  "dandrer bruger kommentar",
  "svndrar kommentaren som lagras med din anvndarprofil. Ange kommentar"
  " 'none' fr att ta bort den. ndra andras kommentarer med -n (krver att"
  " har tillrckligt hg status)",
  "noEndrer brukerkommentar",
  "nlVerandert gebruiker's commentaar",
  "frChange les commentaires-client",
  "dendert den Benutzerkommentar. 'kein Kommentar' entfernt den Eintrag. Um"
  " de Eintrag eines anderen Benutzers mit -n zu ndern, ist der"
  " Benutzerlevel LEVELEXPERT oder hher notwendig",
  "esCambia el comentario de un usuario.'comment none' borra tu comentario."
  " para cambiar el de alguien debes de usar el flag -n y debes de ser de un nivel"
  " LEVELEXPERT or mayor",
  "fiVaihtaa kommenttisi bottiin. 'comment none' poistaa kommentin."
  " -N optiota kytten voit vaihtaa muiden kyttjien kommentteja mikli"
  " tasosi on LEVELEXPERT tai enemmn",
  NULL
};

char *msg_help_convert[] = {
  "enConverts a value to many units",
  "daKonverterer en vrdi til mange forskellige enheder",
  "svKonverterar ett vrde till mnga olika enheter",
  "noKonverterer en verdi til mange forskjellige enheter",
  "nlKonverteert een waarde naar andere eenheden",
  "frConvertis une valeur en plusieurs units",
  "deRechnet einen Wert in viele verschiedene Einheiten um (z.B. Meter in"
  " Meilen, Grad Celsius in Kelvin usw.)",
  "esConvierte un valor en otras unidades (como de grados Celsios a Kelvin)",
  "fiMuuntaa arvoja eri yksikiden vlill",
  NULL
};

char *msg_help_tz[] = {
  "enConverts, lists and displays timezones for different countries",
  "daKonverterer og viser tidszoner for forskellige lande",
  "svKonverterar och visar tidszoner fr olika lnder",
  "noKonverterer og viser tidssoner for forskjellige land",
  "nlKonverteert en toont tijdzones voor verschillende landen",
  "frConvertis, liste et montre les canaux horaires pour les diffrent pays",
  "deBerechnet Zeitzonenverschiebungen fr verschiedene Lnder und gibt sie"
  " aus",
  "esConvierte, Lista y Muestra las horas de diferentes paises",
  "fiMuuntaa, listaa ja nytt aikavyhykkeit eri maille",
  NULL
};

char *msg_help_spell[] = {
  "enChecks the spelling of one or more words",
  "daUndersger den (engelske) stavning af et eller flere ord",
  "svKontrollerar (den engelska) stavningen av ett eller flera ord",
  "noUndersker (den engelske) stavingen av et eller flere ord",
  "nlKontroleert de spelling van een of meerdere woorden",
  "frVrifie l'orthographe de un ou plusieurs mots",
  "deberprft die Rechtschreibung eines oder mehrerer Wrter",
  "esCorrige la ortografia (en ingles)de una o mas palabras",
  "fiTarkistaa yhden tai useamman sanan oikeinkirjoituksen",
  NULL
};

char *msg_help_mynick[] = {
  "enIf you keep a DCC chat when leaving, and then rejoins with another "
  "nick, this is the command to tell me what your new nick is",

  "daHvis du har en DCC chat, og forlader kanalen og kommer tilbage med"
  " et nyt nick, s brug denne kommando til at fortlle mig om dit nye"
  " nick",

  "svOm du har en DCC chat och lmnar kanalen och kommer tillbaka med ett"
  " nytt nick, anvnd dett kommando fr att bertta fr mig om ditt nya"
  " nick",

  "noHvis du har en DCC chat og forlater kanalen, for s  komme tilbake"
  " med nytt nick, bruker du denne kommandoen for  fortelle meg om det",

  "nlIndien je een DCC openlaat bij het weggaan, en rejoined met een andere"
  "nick, is dit het kommando om te vertellen wat je nieuwe nick is",

  "frSi tu gardes un DCC chat quand tu quittes, et reviens avec un nouveau,"
  " C'est la commande a utlis pour me dire quel nick tu as prsentement",

  "deWenn eine DCC-Verbindung zu dem Bot beim Verlassen nicht beendet wird,"
  " kann man bei einem Rejoin mit einem anderen Nick diesen dem Bot mit"
  " diesem Kommando mitteilen",

  "esSi mantienes un sesion DCC cuando has dejado el irc, y reanudas con otro"
  " nick, este es el comando que me va a decir que nuevo nick tienes",

  "fiMikli sinulla on DCC chat kanssani poistuessasi kanavalta, ja"
  " palatessasi sitten takaisin eri nikill, niin tll komennolla"
  " voit kertoa minulle mik uusi nikkisi on",

  NULL
};

char *msg_help_find[] = {
  "enFinds lines in the special search file. Maximum 3 matches are"
  " displayed if <matches> isn't specified",

  "daFinder linier i en speciel sgefil. Hvis <matches ikke er"
  " specificeret vises hjst 3 sammentrf",

  "svSker efter matchande rader i skfilen. Max 3 sktrffar visas"
  " om <matches> inte specificeras",

  "noFinner linjer i en spesiell skefil. Hvis <matches> ikke er"
  " spesifisert, vises maks 3 tilfeller",

  "nlVindt regels in het speciale zoek bestand. Maximaal 3 matches worden"
  " getoond, indien <matches> niet gespecificeerd is",

  "frTrouves une ligne dans le fichier spcial. Un maximum de 3 sont "
  " montrs si <matches> n'as pas t spcifi",

  "deDurchsucht die spezielle Suchdatei. Maximal 3 Treffer werden angezeigt,"
  " wenn <matches> nicht angegeben ist",

  "esBusca lineas en el fichero especial de busquedas. Un maximo de 3 reultados"
  " son mostrados si <matches> no lo has especificado",

  "fiEtsii rivej erityisest hakutiedostosta. Maksimissaan 3 rivi"
  " nytetn kerrallaan mikli <matches> jtetn mrittelemtt",

  NULL
};

char *msg_help_country[] = {
  "enReports which country <nick> is from (or which country has <id>"
  " as country-code)",

  "daFortller hvilket land <nick> kommer fra (eller hvilket land der"
  " har landekoden <id>)",

  "svBerttar vilket land <nick> kommer ifrn (eller vilket land som har"
  " landskoden <id>)",

  "noForteller hvilket land <nick> kommer fra (eller hvilket land som har"
  " landskoden <id>)",

  "nlRapporteert uit welk land <nick> komt (of welk land <id>"
  " als lands-code heeft)",

  "frRaporte de quel pays <nick> provient( ou quel pays a <id> comme code"
  " rgional)",

  "deZeigt an, aus welchem Land <nick> kommt (oder welches Land <id> als"
  " Landescode hat)",

  "esMuestra de que pais <nick> procede (o cuando el pais tiene <id>"
  " como codigo-del-pais)",

  "fiKertoo mist maasta <nick> on kotoisin (tai vaihtoehtoisesti mink"
  " maan koodi <id> on)",

  NULL
};

char *msg_help_calc[] = {
  "enCalculates a mathematical expression. Max 3 lines of the result is"
  " displayed. Do 'man bc' from a Unix shell to read the docs. If you"
  " don't have Unix... too bad ;)",

  "daBeregner et matematisk udtryk. Hjst 3 linier af resultatet vises."
  " Udfr 'man bc' fra en Unix skal for at lse dokumentationen. Har"
  " du ikke Unix, s er det bare rgeligt ;)",

  "svBerknar ett matematiskt uttryck. Max 3 rader av resultatet visas."
  " Skriv 'man bc' i ett Unixskal fr att lsa dokumentationen. Om du inte"
  " har ngon Unix, synd! ;)",

  "noBeregner et matematisk uttrykk. Maks 3 linjer av resultatet vises."
  " Skriv 'man bc' i et Unixshell for  lese dokumentasjonen. Hvis du ikke"
  " har Unix, synd! ;)",

  "nlCalculeert een mathematische expressie. Max 3 regels van het resultaat"
  " worden getoond. Gebruik 'man bc' vanuit een Unix shell om de documentatie"
  " te lezen. Als je niet de beschikking hebt over Unix... pech gehad ;)",

  "frCalcules une expression mathmatique. Un maximum de 3 lignes du rsultat"
  " est afficher. Fait 'man bc' a partir d'un shell Unix pour lire le manuel"
  " Si t'as pas Unix... C'est plate a ;)",

  "deBerechnet einen mathematischen Ausdruck. Maximal 3 Zeilen des"
  " Ergebnisses werden ausgegeben. Die Genaue Anleitung ist mit 'man bc' in"
  " jeder UNIX-Shell verfgbar. Wie, kein UNIX? So ein Pech... :)",

  "esCalcula una expresion matematica. MAX de 3 lineas de resultado es mostrado"
  " haz un 'man bc' desde una shell unix para leer los documentos.Si no"
  " tienes UNIX... Lo siento jiji)",

  "fiLaskee matemaattisia lausekkeita. Enimmilln 3 rivi tuloksesta"
  " nytetn. Kokeile 'man bc' *ix kuorella jos haluat lisohjeita",

  NULL
};

char *msg_help_topic[] = {
  "enTells by whom and when a topic was made",
  "daFortller hvem der satte topic, og hvornr det blev sat",
  "svBerttar av vem och nr ett topic sattes",
  "noForteller hvem som satt topic, og nr",
  "nlVertelt wie en wanneer een topic heeft geplaatst",
  "frDis par qui et quand le topic a t mis",
  "deGibt aus, wann und von wem ein Thema (Topic) gesetzt wurde",
  "esTe dice quien y cuando fue cambiado el topic",
  "fiNytt kanavan topikin, kuka sen asetti ja milloin",
  NULL
};

char *msg_help_tell[] = {
  "enStores a message for a person who is not currently on the channel."
  " Although <who> is a nick, recognition is done by host",

  "daGemmer en besked til en person som ikke er paa kanalen for jeblikket."
  " Selvom <who> er et nick, s genkendes personen paa host, ikke nick",

  "svLagrar ett meddelande till en person som inte r i kanalen just nu."
  " Fastn <who> r ett nick, s knns personen igen p host-basis inte nick",

  "noLagrer en melding til en person som ikke er p kanalen for yeblikket."
  " Selv om <who> er et nick, s kjennes personen igjen p host-basis, ikke nick",

  "nlBewaart een bericht voor een persoon die niet aanwezig is op het kanaal"
  " Alhoewel <who> een nick is, geschied herkenning op basis van de host",

  "frEmmagasine un message pour une personne qui n'est pas actuellement sur"
  " le canal. Malgr que <who> est un nick, la diffrence est faite avec le host",

  "deSpeichert eine Nachricht an einen Benutzer, der im Moment nicht im Kanal"
  " ist. Obwohl <who> ein Nick ist, erfolgt die Identifizierung ber die"
  " Hostmaske",

  "esGuarda un msg para alguien que no esta presente en el canal."
  " y como <who> es un nick, la diferencia la realiza mascara de host",

  "fiTallentaa viestin henkillle joka ei juuri sill hetkell ole kanavalla."
  " Vaikka <who> onkin nikki, tunnistus tapahtuu osoitteen perusteella",

  NULL
};

char *msg_help_telldel[] = {
  "enRemoves a stored message. The <tell id> is given by TELL or TELLLIST",
  "daFjerner en gemt besked. <tell id> kan findes ved TELL eller TELLLIST",
  "svRaderar ett lagrat meddelande. <till id> hittar du med TELL eller"
  " TELLLIST",
  "noFjerner en lagret beskjed. <tell id> kan finnes med TELL eller TELLLIST",
  "nlVerwijdert een bewaard bericht. Het <bericht nr> wordt gegeven door TELL of TELLLIST",
  "frEnlve un message enregistr. Le <tell id> est donn par TELL ou TELLLIST",
  "deEntfernt eine gespeicherte Nachricht. Die <tell id> wird von TELL oder"
  " TELLLIST angezeigt",
  "esBorra un msg guardado.El <tell id> es dado por TELL o TELLLIST",
  "fiPoistaa tallennetun viestin. <tell id> on TELL tai TELLLIST komentojen"
  " palauttama numero",
  NULL
};

char *msg_help_telllist[] = {
  "enLists all messages stored by you",
  "daViser en oversigt over alle beskeder du har gemt",
  "svVisar all meddelanden som du har lagrat",
  "noViser alle meldinger du har lagret",
  "nlToont alle door jouw bewaarde berichten",
  "frListe tout les message emmagasins par toi",
  "deGibt eine Liste aller von Ihnen gespeicherten Nachrichten aus",
  "esLista todos los msg que han sido guardados por ti",
  "fiNytt listan viesteist jotka olet tallentanut",
  NULL
};

char *msg_help_toplist[] = {
  "enPresents various toplists about the current guests. 'joins' - most"
  " recorded joins, 'joined' longest join (in minutes) 'idle' - longest"
  " quiet users (in minutes), 'talk' - number of written lines. See"
  " 'syntax toplist' for complete list",

  "daViser forskellige top lister om gsterne p kanalen. 'joins' - hvem"
  " har joinet flest gange, 'joined' - hvem har vret her lngst, 'idle'"
  " - hvem har vret mest inaktiv, 'talk' - hvem har talt mest. Se 'syntax"
  " toplist' for en komplet liste",

  "svVisar olika topplistor om gsterna i kanalen. 'joins' - de som har"
  " joinat flest gnger, 'joined' - vem har varit hr lngst (i minuter),"
  " 'idle' - vem har varit tyst lngst, 'talk' - flest skrivna rader. Se"
  " 'syntax toplist' fr en komplett lista",

  "noViser forskjellige topplister om gjestene p kanalen. 'joins' - de"
  " som har joinet flest ganger, 'joined' - hvem som har vrt her lengst"
  " (i minutter), 'idle' - hvem som har vrt stille lengst, 'talk' -"
  " flest skrevne linjer. Se 'syntax toplist' for en komplett liste",

  "nlPresenteert verscheidene toplijsten omtrent de huidge gasten. 'joins' - meest"
  " opgemerkte joins, 'joined' langste join (in minuten) 'idle' - meest"
  " stille gasten (in minuten), 'talk' - nummer geschreven lijnen tekst. Zie"
  " 'syntax toplist' voor een complete lijst",

  "frPrsentes les variantes toplists a propos des invits prsents. "
  " 'joins' - le plus de join enregistr, 'joined' le plus long join (en minutes)"
  " 'idle' - le client le plus silencieux (en minutes), 'talk' - le nombre"
  " de ligne cris. Voir 'syntax toplist' pour une liste complte",

  "deGibt verschiedene statistische Angebane zu den Benutzern aus, die sich"
  " gegenwrtig im Kanal befinden: 'joins' - die meisten registrierten Joins,"
  " 'joined' - die lngsten Joins (in Minuten), 'idle' - die am lngsten"
  " idelnden (nichts sagenden) Besucher (in Minuten), 'talk' - die Besucher"
  " mit den meisten geschriebenen Zeilen. Siehe 'syntax toplist' fr eine"
  " komplette Liste",

  "esLista informacion sobre los invitados actuales.'joins'- las entradas"
  " guardadas, 'joined'- la entrada que mas tiempo ha pasado en el canal,"
  " 'idle'- los usuarios mas callados (en minutos), 'talk'- numero de lineas"
  " escritas. tambien puedes mirar 'syntax toplist' para una lista"
  " completa",

  "fiNytt erilaisia top-listoja kanavalla olevista vieraista. 'joins' -"
  " eniten liittymisi kanavalle, 'joined' - kauimman aikaa (minuuteissa)"
  " kanavalle liittyneen ollut vieras, 'idle' - pisimmn aikaa hiljaa"
  " olleet vieraat, 'talk' - kirjoitettujen rivien lukumr. 'syntax"
  " toplist' antaa tydellisen listan kaikista optioista",

  NULL
};

char *msg_help_invite[] = {
  "enInvites you to the channel when used from outside of it",
  "daInviterer dig til en kanal hvis du befinder dig udenfor den",
  "svInbjuder dig till kanalen ifall du befinner dig utanfr den",
  "noInviterer deg til kanalen hvis du befinner deg utenfor den",
  "nlNodigt je uit (invite) voor het kanaal indien gebruikt van buiten het kanaal",
  "frT'invite sur le canal quand il est utilis  l'extrieur du canal",
  "deSorgt dafr, da der Bot den ausfhrenden Benutzer in den Kanal"
  " einldt (invite), wenn der Benutzer sich nicht im Kanal befindet",
  "esCuando lo usas desde fuera del canal te invita a este",
  "fiKutsuu sinut kanavalle sen ulkopuolelta kytettess",
  NULL
};

char *msg_help_op[] = {
  "enGrants channel operator status. If no <passwd> is supplied, you"
  " must have been authenticated before using OP. See PASS",

  "daGiver dig kanal operatr status. Hvis <passwd> ikke er med, skal du"
  " vre verificeret p forhnd. See PASS",

  "svGer dig kanaloperatrsstatus. Om <passwd> inte r med mste du vara"
  " verifierat innan mha PASS",

  "noGir deg kanaloperatrstatus. Hvis <passwd> ikke er med, m du vre"
  " godkjent allerede via PASS",

  "nlVerleent kanaal operator status. Indien geen <passwd> is gegeven, dien"
  " je je te authorizeren voordat je OP gebruikt. Zie PASS",

  "frDonne le status d'oprateur. Si y'a pas de <passwd> qui  t spcifi,"
  " Tu devrais t'avoir authentifi avant d'utiliser OP. Voir PASS",

  "deErteilt Operator Status. Wenn kein <passwd> angegeben wird, mu man sich"
  " vorher mit Pawort authentifiziert haben. Siehe PASS",

  "esTe proporciona estatus de operador en el canal. si no has introducido"
  " el password aun, debes de identificarte antes de usar OP.mira el"
  " comando PASS",

  "fiAntaa sinulle opit (+o) kanavalla. Ellei <passwd> argumenttia kytet,"
  " on sinun tytynyt todistaa henkilllisyytesi jo ennen OP komennon"
  " kytt. Katso PASS",

  NULL
};

char *msg_help_voice[] = {
  "enGives you voice. If no <passwd> is supplied, you must have been"
  " authenticated before using VOICE. See PASS",

  "daGiver dig kanal voice status. Hvis <passwd> ikke er med, skal du"
  " vre verificeret p forhnd. See PASS",

  "svGer dig kanalvoicestatus. Om <passwd> inte r med mste du vara"
  " verifierat innan mha PASS",

  "noGir deg kanalvoicestatus. Hvis <passwd> ikke er med, m du vre"
  " godkjent allerede via PASS",

  "nlVerleent kanaal voice status. Indien geen <passwd> is gegeven, dien"
  " je je te authorizeren voordat je VOICE gebruikt. Zie PASS",

  "frDonne le status d'voice. Si y'a pas de <passwd> qui  t spcifi,"
  " Tu devrais t'avoir authentifi avant d'utiliser VOICE. Voir PASS",

  "deErteilt Voice Status. Wenn kein <passwd> angegeben wird, mu man sich"
  " vorher mit Pawort authentifiziert haben. Siehe PASS",

  "fiAntaa sinulle nen (voice) kanavalla. Ellei <passwd> argumenttia"
  " kytet, on sinun tytynyt todistaa henkilllisyytesi jo ennen VOICE"
  " komennon kytt. Katso PASS",

  NULL
};

char *msg_help_devoice[] = {
  "enRemoves voice from you. If no <passwd> is supplied, you must have been"
  " authenticated before using DEVOICE. See PASS",

  "fiPoistaa sinulta nen (voice) kanavalla. Ellei <passwd> argumenttia"
  " kytet, on sinun tytynyt todistaa henkilllisyytesi jo ennen DEVOICE"
  " komennon kytt. Katso PASS",

  NULL
};

char *msg_help_userlist[] = {
  "enShows a list of all registered users (-V also shows all accounts). Use"
  " the flags to filter out the users you're interested in. Strings are"
  " written in standard pattern style (with ? and * support) and ranges are"
  " written like '<from number>-<to number>' where one or both of the numbers"
  " may be left out",

  "daViser en liste af alle registrede brugere (-V viser ogs alle deres"
  " konti). Brug flagene til at specificere hvilke brugere du er interesseret"
  " i. Tekst strenge kan indeholde wildcards (? og *) og intervaller angives"
  " ved '<fra nummer>-<til nummer>, hvor en eller begge numre kan udelades",

  "svVisar en lista med all registrerade anvndare (-V visar ocks alla deras"
  " konton). Anvnd flaggorna fr att filtrera ut de anvndare du vill se."
  " Strngar r i standard mnster-format (med ? och * std) och 'ranges'"
  " (dvs sekvenser) skrivs som '<frn nummer>-<till nummer>' dr ett eller"
  " bda numren kan utelmnas",

  "noViser ei liste over alle registrerte brukere (-V viser ogs alle deres"
  " konti). Bruk flaggene for  filtrere ut de brukerne du vil se. Strenger"
  " er i standard mnster-format (med sttte for ? og *), og intervaller angis"
  " med '<fra nummer>-<til nummer>', hvor et eller begge nummer kan utelates",

  "nlToont een lijst van alle geregistreerde gebruikers (-V toont ook alle accounts)."
  " Gebruik de flags om de users te selecteren waarin je geinteresseerd bent.  Strings zijn"
  " geschreven in de standaard pattern stijl (met ? en * support) en ranges zijn"
  " geschreven als '<van nummer>-<tot nummer>' waarbij een of beide nummers weggelaten"
  " kunnen worden",

  "frMontre la liste de tout les utilisateurs enregistr(-V montre tous les"
  " comptes). Utilise les flags pour filtrer les utilisateurs voulu. Les chanes"
  " sont crites en format standard (avec le support de * et ?) et le champ sont"
  " crits sous la forme '<du chiffre>-<au chiffre>' ou un ou les deux nombres"
  " peuvent tre laisser de ct",

  "deibt eine Liste aller registrierten Benutzer aus (-V zeigt auch alle"
  " Accounts). Mit den Flags kann die Augabe beliebig eingegrenzt werden."
  " Suchbegriffe knnen '?' und '*' enthalten. Suchbereiche werden in der"
  " Form '<von Nummer>-<bis Nummer>' angegeben, wobei eine oder beide"
  " Nummern weggelassen werden knnen",

  "esMuestra una lista de todos los usuarios registrados (-v ensea todas"
  " las cuentas de usuarios.Usa los flags para listar el usuario que te"
  " interesa.las reglas de busca son las standars (? y *),y (<numero>- a -<numero>)"
  " seran listados. cuando uno o dos de los numeros seran dejados de lado",

  "fiNytt listan rekisteridyist kyttjist (-V nytt mys kaikki"
  " osoite-maskit). Kyt eri optioita tulostaaksesi vain kiinnostuksen"
  " kohteena olevat kyttjt. Normaali maskityyli toimii (tuki '*' ja"
  " '?' jokereille) ja vaihteluvlit kirjoitetaan muodossa"
  " '<luvusta>-<lukuun>' jossa jompikumpi tai molemmat luvut voidaan"
  " jtt pois",

  NULL
};

char *msg_help_say[] = {
  "enMakes me speak the written words in public",
  "daFr mig til at sige det du beder om p kanalen",
  "svFr mig att sga det du ber mig om i kanalen",
  "noFr meg til  si det du ber meg om p kanalen",
  "nlMaakt mij de geschreven tekst spreken in het kanaal",
  "frMe fais dire le mot crit sur le canal",
  "deLt den Bot den bergebenen Text in dem Kanal 'sagen'",
  "esHace que hable lo que escribas en publico(en el canal)",
  "fiKskee minua puhumaan kirjoitettu rivi kanavalla",
  NULL
};

char *msg_help_me[] = {
  "enMakes me do an action (/me <something>)",
  "daFr mig til at udfre en handling (/me <noget>)",
  "svFr mig att utfra en handling (/me <ngonting>)",
  "noFr meg til  utfre en gandling (/me <noe>)",
  "nlLaat mij een actie doen (/me <iets>)",
  "frMe fait faire une action (/me <quelque chose>)",
  "deLt den Bot eine Aktion ausfhren (/me <irgendetwas>)",
  "esMe hace realizar una accion como (/me <haceralgo>)",
  "fiKskee minua tekemn toiminnon kanavalla (/me <tekee jotain>)",
  NULL
};

char *msg_help_talk[] = {
  "enMakes me talkative",
  "daGr mig snaksaglig",
  "svGr mig pratsam",
  "noGjr meg pratsom",
  "nlMaakt mij spreekvaardig",
  "frMe permet de parler",
  "deMacht den Bot redselig",
  "esMe hace hablar relativamente",
  "fiTekee minusta puheliaan",
  NULL
};

char *msg_help_quiet[] = {
  "enMakes me silent",
  "daGr mig stille",
  "svGr mig tyst",
  "noGjr meg stille",
  "nlMaakt mij stil",
  "frMe rend silencieux",
  "deLt den Bot verstummen",
  "esMe hace estar en silencio",
  "fiTekee minusta hiljaisen",
  NULL
};

char *msg_help_lag[] = {
  "enShows lag between me and my server",
  "daViser forsinkelsen mellem mig og min server",
  "svVisar frdrjningen mellan mig och min server",
  "noViser forsinkelsen mellom meg og min server",
  "nlToont de vertraging (lag) tussen mij en de server",
  "frMontre le lag entre moi et mon serveur",
  "deGibt die Verzgerung (lag) zwischen dem Bot und seinem IRC-Server aus",
  "esTe muestra el LAG que hay entre el servidor y yo",
  "fiNytt kuinka paljon minun ja serverin vlill on laggia",
  NULL
};

char *msg_help_reportadd[] = {
  "enReceive warnings about channel desync and fake mode changes",
  "daModtag forskellige advarsler",
  "svF meddelanden om kanal-desync, fejkande mode-ndringar och annat",
  "noF meldinger om kanal-desync, falske tilstandsendringer og annet",
  "nlOntvang waarschuwingen omtrent kanaal-desyncs en valse mode veranderingen",
  "frReois des avertissements a propos de la dsyncronisation du canal"
  " et les changements de modes immit",
  "deSchaltet den Empfang von Warnungen ber Kanal-Desychronisation und"
  " geflschte Modusnderungen ('desync' und 'fake mode changes') ein",
  "esRecibe avisos sobre los cambios de modo en desync y fake",
  "fiSaa minut lhettmn varoituksia kanavan desyncist ja fake moodeista",
  NULL
};

char *msg_help_reportdel[] = {
  "enStop receiving warnings (see HELP REPORTADD)",
  "daStop modtagelsen af forskellige advarsler",
  "svSluta ta emot report-meddlenaden",
  "noSlutt  ta imot advarsler",
  "nlStop het ontvangen van waarschuwingen (zie HELP REPORTADD)",
  "frArrte de recevoir des avertissements (voir HELP REPORTADD)",
  "deSchaltet den Empfang von Warnungen aus (siehe HELP REPORTADD)",
  "esPara de recibir avisos (mira tambien HELP REPORTADD)",
  "fiLopetan varoitusten lhettmisen (katso HELP REPORTADD)",
  NULL
};

char *msg_help_kicklist[] = {
  "enLists the latest kicks in the channel. Optionally matching the"
  " wildcard specified",

  "daViser en list over dem der senest er blevet sparket (kick) af kanalen."
  " Wildcard can benyttes til kun at vise en del af sparkene",

  "svVisar en lista ver de som senast blivit sparkade (kick) ur kanalen."
  " Wildcard kan utnyttjas fr att vlja ut en delmngd",

  "noViser ei liste over de som sist ble sparket (kick) av kanalen."
  " Jokere kan benyttes for  velge ut en del av dem",

  "nlToont de laatste kicks in het kanaal. Optioneel herkenning via de"
  " gespecificeerde wildcards",

  "frListe les derniers kicks du canal. Optionnellement gale le joker spcifi",

  "deGibt eine Liste der letzten Kicks im Kanal aus. Optional werden nur die"
  " auf die gegebenen Variablen passenden angezeigt",

  "esLista los ultimos pateados del canal.Tambien tiene la opcion de usar"
  " wildcards",

  "fiNytt listan jossa on kanavan viimeisimmt potkimiset."
  " Maskin avulla voi listaa rajoittaa halunsa mukaisesti",

  NULL
};

char *msg_help_join[] = {
  "enJoins a channel. If I already am on a channel, I leave this"
  " channel first",

  "daJoiner en kanal. Hvis jeg allerede er paa en kanal, s forlader jeg"
  " den frst",

  "svJoinar en kanal. Om jag redan r p en kanal kommer jag att lmna den"
  " frst",

  "noJoiner en kanal. Hvis jeg allerede er p en kanal, s forlater jeg"
  " den frst",

  "nlJoined een kanaal. Indien ik al op een kanaal ben, verlaat ik dit kanaal eerst",

  "frJoin un canal. Si je suis dj sur le canal, je quitte le canal avant de"
  " joindre le nouveau",

  "deLt den Bot einen Kanal betreten. Wenn sich der Bot bereits in dem"
  " Kanal befindet, verlt er ihn zunchst",

  "esEntra a un canal.Si estoy actualmente en el, primero me marcho del canal",

  "fiSaa minut liittymn kanavalle. Jos jo olen jollakin kanavalla, poistun"
  " kyseess olevalta kanavalta ensin",

  NULL
};

char *msg_help_leave[] = {
  "enMakes me leave the current channel",
  "daFr mig til at forlade kanalen",
  "svFr mig att lmna kanalen",
  "noFr meg til  forlate kanalen",
  "nlMaakt mij het huidige kanaal verlaten",
  "frMe fait quitter le canal ou je suis",
  "deLt den Bot den aktuellen Kanal verlassen",
  "esMe hace marcharme del canal actual",
  "fiSaa minut poistumaan tmn hetkiselt kanavaltani",
  NULL
};

char *msg_help_ban[] = {
  "enBans a person from the channel for the specified time. Preceed"
  " nick with '*' to make it a siteban. [time] is in the format"
  " [[<hours>:]<minutes>:]<seconds>. -E makes the ban get enforced,"
  " preserved by the bot. -K makes it kick all users in the channel"
  " that match the pattern. <nick> can also be a <nick>!<user>@<site>"
  " style pattern",

  "daBanlyser (ban) en person fra kanalen i en given tidsrum. Hvis du"
  " skriver '*' foran nick'et bliver det et siteban. [time] er i formattet"
  " [[<timer>:]<minutter>:]<sekunder>. -E laver et forceret (enforced) ban."
  " -K sparker alle brugere der matcher et bestemt mnster af kanalen."
  " <nick> kan ogs vre af typen <nick>!<user>@<site>",

  "svBannlyser (ban) en person frn kanalen under en viss tid. Om du skriver"
  " '*' fre ett nick s blir det en siteban. [time] r i formatet"
  " [[<timmar>:]<minuter>:]<sekunder>. -E gr en forcerad (enforced) ban."
  " -K sparkar ut alla anvndarna som matchar mnstret. <nick> kan ocks vara"
  " i formatet <nick>!<user>@<site>",

  "noBannlyser en person fra kanalen en viss tid. Hvis du skriver '*' foran nicket,"
  " s blir det et siteban. [time] er i formatet [[<timer>:]<minutter>:]<sekunder>."
  " -E gjr en tvunget (enforced) ban. -K sparker alle brukere som stemmer med"
  " mnsteret av kanalen. <nick> kan ogs vre av typen <nick>!<user>@<site>",

  "nlBanned een persoon van het kanaal voor de gespecificeerde tijd. Voor"
  " een siteban, specificeer '*' voor de nick. [time] is in het formaat"
  " [[<uren>:]<minuten>:]<seconden>. -E maakt de ban geforceerd,"
  " bewaard door de bot. -K kicked alle personen in het kanaal"
  " die aan het pattern voldoen. <nick> kan ook als <nick>!<user>@<site>"
  " pattern gebruikt worden",

  "frBanni une personne du canal pour une priode dterminer. Prcdez le nick"
  " de '*' pour faire un ban du site. [time] est dans le format"
  " [[<hours>:]<minutes>:]<seconds>. -E fait enforcer le ban, prserver dans "
  " le bot. -K kick tout le monde dans le canal qui ont le pattern spcifi"
  " <nick> peut aussi tre sous la forme <nick>!<user>@<site>",

  "deVerbannt (banned) eine Person fr die angegebene Zeit vom Kanal. Durch"
  " ein dem Nick vorangestelltes '*' setzt der Bot einen Siteban. [time] ist"
  " im der Form [[<Stunden>:]<Minuten>:]<Sekunden> anzugeben. -E setzt den"
  " Ban durch (enforced). -K kickt alle Benutzer in Kanal, deren Hostmaske"
  " dem Ban entspricht. <nick> kann auch als <nick>!<user>@<site> angegeben"
  " werden",

  "esBanea una persona del canal por el tiempo especificado.en lugar del"
  " nick pon * para hacer que sea un ban del site entero (*@*.arrakis.es)"
  " [time] se escribe de la forma [[<horas>:]<minutos>:]<segundos>."
  " -E fuerza el ban preserva los del bot, -K tira a todo el mundo del canal"
  " que coincidan con el patron introducido <nick> tambien puese ser un patron"
  " de forma <nick>!<usuario>@<site>",

  "fiBannaa henkiln kanavalta mrtyksi ajaksi. Edell nikki '*' merkill"
  " jos haluat sitebannin. <nick> voi olla mys <nikki>!<kyttj>@<osoite>"
  " tyylinen maski. [time] on formaatissa"
  " [[<tunnit>:]<minuutit>:]<sekunnit>. -E tekee bannista valvotun, jolloin"
  " botti pyrkii pitmn bannin pll mahdollisuuksien mukaisesti. -K"
  " potkaisee ulos kaikki vieraat jotka vastaavat banmaskia",

  NULL
};

char *msg_help_unban[] = {
  "enRemoves a ban. BANLIST lists the bans",
  "daFjerner et ban igen. BANLIST viser alle bans",
  "svTar bort en bannlysning. BANLIST visar alla bannlysningar",
  "noFjerner en bannlysning. BANLIST viser alle bannlysninger",
  "nlVerwijdert de ban. BANLIST toont de bans",
  "frEnlves en ban. BANLIST liste tout les bans",
  "de Entfernt einen Ban. BANLIST gibt eine Liste aller gesetzten Bans aus",
  "esRemueve un ban. BANLIST lista los bans actuales del canal",
  "fiPoistaa bannin. BANLIST nytt listan banneista",
  NULL
};

char *msg_help_banlist[] = {
  "enLists the bans. With the argument -A, it will list more details."
  " -U includes the lastest unbans. If a match (wildcard) is specified"
  ", only than ban is displayed",

  "daViser alle bans. -A viser flere detaljer. -U inkluderer de seneste"
  " fjernede bans. Hvis der bruges wildcard vil kun de bans som matcher"
  " blive vist",

  "svVisar alla bans. -A visar mer detaljer. -U inkluderar de senast"
  " utfrda unbans. Om en match (wildcard) r specifierad visas bara de"
  " som matchar",

  "noViser alle bans. -A viser mer detaljer. -U inkluderer de sist"
  " fjernede bans. Hvis det brukes jokere vil kun de bans som matcher"
  " bli vist",

  "nlToont de bans. Met het argument -A toont het alle details,"
  " -U toont ook de laatste unbans. Indien een herkenning (wildcard) is specificeerd"
  ", wordt alleen betreffende ban getoond",

  "frlistes les bans. Avec l'arguments -A, donne plus de dtails."
  " -U inclus les derniers unban. Si une galit (joker) est spcifi,"
  " seulement ce ban est montrer",

  "deGibt eine Liste aller gesetzten Bans aus. -A erzwingt eine detaillierte"
  " Ausgabe. -U zeigt die letzten aufgehobenen Bans mit an. Die Ausgabe kann"
  " durch die Angabe eines Suchstrings (mit Platzhaltern) eingegrenzt"
  " werden",

  "esLista los bans. con el argumento -A, listara con mas detalle."
  " con -U incluye los ultimos bans. tambien puedes buscar por medio"
  " de wildcards para que sea mostrado solo el ban que buscas",

  "fiNytt listan banneista. -A antaa yksityiskohtaisempaa"
  " tietoa. -U sisllytt mukaan viimeisimmt unbannit. Voit rajoittaa"
  " listan pituutta kyttmll maskia [match] argumenttina",

  NULL
};

char *msg_help_chban[] = {
  "enChange the characteristics of a ban. To make"
  " the ban permanent, set <new time> to 0. The flag -E makes the ban"
  " an enforced one, and -U removes an enforced one. -R makes the"
  " following text used as new banreason. Ex: CHBAN -E 36 makes ban-id"
  " 36 enforced",

  "dandrer et bans karakteristika. St <new time> til 0 for at gre det"
  " permanent. -E forcerer et ban, og -U fjerner en forcering. -R ndrer"
  " medflgende ban besked. F.eks. CHBAN -E 35 laver ban-id 36 om til et"
  " forceret ban",

  "svndrar karaktren av en ban. Stt <new time> till 0 fr att gra den"
  " permanent. -E forcerar en ban och -U tar bort enforced status. -R gr"
  " den fljande texten till ny ban-anledning. Ex: CHBAN -E 36 gr om ban-id"
  " 36 till enforced",

  "noEndrer karakteristikker p et ban. Sett <new time> til 0 for  gjre"
  " den permanent. -E tvinger et ban, og -U tar bort tvungen status. -R"
  " endrer medflgende beskjed til en ny grunn. Eks.: CHBAN -E 36 gjr om"
  " ban-id 36 til enforced",

  "nlVerandert de karakteristieken van een ban. Om de ban permanent te maken,"
  " zet <new time> op 0. De flag -E maakt de ban geforceerd,"
  " en -U verwijdert een geforceerde ban. -R maakt de daarop volgende tekst als nieuwe"
  " banreden. Bijv.: CHBAN -E 36 maakt ban-nr. 36 geforceerd",

  "frChange les caractristiques d'un ban. Pour le rendre permanent, set <newtime>"
  "  0. Le flag -E enforce le ban, -U enlve un ban renforc. -R pour donner"
  " une raison au ban. EX: CHBAN -E 36 rends le ban avec l'ID 36 enforc",

  "deVerndert die Charakteristika eines Bans. Um den Ban permanent zu"
  " machen, mu <new time> auf 0 gesetzt werden. -E setzt den Ban durch"
  " (enforced), -U entfernt einen durchgesetzten Ban. -R setzt den"
  " nachfolgenden Text als Grund fr den Ban. Beispiel: CHBAN -E 36 setzt"
  " den Ban mit der ID 36 durch",

  "esCambia las caracteristicas de un Ban.Para hacer un ban permanente"
  " pon <new time> a 0,El flag -E hace un ban a la fuerza"
  " y -U borra uno echo a la fuerza, -R hace que el texto siguiente sea explicacion"
  " del ban por ejemplo: CHBAN -E 36 hace el ban-id"
  " 36 a la fuerza",

  "fiMuuttaa bannin ominaisuuksia. Asettamalla <new time> arvoon 0 saa"
  " bannista tehty pysyvn. -E tekee bannista valvotun, -U tekee bannista"
  " ei-valvotun. -R asettaa sit seuraavan tekstin bannin uudeksi ban-syyksi."
  " Esim. 'CHBAN -E 36' tekee bannista 36 valvotun",

  NULL
};

char *msg_help_vrfy[] = {
  "enVerifies an email address. Consult the man-page on 'vrfy' for further info",
  "daVerificerer en email adresse. Se man-siderne om 'vrfy' for yderligere"
  " oplysninger",
  "svVerifierar en emailadress. Se mansidorna om 'vrfy' fr ytterligare"
  " information",
  "noVerifiserer email-adresse. Se mansidene om vrfy for ytterligere"
  " informasjon",
  "nlVerifieert een email adres. Raadpleeg de man-pagina met betrekking tot 'vrfy'"
  " voor meer informatie",
  "frVrifie une adresse email. Consulter les pages-man pour 'vrfy' pour plus"
  " d'informations",
  "deVerifiziert eine Email-Adresse. Weiteres in der Manpage zu 'vrfy' ('man"
  " vrfy' in der UNIX-Shell)",
  "esVeerifica una direccion de email. consulta las paginas man sobre 'vrfy'"
  " para mas informacion, si no tienes UNIX ya sabes.. a rascarse",
  "fiVarmistaa email osoitteen oikeellisuuden. 'man vrfy' (Unix komento)"
  " antaa listietoa",
  NULL
};

char *msg_help_host[] = {
  "enLooks up <host>. May be either name (myhost.mydomain.com) or IP"
  " nummeric (127.0.0.1) Consult the man-pages for further info",

  "daLaver et DNS opslag paa <host>. Det kan enten vre et navn"
  " (myhost.mydomain.com) eller et IP nummer (127.0.0.1). Se"
  " man-siderne om 'host' for yderligere oplysninger",

  "svGr en DNS-uppslagning av <host>. Kan vara ett namn (myhost.mydomain.com"
  ") eller IP-nummer (127.0.0.1). Se mansidorna om 'host' fr mer info",

  "noGjr et DNS oppslag p <host>. Det kan enten vre et navn"
  " (myhost.mydomain.com) eller et IP-nummer (127.0.0.1). Se mansidene"
  " om 'host' for ytterligere opplysninger",

  "nlZoekt <host> op. Kan ofwel een naam zijn (myhost.mydomain.com) of een numerieke IP"
  " (127.0.0.1) Raadplaag de man-paginas voor meer informatie",

  "frRegarde <host>. Peut-tre sois un nom (monhost.mondomaine.com) ou une"
  " adresse numrique (127.0.0.1). Consulter les pages-man pour plus d'info",

  "deSucht <host> heraus. Kann entweder als Name (meinhost.meinedomne.de)"
  " oder als numerische IP (127.0.0.1) angegeben werden. Weiteres in den"
  " Man-Pages zu 'host' ('man host' in der UNIX-Shell)",

  "esMira el <host>. por su nombre (mihost.midominio.mx) o por IP"
  " numerico (127.0.0.1) consulta tus paginas man de unix",

  "fiTiedustelee osoitteen <host>. Osoite voi olla joko nimi"
  " (joku.osoite.fi) tai numeerinen IP (127.0.0.1). 'man host' (Unix komento)"
  " antaa listietoa",

  NULL
};

char *msg_help_finger[] = {
  "enDisplays local information about a user. Consult the man-pages"
  " on 'finger' for further info",

  "daViser lokale oplysninger om en bruger. Se man-siderne om 'finger'"
  " for yderligere oplysninger",

  "svVisar lokal information om en anvndare. Se mansidorna om 'finger'"
  " fr ytterligare upplysningar",

  "noViser lokale opplysninger om en bruker. Se mansidene om 'finger'"
  " for ytterligere opplysninger",

  "nlToont locale informatie omtrent een gebruiker. Raadpleeg de man-paginas"
  " met betrekking tot 'finger' voor meer informatie",

  "frMontre l'information local a propos d'un utilisateur. Consultez"
  " les pages-man 'finger' pour plus d'informations",

  "deGibt lokale Informationen ber einen Benutzer aus. Weiteres in den"
  " Man-Pages zu 'finger' ('man finger' in der UNIX-Shell)",

  "esMuestra informacion local sobre un usuario. mira las paginas man"
  " en UNIX para mas informacion",

  "fiNytt paikallista tietoa kyttjst. 'man finger' (Unix komento)"
  " antaa listietoa",

  NULL
};

char *msg_help_status[] = {
  "enReturns various information. -A also shows settings",
  "daReturnerer forskellige oplysninger. -A viser ogs alle indstillinger",
  "svVisar diverse information. -A visar ocks alla instllningar",
  "noViser diverse informasjon. -A viser ogs alle innstillinger",
  "nlGeeft diverse informatie. -A toont alle instelling",
  "frRetourne des informations diverses. -A montre aussi les prfrences",
  "deGibt diverse Informationen aus. -A zeigt auch Einstellungen an",
  "esMuestra alguna informacion. -A aparte muestra algunos estados"
  " en la configuracion",
  "fiPalauttaa monenlaista informaatiota botin tilasta. -A nytt mys"
  " asetukset",
  NULL
};

char *msg_help_cmode[] = {
  "enSets the channel modes",
  "daStter kanalens tilstande (modes)",
  "svStter kanalens tillstnd (mode)",
  "noSetter kanalens tilstand (mode)",
  "nlZet de kanaal modes",
  "frFixe les modes du canal",
  "de Setzt die Kanal-Modi (channel modes)",
  "esPone los modos del canal",
  "fiAsettaa kanavan moodit",
  NULL
};

char *msg_help_ckey[] = {
  "enSets the channel key (channel password). Use '-' to reset to no key",
  "daStter kanalens ngleord. Brug '-' for at fjerne nglen",
  "svStter kanalens lsenord (key). Anvnd '-' fr att ta bort lsenordet",
  "noSetter kanalens passord (key). Bruk '-' for  fjerne det",
  "nlZet de kanaal sleutel (key/kanaal wachtwoord). Gebruik '-' voor verwijdering van een sleutel",
  "frFixe la cl du canal( mot de passe du canal). Utilisez '-' pour ne pas en avoir",
  "deSetzt das Kanalpawort (channel key). '-' lscht ein vorhandenes Pawort",
  "esPone el Key en el canal (osea un codigo para entrar). usa '-' para borrarlo",
  "fiAsettaa kanavan avaimen (salasana joka vaaditaan jotta kanavalle voi"
  " liitty). '-' poistaa avaimen",
  NULL
};

char *msg_help_nick[] = {
  "enChanges my nickname. '+' selects a new nick according"
  " to the internal nickmask",

  "dandrer mig nicknavn. '+' vlger det nste i rkken af dens interne"
  " liste",

  "svndrar mitt nick. '+' vljer nsta alternativ i den interna listan",

  "noEndrer mitt nick. '+' velger neste alternativ i den interne lista",

  "nlVerandert mijn nicknaam. '+' zet de nieuwe tot een nick zoals die is gespecificeerd"
  " in de interne lijst",

  "frChange mon nick. '+' choisi un nouveau nick selon  la liste interne",

  "dendert den Nick des Bots. '+' whlt den nchsten Nick entsprechend der"
  " internen Nickliste des Bots",

  "esCambia mi nick. '+' selecciona un nuevo nick deacuerdo con la mascara interna",

  "fiVaihtaa nikkini. '+' valitsee uuden nikin sisisest nikkilistasta",

  NULL
};

char *msg_help_set[] = {
  "enChanges a lot of settings. HELP SET <label> for further help."
  " Use STATUS to view current setup",

  "dandrer p forskellige indstillinger. HELP SET <label> for yderligere"
  " hjlp. Brug STATUS til at se de nuvrende indstillinger",

  "svndrar instllningar. HELP SET <instllning> visar mer hjlp. Prova"
  " STATUS fr att se nuvarande instllningar",

  "noEndrer mange innstillinger. HELP SET <innstilling> viser mere hjelp."
  " Prv STATUS for  se nvrende innstillinger",

  "nlVerandert verscheidene instellingen. HELP SET <label> voor meer informatie."
  " Gebruik STATUS om de huidige installingen te tonen",

  "frChanges beaucoup de prfrences. HELP SET <label> pour plus d'info."
  " Utilisez STATUS pour voir le prfrences actuelles",

  "dendert eine Reihe von Einstellungen. Mit HELP SET <label> bekommt man"
  " entsprechend weiter Hilfe. STATUS gibt die aktuellen Einstellungen aus",

  "esCambia muchos estados del bot. HELP SET <nombre> para mas informacion."
  " Usa STATUS para ver tu estado actual",

  "fiNytt tai muuttaa useita eri asetuksia. 'HELP SET <label>' antaa apua"
  " jokaiseen yksittiseen asetukseen. 'SET' ilman argumentteja nytt"
  " nykyiset asetukset",

  NULL
};

char *msg_help_mute[] = {
  "enTells me to be absolutely quiet",
  "daGiver mig besked p at vre helt stille",
  "svGr mig helt tyst",
  "noGjr meg helt stille",
  "nlVertelt mij om absoluut stil te zijn",
  "frMe demande d'tre parfaitement muets",
  "deLt den Bot absolut ruhig sein",
  "esMe dice que este absolutamente calladito :)",
  "fiSaa minut tysin hiljaisesti",
  NULL
};

char *msg_help_warnlist[] = {
  "enLists the host patterns defined as belonging to really stupid"
  " or annoying people. Specify [match] to view the warns that match"
  " the wildcard. -A shows more details. -B shows ban-warnings only",

  "daViser listen af advarsler om dumme og irriterende personer. Brug"
  " [match] til kun at vise dem der matcher et mnster. -A viser flere"
  " detaljer. -B viser kun de advarsler der udlser et ban",

  "svVisar listan ver personer som r dumma och irriterande. Anvnd"
  " [match] fr att sortera ut enligt ett mnster. -A visar fler detaljer."
  " -B visar enbart mnster som orsakar bannlysning",

  "noViser lista over dumme og irriterende personer. Bruk [match] for"
  "  sortere ut etter et mnster. -A viser flere detaljer. -B viser kun"
  " mnster som utlser bannlysning",

  "nlToont de host patterns zoals die gespecificeerd zijn voor zeer stomme"
  " of irritante mensen. Specifeer [kenmerk] om de waarschuwingen te tonen die"
  " de wildcard matchen. -A toont meer details. -B toont alleen ban-waarschuwingen",

  "frListe le host modle dfini comme appartenant a une personne vraiment"
  " tannante ou stupide. Spcifiez [match] pour voir les avertissements"
  " affects  ce joker. -A montre plus de dtails. -B montre seulement les "
  " avertissement-ban",

  "deGibt eine liste aller Hostmasks aus, die besonders dummen oder nervigen"
  " Personen zugeordnet wurden. Bei Angabe von [match] werden alle auf den"
  " Suchstring zutreffenden Warnmeldungen ausgegeben. -A erzwingt eine"
  " detaillierte Liste. -B zeigt nur Ban-Warnungen an",

  "esLista los patrones de gente cantidad de gilipollas"
  " o simplemente gente indeseada.Especifica [match] para"
  " para ver los patrones que coinciden con los wildcard."
  " -A muestra mas detalles. -B muestra solo avisos de Ban",

  "fiNytt listan niist osoitemaskeista jotka on mritelty kuuluviksi"
  " erittin typerille tai rsyttville ihmisille. Mrittele [match]"
  " jos haluat rajoittaa listan pituutta sopivan maskin avulla. -A nytt"
  " yksityiskohtaisempaa tietoa. -B nytt vain bannattavat maskit",

  NULL
};

char *msg_help_warnadd[] = {
  "enAdd the nick's pattern (or regular *!*@* pattern) and description"
  " to the warnlist. Preceed nick with '*' to make it a sitepattern."
  " -B will make any user matching the pattern get kickbanned on join",

  "daTilfj en persons mnster (eller et <nick>!<user>@<site> mnster)"
  " og en beskrivelse til warn-listen. Hvis <nick> starter med '*'"
  " laves det til et site-mnster. -B medfrer at personen der matcher"
  " mnstret automatisk bliver sparket og bannet",

  "svLgg till en persons mnster (eller vanligt <nick>!<user>@<site> mnster)"
  " och en beskrivning i varningslistan. Om <nick> brjar med '*'"
  " lggs det till ett site-mnster. -B gr att personen som matchar"
  " mnstret automatiskt blir utsparkad och bannlyst vid 'join'",

  "noLegg til en persons mnster (eller vanlig <nick>!<user>@<site> mnster)"
  " og en beskrivelse i advarselslista. Hvis <nick> begynner med '*'"
  " legges det til et site-mnster. -B gjr at personen som matcher mnsteret"
  " automatisk blir sparket ut og bannlyst ved 'join'",

  "nlVoegt de nick's pattern (of een reguliere *!*@* pattern) en omschrijving"
  " toe aan de waarschuwingslijst. Voor een sitepattern, specifeer '*' voor de nick."
  " -B laat alle gebruikers overeenkomstig met het pattern kickbannen wanneer zij joinen",

  "frAjoute le modle du nick (ou le modle *!*@*) et une decription sur "
  " la liste des avertissements. Prcder le nick de '*' pour le rendre"
  " un modle de ban de site. -B vas kick/ban tout les utilisateurs qui"
  " ont le modles lors du join",

  "deFgt die Hostmask des angegebenen Nocks (oder eine beliebige Hostmask"
  " der Form *!*@*) und eine entsprechende Bemerkung in die Warnliste ein."
  " Wird dem Nick ein * vorangestellt, setzt der Bot die Warnmeldung fr die"
  " ganze Site. -B kicktbanned jeden Benutzer, auf den die Hostmask pat,"
  " sobald er den Kanal betritt",

  "esAade el patron del nick (o regularmente el patron *!*@* ) y descripcion"
  " a la warnlist. Procede con '*' pora hacer un patron de todo un site."
  " -B hara que cualquier usuario que coincida con el patron sea pateado y baneado"
  " al entrar al canal",

  "fiLis nikin <nick> osoitemaskin (tai tavallisen *!*@* maskin) kuvauksen"
  " kera varoituslistaan. Edell <nick> '*' merkill jos haluat sitemaskin."
  " -B option avulla saat jokaisen maskia vastaavan vieraan"
  " ban-potkaistuksi heidn liittyessn kanavalle",

  NULL
};

char *msg_help_warndel[] = {
  "enRemoves a person from the warnlist",
  "daFjerner en person eller mnster fra warn-listen",
  "svRaderar ett mnster frn varningslistan",
  "noFjerner et mnster fra advarselslista",
  "nlVerwijdert een persoon van de waarschuwingslijst",
  "frEnlves une personne de la liste d'avertissement",
  "deEntfernt einen Eintrag aus der Warnliste",
  "esBorra a un usuario de la warnlist",
  "fiPoistaa henkiln varoituslistalta",
  NULL
};

char *msg_help_clientlist[] = {
  "enShows a list of all current /dcc chat client",
  "daViser en liste over alle nuvrende /dcc chat klienter",
  "svVisar en lista ver alla /dcc chat klienter",
  "noViser ei liste over alle /dcc char klienter",
  "nlToont een lijst met alle huidige /dcc chat clients",
  "frMontre la liste de ceux qui sont en /dcc chat avec moi",
  "deGibt eine Liste aller aktiven /dcc chat Verbindungen aus",
  "esMuestra una lista de todos los DCC chat activados",
  "fiNytt listan tmnhetkisist /DCC chateista",
  NULL
};

char *msg_help_do[] = {
  "enMakes me execute a raw IRC command",
  "daFr mig til at udfre en r IRC kommando",
  "svFr mig att exekvera ett rtt IRC kommando",
  "noFr meg til  utfre en r IRC kommando",
  "nlLaat mij een raw IRC kommando uitvoeren",
  "frMe fais executer une commande IRC raw",
  "deLt den Bot einen IRC-Befehl (raw IRC command) ausfhren",
  "esMe hace ejecutar un comando nativo de IRC",
  "fiKskee minua suorittamaan kyseisen (raw) IRC komennon",
  NULL
};

char *msg_help_backlog[] = {
  "enShows the last X commands entered by users. X is 5 if not specified",
  "daViser de sidste X udfrte kommandoer. X er 5 hvis intet er specificeret",
  "svVisar de X senaste kommandon anvndare angett. X r 5 om inte annat"
  " anges",
  "noViser de X siste kommandoene brukere har gitt. X er 5 hvis ikke annet"
  " angis",
  "nlToont de laatste X kommandos die door users gestuurd zijn. X is 5 indien niet gespecificeerd",
  "frMontre la dernire commande X utiliser par un utilisateur. X est 5 si "
  " pas spcifi",
  "deGibt eine Liste der letzten X von Benutzern ausgefhrten Kommandos aus."
  " Standard fr X ist 5",
  "esMuestra los ultimos X comandos usados por los usuarios"
  " si X no es especificado muestra 5",
  "fiNytt X viimeksi kytetty komentoa. X on 5 ellei toisin mritelty",
  NULL
};


char *msg_help_expadd[] = {
  "enAdds an entry to the explanation file",
  "daTilfjer en forklaring til EXPLAIN systemet",
  "svLgger till en frklaring till EXPLAIN-systemet",
  "noLegger til ny forklaring i EXPLAIN-systemet",
  "nlVoegt een verklaring toe aan het EXPLAIN bestand",
  "frRajoute une entre dans la liste des explications",
  "deFgt einen Eintrag in die Erklrungsliste ein",
  "esAade una entrada a la lista de Explicaciones",
  "fiLis uuden selityksen EXPLAIN systeemiin",
  NULL
};

char *msg_help_defpass[] = {
  "enReinstall default password for the forgetful soul. Current"
  " default is '%s'",
  "daGeninstaller default password for dem der glemmer det. Nuvrende"
  " default er '%s'",
  "svterstller default password till ngon som glmt sitt. Nuvarande"
  " default r '%s'",
  "noGjeninstallerer default passord for noen som har glemt sitt."
  " Nvrende default er '%s'",
  "nlHerinstalleerd het default wachtwoord voor een vergeetachtige ziel. Huidige"
  " default is '%s'",
  "frRinstall le mot de passe par dfault pour les tites tte. Le mot de passe"
  " par dfaut est '%s'",
  "deSetzt das Pawort fr die vergelichen Seelen auf den Standardwert zurck."
  " Aktueller Standard ist '%s'",
  "esReistala el password por defecto para los que pierden hasta la cabeza!"
  " ahora mismo el pass por defecto es '%s'",
  "fiAsettaa kyttjn salasanan oletusarvoiseksi mikli kyttj on pssyt"
  " unohtamaan salasanansa. Oletusarvoinen salasana on '%s'",
  NULL
};

char *msg_help_spyadd[] = {
  "enSnoop on commands",
  "daSpioner p kommandoer",
  "svSpionera p kommandon",
  "noSpioner p kommandoer",
  "nlSpiek op kommandos",
  "frEspionne sur les commandes",
  "deberwacht den Kanal nach Kommandos",
  "esEspia los comandos que ponen los demas usuarios",
  "fiVakoile kyttjien suorittamia komentoja",
  NULL
};

char *msg_help_spydel[] = {
  "enStop snooping on commands",
  "daStop udspionering af kommandoer",
  "svSluta spionera p kommandon",
  "noSlutt  spionere p kommandoer",
  "nlStop spieken op kommandos",
  "frArrte l'espionnage sur les commandes",
  "deStop die Kanalberwachung nach Kommandos",
  "esPara de espiar comandos de los demas usuarios",
  "fiLopettaa komentojen vakoilun",
  NULL
};

char *msg_help_debugadd[] = {
  "enReceive debugging information",
  "daModtag debugging informationer",
  "svTa emot debuginformation",
  "noTa imot debuginformasjon",
  "nlOntvang debug informatie",
  "frReois des informations de dboguage",
  "deZeigt Debug-Informationen an",
  "esRecibe informacion debug",
  "fiVastaanota debuggaus tietoa",
  NULL
};

char *msg_help_debugdel[] = {
  "enDon't receive debugging information",
  "daStop modtagelsen af debugging informationer",
  "svSluta ta emot debuginformation",
  "noSlutt  ta imot debuginformasjon",
  "nlOntvang geen debug informatie",
  "frNe reois pas d'informations de dboguage",
  "deSchaltet die Anzeige von Debug-Informationen aus",
  "esNo recibe mas informacion de debug",
  "fiLopettaa debuggaus tietojen lhetyksen",
  NULL
};

char *msg_help_reload[] = {
  "enReloads various files, including the userfile",
  "daGenindls forskellige filer, inklusiv brugerfilen",
  "svLaddar in diverse filer p nytt inklusive anvndarfilen",
  "noLeser inn diverse filer p nytt, inklusive brukerfilen",
  "nlHerlaad verschillende files, inclusief de userfile",
  "frRecharge diffrents fichiers, mme le fichier utilisateur",
  "deLdt diverse Dateien erneut, zum Beispiel die Benutzerdatei",
  "esRecarga varios ficheros,incluido el fichero de usuarios",
  "fiLataa useita tiedostoja uudelleen, mys kyttjtiedoston",
  NULL
};

char *msg_help_wall[] = {
  "enSends <msg> to all connected clients",
  "daSender <msg> til alle forbundne klienter",
  "svSkickar <msg> till alla anslutna klienter",
  "noSender <msg> til alle forbundne klienter",
  "nlStuurt <msg> naar alle aangesloten clients",
  "frEnvoies <msg>  tout les clients connects",
  "deSendet <msg> an alle verbundenen Clients",
  "esManda <msg> a todos los usuarios conectados",
  "fiLhett viestin <msg> kaikille jotka ovat DCC chat yhteydess kanssani",
  NULL
};

char *msg_help_shutdown[] = {
  "enBroadcasts <reason> to all clients. Waits <time> before quitting."
  " <time> is in format [[<hours>:]<minutes>:]<seconds>. -C cancels"
  " the shutdown. No time specifed means 10 seconds",

  "daBroadcaster <reason> til alle forbundne klienter. Venter <time> fr"
  " den lukker ned. <time> er i formattet [[<timer>:]<minutter>:]<sekunder>."
  " -C afbryder nedlukningen. Hvis ingen tid angives bruges 10 sekunder",

  "svBroadcastar <reason> till alla anslutna klienter. Vntar <time> innan"
  " den avslutar. <time> r i formatet [[<timmar>:]<minuter>:]<sekunder>. -C"
  " avbryter en shutdown. Ingen tid angiven betyder 10 sekunder",

  "noKringkaster <reason> til alle forbundne klienter. Venter <time> fr"
  " den avslutter. <time> er i formatet [[<timer>:]<minutter>:]<sekunder>."
  " -C avbryter nedlukningen. Hvis ingen tid angis, brukes 10 sekunder",

  "nlVerstuurt <reason> naar alle clients. Wacht <time> alvorens te stoppen."
  " <time> is in het formaat [[<uren>:]<minuten>:]<seconden>. -C annuleert"
  " het stopzetten. Geen tijd gespecificeerd betekent 10 seconden",

  "frEnvoyes a tout les clients <reason>. Attends <time> avant de quitter."
  " <time> dans le format [[<hours>:]<minutes>:]<secondes>. -C cancle"
  " le shutdown. Si y'a pas de temps de dtermin je vais attendre 10 secondes",

  "deSendet <reason> an alle Clients. Wartet <time> vor dem Herunterfahren."
  " <time> ist im Format [[<Stunden>:]<Minuten>:]<Sekunden>. -C bricht das"
  " Herunterfahren ab. Standardeintrag fr <time> ist 10 Sekunden",

  "esEmite <reason> a todos los clientes.Espera <time> antes de marcharse."
  " <time> esta en formato [[<horas>:]<minutos>:]<segundos>. -C cancela"
  " el proceso de marcharse.Sin especificar tiempo usara el tiempo por"
  " defecto de 10 segundos",

  "fiBotin alasajo. Lhett viestin <reason> kaikille jotka ovat DCC chat"
  " yhteydess kanssani. Odottaa ajan <time> ennen lopetusta. <time> on"
  " formaatissa [[<tunnit>:]<minuutit>:]<sekunnit>. -C peruuttaa alasajon."
  " Ellei aikaa mritell on se oletusarvoisesti 10 sekuntia",

  NULL
};

char *msg_help_quit[] = {
  "enKills me immediately",
  "daDrber mig med det samme",
  "svAvslutar mig omedelbart",
  "noPensjonerer meg umiddelbart",
  "nlStopt mij onmiddellijk",
  "frMe fait quitter immdiatement",
  "deBeendet den Bot unverzglich",
  "esMe mata inmediatamente",
  "fiLopettaa minut vlittmsti (alasajo)",
  NULL
};

char *msg_help_server[] = {
  "enChanges to a new server. Make sure in advance that the new server"
  " allows bots, by reading the message-of-the-day (/motd <server>)."
  " Using '+' as argument will make it select the next server from the"
  " list, and <id> can be used to select a server list item",

  "daSkifter til en ny server. Forsikre dig p forhnd at den nye server"
  " tillader botter, ved at lse dens message-of-the-day (/motd <server>)."
  " Hvis servernavnet er '+', vlges den nste server i den interne liste."
  " <id> kan bruges til at vlge en bestemt server i denne liste",

  "svByter till en ny server. Se till i frvg att servern tillter bottar,"
  " genom att lsa serverns message-of-the-day (/motd <server>)."
  " Anvnd '+' som parameter fr att byta till nsta server i listan. <id>"
  " kan anvndas fr att vlja en specifik server frn listan",

  "noBytter til en ny server. Forsikre deg p forhnd om at den nye serveren"
  " tillater bots ved  lese message-of-the-day (/motd <server>)."
  " Hvis servernavnet er '+', velges den neste serveren i den interne lista."
  " <id> kan brukes til  velge en bestemt server fra lista",

  "nlMaakt mij naar een nieuwe server connecten. Wees er zeker van dat de nieuwe server bots"
  " toestaat, door het lezen van de message-of-the-day (/motd <server>)."
  " Door middel van '+' als argument zal de bot de volgende server van de lijst"
  " selecteren, en <id> kan gebruikt worden om een sever van de lijst te kiezen",

  "frMe fais changer de serveur. S'assurer que ce serveur accepte les bots,"
  " lire le message-de-la-journe </motd <server>). En utilisant l'argument"
  " '+' je vais me connecter sur le prochain serveur dans ma liste, et <id>"
  " peut-tre utilis pour choisir un serveur",

  "deWechselt auf einen neuen Server. Zuvor sollte sichergestellt werden, da"
  " Bots auf dem neuen Server gestattet sind. Diese Information kann"
  " normalerweise der Nachricht des Tages (Message-of-the-day, /motd server)"
  " entnommen werden. Der Parameter + lt den Bot zum nchsten Server der"
  " internen Liste wechseln, und ber <id> kann ein bestimmter Server aus"
  " der Liste ausgewhlt werden",

  "esCambia de servidor. Estate seguro de que el nuevo servidor acepta"
  " bots, leyendo el msg del dia (/motd servidor). Usando '+'"
  " como argumento hace que el bot salte al proximo servidor de la lista"
  " y <id> se puede usar para elegir un servidor predertemidado de la"
  " lista",

  "fiSaa minut vaihtamaan serveri. Varmista etukteen ett uusi serveri"
  " sallii botit lukemalla serverin motd (/motd <serveri>). '+' valitsee"
  " seuraavan serverin serverilistalta. Numerolla <id> voit valita"
  " jonkin yksittisen serverilistan serverin",

  NULL
};

char *msg_help_names[] = {
  "enLists all guests in the channel whose account matches the optionally"
  " specified wildcard. XXX in the level field means the user has your"
  " or higher level",

  "daViser alle gster p kanalen. Der kan ogs bruges wildcard. XXX i"
  " niveau feltet betyder at brugeren har dit eller et hjere niveau",

  "svListar alla gster i kanalen. Wildcard kan anvndas. XXX i niv-fltet"
  " betyder att gsten har din eller hgre niv",

  "noLister alle gjester p kanalen. Jokere kan brukes. XXX i niv-feltet"
  " betyr at gjesten har ditt eller hyere niv",

  "nlToont alle gasten op het kanaal wiens accounts overstemmen met de optionele"
  " gespecifeerde wildcard. XXX in het level veld betekent de gebruiker heeft jouw of",
  " een hoger level",

  "frListes tout les invits du canal qui ont le mme joker spcifi. XXX "
  " dans le premier champs veux dire que l'utilisateur  ton niveau ou plus",

  "deGibt eine Liste aller Gste des Kanals aus, deren Hostmaske auf die"
  " optional angegebenen Suchkriterien pat. XXX im Benutzerlevel-Feld"
  " bedeutet, da der Benutzer den gleichen Level oder einen hheren hat,"
  " als man selber",

  "esLista todos los invitados(guest) en el canal, que su cuenta coincida"
  " con el especificado en el wildcart. XXX significa que el usuario"
  " tiene mas o el mismo nivel que tu",

  "fiNytt listan kaikista kanavan vieraista. Vaihtoehtoisesti voit"
  " rajoittaa listaa kyttmll osoitemaskia [match]. XXX tasona"
  " tarkoittaa ett kyttjn taso on sinun tai korkeampi",

  NULL
};

char *msg_help_moderate[] = {
  "enMakes the channel moderated. A voice is given to all, including"
  " those who joins",

  "daLaver en modereret kanal (+m). En stemme (+v) bliver givet til alle,"
  " inklusiv dem der joiner",

  "svGr en kanal modererad (+m). En stmma (+v) ges till alla, inklusive"
  " de som joinar",

  "noGjr en kanal moderert (+m). En stemme gis til alle, inklusive alle"
  " som joiner",

  "nlMaakt het kanaal gemodereerd (+m). Voice (+v) wordt aan iedereen gegeven die gejoined is"
  " en aan diegene die joinen",

  "frMets le canal en mode Moderate. Le voice est donner a tout le monde, "
  " mme a ceux qui join le canal",

  "deSetzt den Kanal +m (moderated). Alle Benutzer bekommen eine Stimme"
  " (+v), inclusive derer, die den Kanal betreten",

  "esHace que el canal sea moderado(+m). una voz (+v) se dara a todos"
  " incluido a los que entren",

  "fiTekee kanavasta moderoidun. Kaikki saavat nen (+v), mys kaikki"
  " jotka liittyvt kanavalle tulevaisuudessa",

  NULL
};

char *msg_help_cut[] = {
  "enCloses a dcc chat connection to <nick>. If nick isn't specified, it"
  " will close the invoking user's dcc connection",

  "daLukker en dcc chat forbindelse til <nick>. Hvis <nick> ikke er specificeret"
  " s lukkes din egen forbindelse",

  "svStnger en dcc chat frbindelse till <nick>. Om nick inte r angivet"
  " stngs din egen frbindelse",

  "noLukker en dcc chat forbindelse til <nick>. Hvis <nick> ikke er spesifisert,"
  " s lukkes din egen forbindelse",

  "nlSluit een dcc chat connectie met <nick>. Indien nick niet gespecifieerd is,"
  " zal de connectie met jezelf gesloten worden",

  "frFermes une connection dcc chat de <nick> . Si <nick> n'as pas t spcifi"
  " a vas fermer celle que celui qui a fait la commande",

  "deBeendet eine DCC-Chat Verbindung zu <nick>. Wird kein nick angegeben, wird"
  " die Verbindung zu dem aufrufenden benutzer geschlossen",

  "esCierra un sesion DCC a un usuario si no se especifica tal entonces"
  " cerrara la sesion DCC del que invoca el comando",

  "fiSulkee DCC chat yhteyden nikkiin <nick>. Ellei <nick> argumenttia"
  " anneta, sulkee se kutsujan oman DCC yhteyden",

  NULL
};

char *msg_help_chgcmdlev[] = {
  "enChange a command level",
  "dandrer niveauet for en kommando",
  "svByt ett kommandos niv",
  "noBytter niv p en kommando",
  "nlVerandert het niveau van een kommando",
  "frChange le niveau d'une commande",
  "dendert einen Kommandolevel",
  "esCambia el nivel de comandos",
  "fiMuuttaa komennon tasoa",
  NULL
};

char *msg_help_webster[] = {
  "enLooks up words in webster",
  "daSlr ord op i webster",
  "svSl upp ett ord i webster",
  "noSlr opp ord i webster",
  "nlZoekt worden op in webster",
  "frCherche un mot dans le dictionnaire Webster",
  "deSchlgt Wrter in Websters Wrterbuch nach",
  "esBusca palabras en webster",
  "fiEtsii sanojen merkityksi webster sanakirjasta",
  NULL
};

char *msg_help_log[] = {
  "enTurn logging on/off",
  "daSlr logning til/fra",
  "svSlr logging av/p",
  "noSlr logging av/p",
  "nlZet het loggen aan/uit",
  "frActive le log ouvert/fermer",
  "deSchaltet logging ein/aus",
  "esEnciende/apaga el login",
  "fiKnn log plle / pois plt tai mrittele mit logataan. Katso"
  " 'syntax log'",
  NULL
};

char *msg_help_useradd[] = {
  "enAdd a new user. You can enter a specified registed nick or a"
  " custom pattern by using the flags -R and -P. -Q will prevent"
  " me from telling the user. -N let's you add an initial"
  " password for the user",

  "daTilfjer en ny bruger. Med -R kan du angive et registreret nick."
  " Med -P kan der angives et brugermnster. -Q gr at brugeren ikke"
  " fr besked. -N kan bruges til at angive et password",

  "svLgg till en ny anvndare. Du kan lgga till ett specifikt nick eller"
  " ett valfritt mnster genom att anvnda flaggorna -R och -P. -Q kommer"
  " frhindra att anvndaren fr besked. -N lter dig bestmma lsenordet",

  "noLegg til ny bruker. Med -R kan du angi et registrert nick, eller legg"
  " til er brukermnster med -P. -Q gjr at brukeren ikke fr beskjed."
  " -N kan brukes til  angi et passord",

  "nlVoegt een nieuwe gebruiker toe. Je kunt een geregistreerde nick toevoegen of een"
  " pattern door middel van -R en -P. Met -Q wordt er niets getoond aan de betreffende gebruiker"
  " -N maakt het mogelijk een extra initieel wachtwoord"
  " te specificeren voor de gebruiker",

  "frAjoute un utilisateur. Tu peux ajouter un nick ou un modles en utilisant"
  " les flags -R et -P. -Q vas m'empcher de le faire savoir a cet utilisateur"
  " -N te permets d'ajouter un mots de passe initial pour cet usager",

  "deFgt einen neuen Benutzer hinzu. Man kann entweder einen bekannten Nick"
  " oder mit den Flags -R und -P eine Hostmaske angeben. -Q hlt den bot davon"
  " ab, den betreffenden Benutzer von dem Vorgang zu unterrichten. -N setzt"
  " ein Startpasswort fr den Benutzer",

  "esAade unnuevo usuario.Puedes especificar un nick o un patron"
  " a tu medida unsando los flags-R y -P. -Q me previene decirselo"
  " al usuario. -N te deja incluir un password inicial para el usuario",

  "fiLis uuden kyttjn. -R ja -P optioita kytten voit mritell"
  " rekisteritvn nikin tai kyttjn osoitemaskin. -Q ei ilmoita"
  " lisyksest kyttjlle. -N optiolla voit mritella kyttjlle"
  " annettavan salasanan",

  NULL
};

char *msg_help_usermod[] = {
  "enModify an existing user. -P adds a pattern to the user (- to add"
  " current or the name of a nick to steal pattern from),"
  " -E changes the email field and -C the comment field (use quotes if"
  " they contains spaces), -D deletes the pattern or pattern number specified,"
  " -R changes the regged nick, -N the password. -Q prevents the bot from"
  " telling the user. Entering the level field will change the user's level."
  " Flags available are A, B, L, R, S and are set/removed like +B-A."
  " (Autoop, Banprotect, Linkbot, Regularbot, Stealth)",

  "dandrer p en eksistrende bruger. -P tilfjer et mnster (- tilfjer"
  " nuvrende konto). -E ndrer p email feltet (brug anfrselstegn"
  " hvis det indeholder mellemrum). -D fjerner et mnster eller et"
  " mnster nummer. -R ndrer det registrede nick. -Q gr at brugeren"
  " ikke fr besked. Hvis der er et niveau ndres brugers niveau til"
  " dette. Mulige flag er A, B, L, R, S, som bliver sat/slettet med"
  " '-F +B-A' (Autoop, Banprotect, Linkbot, Regularbot, Stealth)",

  "noEndrer en eksisterende bruker. -P legger til et mnster til brukeren"
  " (- for  legge til nvrende eller navnet p et nick  stjele"
  " mnster fra), -E endrer email-feltet (bruk quotes hvis det inneholder"
  " mellomrom), -D fjerner mnsteret eller mnsternummeret du spesifiserer,"
  " -R endrer det registrerte nicket. -Q hindrer boten i  fortelle om"
  " endringene til brukeren. Hvis du angir et niv, settes brukerens til"
  " det. Flagg tilgjengelige er A, B, L, R, S og de settes/fjernes med"
  " +B-A. (Autoop, Banprotect, Linkbot, Regularbot, Stealth)",

  "nlModificeert een bestaande gebruiker. -P voegt een nieuw pattern toe (-om het"
  " huidige pattern toe te voegen van de betreffende nick),"
  " -E verandert het email veld (gebruik aanhalingstekens indien het spaties bevat,"
  " -D verwijdert het pattern of het gespecificeerde pattern nummer,"
  " -R verandert de geregistreerde nick. -Q voorkomt het vertellen door de bot"
  " aan de gebruiker. Wanneer een level gespecificeerd in het level veld verandert het level van de gebruiker."
  " Beschikbaar vlaggen zijn A, B, L, R, S en betekenen aan-/uitzetten zoals +B-A."
  " (Autoop, Banprotect, Linkbot, Regularbot, Stealth)",

  "frModifie un utilisateur. -P ajoute un modle (- pour ajouter le courant"
  " ou le nom du nick a aller voler le modle),-E change le champs pour le"
  " email ( utilisez guillemets poue les espaces), -D enlves le modle"
  " ou le numro du modle spcifi, -R change le nick enregistr, -Q"
  " m'empche de le faire savoir  l'utilisateur .En entrant le champs du"
  " niveau , changeras le niveau de l'utilisateur. Les flags disponible"
  " sont A, B, L, R, S et sont ajouter/enlever comme suit +B-A."
  " (Autoop, Banprotect, Linkbot, Regularbot, Stealth)",

  "dendert einen bestehenden Benutzereintrag. -P fgt eine Hostmaske"
  " hinzu ( - die aktuelle, oder der Name eines nicks um dessen"
  " Hostmaske zu stehlen), -E ndert den Email-Eintrag (Anfhrungszeichen"
  " benutzen, wenn Leerzeichen vorkommen), -D lscht die Hostmaske oder"
  " eine spezielle angegebene Hostmaske, -R ndert den registrierten nick"
  " des Benutzers. -Q verhindert, da der Bot den betreffenden Benutzer"
  " von dem Vorgang in Kenntnis setzt. Level ndert den Benutzerlevel."
  " Verfgbare Flags sind A, B, L, R und S, und werden in der Form +B-A"
  " gesetzt und entfernt. (Autoop, Banprotect, Linkbot, Regularbot,"
  " Stealth)",

  "esModifica un usuario existente. -P aade un patron al usuario(- para"
  " aadir al patron o al nick),"
  " -E cambia el estado del email(usa _ si contiene espacios),"
  " -D borra los patron o patrones especificados,"
  " -R cambia el nick de registro. -Q previene que el bot se lo diga"
  " al usuario.aadiendo nivel cambiara el nivel del usuario."
  " Los flags son A, B, L, R, S y se quitan o ponen como +B-A."
  " (Autoop, Banprotect, Linkbot, Regularbot, Stealth)",

  "fiMuuttaa olemassaolevan kyttjn tietoja. -P lis maskin kyttjlle"
  " ('-' lis nykyisen, voit mys antaa nikin jolta maski varastetaan),"
  " -E muuttaa kyttjn e-mail osoitteen ja -C kommentin (kyt"
  " lainausmerkkej mikli e-mail tai kommentti sislt vlilynti-merkkej)."
  " -D poistaa maskin tai maskinumeron, -R muuttaa rekisteridyn nikin, -N"
  " salasanan. -Q ei kerro muutoksesta kyttjlle. [level] muuttaa kyttjn"
  " tason. -F muuttaa kyttjn lippuja. Olemassaolevat liput: A, B, L, R, S"
  " (Autoop, Banprotect, Linkbot, Regularbot, Stealth) ja niit"
  " asetetaan/poistetaan esim. '-F +B-A'",

  NULL
};

char *msg_help_client[] = {
  "enRequest a DCC CHAT connection (useful if you cannot send the request"
  " yourself because of a firewall or proxy)",

  "daBed om at f en DCC CHAT tilsendt (nyttigt hvis du ikke selv kan sende"
  " den pga. en firewall eller proxy)",

  "svBer att fr en DCC CHAT (praktiskt om du inte kan skicka en anhllan"
  " sjlv pga firewall eller proxy)",

  "noBer om  f en DCC CHAT tilsendt (praktisk hvis du ikke selv kan sende"
  " den pga. en firewall eller proxy)",

  "nlVraag om een DCC CHAT connectie (handig indien je zelf geen request kunt sturen"
  " bijvoorbeeld in het geval van een firewall of proxy)",

  "frDemande une connection DCC CHAT ( utile si tu ne peux pas envoyer"
  " une demande toi mme  cause d'un proxy ou d'un firewall)",

  "deLt den Bot einen DCC-Chat initiieren. Sinnvoll, wenn man die DCC"
  " Anfrage zum Beispiel wegen eines Firewalls oder Proxys nicht selber"
  " schicken kann",

  "esPide un DCC chat sirve por si no puedes mandar tu dcc por ti mismo"
  " como cuando estas detras de un firewall o un proxy)",

  "fiPyyt minua lhettmn DCC CHAT pyynnn (kytnnllist jos et voi"
  " itse lhett pyynt firewallin tai proxyn takia)",

  NULL
};

char *msg_help_expdel[] = {
  "enRemove an explanation",
  "daFjerner en forklaring",
  "svRaderar en frklaring",
  "noFjern en forklaring",
  "nlVerwijder een verklaring (explain)",
  "frEnlve une explication",
  "deEntfernt eine Erklrung",
  "esBorra una explicacion",
  "fiPoistaa selityksen",
  NULL
};

char *msg_help_email[] = {
  "enDisplay a user's stored email address",
  "daViser en brugers email adresse",
  "svVisar en anvndares epost-adress",
  "noViser en brukers email-adresse",
  "nlToont een gebruiker's email adres",
  "frMontre le email d'un utilisateur qui  t sauvegard",
  "deZeigt die gespeicherte Email-Adresse eines Benutzers an",
  "esMuestra la direccion email guardada de un usuario",
  "fiNytt kyttjn email osoitteen",
  NULL
};

char *msg_help_setemail[] = {
  "enChanges your email address. 'setemail none' removes your email."
  " To change someone else's email with -n, you must be LEVELEXPERT or greater",
  "daStter en email adresse til dine egne bruger informationer",
  "svStt epost-adressen i din egen anvndarinformation",
  "noSett email-adressen i din egen brukerinformasjon",
  "nlSpecifieer je email adres voor je eigen gebruikersinformatie",
  "frFixe l'adresse email de ton propre userinfo",
  "deSetzt die eigene Email-Adresse",
  "esPone la direccion email a ti mismo en tu informacion del bot",
  "fiMuuttaa email osoitettasi. 'setemail none' poistaa osoitteen."
  " -N optiota kytten voit vaihtaa muiden kyttjien email osoitteita"
  " mikli tasosi on LEVELEXPERT tai korkeampi",
  NULL
};

char *msg_help_serveradd[] = {
  "enAdd a server to the my list of servers",
  "daTilfjer en server til min liste af servere",
  "svLgg till en server till min serverlista",
  "noLegg til en server til min serverliste",
  "nlVoegt een server toe aan mijn serverlijst",
  "frAjoute un serveur  ma liste de serveurs",
  "deFgt der Serverliste einen neuen Eintrag hinzu",
  "esAade un servidor a mi lista de servidores",
  "fiLis serverin serverilistaan",
  NULL
};

char *msg_help_serverlist[] = {
  "enList all servers in the my list",
  "daViser alle servere i min liste",
  "svVisar alla servrarna i min lista",
  "noViser alle servere i liste",
  "nlToont alle servers in mijn lijst",
  "frListe tout les serveur dans ma liste",
  "deZeigt eine Liste aller dem Bot bekannten Server an",
  "esLista todos los servidores de mi lista",
  "fiNytt koko serverilistan",
  NULL
};

char *msg_help_serverdel[] = {
  "enDelete a server from the my list",
  "daSletter en server fra min liste",
  "svRaderar en server frn min lista",
  "noSletter en server fra lista",
  "nlVerwijdert een server van mijn lijst",
  "frEnlves un serveur de ma liste",
  "deEntfernt einen eintrag aus der Serverliste",
  "esBorra un servidor de mi lista",
  "fiPoistaa serverin serverilistalta",
  NULL
};

char *msg_help_serverstat[] = {
  "enReport/set status of a server. -D disables the server, -E enables it",

  "daFortller/stter status over en server. -D inaktiverer en server, -E"
  " aktiverer den",

  "svBerttar/stter status p en server. -D inaktiverar den, -E aktivierar"
  " den",

  "noForteller/setter status p en server. -D deaktiverer en server, -E"
  " aktiverer den",

  "nlRapporteert/zet status van een server. -D maakt de server ongeldig, -E maakt de server beschikbaar",

  "frMontre/fixe le status d'un serveur. -D dsactive ce serveur, -E l'active",

  "deMeldet/setzt den Status eines Servers. -D deaktiviert den Server, -E"
  "aktiviert ihn",

  "esMuestra/pone el estatus de un servidor. -D anula el servidor, -E lo activa",

  "fiNytt / asettaa serverin tilan. -D ottaa serverin pois kytst"
  " (ei poista listalta), -E palauttaa serverin takaisin kyttn",

  NULL
};

char *msg_help_chat[] = {
  "enToggles chat mode on/off",
  "daStter chat mode skiftevis til eller fra",
  "svStter chat tillstnd (mode) p eller av",
  "noSetter chat tilstand p eller av",
  "nlZet chat mode aan/uit",
  "frBascules le mode chat actif/non-actif",
  "deSchaltet den Chat-Modus ein/aus",
  "esPone el modo chat en encendido/apagado",
  "fiAsettaa chatti moodin plle / pois plt",
  NULL
};

char *msg_help_link[] = {
  "enTest function... hands off",
  "daTest funktion... fingrene vk",
  "svTestfunktion... bort med fingrarna",
  "noTestfunksjon... fingrene av fatet",
  "nlTest optie... afblijven",
  "frFonction test...mains libre",
  "deTestfunktion... Finger weg!",
  "esTest de funcion... Quita las manos de aqui",
  "fiTesti funktio... npit irti",
  NULL
};

char *msg_help_linklist[] = {
  "enTest function... hands off",
  "daTest funktion... fingrene vk",
  "svTestfunktion... bort med fingrarna",
  "noTestfunksjon... fingrene av fatet",
  "nlTest optie... afblijven",
  "frFonction test...mains libre",
  "deTestfunktion... Finger weg!",
  "esTEst de funcion.. quita tus manosde aqui",
  "fiTesti funktio... npit irti",
  NULL
};

char *msg_help_kick[] = {
  "enKick the specified nick or pattern off the channel",
  "daSparker et bestemt nick eller mnster af kanalen",
  "svSparkar angivet nick eller mnster ut frn kanalen",
  "noSparker et bestemt nick eller mnster av kanalen",
  "nlTrapt de gespecificeerde nick of pattern van het kanaal",
  "frKick le nick ou le modle hors du canal",
  "deKickt den angegebenen Nick oder die angegebene Hostmaske vom Kanal",
  "esPatea el nick especifico o patron del canal",
  "fiPotkaisee annetun nikin tai maskia vastaavat nikit pois kanavalta",
  NULL
};

char *msg_help_userdel[] = {
  "enMark a user for deletion. -Q means don't attempt to tell user,"
  " -U means undo a previous delete and -R let's you specify a regged"
  " nick if a user currently joined is shadowing the actual victim."
  " -F forces an immediate delete",

  "daMarkerer at en bruger skal slettes. -Q betyder at brugeren ikke"
  " fr besked herom. Med -U kan du fortryde sletningen. Med -R kan"
  " du angive et registeret nick",

  "svMarkerar en anvndare fr radering. -Q betyder att anvndaren inte"
  " fr reda p det. Med -U kan du ngra raderingen och -R lter dig ange"
  " ett registrat nick istllet fr den som r i kanalen med samma nick",

  "noMarkerer en bruker for sletting. -Q betyr at brukeren ikke fr vite"
  " om det. Med -U kan du angre radering, og -R lar deg angi et registrert"
  " nick istedet for det som er i kanalen med samme nick, hvis noen p"
  " kanalen dekker det egentlige offeret",

  "nlMarkeer een gebruiker voor verwijderen. -Q betekent vertel het niet aan de gebruiker,"
  " -U betekent undo een vorige verwijdering en met -R kun je een geregistreerde nick"
  " specificeren",

  "frMarque un utilisateur pour tre enlever.-Q ne pas avertir l'usager"
  " -U enlve la marque et -R permets de spcifi un nick enregistr"
  " si un utilisateur dj prsent ombre la victime actuelle",

  "deMarkiert einen Benutzer als zum Lschen vorgemerkt. -Q verhindert eine"
  "Benachrichtigung des Benutzers, -U macht ein verheriges Lschen rckgngig"
  "und -R ermglicht die Angabe eines registrierten Nicks, falls ein momentan"
  "im Channel befindlicher User gerade den gleichen Nick wie der zu lschende"
  "Benutzer benutzt",

  "esBorra a un usuario Sealado.-Q significa que no se lo diga al usuario"
  " -U sobre un borrado anterior y -R te deja especificar un nick por si"
  " el usuario esta remplazando a la victima actual",

  "fiMerkitsee kyttjn poistettavaksi. -Q ei kerro kohteelle,"
  " -U peruuttaa aikaisemman 'poiston'. -R optiolla voit mritell"
  " rekisteridyn nikin mikli kanavalla on samanaikaisesti toinen"
  " henkil joka kytt samaa nikki. -F optiolla voit pakottaa kyttjn"
  " vlittmn poiston",

  NULL
};

char *msg_help_exchange[] = {
  "enConvert between currencies",
  "daKonverter mellem forskellige valutaer",
  "svOmvandlar mellan valutor",
  "noKonverter mellom valuta",
  "nlKonverteert geldeenheden",
  "frConverti l'argent entre les devises",
  "deWhrungsumrechner",
  "esConversor de monedas",
  "fiMuuntaa valuuttoja toisikseen",
  NULL
};

char *msg_help_used[] = {
  "enA verbose and descriptive SEEN clone",
  "daEn udvidet udgave af SEEN",
  "svEn pratsam SEEN-variant",
  "noEn pratsom SEEN-variant",
  "nlEen uitgebreide en beschrijvende SEEN",
  "frUne description plus dtaill du clone SEEN",
  "deEin detaillierter und ausfhrlicher SEEN-Clone",
  "esUna repetitiva y descriptiva copia del comando SEEN",
  "fiSEEN klooni joka antaa enemmn ja kuvailevampaa tietoa nikist",
  NULL
};

char *msg_help_language[] = {
  "enSet your preferred language you want the bot to talk to you with."
  " Supported languages at this time are: dansk, deutsch, english, espaol,"
  " franais, nederlands, norsk, svenska and suomi",

  "daVlger hvilket sprog du foretrkker at jeg skal tale p."
  " flgende sprog understttes: dansk, deutsch, english, franais, espaol,"
  " nederlands, norsk, svenska, suomi",

  "svVlj vilket sprk du vill att botten ska prata med dig p. Just"
  " nu stds dansk, deutsch, english, espaol, franais, nederlands, norsk,"
  " svenska, suomi",

  "noVelg hvilket sprk du vil at boten skal prate med deg p."
  " Akkurat n stttes dansk, deutsch, english, espaol, franais, nederlands,"
  " norsk, svenska, suomi",

  "nlZet de taal waarin de bot met je moet praten; dansk, deutsch, english,"
  " espaol, franais, nederlands, norsk, svenska, suomi",

  "frFixe la langue de prfrences du robot. Les languages accept a prsent"
  " sont: dansk, deutsch, english, espaol, franais, nederlands, norsk,"
  " svenska, suomi",

  "deSetzt die Sprache, in der der Bot mit dem Benutzer kommuniziert."
  " Untersttzte Sprachen sind im Moment dansk, deutsch, english, espaol,"
  " franais, nederlands, norsk, svenska, suomi",

/* rek2 */
  "esSelecciona el lenguaje preferido en el que quieres que yo te hable."
  " los lenguajes soportados por ahora son: dansk, deutsch, english, espaol,"
  " franais, nederlands, norsk, svenska, suomi y alguno mas",

  "fiAsettaa kielen jolla haluat botin kanssasi kommunikoivan."
  " Kytsssi olevat kielet: dansk, deutsch, english, espaol,"
  " franais, nederlands, norsk, svenska ja suomi",

  NULL
};

char *msg_need_higher_level[] = {
  "enYou need a higher level to do that",
  "daDu har ikke tilstkkelig hjt niveau",
  "svDu har inte tillrckligt hg statusniv",
  "noDu har ikke hyt nok niv",
  "nlJe hebt een hoger level",
  "frTu dois avoir un niveau",
  "deDazu wird ein hherer benutzerlevel bentigt",
  "esNecesitas un nivel superior para hacer eso",
  "fiTarvitset korkeamman tason sen tehdksesi",
  NULL
};

char *msg_nothing_shown[] = {
  "enNothing was shown, enter a valid command!",
  "daIntet blev vist. Skriv en gyldig kommando!",
  "svInget visades. Skriv ett giltigt kommando!",
  "noIngenting vistes. Skriv en gyldig kommando!",
  "nlEr werd niets getoond, gebruik een geldig kommando!",
  "frRien n'as t montrer, utilise une commande valide!",
  "deEs wurde nichts angezeigt. Bitte einen gltigen befehl eingeben!",
  "esNada a sido mostrado, Pon un comando valido!!!",
  "fiMitn ei nytetty. Kyt kunnollista komentoa!",
  NULL
};

char *msg_command_restored[] = {  /* cmdname, cmdlevel, orglevel */
  "enCommand %s restored from level %d to %d",
  "daKommando %s genplaceret fra niveau %d til %d",
  "svKommandot %s terstllt frn niv %d till %d",
  "noKommando %s tilbakestilt fra niv %d til %d",
  "nlVerander kommando %s van level %d naar %d",
  "frLa commande %s est revenue du niveau %d  %d",
  "deBefehl %s von Benutzerlevel %d auf %d wiederhergestellt",
  "esComandos %s repuesto desde el nivel %d al %d",
  "fiKomento %s palautettiin tasolta %d takaisin tasolle %d",
  NULL
};

char *msg_changed_command_level[] = {  /* cmdname, cmdlevel, newlevel */
  "enChanged command %s from level %d to %d",
  "dandrede kommando %s fra niveau %d til %d",
  "svndrade kommandot %s frn niv %d till %d",
  "noEndret kommando %s fra niv %d til %d",
  "nlVerander kommando %s van level %d naar %d",
  "frChang la commande %s du niveau %d au niveau %d",
  "deBefehl %s von Benutzerlevel %d auf %d gendert",
  "esCambiado el comando %s del nivel %d al nivel %d",
  "fiKomento %s siirrettiin tasolta %d tasolle %d",
  NULL
};

char *msg_chat_mode_off[] = {
  "enChat mode is off",
  "daChat mode er slet fra",
  "svChat mode r avslaget",
  "noChat mode er av",
  "nlChat mode is uit",
  "frLe mode chat est fermer",
  "deChat-Modus ist aus",
  "esEl modo de Charla esta off",
  "fiChatti moodi on pois plt",
  NULL
};

char *msg_left_chat[] = {  /* nick */
  "en%s has left the chat",
  "da%s har forladt chatten",
  "sv%s lmnade chatten",
  "no%s forlot chaten",
  "nl%s heeft de chat verlaten",
  "fr%s  quitter le chat",
  "de%s hat den Chat verlassen",
  "es%s ha dejado la charla",
  "fi%s poistui chatista",
  NULL
};

char *msg_echo_has_been_turned[] = {  /* on/off */
  "en*** Echo has been turned %s",
  "da*** Ekko er slet %s",
  "sv*** Eko r nu '%s'",
  "no*** Ekko er n '%s'",
  "nl*** Echo is nu %s",
  "fr*** Echo  t changer  %s",
  "de*** Echo-Status ist jetzt: %s",
  "es*** Echo ha sido puesto %s",
  "fi*** Kaiku knnettiin %s",
  NULL
};

char *msg_unknown_command[] = {
  "en*** Unknown command",
  "da*** Ukendt kommando",
  "sv*** Oknt kommando",
  "no*** Ukjent kommando",
  "nl*** Onbekend kommando",
  "fr*** Commande inconnue",
  "de*** Unbekannter Befehl",
  "es*** Comando no reconocido",
  "fi*** Tuntematon komento",
  NULL
};

/* Need new translations */
char *msg_already_explained[] = {
  "en'%s' already has an explanation",
  "daDenne tekst har allerede en forklaring",
  "svDen angivna texten har redan en frklaring",
  "noDen angitte teksten har allerede en forklaring",
  "nlDe gespecificeerde string heeft al een verklaring",
  "frLa chane spcifi  dj une explication",
  "de Der angegebene Begriff besitzt bereits eine Erklrung",
  "esEl objeto en si ,ya tiene una explicacion",
  "fiSanalla '%s' on jo selitys",
  NULL
};

#if 0
char *msg_explaination_too_big[] = {
  "enExplanation is too big (max. 200 characters)",
  "daForklaring er for stor (maks. 200 tegn)",
  "noForklaring er for stor (maks. 200 tegn)",
  "nlVerklaring is te groot (max. 200 tekens)",
  "frL'explication est trop grosse (max. 200 caratres)",
  "deDie Erklrung ist zu lang (max. 200 Zeichen)",
  "esLa explicacion es muy grande (max. 200 caracteres)",
  "fiSelityksen pituus on liian suuri (max. 200 merkki)",
  NULL
};
#endif

char *msg_added_explaination[] = {
  "enAdded the explanation",
  "daTilfjede forklaringen",
  "svLade till frklaringen",
  "noLa til forklaringen",
  "nlVoegt een verklaring toe",
  "frL'explication  t ajouter",
  "deErklrung zum Bestand hinzugefgt",
  "esExplicacion agregada",
  "fiSelitys listty",
  NULL
};

char *msg_removed_explaination[] = {  /* explaination */
  "en%s is now removed",
  "da%s er nu blevet fjernet",
  "sv%s r nu raderat",
  "no%s er n fjernet",
/* hans */
  "nl%s Voegt een verklaring toe",
  "fr%s est maintenant enlever",
  "de%s wurde entfernt",
  "es%s ha sido removido!",
  "fiSelitys '%s' poistettu",
  NULL
};

char *msg_explaination_was_not_found[] = {  /* explaination */
  "en%s wasn't found",
  "daKunne ikke finde %s",
  "svKunde inte hitta '%s'",
  "noKunne ikke finne '%s'",
  "nl%s is niet gevonden",
  "fr%s n'as pas t trouver",
  "de%s wurde nicht gefunden",
  "es%s no ha sido encontrado",
  "fiSelityst '%s' ei lytynyt",
  NULL
};

char *msg_no_public_wildcards[] = {
  "enWildcards not allowed in public commands",
  "daWildcards er ikke tilladte i offentlige kommandoer",
  "svWildcard r inte tilltna i offentliga kommandon",
  "noJokere er ikke tillatt i offentlige kommandoer",
  "nlWildcards niet toegestaan in publieke kommandos",
  "frJokers non disponible dans les commandes publique",
  "dePlatzhalter sind in fentlichen befehlen nicht zugelassen",
  "esLos Wildcards no estan permitidos en comandos publicos",
  "fiJokereiden kytt julkisten komentojen kanssa ei ole hyvksyttv",
  NULL
};

char *msg_no_public_options[] = {
  "enOptions not allowed in public commands",
  "daOptions er ikke tilladte i offentlige kommandoer",
  "svOptioner r inte tilltna i offentliga kommandon",
  "noValgene er ikke tillatte i offentlige kommandoer",
  "nlOpties niet toegestaan in publieke kommandos",
  "frLes options ne sont pas disponible en commande publique",
  "deOptionen sind in ffentlichen Befehlen nicht zugelassen",
  "esLas opciones no son validas para comandos publicos",
  "fiOptioiden kytt julkisten komentojen kanssa ei ole hyvksyttv",
  NULL
};

char *msg_report_level[] = {  /* nick, realname, level */
  "en%s %s has %s",
  "da%s %s har %s",
  "sv%s %s har %s",
  "no%s %s har %s",
  "nl%s %s heeft %s",
/* frenchize */
  "fr%s  %s %s",
  "de%s %s hat %s",
  "es%s %s tiene %s",
  "fi%s %s taso: %s",
  NULL
};

char *msg_comment[] = {  /* comment */
  "enComment: %s",
  "daKommentar: %s",
  "svKommentar: %s",
  "noKommentar: %s",
  "nlCommentaar: %s",
  "frCommentaire: %s",
  "deBemerkung: %s",
  "esComentario: %s",
  "fiKommentti: %s",
  NULL
};

char *msg_yours_or_higher[] = {
  "enyours or higher",
  "dadit eller hjere",
  "svdin eller hgre",
  "noditt eller hyere",
  "nlJouw of een hoger",
  "frLe tien ou plus haut",
  "deDen eigenen oder einen Hheren",
  "esIgual que el tuyo o mayor",
  "fisinun tai korkeampi",
  NULL
};

char *msg_sview_user[] = {  /* type, nick, domain, level, status */
  "en%sUser %s!%s, Level: %s%s",
  "da%sBruger %s!%s, Niveau: %s%s",
  "sv%sAnvndare %s!%s, Niv: %s%s",
  "no%sBruker %s!%s, Niv: %s%s",
  "nl%sGebruiker %s!%s, Niveau: %s%s",
  "fr%sUtilisateur %s!%s, Niveau: %s%s",
  "de%sBenutzer %s!%s, Level: %s%s",
  "es%sUsuario %s!%s, Nivel %s%s",
  "fi%sKyttj %s!%s, taso: %s%s",
  NULL
};

/* ----- done for 4.3.4 ------ */

char *msg_no_more_mr_nice_bot[] = {
  "enNo more Mr. Nice Bot",
  "daIkke mere Hr. Rar Bot",
  "svIngen mer snll plysch-bot",
  "noIkke mere pingle-bot her i grden",
  "nlGenoeg gewaarschuwd",
  "frPus Mr. Bon Bot",
  "deKein Mr. Nice Bot mehr",
  "esNo voy hacer mas el 'BOT amable' ahora atente a las consecuencias",
  "fiNyt loppu leikki",
  NULL
};

char *msg_usually_kicks_X[] = {
  "enusually kicks %s! This is warning %d %s...",
  "dasparker normalt %s! Dette er advarsel %d %s...",
  "svsparkar vanligtvis %s! Det hr r varning %d %s...",
  "nosparker vanligvis %s! Dette er adversel %d %s...",
  "nlverwijdert gewoonlijk %s! Dit is waarschuwing %d %s...",
/* frenchize */
  "frHabituellement kick%s! Ceci est l'avertissement %d %s...",
  "dekickt %s normalerweise! Dies ist Warnung Nummer %d, %s...",
  "esPateamiento numero %s! Este es el aviso %d %s...",
  "fiyleens potkii %s pois kanavalta! Tm on %d. varoitus %s...",
  NULL
};

char *msg_flooders[] = {
  "enflooders",
  "dafloddere",
  "svfloodare",
  "nofloodere",
  "nlflooders",
  "frfloodeurs",
  "deFlooder",
  "esFloodeador",
  "fifloodailijat",
  NULL
};

char *msg_no_flooding[] = {
  "enNo flooding!",
  "daIngen flooding!",
  "svSluta flooda!",
  "noIngen flooding!",
  "nlGeen flooding!",
  "frPas de flood!",
  "deNo flooding!",
  "esNo Floodees!",
  "fiEips floodailla",
  NULL
};

char *msg_shouters[] = {
  "enshouters",
  "daskrigehalse",
  "svgaphalsar",
  "noskrikhalser",
  "nlschreeuwers",
  "frcriards",
  "deSchreihlse",
  "esdisparadores",
  "fihuutavat pikkulapset",
  NULL
};

char *msg_no_shouting[] = {
  "enStop shouting in here, will ya?",
  "daHold op med den rben, hva'?",
  "svSluta skrika hr inne, va?",
  "noGidder 'u  slutte skrikinga, eller?",
  "nlWil je ophouden met schreeuwen hier?",
  "frPas de criage ici ok ?",
  "deSchrei hier nicht so rum, ja?!",
  "esPara de disparar aqui OK!!?",
  "fiNyt loppu huutaminen",
  NULL
};

char *msg_repeaters[] = {
  "enrepeaters",
  "dafolk der gentager sig selv",
  "svupprepare",
  "nogjentagere",
  "nlherhalers",
  "frrpteurs",
  "deWiederholer",
  "esRepetidores",
  "fiitsens toistajat",
  NULL
};

char *msg_no_repeaters[] = {
  "enStop repeating yourself",
  "daHold op med at gentage dig selv",
  "svSluta upprepa dig",
  "noSlutt  gjenta deg selv",
  "nlHoudt op met jezelf te herhalen",
  "frArrte de te rpeter",
  "deMir ist, als httest Du das schon einmal gesagt...",
  "esPara de repetirte a ti mismo,hombre",
  "fiToistamisiin",
  NULL
};

char *msg_not_implemented_yet[] = {
  "enNot implemented yet",
  "daEndnu ikke implementeret",
  "svInte implementerat nnu",
  "noEnn ikke implementert",
  "nlNog niet ondersteund",
  "frPas implmenter encore",
  "deNoch nicht implementiert",
  "esNo ha sido agregado aun",
  "fiEi viel implementoitu",
  NULL
};

char *msg_ctcp_bomb_detected[] = {
  "enCTCP bomb detected",
  "daCTCP bombe detekteret",
  "svCTCP bomb detekterad",
  "noCTCP bombe funnet",
  "nlCTCP bom gedetecteerd",
  "frCTCP bomb dtect",
  "deCTCP-Bombe entdeckt",
  "esCTCP-Bomb detectado",
  "fiCTCP pommi havaittu",
  NULL
};

char *msg_tsunami_detected[] = {
  "enTsunami detected",
  "daTsunami detekteret",
  "svTsunami detekterad",
  "noTsunami oppdaget",
  "nlTsunami gedetecteerd",
  "frTsunami dtect",
  "deTsunami entdeckt",
  "esTsunami Detectado",
  "fiTsunami havaittu",
  NULL
};

char *msg_beep_flood_detected[] = {
  "enBeep flood detected",
  "daBeep flood detekteret",
  "svPip-flood detekterad",
  "noPip-flood oppdaget",
  "nlBeep flood gedetecteerd",
  "frFlood de beeps dtect",
  "deBeep-Flood entdeckt",
  "esBeep-flood Detectado!!!",
  "fiPiippi floodi havaittu",
  NULL
};

char *msg_nick_not_found[] = {
  "enCouldn't find no nick named %s!",
  "svKunde inte hitta ngon %s!",
  "daKunne ikke finde nogen %s!",
  "noKunne ikke finne noen %s!",
  "nlKon geen nick vinden genaamd %s!",
  "frN'as pus trouver le nick nommer %s!",
  "deDer Nick %s wurde nicht gefunden!",
  "esNo pude encontrar ningun nick llamado %s!",
  "fiNikki %s ei lytynyt!",
  NULL
};

char *msg_pattern_would_include_myself[] = {
  "enYou stupid! That pattern would include myself!",
  "daFjols! Det mnster ville inkludere mig selv!",
  "svDummer! Det mnstret skulle ju inkludera mig sjlv!",
  "noLavpanne! Det mnsteret ville jo inkludere meg selv!",
  "nlEikel! Dat pattern zou ook mijzelf betekenen!",
  "frTu es stupide! Ce modle m'inclus!",
  "deHerzlichen Glckwunsch. Diese Hostmaske wrde den Bot einschlieen!",
  "esEres tonto!!!?? ese patron me incluye a mi!!!!",
  "fiSenkin lykpi! Tuo maskihan sislt minut!",
  NULL
};

char *msg_ban_report_timed[] = {
  "en%s was just %sbanned by %s for %d seconds \"%s\"",
  "da%s blev %sbannet af %s i %d sekunder \"%s\"",
  "sv%s blev %sbannlyst av %s i %d sekunder \"%s\"",
  "no%s ble %sbannlyst av %s i %d sekunder \"%s\"",
  "nl%s werd net gebanned %sbanned door %s voor %d seconden \"%s\"",
  "fr%s viens d'tre %sbanni par %s pour %d secondes \"%s\"",
  "de%s wurde gerade %sbanned (von %s fr %d Sekunden \"%s\"",
  "es%s acaba de ser %sBaneado por %s, por %d segundos \"%s\"",
  "fi%s %sbannattiin sken %s:n toimesta %d sekunniksi \"%s\"",
  NULL
};

char *msg_ban_report[] = {
  "en%s was just %sbanned by %s, \"%s\"",
  "da%s blev %sbannet af %s, \"%s\"",
  "sv%s blev %sbannlyst av %s, \"%s\"",
  "no%s ble %sbannlyst av %s, \"%s\"",
  "nl%s werd zojuist %sbanned door %s, \"%s\"",
  "fr%s viens d'tre %sbanni par %s, \"%s\"",
  "de%s wurde gerade %sbanned (von %s), \"%s\"",
  "es%s acaba de ser %sbaneado por %s, \"%s\"",
  "fi%s %bannattiin sken %s:n toimesta, \"%s\"",
  NULL
};

char *msg_banned_already[] = {
  "en%s is already banned",
  "da%s er allerede bannet",
  "sv%s r redan bannlyst",
  "no%s er allerede bannlyst",
  "nl%s is reeds gebanned",
  "fr%s est dj banni",
  "de%s ist bereits gebannt",
  "es%s ya esta baneado",
  "fi%s on jo bannattu",
  NULL
};

char *msg_use_pass_first[] = {
  "enYou must register with PASS first",
  "daDu skal frst registrere dig med PASS",
  "svDu mste registrera dig med PASS frst",
  "noDu m registrere deg med PASS frst",
  "nlJe moet je eerst met PASS registreren",
  "frTu dois t'enregistrer avec PASS avant",
  "deBitte zunchst mit PASS anmelden",
  "esDebes identificarte con tu PASS primero, porfavor",
  "fiTodista ensin henkilllisyytesi PASS komennolla",
  NULL
};

char *msg_invalid_password[] = {
  "enInvalid password",
  "daForkert password",
  "svFelaktigt lsenord",
  "noFeil passord",
  "nlVerkeerd wachtwoord",
  "frMot de passe invalide",
  "deUngltiges Pawort",
  "esEl Password no es aceptado!",
  "fiVr salasana",
  NULL
};

char *msg_password_ok[] = {
  "enPassword ok",
  "daPassword ok",
  "svLsenord ok",
  "noPassord ok",
  "nlWachtwoord geaccepteerd",
  "frMot de passe ok",
  "dePawort OK",
  "esEl password esta Bien",
  "fiSalasana hyvksytty",
  NULL
};

char *msg_notop[] = {
  "enSince I lack channel operator status, I can't do that! Get me opped first...",
  "daEftersom jeg ikke har operatrstatus kan jeg ikke gre det. Skaf mig det frst...",
  "svEftersom jag inte har operatrsstatus kan jag inte gra det. Skaffa mig det frst...",
  "noEttersom jeg ikke har operatrstatus kan jeg ikke gjre det. Skaff meg det frst...",
  "nlOmdat ik zelf geen operator status heb, kan ik dat niet doen! Zorg eerst dat ik op ben...",
  "frVue que je n'est pas le status d'oprateur, je ne peux pas faire a! Donnes"
  " moi le OP avant...",
  "deDer Bot konnte die Aktion mangels Operator-Status nicht ausfhren...",
  "esHAsta que no tengo estatus de 'operador del canal', no puedo hacer eso! primero dame OP...",
  "fiKoska minulla ei ole oppeja, en voi sit tehd! Hanki minulle opit ensin...",
  NULL
};

char *msg_use_chat[] = {
  "enYou must use /DCC CHAT for this command",
  "daDu skal brug /DCC CHAT til denne kommando",
  "svDu mste anvnda /DCC CHAT fr det hr kommandot",
  "noDu m bruke /DCC CHAT for den her kommandoen",
  "nlJe dient /DCC CHAT te gebruiken voor dit kommando",
  "frTu dois utiliser /DCC CHAT pour cette commande",
  "deFr diesen befehl mu /DCC CHAT benutzt werden",
  "esDeves de usar /DCC CHAT para este comando",
  "fiTm komento vaatii /DCC chatin toimiakseen",
  NULL
};

char *msg_reload_done[] = {
  "enReload done",
  "daReload klar",
  "svReload klar",
  "noReload ferdig",
  "nlReload klaar",
  "frReload termin",
  "deReload fertig",
  "esFinalizado el reload",
  "fiReload suoritettu",
  NULL
};

char *msg_cant_show[] = {
  "enCannot show command",
  "daKan ikke anvende SHOW til denne kommando",
  "svKan inte anvnda SHOW p detta kommando",
  "noKan ikke bruke SHOW p denne kommandoen",
  "nlKan kommando niet tonen",
  "frNe peux pas montrer la commande",
  "deDer Befehl kann nicht angezeigt werden",
  "esNo se puede mostrar el comando",
  "fiKyseinen komento ei ole nytettviss",
  NULL
};

char *msg_no_such_alias[] = {
  "en%s is no valid command or alias",
  "da%s er ikke nogen gyldig kommando eller alias",
  "sv%s r inte ngot kommando eller alias",
  "no%s er ikke en kommando eller aliase",
  "nl%s is niet een geldig kommando of alias",
  "fr%s n'est pas une commande ou un alias valide",
  "de%s ist kein gltiger Befehl und kein gltiges Alias",
  "es%s no es un comando valido o un alias!",
  "fi%s ei ole olemassaoleva komento tai alias",
  NULL
};

char *msg_available_commands[] = {
  "enThe following commands are available to you:",
  "daDe flgende kommandoer er tilgngelige for dig:",
  "svFljande kommandon finns tillgngliga fr dig:",
  "noFlgende kommandoer er tilgjengelige for deg:",
  "nlDe volgende kommandos staan tot je beschikking:",
  "frVoici la liste de commandes qui te sont disponible:",
  "deDie folgenden Befehle stehen zur Vefgung:",
  "esLos siguientes comandos son los que tienes a tu disposicion por tu nivel",
  "fiSeuraavat komennot ovat kytettvisssi:",
  NULL
};

char *msg_level[] = {
  "enlevel",
  "daniveau",
  "svniv",
  "noniv",
  "nlniveau",
  "frniveau",
  "deLevel",
  "esNivel",
  "fitaso",
  NULL
};

char *msg_beepers[] = {
  "enbeepers",
  "dabeepere",
  "svpipare",
  "nopipere",
  "nlbeepers",
  "frbeepers",
  "deBeepers",
  "esBeepers",
  "fipiippailijat",
  NULL
};

char *msg_kickmsg_no_beepers[] = {
  "enNo beeping!",
  "daIngen beeping!",
  "svInget pipande!",
  "noIngen piping!",
  "nlGeen beeping!",
  "frPas de beeps!",
  "deBei Dir piepts wohl? Hier wird nicht rumgepiept!",
  "esNo beeping! porfavor!",
  "fiEi piippi!",
  NULL
};

char *msg_colour_users[] = {
  "enpeople who use colourcodes",
  "nofolk som bruker fargekoder",
  "dafolk der bruger farvekoder",
  "depeople who use colourcodes",
  "fiihmiset jotka kytt vrikoodeja",
  NULL
};

char *msg_kickmsg_no_colours[] = {
  "enColourcodes are *not* appreciated here!",
  "daVi bryder os *ikke* om farvekoder her!",
  "svVi bryr oss *inte* om frgkoder hr!",
  "noVi bryr oss *ikke* om fargekoder her!",
  "nlKleurcodes worden hier niet gewaardeerd!",
  "deFarben sind hier NICHT erwnscht!",
  "esCodigos de colores no son apreciandos aqui!!",
  "fiEi vrikoodeja kiitos",
  NULL
};

char *msg_helpset_autojoin[] = {
  "enJoin channel automatically if being kicked",
  "daJoin kanal automatisk hvis bliver sparket af",
  "svJoina kanalen automatiskt om jag blir kickad",
  "noJoiner kanalen automatisk hvis jeg blir sparket ut",
  "nlJoin een kanaal automatisch indien gekicked",
  "frRejoindre la canal automatiquement aprs avoir t kicker",
  "deKanal nach Kick automatisch wieder betreten",
  "esReentra en el canal automaticamente en caso de ser pateado",
  "fiLiittyy kanavalle automaattisesti mikli potkaistaan pois",
  NULL
};
char *msg_helpset_bomb[] = {
  "enKick CTCP bombers",
  "daSparker folk der dropper CTCP bomber",
  "svSparka CTCP-bombare",
  "noSpark CTCP-bombere",
  "nlKick CTCP bommers",
  "frKick le floodeur CTCP bombers",
  "deKick CTCP-Bomber",
  "esPatea al bombardero de CTCP",
  "fiEst CTCP pommittukset",
  NULL
};
char *msg_helpset_ctcp[] = {
  "enPrevent CTCP floods",
  "daForhindrer CTCP floods",
  "svMotverka CTCP-floodar",
  "noForhindre CTCP-overflod",
  "nlVoorkomt CTCP floods",
  "frPrviens les CTCP floods",
  "deCTCP-Floods vermeiden",
  "esPreviene CTCP-flood",
  "fiEst CTCP floodin",
  NULL
};
char *msg_helpset_deop[] = {
  "enCheck for massive deoppers",
  "daModvirk massive deoppere",
  "svUpptck och motverka deoppare",
  "noOppdag og motvirk deoppere",
  "nlKijkt uit naar mass deoppers",
  "frVriife pour les dopages massif",
  "deAuf massive DeOPs berwachen",
  "esProtege y Previene de deop masivos",
  "fiEst massiivisen deoppailun",
  NULL
};
char *msg_helpset_flood[] = {
  "enPrevent public floods",
  "daForhindrer offentlige floods",
  "svMotverka floodare i kanalen",
  "noMotvirk floodere i kanalen",
  "nlVoorkomt publiekelijke floods",
  "frPrviens le flood public",
  "deffentliche Floods unterbinden",
  "esPrevien de flood en el canal",
  "fiEst kanavan floodaamisen. Katso FLOODRATE ja FLOODTIME",
  NULL
};
char *msg_helpset_invite[] = {
  "enJoin a channel if being /invite'd",
  "daJoin en kanal hvis jeg bliver /invite't",
  "svJoina en kanal om jag blir /invite'ad",
  "noJoin en kanal hvis jeg blir /invite't",
  "nlJoin een kanaal indien /invite",
  "frRejoin un canal si t /invite ",
  "deEinen Kanal nach Einladung betreten (/invite)",
  "esEntra a un canal si se es invitado a el. (/invite)",
  "fiLiittyy kanavalle kutsusta (/invite)",
  NULL
};
char *msg_helpset_key[] = {
  "enLock the channel key",
  "daLs kanalens ngle (+k)",
  "svLs kanalens 'nyckel'",
  "noLs kanalens 'nkkel'",
  "nlForceer de kanaal sleuitel (+k)",
  "frBarre la cl du canal(+k)",
  "deKanal-Pawort schtzen (+k)",
  "esBlokea el key del canal (+k)",
  "fiLukitsee kanavan avaimen (+k)",
  NULL
};
char *msg_helpset_kickban[] = {
  "enKick banned users if they join (split or lagged servers)",
  "daSpark bannede folk af hvis de joiner (splittede eller laggede servere)",
  "svSparka bannlysta anvndare om de joinar (splittade eller lngsamma servrar",
  "noSpark bannlyste brukere hvis de joiner (splittede eller treige servere)",
  "nlKick gebande gebruikrs indien zij joinen (netsplit of lagged servers)",
  "frKick les utilisateurs banni s'ils rejoin (d'un serveur en split ou qui lagg)",
  "deGebannte Benutzer kicken, wenn sie den kanal betreten (split oder lag-Server)",
  "esPatea usuarios baneados si entran al canar por medio de un split o servers con lag)",
  "fiPotkaisee bannatut vieraat heidn liittyessn kanavalle (splitin tai"
  " lagissa olevien servereiden seurauksena)",
  NULL
};
char *msg_helpset_mode[] = {
  "enLock the channel mode",
  "daLs kanalens tilstand (mode)",
  "svLs kanalens mode",
  "noLs kanalens tilstand (mode)",
  "nlForceert de kanaal mode",
  "frBarre le mode de canal",
  "deKanal-Modi schtzen (mode lock)",
  "esBloquea los modos del canal",
  "fiLukitsee kanavan moodin",
  NULL
};
char *msg_helpset_limit[] = {
  "enLock the channel limit",
  "daLs kanalens limit",
  "svLs kanalens 'limit'",
  "noLs kanalens limit",
  "nlForceert de kanaal limit",
  "frBarre le limit de canal",
  "deDas Benutzerlimit des Kanals schtzen (+l)",
  "esBloquea el limite del canal (+l)",
  "fiLukitsee kanavan ylrajan (+l)",
  NULL
};
char *msg_helpset_multi[] = {
  "enPrevent user to join from the same account multiple times",
  "daForhindr at brugere joiner fra samme konto flere gange",
  "svFrhindra anvndare att joina frn samma konto flera gnger",
  "noForhindre brukere fra  joine fra samme konto flere ganger",
  "nlVoorkomt dat gebruikers verscheidene malen joinen met hetzelfde account",
  "frEmpche l'utilisateur de rejoindre sous le mme compte plusieurs fois",
  "deUnterbinden, da ein benutzer vom selben Account aus mehrfach den Kanal betritt"
  "esPreviene que un usuario pueda entrar con la misma cuenta muchas veces",
  " (clones)",
  "fiEst vieraita liittymst kanavalle samanaikaisesti liian monta kertaa"
  " samasta osoitteesta. Katso FLOODJOINS",
  NULL
};
char *msg_helpset_netsplit[] = {
  "enDeop and unban server ops/bans",
  "daDeop og unban ops/bans der sttes af servere",
  "svDeoppa och unbanna ops/bans satta av servers",
  "noDeop og unban ops/bans satt av servere",
  "nlDeop en unban server ops/bans",
  "frDeop et dban les ops/bans de serveur",
  "deServer OPs und BANs rckgngig machen",
  "esQuita el op y banea a los op/bans del servidor",
  "fiDeoppaa ja unbannaa serveri opit / bannit",
  NULL
};
char *msg_helpset_nick[] = {
  "enKick nickname flooders",
  "daSpark nickname floodere af",
  "svSparka nickname floodare",
  "noSpark nickname floodere",
  "nlKick nickname flooders",
  "frKick les floodeurs de nick",
  "deNickname-Flooder kicken",
  "esPatear a los que floodean con cambio de nick",
  "fiPotkaisee nikkiflooderit",
  NULL
};
char *msg_helpset_repeat[] = {
  "enPrevent repeaters",
  "daForhindr folk der gentager sig selv",
  "svFrhindra upprepningar",
  "noForhindre gjentagelser",
  "nlVoorkomt dat gebruikers zich herhalen",
  "frEmpche les rptitions",
  "deKeine Wiederholer zulassen",
  "esPreviene de repetidores",
  "fiEst toistamisen. Katso FLOODREPEATRATE ja FLOODREPEATTIME",
  NULL
};
char *msg_helpset_reportban[] = {
  "enReport about bans in public",
  "daFortl om bans p kanalen",
  "svBertta om bannlysningar i kanalen",
  "noFortell om bannlysninger p kanalen",
  "nlRapporteer bans publiekelijk",
  "frRapporte les ban en public",
  "deDen Kanal ber BANs informieren",
  "esMuestra informacion de los bans en publico",
  "fiTiedottaa banneista kanavalla",
  NULL
};
char *msg_helpset_say[] = {
  "enEnable/disable the SAY and ME commands",
  "daSl SAY og ME kommandoerne til/fra",
  "svSl p/av SAY och ME kommandona",
  "noSl p/av SAY og ME kommandoene",
  "nlAan-/uitzetten van de SAY en ME kommandos",
  "frActive/Dsactive les commandes SAY et ME",
  "deDie SAY und ME Befehle aktivieren/deaktivieren",
  "esActiva/desactiva los comandos SAY y ME",
  "fiMahdollistaa / est SAY ja ME komentojen kytn",
  NULL
};
char *msg_helpset_talk[] = {
  "enTalkative mode",
  "daSnaksalig tilstand",
  "svSnacksaligt tillstnd",
  "noSnakkesalig tilstand",
  "nlPraatzama mode",
  "frMode parler",
  "deRedseligkeits-Modus",
  "esModo de talk activado",
  "fiPuhelias / vhemmn puhelias",
  NULL
};
char *msg_helpset_upper[] = {
  "enCheck for uppercase violations (> 75%%)",
  "daForhindr rben (folk der bruger mere end 75%% store bogstaver)",
  "svMotverka versal-noja (> 75%%)",
  "noMotvirk roping (>75%% blokkbokstaver)",
  "nlKontroleer op hoofdletter overtredingen (> 75%%)",
  "frVrifie les majuscules (>75%%)",
  "deGROSSSCHREIB-Verste berwachen (> 75%%)",
  "esRevisa las violaciones de mayusculas (> 75%%)",
  "fiEst huutamisen kanavalla (huutamista on kun yli 75%% tekstist on"
  " isoja kirjaimia)",
  NULL
};
char *msg_helpset_warn[] = {
  "enReport about people on the warnlist",
  "daAdvar om folk i warnlisten",
  "svVarna fr folk i varningslistan",
  "noAdvar om folk i advarselslista",
  "nlRapporteert over mensen in de waarschuwingslijst",
  "frMontre les personne de la liste d'avertissement",
  "deber Eintrge in der Warnliste informieren",
  "esMuestra datos sobre la gente de la warnlist",
  "fiVaroitusmoodi plle / pois plt",
  NULL
};
char *msg_helpset_welcome[] = {
  "enWelcome new users",
  "daHils nye brugere velkommen",
  "svVlkomna nya anvndare",
  "noHils nye brukere velkommen",
  "nlVerwelkomt nieuwe gebruikers",
  "frSouhaite bienvenue au nouvel utilisateurs",
  "deNeue Benutzer willkomman heien",
  "esBienvenido al sistema",
  "fiToivottaa uudet vieraat tervetulleiksi",
  NULL
};
char *msg_helpset_xdcc[] = {
  "enKick xdcc announcers",
  "daSpark xdcc annoncrer af",
  "svSparka xdcc-annonsrer",
  "noSpark xdcc annonsrer",
  "nlKick xdcc aankondigers",
  "frKick les annonceurs en xdcc",
  "deXDCC-Ausrufer kicken",
  "esPatea a los anunciantes en xdcc",
  "fiPotkaisee xdcc-mainostajat",
  NULL
};
char *msg_helpset_ckey[] = {
  "enSet a channel key",
  "daSet en kanal ngle",
  "svStt kanal-nyckeln",
  "noSett en kanalnkkel",
  "nlZet de kanaal sleutel",
  "frFixe une cl d'un canal",
  "deEin Kanal-Pawort setzen",
  "esActiva el key del canal",
  "fiAsettaa kanavan avaimen (+k)",
  NULL
};
char *msg_helpset_cmode[] = {
  "enSet a channel mode",
  "daSet en kanal tilstand (mode)",
  "svStt kanalens mode",
  "noSett kanalens tilstand",
  "nlZet een kanaal mode",
  "frFixe un mode de canal",
  "deEinen Kanal-Modus (mode) setzen",
  "esActiva un modo del canal (+i +t +n ...etc)",
  "fiAsettaa kanavan moodin",
  NULL
};
char *msg_helpset_climit[] = {
  "enSet channel limit",
  "daSet en kanal limit",
  "svStt kanalens limit",
  "noSett kanalens limit",
  "nlZet een kanaal limit",
  "frFixe un limit de canal",
  "deEin Benutzerlimit fr den kanal setzen (+l)",
  "esActiva el limite de usurios del canal (+l)",
  "fiAsettaa kanavan ylrajan (limit, +l)",
  NULL
};
char *msg_helpset_autoop[] = {
  "enEnable auto-ops",
  "daSl auto-op til/fra",
  "svSl p/av auto-op",
  "noSl p/av auto-op",
  "nlAanzetten auto-op",
  "frActive le auto-op",
  "deAuto-OP einschalten (siehe auch HELP USERMOD)",
  "esActiva el auto-op",
  "fiAuto-op moodi plle / pois plt",
  NULL
};
char *msg_helpset_comment[] = {
  "enEnable user-comments",
  "daSl join beskeder (bruger kommentarer) til/fra",
  "svSl p/av anvndare-kommentarer vid join",
  "noSl p/av bruker-kommentarer ved join",
  "nlAanzetten gebruikers-kommentaar",
  "frActive les commentaires-usagers",
  "deBenutzer-Bemerkungen einschalten",
  "esActivar los comentarios de usuarios",
  "fiNytt kyttjien kommentit heidn liittyessn kanavalle",
  NULL
};
char *msg_helpset_colour[] = {
  "enKick colourcode (ab)users",
  "daSpark farvekode (mis)brugere",
  "svSparka frgkods(miss)brukare",
  "noSpark fargekode (mis)brukere",
  "nlKick (mis)bruikers van kleurcodes",
  "deBenutzer bei Gebrauch von farbcodes kicken",
  "esCodigo de color de pateamientos (ab)usuarios",
  "fiEst vrikoodien vrinkytn",
  NULL
};
char *msg_helpset_beep[] = {
  "enKick beepers",
  "daSpark beepere",
  "svSparka pipare",
  "noSpark pipere",
  "nlKick beepers",
  "frKick beepers",
  "deBeeper kicken",
  "esBeep de pateadmientos",
  "fiEst piippailun. Katso FLOODBEEPS",
  NULL
};
char *msg_helpset_floodrate[] = {
  "enPrevent more than FLOODRATE messages in FLOODTIME seconds",
  "daForhindrer mere end FLOODRATE beskeder i FLOODTIME sekunder",
  "svMotverka mer n FLOODRATE rader inom FLOODTIME sekunder",
  "noMotvirk mer enn FLOODRATE beskjeder innen FLOODTIME sekunder",
  "nlVoorkomt meer dan FLOODRATE mededelingen in FLOODTIME seconden",
  "frEmpche plus que FLOODRATE message en FLOODTIME secondes",
  "deMehr als FLOODRATE Nachrichten ind FLOODTIME Sekunden unterbinden",
  "esPreviene mas mensajes que FLOODRATE en segundos de FLOODTIME",
  "fiSallii max FLOODRATE viesti FLOODTIME sekunnissa. Katso FLOOD",
  NULL
};
char *msg_helpset_floodtime[] = {
  "ensee FLOODRATE",
  "dase FLOODRATE",
  "svse FLOODRATE",
  "nose FLOODRATE",
  "nlzie FLOODRATE",
  "frVoir FLOODRATE",
  "desiehe FLOODRATE",
  "esmirar FLOODRATE",
  "fiKatso FLOODRATE ja FLOOD",
  NULL
};
char *msg_helpset_floodrepeatrate[] = {
  "enPrevent more than FLOODREPEATRATE repetitions within FLOODREPEATTIME seconds",
  "daForhindrer mere end FLOODREPEATRATE gentagelse indenfor FLOODREPEATTIME sekunder",
  "svMotverka mer n FLOODREPEATRATE upprepningar inom FLOODREPEATTIME sekunder",
  "noForhindre mer enn FLOODREPEATRATE gjentagelser innen FLOODREPEATTIME sekunder",
  "nlVoorkomt meer dan FLOODREPEATRATE herhalingen binnen FLOODREPEATTIME seconden",
  "frEmpche plus que FLOODREPEATRATE rptitions durant FLOODREPEATTIME secondes",
  "deMehr als FLOODREPEATRATE Wiederholungen in FLOODREPEATTIME Sekunden unterbinden",
  "esPreviene mas que repeticiones FLOODREPEATRATE sin los segundos de FLOODREPEATTIME",
  "fiSallii max FLOODREPEATRATE toistoa FLOODREPEATTIME sekunnissa. Katso REPEAT",
  NULL
};
char *msg_helpset_floodrepeattime[] = {
  "ensee FLOODREPEATRATE",
  "dase FLOODREPEATRATE",
  "svse FLOODREPEATRATE",
  "nose FLOODREPEATRATE",
  "nlZie FLOODREPEATRATE",
  "frVoir FLOODREPEATRATE",
  "deSiehe FLOODREPEATRATE",
  "esmirar FLOODREPEATRATE",
  "fiKatso FLOODREPEATRATE ja REPEAT",
  NULL
};
char *msg_helpset_floodbeeps[] = {
  "enMaximum number of public beeps",
  "daMaksimalt antal af offentlige beeps",
  "svMax antal pip i kanalen",
  "noMaks antall pip i kanalen",
  "nlMaximum nummer publiekelijke beeps",
  "frMaximum de beep publique",
  "deMaximal zulssige Anzahl ffentlicher Beeps",
  "esMaximo numero de beeps publicos",
  "fiSuurin sallittu piippien mr. Katso BEEP",
  NULL
};
char *msg_helpset_helpsyntax[] = {
  "enMake the syntax information get displayed when HELP is used",
  "daLad ogs syntaks informationen blive vist ved HELP",
  "svLt syntax-informationen visas nr HELP anvnds",
  "noLa ogs syntaks-informasjon vises nr HJELP brukes",
  "nlToont de syntax informatie wanneer HELP gebruikt wordt",
  "frFait afficher la syntaxe de l'information quand HELP est utilis",
  "deBei Gebrauch von HELP die Syntaxinformation anzeigen",
  "esHace que el la informacion del syntax aparezca cuando HELP es usado",
  "fiNytt HELP komennon yhteydess mys komennon syntaksin",
  NULL
};
char *msg_helpset_bantime[] = {
  "enSet the default ban time for public bans in the channel",
  "daSt default timeout tiden for offentlige bans",
  "svStt default timeout tid fr bannlysningar i kanalen",
  "noSett default timeout tid for bannlysninger i kanalen",
  "nlZet de default ban tijd voor publiekelijke bans in het kanaal",
  "frFixe le temps du ban par dfaut pour les bans publique dans le canal",
  "deSetzt die Standard-Banzeit fr ffentliche Bans in Kanal",
  "esPone el tiempo por defecto de los bans en este canal",
  "fiAsettaa kanavalla tehtyjen bannien kestoajan, jonka jlkeen ne"
  " poistetaan ellei toisin mrt",
  NULL
};
char *msg_helpset_execprotect[] = {
  "enPrevents shell executions by the bot",
  "daForhindr at botten kan udfoere shell kommandoer",
  "svFrhindra shell-exekveringar av botten",
  "noForhindre at boten kan utfre shell-kommandoer",
  "nlVoorkomt shell uitvoeringen door de bot",
  "frEmpche le robot d'effectuer des commandes shell",
  "deVerhindert Shellzugriffe durch den Bot",
  "esPreviene ejecutar comandos de shell por el bot",
  "fiEst shell komentojen suorittamisen botilla",
  NULL
};
char *msg_helpset_identprotect[] = {
  "enPrevents users from using the IDENT command",
  "daForhindrer brugere i at kunne anvende IDENT kommandoen",
  "svFrhindrar anvndare att kunna anvnda IDENT-kommandot",
  "noForhindrer brukere fra  bruke IDENT-kommandoen",
  "nlVoorkomt dat gebruikers het IDENT kommando kunnen gebruiken",
  "frEmpche les utilisateurs d'utiliser la commande IDENT",
  "deBenutzer vom Gebrauch des Befehls IDENT ausschlieen",
  "esPreviene que usuarios puedan usar el comando IDENT",
  "fiEst IDENT komennon kytn",
  NULL
};
char *msg_helpset_autounban[] = {
  "enAutomatically unbans the least important ban when the channel"
  " reaches 18 bans in the list",
  "daAutomatiske unban af de mindst betydende bans nr kanalen nr"
  " 18 bans in dens banliste",
  "svAutomatiskt ta bort den minsta viktiga bannlysningen nr kanalen nr"
  " 18 bannlysningar",
  "noAutomatisk unban av de minst viktige bannlysningene nr kanalen nr"
  " 18 bannlysninger",
  "nlUnbanned automatisch minder belangrijke bans wanneer het kanaal"
  " 18 bans bereikt in de banlijst",
  "frUnban automatiquement les bans moin important quand la liste de ban du canal"
  " atteint 18",
  "deHebt den unwichtigsten Ban automatisch auf, sobal die Zahl der Eintrge in"
  " der Banliste des Kanals 18 erreicht",
  "esAutomaticamente desbanea los bans menos importantes cuando el canal alcanza"
  " 18 bans en la lista",
  "fiPoistaa automaattisesti vhiten merkitsevt bannit kun bannien lukumr"
  " kanavalla saavuttaa 18 tai enemmn",
  NULL
};
char *msg_helpset_botbantime[] = {
  "enDefault time of a bot ban without time specified",
  "daDefault tid for mine egne bans, nr igen tid angives",
  "svDefault tid fr mina bannlysningar nr tid inte anges",
  "noDefault tid for mine bannlysninger nr tid ikke angis",
  "nlDefault tijd voor een door de bot tijdloze gezette ban",
  "frLe temps apr dfaut d'un ban sans avoir spcifi de temps",
  "deStandardzeit fr einen Bot-ban ohne Zeitangabe",
  "fiBotin tekemien bannien kestoaika, ellei toisin mrt",
  NULL
};
char *msg_helpset_floodjoins[] = {
  "enNumber of joins accepted from the same hostpattern",
  "daAntal joinede personer som accepteres fra samme brugermnster",
  "svAntal joins accepterat frn samma anvndarmnster",
  "noAntall joins som aksepteres fra samme bruker-mnster",
  "nlAantal geaccepteerde joins van een zelfde hostpattern",
  "frNombre de join accept par le mme modle-host",
  "deAnzahl zulssiger Benutzer im Kanal mit identischer Hostmaske",
  "esNumero de entradas aceptadas por el mismo patron de host",
  "fiNin monta samanaikaista liittymist samasta hostmaskista sallitaan"
  " enimmilln. Katso MULTI",
  NULL
};
char *msg_helpset_strictop[] = {
  "enWith this enabled, non-recognized user will not be allowed to get"
  " chanop status by people without very high status",
  "daUregistredede brugere tillades ikke at beholde operatrstatus, hvis"
  " de har modtaget det fra folk med en lav status",
  "svIcke-registrerade anvndare kommer inte tilltas f op av folk som"
  " inte har mycket hg status",
  "noUregistrerte brukere tillates ikke  beholde operatrstatus hvis"
  " de har mottatt den fra folk med lav status",
  "nlIndien aangezet kunnen niet herkende gebruikers geen chanop status verkrijgen"
  " van mensen zonder een hoge status",
  "frAvec ceci d'actif, les utilisateurs non-reconnu ne pourront pas obtenir le op"
  " mme avec ceux qui ont un niveau lev",
  "deWird STRICTOP eingeschaltet, drfen dem Bot nicht bekannte Benutzer nur von"
  " dem Bot bekannten Benutzern mit sehr hohem Benutzerlevel ChannelOP-Status"
  " erhalten",
  "esCon esto seleccionado, los usuarios no reconocidos por el bot no podran ser"
  " operadores del canal(OP) solo los que tengan un nivel muy alto seran capazes"
  " de dar op a alguien",
  "fiTmn ollessa pll botti yritt varmistaa ett ainoastaan tarpeeksi"
  " korkean tason omaavat kyttjt saavat antaa opit op-tason alapuolella"
  " oleville kyttjille",
  NULL
};
char *msg_helpset_banuserkicks[] = {
  "enWith this enabled, ordinary users' kicks are taken into consideration"
  " when the bot bans for multiple kicks within a certain time. If disabled,"
  " only bot kicks count.",
  "svOm denna r pslagen rknas vanliga anvndares sparkar nr boten avgr"
  " om den ska bannlysa pga fr mnga sparkar inom en viss tid. Om den r"
  " avslagen s rknas bara botens egna sparkar.",
  "noMed denne p, s blir vanlige brukeres spark regnet nr boten avgjr"
  " om den skal bannlyse pga. for mange spark innen en viss tid. Hvis den er"
  " avsltt, s regnes bare botens egne spark.",
  "nlIndien aangezet zal de bot gewone gebruikers kicks in overweging nemen indien"
  " de bot banned voor meerdere kicks binnen een specifieke tijd. Indien uitgezet,"
  " dan tellen alleen de bot kicks.",
  "frAvec ceci d'actif, les kicks d'utilisateur normal sont pris en considration"
  " quand le bot ban pour un kick multiple dans un laps dtermin. Si non-actif,"
  " seulement les kick du robot sont compts.",
  "deWird diese Option aktiviert, bezieht der Bot in seine Abwgung, ob ein"
  " bestimmter Benutzer wegen mehrerer Kicks innerhalb einer bestimmten Zeit"
  " gebannt werden soll, uch die Kicks anderer benutzer mit ein. Wenn"
  " deaktiviert, zhlen nur die Botkicks.",
  "esCon esto seleccionado, Pateos de usuarios regulares seran tomandos en consideracion"
  " cuando el bot banea por un periodo de tiempo pateamientos multiples.Si no "
  " esta seleccionado solo cuentan las patadas echas por el bot.",
  "fiTmn ollessa pll mys kyttjien tekemt potkut otetaan huomioon"
  " ptettess milloin botti bannaa vieraan liiallisten vrinkytsten"
  " seurauksena tietyss ajassa. Mikli pois plt, ainoastaan botin omat"
  " potkut lasketaan.",
  NULL
};

char *msg_setgroup_thres[] = {
  "enThresholds for different flood trigging",
  "daGrnsevrdier for forskellige flood udlsere",
  "svGrnsvrden fr olika flood-triggningar",
  "noGrenseverdier for forskjellige flood-utlsere",
  "nlWaarden voor verschillende flood triggers",
  "frSeuil pour le dclanchement des floods",
  "esOpcines de estados diferentes de Flood",
  "fiKynnys asetukset eri flood-suojien aktivointeihin",
  NULL
};
char *msg_setgroup_flood[] = {
  "enFlood control options",
  "daFlood kontrol indstillinger",
  "svFlood-kontroll instllningar",
  "noFlood-kontroll innstillinger",
  "nlFlood controle instellingen",
  "frOptions du contrle des floods",
  "esOpciones de control de Flood",
  "fiFloodailua rajoittavat asetukset",
  NULL
};
char *msg_setgroup_verbose[] = {
  "enVerbose/talkative options",
  "daSnaksalige indstillinger",
  "svSnacksaliga instllningar",
  "noSnakkesalige innstillinger",
  "nlUitgebreide/spraakzame opties",
  "frOptions Verbose/Parler",
  "esOpciones de repeticion/charla activada",
  "fiPuheliaisuutta stelevt asetukset",
  NULL
};
char *msg_setgroup_misc[] = {
  "enMisc options",
  "davrige indstillinger",
  "svvriga instllningar",
  "noAndre innstillinger",
  "nlOverige opties",
  "frOptions diverses",
  "esOpciones diversas",
  "fiSekalaiset asetukset",
  NULL
};
char *msg_setgroup_owner[] = {
  "enOwner's options",
  "daEjerens indstillinger",
  "svgarens instllningar",
  "noEierens innstillinger",
  "nlEigenaar's opties",
  "frOtpions du propritaire",
  "esOpciones del amo",
  "fiOmistajan asetukset",
  NULL
};
char *msg_setgroup_ban[] = {
  "enBan control options",
  "daBan kontrol indstillinger",
  "svBannlysningsinstllningar",
  "noBannlysningsinnstillinger",
  "nlBan controlle opties",
  "frOptions du contrle des bans",
  "esControl de Opciones del Ban",
  "fiBannailua koskevat asetukset",
  NULL
};

char *msg_cant_op[] = {
  "enI can't. Where are you?",
  "daDet kan jeg ikke. Hvor er du?",
  "svJag kan inte. Var r du?",
  "noJeg kan ikke. Hvor er du?",
  "nlKan ik niet. Waar ben je?",
  "frJe ne peux pas. O es-tu?",
  "esNo puedo, Donde estas?",
  "fiEn voi tehd sit. Miss olet?",
  NULL
};

char *msg_kickmsg[] = {
  "enRotten persons outside, please",
  "daSmut udenfor kanalen, tak",
  "svTa det dr utanfr kanalen, tack",
  "noHold dritten utenfor kanalen, takk",
  "nlTroep buiten het kanaal, bedankt",
  "frDehors les vermines !",
  "esPor favor, capullos fuera!",
  "fiHuonosti kyttytyvt ihmiset ulos",
  NULL
};

#if 0
    "You don't belong here",
    "Yeps, you're out",
    "Goodbye loser",
    "Here, I'll help you out",
    "And if you come back, bring a clue",

    "T'as pas d'affaire ici",
    "Yeps, t parti",
    "Bonsoir il est parti !",
    "Tiens, j'vas t'aider",
    "Pis si tu reviens amne une rponse",

/* spanish */
    "No mereces estar aqui!",
    "sip estas fuera capullo!",
    "Adios lamer!",
    "ahora llorale a tu madre...",
#endif

char *msg_seen_already_here[] = {
  "enYou need glasses badly",
  "daKontakt din optiker",
  "svBrillor vore nog inte s dumt fr dig",
  "noDu br vurdere briller",
  "nlBezoek eens een opticien",
  "frT'as vraiment besoin de lunettes !",
  "esNecesitas Gafas hombreton !",
  "fiErittin selvsti hnet nenkin. Kiitos kysymst",
  NULL
};

char *msg_ban_by[] = {
  "en by %s",
  "da af %s",
  "sv av %s",
  "no av %s",
  "nl door %s",
  "fr par %s",
  "es por %s",
  "fi bannaaja: %s",
  NULL
};

char *msg_ban_another[] = {
  "en another %s",
  "da yderligere %s",
  "sv ytterligare %s",
  "no ytterligere %s",
  "nl voor nog eens %s",
  "fr un autre %s",
  "es otro %s",
  "fi toiset %s",
  NULL
};

char *msg_ban_ago[] = {
  "en ban %s ago",
  "da ban %s siden",
  "sv bannlysning %s sedan",
  "no bannlysning %s siden",
  "nl ban %s geleden",
  "fr banni vla %s",
  "es baneado hace %s",
  "fi banni %s sitten",
  NULL
};

char *msg_unban_ago[] = {
  "en unban %s ago",
  "da unban %s siden",
  "sv unban %s sedan",
  "no unban %s siden",
  "nl ban %s geleden",
  "fr dban depuis %s",
  "es desbaneado hace %s",
  "fi poisti bannin %s sitten",
  NULL
};

char *msg_time_ban[] = {
  "en %s ban",
  "da %s ban",
  "sv %s bannlysning",
  "no %s bannlysning",
  "nl %s ban",
  "fr %s banni",
  "es %s Ban",
  "fi %s banni",
  NULL
};

char *msg_report_unban_nick[] = {
  "enbanning %s for %s, \"%s\", is over...",
  "dabanning af %s i %s, \"%s\", er ovre...",
  "svbannlysning %s i %s, \"%s\" r slut...",
  "nobannlysning %s i %s, \"%s\" er over...",
  "nlban %s voor %s, \"%s\" is voorbij...",
  "frban %s pour %s, \"%s\", est fini...",
  "esBaneando a %s por %s, \"%s\", se acabo...",
  "fibanniaika kului umpeen (%s bannattiin %s sitten: \"%s\").",
  NULL
};

char *msg_report_unban[] = {
  "en%s ban timed out...",
  "da%s ban er overstet...",
  "sv%s bannlysning tog slut...",
  "no%s bannlysning er oversttt...",
  "nl%s ban afgelopen...",
  "fr%s ban temps expir...",
  "es%s se paso el tiempo del ban",
  "fi%s banniaika kului umpeen.",
  NULL
};

char *msg_report_unbanforce_nick[] = {
  "en%s just unbanned %s",
  "da%s har netop unbannet %s",
  "sv%s tog just bort bannlysningen %s",
  "no%s tok akkurat bort bannlysningen %s",
  "nl%s zojuist geunbanned door %s",
  "fr%s viens de dbannir %s",
/* rek2 */
  "es%s Acaba de ser desbaneado %s",
  "fi%s poisti tuon bannin. %s psee taas kanavalle",
  NULL
};

char *msg_report_unbanforce[] = {
  "en%s did that unban",
  "da%s fjernede den ban",
  "sv%s tog bort den bannlysningen",
  "no%s tok bort den bannlysningen",
  "nl%s deed unban",
  "fr%s  fait le dban",
  "es%s realizo ese unban",
  "fi%s poisti tuon bannin",
  NULL
};

char *msg_kick_repeated_misbehavior[] = {
  "enrepeated misbehaviors",
  "dagentagent misbrug",
  "svupprepat missbruk",
  "nogjentatt misbruk",
  "nlherhaald misbruik",
  "frcomportement rpt inaccept",
  "esRepetimiento inaceptable",
  "fitoistuvaa hirikyttytymist",
  NULL
};

char *msg_kick_learn_your_lesson[] = {
  "enGo learn your lesson",
  "daLr din lektie",
  "svLt detta bli en lxa",
  "noLa dette vre en lekse",
  "nlGa maar eens nadenken",
  "frVas apprendre tes leons",
  "esVete de aqui y aprende la leccion..!!",
  "fiMene ja opettele lksysi",
  NULL
};

char *msg_kicklist_item[] = {
  "en%s (%s) by %s %s ago, %d kicks",
  "da%s (%s) af %s for %s siden, %d spark",
  "sv%s (%s) av %s fr %s sedan, %d sparkar",
  "no%s (%s) av %s for %s siden, %d spark",
  "nl%s (%s) door %s %s geleden, %d kicks",
  "fr%s (%s) par %s il y a %s, %d kick",
  "es%s (%s) por %s hace %s, %d pateados",
  "fi%s (%s) jonka %s potkaisi %s sitten, %d potkua",
  NULL
};

char *msg_no_matching_kick[] = {
  "enNo [matching] kicks!",
  "daIngen [matchende] spark!",
  "svInga [matchande] sparkar!",
  "noIngen [matchende] spark!",
  "nlGeen (overeenkomende) kicks!",
  "frPas de [match] kicks!",
  "esNingun pateadp [similar]!",
  "fiEi [sellaisia] potkuja.",
  NULL
};
char *msg_X_out_of_Y_items[] = {
  "en%d out of %d items shown!",
  "da%d ud af %d vist!",
  "sv%d av %d rader visade!",
  "no%d av %d linjer vist!",
  "nl%d van %d getoond!",
  "fr%d pus de %d montr!",
  "es%d de %d articulos enseados",
  "fi%d rivi %d:sta nytettiin",
  NULL
};

char *msg_warn_pattern_removed[] = {
  "enpattern %s!%s is no longer in the warnlist!",
  "damnster %s!%s er ikke lngere p warnlisten!",
  "svmnstret %s!%s finns inte lngre i varningslistan",
  "nomnsteret %s!%s finnes ikke lenger i advarselslista",
  "nlpattern %s!%s is niet langer in de waarschuwingslijst!",
  "frLe modle %s!%s n'est plus dans la liste d'avertissement",
  "esPatron %s!%s ya no esta en la lista de advertencias",
  "fimaski %s!%s poistettiin varoituslistalta.",
  NULL
};

char *msg_is[] = {
  "enis",
  "daer",
  "svr",
  "noer",
  "nlis",
  "frest",
  "eses",
  "fion",
  NULL
};

char *msg_warn_list_all[] = {
  "en%d warns, last one %s ago",
  "da%d advarsler, sidste for %s siden",
  "sv%d varningar, senast fr %s sedan",
  "no%d advarsler, senest for %s siden",
  "nl%d waarschuwingen, laatste %s geleden",
  "fr%d averti, le dernier est vla %s",
  "es%d Advertencias, la ultima hace %s",
  "fi%d varoitusta, viimeinen %s sitten",
  NULL
};

char *msg_warn_not_warned[] = {
  "enNever warned for.",
  "daAldrig advaret for.",
  "svAldrig varnad fr.",
  "noAldri advart for.",
  "nlNog nooit voor gewaarschuwd.",
  "frN'as jamais t averti pour a.",
  "esNunca avisado de ello.",
  "fiEi koskaan varoitettu.",
  NULL
};

char *msg_warn_by_when[] = {
  "en by %s %s ago. %s",
  "da af %s for %s siden. %s",
  "sv av %s fr %s sedan. %s",
  "no av %s for %s siden. %s",
  "nl door %s %s geleden. %s",
  "fr par %s il y a %s. %s",
  "es por %s hace %s. %s",
  "fi %s lissi varoituksen %s sitten. %s",
  NULL
};

char *msg_unknown[] = {
  "en<UNKNOWN>",
  "da<UKENDT>",
  "sv<OKND>",
  "no<UKJENT>",
  "nl<ONBEKEND>",
  "fr<INCONNU>",
  "es<DESCONOCIDO>",
  "fi<TUNTEMATON>",
  NULL
};

char *msg_no_reason[] = {
  "en<No reason>",
  "da<Ingen grund>",
  "sv<Ingen anledning>",
  "no<Ingen grunn>",
  "nl<Geen reden>",
  "fr<Pas de raison>",
  "es<Sin razon alguna>",
  "fi<Ei syyt>",
  NULL
};

char *msg_alerts[] = {
  "enALERTS: '%s' is %s",
  "daADVARER: '%s' er %s",
  "svVARNAR: '%s' r %s",
  "noADVARER: '%s' er %s",
  "nlWAARSCHUWD: %s is %s",
  "frALERTE: '%s' est %s",
  "esAlertas: '%s' es %s",
  "fivaroittaa: '%s' on %s",
  NULL
};

/* ... added to .h ... */

char *msg_spycast_outofchannel[] = {
  "enSPY: \"%s\" ignored out-of-channel msg from %s (%s)",
  "daSPY: \"%s\" ignorede besked udenfra kanalen fra %s (%s)",
  "svSPY: \"%s\" struntade i ett msg utifrn av %s (%s)",
  "noSPY: \"%s\" ignorerte en beskjed utenfra kanalen fra %s (%s)",
  "nlSPY: \"%s\" buiten het kanaal msg genegeerd van %s (%s)",
  "frSPY: \"%s\"  ignor le message hors du canal de %s (%s)",
  "esSPY: \"%s\" Ignorar mensaje de fuera del canal desde %s (%s)",
  "fiSPY: \"%s\" kanavan ulkopuolinen viesti ignoroitu -- %s (%s)",
 NULL
};

char *msg_snoop_hidden[] = {
  "en\"%s\" used by %s (%s) %s",
  "da\"%s\" brugt af %s (%s) %s",
  "sv\"%s\" av %s (%s) %s",
  "no\"%s\" brukt av %s (%s) %s",
  "nl\"%s\" gebruikte %s (%s) %s",
  "fr\"%s\" utilis par %s (%s) %s",
  "es\"%s\" Usado por %s (%s) %s",
  "fi\"%s\" -- %s (%s) %s",
  NULL
};
char *msg_snoop_prevented[] = {
  "en[snoop prevented]",
  "da[spionfilter]",
  "sv[spionfiltrerad]",
  "no[spionfilter]",
  "nl[snoop prevented]",
  "fr[espionnage impossible]",
  "es[espionaje imposible]",
  "fi[vakoileminen estetty]",
  NULL
};
char *msg_snoop_line[] = {
  "en\"%s\" by %s (%s)",
  "da\"%s\" af %s (%s)",
  "sv\"%s\" av %s (%s)",
  "no\"%s\" av %s (%s)",
  "nl\"%s\" door %s (%s)",
  "fr\"%s\" par %s (%s)",
  "es\"%s\" por %s (%s)",
  "fi\"%s\" -- %s (%s)",
  NULL
};
char *msg_backlog_entry[] = {
  "en%s ago %s",
  "da%s for %s siden",
  "sv%s fr %s sedan",
  "no%s for %s siden",
  "nl%s geleden %s",
  "fr%s vla %s",
  "es%s Hace %s",
  "fi%s sitten %s",
  NULL
};

char *msg_uptime_result[] = {
  "enStarted %s ago (on %s)",
  "daStartet for %s siden (%s)",
  "svStartade fr %s sedan (%s)",
  "noStartet for %s siden (%s)",
  "nlGestart %s geleden (op %s)",
  "frParti il y a %s (sur %s)",
  "esCorriendo desde hace %s (en %s)",
  "fiMinut kynnistettiin %s sitten (%s)",
  NULL
};

char *msg_sview_who_did_what[] = {
  "en%s by %s %s ago",
  "da%s af %s for %s siden",
  "sv%s av %s fr %s sedan",
  "no%s av %s for %s siden",
  "nl%s door %s %s geleden",
  "fr%s par %s vla %s",
  "es%s por %s hace %s",
  "fi%s %s %s sitten",
  NULL
};

char *msg_added[] = {
  "enAdded",
  "daTilfjet",
  "svAdderad",
  "noTilfyd",
  "nlToegevoegd",
  "frAjouter",
  "esAadido",
  "fiLissi",
  NULL
};

char *msg_raised[] = {
  "enRaised",
  "daget",
  "svHjd",
  "nokt",
  "nlVerhoogd",
  "frAugment",
  "esArgumentado",
  "fiNosti",
  NULL
};

char *msg_lowered[] = {
  "enLowered",
  "daSnket",
  "svSnkt",
  "noSenket",
  "nlVerlaagd",
  "frDiminu",
  "esDisminuido",
  "fiLaski",
  NULL
};

char *msg_confirmed[] = {
  "enConfirmed ",
  "daVerificeret ",
  "svBevisad ",
  "noBevist ",
  "nlBevestigde ",
  "frConfirm ",
  "esConfirmado ",
  "fiVarmistettu ",
  NULL
};

char *msg_sview_op[] = {
  "en (op)",
  "da (op)",
  "sv (op)",
  "no (op)",
  "nl (op)",
  "fr (op)",
  "es (op)",
  "fi (op)",
  NULL
};
char *msg_sview_dcc[] = {
  "en (DCC only)",
  "da (kun DCC)",
  "sv (bara DCC)",
  "no (kun DCC)",
  "nl (alleen DCC)",
  "fr (DCC seulement)",
  "es (solo DCC)",
  "fi (vain DCC)",
  NULL
};
char *msg_email[] = {
  "enEmail: %s",
  "daEmail: %s",
  "svEpost: %s",
  "noEmail: %s",
  "nlEmail: %s",
  "frEmail: %s",
  "esEmail: %s",
  "fiEmail: %s",
  NULL
};
char *msg_regged_nick[] = {
  "enRegged nick:",
  "daRegistreret nick:",
  "svReggad nick:",
  "noRegistrert nick:",
  "nlGeregistreerde nick:",
  "frNick enregistr:",
  "esRegged nick:",
  "fiRekisterity nick:",
  NULL
};

char *msg_sview_joins[] = {
  "enJoins: %d, this %s ago",
  "daJoins: %d, denne for %s siden",
  "svJoinar: %d, den hr fr %s sedan",
  "noJoins: %d, denne for %s siden",
  "nlJoins: %d, deze %s geleden",
  "frJoins: %d, il y a %s ",
  "esEmtradas: %d hace %s",
  "fiLiittymiset: %d, tm %s sitten",
  NULL
};
char *msg_warnings[] = {
  "enWarnings: %d",
  "daAdvarsler: %d",
  "svVarningar: %d",
  "noAdvarsler: %d",
  "nlWaarschuwingen: %d",
  "frAvertissements: %d",
  "esAvisos: %d",
  "fiVaroitukset: %d",
  NULL
};
char *msg_last_talked[] = {
  "enLast talked: %s ago (%.2f lines/min)",
  "daSidst talt: for %s siden (%.2f linier/min)",
  "svTalade senast: %s sedan (%.2f rader/min)",
  "noSnakket sist: %s siden (%.2f linjer/min)",
  "nlLaast gepraat: %s geleden (%.2f regels/min)",
  "frA parler la dernire fois: il y a %s (%.2f lignes/minutes)",
  "esHablo por ultima vez hace : %s (%.2f lineas por minuto)",
  "fiPuhui viimeksi: %s sitten (%.2f rivi/min)",
  NULL
};
char *msg_hasnt_said_anything[] = {
  "enHasn't said anything!!",
  "daHar endnu intet sagt!",
  "svHar inte sagt ngot!",
  "noHar ikke sagt noe enn!",
  "nlHeeft niets gezegd!",
  "frN'as rien dis !!",
  "esNo ha dicho nada!!",
  "fiEi ole sanonut mitn!",
  NULL
};
char *msg_messages[] = {
  "enMessages: %d",
  "daBeskeder: %d",
  "svMeddelanden: %d",
  "noMeldinger: %d",
  "nlMededelingen: %d",
  "frMessages: %d",
  "esMensajes: %d",
  "fiViestej: %d",
  NULL
};
char *msg_netsplit[] = {
  "enNetsplit",
  "daNetdeling",
  "svNtdelad",
  "noNettdeling",
  "nlNetsplit",
  "frNetsplit",
  "esNetSplit",
  "fiNetsplitiss",
  NULL
};

char *msg_and[] = {
  "enand",
  "daog",
  "svoch",
  "noog",
  "nlen",
  "fret",
  "esy",
  "fija",
  NULL
};

/* ... date and time ... */

char *msg_second[] = {
  "ensecond",
  "dasekund",
  "svsekund",
  "nosekund",
  "nlseconde",
  "frseconde",
  "esSegundo",
  "fisekunti",
  NULL
};
char *msg_seconds[] = {
  "enseconds",
  "dasekunder",
  "svsekunder",
  "nosekunder",
  "nlseconden",
  "frsecondes",
  "esSegundos",
  "fisekuntia",
  NULL
};
char *msg_minute[] = {
  "enminute",
  "daminut",
  "svminut",
  "nominutt",
  "nlminuut",
  "frminute",
  "esminuto",
  "fiminuutti",
  NULL
};
char *msg_minutes[] = {
  "enminutes",
  "daminutter",
  "svminuter",
  "nominutter",
  "nlminuten",
  "frminutes",
  "esminutos",
  "fiminuuttia",
  NULL
};
char *msg_hour[] = {
  "enhour",
  "datime",
  "svtimme",
  "notime",
  "nluur",
  "frheure",
  "eshora",
  "fitunti",
  NULL
};
char *msg_hours[] = {
  "enhours",
  "datimer",
  "svtimmar",
  "notimer",
  "nluren",
  "frheures",
  "eshoras",
  "fituntia",
  NULL
};
char *msg_day[] = {
  "enday",
  "dadag",
  "svdag",
  "nodag",
  "nldag",
  "frjour",
  "esdia",
  "fipiv",
  NULL
};
char *msg_days[] = {
  "endays",
  "dadage",
  "svdagar",
  "nodager",
  "nldagen",
  "frjours",
  "esdias",
  "fipiv",
  NULL
};
char *msg_month[] = {
  "enmonth",
  "damned",
  "svmnad",
  "nomned",
  "nlmaand",
  "frmois",
  "esmes",
  "fikuukausi",
  NULL
};
char *msg_months[] = {
  "enmonths",
  "damneder",
  "svmnader",
  "nomneder",
  "nlmaanden",
  "frmois",
  "esmeses",
  "fikuukautta",
  NULL
};
/* ---- **** ---- */

char *msg_split_ago[] = {
  "en%s split %s ago%s",
  "da%s splittede for %s siden%s",
  "sv%s delades fr %s sedan%s",
  "no%s deltes for %s siden%s",
  "nl%s split %s geleden%s",
  "fr%s split %s vla %s",
  "es%s se fue en split con %s hace %s",
  "fi%s splittasi %s sitten%s",
  NULL
};
char *msg_split_partly_healed[] = {
  "en (partly healed)",
  "da (delvist helet)",
  "sv (delvis lagad)",
  "no (delvis fikset)",
  "nl (gedeeltelijk hersteld)",
  "fr (pratiquement rtabli)",
  "es (medio curado)",
  "fi (osittain parantunut)",
  NULL
};
char *msg_last_netsplit[] = {
  "enLast netsplit occured %s ago.",
  "daSidste netdeling skete for %s siden.",
  "svSenaste ntdelning intrffade fr %s sedan.",
  "noSiste nettsplitt skjedde for %s siden.",
  "nlLaatste netsplit gebeurde %s geleden.",
  "frLe dernier netsplit est arriv vla %s.",
  "esEl ultimo NETSPLIT ocurrio hace %s.",
  "fiViimeisin netsplit tapahtui %s sitten.",
  NULL
};
char *msg_no_netsplits[] = {
  "enNo netsplits since I started %s ago",
  "daIngen netdeling siden jeg blev startet for %s siden",
  "svInte en ntdelning sen jag startade fr %s sedan",
  "noIngen nettsplitt siden jeg ble startet for %s siden",
  "nlGeen netsplits sinds dat ik %s startte",
  "frY'a pas eu de netsplit depuis que je suis en fonction, il y a %s de a",
/* rek2 */
  "esNo ha habido ningun NETSPLIT desde que estoy en el canal since %s",
  "fiEi netsplittej kynnistykseni jlkeen, %s sitten",
  NULL
};
char *msg_never_seen[] = {
  "enI have never seen '%s'",
  "daJeg har aldrig set '%s'",
  "svJag har aldrig sett '%s'",
  "noJeg har aldri sett '%s'",
  "nlIk heb '%s' nog nooit gezien",
  "frJ'ai jamais vu '%s'",
  "esNunca he visto por aqui a '%s'",
  "fiEn ole koskaan nhnyt nikki '%s'",
  NULL
};
char *msg_yes_i_am_here[] = {
  "enYes, I am here.",
  "daJa, jeg er her.",
  "svJa, jag r hr.",
  "noJa, jeg er her.",
  "nlJa, ik ben hier.",
  "frOui je suis ici.",
  "esSi!! estoy aqui.",
  "fiJoo, olenhan min tll.",
  NULL
};
char *msg_yes_i_see_you[] = {
  "enYeah, I see you. Boy, you're ugly ;)",
  "daJa, jeg ser dig. Nj hvor ser du grim ud ;)",
  "svJa, jag ser dig. Usch vad du ser ut ;)",
  "noJa, jeg ser deg. Og fy som du ser ut ;)",
  "nlJa, ik zie je. Gosh, ben jij lelijk ;)",
  "frOui je te vois. Maudit cliss que t laid ;)",
  "esSi!! te veo .pero hombre ... eres horrible! ;)",
  "fiNen sinut vhn liiankin hyvin, eik kyll ole mikn miellyttv nky ;)",
  NULL
};

/* --- seen stuff --- */
char *msg_seenleave[] = {
  "en%s (%s) left the channel %s ago%s%s%s",
  "sv%s (%s) lmnade kanalen fr %s sedan%s%s%s",
  "da%s (%s) forlod kanalen for %s siden%s%s%s",
  "de%s (%s) hat den Kanal vor %s verlassen%s%s%s",
  "es%s (%s) se marcho hace %s%s%s%s",
  "fi%s (%s) lhti kanavalta %s sitten%s%s%s",
  NULL
};

char *msg_seenquit[] = {
  "en%s (%s) signed off %s ago (%s)",
  "da%s (%s) forsvandt for %s siden (%s)",
  "sv%s (%s) hoppade av fr %s sedan (%s)",
  "no%s (%s) hoppet av for %s siden (%s)",
  "nl%s (%s) stopte %s geleden (%s)",
  "fr%s (%s) a quitt il y a %s (%s)",
/* rek2 */
  "es%s (%s) Se marcho hace %s ago (%s)",
  "fi%s (%s) poistui ircist %s sitten (%s)",
  NULL
};
char *msg_seenkick[] = {
  "en%s (%s) was kicked off the channel %s ago by %s (%s)",
  "da%s (%s) blev sparket af kanalen for %s siden af %s (%s)",
  "sv%s (%s) sparkades av kanalen fr %s sedan av %s (%s)",
  "no%s (%s) ble sparket ut av kanalen for %s siden av %s (%s)",
  "nl%s (%s) werd van het kanaal getrapt %s door %s (%s)",
  "fr%s (%s)  t kick hors du canal il y a %s par %s (%s)",
  "es%s (%s) fue pateado del canal hace %s por %s (%s)",
  "fi%s (%s) potkaistiin kanavalta %s sitten %s:n toimesta (%s)",
  NULL
};
char *msg_seenleft[] = {
  "en%s (%s) was still on the channel when I left %s ago",
  "da%s (%s) var stadig p kanalen da jeg forlod den for %s siden",
  "sv%s (%s) var kvar p kanalen nr jag stack fr %s sedan",
  "no%s (%s) var fortsatt p kanalen da jeg stakk for %s siden",
  "nl%s (%s) was nog steeds op het kanaal toen ik het %s geleden verliet",
  "fr%s (%s) tais encore sur le canal quand j'ai quitt il y a %s",
  "es%s (%s) Seguia en el canal cuando me marche hace %s",
  "fi%s (%s) oli paikalla kun lhdin kanavalta %s sitten",
  NULL
};
char *msg_seenquited[] = {
  "en%s (%s) was still on the channel when I signed off %s ago",
  "da%s (%s) var stadig p kanalen da jeg forsvandt for %s siden",
  "sv%s (%s) var kvar p kanalen nr jag hoppade av fr %s sedan",
  "no%s (%s) var fortsatt p kanalen da jeg hoppet av for %s siden",
  "nl%s (%s) was nog steeds op het kanaal toen ik %s geleden stopte",
  "fr%s (%s) tais encore sur le canal quand j'ai quitt il y a %s",
  "es%s (%s) seguia en el canal cuando me cai hace como %s",
  "fi%s (%s) oli viel kanavalla kun poistuin ircist %s sitten",
  NULL
};
char *msg_seenkicked[] = {
  "en%s (%s) was still on the channel when I was kicked %s ago by %s",
  "da%s (%s) var stadig p kanalen da jeg blev sparket ud for %s siden af %s",
  "sv%s (%s) var kvar i kanalen nr jag sparkades ut fr %s sedan av %s",
  "no%s (%s) var fortsatt p kanalen da jeg ble sparket ut for %s siden av %s",
  "nl%s (%s) was nog steeds op het kanaal toen ik %s geleden gekicked door %s",
/* frenchize */
  "fr%s (%s) tais encore sur le canal quand j'ai t kick il y a %s %s",
  "es%s (%s) Seguia en el canal cuando fuy pateado hace %s por %s",
  "fi%s (%s) oli paikalla kun minut potkaistiin kanavalta %s sitten %s:n"
  " toimesta",
  NULL
};
char *msg_seenchange[] = {
  "en%s (%s) changed nick %s ago",
  "da%s (%s) skiftede nick for %s siden",
  "sv%s (%s) bytte nick fr %s sedan",
  "no%s (%s) byttet nick for %s siden",
  "nl%s (%s) veranderde nick %s geleden",
  "fr%s (%s)  changer de nick il y a %s",
  "es%s (%s) cambio el nick hace %s",
  "fi%s (%s) vaihtoi nikki %s sitten",
  NULL
};

char *msg_defpass_done[] = {
  "enPassword for '%s' has been changed to default",
  "daPassword for '%s' er ndret til default",
  "sv%ss lsenord har ndrats till default",
  "no%ss passord har blitt endret til default",
  "nlWachtwoord van '%s' is veranderd naar het default wachtwoord",
  "frMot de passe pour '%s'  t changer pour celui par dfaut",
  "esEl password '%s' ha sido puesto por defecto",
  "fiKyttjn '%s' salasana on asetettu oletusarvoiseksi",
  NULL
};
char *msg_defpass_inform[] = {
  "enDefault password \"%s\" installed. Please install a new with NEWPASS",
  "daDefalut password \"%s\" installeret. ndr det venligst med NEWPASS",
  "svDefault-lsenordet \"%s\" har satts. Bestm ett nytt med NEWPASS",
  "noDefault-passordet \"%s\" har blitt satt. Velg et nytt med NEWPASS",
  "nlDefault wachtwoord \"%s\" geinstalleerd. S.v.p. installeer een nieuw wachtwoord met NEWPASS",
  "frMot de passe par dfaut \"%s\" install. SVP installer un nouveau avec NEWPASS",
  "esEl password instalado por defecto es \"%s\" . por favor instala uno nuevo con el comando NEWPASS",
  "fiSalasanasi on asetettu oletusarvoiseksi: \"%s\". Vaihda salasanasi"
  " vlittmsti NEWPASS komennolla",
  NULL
};
char *msg_comment_removed[] = {
  "enComment for %s removed",
  "daKommentar for %s removed",
  "svKommentar fr %s borttagen",
  "noKommentar for %s removed",
  "nlKommentaar for %s removed",
  "frCommentaires for %s removed",
  "esLos Comentarios para %s han sido removidos",
  "fiKyttjn %s kommentti poistettu",
  NULL
};
char *msg_comment_set[] = {
  "enComment for %s set to '%s'",
  "daKommentar for %s sat til '%s'",
  "svKommentar till %s satt till '%s'",
  "noKommentar for %s satt til '%s'",
  "nlKommentaar for %s is nu '%s'",
  "frCommentaires le %s fix  '%s'",
  "esComentario para %s puesto a '%s'",
  "fiKyttjn %s kommentti on nyt '%s'",
  NULL
};
char *msg_youre_not_registered[] = {
  "enSorry, you're not a registered user",
  "daDu er desvrre ikke en registreret bruger",
  "svTyvrr, du r inte en registrerad anvndare",
  "noDessverre, du er ikke en registrert bruker",
  "nlSorry, je bent niet een geregistreerde gebruiker",
  "frDsol, tu n'es pas un utilisateur enregistr",
  "esLo siento no eres un usuario registrado",
  "fiSori, et ole rekisterity kyttj",
  NULL
};
char *msg_no_registered_user[] = {
  "enThere is no registered user using nick '%s'",
  "daDer er ingen registreret bruge som anvender nick '%s'",
  "svDet finns ingen registrerad anvndare med nick '%s'",
  "noDet finnes ingen registrerte brukere med nick '%s'",
  "nlEr is geen geregistreerde gebruiker die nick '%s' gebruikt",
  "frIl n'y a pas d'utilisateur enregistr qui utilise le nick '%s'",
  "esNo hay ningun usuario registrado usando como nick '%s'",
  "fiRekisterity kyttj '%s' ei ole olemassa",
  NULL
};
char *msg_cant_undo_delete[] = {
  "enNo delete to undo!",
  "daIngen sletning at omstde!",
  "svIngen radering finns att f ogjord!",
  "noIngen sletting  gjre om!",
  "nlGeen verwijdering voor undo!",
  "frPas d'enlvement  dfaire!",
  "esNo se puede recobrar un borrado!!",
  "fiEt voi peruuttaa poistoa jota ei ole tehty!",
  NULL
};
char *msg_no_longer_deleted[] = {
  "enUser %s is no longer marked for delete.",
  "daBruger %s er ikke markeret til sletning lngere.",
  "svAnvndaren %s r inte lngre markerad fr radering.",
  "noBrukeren %s er ikke markert for sletting lenger.",
  "nlGebruiker %s is niet langer gemarkeerd voor verwijdering.",
  "frL'utilisateur %s n'est plus marquer pour tre enlever.",
  "esEl usuario %s ha dejado de estar asignado para ser borrado.",
  "fiKyttj %s ei ole en merkitty poistettavaksi.",
  NULL
};
char *msg_already_deleted[] = {
  "enThe user is already marked for deletion!",
  "daBrugeren er allerede markeret til sletning!",
  "svAnvndaren r redan markerad fr radering!",
  "noBrukeren er allerede markert for sletting!",
  "nlDe gebruiker is reeds gemarkeerd voor verwijdering!",
  "frL'utilisateur est dj sur la liste a enlever!",
  "esEl usuario ya esta asignado para ser borrado!",
  "fiKyttj on jo merkitty poistettavaksi!",
  NULL
};
char *msg_userdel_inform[] = {
  "enYou were just marked for deletion by %s.",
  "daDu er netop blevet markeret til sletning af %s.",
  "svDu blev just markerad fr radering av %s.",
  "noDu ble akkurat markert for sletting av %s.",
  "nlJe bent zojuist gemerkt voor verwijdering door %s.",
  "frTu viens d'tre marqu pour tre enlever par %s.",
  "esAcabas de ser asignado para ser borrado por %s.",
  "fi%s merkitsi sinut juuri poistettavaksi kyttjlistaltani.",
  NULL
};
char *msg_userdel_done[] = {
  "enUser %s is marked for deletion%s!",
  "daBruger %s er markeret til sletning%s!",
  "sv%s r nu markerad fr radering%s!",
  "no%s er n markert for sletting%s!",
  "nlGebruiker %s is gemarkeerd voor verwijdering%s!",
  "frL'utilisateur %s  t marquer pour tre enlever%s!",
  "esEl usuario %s esta asignado para el borrado%s!",
  "fiKyttj %s merkittiin poistettavaksi kyttjlistalta%!",
  NULL
};
char *msg_and_informed[] = {
  "en and informed",
  "sv och informerad",
  "da og informeret",
  "no og informert",
  "nl en geinformeerd",
  "fr et inform",
  "es y informado",
  "fi ja hnelle kerrottiin asiasta",
  NULL
};
char *msg_ident_forbidden[] = {
  "enThe use of this command has been explicitly forbidden",
  "daBrugen af denne kommando er forbudt",
  "svAnvndandet av detta kommando har frbjudits",
  "noBruken av denne kommandoen har blitt forbudt",
  "nlHet gebruik van dit kommando is expliciet verboden",
  "frL'utilisation de cette commande  t strictement dfendu",
  "esEl uso de este comando a sido explicitamente prohibido!",
  "fiTmn komennon kytt on kielletty",
  NULL
};
char *msg_ident_defpass[] = {
  "enChange your password! You are still using the default password. This is"
  " insecure and dangerous. Use the NEWPASS command right now!",
  "dandr password! Du bruger stadigvk default password. Det er usikkert og farligt.",
  "svByt lsenord! Du anvnder fortfarande default-lsenordet. Detta r oskert och farligt.",
  "noBytt passord! Du bruker fortsatt standard-passordet. Dette er usikkert og farlig.",
  "nlVerander je wachtwoord! Je gebruikt nog steeds je default wachtwoord. Dit is onveilig en gevaarlijk.",
  "frChanges ton mot de passe! Tu utilise encore celui par dfaut.Cela n'est pas scure.",
  "esCambia tu password!!! sigues usando el password por defecto, es inseguro y peligroso.",
  "fiVaihda salasanasi! Kytt vielkin oletusarvoista salasanaa, joka on"
  " erittin turvatonta ja vaarallista. Kyt NEWPASS komentoa vlittmsti!",
  NULL
};
char *msg_ident_noauth[] = {
  "enYou are trying to authenticate with the default password. This is insecure and dangerous. Change your password first!",
  "daDu forsger at identificere dig med default password. Det er usikkert og farligt. ndr dit password frst!",
  "svDu frsker identifiera dig med default-lsenordet. Det r oskert och farligt. Byt lsenord frst!",
  "noDu forsker  identifisere deg med standard-passordet. Det er usikkert og farlig. Bytt passord frst!",
  "nlJe tracht je te identificeren met je default wachtwoord. Dit is onveilig en gevaarlijk. Verander je wachtwoord eerst!",
  "frTu essayes de t'authentifier avec le mot de passe par dfaut. C'est inscure et dangeureux. Change ton mot de passe avant!",
  "esEstas intentando identificarte con el password por defecto. esto es inseguro y peligroso. Cambia tu password lo primero!!! por favor",
  "fiYritt todistaa henkilllisyytesi kytten oletusarvoista salasanaa."
  " Tm on erittin turvatonta ja vaarallista. Vaihda salasanasi ensin!",
  NULL
};
char *msg_ident_already_known[] = {
  "enYou are already identified as a known user. You cannot IDENT.",
  "svDu r redan identifierad som en knd anvndare och kan drfr inte"
  " anvnda IDENT.",
  "esYa estas identificado como un usuario conocido. No puedes usar IDENT.",
  "fiSinut tunnistetaan jo kyttjksi. Et voi kytt IDENT komentoa.",
  NULL
};

char *msg_email_set[] = {
  "enEmail for %s set to '%s'",
  "daEmail for %s er sat til '%s'",
  "svEpost fr %s satt till '%s'",
  "noEmail for %s satt til '%s'",
  "nlEmail voor %s is nu '%s'",
  "frEmail for %s fix  '%s'",
  "esEmail for %s puesto a '%s'",
  "fiKyttjn %s email on nyt '%s'",
  NULL
};
char *msg_email_address[] = {
  "en%s's email address: %s",
  "da%s's email adresse: %s",
  "sv%ss epost-adress: %s",
  "no%s sin email-adresse: %s",
  "nl%s's email adres: %s",
  "frL'adresse email de %s: %s",
  "esEl email de %s es: %s",
  "fiKyttjn %s email osoite: %s",
  NULL
};
char *msg_no_information[] = {
  "en<Information missing>",
  "da<Information mangler>",
  "sv<Information saknas>",
  "no<Informasjon mangler>",
  "nl<Informatie vermist>",
  "fr<Information manquante>",
  "es<Falta informacion>",
  "fi<Tieto puuttuu>",
  NULL
};
char *msg_unknown_user[] = {
  "enUnknown user",
  "daUkendt bruger",
  "svOknd anvndare",
  "noUkjent bruker",
  "nlGebruiker onbekend",
  "frUtilisateur inconnu",
  "esUsuario desconocido",
  "fiTuntematon kyttj",
  NULL
};

char *msg_chat_mode_on[] = {
  "enChat mode is on. Prepend all commands with '%c' (like %cCMD)."
  " Use %chelp for CHAT help.",
  "daChat mode er til. Start alle kommanoder med '%c' (f.eks. %cCMD)."
  " Brug %chelp for hjlp om CHAT.",
  "svChat mode r pslaget. Inled alla kommandon med '%c' (t.ex %cCMD)."
  " Anvnda %chelp fr hjlp om CHAT.",
  "noChat mode er p- Start alle kommandoer med %s (f.eks. %cCMD)."
  " Bruk %chelp for hjelp om CHAT.",
  "nlChat mode is aan. Alle kommandos dienen met '%c' vooraf te worden gegaan (zoals %cCMD). Gebruik %chelp"
  " voor CHAT help.",
  "frLe mode chat est on. Faites prcder toutes les commandes de '%c' (comme %cCMD)."
  " Utilise %chelp pour l'aide de CHAT.",
  "esEl modo charla ha sido encendido. pon delante de todos los comandos '%c' (por ejemplo %cCMD)."
  " Utiliza %chelp para ayuda en el estado de charla.",
  "fiChatti moodi on nyt pll. Edell kaikki komennot '%c' -merkill"
  " (kuten %cCMD). '%chelp' antaa apua CHAT moodiin.",
  NULL
};

char *msg_joined_chat[] = {
  "en%s has joined the chat",
  "da%s er kommet p chat",
  "sv%s har anslutit sig till chatten",
  "no%s har blitt med i chaten",
  "nl%s heeft het kanaal gejoined",
  "fr%s  rejoin le chat",
  "es%s se ha unido a la charla",
  "fi%s liittyi chattiin",
  NULL
};

char *msg_already_client[] = {
  "enYou already have a client connection",
  "daDu har allerede en klient forbindelse",
  "svDu har redan en client-koppling",
  "noDu har allerede en klient-kobling",
  "nlJe hebt reeds een client connectie",
  "frT'as dj une connection client",
  "esActualmente ya tienes una conexion",
  "fiSinulla on jo DCC chat yhteys kanssani",
  NULL
};

char *msg_no_change_done[] = {
  "enNo change done",
  "daIngen ndring udfrt",
  "svIngen ndring utfrd",
  "noIngen endringer utfrt",
  "nlGeen verandering aangebracht",
  "frPas de changement fait",
  "esNo se ha realizado ningun cambio",
  "fiEi muutosta",
  NULL
};
char *msg_user_modified[] = {
  "enUser %s was modified%s",
  "daBruger %s blev ndret%s",
  "svAnvndaren %s ndrades%s",
  "noBrukeren %s ble endret%s",
  "nlGebruiker %s is veranderd%s",
  "frL,utilisateur %s  t modifi%s",
  "esEl usuario %s ha sido modificado a %s",
  "fiKyttjn %s tietoja muutettiin%s",
  NULL
};
char *msg_modified_inform[] = {
  "enYour userdata was just modified by %s.",
  "daDine brugerdata er netop blevet ndret af %s.",
  "svDin anvndardata ndrades just av %s.",
  "noDine brukerdata ble akkurat endret av %s.",
  "nlJe gebruikers informatie was zojuist veranderd door %s.",
  "frTon userdata viens d'tre modifi par %s.",
  "esTus datos hacaban de ser modificados por %s.",
  "fi%s muutti kyttjtietojasi.",
  NULL
};
char *msg_nick_no_pattern[] = {
  "enPattern %s wasn't found for user %s",
  "daMnstret %s blev ikke fundet for %s",
  "svMnstret %s hittades inte fr %s",
  "noMnsteret %s ble ikke funnet for %s",
  "nlPattern %s werd niet gevonden voor gebruiker %s",
  "frModle %s n'as pas t trouver pour l'utilisateur %s",
  "esEl patron %s no ha sido encontrado para el usuario %s",
  "fiMaskia %s ei lytynyt kyttjlle %s",
  NULL
};
char *msg_nick_in_use[] = {
  "en%s is already in use",
  "da%s anvendes allerede",
  "sv%s anvnds redan",
  "no%s brukes allerede",
  "nl%s wordt reeds gebruikt",
  "fr%s est dj utilis",
  "es%s ya esta en uso",
  "fi%s on jo kytss",
  NULL
};
char *msg_user_already_level[] = {
  "en%s is already at level %d!",
  "da%s er allerede p niveau %d!",
  "sv%s r redan p niv %d!",
  "no%s er allerede p niv %d!",
  "nl%s is reeds op niveau %d!",
  "fr%s est dj au niveau %d!",
  "es%s ya esta en el nivel %d",
  "fi%s on jo tasolla %d!",
  NULL
};
char *msg_cant_change_higher_user[] = {
  "enCan't change higher or equal level users",
  "daKan ikke ndre bruger p samme eller hjere niveau",
  "svKan inte ndra anvndare p hgre eller samma niv",
  "noKan ikke endre brukere p hyere eller samme niv",
  "nlKan hogere of dezelfde niveaus niet veranderen",
  "frNe peux pas changer d'utilisateur de niveau suprieur ou gal",
  "esNo puedes cambiar usuarios de igual o mayor nivel",
  "fiEt voi muuttaa samalla tai korkeammalla tasolla olevia kyttji",
  NULL
};
char *msg_illegal_pattern[] = {
  "enIllegal pattern (%s)!",
  "daIllegalt mnster (%s)!",
  "svIllegalt mnster (%s)!",
  "noUlovlig mnster (%s)!",
  "nlOngeldig pattern (%s)!",
  "frModle illgal (%s)!",
  "esPatron ilegal (%s)!!!!",
  "fiLaiton maski (%s)!",
  NULL
};
char *msg_cant_add_current_to_offline[] = {
  "enCan't add current host to an off-channel user!",
  "daKan ikke tilfje nuvrende mnster til en bruger der ikke er p"
  " kanalen!",
  "svKan inte addera nuvarande mnster till en anvndare som inte r i"
  " kanalen!",
  "noKan ikke legge til nvrende mnster til en bruker som ikke er p"
  " kanalen!",
  "nlKan huidige host niet toevoegen voor een buiten het kanaal gebruiker!",
  "frNe peux pas ajouter le host pour une personne qui n'est pas sur le canal!",
  "esNo puedo agragar el host dado a un usuario no presente en el canal!!!",
  "fiEn voi list nykyist osoitetta kanavan ulkopuolisille kyttjlle!",
  NULL
};

char *msg_no_nick[] = {
  "enNo nick specified!",
  "daIntet nick er angivet",
  "svInget nick angivet!",
  "noIngen nick angitt!",
  "nlGeen nick gespecificeerd!",
  "frPas de nick spcifi!",
  "esNo se ha especificado ningun nick!",
  "fiNikki ei mritelty!",
  NULL
};

char *msg_im_on_server[] = {
  "enI'm on %s",
  "daJeg er p %s",
  "svJag r p %s",
  "noJeg er p %s",
  "nlIk gebruik %s",
  "frJe suis sur %s",
  "esEstoy en %s",
  "fiOlen serverill %s",
  NULL
};
char *msg_unknown_server[] = {
  "en%d is an unknown server ID!",
  "da%d er et ukendt server-ID!",
  "sv%d r ett oknt server-ID!",
  "no%d er et ukjent server-ID!",
  "nl%d is een onbekend server ID!",
  "fr%d n'es pas un ID de serveur connu!",
  "es%d es un servidor desconocido!!!",
  "fi%d on tuntematon server-ID!",
  NULL
};
char *msg_dont_send_raw[] = {
  "enDon't send this raw. Use the appropriate command.",
  "daSend ikke dette rt. Brug den rigtige kommando.",
  "svSkicka ett det rtt. Anvnd rtt kommando.",
  "noSend ikke dette rtt. Bruk riktig kommando.",
  "nlGebruik dit niet raw. Gebruik het betreffende kommando.",
  "frNe pas envoyer ce RAW. Utiliser la commande approprie.",
  "esNo uses esto. Usa el comando apropiado.",
  "fil lhet tt raakana (raw). Kyt asianmukaista komentoa.",
  NULL
};

char *msg_no_user_matched[] = {
  "enNo user matched!",
  "daIngen bruger passede p mnstret!",
  "svIngen anvndare passade mnstret!",
  "noIngen brukere passer til mnsteret!",
  "nlGeen overeenstemmende gebruiker!",
  "frPas d'utilisateur trouver!",
  "esNo se ha encontrado ningun usuario similar",
  "fiYksikn kyttj ei vastannut hakua!",
  NULL
};
char *msg_userlist_aborted[] = {
  "en[list aborted, use -X to make longer list or refine the pattern]",
  "da[listen blev afbrudt, brug -X for at ge listen eller ndre mnstret]",
  "sv[listan avbrts, anvnd -X fr att lista ngre eller frndra mnstret]",
  "no[lista ble avbrutt, bruk -X for  lage lengre liste eller endre mnsteret]",
  "nl[lijst afgebroken, gebruik -X voor een langere lijst of herdefinieer het pattern]",
  "fr[liste avorte, utilise -X pour le rendre plus longue ou rafine ta recherche]",
  "es[lista abortada, usa -X para hacer una lista mayor o redefinir el patron]",
  "fi[listan tulostus keskeytetty, kyt -X optiota jos haluat pidemmn"
  " listan tai kyt sopivaa maskia]",
  NULL
};
char *msg_no_user_to_unban[] = {
  "enThere is no %s to unban!",
  "daDer er ingen %s at unbanne!",
  "svDet finns ingen %s att 'unbanna'!",
  "noDet finnes ingen %s  unbanne!",
  "nlEr is geen %s om te unbannen!",
  "frIl n'y a pas %s a unban!",
  "esNo existe %s para desbanear",
  "fiEi lydy nikki %s joka unbannata",
  NULL
};
char *msg_no_such_ban[] = {
  "enThere's no such ban.",
  "daDer findes ikke en sdan ban.",
  "svDet finns ingen sdan bannlysning.",
  "noDet finnes ingen slik bannlysning.",
  "nlDeze ban bestaat niet.",
  "esNo existe ese Ban.",
  "fiSellaista bannia ei ole olemassa.",
  NULL
};
char *msg_changed_the_ban[] = {
  "enchanged the %s (%s) ban",
  "dandrede %s (%s) bannen",
  "svndrade %s (%s) bannlysningen",
  "noendret %s (%s) bannlysningen",
  "nlveranderde de %s (%s) ban",
  "frA chang le ban %s (%s)",
  "esCambiado el ban %s (%s)",
  "fibanni %s (%s) muutettiin",
  NULL
};

char *msg_channel_modes[] = {
  "enChannel modes are: %s",
  "daKanalens modes er: %s",
  "svKanalens modes r: %s",
  "noKanalens tilstander er: %s",
  "nlKanaal modes zijn: %s",
  "frLes modes du canal sont: %s",
  "esLos modos del canal son: %s",
  "fiKanavan moodit ovat: %s",
  NULL
};
char *msg_no_channel_modes[] = {
  "enNo channel modes set",
  "daIngen mode sat for kanalen",
  "svIngen mode r satt i kanalen",
  "noIngen tilstander er satt p kanalen",
  "nlGeen kanaal modes gezet",
  "frPas de modes de canal fix",
  "esNo hay modos para el canal puestos",
  "fiEi moodeja asetettu",
  NULL
};
char *msg_channel_key[] = {
  "enCurrent channel key is '%s' (should be '%s')",
  "daNuvrende kanalngle er '%s' (burde vre '%s')",
  "svNuvarande kanalnyckel r '%s' (borde vara '%s')",
  "noNvrende kanalnkkel er '%s' (burde vre '%s')",
  "nlHuidige kanaal sleutel is '%s' (zou '%s' moeten zijn)",
  "frLe key du canal est prsentement '%s' ( devrait-tre '%s')",
  "esEl key actual del canal es '%s' (deberia de ser '%s')",
  "fiKanavan tmnhetkinen avain on '%s' (pitisi olla '%s')",
  NULL
};

char *msg_say_is_off[] = {
  "enSAY is set to off, can't do this now!",
  "daSAY er slet fra, kan ikke gre det nu!",
  "svSAY r avslaget, kan inte gra detta nu!",
  "noSAY er sltt av, kan ikke gjre det n!",
  "nlSAY is uitgezet, ik kan dit nu niet doen!",
  "frSAY est fix a off, peux pas faire a maintenant!",
  "esSAY esta apagado, ahora no puedo hacerlo!!!",
  "fiSAY on pois plt, en voi suorittaa komentoa!",
  NULL
};
char *msg_talk_on[] = {
  "enThanks %s, I'll try to talk now",
  "daTak %s, jeg vil forsge at tale nu",
  "svTack %s, jag ska frska prata nu",
  "noTakk %s, jeg skal prve  prate n",
  "nlBedankt %s, ik zal nu proberen te praten",
  "frMerci %s, Je vais essayer de parler  prsent",
  "esGracias %s, Intentare hablar ahora",
  "fiKiitos %s, yritn puhua nyt..",
  NULL
};
char *msg_talk_already[] = {
  "enI'm already talkative",
  "daJeg er allerede snaksalig",
  "svJag r redan snacksalig",
  "noJeg er allerede snakkesalig",
  "nlIk ben al spraakzaam",
  "frJe parle dj",
  "esYa estoy hablando activamente",
  "fiOlenhan jo puhelias!",
  NULL
};
char *msg_quiet_on[] = {
  "enOk %s, I'll shut up now",
  "daOk %s, jeg holder mund nu",
  "svOk %s, jag hller tyst nu",
  "noOk %s, jeg holder kjeft fra n av",
  "nlOk %s, ik zal nu stil zijn",
  "frOK %s, J'me la ferme",
  "esOK %s, ya dejo de hablar",
  "fiOK %s, olen hiljaa",
  NULL
};
char *msg_quiet_already[] = {
  "enI'm already quiet",
  "daJeg er allerede stille",
  "svJag r redan tyst",
  "noJeg er allerede stille",
  "nlIk ben al stil",
  "frJe suis dj silencieux",
  "esYa estoy callado!!!",
  "fiOlen hiljaa jo",
  NULL
};
char *msg_mute_talkative[] = {
  "enI was instructed to be absolutely silent",
  "daJeg blev bedt om at vre helt stille",
  "svJag blev instruerad att vara helt tyst",
  "noJeg ble bedt om  vre helt stille",
  "nlIk werd verteld om absoluut stil te zijn",
  "frOnt m'as demand d'tre compltement silencieux",
  "esHe sido ordenado a estar totalmente calladito",
  "fiMinun kskettiin olla tysin hiljaa",
  NULL
};
char *msg_mute_grave[] = {
  "enSilent as the grave",
  "daStille som graven",
  "svTyst som i graven",
  "noStille som i graven",
  "nlZo stil als een muis",
  "frSilencieux comme une tombe",
  "esCallado hasta la tumba!",
  "fiEhdottoman hiljainen!",
  NULL
};

char *msg_lag[] = {
  "enLast measured lag to %s was %d.%03d seconds",
  "daSidste mlte forsinkelse til %s var %d.%03d sekunder",
  "svSenast uppmtt frdrjning till %s var %d.%03d sekunder",
  "noSiste mlte forsinkelse til %s var %d.%03d sekunder",
  "nlLaatst waargenomen vertraging naar %s was %d.%03d seconden",
  "frLe dernier lag mesur de %s tais %d.%03d secondes",
  "esLa ultima medida de lag con %s fue de %d.%03d segundos",
  "fiViimeksi mitattu lagi serveriin %s oli %d.%03d sekuntia",
  NULL
};
char *msg_no_info_for_toplist[] = {
  "en<insufficient data for toplist>",
  "da<utilstrkkelig data til toplisten>",
  "sv<otillrckligt med data fr topplista>",
  "no<manglende data for toppliste>",
  "nl<onvoldoende gegevens voor toplijst>",
  "fr<information insuffisante pour toplist>",
  "es<Datos insuficientes para el toplist>",
  "fi<ei riittvsti tietoa toplistaa varten>",
  NULL
};


char *msg_need_pattern_offchannel[] = {
  "enI need a pattern for off-channel addings!",
  "daJeg behver et mnster til at tilfje folk som ikke er p kanalen!",
  "svJag behver ett mnster fr att addera folk som inte r i kanalen!",
  "noJeg behver et mnster for  legge til folk som ikke er p kanalen!",
  "nlIk heb een pattern nodig voor buiten het kanaal toevoegingen!",
  "frJ'ai besoin d'un modle pour les ajouts hors connections!",
  "esNecesito un patron para poder agregar usuarios que no estan en el canal!",
  "fiTarvitsen maskin kanavan ulkopuolisiin lisyksiin!",
  NULL
};
char *msg_another_nick_added[] = {
  "enAnother user with nick %s is already added",
  "daEn anden bruger med registreret nick %s findes allerede",
  "svEn annan anvndare med registrerad nick %s finns redan",
  "noEn annen bruker med registrert nick %s finnes allerede",
  "nlEen andere gebruiker met nick %s bestaat reeds",
  "frUn autre utilisateur avec le nick %s est dj ajout",
  "esYa hay un usuario con el nick %s",
  "fiToinen kyttj on jo rekisterity nikill %s",
  NULL
};
char *msg_already_added[] = {
  "en%s is already added",
  "da%s er allerede tilfjet",
  "sv%s r redan inlagd",
  "no%s er allerede lagt inn",
  "nl%s is reeds toegevoegd",
  "fr%s est dj ajout",
  "es%s ya esta agregado",
  "fi%s on jo listty",
  NULL
};
char *msg_added_inform[] = {
  "enYou were just added with level %d, pattern %s. Try CMD and HELP for info."
  " Your initial password is '%s'.",
  "daDu er netop blevet tilfjet med niveau %d, mnster %s. Brug CMD og"
  " og HELP for yderligere information. Dit password er '%s'.",
  "svDu blev just inlagd med niv %d, mnster %s. Prova CMD och HELP fr info."
  " Ditt lsenord r '%s'.",
  "noDu ble akkurat lagt inn med niv %d, mlnster %s. Prv CMD og HELP for info."
  " Ditt passord er '%s'.",
  "nlJe bent zojuist toegevoegd met niveau %d, pattern %s. Probeer CMD of HELP voor informatie."
  " Jouw initiele wachtwoord is '%s'.",
  "frTu viens d'tre ajout avec le niveau %d, modle %s. Essayes CMD et HELP pour"
  " plus d'information. Ton mot de passe initial est '%s'.",
  "esHa sido agragado al bot con nivel %d, patron %s. Utiliza CMD y HELP para mas informacion."
  " tu password inicial es '%s'"
  " cambialo por uno nuevo en cuanto antes porfavor con el comando (newpass)",
  "fiSinut listtiin juuri kyttjlistalleni. Tasosi on %d, maskisi %s ja"
  " salasanasi '%s'. CMD ja HELP komennot antavat lisapua."
  " Vaihda salasanasi NEWPASS komennolla, kiitos.",
  NULL
};
char *msg_user_added[] = {
  "enUser %s, level %d, pattern %s added%s%s!",
  "daBruger %s, niveau %d, mnster %s er tilfjet%s%s!",
  "svAnvndaren %s, niv %d, mnster %s lades in%s%s!",
  "noBrukeren %s, niv %d, mnster %s ble lagt inn%s%s!",
  "nlGebruiker %s, niveau %d, pattern %s toegevoegd%s%s!",
  "frL'utilisateur %s, niveau %d, modle %s ajout%s%s!",
  "esEl usuario %s, con nivel %d, y patron %s ha sido agragado en%s%s!",
  "fiKyttj %s, taso %d, maski %s listty,%s%s!",
  NULL
};
char *msg_with_nondefault_password[] = {
  "en with non-default password",
  "da med ikke-default password",
  "sv med icke-default lsenord",
  "no med ikke-default passord",
  "nl met geen-default wachtwoord",
  "fr sans le mot-de-passe par dfaut",
  "es Sin ningun password por defecto",
  "fi salasana ei ole oletusarvoinen,",
  NULL
};

char *msg_language_set_to[] = {
  "enYour preferred language has been set to '%s'",
  "daDit foretrukne sprog er nu sat til '%s'",
  "svDitt valda sprk r nu satt till '%s'",
  "noDitt valgte sprk er n satt til '%s'",
  "nlJouw voorkeurs taal is ingesteld op '%s'",
  "frVotre langage par dfaut  t fix  '%s'",
  "esTu lenguaje por defecto a sido cambiado a '%s'",
  "fiEnsisijainen kielesi on nyt '%s'",
  NULL
};
char *msg_language[] = {
  "enLanguage:",
  "daSprog:",
  "svSprk:",
  "noSprk:",
  "nlTaal:",
  "frLangue:",
  "eslengua:",
  "fiKieli:",
  NULL
};
char *msg_flags[] = {
  "enFlags:",
  "daFlag:",
  "svFlaggor:",
  "noFlagg:",
  "nlVlaggen:",
  "frFlags:",
  "esFlags:",
  "fiLiput:",
  NULL
};

/* END OF du TRANSLATED PHRASES */

char *msg_cant_use_in_public[] = {
  "enCan't use this command in public",
  "daKan ikke anvende denne kommand p kanalen",
  "svKan inte anvnda detta kommando publikt",
  "noKan ikke bruke denne kommandoen offentlig",
  "frPeux pas utiliser cette commande en public",
  "esNo se puede usar este comando en publico!",
  "fiTt komentoa ei voi kytt julkisesti",
  NULL
};

char *msg_illegal_name[] = {
  "enIllegal host/domain name",
  "daIllegalt host-/domnenavn",
  "svIllegalt host-/domnnamn",
  "noUlovlig host-/domenenavn",
  "frnom de host/domain invalide",
  "esNombre de Host/dominio ilegal!",
  "fiLaiton host/domain nimi",
  NULL
};

char *msg_helpset_fakename[] = {
  "enKick joiners with faked host/domain names",
  "daSpark folk som joiner med illegale host-/domnenavne",
  "svSparka folk som joinar med illegala host- eller domnnamn",
  "noSpark folk som kommer inn med ulovlige host- eller domenenavn",
  "frKick ceux qui join avec un nom de host/domain illgal",
  "esPatea recien entrados con un nombre de host/dominio falso",
  "fiPotkaisee vieraat jotka liittyvt kytten vrennettyj host/domain"
  " nimi",
  NULL
};

char *msg_topic_set[] = {
  "enTopic \"%s\" set by %s %s ago",
  "daTopic \"%s\" valgt af %s for %s siden",
  "svTopic \"%s\" sattes av %s fr %s sedan",
  "noTopic \"%s\" ble satt av %s for %s siden",
  "frTopic \"%s\" fix par %s vla %s",
  "esTopic \"%s\" puesto por %s hace %s",
  "fiTopikin \"%s\" asetti %s, %s sitten",
  NULL
};
char *msg_topic_not_set[] = {
  "enNo topic set since I joined",
  "daIntet topic sat siden jeg joinede",
  "svInget topic satt sen jag joinade",
  "noIkke no' topic siden jeg kom inn",
  "frPas eu de topic de fix depuis que je suis ici",
  "esNingun Topic puesto desde que entre...",
  "fiEi topikkia asetettu kanavalle tuloni jlkeen",
  NULL
};

/* NEWS STUFF */
char *msg_help_newsadd[] = {
  "enAdd a news item. The news will be readable by all registered users with"
  " an equal or higher level than you specify for this particular news. You"
  " can also make the news only get readable/noticed by a subset of users by"
  " using the -p pattern and you can select expire time by using the -e",

  "daTilfj en nyhed. Nyheden kan lses af alle registrede brugere med samme"
  " eller hjere niveau som det du valgte for nyheden. Du kan ogs begrnse"
  " nyheden til kun, at kunne lses af folk der passer p et bestemt mnster"
  " med -p, og du kan vlge en udlbsdato med -e",

  "svLgg till en nyhet. Nyheten kommer att vara lsbar av alla registrerade"
  " anvndare som har en niv som r lika eller hgre n den nivn du satt"
  " fr den specifika nyheten. Du kan ocks gra nyheten lsbar fr bara en"
  " del anvndare genom att anvnda -p mnster, och hur lnge nyheten ska"
  " bevaras stter du med -e",

  "noLegg til en nyhet. Oppslaget kommer til  vre lesbart av alle"
  " registrerte brukere som har et niv likt med eller hyere enn nivet du"
  " satt for den spesifikke nyheten. Du kan ogs gjre nyheten lesbar for"
  " kun enkelte brukere ved  bruke -p mnster, og hvor lenge nyheten skal"
  " bevares med -e",

  "esAgrega una nueva noticia. Las noticias podran ser leidas por todos los"
  " usuarios registrados con un nivel igual o mayor del que especificas al"
  " agragar la noticia.Tambien puedes hacer que la noticiasea leida por unos"
  " usuarios especificados usando el parametro -p y puedes poner la fecha de"
  " caducidad con -e",

  "fiLis uutisen. Uutisen voivat lukea kaikki rekisterityneet kyttjt"
  " joiden taso on yht suuri tai suurempi kuin mrittelemsi taso"
  " kyseiselle uutiselle. Voit mys rajoittaa uutisen kohderyhm"
  " kyttmll -P optiota halutun maskin kanssa, ja voit mritell"
  " ajan jolloin uutinen poistuu listalta kytten -E optiota",

  NULL
};
char *msg_help_newsdel[] = {
  "enDelete a news item. The specified news ID will be removed from the news"
  " system. You don't have to have added the news yourself to delete it."
  " If a news item isn't deleted, it will be automatically deleted after its"
  " expiration date set with NEWSADD",

  "daSletter en nyhed. Den angivne nyheds-ID vil blive fjernet. Du behver"
  " ikke have tilfjet nyheden for at kunne slette den. Hvis en nyhed ikke"
  " slettes, s vil den automatisk slettes efter den udlbstid, der blev"
  " valgt med NEWSADD",

  "svRadera en nyhet. Det angivna nyhetetsID:t tas bort frn nyhetssystemet."
  " Du behver inte ha lagt till nyheten sjlv fr att ta bort den. Om en"
  " nyhet inte raderas kommer den automatiskt att raderas efter dess livslngd"
  " som stlldes in med NEWSADD",

  "noSletter en nyhet. Det angitte oppslagets ID tas bort fra nyhetssystemet."
  " Du behver ikke  ha lagt til nyheten selv for  ta den vekk. Hvis et"
  " oppslag ikke slettes kommer det automatisk til  fjernes etter den tiden"
  " som ble stilt inn med NEWSADD",

  "esBorra una nueva entrada.El ID especificado sera removido del sistema de noticias"
  " No hace falta que seas tu quien la introdujo para poder borrarla."
  " si una noticia no es borrada, sera borrada automaticamente cuando se cumpla"
  " su fecha de caducidad puesto por el comando NEWSADD",

  "fiPoistaa uutisen. Annettu ID poistetaan uutislistalta. Voit poistaa"
  " mys muiden kirjoittamia uutisia. Mikli uutista ei poisteta"
  " manuaalisesti NEWSDEL komennolla, poistuu se automaattisesti kun"
  " NEWSADD komennon yhteydess mritelty aika kuluu umpeen",

  NULL
};
char *msg_help_newslist[] = {
  "enLists the X latest news items. Default X is 5.",
  "daViser de seneste X nyheder. Default for X er 5.",
  "svLista de X senaste nyheterna. Default X r 5.",
  "noVis de X siste nyhetene. Standard X er 5.",
  "esLista las X ultimas noticias. por defecto X es igual a 5.",
  "fiNytt X viimeist uutista. X on oletusarvoisesti 5.",
  NULL
};

char *msg_chat_mode_cmd[] = { /* 5 chatcmdchar + 1 cmdchar */
  "enCommands available in chat mode:\n"
  "%cecho  - toggles echo mode\n"
  "%chelp  - this help text\n"
  "%cme    - writes action-like lines\n"
  "%cnames - lists all locally attached chatters\n"
  "%cquit  - quit chat mode (same as '%cCHAT')",

  "daKommandoer i chat mode:\n"
  "%cecho  - slr echo til/fra\n"
  "%chelp  - denne hjlpe tekst\n"
  "%cme    - laver action-lignende linier\n"
  "%cnames - viser alle lokalt tilsluttede chatters\n"
  "%cquit  - quitter chat mode (samme som '%cCHAT')",

  "noKommandoer i chat mode:\n"
  "%cecho  - slr echo av/p\n"
  "%chelp  - denne hjelpeteksten\n"
  "%cme    - skriver action-lignende linjer\n"
  "%cnames - viser alle lokalt tilkoblede chattere\n"
  "%cquit  - avslutter chat (samme som '%cCHAT')",

  "esComandos disponibles en modo de Charla:\n"
  "%cecho  - pone el modo echo\n"
  "%chelp  - la ayuda\n"
  "%cme    - escribe lineas de accion\n"
  "%cnames - lista todos los conectados a la charla local\n"
  "%cquit  - cierra el modo de charla (igual que '%cCHAT')",

  "enKytsssi olevat komennot chat moodissa:\n"
  "%cecho  - vaihtaa echo moodin plle/pois\n"
  "%chelp  - tm help teksti\n"
  "%cme    - kirjoittaa /me -tyylisi rivej chatissa\n"
  "%cnames - nytt kaikki chatissa olevat kyttjt\n"
  "%cquit  - poistuu chat moodista (sama kuin '%cCHAT')",

  NULL
};

char *msg_no_dcc_clients[] = {
  "enNo DCC clients",
  "daIngen DCC klienter",
  "noIngen DCC klienter",
  "esNo hay clientes DCC",
  "fiEi DCC chat yhteyksi",
  NULL
};

char *msg_find_no_match_found[] = {
  "enNo match found, %s",
  "daIngen match fundet, %s",
  "noIngenting matchende funnet, %s",
  "esNo se ha encontrado ninguna relacion, %s",
  "fiEi lytynyt, %s",
  NULL
};

char *msg_find_no_index[] = {
  "enSorry, could not find the index file",
  "daDesvrre, kunne ikke finde index filen",
  "noDessverre, kunne ikke finne indeksfilen",
  "esLo siento, no pude encontrar el fichero indice",
  "fiHakutiedostoa ei lytynyt",
  NULL
};

char *msg_silly_username[] = {
  "en%s has a silly username '%s'. Operation aborted",
  "da%s har et skrt brugernavn '%s'. Operation afbrudt",
  "no%s har et teit brukernavn '%s'. Operasjon avbrutt",
  "es%s tiene un nombre ridiculo 's%'. Operacion abortada",
  "fi%s omaa kanamaisen kyttjnimen: '%s'. Toimenpide keskeytetty",
  NULL
};

char *msg_not_found[] = {
  "enNot found",
  "daIkke fundet",
  "noIkke funnet",
  "esNo encontrado",
  "fiEi lytynyt",
  NULL
};

char *msg_cannot_x_beyond_split[] = {
  "enPatience! I cannot %s from beyond a netsplit",
  "daTlmodighed! Jeg kan ikke %s hinsidens et netsplit",
  "noTlmodighet! Jeg kan ikke %s forbi en nettsplitt",
  "esPaciencia!!! no te puedo dar %s desde un netsplit!!",
  "fiKrsivllisyytt! En voi %s netsplitin yli",
  NULL
};

char *msg_give_op[] = {
  "enop you",
  "dagive dig ops",
  "nogi deg op",
  "esOP",
  "fiantaa sinulle oppeja",
  NULL
};

char *msg_give_voice[] = {
  "envoice you",
  "dagive dig voice",
  "nogi deg voice",
  "fiantaa sinulle voicea",
  NULL
};

char *msg_remove_voice[] = {
  "endevoice you",
  "fipoistaa sinulta voicea",
  NULL
};

char *msg_not_allowed_target[] = {
  "enNot allowed target. Rethink",
  "noForbudt  bruke det mlet. Tenk igjen",
  "esDestino no autorizado. piensalo otra vez",
  "fiVr kohde. Ajattele uudestaan",
  NULL
};

char *msg_no_bans_set[] = {
  "enNo bans set",
  "daIngen bans sat",
  "noIngen bannlysninger satt",
  "esNo hay Bans puestos",
  "fiEi banneja asetettu",
  NULL
};

char *msg_sview_users[] = {
  "en%sUsers: %d Guests: %d (%d ops) Split guests: %d Clients: %d"
  " Explainations: %d Seen: %d hosts (%d nicks)",

  "da%sBrugere: %d Gster: %d (%d ops) Splittet gster: %d"
  " Klienter: %d Forklaringer: %d Seen: %d maskiner (%d nicks)",

  "no%sBrukere: %d Gjester: %d (%d ops) Splittede gjester: %d"
  " Klienter: %d Forklaringer: %d Seen: %d maskiner (%d nicks)",

  "es%s Usuarios: %d invitados: %d (%d ops) Split detectados: %d Clientes %d"
  " Explicaciones: %d Vistos: %d Host (%d nicks)",

  "fi%sKyttji: %d Vieraita: %d (%d oppia) Splitanneita: %d DCCeit: %d"
  " Selityksi: %d Nhty: %d osoitetta (%d nikki)",

  NULL
};

char *msg_sview_commands[] = {
  "enCommands served: %d (Public: %3.2f%% DCC: %3.2f%%) Mode changes: %d",
  "daUdfrte kommandoer: %d (offenlige: %3.2f%% DCC: %3.2f%%) Mode skift: %d",
  "noUtfrte kommandoer: %d (offentlige: %3.2f%% DCC: %3.2f%%) Modusskift: %d",
  "esComandos servidos: %d (Publicos: %3.2f%% DCC: %3.2f%%) Cambios de modo: %d",
  "fiSuoritettuja komentoja: %d (Julkiset: %3.2f%% DCC: %3.2f%%) Moodien muutokset: %d",
  NULL
};

char *msg_sview_bans[] = {
  "enBans: %d (%d enforced) Warnings: %d (%d kickbans)",
  "daBans: %d (%d tvunget) Advarsler: %d (%d kickbans)",
  "noBans: %d (%d tvunget) Advarsler: %d (%d kickbans)",
  "esBans: %d (%d a la fuerza) Avisos: %d (%d kickbans)",
  "fiBanneja: %d (%d valvottua) Varoituksia: %d (%d potkubannia)",
  NULL
};

char *msg_sview_ignoring_ctcp[] = {
  "enIgnoring CTCP for another %s",
  "daIgnorerer CTCP i %s endnu",
  "noIgnorerer CTCP enda %s",
  "esInorando CTCP por otros %s",
  "fiIgnoroin CTCP:t viel %s",
  NULL
};

char *msg_shutdown_canceled[] = {
  "enShutdown canceled. Living on borrowed time",
  "noAvstengning avbrutt. Lever p lnt tid",
  "esApagado cancelado",
  "fiAlasajo keskeytetty. Elm jatkuu",
  NULL
};

char *msg_shutdown_already_in_progress[] = {
  "enShutdown already in progress. \"SHUTDOWN -c\" to cancel",
  "noAvstengning allerede i gang. \"SHUTDOWN -c\" for  avbryte",
  "esEl Apagado ya esta en progreso. \"SHUTDOWN -c\" para cancelar",
  "fiAlasajo on jo kynniss. \"SHUTDOWN -c\" keskeytt alasajon",
  NULL
};

char *msg_shutdown_in_progress_left[] = {
  "enShutdown in progress... %s left",
  "noAvstengning i gang... %s igjen",
/* rek2 */
  "esApagado en progreso... %s left",
  "fiAlasajo kynniss... %s jljell",
  NULL
};

char *msg_no_shutdown[] = {
  "enNo shutdown in progress",
  "noIngen avstengning i gang",
  "esNO apagado en progreso....",
  "fiEi alasajoa meneilln",
  NULL
};

char *msg_server_cannot_connect_to_port[] = {
  "enError! Cannot connect to %s on port %s",
  "daFejl! Kan ikke forbinde mig til %s p port %s",
  "noFeil! Kan ikke koble meg til %s p port %s",
  "esError!!! no puedo conectar a %s en el puerto %s",
  "fiVirhe! Yhteys serveriin %s, portiin %s ei onnistunut",
  NULL
};

char *msg_passwd_changed[] = {
  "enPassword changed to '%s'",
  "daPassword ndret til '%s'",
  "noPassord endret til '%s'",
  "esEl password ha sido cambiado a '%s'",
  "fiSalasanasi on nyt '%s'",
  NULL
};

char *msg_moderate_is[] = {
  "enModerate is %s",
  "daModeration er %s",
  "noModerasjon er %s",
  "esModerado esta en %s",
  "fiModeraatio on tll hetkell %s",
  NULL
};

char *msg_tell_already_here[] = {
  "en%s is here now. Tell it yourself",
  "da%s er her allerede. Sig det selv",
  "no%s er allerede her. Si det sjl",
  "es%s esta aqui ahora!. diselo tu mismo!!!",
  "fi%s on parasta aikaa kanavalla. Kerro se itse!",
  NULL
};

char *msg_tell_no_information[] = {
  "enCould not find information nor leave a message to '%s'",
  "daKunne ikke finde information eller efterlade en besked til '%s'",
  "noKunne ikke finne informasjonen eller etterlate en beskjed til '%s'",
  "esNo pude encontrar informacion ahora deja tu mensaje a '%s'",
  "fiPuutteellisten tietojen johdosta en voinut jtt viesti nikille '%s'",
  NULL
};

char *msg_warnlist_no_match[] = {
  "enNo (matching) persons in the list",
  "daIgen (matchende) personer i listen",
  "noIngen (matchende) personer i lista",
  "esNo hay personas (similares) en la lista",
  "fiEi (vastaavia) henkilit varoituslistalla",
  NULL
};

char *msg_warnadd_could_not_find[] = {
  "enCould not find no user called %s",
  "daKunne ikke finde en bruger kaldet %s",
  "noKunne ikke finne en bruker ved navn %s",
  "esNo pude encontrar ningun usuario llamado %s",
  "fiEn lytnyt kyttj %s",
  NULL
};

char *msg_warnadd_include_me[] = {
  "enYou stupid! That warning would include myself",
  "daFjols! Denne advarsel ville inkludere migselv",
  "noLavpanne! Denne advarselen ville inkludere meg!",
  "esEres Tonto? el aviso me incluiria a mi mismo!",
  "fiHlm! Tuo varoitus sisltisi minutkin",
  NULL
};

char *msg_warnadd_added[] = {
  "en%s (%s!%s) is now added",
  "da%s (%s!%s) er tilfjet",
  "no%s (%s!%s) er lagt til",
  "es%s (%s!%s) esta agregado",
  "fi%s (%s!%s) on nyt listty",
  NULL
};

char *msg_warnadd_not_added[] = {
  "enNot added, already warned for",
  "daIkke tilfjet. Advarslen findes allerede",
  "noIkke lagt til. Advarselen finnes allerede",
  "esNo ha sido incorporado. Ya ha sido informado de ello",
  "fiVaroitusta ei listty, maski on jo listalla",
  NULL
};

char *msg_report_on[] = {
  "enReport is on",
  "daRapportering er til",
  "noRapportering er p",
  "esEl report esta encendido",
  "fiRaportointi on pll",
  NULL
};

char *msg_report_already_on[] = {
  "enReport is already on",
  "daRapportering er allerede til",
  "noRapportering er allerede p",
  "esEl report ya estaba encendido",
  "fiRaportointi on jo pll",
  NULL
};

char *msg_report_off[] = {
  "enReport is off",
  "daRapportering er fra",
  "noRapportering er av",
  "esEl report esta apagado",
  "fiRaportointi on pois plt",
  NULL
};

char *msg_report_already_off[] = {
  "enReport is already off",
  "daRapportering er allerede fra",
  "noRapportering er allerede av",
  "esEl report ya estaba apagado",
  "fiRaportointi on jo pois plt",
  NULL
};

char *msg_spy_on[] = {
  "enSpy is on",
  "daSpionering er til",
  "noSpionering er p",
  "esEl espia esta encendido",
  "fiVakoilu on pll",
  NULL
};

char *msg_spy_already_on[] = {
  "enSpy is already on",
  "daSpionering er allerede til",
  "noSpionering er allerede p",
  "esEl Espia ya estaba encendido",
  "fiVakoilu on jo pll",
  NULL
};

char *msg_spy_off[] = {
  "enSpy is off",
  "daSpionering er fra",
  "noSpionering er av",
  "esEl espia esta apagado",
  "fiVakoilu on pois plt",
  NULL
};

char *msg_spy_already_off[] = {
  "enSpy is already off",
  "daSpionering er allerede fra",
  "noSpionering er allerede av",
  "esEl Espia ya estaba apagado",
  "fiVakoilu on jo pois plt",
  NULL
};

char *msg_debug_on[] = {
  "enDebug is on",
  "daDebug beskeder er til",
  "noDebug er p",
  "esEl debug esta encendido",
  "fiDebug on pll",
  NULL
};

char *msg_debug_already_on[] = {
  "enDebug is already on",
  "daDebug beskeder er allerede til",
  "noDebug er allerede p",
  "esEl Debug ya estaba encendido",
  "fiDebug on jo pll",
  NULL
};

char *msg_debug_off[] = {
  "enDebug is off",
  "daDebug beskeder er fra",
  "noDebug er av",
  "esEl Debug esta apagado",
  "fiDebug on pois plt",
  NULL
};

char *msg_debug_already_off[] = {
  "enDebug is already off",
  "daDebug beskeder er allerede fra",
  "noDebug er allerede p",
  "esEl Debug ya estaba apagado",
  "fiDebug on jo pois plt",
  NULL
};

char *msg_alias_aliases[] = {
  "enAliases for %s: %s",
  "daAliaser for %s: %s",
  "noAliaser for %s: %s",
  "esAlias para %s: %s",
  "fi%s komennon aliakset: %s",
  NULL
};

char *msg_alias_no_aliases[] = {
  "enNo aliases for %s",
  "daIngen aliaser for %s",
  "noIngen aliaser for %s",
  "esNo existe alias para %s",
  "fiKomennolla %s ei ole aliaksia",
  NULL
};

char *msg_alias_command_not_found[] = {
  "enCommand \"%s\" not found",
  "daKommando \"%s\" ikke fundet",
  "noKommando \"%s\" ikke funnet",
  "esComando \"%s\" no encontrado",
  "fiKomentoa \"%s\" ei lytynyt",
  NULL
};

char *msg_identify_no_match[] = {
  "enCannot unify. Data doesn't match",
  "daKan ikke forene. Data passer ikke",
  "noKan ikke forene. Data stemmer ikke",
  "esNo se puede unir .los Dator no coinciden",
  "fiEn voi yhdist. Tiedot eivt vastaa",
  NULL
};

char *msg_identify_already_linked[] = {
  "enCannot unify. Already linked to %s",
  "daKan ikke forene. Allerede forenet med %s",
  "noKan ikke forene. Allerede forenet med %s",
  "esNo se puede unir. Ya esta unido a nosotros %s",
  "fiEn voi yhdist. DCC linkattu jo (%s)",
  NULL
};

char *msg_identify_already_unified[] = {
  "enAlready unified",
  "daAllerede forenet",
  "noAllerede forenet",
  "esYa esta unido",
  "fiYhdistetty jo",
  NULL
};

char *msg_identify_no_nick[] = {
  "enNick \"%s\" not found on channel %s",
  "daNick \"%s\" ikke fundet p kanal %s",
  "noNick \"%s\" ikke funnet p kanal %s",
  "esEl Nick \"%s\" no ha sido encontrado en el canal %s",
  "fiNick \"%s\" ei ole kanavalla %s",
  NULL
};

char *msg_identify_only_dcc[] = {
  "enYou can only identify through DCC",
  "daDu kan kun identificere dig gennem DCC",
  "noDu kan kun identifisere deg via DCC",
  "esSolo te puedes identificar por DCC",
  "fiVoit kytt komentoa vain DCCn kautta",
  NULL
};

char *msg_cut_closed[] = {
  "enConnection has been closed",
  "daForbindelse er blevet lukket",
  "noForbindelsen har blitt lukket",
  "esLa conexion ha sido cerrada",
  "fiYhteytesi on suljettu",
  NULL
};

char *msg_cut_closed_by[] = {
  "enYour DCC connection has been closed down by %s",
  "daDin DCC forbindelse er blevet lukket af %s",
  "noDin DCC-forbindelse ble lukket av %s",
  "esTu conexion DCC ha sido cerrado por %s",
  "fi%s sulki DCC chat yhteytesi",
  NULL
};

char *msg_cut_no_client[] = {
  "enNo client for %s found",
  "daIgen klient for %s fundet",
  "noIngen klient for %s funnet",
  "esNingun cliente encontrado para %s",
  "fiDCC chattia ei lytynyt nikille %s",
  NULL
};

char *msg_top_unknown[] = {
  "enUnknown toplist",
  "daUkendt topliste",
  "noUkjent toppliste",
  "esToplist no reconocido",
  "fiTuntematon toplista",
  NULL
};

char *msg_invite_already_here[] = {
  "enYou're already here",
  "daDu er her allerede",
  "noDu er allerede her",
  "esYa estas aqui!",
  "fiOlet jo tll",
  NULL
};

char *msg_log_logging[] = {
  "enLogging: %s",
  "daLogger: %s",
  "noLogger: %s",
  "esLogin (Logeando): %s",
  "fiLoggaan: %s",
  NULL
};

char *msg_log_nothing[] = {
  "enLogging nothing",
  "daLogger intet",
  "noLogger ingenting",
  "esLoggin nada",
  "fiEn loggaa mitn",
  NULL
};

char *msg_i_need_a_nick[] = {
  "enI need a nick",
  "daJeg mangler et nick",
  "noJeg mangler et nick",
  "esNecesito un Nick",
  "fiTarvitsen nikin",
  NULL
};

char *msg_serveradd_added[] = {
  "enAdded server %s",
  "daTilfjede server %s",
  "noLa til server %s",
/* rek2 */
  "esServidor incorporado %s",
  "fiServeri %s listty",
  NULL
};

char *msg_serveradd_already_added[] = {
  "enServer %s is already added",
  "daServer %s er allerede tilfjet",
  "noServer %s er allerede lagt til",
  "esEL Servidor %s ya esta incorporado",
  "fiServeri %s on jo listty",
  NULL
};

char *msg_helpset_banprotect[] = {
  "enEnable banprotection",
  "fiBan-suojauksen pkatkaisin",
  NULL
};
char *msg_helpset_loopservers[] = {
  "enMakes the bot loop the serverlist forever. When off, the bot quits"
  " after losing connection to the last server in the list",

  "fiPakottaa botin kymn serveri-listaa ikuisesti lpi. Jos loopservers"
  " on pois plt, botti kuolee menetettyn yhteyden viimeiseen serveriin",

  NULL
};
char *msg_helpset_oplevel[] = {
  "enUsers with level OPLEVEL or higher are allowed to handle OPs in the"
  " channel. Setting OPLEVEL to 0 turns it off. Affects STRICTOP, OPPROTECT,"
  " NETSPLIT, LOCKKEY, LOCKMODE and LOCKLIMIT when on",

  "fiMritt tason joka vaaditaan kyttjilt jotta he saisivat toimia"
  " kanavan operaattoreina. Arvolla 0 toiminto on pois plt. Vaikuttaa"
  " STRICTOP, OPPROTECT, NETSPLIT, LOCKKEY, LOCKMODE ja LOCKLIMIT asetuksiin"
  " toiminnon ollessa pll",

  NULL
};
char *msg_helpset_mute[] = {
  "enDisable TALK, WELCOME, REPORTBAN and all the other unwanted noise"
  " not controlled by these settings. It won't touch the individual"
  " settings itself, but overrides all of these by preventing the bot"
  " to talk unless commanded",

  "fiEst bottia puhumasta ilman erillist ksky. TALK, WELCOME,"
  " REPORTBAN ja muut ylimriset net pois",

  NULL
};
char *msg_mute_is_on[] = {
  "enMUTE is on, can't do this now!",
  "fiMUTE on pll, en voi suorittaa komentoa!",
  NULL
};
char *msg_mute_is_off[] = {
  "enMUTE is off now",
  "fiMUTE on pois plt",
  NULL
};

char *msg_userdel_inform_real[] = {
  "enYou were just deleted by %s.",
  "fi%s poisti sinut kyttjlistalta.",
  NULL
};

char *msg_userdel_done_real[] = {
  "enUser %s was deleted%s!",
  "fi%s poistettiin kyttjlistalta%!",
  NULL
};

char *msg_no_invitation[] = {
  "enI don't respond to invitations right now",
  "fiEn vastaa kutsuihin juuri nyt",
  NULL
};

char *msg_no_ops_allowed[] = {
  "en%s is not allowed to get ops from you.",
  "fi%s ei ole oikeutettu saamaan oppeja sinulta.",
  NULL
};

/* --- transfer.c --- */

char *msg_execprotect_on[] = {
  "enEXECPROTECT is on",
  "fiEXECPROTECT on pll",
  NULL
};
char *msg_cannot_do_that[] = {
  "enCannot do that.",
  "fiEn voi suorittaa komentoa.",
  NULL
};
char *msg_done[] = {
  "enDone",
  "fiKomento suoritettu",
  NULL
};

/* --- setup.c strings --- */

char *msg_matches_several_groups[] = {
  "en'%s' matches several groups",
  "fi'%s' vastaa useita ryhmi",
  NULL
};
char *msg_matches_several_items[] = {
  "en'%s' matches several items",
  "fi'%s' vastaa useita asetuksia",
  NULL
};
char *msg_set[] = {
  "enSET",
  "fiSET",
  NULL
};
char *msg_group[] = {
  "enGroup",
  "fiRyhm",
  NULL
};
char *msg_group_doesnt_exist[] = {
  "enGroup %s doesn't exist.",
  "fiRyhm %s ei ole.",
  NULL
};
char *msg_item_doesnt_exist[] = {
  "enItem %s doesn't exist%s.",
  "fiAsetusta %s ei ole%s.",
  NULL
};
char *msg_in_that_group[] = {
  "en in that group",
  "fi kyseisess ryhmss",
  NULL
};
char *msg_no_access[] = {
  "en[NO ACCESS]",
  "fi[EI PSY]",
  NULL
};
char *msg_cant_find_set_keyword[] = {
  "enCan't find that SET keyword. Please be more specific.",
  "fiKyseist SET-avainsanaa ei lytynyt. Ole tsmllisempi.",
  NULL
};
char *msg_i_dont_understand[] = {
  "enI don't understand.",
  "fiEn ymmrr.",
  NULL
};
char *msg_dont_touch_this[] = {
  "enYou are not allowed to touch this.",
  "fiSinulla ei ole lupa koskea thn.",
  NULL
};

/* --- news.c strings --- */

char *msg_news_report[] = {
  "enNEWS: \"%s\" by %s %s ago",
  "fiUUTINEN: \"%s\" uutisoi: %s -- %s sitten",
  NULL
};
char *msg_news_list[] = {
  "en%sID: %d, level: %d, match: '%s' by: %s --  %s ago",
  "fi%sID: %d, taso: %d, kohde: '%s' toimittaja: %s -- %s sitten",
  NULL
};
char *msg_unread[] = {
  "en(unread) ",
  "fi(lukematon) ",
  NULL
};
char *msg_no_news[] = {
  "enNo news",
  "fiEi uutisia",
  NULL
};

char *msg_internal_error[] = {
  "eninternal error",
  "fisisinen virhe",
  NULL
};

char *msg_seensplit[] = {
  "en%s is currently on the other side of a netsplit",
  "fi%s on tll hetkell toisella puolen netsplitti",
  NULL
};
char *msg_seen_bad_pattern[] = {
  "enToo general search pattern, the rest was cut",
  "fiLiian yleinen hakumaski, loppu ji nyttmtt",
  NULL
};
char *msg_never_seen_match[] = {
  "enI have never seen anybody who matches '%s'",
  "fiEn ole koskaan nhnyt ketn joka vastaisi maskia '%s'",
  NULL
};

char *msg_helpset_language[] = {
  "enSet primary (default) language for the bot to use. Available"
  " languages: dansk, deutsch, english, espaol, franais, nederlands,"
  " norsk, svenska and suomi",

  "fiAseta botin ensisijainen pkieli. Kytetettviss olevat kielet:"
  " dansk, deutsch, english, espaol, franais, nederlands, norsk, svenska"
  " and suomi",

  NULL
};

/* --- convert.c --- */

char *msg_unknown_unit[] = {
  "enUnknown unit '%s'",
  "fiTuntematon yksikk '%s'",
  NULL
};
char *msg_convert_length[] = {
  "en%.*f meters = %.*f miles = %.*f yards = %.*f feet = %.*f inches ="
  " %.*f naut.mi. = %.*f chains = %.*f rods = %.*f fathoms",

/* fin */
  "fi%.*f metri = %.*f mailia = %.*f jaardia = %.*f jalkaa = %.*f tuumaa ="
  " %.*f meripeninkulmaa = %.*f chains = %.*f rods = %.*f syli",

  NULL
};
char *msg_convert_temperature[] = {
  "en%.*f celsius = %.*f fahrenheit = %.*f kelvin",
  "fi%.*f celsius astetta = %.*f fahrenheittia = %.*f kelvini",
  NULL
};
char *msg_convert_mass[] = {
  "en%.*f grams = %.*f pounds = %.*f ounces",
  "fi%.*f grammaa = %.*f naulaa = %.*f unssia",
  NULL
};
char *msg_convert_volume[] = {
  "en%.*f liter = %.*f gallons = %.*f us gallons = %.*f floz = %.*f pints ="
  " %.*f cups = %.*f tablespoons = %.*f teaspoons = %.*f quarts ="
  " %.*f bushels = %.*f pecks = %.*f cumeter = %.*f cuyards = %.*f cufeet ="
  " %.*f cuinches",

/* fin */
  "fi%.*f litraa = %.*f gallonaa = %.*f us gallonaa = %.*f floz ="
  " %.*f pintti = %.*f kuppia = %.*f ruokalusikkaa = %.*f teelusikkaa ="
  " %.*f neljnnesgallonaa = %.*f vakkaa = %.*f pecks = %.*f kuutiometri ="
  " %.*f kuutiojaardia = %.*f kuutiojalkaa = %.*f kuutiotuumaa",

  NULL
};
char *msg_convert_area[] = {
  "en%.*f sqmeter = %.*f sqkm = %.*f hectares = %.*f acres = %.*f sqmiles ="
  " %.*f sqyards = %.*f sqfeet = %.*f sqinches",

  "fi%.*f nelimetri = %.*f nelikilometri = %.*f hehtaaria ="
  " %.*f eekkeri = %.*f nelimailia = %.*f nelijaardia = %.*f nelijalkaa ="
  " %.*f nelituumaa",

  NULL
};
char *msg_specify_tz[] = {
  "enYou must specify at least one time zone.",
  "fiSinun on annettava vhintn yksi aikavyhyke.",
  NULL
};
char *msg_unknown_zone[] = {
  "enUnknown zone: %s",
  "fiTuntematon vyhyke: %s",
  NULL
};
char *msg_time_equals_time_in[] = {
  "en%02d:%02d in %s equals %02d:%02d in %s.",
  "fiKellon ollessa %02d:%02d %s:ssa, se on %02d:%02d %s:ssa.",
  NULL
};
char *msg_current_time[] = {
  "enCurrent time in %s%s%s%s is %02d:%02d.",
  "fi%s:ssa%s%s%s kello on %02d:%02d.",
  NULL
};
char *msg_pattern_doesnt_match[] = {
  "en%s matches no country or timezone.",
  "fi%s ei vastaa ainoatakaan maata eik aikavyhykett.",
  NULL
};
char *msg_limit_searchpattern[] = {
  "en%d items weren't shown. Limit the searchpattern and try again.",
  "fi%d ji nyttmtt. Rajoita hakumaskia ja yrit uudestaan.",
  NULL
};
char *msg_ahead_of[] = {
  "enahead of",
  "fiedell",
  NULL
};
char *msg_behind[] = {
  "enbehind",
  "fijljess",
  NULL
};
char *msg_is_the_same_as[] = {
  "en%s is the same as %s.",
  "fi%s on samalla aikavyhykkeell kuin %s.",
  NULL
};
char *msg_no_currency_info[] = {
  "enI don't have currency information for %s!",
  "fiEn lytnyt valuuttakurssia %s:lle!",
  NULL
};
char *msg_no_country_or_currency[] = {
  "enI can't find a country or currency named %s",
  "fi%s nimist maata tai valuuttaa ei lytynyt",
  NULL
};
char *msg_currency_is[] = {
  "enThe currency in %s is abbrivated %s. One unit of it is called %s.",
  "fi%s:n valuutta lyhennetn %s. Rahayksikkn nimi on %s.",
  NULL
};

/* --- command.c --- */

char *msg_permission_denied[] = {
  "enPermission denied",
  "fiLupa kielletty",
  NULL
};
char *msg_channel_not_invite_only[] = {
  "enCome right in. The channel is not invite-only",
  "fiTule vain sisn. Kanavalle on vapaa psy",
  NULL
};
char *msg_could_not_delete_news[] = {
  "enCouldn't delete news ID %d",
  "fiEn voinut poistaa uutista (ID %d)",
  NULL
};
char *msg_news_removed[] = {
  "enRemoved news ID %d",
  "fiUutinen poistettu (ID %d)",
  NULL
};
char *msg_news_added[] = {
  "enNews ID %d added",
  "fiUutinen listty (ID %d)",
  NULL
};
char *msg_failed_to_send_news[] = {
  "enFailed to send news",
  "fiUutisten lhetys eponnistui",
  NULL
};
char *msg_cant_ban_banprotected[] = {
  "enCan't ban a banprotected user",
  "fiBan-suojattua kyttj ei voi bannata",
  NULL
};

/* --- servfunc.c --- */

char *msg_cant_delete_current_server[] = {
  "enCan't delete current server",
  "fiNykyist serveri ei voi poistaa",
  NULL
};
char *msg_could_not_find_server[] = {
  "enCouldn't find server %s (port %s)",
  "fiEn lytnyt serveri %s (portti %s)",
  NULL
};
char *msg_server_removed[] = {
  "en%s (port %s) is removed",
  "fi%s (portti %s) poistettu",
  NULL
};
char *msg_server_not_in_list[] = {
  "enCurrent server %s is not in the list",
  "fiNykyinen serveri %s ei ole listassa",
  NULL
};

/* --- tell.c --- */

char *msg_said[] = {
  "ensaid",
  "fisanoi",
  NULL
};
char *msg_ago[] = {
  "enago",
  "fisitten",
  NULL
};
char *msg_i_have_tells[] = {
  "enI have %s%s%sstored for you. Use \"/msg %s TELLME\" to make me tell",
  "fiMinulla on %s%s%stallennettuna sinulle. \"/msg %s TELLME\" kertoo",
  NULL
};
char *msg_msg[] = {
  "enmessage",
  "fiviesti",
  NULL
};
char *msg_msgs[] = {
  "enmessages",
  "fiviesti",
  NULL
};
char *msg_news_items[] = {
  "ennews items",
  "fiuutista",
  NULL
};
char *msg_you_have_more[] = {
  "enYou have %d more %s!",
  "fiSinulla on viel %d %s lis!",
  NULL
};
char *msg_no_msgs_or_news[] = {
  "enNo messages or news for you",
  "fiEi viestej eik uutisia sinulle",
  NULL
};
char *msg_please_join_channel[] = {
  "enPlease join the channel first",
  "fiTule ensin kanavalle",
  NULL
};
char *msg_message_stored[] = {
  "enMessage stored for %s with ID %d",
  "fiViesti kyttjlle %s tallennettu (ID %d)",
  NULL
};
char *msg_error_message_pattern[] = {
  "enError: Could not store message for pattern '%s'",
  "fiVirhe: En voinut tallentaa viesti maskille '%s'",
  NULL
};
char *msg_had_been_removed[] = {
  "enMessage %d had been removed",
  "fiViesti poistettu (ID %d)",
  NULL
};
char *msg_not_your_messageid[] = {
  "enID %d does not belong to you",
  "fiKyseinen viesti ei kuulu sinulle (ID %d)",
  NULL
};
char *msg_no_such_id[] = {
  "enNo such ID",
  "fiViesti ei lytynyt (vr ID)",
  NULL
};
char *msg_you_have_stored_these[] = {
  "enYou have stored these messages",
  "fiOlet tallettanut seuraavat viestit",
  NULL
};
char *msg_tell_list_empty[] = {
  "enTell list is empty",
  "fiEi viestej, tell-lista on tyhj",
  NULL
};

/* --- user.c --- */

char *msg_warn_nick_collide[] = {
  "en\"%s\" was used %s ago by %s who left in a netsplit between %s."
  " You could get collided when the net heals again.",

  "fiNikki \"%s\" oli kytss viel %s sitten (%s), mutta hn poistui"
  " netsplitiss servereiden %s vlill. Saatat trmt hneen kun netti"
  " paranee jlleen. (nikkitrmys -> kuolema)",

  NULL
};
char *msg_is_joined_now[] = {
  "enis joined now",
  "fion kanavalla juuri nyt",
  NULL
};
char *msg_regged_user_with_nick[] = {
  "enRegistered user with this nick.",
  "fiKyttj on rekisterity tll nickill.",
  NULL
};
char *msg_not_his_nick[] = {
  "enAlthough another person has the nick registered.",
  "fiTosin ers toinen henkil on rekisterity samalla nikill.",
  NULL
};
char *msg_who_is_now[] = {
  "en...who is now joined as '%s'",
  "fi...joka on juuri kavalla kytten nicki '%s'",
  NULL
};
char *msg_most_recently_used_by[] = {
  "enMost recently used by %s.",
  "fiViimeksi sit kytti %s.",
  NULL
};
char *msg_from_which_host[] = {
  "enFrom which host, '%s' is joined now.",
  "fiJolta '%s' on nyt mys kanavalle liittynyt",
  NULL
};
char *msg_most_often_used_by[] = {
  "enBut most often used by %s.",
  "fiMutta kaikkein eniten kyseist nikki on kyttnyt %s",
  NULL
};
char *msg_and_also_most_often_used[] = {
  "enAnd also most often used by that host.",
  "fiTuosta osoitteesta sit on mys kaikkein eniten kytetty.",
  NULL
};

/* --- country.c --- */

char *msg_x_not_found[] = {
  "en%s not found",
  "da%s ikke fundet",
  "no%s ikke funnet",
  "es%s no encontrado",
  "fi%s ei lytynyt",
  NULL
};
char *msg_is_from[] = {
  "en%s is from %s%s",
  "fi%s on kotoisin maasta: %s%s",
  NULL
};
char *msg_cannot_find_info[] = {
  "enSorry, cannot find information on %s",
  "fiSori, en tied mist %s on kotoisin",
  NULL
};
char *msg_has_country_code[] = {
  "en%s has .%s%s",
  "fi%s omaa koodin .%s%s",
  NULL
};
char *msg_has_country_assuming[] = {
  "en%s has .%s (assuming %s%s)",
  "fi%s omaa koodin .%s (olettaen %s%s)",
  NULL
};
char *msg_is_unknown[] = {
  "en%s is unknown",
  "fi%s on tuntematon",
  NULL
};

char *msg_thanks_for_ops[] = {
  "enbows to %s for that...",
  "fikumartaa nyrsti. Kiitos %s.",
  NULL
};
char *msg_slaps_for_deop[] = {
  "enslaps %s for that nasty deed! ;(",
  "fituntee olonsa kovin voimattomaksi ylltten ;( Tm muistetaan %s.",
  NULL
};

char *msg_alert_banlist_full[] = {
  "enALERTS: Banlist contains %d bans!",
  "fivaroittaa: banlistassa on %d bannia!",
  NULL
};

char *msg_available_languages[] = {
  "enAvailable languages: ",
  "fiSeuraavat kielet ovat kytettvisssi: ",
  NULL
};

char *msg_spy_hidden_command[] = {
  "enSPY: %s used the command \"%s\". %s",
  "fiSPY: %s kytti komentoa \"%s\". %s",
  NULL
};
char *msg_spy_who_did_what[] = {
  "enSPY: %s did \"%s%s%s\"",
  "fiSPY: %s teki \"%s%s%s\"",
  NULL
};

char *msg_spy_auth_failed[] = {
  "enSPY: Authentication failed for %s",
  "fiSPY: %s:n todennus eponnistui",
  NULL
};

char *msg_helpset_opprotect[] = {
  "enProtect channel operators. With this enabled, non-chanop users will"
  " not be allowed to deop chanop users. The bot will first deop the deoper"
  " and then op the chanop users that were deoped",
  "fiSuojelee kanavan operaattoreita. Tmn ollessa pll botti yritt"
  " varmistaa ett op-tason alapuolella olevat vieraat eivt deoppaile"
  " op-tasolla tai sen ylpuolella olevia kyttji. Botti poistaa ensin"
  " opit deoppailijalta ja antaa sen jlkeen opit niille op-tason kyttjille"
  " joilta opit vietiin",
  NULL
};
