/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/function.h,v $
 * $Revision: 1.1.1.1 $
 * $Date: 2000/11/13 02:42:42 $
 * $Author: holsta $
 * $State: dancer.c $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#ifndef FUNCTION_H
#define FUNCTION_H

#include "dancer.h"
#include "strio.h"

typedef struct {  /* Options */
  char *newpos;
  char copt;
} itemopt;


inline bool IsChannel(char *);
inline bool IsServer(char *);
bool GetOption(char *);
char *Userdomain(char *);
void NewNick(void);
char *TimeAgo(time_t);
char *SecsToString(int);
int ToSeconds(char *);
inline unsigned int Hash(char *);
inline unsigned int HashU(char *);
ulong HashSignatureU(char *);
void PatternInit(void);
bool PatternExist(char *, char *);
bool Match(char *, char *);
bool MatchEsc(char *, char *);
bool MatchMatch(char *, char *);
bool IRCEqual(const char *, const char *);
#define IRCEqualCase(first, second) StrEqualCase((first), (second))
inline char *OnOff(bool);
inline bool IsOn(char *);
char *OurNextWord(char *, char **);
char *OurNextQuoteWord(char *, char **);
#define NextWord(x) OurNextWord((x), &(x))
#define NextQuoteWord(x) OurNextQuoteWord((x), &(x))
char *StrSplitMax(char *, size_t);

/* Initialize the pseudo-random number generator */
void RandomInit(int);
/* Returns a pseudo-random number between 0 and RNDMAX */
inline ulong Random(void);
/* Returns a pseudo-random number between 0.0 and 1.0 */
float Rnd(void);

void AddToTop(char *name, long value);
void InitTop(void);
char *PresentTop(void);
bool FileExist(char *);

#endif /* FUNCTION_H */
