/******************************************************************************
 *                    Internetting Cooperating Programmers
 * ----------------------------------------------------------------------------
 *
 *  ____    PROJECT
 * |  _ \  __ _ _ __   ___ ___ _ __ 
 * | | | |/ _` | '_ \ / __/ _ \ '__|
 * | |_| | (_| | | | | (_|  __/ |   
 * |____/ \__,_|_| |_|\___\___|_|   the IRC bot
 *
 * All files in this archive are subject to the GNU General Public License.
 *
 * $Source: /cvsroot/dancer/dancer/src/flood.h,v $
 * $Revision: 1.1.1.1 $
 * $Date: 2000/11/13 02:42:41 $
 * $Author: holsta $
 * $State: dancer.c $
 * $Locker:  $
 *
 * ---------------------------------------------------------------------------
 *****************************************************************************/

#ifndef FLOOD_H
#define FLOOD_H

#include "dancer.h"
#include "user.h"

/* This define sets the *longest* interval accepted between two failed sitebans
   to trigger the RED alert situation. RED alert will most likely set the
   channel +i */
#define TRIGGER_RED_ALERT (10*SECINMIN) 

typedef enum {
  ALERT_NONE,
  ALERT_ON,
  ALERT_OFF,
  ALERT_RED,
  ALERT_LAST
} Alert;

int AlertMode(Alert);

bool Warning(itemguest *, char *, char *);
void FloodCheck(itemguest *);
void Check(itemguest *, char *);
void RepeatCheck(itemguest *, char *);
void AvalanceCheck(itemguest *, char *);
bool CTCPFloodCheck(itemguest *, bool);
void MultiCheck(char *domain);

#endif /* FLOOD_H */
