#!/bin/sh
##################
# Version 3.
# Converts from any rate to any rate.
#
# * 'list' enhanced to deal with large currency quantities an additional
#   argument is now also supported to list, which is the initial string of
#   the currency name, thus 'list a' lists all currencies startign with 'a'
#
RATES="/full/path/to/destination/rates/file"

amount=$1
fromcurr=$2
tocurr=$3
fromname=$4
toname=$5
fromcountry=$6
tocountry=$7

if test "list" = "$amount"; then
  cat "$RATES" | sort | grep -i "^$fromcurr" | awk 'BEGIN{a=""; c=0;} {c++; a = sprintf("%s%s ", a, $1); if(length(a)>240) { print a; a=""; } } END { if(length(a))print a; print c " currencies!";}'
  exit
fi


fromrate=`grep -i "$fromcurr" "$RATES" | awk '{ print $2;}'`
torate=`grep -i "$tocurr" "$RATES" | awk '{ print $2;}'`

if test -z "$torate"; then
  echo "*** I have no rate for $tocurr"
  exit
fi

if test -z "$fromrate"; then
  echo "*** I have no rate for $fromcurr"
  exit
fi

# This bc-line is to make the actual calculation use a 99-scale, while
# we want the output to use only 3!
result=`echo "scale=99; a= $amount / ($fromrate/$torate); scale=3; a/1" | bc`

echo "$amount $fromcurr ($fromcountry $fromname) makes $result $tocurr ($tocountry $toname)"
