DACS.EXPRS(5)                 DACS Formats Manual                DACS.EXPRS(5)



[1mNAME[0m
       dacs.exprs - [1mDACS [22mexpression language

[1mDESCRIPTION[0m
       These files are part of the [1mDACS [22msuite.

       [1mDPL [22m(the [1mDACS [22mprogramming language) is used in access control rules,
       its revocation list, and in configuration files. This programmability
       gives [1mDACS [22mmaximum run-time configurability and flexibility. A [1mDPL[0m
       expression - or even a small program - may appear within predicate,
       allow, and deny elements of an access control rule, for example.  [1mDPL[0m
       is also accessible using the [34m[1mdacsexpr(1)[0m[1m[22m[1] command, which can be used
       for writing scripts even for non-[1mDACS [22mapplications.

       [1mDPL[22m, which is gradually evolving in mostly backward-compatible ways, is
       similar in many ways to [34m[1mPerl[0m[1m[22m[2], [34m[1mPHP[0m[1m[22m[3], [34m[1mTcl[0m[1m[22m[4] and its expressions
       look and behave much like C/C++ expressions. The calling signatures for
       functions are reminiscent of those of [1mTcl[22m, with literal or string
       arguments used to select a particular mode of operation or specify
       options. The syntaxes used for strings and variables have been
       influenced by various Unix shells. Our intent is for the language to
       feel familiar and be easy to use for the typical tasks at hand. We have
       tried not to be gratuitously different.

           [1mNote[0m
           The philosophy guiding the design of the [1mDACS [22mexpression language
           is that its power should be limited to basic operations on
           elementary data types that can be expressed simply and evaluated
           efficiently, along with a collection of utility and higher-level
           functions, targeted for the tasks at hand, that hide complexity.
           This is why the language does not include much in the way of
           control flow statements - our feeling is that complicated
           expressions are more likely to introduce mistakes, which can easily
           result in access control rules not working as intended.

           While fleshing out the language is not a priority, expression
           syntax and the set of functions are being extended as necessary. An
           extensibility mechanism is planned that would let user-defined
           functions be loaded at run-time.

           While there are no immediate plans to do so, replacing the [1mDACS[0m
           expression language with a general-purpose extension language may
           eventually make sense.  [1mTcl [22mand [1mPerl [22mwould be leading contenders.

           [1mTip[0m
           The [34m[1mdacsexpr(1)[0m[1m[22m[1] utility can be useful for learning, testing, and
           debugging [1mDPL[22m.

   [1mExpression Syntax[0m
       Expression evaluation consists of a lexical analysis stage, in which
       the expression is broken into a sequence of tokens, followed by
       evaluation of the tokens.

       Expression syntax is checked before an expression is evaluated. Any
       syntactic or run-time evaluation error immediately terminates
       evaluation of the top-level expression and returns a [1mFalse [22mresult.

           [1mNote[0m
           Because files containing expressions are local to the [1mDACS [22msite on
           which they appear (i.e., [1mDACS [22mdoes not copy them), they need not be
           portable across sites. This means that any [1mDACS [22mjurisdiction is
           free to customize or extend these expressions at will since they do
           not have to be understood or executed by any other jurisdiction.

       [1mComments[0m
           Three comment styles are recognized:

           +o   The /* ... */ C style comment syntax, which does not nest;

           +o   The // syntax of C++, where the remainder of the line following
               the token is ignored; and

           +o   The # syntax of shells and many scripting languages, provided
               the # is either at the beginning of a line or appears after
               whitespace, where the remainder of the line following the token
               is ignored. Note that escaping the # by preceding it with a
               backslash prevents the text that follows from being interpreted
               as a comment. For example, this will result in a syntax error
               if the backslash is omitted:

                   > ${foo:? \#xxx}
                   " #xxx"



       Here are examples of all three styles:

           /*
            * This is a comment
            */

           // This is another comment

           ${x} = 17;  # And one last comment

       Additionally, when expressions are parsed in the context of an XML
       document (such as in an access control rule), the XML comment syntax
       can be used (<!-- A comment -->). Such comments can span multiple
       lines.

           <!--
           Comment out this clause for now...
           <Auth id="authx">
           STYLE "expr"
           CONTROL "sufficient"
           </Auth>
           -->


   [1mBasic Data Types[0m
       The following basic data types are supported:

       integer
       int
           , Integers are represented internally as a C/C++ [1mlong int[22m. Maximum
           and minimum values are platform dependent. Integers are written in
           the C-style syntax; for example, -1958, 0377 (octal), and 0xABC
           (hexadecimal, upper or lower case).

       real
       double
           , Reals are represented internally as a C/C++ [1mdouble[22m. Maximum and
           minimum values are platform dependent. A real constant is an
           optional sequence of decimal digits (possibly signed) followed by a
           period and 1) at least one digit or 2) an 'e' or 'E' followed by at
           least one digit.

       string
           A string is a sequence of characters enclosed between matching
           single or double quotes (e.g., 'Hello world'). Interpolation of
           variables occurs within double quotes but not single quotes.
           C-style character escape codes and octal numeric escape codes are
           understood (e.g., "\t", "\010") and either quote character (e.g.,
           'It\'s here') and the backslash character (e.g., "\\") can be
           quoted. An unrecognized quoted character is mapped to that
           character (e.g., "\x" is "x"). Character strings are limited in
           length by available memory and are represented internally as a
           null-terminated vector.

               [1mNote[0m
               +o   Because a string is null-terminated, it cannot contain a
                   NUL character. Also, functions that deal with strings
                   usually do not expect (most) ASCII control characters to
                   appear in a string. Therefore a string that contains an
                   unprintable character (a character that is not a tab,
                   newline, carriage return, and that does not satisfy
                   [34m[1misprint(3)[0m[1m[22m[5]) automatically becomes a bstring (see below).

               +o   Because [1mDACS [22mconfiguration files are XML documents,
                   characters special to XML must be properly escaped within
                   them. In particular, an ampersand character must always be
                   written as &amp; and a < character must be written as &lt;.
                   For example, the query string a=1&b=2 might be used as

                       ${Foo::QUERY_STRING} = "a=1&amp;b=2"

               Variable references may occur within a (double-quoted) string;
               the value of the variable reference is interpolated at that
               point. If [4m${Foo::bar}[24m is "hello", then the value of
               "${Foo::bar}, world" is "hello, world".


                   [1mNote[0m
                   The first expression is invalid and must be written as the
                   second:

                       foo"baz"
                       foo."baz"

           binary
           bstring
               , A binary string is a sequence of bytes, limited in length by
               available memory. Most language operators cannot be applied to
               data of this type without converting it to another type (e.g.,
               two bstring values cannot be added using the + operator). A
               binary string is not necessarily portable across systems.

                   > "\0\1\2"
                   "000102"


           bareword
               This type is a "literal word" much like Perl's [4mbarewords[24m. A
               bareword consists of an initial alphabetic character, followed
               by any number of alphanumerics and underscores. The resulting
               lexical token must have no other interpretation in the language
               and is treated as if it were a quoted string. This syntactic
               convenience makes these two function calls equivalent:

                   file(test, "-e", foo)
                   file("test", "-e", "foo")

               These two expressions are equivalent and yield "foobaz":


                   foo."baz"
                   foo.baz


           bool
               The boolean values [1mTrue [22mand [1mFalse [22mare either the result of
               evaluating certain expressions or are implicit argument values.
               This is really a pseudo-type because it is represented
               internally as an integer. In the former case, the integer [1m1 [22mis
               the canonical "true" value and [1m0 [22mis considered "false". In the
               latter case, there are several possibilities. If the argument
               is an integer or real, any non-zero value is considered [1mTrue[0m
               and [1m0 [22mis considered [1mFalse[22m. For the string data type, both the
               empty string (i.e., "") and the string "0" are considered [1mFalse[0m
               and anything else is considered [1mTrue[22m. A binary string is
               equivalent to [1mFalse [22mif and only if its length is zero. An empty
               list of either variety ("[]" or "{}") is [1mFalse[22m, while any
               non-empty list or alist is [1mTrue[22m.

           Automatic type conversion is performed when necessary and possible.
           In general, a "lower" type is promoted to a "higher" type (e.g., an
           integer is converted to a real when it is added to a real) and the
           result is of the higher type. Arguments to function calls are
           automatically coerced to the required types. A printable binary
           string (one not containing any "troublesome" control characters)
           can be converted into a string without loss; other binary strings
           are converted into a hexadecimal string representation for
           assignment or display.

           The C/C++ unary cast operation is available for explicit type
           conversion. Not all conversions are supported (e.g., integer to
           binary and binary to string). These type names are case sensitive.

           The language includes the concept of the void type, which cannot be
           stored in a variable, used as an operand, or printed. Some
           functions are void, [34m[1mprint()[0m[1m[22m[6] for example. A value can be [34m[1mcast[0m[1m[22m[7]
           to void.

               [1mNote[0m
               Support for binary data is only partially implemented.

   [1mVariables and Namespaces[0m
       Every variable exists within a namespace. Namespaces exist so that the
       same variable name can exist safely and without ambiguity in different
       contexts. They also serve to group together and name a set of closely
       related variables, and they make it easy for all variables in the set
       to be assigned a characteristic (such as being read-only). For example,
       CGI parameter values are automatically put in the [4mArgs[24m namespace and
       variables automatically created by [1mDACS [22mare put in the [4mDACS[24m namespace.
       Namespaces address the problem of a parameter name that happens to have
       the same name as a variable created by [1mDACS[22m, for example. They also
       allow intermediate results to be stored in their own namespace, also
       avoiding the problem of clashing variable names.

       Variables are not declared in advance. The value of an uninitialized
       variable is the empty string, which is invalid in a numerical context,
       but variables should always be initialized before being used. Some
       variables are created automatically by [1mDACS [22mfrom the execution context
       (e.g., the value of a CGI parameter value, the identity of the client,
       an environment variable), as a side-effect of function evaluation, or
       by an assignment operator.

       The interpreter tries to maintain the natural type of a variable when
       possible, to avoid conversions to and from the string type.

       [1mVariable Syntax[0m
           A variable reference may have either of the following syntaxes:

               ${[[4mnamespace[24m::][4mvariable-name[24m[:[4mflags[24m]}
               $[[4mnamespace[24m::][4mvariable-name[0m

           For instance, the following refers to the value of a variable
           called [4mJURISDICTION_NAME[24m within the namespace called [4mConf[24m:

               ${Conf::JURISDICTION_NAME}

           A variable called [4mJURISDICTION_NAME[24m within a different namespace
           could exist and would be completely distinct.

           A namespace must begin with an alphabetic character and can be
           followed by any number of alphabetics, digits, dashes, and
           underscores. By convention, predefined namespaces begin with an
           upper case letter.

           If the namespace is omitted from a variable reference, a default
           namespace is implied (see below).

           A variable name consists of any number of alphanumeric characters
           (upper and lower case), and characters from this set:

               -_.!~*'()

           Additionally, a "%" character that is followed by two hexadecimal
           characters (upper and lower case) is acceptable.

           If instead of a variable name the character "#" appears, the number
           of variables in the namespace is returned. If the namespace does
           not exist, 0 is returned. For example, the value of this variable
           reference is the number of variables in the [4mConf[24m namespace:

               ${Conf::#}

           When the syntax with braces is used, a variable name may be
           followed by a colon and then one or more modifier flags that affect
           the processing of the variable. Referencing an invalid variable
           name or unknown namespace, or using an undefined modifier flag is
           an error. Referencing an undefined variable yields the empty
           string.

           Variable names are case sensitive by default; namespaces are always
           case sensitive.

           User-defined variables and namespaces are not persistent. They
           disappear when their execution context terminates.

               [1mTip[0m
               A variable reference may not contain any whitespace except when
               it appears after a ?  or + modifier flag.

               [1mTip[0m
               Because many variable references do not include flags or use
               punctuation characters in the variable name, as a convenience
               the braces that surround a variable reference may be omitted in
               certain cases. This is only possible if the variable name
               begins with an alphabetic or an underscore, which can be
               followed by alphanumerics and underscores. A namespace may be
               specified, but flags are not permitted, although the special
               "#" construct is also allowed. The variable name ends with the
               first invalid character. For example, these pairs of variable
               references are equivalent:


                   ${myvar}
                   $myvar

                   ${foo::baz}
                   $foo::baz

               Note that the variable reference ${foo-17} has a valid but
               different interpretation if the braces are omitted.

       [1mVariable Modifier Flags[0m
           A variable reference may include one or more modifier flags that
           control how the reference is to be interpreted.

           The following modifier flags are recognized:

           e
               [4mExists[24m: The "e" modifier flag is used to test whether the
               variable exists (has been defined). Instead of returning the
               value of the variable or causing an error, the value of the
               variable reference is the string "1" if the variable is
               defined, the empty string otherwise (equivalent to [1mFalse[22m).

           i
               [4mInsensitive[24m: When looking up the name of a variable, the
               default is to use a case-sensitive comparison for the variable
               name. To use a case-insensitive comparison instead, an "i" flag
               is used (e.g., [4m${FOO::i}[24m). The namespace lookup is always case
               sensitive.

           n
               [4mNon-empty[24m: The "n" modifier flag tests whether the variable
               exists (has been defined) [4mand[24m is not the empty string (i.e.,
               has zero length). Instead of returning the value of the
               variable or causing an error, the value of the variable
               reference is the string "1" if the variable is defined and is
               not the empty string, otherwise it is the empty string
               (equivalent to [1mFalse[22m).

           z
               [4mZero[24m: The opposite of the "n" flag, instead of returning the
               value of the variable or causing an error, the value of the
               variable reference is the string "1" if the variable is
               undefined or the empty string, otherwise it is the empty string
               (equivalent to [1mFalse[22m).

           ?
               [4mDefault[24m: The "?" modifier flag must appear last if it is used.
               The flag is immediately followed by zero or more characters.
               Its purpose is to associate a default value with the variable
               reference. If the variable is defined and is not empty, then
               the result of the variable reference is the value of the
               variable; otherwise, the result is the evaluation of the
               characters that follow the "?" flag. If no character follows
               the "?" flag, the empty string is indicated. The default may
               itself contain variable references, embedded spaces, etc., and
               is evaluated left to right. Any "}" characters appearing in the
               string before the last closing brace must be escaped by being
               preceded by a backslash.

           +
               [4mSubstitute[24m: The "+" modifier flag must appear last if it is
               used. The flag is immediately followed by zero or more
               characters. Its purpose is to associate a substitute value with
               a variable reference. If the variable is defined and is not the
               empty string, then the result of the variable reference is the
               evaluation of the characters that follow the "+" flag; if the
               variable is undefined or is the empty string, the value of the
               variable reference is the empty string. If no character follows
               the "+" flag, the empty string is indicated. The substitute may
               itself contain variable references, embedded spaces, etc., and
               is evaluated left to right. Any "}" characters appearing in the
               string before the last closing brace must be escaped by being
               preceded by a backslash.
           The i can be combined with any other flag, but it must appear
           first. All other flags are mutually exclusive. Repetitions of a
           flag are ignored. An unrecognized flag raises an error condition.

           Consider these examples:

               ${Args::SCALE:?17}
               ${Foo::bar:i?${Bar::baz\}baz}
               "${DACS::QUERY:+?}${DACS::QUERY:?}"

           In the first example, if [4m${Args::SCALE}[24m is undefined or empty, the
           value of the variable reference is "17" instead of the value of
           [4m${Args::SCALE}[24m. In the second example, if [4m${Foo::bar}[24m (case
           insensitive) is defined, the result is its value, otherwise the
           result is the value of the string "${Bar::baz}baz". In the third
           example, if [4m${DACS::QUERY}[24m is defined and not empty, the value of
           the expression will be a question mark followed by the value of
           [4m${DACS::QUERY}[24m. If [4m${DACS::QUERY}[24m is undefined or empty, the value
           will be the empty string.

       [1mReserved Namespaces[0m
           The following namespaces are predefined by [1mDACS [22mand reserved for
           particular uses. Some are read-only, which means that only [1mDACS [22mcan
           create a variable or change the value of a variable in the
           namespace, except in certain contexts.

           [4mArgs[0m
               Instantiated from query string arguments and the POST data
               stream (if the content type is
               application/x-www-form-urlencoded or multipart/form-data). This
               namespace is read-only.

           [4mArgv[0m
               Instantiated by [1mdacsexpr [22mfrom the command line flags passed to
               the script. The value of [4m${Argv::0}[24m is the name of the file
               being processed, with - signifying the standard input. The next
               argument, if any, will be [4m${Argv::1}[24m, and so on. This namespace
               is read-only.

           [4mAuth[0m
               Used by [34m[1mdacs_authenticate(8)[0m[1m[22m[8] during authentication
               processing.

           [4mConf[0m
               Instantiated with configuration directive variables, this
               namespace is made read-only after configuration processing. See
               [34m[1mdacs.conf(5)[0m[1m[22m[9].

           [4mCookies[0m
               This namespace is instantiated with HTTP cookies that were
               submitted with a request. For security reasons, those
               associated with [1mDACS [22mcredentials are excluded. This is a
               read-only namespace. If a cookie named foo is sent by a user
               agent, an access control rule can access the cookie value as
               [4m${Cookies::foo}[24m.

           [4mDACS[0m
               Instantiated with [1mDACS[22m-specific variables. It is read-only. See
               [34m[1mdacs_acs(8)[0m[1m[22m[10].

           [4mEnv[0m
               For web services, instantiated with the standard [1mApache[0m
               environment variables; for other programs, instantiated from
               the execution environment ([34m[1menviron(7)[0m[1m[22m[11]). It is read-only.

           [4mExecEnv[0m
               Used by [34m[1mexec()[0m[1m[22m[12].

           [4mLDAP[0m
               Used by [1mlocal_ldap_authenticate[22m.

           [4mTemp[0m
               Unless disabled or redefined at build-time, variable references
               that do not include a namespace are associated with this
               namespace as a convenience. The following three expressions are
               therefore equivalent:

                   ${foo} = 17
                   ${Temp::foo} = 17
                   $foo = 17

               In a future release, this mechanism may be generalized to
               provide a run-time means of selecting the default namespace.

   [1mLists, Alists, and Arrays[0m
       [1mDPL [22msupports more complicated data structures based on lists and
       associative lists. These types may also be combined and composed so
       that programmers can create lists of lists, and so on.

       [1mLists[0m
           A list is composed of zero or more basic data types or sub-lists. A
           list is created using the following syntax:

               [4mLIST[24m     -> "[" "]" | "[" [4mLIST-ELS[24m "]"
               [4mLIST-ELS[24m -> [4mEL[24m | [4mEL[24m "," [4mLIST-ELS[0m
               [4mEL[24m       -> [4mBASIC-DATA-TYPE[24m | [4mLIST[0m

           A list can also be created through the [34m[1mlist()[0m[1m[22m[13] function.

           Here is a list consisting of four elements:

               [1, "one", 1.000, ["one sublist"]]

           The [34m[1mlength()[0m[1m[22m[14] function returns the number of elements in a list.

           A list can be assigned to a variable:

               $mylist = [1, 2, 3, 4, 5, 6]
               $mylist_copy = $mylist


               [1mNote[0m
               These two statements are equivalent:

                   $mylist = ["one", "two"]
                   ${mylist} = ["one", "two"]

               And so are these two:

                   $mylist[0]
                   ${mylist}[0]

               Modifier flags therefore do not apply to list elements, only
               the list variable.

           A list or element can be appended to another list using the "."
           ("dot") concatenation operator. List elements can be rotated using
           the ">>" ("shift left") or "<<" ("shift right") operators. The
           compound assignment operator versions of these operators may also
           be used.

               > $mylist=[orange, apple, grape]
               [orange,apple,grape]
               > $mylist . banana
               [orange,apple,grape,banana]
               > $mylist .= [prune,plum]
               [orange,apple,grape,prune,plum]
               > $mylist .= [[lime]]
               [orange,apple,grape,prune,plum,[lime]]
               >$mylist << 1
               [apple,grape,banana,prune,plum,[lime],orange]

           A list element can be referenced using a subscript between zero and
           one less than the number of elements in the list:

               > $mylist = [1, 2, 3, 4, 5, 6]; length($mylist)
               6
               > $mylist[0]
               1

           It is an error to reference a non-existent list element using a
           subscript. (Note: additional syntax may be introduced to provide a
           way to declare lists and arrays.)

           The values of one or more list elements are selected by a list
           reference, which includes the simple subscript case just described.
           The value of a list reference is either a basic data type or a
           list.

               [4mLIST-REFERENCE[24m       -> "[" [4mLIST-REFERENCE-ELS[24m "]"
               [4mLIST-REFERENCE-ELS[24m   -> [4mEMPTY[24m | [4mLIST-REFERENCE-EL[24m | [4mLIST-REFERENCE-EL[24m "," [4mLIST-REFERENCE-ELS[0m
               [4mLIST-REFERENCE-EL[24m    -> [4mEXP[24m | [4mLIST-REFERENCE-SLICE[0m
               [4mLIST-REFERENCE-SLICE[24m -> [4mEXP[24m ".." [4mEXP[0m

               [4mLIST-REFERENCE-SEQ[24m   -> [4mLIST-REFERENCE[24m | [4mLIST-REFERENCE[24m [4mLIST-REFERENCE-SEQ[0m

           An [4mEXP[24m must evaluate to a non-negative integer value. The ".."
           ("dotdot") range operator specifies a sequence of subscripts
           between the value to its left and the value to its right,
           inclusive. The left value must not be greater than the right value.
           If "#" appears to the right of the ".." operator, the number of
           elements in the list variable or the intermediate list computation
           is implied. A "#" may not appear to the left of ".." and may not be
           used in an expression (e.g., "#-2" is invalid). As in a function's
           argument list, a comma is not treated as the comma operator in this
           context. Note that it is not an error to specify non-existent
           elements in a slice; therefore it is possible for the value of a
           list reference to be the empty list.

               > $i=1, $mylist[$i]
               2
               > $mylist[1,3,5]
               [2,4,6]
               > $mylist[0..2,4]
               [1,2,3,5]
               > $mylist[2..#]
               [3,4,5,6]
               > $mylist[0..3]
               [1,2,3,4]

           The dotdot operator can also be used to construct an element of a
           list or alist:

               > $a = [1, 4..8, 10, 12, 13]
               [1,4..8,10,12,13]
               > length($a)
               5
               > $b = [0..2,4]; listref($a, $b)
               [1,4..8,10,13]

           Whether a "[" ... "]" sequence introduces a list constructor or
           list reference depends on the context; if it appears to the right
           of a list variable, list constructor, a function that returns a
           list, or another list reference, it is treated as a list reference.

           List references can be composed as a right-associative operation.
           For example:

               > $a = [[1,2,3], [4,5,6], [7,8,9]]
               [[1,2,3], [4,5,6], [7,8,9]]
               > $a[1][1]
               5
               > $a[0..1][1..2]
               [[4,5,6]]
               > $a[0..1][1..2][0][2]
               6


               [1mTip[0m
               Individual characters and sequences of characters of a
               string-valued expression can be selected using [34m[1mstrchars()[0m[1m[22m[15],
               which uses a similar syntax.

               [1mNote[0m
               +o   The list constructor and list reference syntax has not yet
                   been integrated with the [34m[1mexpression grammar[0m[1m[22m[16].

               +o   A list value can also be assigned to a subscripted
                   variable; only a single subscript is allowed, however, and
                   the referenced element must already exist:

                       > $a = [1, 2, 3]
                       [1,2,3]
                       > $a[2] = 17
                       17
                       > $i = 1
                       1
                       > $a[$i] = [10, 11]
                       [10,11]
                       > $a
                       [1,[10,11],17]



       [1mAlists[0m
           [1mDPL's [22massociative list, or "alist", is similar to Perl's hashes. An
           alist is composed of zero or more pairs. The first element of each
           pair is a case-sensitive key, unique within the alist, that is used
           to index the element. The second element of a pair is its value,
           which may be any data type. The key element of a pair, or all the
           keys in an alist, can be obtained using [34m[1mkeysof()[0m[1m[22m[17]. Similarly,
           [34m[1mvaluesof()[0m[1m[22m[18] yields the value element or a list of value
           elements.

           Unlike a regular list, elements within an alist are not ordered.
           Two alists can only be compared for equality (or inequality); they
           are equal if they contain exactly the same pairs.

           An alist has the following syntax:

               [4mALIST[24m       -> "{" "}" | "{" [4mALIST-PAIRS[24m "}"
               [4mALIST-PAIRS[24m -> [4mALIST-PAIR[24m | [4mALIST-PAIRS[24m "," [4mALIST-PAIR[0m
               [4mALIST-PAIR[24m  -> [4mKEY-EL[24m "," [4mVALUE-EL[0m
               [4mKEY-EL[24m      -> [4mSTRING[0m
               [4mVALUE-EL[24m    -> [4mBASIC-DATA-TYPE[24m | [4mLIST[24m | [4mALIST[0m

           An alist can also be created through the [34m[1malist()[0m[1m[22m[19] function.

           Here is an alist consisting of four elements:

               {"red", 0, "blue", 2, "green", 5, "black", 7}

           The [34m[1mlength()[0m[1m[22m[14] function returns the number of pairs of elements
           in an alist.

           An alist can be assigned to a variable:

               $myalist = {1, 2, 3, 4, 5, 6}
               $myalist_copy = $myalist

           An alist can be appended to another alist using the "." ("dot")
           concatenation operator. The compound assignment operator version of
           this operator may also be used.

               > $myalist={sunny, 3}
               {"sunny", 3}
               > $myalist . {rainy, 11}
               {"sunny", 3, "rainy", 11}
               > $myalist .= {"snowy", 13}
               {"sunny", 3, "snowy", 13}

           An alist element or pair is referenced using a string subscript. A
           sequence of string subscripts can be used to select multiple pairs.
           If the subscript (or subscripts) are within brackets, then a
           successful result will be a basic data type or a list. If the
           subscript (or subscripts) are within braces, then a successful
           result will always be an alist. Note that because an alist
           subscript is not automatically converted to the string type, a
           numeric subscript is illegal.

               > $myalist = {a, 2, b, 4, c, 6}; length($myalist)
               3
               > $myalist["a"]
               2
               > $myalist{"b"}
               {"b", 4}
               > $myalist{"c", "a"}
               {"c", 6, "a", 2}

           It is an error to reference a non-existent alist element. (Note:
           additional syntax may be introduced to provide a way to declare
           lists and arrays.)

           Like regular lists, alist references can be composed as a
           right-associative operation:

               > $myalist = {a, [1, 2], b, [3, 4], c, [5, 6]}; length($myalist)
               3
               > $myalist["a"]
               [1, 2]
               > $myalist{"b"}
               {"b", [3, 4]}
               > $myalist{"b"}[1]
               4

           It is possible to convert an alist to a regular list, or vice
           versa; see the [34m[1mcast[0m[1m[22m[7] operator.

               [1mNote[0m
               There is currently no way to delete an alist pair.

   [1mExpression Grammar[0m
       The following grammar is used to construct an expression (EXP) or
       sequence (S) of expressions.

           [1mNote[0m
           The syntax is very similar to that of the C programming language.
           It differs with respect to data types, variables, compile-time
           operators, and on some minor aspects of grammar.

       A sequence of statements (or simply a sequence) is two or more
       expressions, with a ";" character separating them. The ";" is
       unnecessary following the last statement in a sequence of statements
       (and is therefore unnecessary if there is only one expression). The
       statements are evaluated in the order in which they appear. The value
       of a sequence is that of the last expression, unless an [1mexit [22mor [1mreturn[0m
       function is invoked, in which case the value of the sequence is the
       value returned by the function call. An error condition will also
       terminate evaluation of the sequence and yield a result of [1mFalse[22m. A
       sequence within curly braces is called a block.

       [1mFigure 1. Expression Grammar[0m

           [4mS[24m    -> [4mE[24m    | [4mE[24m ";" | [4mE[24m ";" [4mS[0m
           [4mE[24m    -> [4mE2[24m   | [4mE2[24m "," [4mE[0m
           [4mE2[24m   -> [4mE3[24m   | [4mVAR[24m [4mASSIGN_OP[24m [4mE2[24m | [4mIF_ELSEIF_ELSE[0m
           [4mE3[24m   -> [4mE4[24m   | [4mE4[24m "?" [4mE[24m ":" [4mE[0m
           [4mE4[24m   -> [4mE5[24m   | [4mE5[24m [4mOR[24m [4mE5[0m
           [4mE5[24m   -> [4mE6[24m   | [4mE6[24m [4mAND[24m [4mE5[0m
           [4mE6[24m   -> [4mE7[24m   | [4mE7[24m "|" [4mE7[0m
           [4mE7[24m   -> [4mE8[24m   | [4mE8[24m "^" [4mE8[0m
           [4mE8[24m   -> [4mE9[24m   | [4mE9[24m "&" [4mE9[0m
           [4mE9[24m   -> [4mE10[24m  | [4mE10[24m [4mEQ_OP[24m [4mE10[0m
           [4mE10[24m  -> [4mE11[24m  | [4mE11[24m [4mREL_OP[24m [4mE11[0m
           [4mE11[24m  -> [4mE12[24m  | [4mE12[24m "." [4mE12[0m
           [4mE12[24m  -> [4mE13[24m  | [4mE13[24m "<<" [4mE13[24m | [4mE13[24m ">>" [4mE13[0m
           [4mE13[24m  -> [4mE14[24m  | [4mE14[24m "+" [4mE14[24m  | [4mE14[24m "-" [4mE14[0m
           [4mE14[24m  -> [4mE15[24m  | [4mE15[24m "*" [4mE15[24m  | [4mE15[24m "/" [4mE15[24m | [4mE15[24m "%" [4mE15[0m
           [4mE15[24m  -> [4mE16[24m  | [4mE16[24m "^" [4mE14[24m  | [4mE16[24m "**" [4mE14[0m
           [4mE16[24m  -> [4mE17[24m  | [4mNOT[24m [4mE16[24m | "~" [4mE16[24m | "++" [4mVAR[24m | "--" [4mVAR[0m
                        | "+" [4mE[24m | "-" [4mE[24m | "(" [4mtype[24m ")"
           [4mE17[24m  -> "(" [4mE[24m ")" | [4mVAR[24m "++" | [4mVAR[24m "--" | [4mFUNCTION_CALL[24m | [4mPRIMARY[0m

           [4mASSIGN_OP[24m -> "=" | "+=" | "-=" | "*=" | "/=" | "%=" | ">>="
                            | "<<=" | "&=" | "^=" | "|=" | ".="

           [4mPRIMARY[24m -> [4ma[24m [4mnumber[24m | [4ma[24m [4mstring[24m | [4mVAR[0m
           [4mOR[24m      -> "||" | "or"
           [4mAND[24m     -> "&&" | "and"
           [4mNOT[24m     -> "!"  | "not"
           [4mEQ_OP[24m   -> "==" | "!=" | "eq" | "ne"
           [4mREL_OP[24m  -> "<"  | "<=" | ">" | ">=" | "lt" | "le" | "gt" | "ge"
           [4mVAR[24m     -> [4ma[24m [4mvariable[24m [4mreference[0m
           [4mFUNCTION_CALL[24m -> [4mFUNCTION_NAME[24m "(" [4mARG_LIST[24m ")"
           [4mARG_LIST[24m -> [4mEMPTY[24m | [4mE2[24m | [4mARG_LIST[24m "," [4mE2[0m
           [4mEMPTY[24m    ->

       Keywords and function names are case sensitive.

       The production [4mVAR[24m [4mASSIGN_OP[24m [4mE[24m in the grammar refers to assignment of
       the evaluation of [4mE[24m to a variable using the given assignment operator
       ([4mASSIGN_OP[24m). For example,

           ${a} += 17

       Provided [4m${a}[24m has been initialized to an integer value, this expression
       increments it by 17.

       The production [4mIF_ELSEIF_ELSE[24m represents a familiar if statement with
       zero or more elseif components and an optional else component:

           if ([4mexpression[24m) {
             [4msequence[0m
           }
           [elseif ([4mexpression[24m) {
             [4msequence[0m
           }] ...
           [else {
             [4msequence[0m
           }]

       Each [4mblock[24m is an optional sequence of statements. Braces are mandatory.

           [1mTip[0m
           An if_elseif_else statement has a value: it is either that of the
           last statement executed in the selected block, or the empty string
           if no statement is executed. In this example, [4m${a}[24m is set to either
           33 or ${b} - 1, depending on whether [4m${b}[24m is greater than eight:

               ${a} = if (${b} > 8) {${b}++; 33;} else {${b} - 1}

           The value of this expression is the string "hello, world":

               "hello, " . (if (0) {b . y . e} else {"world"})

           [1mNote[0m
           As in C, function calls, nested assignment operators, and increment
           and decrement operators cause side effects where the value of a
           variable is changed during expression evaluation. Because exactly
           when such side effects take place is left unspecified, programmers
           should avoid writing code with these kinds of dependencies on
           evaluation ordering.

   [1mOperators[0m
       The operators that appear in the grammar have the following semantics.
       They are listed in order of increasing precedence (which is very close
       to ISO C's), with operators in the same section having equal
       precedence. The result of applying an operator is one of the [34m[1msupported[0m
       [1m[34mdata types[0m[1m[22m[20], or an error. Parentheses can be applied to
       subexpressions in the usual way.

       Whenever it makes sense, intermediate values are automatically
       converted to an appropriate type by an operator. So, for example,
       adding an integer and a real will cause the integer to automatically be
       converted to a real, yielding a real value. Adding a string and a
       number will work only if the string can be successfully converted to a
       number. In situations where an integer is required, a real value
       (including a string that represents a valid real number) will be
       truncated to an integer. For logical comparison operators, the operands
       will both be converted to integers, reals, or strings as necessary. A
       string value that is an illegal number will always be treated as a
       string.

           [1mNote[0m
            id="note11" xreflabel="dacsexpr prompts".PP In the examples that
           follow, the '>' character at the beginning of an input line is a
           prompt from [34m[1mdacsexpr(1)[0m[1m[22m[1].

       ,
           This is the C/C++ comma operator. A pair of expressions separated
           by a comma is evaluated left to right, and the type and value of
           the result are the type and value of the right operand.

       =, +=, -=, *=, /=, %=, >>=, <<=, &=, ^=, |=, .=
           Assignment is done using a simple or compound assignment operator,
           each of which has right to left associativity. In the case of a
           compound assignment operator, the left hand side is evaluated only
           once. The type and value of an assignment is that of its right hand
           side. A variable reference is expected on the left side of the
           operator. Modifier flags are not permitted. The variable, which is
           created if it does not exist. The syntax of the variable reference
           includes the initial "${" and terminating "}" character (so it's
           similar to [1mPerl[22m's syntax).

               > ${foo::bar} = "hello"
               "hello"
               > ${foo::bar} .= ", world"
               "hello, world"
               > ${a} = [1, 2]
               [1,2]
               > ${a} .= [3, 4]
               [1,2,3,4]


       ?:
           This is equivalent to the C/C++ conditional expression, which has
           right to left associativity. If the first expression is [1mTrue[22m, the
           result is the value of the second expression (the third is not
           evaluated). If the first expression is [1mFalse[22m, the result is the
           value of the third expression (the second is not evaluated).

       or, ||
           This is the C/C++ logical OR operator, which yields [1m1 [22m([1mTrue[22m) if
           either operand is [1mTrue[22m, otherwise it yields [1m0 [22m([1mFalse[22m). Evaluation
           is from left to right and and stops as soon as the truth or
           falsehood of the result is known. The two tokens are synonymous.

       and, &&
           This is the C/C++ logical AND operator, which yields [1m1 [22m([1mTrue[22m) if
           both operands are [1mTrue[22m, otherwise it yields [1m0 [22m([1mFalse[22m). Evaluation
           is from left to right and and stops as soon as the truth or
           falsehood of the result is known. The two tokens are synonymous.

               [1mNote[0m
               When expressions are parsed as XML attribute values, an '&'
               character must be encoded as the five characters '&amp;'.

       |
           This is the C/C++ bitwise inclusive OR operator. Both operands must
           be integers.

       ^
           This is the C/C++ bitwise exclusive OR operator. Both operands must
           be integers.

       &
           This is the C/C++ bitwise AND operator. Both operands must be
           integers.

               [1mNote[0m
               When expressions are parsed as XML attribute values, an '&'
               character must be encoded as the five characters '&amp;'.

       ==, !=, eq, ne, eq:i, ne:i
           These operators compare their arguments and return 1 if the
           relation is true, 0 otherwise. If both arguments are lists,
           corresponding elements of both lists are compared, recursively. If
           both arguments are alists, the number of pairs in both lists is
           compared and, if necessary, pairs in the first list are looked up
           in the second list for matching values (note that the
           case-insensitive variant applies only to the value component of a
           pair, not the key component). For other valid arguments an attempt
           is first made to coerce both arguments to numbers and do a numeric
           comparison. If that fails, a lexicographic comparison is performed.
           Operators having a :i modifier are like their counterparts without
           the modifier except they do case-insensitive string comparisons.

           If either argument is of type bstring, however, the comparison is
           done differently than explained above. Two bstring arguments are
           equal if and only if they are byte-wise identical. If one argument
           is a bstring and the other is a string, the latter is treated as a
           bstring of length([4mstring[24m) bytes. The case flag is ignored if at
           least one argument is a bstring.

       <, <=, >, >=, lt, le, lt:i, le:i, gt, ge, gt:i, ge:i
           These operators compare their arguments and return 1 if the
           relation is true, 0 otherwise. An attempt is first made to coerce
           both arguments to numbers and do a numeric comparison. If that
           fails, a lexicographic comparison is performed. Operators having a
           :i modifier are like their counterparts without the modifier except
           they do a case-insensitive comparison.

               [1mNote[0m
               When expressions are parsed as XML attribute values, the '<'
               character must be encoded as the four characters '&lt;'; the
               same applies to the "greater than" symbol.
           If either argument is of type bstring, however, the comparison is
           done differently than explained above. If two bstring arguments are
           compared, the shorter bstring is "less than" the other argument and
           they are equal if and only if they are byte-wise identical. If one
           argument is a bstring and the other is a string, the latter is
           treated as a bstring of length([4mstring[24m) bytes. The case flag is
           ignored if at least one argument is a bstring.

       .
           The "dot" operator (not in ISO C) concatenates its right operand to
           its left operand. If both arguments are of type bstring, the result
           is also of type bstring. If the left operand is a list and the
           right operand is a basic data type, the right operand is appended
           to the list. If the left operand is a list and the right operand is
           also a list, the elements of the right operand are appended to the
           left operand. A list may not appear as the right operand if the
           left operand is not a list. In all other cases, both arguments are
           coerced to string (an error occurs if this cannot be done) before
           the left operand is appended to the right.

               > "hello" . ", world"
               "hello, world"
               > "hello" . (16 + 1)
               "hello17"
               > 17 . (16 + 1)
               "1717"
               > [1, 2, 3] . 4
               [1,2,3,4]
               > [1, 2, 3] . [4, 5, 6]
               [1,2,3,4,5,6]
               > [1, 2, 3] . [[4]]
               [1,2,3,[4]]


               [1mNote[0m
               A period will be recognized as a decimal point in a real number
               context rather than as the dot operator, so the input:

                   4.5

               will be scanned as a number whereas, for example, the input:

                   "4".5

               will evaluate to the string "45".

       <<, >>
           These are the C/C++ bitwise left shift and right shift operators,
           respectively. The first operand may be an integer or a list, the
           second operand must be an integer. When shifting an integer, these
           operators are implemented using the corresponding C/C++ operators.
           In the case of right shifting, the behaviour with respect to
           arithmetic vs. logical shifts will be platform dependent.

       +, -
           These are the (binary) addition and subtraction operators,
           respectively. Both arguments are coerced to numbers. An error
           occurs if this cannot be done. Also, unary + and - operators may
           precede an arithmetic-valued expression.

       *, /, %
           These are the multiplication, division, and remainder operators,
           respectively. Both arguments are coerced to numbers. An error
           occurs if this cannot be done, such as attempting to divide by
           zero. For the remainder operator, both operands must be integers.

       **
           This is the exponentiation operator (not in ISO C). Both arguments
           are coerced to numbers (either both integers or both reals). An
           error occurs if this cannot be done, such as attempting to raise to
           a negative power.

               > 2**10
               1024


       +, -, not, !, ~, ++[4mVAR[24m, --[4mVAR[24m, ([4mtype[24m)
           The + and - operators are the (unary) arithmetic plus and minus
           operators, respectively. These may precede an arithmetic-valued
           expression. Both arguments are coerced to numbers. An error occurs
           if this cannot be done.

           The logical NOT operator (not, or equivalently, !) yields a result
           of zero when applied to a non-zero numeric value and non-zero when
           applied to an operand of zero. The result of applying this operator
           to a non-empty string is zero and it is non-zero when applied to an
           empty string string. These two tokens are synonymous.

           The ~ operator is the one's complement (bitwise not) unary
           operator.

           The ++[4mVAR[24m and --[4mVAR[24m operators are the prefix increment and
           decrement operators, respectively. These operators are followed by
           a variable reference. The variable must have an integer value.

               > ${foo} = 17, ++${foo}
               18

           An explicit type conversion can be forced by using a cast. The
           syntax for this type coercion is:

               ([4mtype[24m) [4mexpression[0m

           The [4mtype[24m must be a recognized data type name: integer or int (for
           an integer), real or double (for a real), bool (for a boolean value
           as a long integer), string (for a character string), bstring or
           binary (for a binary string), list, alist, or void.

           A list can be cast to an alist, provided it has no elements or an
           even number of elements and if no key would appear more than once
           in the alist. A namespace can be cast to an alist; the operand
           specifies the namespace, either as a literal or a string. An alist
           can be cast to an list; the ordering of the pairs in the resulting
           list is unspecified. A void type can only be cast to void, which is
           a no-op. Here are some examples:

               > (int) 3.4
               3
               > (int) "3.6"
               3
               > (bool) 17
               1
               > (bool) ""
               0
               > (string) (4 * 3)
               "12"
               > ${x} = "17"; (int) ((real) ${x} + (bool) 1965)
               18
               > (bstring) "abc"
               "abc"
               > (bstring) 4.4
               "4.400000"
               > (bstring) "\0\1\2"
               ""
               > bstring("\0\1\2",3) . bstring("\3\4", 3)
               "0001020304"
               > (void) ($b=$x)
               >
               > (alist) [a, 1, "b", 2, 3, 3]
               {"a", 1, "b", 2, "3", 3}
               > (list) { red, first, blue, second, white, third }
               ["blue", "second", "white", "third", "red", "first"]
               > $env = (alist) Env; $env["HOME"]
               "/home/bobo"
               > $env{HOME}
               {"HOME","/home/bobo"}


       [4mVAR[24m++, [4mVAR[24m--, primary
           The [4mVAR[24m++ and [4mVAR[24m-- operators are the postfix increment and
           decrement operators, respectively. These operators are preceded by
           a variable reference. The variable must have an integer value.

           A primary is a basic [34m[1mdata type[0m[1m[22m[20] (i.e., an integer or real
           number, string, bareword, or binary string), or a [34m[1mvariable[0m
           [1m[34mreference[0m[1m[22m[21].

   [1mFunctions[0m
       A function call is written as a function name, optionally followed by
       whitespace, a left parenthesis, zero or more comma-separated arguments,
       and a right parenthesis. A function name begins with either an
       alphabetic character or an underscore, followed by any number of
       alphanumerics and underscores. Additionally, a pair of colons may
       appear exactly once within the name (except at the beginning or end of
       the name). The number of arguments and their expected types depends on
       the particular function being called. The order in which the arguments
       to a function are evaluated is undefined. There is no mechanism for
       creating user-defined functions yet (they will eventually be available
       on some platforms through dynamically linked libraries).

       The result of a function call is one of the [34m[1msupported data types[0m[1m[22m[20],
       or an error. An invalid function call, including those that fail during
       execution, yields a [1mFalse [22mresult.

       [1mFunction Index:[0m

       +o   [1mack[22m: notice acknowledgement processing

       +o   [1malist[22m: create an alist

       +o   [1malistref[22m: create an alist reference

       +o   [1mbstring[22m: convert a string to binary

       +o   [1mcontains_any[22m: count elements common to two lists

       +o   [1mcounter[22m: persistent integer counters

       +o   [1mdacs_admin[22m: test if user is an administrator

       +o   [1mdacs_approval[22m: create or test a signed authorization

       +o   [1mdacs_meta[22m: get or update metadata

       +o   [1mdacsauth[22m: perform authentication tests

       +o   [1mdacscheck[22m: perform authorization tests

       +o   [1mdebug[22m: control debugging output

       +o   [1mdecode[22m: convert from a text representation

       +o   [1mdigest[22m: cryptographic hash functions

       +o   [1mencode[22m: convert to a text representation

       +o   [1meval[22m: evaluate a string

       +o   [1mexec[22m: execute a program

       +o   [1mexit[22m: terminate current evaluation

       +o   [1mexpand[22m: variable interpolation

       +o   [1mfile[22m: perform an operation on a file

       +o   [1mfile_group[22m: test if user is associated with file's group

       +o   [1mfile_owner[22m: test if user is associated with file's owner

       +o   [1mfrom[22m: test where the current request comes from

       +o   [1mget[22m: read the contents of a file or VFS object

       +o   [1mhash[22m: fast hashes

       +o   [1mhmac[22m: secure keyed-hashes

       +o   [1mhttp[22m: invoke an HTTP request

       +o   [1mindex[22m: search a string or list

       +o   [1minfo[22m: information about namespaces and variables

       +o   [1mkeysof[22m: extract keys from an alist

       +o   [1mldap[22m: extract a component from an LDAP name

       +o   [1mlength[22m: string length

       +o   [1mlist[22m: create a list

       +o   [1mlistref[22m: dereference a list

       +o   [1mon_success[22m: evaluate an expression if authentication or
           authorization succeeds

       +o   [1mpassword[22m: compute or check a password hash

       +o   [1mpathname[22m: filename-based string interpolation

       +o   [1mpbkdf2[22m: password-based key derivation

       +o   [1mprint[22m: display a string

       +o   [1mprintf[22m: display a formatted string

       +o   [1mrandom[22m: generate random values

       +o   [1mredirect[22m: redirect user after access is denied

       +o   [1mregmatch[22m: string matching

       +o   [1mregsub[22m: string substitution

       +o   [1mrequest_match[22m: compare the current request to a URI

       +o   [1mreturn[22m: terminate current evaluation

       +o   [1mrule[22m: recursive authorization checking

       +o   [1msetvar[22m: operations on namespaces

       +o   [1msizeof[22m: basic data type sizes

       +o   [1msleep[22m: suspend execution temporarily

       +o   [1msource[22m: read and evaluate external expressions

       +o   [1msprintf[22m: format a string

       +o   [1mstrchars[22m: select characters from a string

       +o   [1mstrftime[22m: format the current date and time

       +o   [1mstrptime[22m: parse a date and time

       +o   [1mstrrstr[22m: locate the last instance of a substring

       +o   [1mstrstr[22m: locate the first instance of a substring

       +o   [1mstrtolower[22m: map uppercase to lowercase

       +o   [1mstrtoupper[22m: map lowercase to uppercase

       +o   [1mstrtr[22m: character transliteration

       +o   [1msubset[22m: test if one set is a subset of another

       +o   [1msubstr[22m: extract a substring

       +o   [1msyntax[22m: perform a syntax check on a string

       +o   [1mtime[22m: local time and date

       +o   [1mtransform[22m: filter text through rule-based transformations

       +o   [1mtransform_config[22m: set options for transform

       +o   [1mtrim[22m: delete trailing characters

       +o   [1mtypeof[22m: get or test data type

       +o   [1mundef[22m: an undefined value

       +o   [1muser[22m: test current user's identity

       +o   [1mustamp[22m: generate a unique stamp

       +o   [1mvaluesof[22m: extract values from an alist

       +o   [1mvar[22m: operations on individual variables

       +o   [1mvfs[22m: perform a VFS operation

       [1mack[22m([4mnotice-uri[24m[, [4m...[24m][, EXACT_MATCH | ALL_MATCH])
           This function is associated with notice acknowledgement processing.
           The function indicates that the current service request has one or
           more notices associated with it (identified by a sequence of
           [4mnotice-uri[24m arguments), each one represented by a URI that will
           return the text of a notice that must be acknowledged by the user.
           Following the last URI is an optional mode argument. The
           EXACT_MATCH mode is the default mode and requires a single
           acknowledgement to address all of the specified notices. The
           ALL_MATCH argument specifies a less stringent matching mode and
           requires any set of acknowledgements to collectively address all of
           the specified notices. See [34m[1mdacs_notices(8)[0m[1m[22m[22].

       [1malist[22m([[4mkey[24m, [4mvalue[24m [, ...])
           This function is equivalent to the [34m[1malist construction operator[0m[1m[22m[23].
           There must be an even number of arguments, or no arguments. If the
           first argument of each pair (the key) is not a string or literal,
           it will be converted to a string, if possible.

               alist(cars, 2, bikes, 5)

           is equivalent to the expression:

               {"cars", 2, "bikes", 5}

           And the call:

               alist(2, xx, [0, 1], yy)

           yields:

               {"2", xx, "[0,1]", yy}


       [1malistref[22m([4mlist[24m)
           This function creates a new list that is equivalent to that of the
           special "brace syntax" subscript used to dereference an alist. This
           is currently useful only in conjunction with [34m[1mlistref()[0m[1m[22m[24].

               listref({"a", 1, "b", 2, "c", 3}, alistref(["b"]))

           is equivalent to the expression:

               {"a", 1, "b", 2, "c", 3}{"b"}

           the value of which is:

               {"b", 2}


       [1mbstring[22m([4mstring[24m, [4mlength[24m)
           This function converts the first [4mlength[24m characters of [4mstring[24m (which
           may also be a bstring and which is converted to a string if
           necessary) into the binary type. The [4mlength[24m argument may be less
           than the actual length of [4mstring[24m; if it is zero, then actual length
           is computed, and if [4mlength[24m is greater than the actual length, the
           actual length is used. The implicit null character on the end of
           [4mstring[24m is not considered part of it.

               > bstring("\0\1\2", 4)
               "000102"
               > bstring("\0\1\2", 2)
               "0001"


       [1mcontains_any[22m([4mformat[24m, [4mtest-set[24m, [4mtarget-set[24m[, nocase])
           This function returns a count of the number of elements of [4mtest-set[0m
           that appear in [4mtarget-set[24m at least once. Duplicate elements may
           appear in [4mtest-set[24m and are considered to be distinct. The [4mformat[0m
           indicates how to parse the set arguments. It can be the space, tab,
           or newline character, or any punctuation character. For both sets,
           it is currently interpreted as the character that separates
           elements. If the optional nocase literal argument is given, then
           set elements are compared case-insensitively. The greatest possible
           return value is the number of distinct elements in the third
           parameter.

               contains_any(",", ${Args::LAYERS:i}, "Nests,Secret_roads,Heritage")
               contains_any(",", "a,a,b,z", "a,a,a,b,b,b,a,z,z")

           The first expression returns [1m3 [22mif every element in the third
           parameter appears at least once (case insensitive) in the second
           parameter, otherwise the value of the expression is [1m0[22m. The second
           expression returns [1m4[22m.

       [1mcounter[22m([4mop[24m, [4mvfs-ref[24m, [4mcounter_name[24m [,[4mvalue[24m])
           This function is used to manage persistent integer counters, which
           can be useful for a variety of purposes, such as counting the
           number of logins for a particular identity, limiting the number of
           logins, or restricting the number of times a resource can be
           accessed. Internally, counter values are [34m[1mintegers[0m[1m[22m[20].

           The first argument specifies an operation and is case-insensitive.
           The second argument identifies a filestore (typically a file or
           database). It must be an indexed filestore scheme, such as
           dacs-kwv-fs or dacs-db (see [34m[1mVFS[0m[1m[22m[25]). The third argument is the
           name of the counter, which acts as a key. The meaning of the fourth
           argument depends on the operation, but if present it must be an
           integer.

               [1mNote[0m
               The current implementation has a limitation; a counter name
               (key) can be any printable string but cannot contain a space
               character. You can work around this limitation by encoding all
               keys every time they are used in a filestore operation.

            1. counter(set, [4mvfs-ref[24m, [4mcounter_name[24m, [4mnew-value[24m)

               This is used to create a new counter or reset an existing
               counter. The counter's value will be [4mnew-value[24m, which must be
               an integer, and is the return value.

            2. counter(create, [4mvfs-ref[24m, [4mcounter_name[24m, [4minitial-value[24m)

               This is used to create a new counter if it does not already
               exist. The new counter's value will be [4minitial-value[24m, which
               must be an integer. If the counter exists, its value will not
               be changed and is returned.

            3. counter(del[ete], [4mvfs-ref[24m, [4mcounter_name[24m)

               This operation deletes an existing counter. The operation can
               be del or delete.

            4. counter(exists, [4mvfs-ref[24m, [4mcounter_name[24m)

               This operation returns 1 if a counter exists, 0 otherwise.

            5. counter(get, [4mvfs-ref[24m, [4mcounter_name[24m)

               This operation returns the current counter value.

            6. counter(inc|dec, [4mvfs-ref[24m, [4mcounter_name[24m[, [4mamount[24m])

               This operation increments or decrements an existing counter by
               [4mamount[24m, which must be an integer. If [4mamount[24m is not given, 1 is
               used. The updated counter value is returned.

            7. counter(decdel, [4mvfs-ref[24m, [4mcounter_name[24m[, [4mamount[24m])

               This operation decrements an existing counter by [4mamount[24m, which
               must be an integer. If [4mamount[24m is not given, 1 is used. If the
               resulting value is zero or negative, the counter is deleted and
               zero is returned. If the counter is not deleted, its updated
               value is returned.

            8. counter(list, [4mvfs-ref[24m)

               This operation returns a list of counters as a string, newline
               separated, each with its current value.

               Operations that set or change the counter value return the new
               value.

               For filestores that support locking, read-only operations
               obtain a shared lock while the other operations obtain an
               exclusive lock.

               It is an error to reference a counter that does not exist
               unless the operation is set or exists.

                   [1mNote[0m
                   To some extent, this function is a poor substitute for a
                   more general Perl-like [1mtie() [22mfunction. Such a function is
                   being considered.

                   Modifications to counters are not atomic. Amongst other
                   things, this means that a crash may cause counter updates
                   to be lost.
               A counter would typically be created by running [34m[1mdacsexpr(1)[0m[1m[22m[1]:

                   % dacsexpr -e 'counter(set, "dacs-kwv-fs:/usr/local/dacs/counters/logins", "EXAMPLE::EX:bob", 1)'

               The counter's value might then be tested in the [34m[1mrevocation[0m
               [1m[34mlist[0m[1m[22m[26] or by an [34m[1maccess control rule[0m[1m[22m[27], for instance:

                   counter(exists, "dacs-kwv-fs:/usr/local/dacs/counters/logins", ${DACS::IDENTITY})

               The counter might be conditionally updated using the
               [34m[1mon_success()[0m[1m[22m[28] function, or the [34m[1mAUTH_SUCCESS[0m[1m[22m[29] or
               [34m[1mACS_SUCCESS[0m[1m[22m[30] directives, using an expression like:

                   counter(decdel, "dacs-kwv-fs:/usr/local/dacs/counters/logins", ${DACS::IDENTITY})


           [1mdacs_admin[22m()
               This predicate returns [1mTrue [22mif the user making a service
               request has any credentials that match any specified by the
               [34m[1mADMIN_IDENTITY[0m[1m[22m[31] configuration directive.

           [1mdacs_approval[22m([4mop[24m[, ...])
               This function is used to create an [34m[1mapproval stamp[0m[1m[22m[32] or
               inspect or validate one.

               The following operations are available:

               [1mdacs_approval[22m(approval, [4mdacs64-approval-message[24m, [4mnamespace[24m)
                   This operation parses the [4mdacs64-approval-message[24m (the
                   value of [1mDACS_APPROVAL[22m), setting variables in [4mnamespace[24m,
                   after first [34m[1mdacs64 decoding[0m[1m[22m[33] the argument. If [4mnamespace[0m
                   exists, its contents are deleted. Variables set are: [4mj[0m
                   (jurisdiction name), [4mh[24m (hash/digest name), [4ms[24m (stamp), [4mu[0m
                   (URI), [4mm[24m (HTTP method), and [4mi[24m (user identity). See
                   [34m[1mdacs_acs(8)[0m[1m[22m[32]. The signature is [4mnot[24m checked. The function
                   returns [1mTrue [22m(1) if the approval message is syntactically
                   correct, otherwise [1mFalse [22m(0).

               [1mdacs_approval[22m(check, [4mdacs64-approval-message[24m)
                   The [4mdacs64-approval-message[24m is decoded and parsed, and the
                   signature is validated. The function returns [1mTrue [22m(1) only
                   if the signature is correct, otherwise [1mFalse [22m(0).

                   In the current implementation, the signature can only be
                   validated by the jurisdiction that signed the message. This
                   deficiency will be addressed in a future release and a web
                   service will also supply this functionality. Ideally, for
                   maximum convenience, availability, efficiency, and
                   simplicity, the recipient of an approval message should be
                   able to validate it directly if it has the appropriate
                   public key, invoke a web service at any jurisdiction in the
                   federation if public keys are distributed and kept current,
                   or at the jurisdiction that signed the message.

               [1mdacs_approval[22m(create, [4muri[24m, [4mmethod[24m, [4mident[24m, [4mdigest-name[24m)
                   Create and return a [4mdacs64-approval-message[24m (as described
                   above and in [34m[1mdacs_acs(8)[0m[1m[22m[32]), formed from the given
                   arguments and signed by the current jurisdiction.


           [1mdacs_meta[22m([4mop[24m[, ...])
               This function returns information associated with the current
               federation, current jurisdiction, or other jurisdictions in the
               current federation. See [34m[1mdacs_list_jurisdictions(8)[0m[1m[22m[34] for
               additional information.

               The following operations are available:

               [1mdacs_meta[22m(federation, [4mnamespace[24m)
                   Return metadata for the current federation, setting
                   variables in [4mnamespace[24m. If [4mnamespace[24m exists, its contents
                   are deleted. Variables set are: [4mfederation[24m, [4mdomain[24m, [4mfed_id[0m
                   (if available), and [4mfed_public_key[24m (if available, in PEM
                   format).

               [1mdacs_meta[22m(jname, [4mjurisdiction-name[24m, [4mnamespace[24m)
                   Return metadata for the jurisdiction named
                   [4mjurisdiction-name[24m in the current federation. If [4mnamespace[0m
                   exists, its contents are deleted. Variables set are: [4mjname[24m,
                   [4mname[24m, [4malt_name[24m, [4mdacs_url[24m, [4mauthenticates[24m, [4mprompts[24m, [4mauxiliary[0m
                   (if available), and [4mpublic_key[24m (if available, in PEM
                   format).

               [1mdacs_meta[22m(jurisdiction, [4mnamespace[24m)
                   This is equivalent to the jname operation with
                   [4mjurisdiction_name[24m set to the name of the current
                   jurisdiction.

               [1mdacs_meta[22m(list_jurisdictions)
                   Return a newline-separated list of all jurisdiction names
                   in the current federation. A local copy of the metadata is
                   used.

               [1mdacs_meta[22m(update_jurisdiction, [4mjname[24m [,[4murl[24m])
                   [4mNot[24m [4mimplemented[24m. Intended to update the local metadata for
                   the jurisdiction name [4mjname[24m. If [4murl[24m is absent, then the
                   current jurisdiction must already have the correct dacs_url
                   attribute in its entry for [4mjname[24m. If [4murl[24m is given, it is
                   assumed to be the URL for [1mdacs_list_jurisdictions [22mand it is
                   used instead of one formed from dacs_url for the
                   jurisdiction.

               [1mdacs_meta[22m(update_jurisdictions, [4mjname[24m)
                   [4mNot[24m [4mimplemented[24m. Intended to update the local metadata for
                   all of the jurisdictions. If [4mjname[24m looks like a URL (i.e.,
                   it begins with either "http" or "https", then it is assumed
                   to be the URL for [1mdacs_list_jurisdictions [22mand it is used to
                   obtain a fresh copy of the metadata; otherwise, [4mjname[24m is
                   assumed to be a jurisdiction name for which the current
                   jurisdiction already has a correct dacs_url attribute and
                   metadata is retrieved from that jurisdiction.


           [1mdacsauth[22m([4mdacsauth-flags[24m)
           [1mdacsauth[22m([4marg1[24m, [4marg2[24m[, ...])
               This function provides an interface to [34m[1mdacsauth(1)[0m[1m[22m[35]. In the
               first usage, the single string argument is parsed into space or
               tab separated flags. Single or double quotes are allowed. In
               the second usage, each flag is a separate string or literal
               argument and is not parsed.

               An alist is returned that has the following three elements:

               result
                   An integer: 1 if authentication succeeded, 0 if it failed
                   or was not requested, and -1 if an error occured.

               identity
                   A string: if authentication was requested and succeeded,
                   this is the corresponding identity, otherwise it is the
                   empty string.

               roles
                   A string: if roles were requested (and authentication
                   succeeded, if requested), this is the role descriptor
                   string, otherwise it is the empty string.


                   [1mImportant[0m
                   This function should be considered experimental. Use it
                   with caution. In version 1.4.25 and earlier, this function
                   returned an integer value (the result).

                   [1mSecurity[0m
                   Like [1mdacsauth [22mand [1mdacs_authenticate[22m, if a built-in module
                   is used to perform authentication, this function must be
                   run by a setuid or setgid process to obtain sufficient
                   privileges to access the required files; this is true for
                   Unix password authentication, for example.
               Examples: .sp .if n  .RS 4 . .fam C .ps -1 .nf .if t  .sp -1 .
               .BB lightgray adjust-for-leading-newline .sp -1 > dacsauth("-m
               unix suff -user bobo -p apassword")
               {"result",0,"identity","","roles",""} > dacsauth("-m", "unix",
               "suff", "-user", "bobo", "-p", "bpassword")
               {"result",1,"identity","EXAMPLE::FEDROOT:bobo","roles",""} >
               dacsauth("-r unix
               -DVFS='[federation_keys]dacs-fs:/usr/local/dacs/federations/federation_keys'
               -u bobo")
               {"result",0,"identity","","roles","bobo,wheel,www,users"} .EB
               lightgray adjust-for-leading-newline .if t  .sp 1 . .fi .fam
               .ps +1 .if n  .RE . .sp

           [1mdacscheck[22m([4mdacscheck-flags[24m)
           [1mdacscheck[22m([4marg1[24m, [4marg2[24m[, ...])
               This function provides an interface to [34m[1mdacscheck(1)[0m[1m[22m[36],
               returning 1 if access is granted, 0 if access is denied, and -1
               if an error occurs. In the first usage, the single string
               argument is parsed into space or tab separated flags. Single or
               double quotes are allowed. In the second usage, each flag is a
               separate string or literal argument and is not parsed.

                   [1mImportant[0m
                   This function should be considered experimental. Use it
                   with caution.

           [1mdebug[22m([4mtype[24m, [4mvalue[24m)
               This function enables, disables, or adjusts the amount of
               debugging output produced by the interpreter. Output type [4mtype[0m
               is set to [4mvalue[24m, which may be "on", "off", or a non-negative
               integer level (the meaning of which depends on [4mtype[24m.

               The following [4mtype[24m names are recognized: TBD

           [1mdecode[22m([4mencoding-type[24m, [4mstring[24m)
               This function performs the inverse of [34m[1mencode()[0m[1m[22m[37] for the same
               [4mencoding-type[24m. The result is a bstring. The function will fail
               if its argument is not properly encoded.

               For the hex encoding type, alphabetic characters may be upper
               case or lower case.

           [1mdigest[22m([4mmsg[24m, [4mmsg-len[24m [, [4mdigest-name[24m])
               This function computes a [34m[1mcryptographic hash[0m[1m[22m[38] of [4mmsg[24m (a
               string or bstring). The [4mmsg-len[24m is the length of [4mmsg[24m in bytes;
               if it is 0, its length is computed. The hash algorithm can be
               any function provided by [1mOpenSSL [22mand may be specified as
               [4mdigest-name[24m, case insensitively, otherwise SHA1 is used. The
               list of available digest algorithms is subject to change, but
               is likely to include md5, sha, sha1, sha224, sha256, sha384,
               and sha512. The function value is a bstring. If cryptographic
               strength is not required, see [34m[1mhash()[0m[1m[22m[39].

                   > digest("foo", 0, "md5")
                   "acbd18db4cc2f85cedef654fccc4a4d8"
                   > digest("Hello, world", 0, "SHA256")
                   "4ae7c3b6ac0beff671efa8cf57386151c06e58ca53a78d83f36107316cec125f"


           [1mencode[22m([4mencoding-type[24m, [4marg[24m)
               This function converts [4marg[24m, a string or bstring, into a
               printable text representation that depends on [4mencoding-type[24m.
               Applying [34m[1mdecode()[0m[1m[22m[40] with the same [4mencoding-type[24m to the output
               of this function will produce a value equivalent to the
               original [4marg[24m. The result is a string.

               Note that encoding is only a representational or formatting
               change. If secrecy, authentication, or verification of
               integrity are required, use a cryptographic method.

               The following encoding types are recognized:

               [1mencode[22m(ascii85, [4marg[24m)
                   This encoding, also known as [34m[1mradix-85[0m[1m[22m[41], uses nearly
                   every printable character to obtain a compact encoding. But
                   note that the resulting strings may be problematic in many
                   contexts without additional encoding, which can largely
                   defeat the reason for selecting this encoding in the first
                   place. The start-of-data ("<~") and end-of-data ("~>")
                   indicators that are sometimes used with this encoding are
                   not included.

                       > encode(ascii85, decode(hex, "123456789a"))
                       "&i<X6RK"


               [1mencode[22m(cescape, [4marg[24m)
                   This encoding converts its argument into a C-style escaped
                   string. Character escape codes are used when possible,
                   numeric escape codes are used for other non-printable
                   characters, and all other characters map to themselves.

                       > encode(cescape, bstring("hi\0\1\2\3\012", 7))
                       "hi\0\001\002\003\n"


               [1mencode[22m(dacs64, [4marg[24m)
                   This encoding type produces a base-64 encoding of [4marg[24m using
                   upper- and lower-case alphabetics, digits, '-', and '_'. It
                   is similar to the mime encoding except that '-' and '_' are
                   used in the encoding character set instead of '+' and '/'.
                   This encoding is better suited for use in paths and URIs,
                   for example, and is used extensively within [1mDACS[22m. It is
                   sometimes referred to as "the dacs64 encoding" or just
                   "dacs64" in the [1mDACS [22mdocumentation.

                       > encode(dacs64, bstring("\0\0\0\1", 4))
                       "_____-"


               [1mencode[22m(hex, [4marg[24m)
                   This encoding converts each byte in [4marg[24m into a hexadecimal
                   character pair.

                       > encode(hex, "Hello")
                       "48656c6c6f"


               [1mencode[22m(mime, [4marg[24m)
                   This encoding applies the MIME base-64 encoding function
                   ([34m[1mRFC 2045[0m[1m[22m[42], Section 6.8) to its argument and returns the
                   result.

                       > encode(mime, bstring("\0\0\0\1", 4))
                       "AAAAAQ=="


               [1mencode[22m(url, [4marg[24m)
                   This returns the URL-encoding of the argument ([34m[1mRFC[0m
                   [1m[34m1738[0m[1m[22m[43], [34m[1mRFC 2396[0m[1m[22m[44] (Section 2.4), and [34m[1mRFC 3986[0m[1m[22m[45]).

                       > encode(url, bstring("a\0b", 3))
                       "a%00b"



           [1meval[22m([4mexpression[24m)
               This function evaluates its string argument and returns the
               result.

               The call:

                   > eval("length(\"abc\")")
                   3

           [1mexec[22m([4mprog[24m, [4m...[24m)
               The [1mexec [22mfunction executes [4mprog[24m, waits (indefinitely) for it to
               terminate, and returns the program's standard output. A
               trailing newline in the output is deleted. Optionally, command
               line arguments to [4mprog[24m may be given; they are automatically
               converted to strings. By default, no environment variables are
               passed to the program; if the namespace [4mExecEnv[24m exists,
               however, its contents are used as the executed program's
               environment variables. The exit status of [4mprog[24m is made
               available as the value of [4m${DACS::status}[24m. The program is
               executed using the [34m[1mexecv(3)[0m[1m[22m[46] function, not a command shell.

               On POSIX systems, this call returns the string "1\n" on
               Thursdays, "0\n" on any other day:

                   > exec("/bin/sh", "-c", "date | grep -c ^Thu")
                   "0"



                   > ${ExecEnv::PATH} = "/usr/bin";
                   "/usr/bin"
                   > exec("/bin/sh", "-c", "printenv");
                   "PATH=/usr/bin"


                   [1mSecurity[0m
                   The program is executed as the same user and group IDs as
                   the [1mDACS [22mprogram that calls [1mexec()[22m. Take appropriate
                   precautions to prevent unauthorized users from modifying or
                   replacing [1mDACS [22mconfiguration files, access control rules,
                   and so on.

           [1mexit[22m([4mresult[24m)
               Equivalent to [1mreturn[22m, this function causes evaluation of the
               expression, block, or program being evaluated to terminate and
               returns [4mresult[24m as the value of the expression or the program's
               exit status.

           [1mexpand[22m([4mstring[24m)
               The argument, a string, is returned with variable references
               expanded. An undefined variable expands to the empty string.

                   > ${a} = 17
                   17
                   > "${a}"
                   "17"
                   > '${a}'
                   "${a}"
                   > expand('${a}')
                   "17"
                   > ${b} = 1999, ${c} = expand('${a}, \${b}')
                   "17, ${b}"
                   > expand(${c})
                   "17, 1999"


           [1mfile[22m([4mop[24m [,[4marg-list[24m])
               This function performs various operations on files and
               filenames according to [4mop[24m, which is one of the following
               operation names, followed by command-specific arguments. All
               arguments must either be strings or literal words.

                1. file(basename, [4mstring[24m [,[4msuffix[24m])

                   This is used to extract the last component of a pathname
                   and is equivalent to the [34m[1mbasename(1)[0m[1m[22m[47] command. It
                   deletes any prefix that ends with the last slash character
                   in [4mstring[24m, after first stripping trailing slashes, and a
                   [4msuffix[24m, if present. The [4msuffix[24m is [4mnot[24m stripped, however, if
                   it is identical to the remaining characters in [4mstring[24m. A
                   non-existent suffix is ignored. The value is the resulting
                   string.

                       > file(basename,"/a/b/c")
                       "c"
                       > file(basename,"/a/b/c.c")
                       "c.c"
                       > file(basename,"/a/b/c.c", ".c")
                       "c"
                       > file(basename,"/a/b/c.c", "c")
                       "c."
                       > file(basename,"/a/b/c.c", "c.c")
                       "c.c"
                       > file(basename,"/a/b/c.c//", "c.c")
                       "c.c"


                2. file(chmod, [4mabs-mode[24m, [4mfile[24m)

                   Change the mode of [4mfile[24m to [4mabs-mode[24m, which is an absolute
                   (octal) file mode (note, however, that [1mDACS [22malways set the
                   process [1mumask [22mto 07).

                       file(chmod, "0755", "/usr/local/dacs/tmp/foofile")

                3. file(dirname, [4mstring[24m)

                   Equivalent to the [34m[1mdirname(1)[0m[1m[22m[48] command, its value is the
                   string that remains after deleting the filename portion of
                   [4mstring[24m (a pathname), beginning with the last slash
                   character to the end of [4mstring[24m, after first stripping
                   trailing slashes.

                       > file(dirname,"/usr/local/dacs/bin/dacsexpr")
                       "/usr/local/dacs/bin"
                       > file(dirname,"/usr/local/dacs///")
                       "/usr/local"


                4. file(extension, [4mpathname[24m)

                   The returned value is all of the characters in [4mpathname[0m
                   after and including the last dot in the last element. If
                   there is no dot in the last element of [4mpathname[24m, the value
                   is the empty string.

                       > file(extension,"acl-myapp.0")
                       ".0"


                5. file(lstat, [4mfmt[24m, [4mfile[24m)

                   This is like the [34m[1mstat[0m[1m[22m[49] operation, except in the case
                   where the named file is a symbolic link, in which case
                   [1mlstat [22mreturns information about the link, while [1mstat[0m
                   returns information about the file the link references.

                6. file(mkdir, [4mdirectory[24m [,abs-mode])

                   Create [4mdirectory[24m. If an absolute (octal) mode is given, the
                   new directory will have that mode (note, however, that [1mDACS[0m
                   always set the process [1mumask [22mto 07).

                7. file(readlink, [4mfile[24m)

                   If [4mfile[24m is a symbolic link, print its contents.

                8. file(remove, [4mfile[24m)

                   Remove (delete) [4mfile[24m.

                9. file(rename, [4msource-file[24m, [4mtarget-file[24m)

                   Rename (mv) [4msource-file[24m to [4mtarget-file[24m.

               10. file(rmdir, [4mdirectory[24m)

                   Remove (delete) [4mdirectory[24m, which must be empty.

               11. file(stat, [4mfmt[24m, [4mfile[24m)

                   Similar to the [34m[1mstat(1)[0m[1m[22m[50] command available on some
                   systems, this makes the functionality of the [34m[1mstat(2)[0m[1m[22m[51]
                   system call available. The [4mfmt[24m argument is a
                   [34m[1mprintf(3)[0m[1m[22m[52]-type descriptor that indicates what file
                   status information is wanted and how it is to be printed.
                   Non-formatting characters, including \n, \t, and \\, are
                   copied to the output verbatim.

                   The following format specifiers are understood:

                   +o   %d

                       The value of [4mst_dev[24m.

                   +o   %i

                       The value of [4mst_ino[24m.

                   +o   %m

                       The value of [4mst_mode[24m in octal.

                   +o   %M

                       The value of [4mst_mode[24m as text.

                   +o   %l

                       The value of [4mst_nlink[24m.

                   +o   %u

                       The value of [4mst_uid[24m in decimal.

                   +o   %U

                       The value of [4mst_uid[24m as text.

                   +o   %g

                       The value of [4mst_gid[24m in decimal.

                   +o   %G

                       The value of [4mst_gid[24m as text.

                   +o   %r

                       The value of [4mst_rdev[24m.

                   +o   %s

                       The value of [4mst_size[24m.

                   +o   %b

                       The value of [4mst_blksize[24m.

                   +o   %n

                       The value of the [4mfile[24m argument.

                   +o   %N

                       If the argument is a symbolic link, print the contents
                       of the link, otherwise print the [4mfile[24m argument.

                   +o   %ta

                       The value of [4mst_atime[24m in decimal.

                   +o   %tA

                       The value of [4mst_atime[24m as text.

                   +o   %tm

                       The value of [4mst_mtime[24m in decimal.

                   +o   %tM

                       The value of [4mst_mtime[24m as text.

                   +o   %tc

                       The value of [4mst_ctime[24m in decimal.

                   +o   %tC

                       The value of [4mst_ctime[24m as text.

                   +o   %f

                       The name of the host (fileserver) where the file is
                       stored.

                   +o   %%

                       A literal '%' character.

                       This excerpt from an access control rule limits access
                       to authenticated users for every file greater than 999
                       bytes in length that it [1mDACS[22m-wraps:

                           <allow>
                             user("auth")
                           </allow>

                           <allow>
                             user("any") and file(stat, "%s", ${DACS::FILENAME}) lt 1000
                           </allow>


                   12. file(test, [4mop[24m [, [4margs[24m])

                       Most of the file-testing predicates of the [34m[1mtest(1)[0m[1m[22m[53]
                       command are available.

                       +o   [1m-b  [4m[22mfile[0m

                           [1mTrue [22mif [4mfile[24m exists and is a block special file.

                       +o   [1m-c  [4m[22mfile[0m

                           [1mTrue [22mif [4mfile[24m exists and is a character special
                           file.

                       +o   [1m-d  [4m[22mfile[0m

                           [1mTrue [22mif [4mfile[24m exists and is a directory.

                       +o   [1m-e  [4m[22mfile[0m

                           [1mTrue [22mif [4mfile[24m exists, regardless of its type.

                       +o   [1m-f  [4m[22mfile[0m

                           [1mTrue [22mif [4mfile[24m exists and is a regular file.

                       +o   [1m-g  [4m[22mfile[0m

                           [1mTrue [22mif [4mfile[24m exists and its set group ID flag is
                           set.

                       +o   [1m-k  [4m[22mfile[0m

                           [1mTrue [22mif [4mfile[24m exists and its sticky bit is set.

                       +o   [1m-p  [4m[22mfile[0m

                           [1mTrue [22mif [4mfile[24m exists and is a named pipe (FIFO).

                       +o   [1m-r  [4m[22mfile[0m

                           [1mTrue [22mif [4mfile[24m exists and is readable (access(file,
                           R_OK) == 0).

                       +o   [1m-s  [4m[22mfile[0m

                           [1mTrue [22mif [4mfile[24m exists and has a size greater than
                           zero bytes.

                       +o   [1m-u  [4m[22mfile[0m

                           [1mTrue [22mif [4mfile[24m exists and its set user ID flag is
                           set.

                       +o   [1m-w  [4m[22mfile[0m

                           [1mTrue [22mif [4mfile[24m exists and is writable (access(file,
                           W_OK) == 0).

                       +o   [1m-x  [4m[22mfile[0m

                           [1mTrue [22mif [4mfile[24m exists and is executable (access(file,
                           X_OK) == 0).

                       +o   [1m-L  [4m[22mfile[0m

                           [1mTrue [22mif [4mfile[24m exists and is a symbolic link.

                       +o   [1m-O  [4m[22mfile[0m

                           [1mTrue [22mif [4mfile[24m exists and its owner matches the
                           effective user id of this process.

                       +o   [1m-G  [4m[22mfile[0m

                           [1mTrue [22mif [4mfile[24m exists and its group matches the
                           effective group id of this process.

                       +o   [1m-S  [4m[22mfile[0m

                           [1mTrue [22mif [4mfile[24m exists and is a socket.

                       +o   [1m-nt  [4m[22mfile1[24m [4mfile2[0m

                           [1mTrue [22mif [4mfile1[24m and [4mfile2[24m exist and the former is
                           newer than the latter.

                       +o   [1m-ot  [4m[22mfile1[24m [4mfile2[0m

                           [1mTrue [22mif [4mfile1[24m and [4mfile2[24m exist and the former is
                           older than the latter.

                       +o   [1m-ef  [4m[22mfile1[24m [4mfile2[0m

                           [1mTrue [22mif [4mfile1[24m and [4mfile2[24m exist and refer to the same
                           file.

                   13. file(touch, [4mfile[24m [, [4mabs-mode[24m])

                       If [4mfile[24m does not exist, it is created; if an absolute
                       (octal) mode is given, the new file will have that mode
                       (note, however, that [1mDACS [22malways set the process [1mumask[0m
                       to 07). If the file exists, its modification time will
                       be set to the current date and time.

                   [1mfile_group[22m([[4mpath[24m])
                       Test if [4mpath[24m (defaults to [4m${DACS::FILENAME}[24m, which is
                       equivalent to Apache's [1mSCRIPT_FILENAME [22mor
                       [4mREQUEST_FILENAME[24m variables) has a group ownership with
                       which the user making the request is associated. This
                       is effectively the same as:

                           file(test, "-e", ${DACS::FILENAME})
                           and
                           user("%" . ${Conf::JURISDICTION_NAME} . ":" \
                             . file(stat, "%G", ${DACS::FILENAME}))

                       This predicate provides a simple way of limiting access
                       to a file to its group membership with respect to file
                       system permissions:

                           <allow>
                             file_group()
                           </allow>

                       For example, if the user requesting access has been
                       assigned the following roles by the current
                       jurisdiction (e.g., through [1mlocal_unix_roles[22m):

                           wheel,www,users

                       and the resource being requested is the file:

                           -rw-r--r--  1 bobo     www  75 Apr 11 12:41 htdocs/foo.html

                       then this predicate would return [1mTrue [22mbecause the file
                       has group ownership www and the user is associated with
                       that role.

                       There is an implicit assumption that the file in
                       question is associated with the current jurisdiction;
                       this might be problematic if more than one jurisdiction
                       can claim this association.

                   [1mfile_owner[22m([[4mpath[24m])
                       Test if [4mpath[24m (defaults to [4m${DACS::FILENAME}[24m, which is
                       equivalent to Apache's [1mSCRIPT_FILENAME [22mor
                       [4mREQUEST_FILENAME[24m variables) is owned by the user making
                       the request. This is effectively the same as:

                           file(test, "-e", ${DACS::FILENAME})
                           and
                           user(${Conf::JURISDICTION_NAME} . ":" . file(stat, "%U", ${DACS::FILENAME}))

                       This predicate provides a simple way of limiting access
                       to a file to its owner with respect to file system
                       permissions:

                           <allow>
                             file_owner()
                           </allow>

                       There is an implicit assumption that the file in
                       question is associated with the current jurisdiction;
                       this might be problematic if more than one jurisdiction
                       can claim this association.

                   [1mfrom[22m([4mstring[24m)
                       This predicate is used to test where a request comes
                       from, based on the values of [1mREMOTE_ADDR [22mand
                       [1mREMOTE_HOST[22m. These environment variables are passed to
                       [1mDACS [22mfrom [1mApache[22m. The supported argument types are
                       similar to those recognized by the [1mApache[0m
                       [34m[1mmod_access[0m[1m[22m[54] module's allow and deny directives. If
                       either [1mREMOTE_HOST [22mor [1mREMOTE_ADDR [22mare needed to
                       evaluate the argument but are not available, the result
                       will be [1mFalse[22m.

                       The string argument may be:

                        1. a full or partially matching domain name:

                               from("metalogic.example.com")

                           Here, the function yields [1mTrue [22mif the given domain
                           name matches [1mREMOTE_HOST [22mor is a subdomain of
                           [1mREMOTE_HOST[22m. Case-insensitive matching is performed
                           ([34m[1mRFC 1035[0m[1m[22m[55]). Only complete components are
                           matched, so the above example will match
                           foo.metalogic.example.com but not
                           foonmetalogic.example.com. If [1mREMOTE_ADDR [22mis
                           available but not [1mREMOTE_HOST[22m, a reverse DNS lookup
                           will be performed on the domain name and all IP
                           addresses that result will be tested against
                           [1mREMOTE_ADDR[22m; if this lookup results in an error
                           (i.e., it fails), then the function raises an error
                           condition.

                        2. a full IPv4 address in standard dot notation:

                               from("10.0.0.123")

                        3. a partial IPv4 address (the first one, two, or
                           three bytes) in standard dot notation:

                               from("10.0")

                        4. a network/netmask pair:

                               from("10.0.0.0/255.255.0.0")

                        5. a network/nnn pair using [34m[1mCIDR notation[0m[1m[22m[56] ([34m[1mRFC[0m
                           [1m[34m1338[0m[1m[22m[57]):

                               from("10.0.0.0/8")

                        6. a full or partial IPv4 address in standard dot
                           notation where any address element can be a decimal
                           number (0 through 255) or a [34m[1mrange[0m
                           [1m[34mspecification[0m[1m[22m[58], similar to that used with
                           [34m[1mstrchars()[0m[1m[22m[15]; note that the range separator in
                           this context is ":" instead of "..": :

                               from("10.0.[0:100,255]")

                           In the example above, the two high-order octets of
                           [4m${DACS::REMOTE_ADDR}[24m must be 10 and 0, the value of
                           the next octet must be between 0 and 100
                           (inclusive) or be 255 (decimal), and the value of
                           the fourth octet is unimportant. The following
                           expressions are equivalent:

                               from("10")
                               from("10.")
                               from("[10]")
                               from("[10].")
                               from("10.0.0.0/8")
                               from("10.0.0.0/255.0.0.0")


                        7. "all" (always yields [1mTrue [22mand is included for
                           compatibility with [1mApache[22m):

                               from("all")
                           An alternative method is to perform a regular
                           expression match against [4m${DACS::REMOTE_ADDR}[24m using
                           [34m[1mregmatch()[0m[1m[22m[59].

                               [1mTip[0m
                               To test where a client authenticated from,
                               which is not necessarily the same as the place
                               from which a request is sent, use the
                               [34m[1muser()[0m[1m[22m[60] function.

                       [1mget[22m([4mvfs-ref[24m [,[4mkey[24m])
                           The file or item specified by [4mvfs-ref[24m, which may be
                           followed by a [4mkey[24m if it is an indexed filestore, is
                           read and returned. The [4mvfs-ref[24m may be an absolute
                           pathname, an item type, or a [34m[1mvfs_uri[0m[1m[22m[61], except if
                           called from a standalone application without a [4mkey[0m
                           argument, in which case [4mvfs-ref[24m may also be a
                           relative pathname.

                               [1mNote[0m
                               A proper I/O subsystem does not exist yet, but
                               until then you may use the special item type
                               stdin to read the standard input until end of
                               file. This function will probably not work if a
                               special file is used (e.g., /dev/stdin).

                       [1mhash[22m([4mmsg[24m, [4mmsg-len[24m [,[4mhash-name[24m])
                           This function computes a fast hash of [4mmsg[24m, a string
                           or bstring. The [4mmsg-len[24m is the length of [4mmsg[24m in
                           bytes; if it is 0, its length is computed. The
                           [4mhash-name[24m can be the 32-bit hash "hash32" (the
                           default) or the 64-bit hash "hash64". The result is
                           a string. Although the algorithms have been used
                           extensively with very good results, they should not
                           be used for cryptographic purposes; see
                           [34m[1mdigest()[0m[1m[22m[62].

                               > hash("Hello, world", 0)
                               "3696529580"
                               > hash("Hello, world", 0, hash64)
                               "462009511995194717"


                       [1mhmac[22m([4mmsg[24m, [4mmsg-len[24m, [4mkey[24m, [4mkey-len[24m [, [4mdigest-name[24m])
                           This function computes a cryptographic [34m[1mmessage[0m
                           [1m[34mauthentication code[0m[1m[22m[63] - specifically, the
                           [34m[1mKeyed-Hash Message Authentication Code (HMAC)[0m[1m[22m[64] -
                           of [4mmsg[24m (a string or bstring), using [4mkey[24m (a string
                           or bstring). The [4mmsg-len[24m is the length of [4mmsg[24m in
                           bytes; if it is 0, its length is computed.
                           Similarly, [4mkey-len[24m is the length of [4mkey[24m in bytes
                           and if it is 0, its length is computed. Any of the
                           available [34m[1mSecure Hash Standard functions[0m[1m[22m[65], as
                           well as [34m[1mMD5 (RFC 2104)[0m[1m[22m[66], may be specified as
                           [4mdigest-name[24m (case insensitively), otherwise SHA1 is
                           used. The list of available digest algorithms is
                           subject to change, but is likely to include md5,
                           sha1, sha224, sha256, sha384, and sha512. The
                           function value is a bstring. Note that the function
                           is not commutative; the key is the third argument,
                           not the first. Although the MD5 hash function is
                           deprecated for some purposes, it is still
                           considered adequate in some applications and is
                           required by many older protocols that are still in
                           widespread use.

                               > hmac("Sample #2", 0,
                                 decode(hex, "303132333435363738393a3b3c3d3e3f40414243"), 0)
                               "0922d3405faa3d194f82a45830737d5cc6c75d24"


                       [1mhttp[22m([4murl[24m, [[4mmethod[24m [,[4marglist[24m]])
                           This function sends an HTTP request to [4murl[24m, using a
                           given method (GET, POST, HEAD, PUT, DELETE, or
                           OPTIONS, case insensitively), and optionally
                           passing parameters. If no method is given (and no
                           arguments), GET is assumed. The value of the
                           function is the message returned by the request.
                           The [4murl[24m is in the usual syntax and must use either
                           the http or https scheme (case insensitive). The
                           argument list, if present, consists of some number
                           of pairs, the first being the name of the parameter
                           and the second the value of the parameter.

                           The first statement sends an HTTP request to
                           example.com and sets the variable to the message
                           body (if any) that is returned. The second
                           statement makes a GET request to port 8443 of
                           example.com over SSL, passing it two parameters,
                           FOO=17 and FOO=2:

                               > ${x} = http("http://example.com")
                               > http("https://example.com:8443/cgi-bin/dacs_prenv.cgi", "GET", "FOO", 17,
                                     "BAZ", 1+1)


                       [1mindex[22m([4mstring[24m, [4mcharacter-class[24m [, nocase])
                       [1mindex[22m([4mlist[24m, [4msearch_operand[24m [, nocase])
                           If the first argument is a string, this function
                           returns the first position in [4mstring[24m (counting from
                           1) where the first character in [4mcharacter-class[24m was
                           found, or 0. Case-sensitive character comparison is
                           used unless the optional [4mnocase[24m literal argument is
                           present.

                           If the first argument is a list, the position of
                           element [4msearch_operand[24m (counting from 1) in [4mlist[24m is
                           returned, or 0 if it is not found. During
                           comparison, types are automatically converted as
                           necessary. Case-sensitive character comparison is
                           used unless the optional [4mnocase[24m literal argument is
                           present.

                           Examples:

                               > index("abcdef", "abc")
                               1
                               > index("abcdef", "e")
                               5
                               > index("zzz", "abc")
                               0
                               > index([a, b, c, d, e], d)
                               4
                               > index(["hello", world, 2009, qUAKe], "quake", nocase)
                               4
                               > index([1.0, 2.2, 3.3, 4.4, 5.0, 6.6], "1")
                               1
                               > index(["apple", ["orange", "banana"], ["peach", "mango"]], "orange")
                               0
                               > index(["apple", ["orange", "banana"], ["peach", "mango"]], ["orange", "banana"])
                               2


                       [1minfo[22m(namespaces)
                       [1minfo[22m(namespace, [4mnamespace-name[24m)
                           Return a string containing information about
                           variables and namespaces. The first form returns a
                           comma-separated list of known namespaces. The
                           second form returns a list containing all variables
                           in the given namespace and their values, one per
                           line. This can be useful for debugging.

                           Examples:

                               info(namespaces)
                               info(namespace, "Conf")


                       [1mkeysof[22m([4malist[24m)
                           If its argument is a single pair, the pair's key is
                           returned. If there is more than one pair in the
                           argument, a list of keys is returned. To get the
                           value component of a pair or set of pairs, use
                           [34m[1mvaluesof()[0m[1m[22m[18].

                           Examples:

                               > keysof({red, 17})
                               "red"
                               > keysof({red, 17, blue, 100})
                               ["red", "blue"]


                       [1mldap[22m(dn_length, [4mdn-string[24m)
                       [1mldap[22m(dn_index, [4mdn-string[24m, [4mnth[24m)
                       [1mldap[22m(rdn_length, [4mrdn-string[24m)
                       [1mldap[22m(rdn_index, [4mrdn-string[24m, [4mnth[24m)
                       [1mldap[22m(rdn_attrtype, [4mrdn-string[24m [, [4mnth[24m])
                       [1mldap[22m(rdn_attrvalue, [4mrdn-string[24m [, [4mnth[24m])
                           The [1mldap [22mfunction is used to extract components of
                           LDAP names. Its first argument, a literal,
                           determines the operation mode to be used and the
                           semantics of the following arguments. Distinguished
                           Name (DN) and Relative Distinguished Name (RDN)
                           strings are as defined in [34m[1mRFC 2253[0m[1m[22m[67].

                           The dn_length mode returns the number of RDN
                           components in its DN argument; -1 is returned if
                           the argument is not a valid DN. The dn_index mode
                           returns the [4mnth[24m RDN component of the DN, where [4mnth[0m
                           is an integer greater than zero. If [4mnth[24m is greater
                           than the number of components, the last component
                           is returned.

                           The rdn_length mode returns the number of
                           AttributeTypeAndValue elements in its RDN argument;
                           -1 is returned if the argument is not a valid RDN.
                           The rdn_index mode returns the [4mnth[0m
                           AttributeTypeAndValue component of the RDN, where
                           [4mnth[24m is an integer greater than zero. If [4mnth[24m is
                           greater than the number of components, the last
                           component is returned.

                           The rdn_attrtype mode returns the AttributeType of
                           the [4mnth[24m AttributeTypeAndValue component of the RDN,
                           where [4mnth[24m is an integer greater than zero. If [4mnth[0m
                           is missing, it is taken to be 1. If [4mnth[24m is greater
                           than the number of components, the last component
                           is selected. The rdn_attrvalue mode is similar
                           except that it returns the AttributeValue.

                           The first and second expressions below return 2,
                           the third expression returns Administrator:

                               ldap(dn_length, "dc=example,dc=com")
                               ldap(rdn_length, "foo=bar+bar=baz")
                               ldap(rdn_attrvalue, ldap(dn_index, \
                                   "CN=Administrator,CN=Users,DC=example,DC=com", 1))


                       [1mlength[22m([4mstring[24m)
                       [1mlength[22m([4mbstring[24m)
                       [1mlength[22m([4mlist[24m)
                       [1mlength[22m([4malist[24m)
                           This function returns the length, in characters, of
                           [4mstring[24m, the number of bytes in binary string
                           [4mbstring[24m, the number of elements in [4mlist[24m, or the
                           number of pairs in [4malist[24m.

                       [1mlist[22m([[4mvalue[24m [, ...])
                           This function is equivalent to the [34m[1mlist[0m
                           [1m[34mconstruction operator[0m[1m[22m[68].

                               list(1, 2, [hello, world], 5)

                           is equivalent to the expression:

                               [1, 2, [hello, world], 5]


                       [1mlistref[22m([4mlist[24m, [4mlist-ref[24m [, ...])
                           This function provides an alternate syntax to the
                           language's list/array notation. For example, the
                           function call:

                               listref([1, 2, [3, 4], 5], 2, 1)

                           is equivalent to the expression:

                               [1, 2, [3, 4], 5][2][1]

                           Note that a list reference may follow a list-valued
                           expression (e.g., a list constructor, a list-valued
                           variable, a function that returns a list) this
                           syntax is valid:

                               ($a . $b)[0]

                           The parentheses are necessary here because the
                           subscript binds more tightly than the concatenation
                           operator. This expression can also be written as:

                               listref($a . $b, 0)


                       [1mon_success[22m([4mlist-name[24m [, [4mexpr[24m])
                           The [4mlist-name[24m argument must be either acs or auth
                           (case insensitive) to select the post-authorization
                           list or the post-authentication list, respectively.
                           For the former case, if authorization is
                           successful, the [4mexpr[24m argument (a string) will be
                           evaluated by [1mdacs_acs [22mimmediately after any
                           [34m[1mACS_SUCCESS[0m[1m[22m[30] directive, and just prior to
                           program termination. These expressions are not
                           evaluated if authorization is denied, an
                           authorization processing error occurs, or a
                           [4mDACS_ACS[24m argument prevents execution of the
                           request. For the latter case, if authentication is
                           successful, the [4mexpr[24m argument (a string) will be
                           evaluated by [34m[1mdacs_authenticate(8)[0m[1m[22m[8] immediately
                           after any [34m[1mAUTH_SUCCESS[0m[1m[22m[29] directive, and just
                           prior to program termination. These expressions are
                           not evaluated if authentication fails or an
                           authentication processing error occurs.

                           Once added to either list, an entry cannot be
                           removed. The expressions are evaluated in the order
                           in which [1mon_success() [22mwas called. The values
                           returned by the expressions are discarded and
                           errors are ignored.

                           If no [4mexpr[24m is given, the current list of
                           expressions is returned, one per line, in order of
                           evaluation. With an expression argument, it returns
                           the number of expressions in the list after any
                           addition.

                       [1mpassword[22m([4mop[24m [, [4mop-args[24m])
                           This function performs a variety of read-only
                           operations on [1mDACS [22maccounts and their passwords.
                           See [34m[1mdacspasswd(1)[0m[1m[22m[69] and directives
                           [34m[1mPASSWORD_DIGEST[0m[1m[22m[70] and [34m[1mPASSWORD_SALT_PREFIX[0m[1m[22m[71]
                           for additional information.

                           The following operations are available:

                           [1mpassword[22m(check, [4mgiven-password[24m, [4mpassword-digest[0m
                           [,[4malg-name[24m])
                               With the check operation, the digest of
                               [4mgiven-password[24m is computed (as computed by the
                               hash operation) and compared to
                               [4mpassword-digest[24m, which was previously generated
                               by the hash operation of this function,
                               retrieved by the getdigest operation, or
                               obtained using [1mdacspasswd[22m. This algorithm is
                               identical to the one used by
                               [34m[1mlocal_passwd_authenticate[0m[1m[22m[72] to validate
                               passwords. If [4malg-name[24m is given, it names the
                               digest algorithm to use instead of the one
                               specified within [4mpassword-digest[24m. If
                               [4mgiven-password[24m is correct (i.e., the same
                               passwords were used to generate the two digest
                               values), [1mTrue [22m(1) is returned, otherwise [1mFalse[0m
                               (0) is returned.

                           [1mpassword[22m(getdata, [4musername[24m [,[4mvfs-ref[24m])
                               The getdata operation returns the private data
                               associated with the account for [4musername[24m. The
                               result is a bstring. If there is no private
                               data, the length of the result will be zero
                               (the length of the empty string is one). If a
                               [4mvfs-ref[24m is given, it identifies the virtual
                               filestore to use, otherwise the item type
                               passwds is used. It is an error if the account
                               does not exist, so a test operation will often
                               be performed first.

                           [1mpassword[22m(getdigest, [4musername[24m [,[4mvfs-ref[24m])
                               The getdigest operation is similar to getdata
                               except that the digest string for the account
                               is returned; this digest string can be used
                               with the check operation.

                           [1mpassword[22m(hash, [4mplain-password[24m [,[4malg-name[24m])
                               With the hash operation, a digest of the string
                               [4mplain-password[24m is returned as a printable
                               string. The password hashing algorithm is
                               identical to the one used by [34m[1mdacspasswd(1)[0m[1m[22m[69].
                               If [4malg-name[24m is given (see [34m[1mdigest()[0m[1m[22m[62]), it
                               names the digest algorithm to use instead of
                               the configured default.

                           [1mpassword[22m(list [, [4mvfs-ref[24m])
                               The list operation returns a list of account
                               names, one per line. An empty string is
                               returned if there are no accounts. If a [4mvfs-ref[0m
                               is given, it identifies the virtual filestore
                               to use, otherwise the item type passwds is
                               used. To test if a password file exists, use
                               [34m[1mvfs()[0m[1m[22m[73].

                           [1mpassword[22m(syntax, [4mpassword[24m [,[4mconstraints[24m])
                               The syntax operation tests if [4mpassword[0m
                               satisfies the [4mconstraints[24m argument, if
                               provided, otherwise the value of the
                               [34m[1mPASSWORD_CONSTRAINTS[0m[1m[22m[74] directive. The
                               [4mconstraints[24m are specified in the same syntax as
                               the PASSWORD_CONSTRAINTS directive. The
                               function returns [1mTrue [22m(1) if the constraints
                               are satisfied, otherwise [1mFalse [22m(0).

                           [1mpassword[22m(test, [4mtest-op[24m, [4musername[24m [,[4mvfs-ref[24m])
                               The test operation applies [4mtest-op[24m to the
                               account entry for [4musername[24m in the virtual
                               filestore [4mvfs-ref[24m (or item type passwds). It is
                               an error if the password file does not exist or
                               is unreadable. It returns [1mTrue [22mif the test is
                               successful, otherwise the result is [1mFalse[22m. The
                               recognized values of [4mtest-op[24m are (case
                               insensitively): data (to test if the account
                               exists and has private data), disabled (to test
                               if the account exists and is disabled), enabled
                               (to test if the account exists and is enabled),
                               or exists (to test if the account exists).

                           Examples:

                               > password(hash, "bobo")
                               "2|XYZZYxBhU/7VgJAt2lc.G|HL4RQ2vo0uNoXlXnv.GcY3Vlf9."
                               > password(check, "bobo", "2|XYZZYxBhU/7VgJAt2lc.G|HL4RQ2vo0uNoXlXnv.GcY3Vlf9.")
                               1


                       [1mpathname[22m([4mpath[24m, [4mhostname[24m, [4mport[24m)
                           Perform string interpolation on [4mpath[24m based on the
                           other arguments. For details, please see
                           [34m[1mdacs.conf(5)[0m[1m[22m[75] (where [4mhostname[24m is [1mSERVER_NAME[22m).

                       [1mpbkdf2[22m([4mpassword[24m, [4msalt[24m, [4mcount[24m, [4mdklen[24m)
                           Apply a pseudorandom function (HMAC-SHA-1) to
                           [4mpassword[24m and [4msalt[24m (both binary strings, or
                           converted as required), modified by [4mcount[0m
                           iterations, returning a binary string of length
                           [4mdklen[24m bytes. For details, please see [34m[1mRFC 2898[0m[1m[22m[76]
                           and [34m[1mRFC 3962[0m[1m[22m[77].

                               > pbkdf2("password", "ATHENA.MIT.EDUraeburn", 1200, 32)
                               "5c08eb61fdf71e4e4ec3cf6ba1f5512ba7e52ddbc5e5142f708a31e2e62b1e13"
                               > pbkdf2("password", decode(hex,"1234567878563412"), 5, 16)
                               "d1daa78615f287e6a1c8b120d7062a49"


                       [1mprint[22m([4m...[24m)
                           Each argument is converted to a string, the strings
                           are concatenated, a newline is appended, and the
                           result is printed. The return type is void. If
                           called from [34m[1mdacsexpr(1)[0m[1m[22m[1], the string is printed
                           to the standard output; otherwise, it is printed to
                           the [1mDACS [22mlog file (or stderr), which can be useful
                           for debugging purposes. These log messages are
                           associated with the user class (see the
                           [34m[1mLOG_FILTER[0m[1m[22m[78] directive).

                       [1mprintf[22m([4mfmt[24m, [4m...[24m)
                           This is a slightly scaled-down version of the
                           [34m[1mprintf(3)[0m[1m[22m[52] library function. If called from
                           [34m[1mdacsexpr(1)[0m[1m[22m[1], the string is printed to the
                           standard output; otherwise, it is printed to the
                           [1mDACS [22mlog file (or stderr), which can be useful for
                           debugging purposes. These log messages are
                           associated with the user class (see the
                           [34m[1mLOG_FILTER[0m[1m[22m[78] directive). This can be useful for
                           debugging purposes. If necessary and possible,
                           arguments are converted to the type requested by a
                           formatting specification. The return type is void.

                       [1mrandom[22m(bytes, [4mnbytes[24m)
                       [1mrandom[22m(uint, [4mlo[24m, [4mhi[24m)
                       [1mrandom[22m(string, [4mnbytes[24m [, [4mspec[24m])
                       [1mrandom[22m(stringc, [4mnbytes[24m, [4mspec[24m)
                           The various forms of this function, distinguished
                           by the first argument, return [34m[1mcryptographically[0m
                           [1m[34mstrong pseudo-random values[0m[1m[22m[79] in various formats.
                           The starting point (seed value) for the
                           pseudo-random sequence cannot be set, meaning that
                           the sequence cannot be (intentionally) reproduced.

                           The bytes operation requests [4mnbytes[24m bytes of random
                           material. The result is a bstring of that length.

                           The uint operation requests an unsigned random
                           integer between [4mlo[24m and [4mhi[24m (both unsigned integers),
                           inclusive. It is an error if [4mlo[24m is not greater than
                           [4mhi[24m. The result is an (unsigned) integer.

                           The string operation requests [4mnbytes[24m of random
                           material, returned as a hex-encoded string. If a
                           [4mspec[24m argument is present, it uses the character
                           specification syntax of [34m[1mstrtr()[0m[1m[22m[80] to indicate the
                           characters that can be used to encode the result.
                           Only printable characters, excluding the space, are
                           allowed in the result, regardless of the [4mspec[0m
                           argument. Example:

                               > random(string,12,"a-zA-Z0-9")
                               "LgROshy6SMMH"
                               > random(string,12,"a-z")
                               "kehhvwydhhbk"

                           The functionality of the stringc operation is
                           identical to that of the three-argument instance of
                           the string operation except that the sense of the
                           [4mspec[24m argument is complemented to indicate those
                           characters that may [4mnot[24m be used in the encoding of
                           the result.

                       [1mredirect[22m([4merror-code[24m, [4mtarget[24m)
                       [1mredirect[22m([4mtarget[24m)
                           Permitted only within the context of an access
                           control rule's deny clause, this function causes
                           expression evaluation and rule processing to stop
                           immediately, access to be denied, and the client to
                           be redirected to [4mtarget[24m, a URL that may contain a
                           query component. If the [4merror-code[24m is present, it
                           must be an ACS error name or number (see the
                           [34m[1mACS_ERROR_HANDLER[0m[1m[22m[81] directive), otherwise
                           "BY_REDIRECT" is used.

                               [1mNote[0m
                               The URL must be properly escaped if it appears
                               within an XML document, such as an access
                               control rule; for example, if an ampersand
                               occurs in the query component in a context
                               where it must be escaped, it must appear as the
                               five characters "&amp;".
                           The [4mtarget[24m string is expected to have one of the
                           syntaxes of the document component of [1mApache's[0m
                           [34m[1mErrorDocument directive[0m[1m[22m[82]. In essence, this
                           function causes an ACS_ERROR_HANDLER directive to
                           be created and triggered. The function returns the
                           [4mtarget[24m string, although because of the function's
                           run time behaviour the value cannot be used.

                               [1mTip[0m
                               One application of this function is to create a
                               short link, which is a relatively concise URL
                               that acts as an "alias" for another, usually
                               much longer URL (here, the [4mtarget[24m). The short
                               link is made public. It must be [1mDACS[22m-wrapped;
                               the [4mtarget[24m does not need to be. Any attempt to
                               access the short link is denied by its rule,
                               but the rule uses the [1mredirect() [22mfunction,
                               probably with BY_SIMPLE_REDIRECT as the
                               [4merror-code[24m (see [34m[1mdacs.conf(5)[0m[1m[22m[81]), to redirect
                               the user agent to the [4mtarget[24m.

                               The following rule demonstrates how this can be
                               done:

                                   <acl_rule status="enabled">
                                    <services>
                                     <service url_pattern="/id/*"/>
                                    </services>

                                    <rule order="allow,deny">
                                     <deny>
                                       setvar(split, "X", ${Env::REQUEST_URI}, "/");
                                       ${x} = var(get, X, ${X::#} - 1);
                                       redirect(BY_SIMPLE_REDIRECT, "https://example.com/docs/${x}.html");
                                     </deny>
                                    </rule>
                                   </acl_rule>

                               With this rule in place, a request like:

                                   https://example.com/id/17795821

                               would result in a redirect to this target:

                                   https://example.com/docs/17795821.html

                               The target URL can depend on contextual
                               elements, and it is straightforward to do
                               things like make the target URL depend on the
                               time of day, identity of the user, and so on.
                               The technique can also be used with [34m[1mRlinks[0m[1m[22m[83].

                               Because the rule associated with the short link
                               can be changed at any time, this feature can be
                               used to implement smart [34m[1mpermalinks[0m[1m[22m[84].

                       [1mregmatch[22m([4mstring[24m, [4mregex[24m [, [4mnamespace[24m] [, nocase])
                           This is a pattern matching function. The first two
                           arguments are coerced to strings, with the second
                           one taken to be the regular expression, with a "^"
                           (the start-of-string anchor) implicitly prepended.
                           The [4mstring[24m argument is then matched against the
                           regular expression, which may contain
                           subexpressions enclosed between '(' and ')' (or
                           '\(' and '\)'). If the match fails, the result is
                           0. If the match succeeds there are several
                           possibilities:

                           +o   if there are no subexpressions in [4mregex[24m, the
                               result is an integer that is the number of
                               characters matched.

                           +o   if there is at least one subexpression in [4mregex[0m
                               but no [4mnamespace[24m (a string argument) is given,
                               the result is the substring of [4mstring[24m that was
                               matched by the entire regular expression.

                           +o   if there is at least one subexpression in [4mregex[0m
                               and a namespace argument is given, the result
                               is an integer that is the number of characters
                               matched by the entire regular expression. The
                               value of the first matching subexpression is
                               assigned to the variable named "[4m1[24m" in the
                               namespace, the value of the second
                               subexpression is assigned to a variable named
                               "[4m2[24m" in the namespace, and so on up to the ninth
                               subexpression. The variable named "[4m0[24m" in the
                               namespace is assigned the substring of string
                               that was matched by the entire regular
                               expression. Following function evaluation in
                               the context of ACL rule processing, [4mnamespace[0m
                               is accessible only within the predicate, allow,
                               or deny element in which it appears.
                               If the optional [4mnocase[24m literal argument is
                               given, then matching is done
                               case-insensitively. Only one parenthesized pair
                               can be used. IEEE Std 1003.2 ("POSIX.2")
                               "extended" regular expressions are supported
                               ([34m[1mregex(3)[0m[1m[22m[85], [34m[1mre_format(7)[0m[1m[22m[86]).

                               Examples:

                                   > ${X} = "abfoo"
                                   "abfoo"
                                   > regmatch(${X}, ".*foo", nocase)
                                   5
                                   > regmatch("abcdefgzz", "(.*)g")
                                   "abcdefg"
                                   > regmatch("foo", "(bar)|(baz)|(foo)")
                                   "foo"
                                   > regmatch("abcdefgzz", "ab(.*)efg(.*)", "x")
                                   9
                                   > ${x::0}
                                   "abcdefgzz"
                                   > ${x::1}
                                   "cd"
                                   > ${x::2}
                                   "zz"
                                   > $addr = "192.168.7.3"
                                   "192.168.7.3"
                                   > regmatch($addr, "192\\.168\\.(.*)\\..*", "X")
                                   11
                                   > ${X::1}
                                   "7"


                           [1mregsub[22m([4mstring[24m, [4mregex[24m, [4mreplacement[24m [,nocase]
                           [,repeat])
                               This function matches [4mregex[24m against [4mstring[24m,
                               like [34m[1mregmatch()[0m[1m[22m[59] does, and returns the
                               string that results when the substitution
                               specified by [4mreplacement[24m is applied to the
                               matched text. This is similar to the [1med[22m/[1mvi[22m/[1msed[0m
                               command "s/regex/replacement/" applied to
                               [4mstring[24m. If no match is found, the empty string
                               is returned.

                               The optional [4mrepeat[24m literal argument causes the
                               replacement to be applied to all matches; i.e.,
                               like the [1med[22m/[1mvi[22m/[1msed [22mcommand
                               "s/regex/replacement/g".

                               Examples:

                                   > regsub("hello world", "world", "auggie")
                                   "hello auggie"
                                   > regsub("hello world", "auggie", "world")
                                   ""
                                   > regsub("hello", ".*", "& &")
                                   "hello hello"
                                   > regsub("one two three", "(.*) (.*) (.*)", "\${3} \${2} \${1}")
                                   "three two one"
                                   > regsub("one two three", "(.*) (.*) (.*)", '${3} ${2} ${1}')
                                   "three two one"
                                   > strtr(regsub("https://BOB.Example.com",
                                       "\([^:]*\)://\([^.]*\)\\.\(.*\)", '${1}-${2}@${3}'),
                                         "A-Z", "a-z")
                                   "https-bob@example.com"
                                   > regsub("one, bone, cone, hone", "one", "two", repeat)
                                   "two, btwo, ctwo, htwo"


                           [1mrequest_match[22m([4muri-string[24m)
                               This function is used to inspect the current
                               request. The argument is either a valid URI or
                               a path component that begins with a slash. In
                               the latter case, the scheme and authority
                               components of the current request are
                               effectively prepended to the given path. The
                               path component is like the [4murl_pattern[0m
                               attribute used in [34m[1maccess control rules[0m[1m[22m[87] in
                               that it can either specify an exact match or,
                               by ending in "/*", a wildcard match. A query
                               component is allowed but ignored. The function
                               returns 0 if [4muri-string[24m does not match the
                               current request, otherwise it returns the
                               number of path components of [4muri-string[24m that
                               match the current request. If the scheme and
                               authority components are given in [4muri-string[24m,
                               they count as one naming component.

                               Assuming that the current request is
                               http://example.com:18123/a/b/c, we get:

                                   > request_match("http://example.com:18123/a/b/c")
                                   4
                                   > request_match("https://example.com:18123/a/b/c")
                                   0
                                   > request_match("http://example.com:18123/a/b/c/d")
                                   0
                                   > request_match("http://example.com:18123/a/b")
                                   0
                                   > request_match("http://example.com:18123/a/b/*")
                                   4
                                   > request_match("http://example.com:18123/*")
                                   2
                                   > request_match("http://example.com:18123")
                                   0
                                   > request_match("http://example.com")
                                   0
                                   > request_match("http://example.com/*")
                                   2
                                   > request_match("/*")
                                   1
                                   > request_match("/a/b/c")
                                   3
                                   > request_match("/a/b/*")
                                   3
                                   > request_match("/")
                                   0


                           [1mreturn[22m([4mresult[24m)
                               Equivalent to [1mexit[22m, this function causes
                               evaluation of the expression to terminate and
                               returns [4mresult[24m as the value of the expression.

                           [1mrule[22m([4mobject[24m, [4mruleset_vfs[24m)
                               The [1mrule [22mpredicate is an interface to the [1mDACS[0m
                               rule processing engine. It is used to test if
                               the rule set [4mruleset_vfs[24m authorizes [4mobject[24m,
                               much as [34m[1mdacscheck(1)[0m[1m[22m[36] does. The [4mobject[0m
                               argument is the name to match against the
                               services specified in access control rules and
                               can either be a URI or an absolute pathname
                               (one that begins with a slash character). It
                               can have an optional query string component
                               attached. An absolute pathname [4mpath[24m is mapped
                               internally to a URI as file://[4mpath[24m; e.g.,
                               /myapp is interpreted as file:///myapp (see [34m[1mRFC[0m
                               [1m[34m1738[0m[1m[22m[43]).

                               One application of this predicate is for a rule
                               associated with a program to check that the
                               user requesting access is entitled to use a
                               data file needed by the program.

                                   [1mNote[0m
                                   Only the [4mpath[24m component of the URI is
                                   considered when [1mDACS [22mmatches an object's
                                   name against the url_pattern of an access
                                   control rule. At present, the object name
                                   is not automatically canonicalized or
                                   resolved (see [34m[1mRFC 3986[0m[1m[22m[45]), as is usually
                                   done by a web server, so relative path
                                   components should be avoided.
                               The [4mruleset_vfs[24m is a URI in the syntax of the
                               [34m[1mVFS[0m[1m[22m[25] configuration directive.

                               The various components of the URI that names
                               the object are available as [1mDACS [22mvariables and
                               environment variables (see below). If a query
                               string is given, it is parsed and the
                               individual arguments are made available to
                               rules through the [4mArgs[24m namespace, just as for
                               [1mDACS[22m-wrapped web services.

                               Many variables normally set by a web server are
                               instantiated based on the object name and the
                               execution environment. These variables are
                               available in the [4mDACS[24m namespace. For example,
                               if the object name is
                               https://example.com:8443/myapp/edit-menu?entry=item1,
                               the following variables will be set as
                               indicated:

                                   ${DACS::HTTPS}=on
                                   ${DACS::SERVER_NAME}=example.com
                                   ${DACS::SERVER_ADDR}=142.179.101.118
                                   ${DACS::HTTP_HOST}=example.com:8443
                                   ${DACS::SERVER_PORT}=8443
                                   ${DACS::REQUEST_URI}=/myapp/edit-menu
                                   ${DACS::DOCUMENT_ROOT}=/
                                   ${DACS::REQUEST_METHOD}=GET
                                   ${DACS::SERVER_SOFTWARE}=dacsexpr-1.4.14
                                   ${DACS::QUERY_STRING}=entry=item1
                                   ${DACS::ARG_COUNT}=1
                                   ${DACS::CURRENT_URI}=/myapp/edit-menu?entry=item1
                                   ${DACS::CURRENT_URI_NO_QUERY}=/myapp/edit-menu

                               The value of [4m${Args::entry}[24m will be item1. The
                               request method is always GET. The variable
                               [4m${DACS::REMOTE_USER}[24m will be set if credentials
                               are available in the execution environment.

                               For example, assuming that the file
                               /usr/local/exams/acls/acl-exams.17 contains:

                                   <acl_rule status="enabled">
                                     <services>
                                       <service url_pattern="/exam1.html"/>
                                     </services>

                                     <rule order="allow,deny">
                                       <precondition><predicate>
                                         ${Args::user} eq "teacher"
                                       </predicate></precondition>

                                       <allow>
                                         time(hour) eq 17
                                       </allow>
                                     </rule>
                                   </acl_rule>

                               The following call would only return [1mTrue [22m([1m1[22m)
                               any day between 5:00pm and 5:59pm:

                                   rule("/exam1.html?user=teacher", "dacs-fs:/usr/local/exams/acls");


                                   [1mNote[0m
                                   +o   Since any rule can call the [1mrule[0m
                                       function, take care to avoid infinite
                                       recursion.

                                   +o   Although this function is similar in
                                       concept to the [34m[1mdacscheck(1)[0m[1m[22m[36]
                                       command, there are some significant
                                       differences, particularly with respect
                                       to the context available during rule
                                       evaluation.

                                   +o   The [4mEnv[24m namespace is not reinitialized
                                       or altered during evaluation of rules
                                       processed by [1mrule[22m. That is, the [4mEnv[0m
                                       namespace is the same as the outer-most
                                       one.

                               [1msetvar[22m([4mop[24m, [4mdst-namespace[24m [, [4margs[24m ...])
                                   This function, which performs various
                                   operations on namespaces, has several
                                   different syntaxes. The first argument
                                   always specifies the operation (case
                                   insensitively) and determines the meaning
                                   of the arguments that follow it. The second
                                   argument always specifies a namespace that
                                   is created or modified. If successful, the
                                   function returns the number of variables
                                   created (or replaced) in [4mdst-namespace[24m.

                                   The [4mdst-namespace[24m cannot be a [34m[1mread-only[0m
                                   [1m[34mnamespace[0m[1m[22m[88]. Unless otherwise specified,
                                   if [4mdst-namespace[24m exists, variables are
                                   added to it, with any existing variable
                                   assigned its new value.

                                   The following operations are recognized:

                                   [1msetvar[22m(authorization, [4mdst-namespace[24m,
                                   [4mauth-str[24m)
                                       The [4mauth-str[24m argument, which is the
                                       value of an Authorization HTTP request
                                       header, is parsed into its component
                                       fields and assigned to variables in the
                                       destination namespace [4mdst-namespace[24m. If
                                       [4mdst-namespace[24m exists, its contents are
                                       deleted first. Corresponding to the
                                       field names used in [34m[1mRFC 2617[0m[1m[22m[89]
                                       Section 3.2.2, the following variables
                                       are created: [4mAUTH_SCHEME[24m, [4mUSERNAME[24m,
                                       [4mPASSWORD[24m, [4mREALM[24m, [4mNONCE[24m, [4mDIGEST_URI[24m,
                                       [4mRESPONSE[24m, [4mALGORITHM[24m, [4mCNONCE[24m, [4mOPAQUE[24m,
                                       [4mMESSAGE_QOP[24m, [4mNONCE_COUNT[24m, and
                                       [4mAUTH_PARAM[24m. Any variable that
                                       corresponds to a non-existent field is
                                       assigned the empty string.

                                       The following call sets
                                       [4m${Foo::AUTH_SCHEME}[24m to Basic,
                                       [4m${Foo::USERNAME}[24m to Bobo, and
                                       [4m${Foo::PASSWORD}[24m to myPassWord.

                                           setvar(authorization, Foo, "Basic Qm9ibzpteVBhc3NXb3Jk")


                                   [1msetvar[22m(copy, [4mdst-namespace[24m, [4msrc-namespace[24m)
                                       With the copy operation, all variables
                                       in an existing namespace [4msrc-namespace[0m
                                       are copied to [4mdst-namespace[24m. If the
                                       latter exists, its contents are
                                       deleted, otherwise the namespace is
                                       created.

                                   [1msetvar[22m(delete, [4mdst-namespace[24m)
                                       The delete operation is used to delete
                                       [4mdst-namespace[24m and its contents.

                                   [1msetvar[22m(kwv, [4mdst-namespace[24m, [4massign-char[24m,
                                   [4msep-chars[24m, [4mstring[24m)
                                       For the kwv operation, [4mstring[24m is
                                       parsed, creating (or replacing)
                                       variables in [4mdst-namespace[24m. The [4mstring[0m
                                       consists of zero or more keyword/value
                                       pairs. The keyword, which is used as
                                       the variable name, is separated by the
                                       value by the character [4massign-char[24m. A
                                       keyword/value pair is separated from
                                       the next by any character that appears
                                       in [4msep-chars[24m. Here is an example:

                                           setvar(kwv, "Foo", "=", ", ", "a=b, c=d, e=f")

                                       The value of this call is 3 and it sets
                                       [4m${Foo::a}[24m to "b", [4m${Foo::c}[24m to "d", and
                                       [4m${Foo::e}[24m to "f".

                                   [1msetvar[22m(load, [4mdst-namespace[24m, [4mfilename[24m)
                                   [1msetvar[22m(load, [4mdst-namespace[24m, [4mitem_type[24m, [4mkey[24m)
                                   [1msetvar[22m(load, [4mdst-namespace[24m, [4mvfs-ref[24m, [4mkey[24m)
                                       The contents of a text object, which
                                       can be specified using a filename, as
                                       an [4mitem_type[24m, or using a [4mvfs-ref[24m (see
                                       [34m[1mvfs()[0m[1m[22m[73]), is split into newline
                                       separated lines. The first line is
                                       assigned index 0 in [4mdst-namespace[24m, the
                                       second index 1, and so on.

                                       Consider the following example:

                                           > setvar(load, PASSWD, "/etc/passwd")
                                           25
                                           > ${PASSWD::2}
                                           "root:*:0:0:Charlie &amp;:/root:/bin/csh"

                                       Here, there are 25 lines in /etc/passwd
                                       and the third line is printed.

                                   [1msetvar[22m(loadi, [4mdst-namespace[24m, [4mvfs-ref[24m)
                                       Each item in the indexed text object
                                       specified by [4mvfs-ref[24m (an absolute
                                       pathname, an item type, or a [34m[1mVFS[0m
                                       [1m[34mURI[0m[1m[22m[61]) is copied to [4mdst-namespace[24m,
                                       with the same index. The index must be
                                       a valid [4mvariable-name[24m.



                                           > setvar(loadi, PASSWD, "dacs-kwv-fs:/etc/passwd")
                                           23
                                           > ${PASSWD::root}
                                           "*:0:0:Charlie &amp;:/root:/bin/csh"
                                           > ${PASSWD::bobo}
                                           "bobo:*:1001:1001:Bobo &amp;:/home/bobo:/bin/tcsh"

                                       Here, 23 items are copied into the
                                       [4mPASSWD[24m namespace (the first two lines
                                       in this particular /etc/passwd are
                                       ignored because they are comments that
                                       are not recognized as items). The lines
                                       indexed by the keys root and bobo are
                                       printed.

                                   [1msetvar[22m(merge, [4mdst-namespace[24m, [4msrc-namespace[24m)
                                       The merge operation is similar to
                                       [34m[1mcopy[0m[1m[22m[90] except that if [4mdst-namespace[0m
                                       exists its contents are not deleted.

                                   [1msetvar[22m(post, [4mdst-namespace[24m [, [4mcontent-type[24m,
                                   [4mstring[24m])
                                       Like [34m[1mquery[0m[1m[22m[91], this operation parses
                                       its input into arguments in
                                       [4mdst-namespace[24m. The function reads its
                                       standard input, unless a [4mstring[0m
                                       argument is given. The input is
                                       expected to be a correctly formatted
                                       application/x-www-form-urlencoded or
                                       multipart/form-data content type. If
                                       the standard input is read, both the
                                       [4mCONTENT_TYPE[24m and [4mCONTENT_LENGTH[0m
                                       environment variables must be set (as
                                       they are when Apache runs a script that
                                       is passed an entity-body).

                                       The form that takes [4mstring[24m is not yet
                                       implemented.

                                   [1msetvar[22m(query, [4mdst-namespace[24m, [4mquery-string[24m)
                                       For the query operation, [4mquery-string[0m
                                       is parsed, creating variables in
                                       [4mdst-namespace[24m. This uses the same
                                       parsing algorithm employed by
                                       [34m[1mcgiparse(8)[0m[1m[22m[92]. In the case of a
                                       malformed query string, like "a&b",
                                       variables will be created but will have
                                       the empty string as their value. If
                                       successful, the function returns the
                                       number of variables created. The
                                       following call returns 3 and sets
                                       [4m${Foo::a}[24m to "b", [4m${Foo::c}[24m to "d", and
                                       [4m${Foo::e}[24m to "f":

                                           setvar(query, "Foo", "a=b&c=d&e=f")

                                       One application of this function it to
                                       distinguish query arguments (which are
                                       part of the requested resource's URI
                                       and made available through the
                                       environment variable [1mQUERY_STRING[22m) from
                                       arguments supplied in the body of a
                                       POST method (or other such method). For
                                       example:

                                           setvar(query, "Qargs", "${Env::QUERY_STRING}")
                                           if (${Qargs::foo:e}) {
                                               /* "foo" is a query argument */
                                           }
                                           else {
                                               /* "foo" is not a query argument */
                                           }

                                           if (${Args::foo:e} and not ${Qargs::foo:e}) {
                                               /* "foo" is a POST argument */
                                           }
                                           else {
                                               /* "foo" is not a POST argument */
                                           }


                                   [1msetvar[22m(regsplit, [4mdst-namespace[24m, [4mstring[24m,
                                   [4mdelimiter-regex[24m [,[4mlimit[24m])
                                       The regsplit operation is similar to
                                       [34m[1msplit[0m[1m[22m[93] except that substrings are
                                       separated by the regular expression
                                       [4mdelimiter-regex[24m. IEEE Std 1003.2
                                       ("POSIX.2") "extended" regular
                                       expressions are used ([34m[1mregex(3)[0m[1m[22m[85]).

                                   [1msetvar[22m(rename, [4mdst-namespace[24m,
                                   [4msrc-namespace[24m)
                                       The rename operation deletes
                                       [4mdst-namespace[24m, if it exists, and
                                       changes the name of [4msrc-namespace[24m to
                                       [4mdst-namespace[24m. The two namespace
                                       arguments must be different.

                                   [1msetvar[22m(split, [4mdst-namespace[24m, [4mstring[24m,
                                   [4mdelimiter[24m [,[4mlimit[24m [,[4mdflag[24m]])
                                       The split operation extracts substrings
                                       from [4mstring[24m. Substrings are separated
                                       by the string [4mdelimiter[24m. For example,
                                       this call separates a composite role
                                       string into individual basic roles:

                                           setvar(split, "ROLES", ${DACS::ROLES}, ",")

                                       If the variable reference
                                       [4m${DACS::ROLES}[24m has the value
                                       "root,wheel,www,users", then the
                                       example would return 4 and set
                                       [4m${ROLES::0}[24m to "root", [4m${ROLES::1}[24m to
                                       "wheel", and so on.

                                       If a [4mlimit[24m is given, it is an integer
                                       that specifies the maximum number of
                                       substrings to extract. Once the maximum
                                       has been reached, the remainder of
                                       [4mstring[24m that has not been split will be
                                       assigned to the last element. A [4mlimit[0m
                                       of zero is equivalent to the default,
                                       which is for there to be no maximum.
                                       For instance, setvar(split, X,
                                       "a,b,c,d", ",", 2) will assign "a" to
                                       [4m${X::0}[24m and "b,c,d" to [4m${X::1}[24m.

                                       Here is another example:

                                           > setvar(split, "X", "a\nb\nc\n", "\n")
                                           "3"
                                           > ${X::0}
                                           "a"
                                           > ${X::#}
                                           "3"

                                       This function can be used to break a
                                       pathname into its individual
                                       components. For instance, the following
                                       call results in [4m${X::0}[24m set to the
                                       empty string, [4m${X::1}[24m set to "a",
                                       [4m${X::2}[24m set to "long", and [4m${X::3}[24m set
                                       to "path":

                                           > setvar(split, "X", "/a/long/path", "/")
                                           4

                                       (You may need to first remove redundant
                                       slashes in [4mstring[24m using [34m[1mstrtr()[0m[1m[22m[80].)

                                       A [4mdflag[24m argument may follow the [4mlimit[0m
                                       argument to indicate whether [4mdelimiter[0m
                                       should not be included in substrings
                                       ([4mdflag[24m == 0, which is the default
                                       behavior), whether it should be
                                       included at the start of substrings
                                       with the possible exception of the
                                       first one ([4mdflag[24m > 0), or whether it
                                       should be included at the end of
                                       substrings with the possible exception
                                       of the last one ([4mdflag[24m < 0).

                                           > setvar(split, P, "/a/long/path", "/", 0, 1)
                                           3
                                           > ${P::0}
                                           "/a"
                                           > ${P::1}
                                           "/long"
                                           > ${P::2}
                                           "/path"
                                           > setvar(split, P, "/a/long/path", "/", 0, -1)
                                           4
                                           > ${P::0}
                                           "/"
                                           > ${P::1}
                                           "a/"
                                           > ${P::2}
                                           "long/"
                                           > ${P::3}
                                           "path"


                                   [1msetvar[22m(uri, [4mdst-namespace[24m, [4muri[24m)
                                       The given [4muri[24m, a URI conforming to [34m[1mRFC[0m
                                       [1m[34m2396[0m[1m[22m[44] or [34m[1mRFC 3986[0m[1m[22m[45], is parsed
                                       into its components. Variables in
                                       [4mdst-namespace[24m are set accordingly:
                                       [4mSCHEME[24m (mapped to lower case), [4mHOST[0m
                                       (mapped to lower case), [4mAUTHORITY[24m,
                                       [4mPORT[24m, [4mSERVER[24m, [4mUSERINFO[24m, [4mPATH[24m, [4mQUERY[24m,
                                       and [4mFRAGMENT[24m. If a component is absent
                                       from [4muri[24m, the corresponding variable
                                       will not be defined.

                                           [1mSecurity[0m
                                           It is possible for [4mUSERINFO[24m to
                                           include a plaintext password.
                                       In addition, the URI's path component
                                       is split into its slash-delimited
                                       pieces. The variable [4mPATH_LENGTH[24m is set
                                       to the number of such pieces (it will
                                       be zero if there are none), and
                                       variables [4mPATH_0[24m, [4mPATH_1[24m, and so on are
                                       set to the first, second, and
                                       successive pieces. An "empty" path
                                       component is treated as a piece
                                       consisting of the empty string.

                                           > setvar(uri, "X", "https://bar@foo.example.com:8443/cgi-bin/prog?a=17")
                                           11
                                           > info(namespace,X)
                                           "SCHEME="https"
                                           AUTHORITY="bar@foo.example.com:8443"
                                           HOST="foo.example.com"
                                           PORT="8443"
                                           SERVER="foo.example.com:8443"
                                           USERINFO="bar"
                                           PATH="/cgi-bin/prog"
                                           PATH_COUNT="2"
                                           PATH_0="cgi-bin"
                                           PATH_1="prog"
                                           QUERY="a=17"
                                           "



                               [1msizeof[22m([4mtypename[24m)
                                   This function returns the amount of memory
                                   in bytes, as an integer, used by [4mtypename[24m,
                                   the name of a [34m[1mbasic data type[0m[1m[22m[20]. For the
                                   string and binary types, the returned value
                                   is the number of bytes used by each element
                                   of that type (1, typically). To find the
                                   number of elements in string or binary
                                   data, use [34m[1mlength()[0m[1m[22m[14].



                                       > sizeof(real)
                                       8


                               [1msleep[22m([4mseconds[24m)
                                   The process is suspended for approximately
                                   [4mseconds[24m seconds, or until a signal is
                                   received and caught or the process
                                   terminated. It returns the "unslept" number
                                   of seconds, which will be zero if the
                                   process slept for the requested interval.
                                   This is an interface to [34m[1msleep(3)[0m[1m[22m[94]. It
                                   can be useful for inserting delays in
                                   conjunction with error handlers, for
                                   instance.

                               [1msource[22m([4mvfs-ref[24m [,[4mkey[24m])
                                   The expressions in the file or item
                                   specified by [4mvfs-ref[24m, which may be followed
                                   by a [4mkey[24m if it is an indexed filestore, are
                                   read and evaluated as a block. The [4mvfs-ref[0m
                                   can be an absolute pathname, an item type,
                                   or a [34m[1mVFS URI[0m[1m[22m[61]. The value returned is
                                   that of the evaluated block. The following
                                   two expressions are essentially equivalent:

                                       source("/usr/local/dacs/scripts/script17")
                                       eval(get("/usr/local/dacs/scripts/script17"))

                                   This function is handy when a lengthy
                                   expression is needed but one does not want
                                   to clutter a configuration file or a rule.

                               [1msprintf[22m([4mfmt[24m, [4m...[24m)
                                   This is a slightly scaled-down version of
                                   the [34m[1msprintf(3)[0m[1m[22m[95] library function. If
                                   necessary and possible, arguments are
                                   converted to the type requested by a
                                   formatting specification. The formatted
                                   string is returned.

                                       ${a} = sprintf("Hello") . ", world."
                                       "Hello, world."
                                       length(sprintf("Hello") . ", world.")
                                       13


                               [1mstrchars[22m([4mstr[24m, [4mrange-spec[24m [,...])
                                   This function returns a new string by
                                   selecting characters from [4mstr[24m according to
                                   a sequence of one or more range
                                   specifications (each one a [4mrange-spec[24m). A
                                   [4mrange-spec[24m is a string argument that
                                   determines the indexes of characters to
                                   select within [4mstr[24m. Indexes start at zero.
                                   The result of each successive range
                                   specification is appended to the previous
                                   result.

                                   A [4mrange-spec[24m is an unordered set of one or
                                   more comma-separated elements, each of
                                   which is either an [4mindex[24m or a [4mrange[24m. An
                                   [4mindex[24m may either be a non-negative integer
                                   or "#", which means "all indexes". A [4mrange[0m
                                   represents a sequence of indexes and has
                                   the syntax:

                                       [4mrange-start[24m ".." [4mrange-end[0m

                                   A [4mrange-start[24m may be a non-negative
                                   integer, the character "#" (which means
                                   "from the beginning"), or may be elided
                                   (also meaning "from the beginning"). A
                                   [4mrange-end[24m may be a non-negative integer
                                   (not less than [4mrange-start[24m, if it is also a
                                   non-negative integer), the character "#"
                                   (which means "to the end"), or may be
                                   omitted (also meaning "to the end").

                                       > $a = "abcdef"
                                       "abcdef"
                                       > strchars($a, 2)
                                       "c"
                                       > strchars($a, "1..4", "0")
                                       "bcdea"
                                       > strchars($a . $a, "5..#")
                                       "fabcdef"
                                       > strchars($a, "#")
                                       "abcdef"
                                       > strchars($a, "#..#")
                                       "abcdef"
                                       > strchars($a, "#..3")
                                       "abcd"
                                       > strchars($a, "..3")
                                       "abcd"
                                       > strchars($a, "..3", "#")
                                       "abcdabcdef"


                               [1mstrftime[22m([4mformat[24m)
                                   This function is an interface to the
                                   [34m[1mstrftime(3)[0m[1m[22m[96] function. It is applied to
                                   the current date and time.

                               [1mstrptime[22m([4mdate-str[24m, [4mdate-format[24m, [4mnamespace[24m)
                               [1mstrptime[22m([4mnamespace[24m)
                                   This function is an interface to the
                                   [34m[1mstrptime(3)[0m[1m[22m[97] function. The [4mdate-str[0m
                                   argument is a string representation of a
                                   date and/or time, with [4mdate-format[0m
                                   describing its syntax. If the parse of
                                   [4mdate-str[24m succeeds, the following elements
                                   of [4mnamespace[24m are set from the corresponding
                                   fields of struct tm: [4mtm_sec[24m, [4mtm_min[24m,
                                   [4mtm_hour[24m, [4mtm_mday[24m, [4mtm_mon[24m, [4mtm_year[24m, [4mtm_wday[24m,
                                   [4mtm_yday[24m, [4mtm_isdst[24m, [4mtm_zone[24m, and [4mtm_gmtoff[24m.
                                   Additionally, a variable named [4mclock[24m is set
                                   to the Unix time that corresponds to the
                                   parsed date and time. Any existing elements
                                   of [4mnamespace[24m are not modified. If [4mdate-str[0m
                                   does not fully describe a date and time, it
                                   is taken to be relative to the current date
                                   and time (e.g., if only a time is given,
                                   "today's date" is used).

                                   In the single-argument usage, the current
                                   date and time are parsed and [4mnamespace[24m is
                                   assigned values as previously described.

                                   The return value is the "Unix time"
                                   equivalent of the resulting time and date.



                                       > strptime("6 Dec 2001 12:33:45", "%d %b %Y %H:%M:%S", tm)
                                       1007670825
                                       > "${tm::tm_mon} ${tm::tm_mday} ${tm::tm_hour} ${tm::tm_min}"
                                       "11 6 12 33"
                                       > ${tm::clock}
                                       1007670825


                               [1mstrrstr[22m([4mstring[24m, [4msubstring[24m)
                                   Return the start of the last occurrence of
                                   [4msubstring[24m within [4mstring[24m. The empty string
                                   is returned if [4mstring[24m is empty or if no
                                   occurrence of [4msubstring[24m is found. If
                                   [4msubstring[24m is empty, [4mstring[24m is returned.

                               [1mstrstr[22m([4mstring[24m, [4msubstring[24m)
                                   Return the start of the first occurrence of
                                   [4msubstring[24m within [4mstring[24m. The empty string
                                   is returned if [4mstring[24m is empty or if no
                                   occurrence of [4msubstring[24m is found. If
                                   [4msubstring[24m is empty, [4mstring[24m is returned.

                                       > strstr("foobazbar", "baz")
                                       "bazbar"
                                       > strstr("foobazbar", "")
                                       "foobazbar"
                                       > strstr("foobazbar", "zzz")
                                       ""
                                       > strstr("", "zzz")
                                       ""
                                       > strstr("afoofoofooz", "foo")
                                       "foofoofooz"
                                       > strrstr("afoofoofooz", "foo")
                                       "fooz"


                               [1mstrtolower[22m([4mstring[24m)
                                   A new string is returned where each
                                   uppercase character in [4mstring[24m is mapped to
                                   lowercase and all other characters are
                                   mapped to themselves. These two expressions
                                   are equivalent and have the value "hello,
                                   world 2008":

                                       strtolower("Hello, World 2008")
                                       strtr("Hello, World 2008", "A-Z", "a-z")


                               [1mstrtoupper[22m([4mstring[24m)
                                   A new string is returned where each
                                   lowercase character in [4mstring[24m is mapped to
                                   uppercase and all other characters are
                                   mapped to themselves. These two expressions
                                   are equivalent and have the value "HELLO,
                                   WORLD 2008":

                                       strtoupper("Hello, World 2008")
                                       strtr("Hello, World 2008", "a-z", "A-Z")


                               [1mstrtr[22m([4minput-string[24m, [4mstring1[24m, [[4mstring2[24m [,cds]])
                                   This function performs string
                                   transliteration, like the [34m[1mtr(1)[0m[1m[22m[98] command
                                   and [1mPerl[22m's tr and y operators. The result
                                   is the transliterated string. The first
                                   argument is the input string to be
                                   transliterated (stdin in the [1mtr [22mcommand).
                                   The second argument is the search list
                                   ("string1" in the [1mtr [22mcommand). The third
                                   argument is the (possibly empty)
                                   replacement list ("string2" in the [1mtr[0m
                                   command); it may be omitted if no flag
                                   string argument follows.

                                   The fourth, optional argument is a literal
                                   flag string made of the characters 'c',
                                   'd', and 's' (in any order), which
                                   correspond to the flags of the same name in
                                   the [1mtr [22mcommand:

                                   [1mc[0m
                                       Complement the set of values in
                                       [4mstring1[24m.

                                   [1md[0m
                                       Delete characters in [4mstring1[24m from the
                                       input string.

                                   [1ms[0m
                                       Squeeze multiple occurrences of the
                                       characters listed in the last operand
                                       (either [4mstring1[24m or [4mstring2[24m) in the
                                       input into a single instance of the
                                       character. This occurs after all
                                       deletion and translation is completed.


                                       > strtr("AbCdEf", "A-Z", "a-z")
                                       "abcdef"
                                       > strtr("/a//b///c", "/", "", "s")
                                       "/a/b/c"


                               [1msubset[22m([4mformat[24m, [4mpurported-subset[24m, [4msuperset[24m [,
                               nocase])
                                   This function returns [1mTrue [22mif every element
                                   of the purported-subset appears in
                                   superset. The [4mformat[24m indicates how to parse
                                   the set arguments. It can be the space,
                                   tab, or newline character, or any
                                   punctuation character. It is currently
                                   interpreted as the character that separates
                                   elements. If the optional nocase literal
                                   argument is given, then set elements are
                                   compared case-insensitively.

                                   Example:

                                       subset(",", ${Args::LAYERS:i}, "RELIEF:Foundation,GTOPO30:Foundation")

                                   This call returns [1mTrue [22mif every element of
                                   the LAYERS parameter (case insensitive)
                                   appears in the given list, otherwise the
                                   expression is [1mFalse[22m.

                               [1msubstr[22m([4mstring[24m, [4mstart-position[24m, [4mlength[24m)
                                   This function returns the substring of
                                   [4mstring[24m beginning at [4mstart-position[24m with
                                   length at most [4mlength[24m characters. The first
                                   character is in position one. If
                                   [4mstart-position[24m is negative, the position is
                                   relative to the end of [4mstring[24m (-1 specifies
                                   the last character in [4mstring[24m). If the
                                   effective starting position is outside of
                                   [4mstring[24m, an empty string is returned. If
                                   [4mlength[24m is negative, it means "the remainder
                                   of the string". It is an error if either
                                   numeric argument is zero. It is not an
                                   error if [4mlength[24m exceeds the actual number
                                   of characters returned.

                                       > substr("foozle", 3, 4)
                                       "ozle"
                                       > substr("foobar", -3, 2)
                                       "ba"
                                       > substr("foobar", -5, -1)
                                       "oobar"
                                       > substr("foobar", 10, -1)
                                       ""
                                       > substr("foobar", -10, 3)
                                       ""


                               [1msyntax[22m([4mtype[24m, [4mname[24m [, [4mflag[24m])
                                   This function performs a syntax test,
                                   specified by [4mtype[24m, on [4mname[24m. It returns 0 if
                                   the test fails, 1 or a [4mtype[24m-dependent,
                                   non-zero value if the test is successful.
                                   It can be useful for testing, catching
                                   errors, recognizing when a string must be
                                   mapped, and for learning about [1mDACS[22m. Note
                                   that these are purely syntactical checks.
                                   They do not test whether an object called
                                   [4mname[24m exists or is configured.

                                   The following tests are recognized:

                                   [1msyntax[22m(charset, [4mname[24m, [4mcharset_spec[24m)
                                       Test if each of the characters in [4mname[0m
                                       is specified by [4mcharset_spec[24m, which is
                                       a character set specification as used
                                       by [34m[1mstrtr()[0m[1m[22m[80] ("the search list").

                                   [1msyntax[22m(dacsname, [4mname[24m)
                                       Test if [4mname[24m is valid as a [34m[1mDACS[0m
                                       [34mname[0m[99]. If the string is recognized,
                                       one of the following values is returned
                                       to classify it:

                                       +o   1 if it is a [1mDACS [22midentity

                                       +o   2 if it is a group name

                                       +o   3 if it is a jurisdiction name

                                       +o   4 if it is a federation name

                                       +o   5 if it is an IP address in numeric
                                           dot notation

                                       [1msyntax[22m(emailaddr, [4mname[24m)
                                           Test if [4mname[24m is a syntactically
                                           valid [34m[1mRFC 822[0m[1m[22m[100] email address. A
                                           successful test does not imply that
                                           a message can be delivered to the
                                           address.

                                               [1mNote[0m
                                               The implementation does not
                                               currently recognize valid
                                               addresses where the local-part
                                               (the substring to the left of
                                               the '@' character) contains a
                                               quoted-string component.

                                       [1msyntax[22m(expr, [4mname[24m)
                                           Test if [4mname[24m is a syntactically
                                           valid expression. The expression is
                                           not actually evaluated. A
                                           successful test does not imply that
                                           evaluation of the expression will
                                           necessarily be successful or
                                           error-free.

                                       [1msyntax[22m(domainname, [4mname[24m)
                                           Test if [4mname[24m is a syntactically
                                           valid domain name ([34m[1mRFC 952[0m[1m[22m[101]). A
                                           successful test does not imply that
                                           [4mname[24m exists or has a DNS entry.

                                       [1msyntax[22m(federation, [4mname[24m)
                                           Test if [4mname[24m is valid as a
                                           federation name (e.g., as the value
                                           of [34m[1mFEDERATION_NAME[0m[1m[22m[102]).

                                       [1msyntax[22m(group, [4mname[24m)
                                           Test if [4mname[24m is valid as a group
                                           name.

                                       [1msyntax[22m(hostname, [4mname[24m)
                                           Test if [4mname[24m is valid as a host
                                           name (an alphanumeric, followed by
                                           any number of alphanumerics and
                                           hyphens, but not ending with a
                                           hyphen; see [34m[1mRFC 952[0m[1m[22m[101] and [34m[1mRFC[0m
                                           [1m[34m1123[0m[1m[22m[103]).

                                       [1msyntax[22m(ipaddr, [4mname[24m)
                                           Test if [4mname[24m is a valid Class C
                                           IPv4 address ([34m[1mRFC 790[0m[1m[22m[104]).

                                       [1msyntax[22m(jurisdiction, [4mname[24m)
                                           Test if [4mname[24m is valid as a
                                           jurisdiction name (e.g., as the
                                           value of [34m[1mJURISDICTION_NAME[0m[1m[22m[105]).

                                       [1msyntax[22m(namespace, [4mname[24m)
                                           Test if [4mname[24m is valid as the name
                                           of a [34m[1mnamespace[0m[1m[22m[21].

                                       [1msyntax[22m(role, [4mname[24m)
                                           Test if [4mname[24m is valid as a [34m[1mrole[0m
                                           [1m[34mdescriptor string[0m[1m[22m[99].

                                       [1msyntax[22m(uri, [4mname[24m)
                                           Test if [4mname[24m is a valid URI ([34m[1mRFC[0m
                                           [1m[34m2396[0m[1m[22m[44], but partially [34m[1mRFC[0m
                                           [1m[34m3986[0m[1m[22m[45]). It must consist of a
                                           scheme, authority component, path
                                           component, and optional query and
                                           fragment components.

                                       [1msyntax[22m(username, [4mname[24m)
                                           Test if [4mname[24m is valid as a username
                                           (e.g., as the value of the [4mUSERNAME[0m
                                           argument to many [1mDACS [22mweb
                                           services).

                                       [1msyntax[22m(variable, [4mname[24m)
                                           Test if [4mname[24m is valid as a [34m[1mvariable[0m
                                           [1m[34mreference[0m[1m[22m[21]. This does not test
                                           if the named variable exists.

                                       [1msyntax[22m(varname, [4mname[24m)
                                           Test if [4mname[24m is a syntactically
                                           correct [34m[1mvariable name[0m[1m[22m[21], with or
                                           without a namespace. This does not
                                           test if the named variable exists.



                                           > syntax(federation, "FOO")
                                           1
                                           > syntax(dacsname, "FOO::BAZ:bar")
                                           1
                                           > syntax(dacsname, "FOO::")
                                           4
                                           > syntax(charset, "bobo17+", "a-z0-9")
                                           0
                                           > syntax(expr, '1 + 1 + 1')
                                           1
                                           > syntax(variable, '${1$}')
                                           0
                                           > syntax(variable, '${Foo::baz:z}')
                                           0
                                           > syntax(varname, 'Foo::baz')
                                           1
                                           > syntax(varname, "17")
                                           1
                                           > syntax(username, "/bobo/")
                                           0
                                           > syntax(group, "blop")
                                           1
                                           > syntax(group, "%blop")
                                           0
                                           > syntax(dacsname, "%blop:flop")
                                           1
                                           > syntax(uri,"https://foo.example.com:8443/cgi-bin/prog?a=17")
                                           1


                                   [1mtime[22m([4mformat[24m [, [4mtimeval[24m])
                                   [1mtime[22m([4mformat[24m, [4mnamespace[24m)
                                       This function returns time and date
                                       information, as specified by the first
                                       argument. The second argument, if
                                       present, either specifies the "Unix
                                       time" from which to obtain the time and
                                       date or a namespace that was returned
                                       by [34m[1mstrptime()[0m[1m[22m[106]. If the second
                                       argument is absent, the result is the
                                       same as if a second argument were given
                                       as time("now"). The [34m[1mlocaltime(3)[0m[1m[22m[107]
                                       library function is used internally to
                                       perform the date calculations.

                                       The [4mformat[24m argument, which is treated
                                       case-insensitively, can be any of the
                                       following:

                                       +o   If the argument is "now", the
                                           function's value is the current
                                           "Unix time" (the value of time in
                                           seconds since 0 hours, 0 minutes, 0
                                           seconds, January 1, 1970,
                                           Coordinated Universal Time). If the
                                           second argument is present,
                                           however, it is the function's
                                           value.

                                       +o   If the argument is "sec" or "secs"
                                           or "seconds", the function's value
                                           is the system clock's seconds
                                           reading.

                                       +o   If the argument is "min" or "mins"
                                           or "minutes", the function's value
                                           is the system clock's minutes
                                           reading.

                                       +o   If the argument is "hour", the
                                           function's value is the system
                                           clock's hour reading (0 - 23).

                                       +o   If the argument is "mday", the
                                           function's value is the day of the
                                           month (1 - 31).

                                       +o   If the argument is "ismdaylast",
                                           the function's value is non-zero if
                                           this is the last day of the month.

                                       +o   If the argument is "mon" or
                                           "month", the function's value is
                                           the month of the year (0 - 11).

                                       +o   If the argument is "year", the
                                           function's value is the year (from
                                           1900 onward).

                                       +o   If the argument is "isleapyear",
                                           the function's value is non-zero if
                                           this is a leap year.

                                       +o   If the argument is "wday", the
                                           function's value is the day of the
                                           week (Sunday is 0).

                                       +o   If the argument is "yday", the
                                           function's value is the day of the
                                           year (0 - 365).

                                       +o   If the argument is "isdst", the
                                           function's value is non-zero if
                                           daylight saving time is in effect.

                                       +o   If the argument is "zone", the
                                           function's value is system clock's
                                           time zone, abbreviated. If the time
                                           zone is not known, the value will
                                           be the empty string.

                                       +o   If the argument is "gmtoff", the
                                           function's value is the offset (in
                                           seconds) of the system clock's time
                                           represented from UTC, with positive
                                           values indicating east of the Prime
                                           Meridian.

                                               [1mNote[0m
                                               A more powerful function is
                                               planned to test whether the
                                               current time and date satisfy a
                                               predicate. It might, for
                                               example, understand arguments
                                               such as "Tuesday" ([1mTrue [22mon any
                                               Tuesday), "last day of the
                                               month", "between midnight and
                                               8:30am", "January 30, 2004 at
                                               1:23pm", "between March 2 and
                                               April 1", "the second Tuesday
                                               of the month", or "within 15
                                               days of April 30".

                                       [1mtransform[22m([4minput[24m,[4mname[24m,[4mrules[24m,[4mdocs[0m
                                       [,[4midents[24m])
                                       [1mtransform[22m([4minput[24m,[4mconfig[24m,[4mname[24m,[4mrules[24m,[4mdocs[0m
                                       [,[4midents[24m])
                                           This function provides a simplified
                                           API for [34m[1mdacstransform(1)[0m[1m[22m[108] -
                                           refer to its description for
                                           additional details. The first form
                                           of the function uses compile-time
                                           defaults, unless they are
                                           overridden by configuration
                                           variables (e.g.,
                                           [4m${Conf::transform_prefix}[24m). The
                                           second form passes a configuration
                                           object returned by
                                           [34m[1mtransform_config()[0m[1m[22m[109]. The [4minput[0m
                                           argument is the text to be passed
                                           through the function. The [4mname[0m
                                           argument is equivalent to the value
                                           of the [1mdacstransform -name [22mflag,
                                           [4mrules[24m is equivalent to the value of
                                           the [1m-r [22mflag, [4mdocs[24m is equivalent to
                                           the value of the [1m-docs [22mflag, and
                                           the optional [4midents[24m argument is a
                                           whitespace-separated list of
                                           identities in the [34m[1mconcise user[0m
                                           [1m[34msyntax[0m[1m[22m[110]. The function returns
                                           the transformed [4minput[24m.

                                       [1mtransform_config[22m([4mflags[24m)
                                           This function returns a
                                           configuration object that is passed
                                           to subsequent calls to
                                           [34m[1mtransform()[0m[1m[22m[111] so that defaults
                                           can be overridden. The single
                                           string argument is parsed into
                                           whitespace-separated words. If a
                                           flag is repeated, the right-most
                                           occurrence is used.

                                           The following flags are recognized:

                                           +o   [1m-prefix [4m[22mprefix-string[24m: The
                                               string used to introduce a
                                               directive, which must appear at
                                               the beginning of a line.

                                           +o   [1m-suffix [4m[22msuffix-string[24m: The
                                               string used to end a directive.

                                           +o   [1m-rprefix [4m[22mregex-prefix[24m: A line
                                               whose beginning matches the
                                               specified regular expression
                                               introduces a directive.

                                           +o   [1m-rsuffix [4m[22mregex-suffix[24m: The end
                                               of a directive is found by
                                               matching the specified regular
                                               expression.

                                           [1mtrim[22m([4mstring[24m, [4mdelete-set[24m [,[4mlimit[24m])
                                               Delete each character in
                                               [4mdelete-set[24m that appears at the
                                               end of [4mstring[24m, up to [4mlimit[0m
                                               characters. The [4mdelete-set[24m is a
                                               search list specification as
                                               used by [34m[1mstrtr()[0m[1m[22m[80]. If [4mlimit[0m
                                               is missing or zero, all of the
                                               characters in [4mstring[24m can
                                               potentially be deleted (leaving
                                               the empty string). The new
                                               string is returned.



                                                   > trim("abceffff", "f")
                                                   "abce"
                                                   > trim("abceffff", abf)
                                                   "abce"
                                                   > trim("a\n\n\n", "\n")
                                                   "a"
                                                   > trim("a", "a-z")
                                                   ""


                                           [1mtypeof[22m([[4mtypename[24m,] [4mexpression[24m)
                                               If there are two arguments and
                                               the first is a recognized [34m[1mdata[0m
                                               [1m[34mtype name[0m[1m[22m[20], the return value
                                               is 1 ([1mTrue[22m) if [4mexpression[24m has
                                               that type and 0 ([1mFalse[22m)
                                               otherwise. If there is one
                                               argument, the function yields a
                                               string that is the data type
                                               name of the evaluated
                                               expression.



                                                   > typeof(4.5)
                                                   "real"
                                                   > typeof(integer, 4.5)
                                                   0


                                           [1mundef[22m()
                                               This function returns a special
                                               value that represents the
                                               "undefined" value. It is used
                                               in certain circumstances to
                                               undefine a symbol. See
                                               [34m[1mdacs.conf(5)[0m[1m[22m[9].

                                           [1muser[22m([4mstring[24m)
                                               This function compares its
                                               argument against each set of
                                               current credentials and returns
                                               the number of credentials that
                                               match. The argument is a user
                                               filter expression that must
                                               evaluate to [1mTrue [22mfor a set of
                                               credentials for those
                                               credentials to match. See
                                               [34m[1mdacs(1)[0m[1m[22m[99] for information
                                               about naming.

                                                   [1mNote[0m
                                                   In typical usage, each user
                                                   will have only one set of
                                                   credentials or will be
                                                   unauthenticated. One should
                                                   keep in mind, however, that
                                                   multiple concurrent
                                                   identities are allowed,
                                                   subject to
                                                   [34m[1mACS_CREDENTIALS_LIMIT[0m[1m[22m[112].
                                               The [4mstring[24m argument ([4mEXP[24m) has
                                               the following syntax:

                                               [1mFigure 2. User Filter[0m
                                               [1mExpression Grammar[0m

                                                   [4mEXP[24m -> [4mE1[0m
                                                   [4mE1[24m  -> [4mE2[24m | [4mE2[24m [4mOR[24m [4mE2[0m
                                                   [4mE2[24m  -> [4mE3[24m | [4mE3[24m [4mAND[24m [4mE2[0m
                                                   [4mE3[24m  -> [4mE4[24m | [4mNOT[24m [4mE3[0m
                                                   [4mE4[24m  -> [4mprimary[24m | "(" [4mE1[24m ")"

                                                   [4mOR[24m  -> "or"  | "||"
                                                   [4mAND[24m -> "and" | "&&"
                                                   [4mNOT[24m -> "not" | "!"

                                               Whitespace (spaces and tabs) is
                                               permitted before and after
                                               lexical elements. Keywords are
                                               case sensitive except when
                                               otherwise stated.

                                               A [4mprimary[24m, which evaluates to
                                               [1mTrue [22mor [1mFalse[22m, is one of the
                                               following:

                                               [4musername[0m
                                                   [1mTrue [22mif the [1mDACS [22midentity
                                                   [4musername[24m matches.

                                                       user("METALOGIC:auggie")
                                                       user(":bobo")

                                                   If the jurisdiction name or
                                                   federation name components
                                                   are omitted, the [34m[1mcurrent[0m
                                                   [1m[34mfederation and[0m
                                                   [1m[34mjurisdiction[0m[1m[22m[99] are
                                                   implied. The jurisdiction
                                                   name component may be
                                                   specified as "*" (e.g.,
                                                   *:[4musername[24m), in which case
                                                   it will match [4many[0m
                                                   jurisdiction name in the
                                                   current federation. In
                                                   addition, both the
                                                   federation name and the
                                                   jurisdiction name
                                                   components may be specified
                                                   as "*" (e.g.,
                                                   *::*:[4musername[24m), in which
                                                   case it will match [4many[0m
                                                   federation name and [4many[0m
                                                   jurisdiction name.

                                               [4mjurisdiction[0m
                                                   [1mTrue [22mif [4mjurisdiction[0m
                                                   matches the name of the
                                                   jurisdiction that created
                                                   the credentials.

                                                       user("METALOGIC:")
                                                       user("DEMO::METALOGIC:")


                                               [4mfederation[0m
                                                   [1mTrue [22mif [4mfederation[24m matches
                                                   the name of the federation
                                                   that created the
                                                   credentials.

                                                       user("DEMO::")


                                               [4maddress[0m
                                                   Given an argument
                                                   acceptable to the
                                                   [34m[1mfrom()[0m[1m[22m[113] predicate, the
                                                   result is [1mTrue [22mif the
                                                   credentials were generated
                                                   by a user apparently
                                                   located at [4maddress[24m.

                                                       user("10.0.0.123")
                                                       user("10.0.0.0/24")
                                                       user("example.com")


                                               [4mgroup[0m
                                                   [1mTrue [22mif the identity is a
                                                   member of [4mgroup[24m, which is a
                                                   [1mDACS [22mgroup.

                                                       user("%METALOGIC:admin")

                                                   A group name may reference
                                                   an explicit group
                                                   membership list or a
                                                   role-based group. Also, it
                                                   is possible for an explicit
                                                   group membership list to
                                                   have the same name as a
                                                   role-based group; if the
                                                   name is referenced in a
                                                   rule, the rule processing
                                                   engine will first check if
                                                   the user is associated with
                                                   the role. If he's not, it
                                                   will go on to check for an
                                                   explicit group membership
                                                   list with the same name.
                                                   This allows an
                                                   administrator to easily
                                                   supplement the membership
                                                   associated with a
                                                   role-based group. Refer to
                                                   [34m[1mdacs.groups(5)[0m[1m[22m[114].

                                               namespace [4mns[0m
                                                   The value of each element
                                                   in [4mns[24m (a namespace) is
                                                   evaluated as a [4mprimary[24m. The
                                                   order in which the list is
                                                   evaluated is unspecified.
                                                   Processing of the list
                                                   terminates with the first
                                                   [4mprimary[24m that evaluates to
                                                   [1mTrue [22mor when the list is
                                                   exhausted. This [4mprimary[24m can
                                                   appear in an element (so
                                                   that one list can reference
                                                   other lists) but beware of
                                                   infinite recursion.

                                                   For example, if
                                                   /usr/local/dacs/app_users
                                                   consists of usernames, one
                                                   per line, an access control
                                                   rule can grant permission
                                                   to any of the users by
                                                   having an allow element
                                                   containing the statements:

                                                       setvar(load, APP_USERS, "/usr/local/dacs/app_users");
                                                       user("namespace APP_USERS")


                                               style [4mstyle-list[0m
                                                   The keyword style is
                                                   followed by a list of one
                                                   or more comma-separated,
                                                   case-insensitive style
                                                   keywords, described below.
                                                   Each style keyword may be
                                                   abbreviated up to the
                                                   indicated minimum number of
                                                   initial characters. Every
                                                   set of credentials has one
                                                   or more [34m[1mstyles[0m[1m[22m[115]
                                                   associated with it that
                                                   indicate which
                                                   authentication method or
                                                   methods were successfully
                                                   applied and how (by what
                                                   means) the credentials were
                                                   generated within [1mDACS[22m. A
                                                   primary is [1mTrue [22mif the
                                                   tested credentials satisfy
                                                   [4mall[24m of the keywords in the
                                                   [4mstyle-list[24m.

                                                   For example, this
                                                   expression tests if both
                                                   the passwd and certificate
                                                   styles are associated with
                                                   it:

                                                       user("style passwd,cert")

                                                   This is equivalent to the
                                                   following expression, which
                                                   tests if the user was
                                                   authenticated via a
                                                   username/password style of
                                                   authentication and a valid
                                                   X.509 client certificate
                                                   was presented:

                                                       user("style passwd") and user("style CERT")

                                                   The following style
                                                   keywords are understood:

                                                   acs
                                                       [1mTrue [22mif the credentials
                                                       were created during an
                                                       authorization check by
                                                       [1mdacs_acs[0m

                                                   admin
                                                       [1mTrue [22mif the credentials
                                                       were created for use
                                                       internal to [1mDACS[22m.

                                                   alien
                                                       [1mTrue [22mif the credentials
                                                       were imported by
                                                       [34m[1mdacs_auth_agent(8)[0m[1m[22m[116]
                                                       in its "alien" mode, or
                                                       by
                                                       [34m[1mdacs_auth_transfer(8)[0m[1m[22m[117].

                                                   cas
                                                       [1mTrue [22mif the user was
                                                       authenticated using
                                                       CAS.

                                                   cert[ificate]
                                                       [1mTrue [22mif the user
                                                       authenticated using an
                                                       X.509 certificate.

                                                   digest
                                                       [1mTrue [22mif the user
                                                       authenticated using [34m[1mRFC[0m
                                                       [1m[34m2617[0m[1m[22m[89] Digest
                                                       authentication.

                                                   expr
                                                       [1mTrue [22mif the user was
                                                       authenticated using an
                                                       expression.

                                                   gen[erated]
                                                       [1mTrue [22mif the credentials
                                                       were generated by a
                                                       [1mDACS [22mutility (e.g.,
                                                       [34m[1mdacscookie(1)[0m[1m[22m[118]).

                                                   import[ed]
                                                       [1mTrue [22mif the credentials
                                                       were imported by
                                                       [34m[1mdacs_auth_agent(8)[0m[1m[22m[116]
                                                       or
                                                       [34m[1mdacs_auth_transfer(8)[0m[1m[22m[117].

                                                   infocard
                                                       [1mTrue [22mif the user was
                                                       authenticated using an
                                                       InfoCard.

                                                   nat[ive]
                                                       [1mTrue [22mif the user was
                                                       authenticated using the
                                                       native authentication
                                                       style.

                                                   managed_infocard
                                                       [1mTrue [22mif the user was
                                                       authenticated using a
                                                       managed InfoCard.

                                                   pass[word]
                                                   passwd
                                                       [1mTrue [22mif the user
                                                       authenticated using a
                                                       password.

                                                   prompt[ed]
                                                       [1mTrue [22mif the user was
                                                       authenticated using the
                                                       prompted authentication
                                                       style.

                                                   rlink
                                                       [1mTrue [22mif the user was
                                                       authenticated using an
                                                       [34m[1mRlink[0m[1m[22m[83].

                                                   selfissued_infocard
                                                       [1mTrue [22mif the user was
                                                       authenticated using a
                                                       self-issued InfoCard.

                                                   simple
                                                       [1mTrue [22mif the user
                                                       authenticated without
                                                       using a password.

                                                   This test can be used as
                                                   part of a risk-based
                                                   authentication
                                                   configuration; a user with
                                                   credentials obtained
                                                   through an authentication
                                                   style deemed not to be
                                                   sufficiently secure with
                                                   respect to a resource could
                                                   be forced to reauthenticate
                                                   using a stronger
                                                   authentication method. See
                                                   [34m[1mdacs_authenticate(8)[0m[1m[22m[8] for
                                                   additional information.

                                               importedby [4mjurisdiction[0m
                                                   The keyword importedby is
                                                   followed by the name of a
                                                   jurisdiction within the
                                                   current federation; the
                                                   result is [1mTrue [22mif the
                                                   credentials were imported
                                                   using
                                                   [34m[1mdacs_auth_transfer(8)[0m[1m[22m[117]
                                                   at that jurisdiction.

                                                       user("importedby METALOGIC")


                                               version [4mprotocol-version[0m
                                                   The keyword version is
                                                   followed by a [1mDACS [22mprotocol
                                                   version number (every
                                                   release of [1mDACS [22mdefines
                                                   this as the value of the
                                                   compile-time symbol
                                                   DACS_VERSION_NUMBER); the
                                                   result is [1mTrue [22mif the
                                                   credentials match that
                                                   protocol version number.

                                                       user("version 1.4")


                                               authenticated, unauthenticated
                                                   Either of two keywords:
                                                   authenticated (or simply
                                                   auth) or unauthenticated
                                                   (or simply unauth). The
                                                   former is [1mTrue [22mif the user
                                                   is authenticated, while the
                                                   latter is [1mTrue [22mif the user
                                                   is not authenticated. A
                                                   case-insensitive string
                                                   comparison is used to match
                                                   these special names.

                                                       user("auth")
                                                       user("unauth")


                                               mine
                                                   The keyword "mine" (case
                                                   insensitive) is [1mTrue [22mif the
                                                   user was authenticated by
                                                   the current jurisdiction.

                                                       user("mine")


                                               any
                                                   The keyword "any" (case
                                                   insensitive) is always
                                                   [1mTrue[22m.

                                                       user("any")


                                               none
                                                   The keyword "none" (case
                                                   insensitive) is always
                                                   [1mFalse[22m.

                                                       user("none")


                                               By default, an exact string
                                               comparison (case sensitive) is
                                               used to match name components
                                               other than the special names;
                                               this default behaviour can be
                                               overridden using the
                                               NAME_COMPARE configuration
                                               directive ([34m[1mdacs.conf(5)[0m[1m[22m[9]).
                                               The method used to compare
                                               federation names, jurisdiction
                                               names, and usernames can also
                                               be specified by following the
                                               [4mprimary[24m with a [4mmode[24m. If the
                                               value of [4mmode[24m (which is itself
                                               case insensitive) is case, then
                                               case-sensitive comparisons are
                                               used, if its value is nocase,
                                               then case-insensitive
                                               comparisons are used, and if
                                               its value is default, then the
                                               value of the NAME_COMPARE
                                               directive will be used if
                                               present, otherwise the
                                               application default is used
                                               (either case or the value
                                               selected by the application).

                                                   [1mImportant[0m
                                                   Keep in mind that [1muser()[0m
                                                   can return [1mFalse [22mbecause no
                                                   credentials matched the
                                                   user filter expression and
                                                   because there are no
                                                   credentials at all (i.e.,
                                                   the user is
                                                   unauthenticated). For
                                                   example,

                                                       user("not METALOGIC:rmorriso")

                                                   will return [1mTrue [22mif the
                                                   user's identity is not
                                                   METALOGIC:rmorriso, even if
                                                   the user is not
                                                   authenticated. It may
                                                   therefore be necessary to
                                                   explicitly test for an
                                                   authenticated user:

                                                       user("not METALOGIC:rmorriso and auth")
                                               Here are examples of the [1muser()[0m
                                               function. Note that any
                                               non-zero expression value
                                               implies [1mTrue[22m.



                                                1.

                                                       user("METALOGIC:")

                                                   Return [1mTrue [22mif the client
                                                   was authenticated by the
                                                   jurisdiction METALOGIC in
                                                   this federation

                                                2.

                                                       user("METALOGIC:rmorriso")

                                                   Return [1mTrue [22mif the client
                                                   was authenticated as the
                                                   user METALOGIC:rmorriso

                                                3.

                                                       user("DEMO::METALOGIC:rmorriso")

                                                   Return [1mTrue [22mif the client
                                                   was authenticated by the
                                                   given federation and
                                                   jurisdiction as rmorriso

                                                4.

                                                       user("%METALOGIC:admin")

                                                   Return [1mTrue [22mif the client
                                                   is a member of the group
                                                   METALOGIC:admin

                                                5.

                                                       user("*:rmorriso")

                                                   Return [1mTrue [22mif the client
                                                   was authenticated as the
                                                   username rmorriso by any
                                                   jurisdiction in this
                                                   federation

                                                6.

                                                       user("auth")

                                                   Return [1mTrue [22mif the client
                                                   was authenticated anywhere

                                                7.

                                                       user("UnAuthenticated")

                                                   Return [1mTrue [22mif the client
                                                   is not authenticated

                                                8.

                                                       user("10.0.0.123")

                                                   Return [1mTrue [22mif the client
                                                   was authenticated through a
                                                   request from a host having
                                                   the IP address 10.0.0.123

                                                9.

                                                       user("not 10.0.0.123")

                                                   Return [1mTrue [22mif the client
                                                   is unauthenticated or was
                                                   not authenticated through a
                                                   request from a host having
                                                   the IP address 10.0.0.123
                                                   (use user("auth and not
                                                   10.0.0.123") to remove the
                                                   unauthenticated case)

                                               10.

                                                       user("ANY")

                                                   Always return [1mTrue[0m

                                               11.

                                                       user("any") gt 1

                                                   Return [1mTrue [22mif the client
                                                   has more than one set of
                                                   current credentials (i.e.,
                                                   has authenticated as two or
                                                   more identities)

                                               12.

                                                       user(":rmorriso")

                                                   Return [1mTrue [22mif the client
                                                   was authenticated as
                                                   rmorriso by this
                                                   jurisdiction

                                               13.

                                                       user(":rmorriso nocase")

                                                   Return [1mTrue [22mif the client
                                                   was authenticated as
                                                   rmorriso,
                                                   case-insensitively, by this
                                                   jurisdiction

                                               14.

                                                       user("metalogic:RMORRISO nocase")

                                                   Return [1mTrue [22mif the client
                                                   was authenticated as the
                                                   user metalogic:RMORRISO,
                                                   but comparing the
                                                   jurisdiction name,
                                                   username, and implied
                                                   federation name
                                                   case-insensitively

                                               15.

                                                       user("METALOGIC:rmorriso default")

                                                   Equivalent to
                                                   user("METALOGIC:rmorriso"),
                                                   return [1mTrue [22mif the client
                                                   was authenticated as the
                                                   user METALOGIC:rmorriso,
                                                   but comparing the
                                                   jurisdiction name,
                                                   username, and implied
                                                   federation name according
                                                   to the NAME_COMPARE
                                                   directive, otherwise using
                                                   the application's default

                                                       [1mTip[0m
                                                       The following two tests
                                                       are not equivalent:

                                                           user("auth")
                                                           user("DSS:auth")

                                                       The first is [1mTrue [22mif
                                                       the user making the
                                                       request has been
                                                       authenticated; it does
                                                       matter which
                                                       jurisdiction
                                                       authenticated the user
                                                       or what the username
                                                       is. The second test
                                                       requires the user
                                                       making the request to
                                                       have a specific
                                                       identity; she must have
                                                       been authenticated by
                                                       the jurisdiction DSS as
                                                       the username auth.

                                               [1mustamp[22m([4mop[24m, [4mvfs-ref[24m [,[4margs[24m ...])
                                                   This function generates a
                                                   string called a [4mstamp[24m that
                                                   is globally unique and
                                                   sequenced, with high
                                                   probability. It has the
                                                   following syntax:

                                                       h=[4mhostid[24m, s=[4mseqno[0m

                                                   A [4mhostid[24m consists of one or
                                                   more characters from the
                                                   same set used for a [34m[1mDACS[0m
                                                   [1m[34musername[0m[1m[22m[119]. A [4mseqno[0m
                                                   consists of two elements,
                                                   separated by a colon, each
                                                   of which is an unsigned
                                                   decimal value.

                                                   The first component of a
                                                   stamp, the [4mhostid[24m, is
                                                   intended to be uniquely
                                                   associated with the host
                                                   that generates the stamp.
                                                   By default, it is a
                                                   128-bit, cryptographically
                                                   strong pseudo-random value.
                                                   This value is stored in
                                                   [4mvfs-ref[24m, which may be an
                                                   absolute pathname, an item
                                                   type, or a [34m[1mVFS URI[0m[1m[22m[61]. If
                                                   [4mvfs-ref[24m does not exist, it
                                                   is created and a new value
                                                   is stored in it.

                                                   Note that by default,
                                                   [4mhostid[24m identifies a host,
                                                   not a jurisdiction. If
                                                   required, it is possible to
                                                   configure unique stamps for
                                                   each jurisdiction on a
                                                   host.

                                                   The second component
                                                   ([4mseqno[24m) is a sequence
                                                   number string relative to
                                                   [4mhostid[24m. Sequence numbers
                                                   should never repeat with
                                                   respect to a host and
                                                   always increase in value so
                                                   that any two sequence
                                                   numbers created by the same
                                                   host must be different.
                                                   Successive sequence numbers
                                                   need not increase by
                                                   uniform steps. If [4mstamp1[0m
                                                   compares less than [4mstamp2[24m,
                                                   then [4mstamp1[24m was created
                                                   before [4mstamp2[24m. Comparison
                                                   of sequence numbers is
                                                   performed on matching
                                                   elements numerically, left
                                                   to right. Two [4mhostid[0m
                                                   components are compared
                                                   case insensitively. No
                                                   ordering is necessarily
                                                   implied by stamps created
                                                   by different hosts.

                                                   Sequence number state
                                                   information is stored in a
                                                   file that must be specified
                                                   using the configuration
                                                   variable
                                                   [4m${Conf::ustamp_seqno}[24m;
                                                   e.g.,

                                                       EVAL ${Conf::ustamp_seqno} = "${Conf::DACS_HOME}/seqno"

                                                   The variable must be set to
                                                   the absolute pathname of a
                                                   file that is readable and
                                                   writable by any process
                                                   that needs to generate a
                                                   stamp. If this file is
                                                   deleted, the sequence will
                                                   be reinitialized. Note that
                                                   updates to the state
                                                   information are unlikely to
                                                   be atomic, which means that
                                                   in the event of a system
                                                   crash the state information
                                                   should be deleted so that a
                                                   new stream of sequence
                                                   numbers is generated.

                                                   One application of these
                                                   stamps is to provide an
                                                   efficient way to detect
                                                   replayed messages. A
                                                   recipient may only need to
                                                   keep track of the stamp
                                                   sent with the last message
                                                   received from a
                                                   jurisdiction to detect an
                                                   invalid stamp in any
                                                   subsequent message.
                                                   Cryptographic techniques
                                                   can be employed to prevent
                                                   a stamp from being altered
                                                   or forged.

                                                   The following operations
                                                   are recognized:

                                                   [1mustamp[22m(clock, [4mvfs-uri[24m)
                                                       The host's system clock
                                                       is used for the stamp's
                                                       sequence number. Its
                                                       first element is the
                                                       number of seconds since
                                                       the start of the epoch
                                                       and the second is a
                                                       counter value. Note
                                                       that if the system
                                                       clock is reset to an
                                                       earlier time, sequence
                                                       numbers may repeat with
                                                       unpredictable
                                                       consequences; a future
                                                       version of this
                                                       function may detect a
                                                       reset clock.

                                                   [1mustamp[22m(ntpclock, [4mvfs-uri[24m,
                                                   [4mntp_host[24m)
                                                       [4mThis[24m [4moperation[24m [4mis[24m [4mnot[0m
                                                       [4mimplemented[24m. Rather
                                                       than using the system
                                                       clock, this operation
                                                       obtains the current
                                                       time from [4mntp_host[24m,
                                                       which is assumed to be
                                                       more reliable than the
                                                       system clock in that it
                                                       will never be reset to
                                                       an earlier time. The
                                                       [4mntp_host[24m argument is a
                                                       hostname or IP address.
                                                       The default port number
                                                       (123) may be overridden
                                                       by appending a colon
                                                       and the port number to
                                                       use.

                                                   [1mustamp[22m(user, [4mvfs-uri[24m,
                                                   [4mseqno[24m)
                                                       Instead of
                                                       incorporating the
                                                       current time into the
                                                       stamp's sequence
                                                       number, this operation
                                                       uses a user-supplied
                                                       string that is assumed
                                                       to have the necessary
                                                       syntax and
                                                       characteristics.

                                                   Examples:

                                                       > ustamp(clock, "${Conf::DACS_HOME}/hostid")
                                                       "h=2fbae312ddc1d2ae388cea1b57a47c66, s=1185565675:9"


                                               [1mvaluesof[22m([4malist[24m)
                                                   If its argument is a single
                                                   pair, the pair's value is
                                                   returned. If there is more
                                                   than one pair in the
                                                   argument, a list of values
                                                   is returned. To get the key
                                                   component of a pair or set
                                                   of pairs, use [34m[1mkeysof()[0m[1m[22m[17].

                                                   Examples:

                                                       > valuesof({red, 17})
                                                       17
                                                       > valuesof({red, 17, blue, 100})
                                                       [17, 100]


                                               [1mvar[22m([4mop[24m, [4mnamespace[24m,
                                               [4mvariable-name[24m [, [4margs[24m ...])
                                                   This function performs
                                                   various operations on a
                                                   variable, some of which are
                                                   awkward or impossible to do
                                                   using the more concise
                                                   variable reference syntax.
                                                   For example, the namespace
                                                   or variable name argument
                                                   to [1mvar() [22mcan be specified
                                                   by an expression.

                                                   The following operations
                                                   are available:

                                                   [1mvar[22m(delete, [4mnamespace[24m,
                                                   [4mvariable-name[24m)
                                                       Delete (undefine) the
                                                       variable named
                                                       [4mvariable-name[24m within
                                                       [4mnamespace[24m. If the
                                                       variable is deleted, 1
                                                       is returned, and if it
                                                       does not exist, 0 is
                                                       returned.

                                                   [1mvar[22m(exists, [4mnamespace[24m,
                                                   [4mvariable-name[24m)
                                                       Test if the variable
                                                       named [4mvariable-name[0m
                                                       within [4mnamespace[0m
                                                       exists, returning 1 if
                                                       so and 0 if not.

                                                   [1mvar[22m(get, [4mnamespace[24m,
                                                   [4mvariable-name[24m [, [4maltval[24m])
                                                       Return the value of the
                                                       variable named
                                                       [4mvariable-name[24m within
                                                       [4mnamespace[24m. If the
                                                       variable does not
                                                       exist, [4maltval[24m is
                                                       returned if given,
                                                       otherwise the empty
                                                       string is returned
                                                       (which could
                                                       potentially be confused
                                                       with a legitimate
                                                       value).

                                                   [1mvar[22m(set, [4mnamespace[24m,
                                                   [4mvariable-name[24m, [4mvalue[24m)
                                                       Set the value of the
                                                       variable named
                                                       [4mvariable-name[24m within
                                                       [4mnamespace[24m to [4mvalue[24m. If
                                                       [4mnamespace[24m or
                                                       [4mvariable-name[24m do not
                                                       exist they are created.
                                                       If the variable already
                                                       exists, its value is
                                                       replaced. The function
                                                       returns [4mvalue[24m.

                                                   Examples:

                                                       > ${Y::foo} = 17
                                                       17
                                                       > setvar(split, X, "/a/b/c/Y", "/")
                                                       5
                                                       > var(get, X, 4)
                                                       "Y"
                                                       > var(get, X, ${X::#} - 1)
                                                       "Y"
                                                       > var(get, var(get, X, "4"), "foo")
                                                       "17"
                                                       > var(set, Y, "f" . "o" . "o", 2007)
                                                       2007
                                                       > ${Y::foo}
                                                       2007


                                               [1mvfs[22m([4mop[24m, [4mvfs-ref[24m [, [4margument[0m
                                               ...])
                                                   This function is an
                                                   interface to the [1mDACS[0m
                                                   virtual filestore
                                                   subsystem, described in
                                                   [34m[1mdacs.vfs(5)[0m[1m[22m[120]. Please
                                                   refer to [34m[1mdacs.conf(5)[0m[1m[22m[25]
                                                   and [34m[1mdacsvfs(1)[0m[1m[22m[121] for
                                                   details and examples.

                                                   The first argument
                                                   specifies the operation to
                                                   be performed. The second
                                                   argument identifies a
                                                   filestore (typically a file
                                                   or database); it can be an
                                                   absolute pathname, an
                                                   item_type that has been
                                                   configured through a
                                                   [34m[1mVFS[0m[1m[22m[25] directive, or a [34m[1mVFS[0m
                                                   [1m[34mURI[0m[1m[22m[61]. Zero or more
                                                   arguments may follow,
                                                   depending on [4mop[24m. For most
                                                   operations, the third
                                                   argument will be the key
                                                   that identifies the object
                                                   of interest. The underlying
                                                   filestore is implicitly
                                                   opened and closed.

                                                   An operation that fails
                                                   abnormally triggers a fatal
                                                   error.

                                                   The following operations
                                                   ([4mop[24m) are available:

                                                   vfs(control, [4mvfs-ref[24m, [4mc_op[0m
                                                   [, [4margument[24m]
                                                       Perform a configuration
                                                       operation on the
                                                       underlying storage
                                                       scheme. Returns [1mTrue[22m.

                                                   vfs(defined, [4mitem-type[24m)
                                                       Test if the specified
                                                       [4mitem-type[24m has been
                                                       defined by a [34m[1mVFS[0m[1m[22m[61]
                                                       directive.

                                                           vfs(defined, "passwds")


                                                   vfs(delete, [4mvfs-ref[24m [,
                                                   [4mkey[24m])
                                                       Delete the referenced
                                                       object.

                                                   vfs(enabled [, [4mstore-name[24m])
                                                       With an argument, test
                                                       if the specified
                                                       [4mstore-name[24m can be used.
                                                       With no argument,
                                                       return a [34m[1mlist[0m[1m[22m[68] of
                                                       enabled store names.

                                                           vfs(enabled, "db") ? print("yes") : print("no");


                                                   vfs(exists, [4mvfs-ref[24m [,
                                                   [4mkey[24m])
                                                       Test whether the
                                                       referenced object
                                                       exists, returning [1mTrue[0m
                                                       or [1mFalse[22m.

                                                           vfs(exists, "/usr/local/dacs/conf/passwd")
                                                           vfs(exists, "file:///usr/local/dacs/conf/passwd")


                                                   vfs(get, [4mvfs-ref[24m [, [4mkey[24m])
                                                       Retrieve the referenced
                                                       object.

                                                   vfs(getsize, [4mvfs-ref[24m [,
                                                   [4mkey[24m])
                                                       Return the length, in
                                                       bytes, of the
                                                       referenced object.

                                                   vfs(list, [4mvfs-ref[24m)
                                                       List the keys of all
                                                       objects in the store.

                                                   vfs(put, [4mvfs-ref[24m, [4mvalue[24m)
                                                   vfs(put, [4mvfs-ref[24m, [4mkey[24m,
                                                   [4mvalue[24m)
                                                       Store an item under the
                                                       given key, replacing
                                                       any existing instance.
                                                       The value is
                                                       null-terminated.

                                                   vfs(rename, [4mvfs-ref[24m,
                                                   [4moldkey[24m, [4mnewkey[24m)
                                                       Change the key
                                                       associated with an
                                                       existing item from
                                                       [4moldkey[24m to [4mnewkey[24m.

                                                   vfs(uri, [4mitem-type[24m)
                                                       If [4mitem-type[24m has been
                                                       defined by a [34m[1mVFS[0m[1m[22m[61]
                                                       directive, return its
                                                       URI, otherwise the
                                                       empty string.

                                                           > vfs(uri, "passwds")
                                                           "[passwds]dacs-kwv-fs:/usr/local/dacs/conf/passwd?field_sep=:"


                                                   This statement sets a
                                                   variable to the contents of
                                                   the file /tmp/somefile:

                                                       ${somefile} = vfs(get, "file:///tmp/somefile")

                                                   As do this equivalent
                                                   statements:

                                                       ${somefile} = vfs(get, "/tmp/somefile")
                                                       ${somefile} = get("/tmp/somefile")

                                                   This expression lists the
                                                   files in the /tmp
                                                   directory:

                                                       vfs(list,"dacs-fs:/tmp")

                                                   These expressions 1) add a
                                                   key/value pair to a
                                                   Berkeley DB database
                                                   (/tmp/mydb.db), creating
                                                   the database file if
                                                   necessary, 2) retrieve the
                                                   value, 3) rename the key,
                                                   and 4) list the keys in the
                                                   database:

                                                       vfs(put, "dacs-db:/tmp/mydb.db", "foo", "baz");
                                                       vfs(get, "dacs-db:/tmp/mydb.db", "foo");
                                                       vfs(rename, "dacs-db:/tmp/mydb.db", "foo", "bar");
                                                       vfs(list, "dacs-db:/tmp/mydb.db");

                                                   This rule fragment denies
                                                   access if the user has
                                                   already been granted access
                                                   five times:

                                                       <deny>
                                                         if (user("auth")) {
                                                           if (vfs(exists, counter_db, ${DACS::IDENTITY})) {
                                                             ${count} = vfs(get, counter_db, ${DACS::IDENTITY});
                                                           }
                                                           else {
                                                             ${count} = 0;
                                                           }
                                                           if (${count} gt 5) {
                                                             return(1);
                                                           }
                                                           vfs(put, counter_db, ${DACS::IDENTITY}, ++${count});
                                                           return(0);
                                                         }
                                                       </deny>

                                                   The item type counter_db
                                                   would be configured in
                                                   dacs.conf; e.g.,

                                                       VFS "[counter_db]dacs-db:/usr/local/dacs/federations/counters.db"


[1mSEE ALSO[0m
       [34m[1mdacsexpr(1)[0m[1m[22m[1]

[1mBUGS[0m
       Assorted clunky aspects of the language are likely to be replaced by
       simplified or more general approaches once requirements are clearer.
       The list and alist data types have not been fully developed and
       integrated. Assignment to a namespace would be a useful extension.

       A way to handle errors and exceptions (such as with try/catch/throw
       statements) would be nice. A switch statement and dynamically loaded
       functions are planned. A foreach statement might be useful, although
       the language has so far successfully avoided loop constructs as a way
       to limit its complexity.

       Various aspects of variables and namespaces are not implemented. A
       namespace cannot be copied by assignment; use [1msetvar()[22m.

       Input and output processing is still rather limited.

       Having to use ":" instead of ".." when matching octet ranges with
       [34m[1mfrom()[0m[1m[22m[113] is unfortunate but avoids pesky period proliferation.

       Some of the more esoteric functions and modes of operation exist
       primarily to expose [1mDACS [22mcore code for testing purposes.

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[122])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[123] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsexpr(1)
           http://dacs.dss.ca/man/dacsexpr.1.html

        2. Perl
           http://www.perl.org/

        3. PHP
           http://www.php.net

        4. Tcl
           http://www.tcl.tk/about

        5. isprint(3)
           http://www.freebsd.org/cgi/man.cgi?query=isprint&apropos=0&sektion=3&manpath=FreeBSD+9.0-RELEASE&format=html

        6. print()
           http://dacs.dss.ca/man/#print

        7. cast
           http://dacs.dss.ca/man/#cast

        8. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

        9. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html

       10. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

       11. environ(7)
           http://www.freebsd.org/cgi/man.cgi?query=environ&apropos=0&sektion=7&manpath=FreeBSD+9.0-RELEASE&format=html

       12. exec()
           http://dacs.dss.ca/man/#exec

       13. list()
           http://dacs.dss.ca/man/#list

       14. length()
           http://dacs.dss.ca/man/#length

       15. strchars()
           http://dacs.dss.ca/man/#strchars

       16. expression grammar
           http://dacs.dss.ca/man/#expression_grammar

       17. keysof()
           http://dacs.dss.ca/man/#keysof

       18. valuesof()
           http://dacs.dss.ca/man/#valuesof

       19. alist()
           http://dacs.dss.ca/man/#alist

       20. supported data types
           http://dacs.dss.ca/man/#data_types

       21. variable reference
           http://dacs.dss.ca/man/#variables

       22. dacs_notices(8)
           http://dacs.dss.ca/man/dacs_notices.8.html

       23. alist construction operator
           http://dacs.dss.ca/man/#alists

       24. listref()
           http://dacs.dss.ca/man/#listref

       25. VFS
           http://dacs.dss.ca/man/dacs.conf.5.html#VFS

       26. revocation list
           http://dacs.dss.ca/man/dacs.acls.5.html#revocation_list

       27. access control rule
           http://dacs.dss.ca/man/dacs.acls.5.html

       28. on_success()
           http://dacs.dss.ca/man/#on_success

       29. AUTH_SUCCESS
           http://dacs.dss.ca/man/dacs.conf.5.html#AUTH_SUCCESS

       30. ACS_SUCCESS
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_SUCCESS

       31. ADMIN_IDENTITY
           http://dacs.dss.ca/man/dacs.conf.5.html#ADMIN_IDENTITY

       32. approval stamp
           http://dacs.dss.ca/man/dacs_acs.8.html#dacs_approval

       33. dacs64 decoding
           http://dacs.dss.ca/man/dacs.exprs.5.html#encode

       34. dacs_list_jurisdictions(8)
           http://dacs.dss.ca/man/dacs_list_jurisdictions.8.html

       35. dacsauth(1)
           http://dacs.dss.ca/man/dacsauth.1.html

       36. dacscheck(1)
           http://dacs.dss.ca/man/dacscheck.1.html

       37. encode()
           http://dacs.dss.ca/man/#encode

       38. cryptographic hash
           http://en.wikipedia.org/wiki/Message_digest

       39. hash()
           http://dacs.dss.ca/man/#hash

       40. decode()
           http://dacs.dss.ca/man/#decode

       41. radix-85
           http://en.wikipedia.org/wiki/Ascii85

       42. RFC 2045
           http://www.rfc-editor.org/rfc/rfc2045.txt

       43. RFC 1738
           http://www.rfc-editor.org/rfc/rfc1738.txt

       44. RFC 2396
           http://www.rfc-editor.org/rfc/rfc2396.txt

       45. RFC 3986
           http://www.rfc-editor.org/rfc/rfc3986.txt

       46. execv(3)
           http://www.freebsd.org/cgi/man.cgi?query=execv&apropos=0&sektion=3&manpath=FreeBSD+9.0-RELEASE&format=html

       47. basename(1)
           http://www.freebsd.org/cgi/man.cgi?query=basename&apropos=0&sektion=1&manpath=FreeBSD+9.0-RELEASE&format=html

       48. dirname(1)
           http://www.freebsd.org/cgi/man.cgi?query=dirname&apropos=0&sektion=1&manpath=FreeBSD+9.0-RELEASE&format=html

       49. stat
           http://dacs.dss.ca/man/#stat

       50. stat(1)
           http://www.freebsd.org/cgi/man.cgi?query=stat&apropos=0&sektion=1&manpath=FreeBSD+9.0-RELEASE&format=html

       51. stat(2)
           http://www.freebsd.org/cgi/man.cgi?query=stat&apropos=0&sektion=2&manpath=FreeBSD+9.0-RELEASE&format=html

       52. printf(3)
           http://www.freebsd.org/cgi/man.cgi?query=printf&apropos=0&sektion=3&manpath=FreeBSD+9.0-RELEASE&format=html

       53. test(1)
           http://www.freebsd.org/cgi/man.cgi?query=test&apropos=0&sektion=1&manpath=FreeBSD+9.0-RELEASE&format=html

       54. mod_access
           http://httpd.apache.org/docs-2.2/mod/mod_access.html

       55. RFC 1035
           http://www.rfc-editor.org/rfc/rfc1035.txt

       56. CIDR notation
           http://en.wikipedia.org/wiki/CIDR_notation

       57. RFC 1338
           http://www.rfc-editor.org/rfc/rfc1338.txt

       58. range specification
           http://dacs.dss.ca/man/#range-spec

       59. regmatch()
           http://dacs.dss.ca/man/#regmatch

       60. user()
           http://dacs.dss.ca/man/#user

       61. vfs_uri
           http://bsd6.dss.ca/dacs/man/dacs.conf.5.html#VFS

       62. digest()
           http://dacs.dss.ca/man/#digest

       63. message authentication code
           http://en.wikipedia.org/wiki/Message_Authentication_Code

       64. Keyed-Hash Message Authentication Code (HMAC)
           http://csrc.nist.gov/publications/fips/fips198-1/FIPS-198-1_final.pdf

       65. Secure Hash Standard functions
           http://dacs.dss.ca/man/dacs.conf.5.html#SHA_functions

       66. MD5 (RFC 2104)
           http://www.rfc-editor.org/rfc/rfc2104.txt

       67. RFC 2253
           http://www.rfc-editor.org/rfc/rfc2253.txt

       68. list construction operator
           http://dacs.dss.ca/man/#lists

       69. dacspasswd(1)
           http://dacs.dss.ca/man/dacspasswd.1.html

       70. PASSWORD_DIGEST
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_DIGEST

       71. PASSWORD_SALT_PREFIX
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_SALT_PREFIX

       72. local_passwd_authenticate
           http://dacs.dss.ca/man/dacs_authenticate.8.html#local_passwd_authenticate

       73. vfs()
           http://dacs.dss.ca/man/#vfs

       74. PASSWORD_CONSTRAINTS
           http://dacs.dss.ca/man/dacs.conf.5.html#PASSWORD_CONSTRAINTS

       75. dacs.conf(5)
           http://dacs.dss.ca/man/dacs.conf.5.html#interpolation

       76. RFC 2898
           http://www.rfc-editor.org/rfc/rfc2898.txt

       77. RFC 3962
           http://www.rfc-editor.org/rfc/rfc3962.txt

       78. LOG_FILTER
           http://dacs.dss.ca/man/dacs.conf.5.html#LOG_FILTER

       79. cryptographically strong pseudo-random values
           http://www.openssl.org/docs/crypto/RAND_bytes.html

       80. strtr()
           http://dacs.dss.ca/man/#strtr

       81. ACS_ERROR_HANDLER
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_ERROR_HANDLER

       82. ErrorDocument directive
           http://httpd.apache.org/docs-2.2/mod/core.html#errordocument

       83. Rlinks
           http://dacs.dss.ca/man/dacs_acs.8.html#rlinks

       84. permalinks
           http://en.wikipedia.org/wiki/Permalink

       85. regex(3)
           http://www.freebsd.org/cgi/man.cgi?query=regex&apropos=0&esektion=3&emanpath=FreeBSD+9.0-RELEASE&format=html

       86. re_format(7)
           http://www.freebsd.org/cgi/man.cgi?query=re_format&sektion=7&apropos=0&manpath=FreeBSD+9.0-RELEASE&format=html

       87. access control rules
           http://dacs.dss.ca/man/dacs.acls.5.html#elements

       88. read-only namespace
           http://dacs.dss.ca/man/#reserved_namespaces

       89. RFC 2617
           http://www.rfc-editor.org/rfc/rfc2617.txt

       90. copy
           http://dacs.dss.ca/man/#setvar-copy

       91. query
           http://dacs.dss.ca/man/#setvar-query

       92. cgiparse(8)
           http://dacs.dss.ca/man/cgiparse.8.html

       93. split
           http://dacs.dss.ca/man/#setvar-split

       94. sleep(3)
           http://www.freebsd.org/cgi/man.cgi?query=sleep&apropos=0&sektion=3&manpath=FreeBSD+9.0-RELEASE&format=html

       95. sprintf(3)
           http://www.freebsd.org/cgi/man.cgi?query=sprintf&apropos=0&sektion=3&manpath=FreeBSD+9.0-RELEASE&format=html

       96. strftime(3)
           http://www.freebsd.org/cgi/man.cgi?query=strftime&apropos=0&sektion=3&manpath=FreeBSD+9.0-RELEASE&format=html

       97. strptime(3)
           http://www.freebsd.org/cgi/man.cgi?query=strptime&apropos=0&sektion=3&manpath=FreeBSD+9.0-RELEASE&format=html

       98. tr(1)
           http://www.freebsd.org/cgi/man.cgi?query=tr&apropos=0&sektion=1&manpath=FreeBSD+9.0-RELEASE&format=html

       99. [1mDACS [22mname
           http://dacs.dss.ca/man/dacs.1.html#naming

       00. RFC 822
           http://www.rfc-editor.org/rfc/rfc822.txt

       01. RFC 952
           http://www.rfc-editor.org/rfc/rfc952.txt

       02. FEDERATION_NAME
           http://dacs.dss.ca/man/dacs.conf.5.html#FEDERATION_NAME

       03. RFC 1123
           http://www.rfc-editor.org/rfc/rfc1123.txt

       04. RFC 790
           http://www.rfc-editor.org/rfc/rfc790.txt

       05. JURISDICTION_NAME
           http://dacs.dss.ca/man/dacs.conf.5.html#JURISDICTION_NAME

       06. strptime()
           http://dacs.dss.ca/man/#strptime

       07. localtime(3)
           http://www.freebsd.org/cgi/man.cgi?query=localtime&apropos=0&sektion=3&manpath=FreeBSD+9.0-RELEASE&format=html

       08. dacstransform(1)
           http://dacs.dss.ca/man/dacstransform.1.html

       09. transform_config()
           http://dacs.dss.ca/man/#transform_config

       10. concise user syntax
           http://dacs.dss.ca/man/dacs.1.html#concise_user_syntax

       11. transform()
           http://dacs.dss.ca/man/#transform

       12. ACS_CREDENTIALS_LIMIT
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_CREDENTIALS_LIMIT

       13. from()
           http://dacs.dss.ca/man/#from

       14. dacs.groups(5)
           http://dacs.dss.ca/man/dacs.groups.5.html

       15. styles
           http://dacs.dss.ca/man/dacs_authenticate.8.html#STYLE

       16. dacs_auth_agent(8)
           http://dacs.dss.ca/man/dacs_auth_agent.8.html

       17. dacs_auth_transfer(8)
           http://dacs.dss.ca/man/dacs_auth_transfer.8.html

       18. dacscookie(1)
           http://dacs.dss.ca/man/dacscookie.1.html

       19. DACS username
           http://dacs.dss.ca/man/dacs.1.html#dacs_identity

       20. dacs.vfs(5)
           http://dacs.dss.ca/man/dacs.vfs.5.html

       21. dacsvfs(1)
           http://dacs.dss.ca/man/dacsvfs.1.html

       22. www.dss.ca
           http://www.dss.ca

       23. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012                     DACS.EXPRS(5)
