<?php
/**
 * phpnukeopenmind theme
 *
 * daCode http://www.dacode.org
 * src/phplib/themes/linuxfr/html.php3
 * $Id: html.php3,v 1.28.2.7 2002/11/05 22:58:32 ruffy Exp $
 *
 *	All HTML design will be put here
 *
 *	header($title)	Return the header with $title as title.
 *	footer()		Return footer.
 *	newsbox($title, $news, $icon, $urls, footer)	Return the box.
 *
 * Depends: Config Redirect Utils User
 */
class Htmlphpnukeopenmind extends Html {
	
	/**
	 * Session instance
	 *@var object Session
	 */
	var $session;

	/**
	 * Redirect instance
	 *@var object Redirect
	 */
	var $redirect;

	/**
	 * Hits instance
	 *@var object Hits
	 */
	var $hits;

	/**
	 * Fortune instance
	 *@var object Fortune
	 */
	var $fortune;

	/**
	 * Utils instance
	 *@var object Utils
	 */
	var $utils;

	/**
	 * Class constructor
	 */
	Function Htmlphpnukeopenmind() {
		global $config;

		//echo '<br />Htmldefault';
		$this->utils = LoadClass('Utils',$config);
		$this->session = LoadClass('Session',$config);
		$this->hits = LoadClass('Hits',$config);
		$this->redirect = LoadClass('Redirect',$config);
		$this->fortune = LoadClass('Fortunes',$config);
	}

	
	/**
	 * Returns the HTML header 
	 *@param string title of the page
	 *@param boolean true if there shall be no banner on top of page
	 *@return string the HTML for the header (including doctype)
	 *@access public
	 */
	Function header($title,$nobanner=false) {
		global $config;

		$title = (empty($title)) ? $config->titledefault : $title;
		$tmp = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" ';
		$tmp .= '"http://www.w3.org/TR/REC-html40/loose.dtd">'."\n";
		$tmp .= '<!-- This page has been generated at the following time: '.
			date("d/m/Y H:i:s").' -->'."\n";
		$tmp .= "\n<html>\n<head>\n";
		$tmp .= '<title>'.$title.'</title>'."\n";
		$tmp .= '<link rel="stylesheet" type="text/css" href="'.
			$this->session->href_theme('style.css').'" />'."\n";
		if (isset($config->favicon)) {
			$tmp .= '<link rel="icon" type="image/png" href="'.
			$this->session->imgurl($config->favicon).'" />'."\n";
		}
		$tmp .= '<meta http-equiv="Content-Type" content="text/html; '.
			'charset='.$config->encodingcharset.'" />'."\n";
		$tmp .= '</head>'."\n";
		$tmp .= '<body>'."\n";
		$tmp .= '<a name="top"></a>';

		if ($nobanner==0) {
			$tmp .= '<br /><br /><div class="logoinfo"><a href="'.
				$config->basehref.'"><img src="'.
				$this->session->imgurl($config->logo).
				'" border="0" alt="'.$config->titledefault.'" /></a><br />';
			if (isset($config->aboutlogo) && !empty($config->aboutlogo))
				$tmp .= $config->aboutlogo;
			$tmp .= '</div><br />'."\n";
		}

		return $tmp;
	}


	/**
	 * Returns the footer
	 *@param string text to add at the bottom of the page, if $nobanner is false
	 *@param boolean if true, do nbot print standard footer
	 *@return string the HTML for the footer
	 *@access public
	 */
	Function footer($text="",$nobanner=false) {
		$tmp = '';
		if (!$nobanner) {
			$out = '<table width="100%" border="0" cellpadding="0" cellspacing="0">';
			$out .= '<tr><td bgcolor="#d8ecea"><ul>';
			$out .= '<li>'.lecho("This website runs").
				' <a href="http://www.dacode.org/">';
			$out .= 'daCode</a></li>'."\n";
			$out .= '</ul></td>';

			$out .= '<td class="newstext" bgcolor="#d8ecea">';
			$out .= $this->fortune->get_random();
			$out .= '</td></tr>';
			$out .= '</table>';
			$out .= $text;
			$tmp = $this->simplebox($out);
		}
		$tmp .= "</body>\n</html>\n";
		return $tmp;
	}

	
	/**
	 * Return HTML code for side box with $text
	 *@param string title of the box
	 *@param string content of the box
	 *@param string name of the box (for HTML comment, not displayed)
	 *@return string the HTML for the box
	 *@access public
	 */
	Function sidebox($title,$text, $type="") {
		$tmp = '<!-- SIDEBOX '.$type.' -->'.
			'<table border="0" cellpadding="1" cellspacing="0" bgcolor="#000000" '.
			'width="100%"><tr><td width="100%">'.
			'<table border="0" cellpadding="0" cellspacing="0" bgcolor="#d8ecea" '.
			'width="100%"><tr><td bgcolor="#ffffff">'.
			'<img src="'.$this->session->imgurl("pixel").
			'" height="1" alt="" border="0" width="100%" /></td></tr>'.
			'<tr><td align="left" height="20" class="boxheader" width="100%">'.
			'<b>&nbsp;&nbsp;'.$title.'</b></td></tr>'.
			'<tr><td bgcolor="#aaaaaa"><img src="'.$this->session->imgurl("pixel").
			'" width="1" height="1" alt="" border="0" /></td>'.
			'</tr></table></td></tr></table>'.
			'<table border="0" cellpadding="0" cellspacing="0" bgcolor="#ffffff" '.
			'width="100%"><tr valign="top"><td bgcolor="#ffffff" class="boxtext" '.
			'width="100%">'.$text.'</td></tr><tr><td width="100%"><br />'.
			'<img src="'.$this->session->imgurl("shadow").
			'" width="150" border="0" alt="" />'.
			'</td></tr></table><br />'.
			'<!-- /SIDEBOX '.$type.' -->'."\n";
		return $tmp;
	}

	
	/**
	 * Return HTML code for simple box with $text
	 *@param string content of the box
	 *@return string the HTML for the box
	 *@access public
	 */
	Function simplebox($text) {
		$tmp = '<!-- SIMPLEBOX -->'."\n".
			'<table cellpadding="0" cellspacing="0" width="100%" border="0" '.
			'align="center" bgcolor="#fefefe">'.
			'<tr><td bgcolor="#000000" colspan="6" width="100%">'.
			'<img src="'.$this->session->imgurl("pixel").
			'" width="1" height="1" alt="" border="0" /></td></tr><tr>'.
			'<td bgcolor="#ffffff" width="100%"><img src="'.
			$this->session->imgurl("pixel").
			'" width="1" height="1" alt="" border="0" /></td></tr>'.
			'<tr bgcolor="#d8ecea"><td width="100%"><img src="'.
			$this->session->imgurl("pixel").
			'" width="1" height="6" alt="" /></td></tr>'.
			'<tr valign="middle" bgcolor="#d8ecea"><td width="100%">'.
			$text.
			'</td></tr>'.
			'<tr bgcolor="#d8ecea"><td width="100%"><img src="'.
			$this->session->imgurl("pixel").
			'" width="1" height="6" alt="" /></td></tr>'.
			'<tr><td bgcolor="#cccccc" width="100%"><img src="'.
			$this->session->imgurl("pixel").
			'" width="1" height="1" alt="" border="0" /></td></tr>'.
			'<tr><td bgcolor="#000000" width="100%"><img src="'.
			$this->session->imgurl("pixel").
			'" width="1" height="1" alt="" border="0" /></td>'.
			'</tr></table>'.
			'<!-- /SIMPLEBOX -->'."\n";
		return $tmp;
	}

	
	/**
	 * Return HTML code for news box with $row from news table
	 *@param array row from news table
	 *@param integer if 1, special mode for preview (?!)
	 *@return string the HTML for news box
	 *@access public
	 */
	Function newsbox($row,$preview=0) {
		global $section,$topic;
		global $config;

		$tmp = '';

		// Title is referenced by a <a name>

		if (isset ($row['id'])) {
			$title = '<a name="n'.$row['id'].'">'.
				((empty($row['title'])) ? htmlentities($config->newstitledefault) :
				htmlentities($row['title'])).'</a>';
		} else {
			$title = ((empty($row['title']))?htmlentities($config->newstitledefault):
				htmlentities($row['title']));
		}

		if ($row['section'] != "Articles" && $row['section'] != $section) {
			$url_tmp = $config->basehref.
				($config->visiblenewsfile ? $config->newsfile : "");
			$title = $this->redirect->make($row['section'],
				$url_tmp.'/section/'.urlencode($row['section']).
				$config->extraopts.$config->ext) . ": $title";
		}

		$body  = (empty($row['body'])) ?
			htmlentities($config->newsbodydefault) :
			(($row['content_type']=="text/plain") ?
			nl2br(htmlentities($row['body'])) : $row['body']);

		$departement = (empty($row['departement']))
			? htmlentities($config->newsdepartementdefault) :
			htmlentities($row['departement']);
		$row['section'] = (empty($row['section'])) ? "nosection" :
			htmlentities($row['section']);
		$row['topic'] = (empty($row['topic'])) ? "notopic" :
			htmlentities($row['topic']);

		// Let's do HTML code
		$tmp .= '<!-- NEWSBOX '.(isset($row['id'])?$row['id']:'').' -->'.
			'<table border="0" cellpadding="0" cellspacing="0" bgcolor="#ffffff" '.
			'width="100%"><tr><td align="left">'.
			'<table border="0" cellpadding="1" cellspacing="0" bgcolor="#000000" '.
			'width="100%"><tr><td align="left">'.
			'<table border="0" cellpadding="0" cellspacing="0" bgcolor="#d8ecea" '.
			'width="100%"><tr><td bgcolor="#ffffff" align="left">'.
			'<img src="'.$this->session->imgurl("pixel").
			'" width="1" height="\" alt="" border="0" /></td></tr>'.
			'<tr><td align="left" height="20"><font size="3" color="#363636">'.
			'<b>&nbsp;'.$title.'</b></font></td></tr>'.
			'<td bgcolor="#aaaaaa" align="left"><img src="'.
			$this->session->imgurl("pixel").
			'" width="1" height="1" alt="" border="0" /></td></tr>'.
			'</table></td></tr></table>';

		$tmp .= $this->linkto_topic($row['topic']);

		$tmp .= '<font color="#999999" size="2">'.
			$this->newsbox_posted_by($row,$preview)."\n";

		if (isset ($row['id'])) {
			$tmp .= '<!-- ADMINEDIT:'.$row['id'].' -->';
			if ($this->session->checked && ($this->session->level&pow(2,21))) {
				$tmp .= ' - <b><a href="'.$config->basehref.
					$config->adminfile.'?action=edit_news&amp;news_id='.
					$row['id'].'">'.lecho("Edit!").'</a></b>';
			}
			$tmp .= '<!-- /ADMINEDIT -->';
		}

		if (!empty($departement)) {
			$tmp .= "<br />\n".ucfirst("dpt").': <b>'.$departement.'</b>';
		}
		$tmp .= '</font><br /><br />';

		$tmp .= ' <font size="3" color="#505050">'.$body.'</a><br /><br />';

		$tmp .= $this->newsbox_show_links($row,$preview);

		if (isset ($row['id'])) {
			$tmp .= '<br /><br /><div align="left"><img src="'.
				$this->session->imgurl("point").
				'" border="0" alt="" />&nbsp;<font size="2">';
			ereg("^([0-9]{4})([0-9]{2})([0-9]{2})", $row['timestamp'], $regs);
			$tmp .= $this->newsbox_count_comments($row,$row['section'],$row['topic'],$regs[1],$regs[2],$regs[3]);
			$tmp .= $this->newsbox_show_attachments($row);
			$tmp .= '</div>';
		}
		$tmp .= '</td></tr></table>'."\n";

		$tmp .= '<!-- /NEWSBOX --><br /><br />'."\n";
		return $tmp;
	}

	
	/**
	 * Function to print comment top banner
	 *@param integer the score threshold
	 *@param integer the type of resource
	 *@return string the HTML code
	 *@access public
	 */
	Function commentbanner ($score, $res_type) {
		global $config,$news;
		global $section,$topic;
		global $HTTP_GET_VARS,$HTTP_SERVER_VARS,$news_id;

		// Get information to get timestamp + news
		$this->comments = LoadClass('Comments');
		$path = ereg_replace('^/'.$config->htmldir, '/',
			$HTTP_SERVER_VARS['PATH_INFO']);
		if (ereg("^(.*)\\.(html|$config->php)", $path, $res)) {
			$path = $res[1];
		}
		if (ereg('^([^,]*)(,.+)$', $path, $res)) {
			$path = $res[1];
		}
		if (ereg("^/([0-9]{4})/([0-9]{2})/([0-9]{2})/([0-9]+)$", $path, $res)) {
			$year = $res[1];
			$month= $res[2];
			$day  = $res[3];
		} else {
			$ts = $this->utils->gettimestampnews($news_id);
			$year = $ts[0];
			$month= $ts[1];
			$day  = $ts[2];
		}

		if (isset($HTTP_GET_VARS['score'])) {
			$score = $HTTP_GET_VARS['score'];
		}
		$out = '';
		$out .= '<table width="100%" border="0" cellspacing="1" '.
				'cellpadding="2">'."\n";
		$out .= '<tr><td class="commentbox"><a name="banner" href="'.
			$this->session->newsurls($news_id,'','',$year,$month,$day,$score).
			'"><font color="#ffffff">'."\n";
		if (is_object($news)) {
			$out .= $news->show_title($news_id);
		}
		$out .= '</font></a> | ';
		if (!$this->session->checked) {
			$out .= '<a href="'.$config->basehref.
				'users/?a=na"><font color="#ffffff">'.lecho("New Account").
				'</font></a> | ';
			}
		$out .= '<b>';
		$counttmp = $this->comments->count_comments($news_id, $res_type);
		$out .= $counttmp . '</b> ';
		if ($counttmp <= 1) {
			$out .= lecho("comment")."\n";
		} else {
			$out .= lecho("comments")."\n";
		}

		$out .= '</td></tr>'."\n";
		$out .= '<tr><td class="commentboxmiddle">'."\n";
		$out .= '<form method="post" action="'.$config->basehref.
			$config->commaddfile.'">'."\n";
		$out .= '<input type="hidden" name="news_id" value="'.$news_id.'" />'."\n";
		$out .= '<input type="hidden" name="year" value="'.$year.'" />'."\n";
		$out .= '<input type="hidden" name="month" value="'.$month.'" />'."\n";
		$out .= '<input type="hidden" name="day" value="'.$day.'" />'."\n";
		$out .= '<input type="hidden" name="res_type" value="'.$res_type.'" />'.
			"\n";

		$out .= '<input type="hidden" name="section" value="';
		$out .= !empty($section) ? $section : "0";
		$out .= '" />'."\n";

		$out .= '<input type="hidden" name="topic" value="';
		$out .= !empty($topic) ? $topic : "0";
		$out .= '" />'."\n";

		$out .= lecho("Hide signatures").
			': <input type="checkbox" name="hide_sig"';
		if ($config->hide_sig == "1") {
			$out .= ' checked="checked"';
		}
		$out .= ' />'."\n";

		$out .= lecho("Score").': <select name="score">'."\n";
		$score_comment = (array) $this->comments->count_comments_array($news_id,
		$res_type);

		if ($config->moderation_type == 1) {
			for ($i=-1;$i<6;$i++) {
				$counttmp = $score_comment['n'.$news_id]['s'.$i];
				$out .= '<option value="'.$i.'"';

				if ($i == $score || (!isset($score) && $this->session->score == $i)) {
					$out .= ' selected="selected"';
				}

				$out .= '>'.$i.': '.$counttmp.' ';
				if ($counttmp <= 1) {
					$out .= lecho("comment")."\n";
				} else {
					$out .= lecho("comments")."\n";
				}
				$out .= '</option>';
			}
		} else {

			$ok_tmp = 0;
			for ($i=-1;$i<6;$i++) {
				$counttmp = $score_comment['n'.$news_id]['s'.$i];


				$out .= '<option value="'.$i.'"';
				if ($i == $config->oldscore || (!isset($config->oldscore) && $this->session->score == $i)) {
					$out .= ' selected="selected"';
				}

				switch ($i) {
					case "-1":
						$out .= ">".lecho("all");
						break;
					case 0:
						$out .= ">0";
						break;
					case 1:
						$out .= ">".$config->last_week_score;
						break;
					case 2:
						$out .= ">".(2*$config->last_week_score);
						break;
					case 3:
						$out .= ">".(3*$config->last_week_score);
						break;
					case 4:
						$out .= ">".(4*$config->last_week_score);
						break;
					case 5:
						$out .= ">".(5*$config->last_week_score);
						break;
				}

				$out .= ': '.$counttmp.' ';
				if ($counttmp <= 1) {
					$out .= lecho("comment")."\n";
				} else {
					$out .= lecho("comments")."\n";
				}
				$out .= '</option>';
			}

		}

		$out .= '</select>';
		$out .= '<input type="submit" name="op" value="'.lecho("Change").'" />'.
			"\n";
		$out .= '<input type="submit" name="op" value="'.lecho("Reply").
			'" />'."\n</form></td></tr>\n";
		$out .= '<tr><td class="commentbox">'."\n";
		$out .= lecho("<b>The fine print</b>: The following comments are owned by whoever posted them.")." ";
		$out .= lecho("We are not responsible for what they say.")."\n";
		$out .= '</td></tr></table><br /><br />'."\n";

		return $out;
	}

}
?>
