<?php
/** 
 * This Class will host all the sidebox
 * If you wanna commit a new sidebox, do it here
 *
 * daCode http://www.dacode.org/
 * src/phplib/sidebox.php3
 * $Id: sidebox.php3,v 1.95.2.8 2002/08/04 20:40:48 ruffy Exp $
 *
 * Depends: Config Db Html Cache Redirect
 *
 *@author Fabien Penso <penso@linuxfr.org>
 */
Class Sidebox {

	/**
	 * Database abstraction layer
	 *@var object Db
	 */
 	var $db;

	/**
	 * HTML rendering package
	 *@var object HTML
	 */
	var $html;

	/**
	 * Redirect handling insrtance
	 *@var object Redirect
	 */
	var $redirect;

	/**
	 * Cache abstraction layer
	 *@var object Cache
	 */
	var $cache;

	/**
	 * Class constructor
	 */
	Function Sidebox() {
		global $config;
		$this->db = LoadClass('Db');
		$this->user = LoadClass('User');
		$this->session= LoadClass('Session');
		$this->html  = LoadClass('Html');
		$this->cache = LoadClass('Cache');
		$this->redirect = LoadClass('Redirect');
	}

	/**
	 * Returns a box with all the section inside
	 * This is usually used as first box
	 *@return string
	 *@access public
	 */
	Function dacode() {
		global $section;
		global $config;

		if (!isset($section)) $section = '';

		$cachetmp = array ($section,$config->ext,$config->score,$config->hide_sig,$config->depth);

		$fcontents = $this->cache->check_box("180","sidebox_dacode",$cachetmp);
		if (!empty($fcontents)) {
			return $fcontents;
		}

		$out = "";
		$sqlc_q = "SELECT section FROM ". $config->tables['sections'].
			" WHERE state='1' ORDER BY section";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL Failed: ".$this->db->error()." -->\n";
			return;
		}

		$news = LoadClass('News');

		$i=0;
		while($row=$this->db->fetch_array()) {
			$table[$i] = $row;
			$i++;
		}
		$this->db->free();

		$i=0;
		$tempo = array();
		if (count($table) > 0) {
			while ($cur = current($table)) {
				$tempo[$i] = $cur;
				$i++;
				next($table);
			}
		} else {
			$title_tmp = $this->redirect->make("daCode ".$config->version,
				"http://www.dacode.org/", "", ' class="boxheader"');
			$out = $this->html->sidebox($title_tmp, lecho("No section yet"));
			$this->cache->write_box("sidebox_dacode",$cachetmp,$out);
			return $out;
		}

		$tempo_nb = $news->count_section($tempo);
		reset($table);

		while ($cur = current($table)) {
			$out .= "&nbsp;-&nbsp;";
			if ($section == $cur['section']) {
				$out .= "<b>";
			}

			$ok = 0;
			if (gettype($tempo_nb) == "array") {
				reset($tempo_nb);
				while($cur2 = current($tempo_nb)) {
					if ($cur2['section'] == $cur['section']) {
						$out .= "[".$cur2[0]."] ";
						$ok = 1;
						break;
					}
					next($tempo_nb);
				}
			}

			if ($ok=='0') {
				$out .= "[0] ";
			}

			$url_tmp = $config->baseurl.
				($config->visiblenewsfile ? $config->newsfile . "/" : "");
			$out .= $this->redirect->make(htmlentities($cur['section']),$url_tmp.
				"section/".urlencode($cur['section']).$config->extraopts.$config->ext).
				"<br />";

			if ($section == $cur['section']) {
				$out .= "</b>";
			}

			next($table);
		}

		// users can post resource using these links:
		$out .= '<div align="center"><hr style="height:1px" '.
			'width="80%" /></div>'."\n";
		$out .= '&nbsp;-&nbsp;<a href="'.$config->baseurl.
			'submit.'.$config->php.'">'.lecho("Submit news")."</a><br />\n";
		$out .= '&nbsp;-&nbsp;<a href="'.$config->baseurl.
			$config->pollsubmitfile.'">'.lecho("Submit a poll")."</a><br />\n";
		// but some users have got privilegies:
		if ($this->session->checked) {
			$out .= '&nbsp;-&nbsp;<a href="'.$config->baseurl.
				'tips/submit.'.$config->php.'">'.lecho("Submit a tip")."</a><br />\n";
			$out .= '&nbsp;-&nbsp;<a href="'.$config->baseurl.
				'webcam/submit.'.$config->php.'">'.lecho("Submit a picture")."</a><br />\n";
		}

		$title_tmp = $this->redirect->make("daCode ".$config->version,
					"http://www.dacode.org/", "", ' class="boxheader"');
		$out = $this->html->sidebox($title_tmp, $out);
		$this->cache->write_box("sidebox_dacode",$cachetmp,$out);
		return $out;
	}


	/**
	 *  This is to show the topics box on the left 
	 *@return string list of topics
	 *@access public
	 */
	Function topics() {
		global $topic;
		global $config;

		$cachetmp = array ($config->ext,$config->score,$config->hide_sig,$config->depth);

		$fcontents = $this->cache->check_box("180","sidebox_topics",$cachetmp);
		if (!empty($fcontents)) {
			return $fcontents;
		}

		$out = "";
		$sqlc_q = "SELECT topic,longname FROM ". $config->tables['topics'].
			" WHERE state='1' ORDER BY topic,longname";
		$ret = $this->db->query($sqlc_q);
		if (!$ret) {
			echo "<!-- SQL Failed: ".$this->db->error()." -->";
			return;
		}

		if (!$this->db->num_rows()) {
			$out = $this->html->sidebox(lecho("Topics"), lecho("No topic yet"));
			$this->cache->write_box("sidebox_topics",$cachetmp,$out);
			return $out;
		}

		while($row=$this->db->fetch_array()) {
			if (!isset($row['longname']) ||
					$row['longname'] == "") {
				$row['longname'] = $row['topic'];
			}
			$out .= "&nbsp;-&nbsp;";
			if (isset($topic) && $topic == $row['topic']) {
				$out .= "<b>";
			}
			$url_tmp = $config->baseurl .(
				$config->visiblenewsfile ? $config->newsfile . "/" : "");
			$out .= $this->redirect->make(htmlentities($row['longname']),
				$url_tmp."topic/".urlencode($row['topic']).$config->extraopts.$config->ext).
				"<br />";
			if (isset($topic) && $topic == $row['topic']) {
				$out .= "</b>";
			}
		}

		$this->db->free();
		$out = $this->html->sidebox(lecho("Topics"), $out);
		$this->cache->write_box("sidebox_topics",$cachetmp,$out);
		return $out;
	}

	/**
	 * We use this box to put local links
	 *@return string box with local links
	 *@access public
	 */
	Function local_links() {
		global $config;

		$title = lecho("Local Links");
		$tmp = '';
		$tmp .= '&nbsp;-&nbsp;'.
			$this->redirect->make(lecho("News on your PDA"),
				$config->basehref.'pda/').'<br />';
		$tmp .= '&nbsp;-&nbsp;'.
			$this->redirect->make(lecho("News by WAP"),
				$config->basehref.'wap/').'<br />';
		$tmp .= '&nbsp;-&nbsp;'.
			$this->redirect->make(lecho("News on your site"),
				$config->basehref.'w/index.'.$config->php).'<br />';
		$tmp .= '&nbsp;-&nbsp;'.
			$this->redirect->make(lecho("Mozilla/Netscape 6 Sidebar"),
				$config->basehref.'sidebar/index.'.$config->php);

		return $this->html->sidebox($title,$tmp);
	}

	/**
	 * This is called edito and will be the first box on the right
	 *@return string
	 *@access public
	 */
	Function edito() {
		global $config;

		if (empty($config->edito)) {
			return;
		}
		$title = lecho("Editorial");
		$body = nl2br($config->edito);
		return $this->html->sidebox($title,$body);
	}

	/**
	 * This is to show the last people connected
	 *@param integer number of users to show
	 *@return string
	 *@access public
	 */
	Function lastconnected($nb=10) {
		$out = $this->user->get_lastconnected($nb);
		return $this->html->sidebox(lecho("Users"),$out);
	}

	/**
	 * Search box
	 *@param integer if 1, puts search form in a box
	 *@param string size of the input field
	 *@return string the form
	 *@access public
	 */
	Function searchbox($box=1,$size="20") {
		global $config;

		if ($box == 1) {
			$tmp = "<form method=\"get\" action=\"".$config->baseurl.
				"search.".$config->php."\">".
				"<center><input type=\"text\" name=\"keywords\" size=\"".$size."\"".
				" maxlength=\"100\" /><br />".
				"<input type=\"hidden\" name=\"pos\" value=\"0\" />".
				"<input type=\"hidden\" name=\"step\" value=\"".
				$config->default_results_step."\" />".
				"<input type=\"hidden\" name=\"topic\" value=\"-1\" />".
				"<input type=\"hidden\" name=\"section\" value=\"-1\" />".
				"<input type=\"submit\" name=\"submit\" value=\"".
				lecho("Search")."\" /></center>"."</form>";

			$boxtitle = "<a href=\"".$config->baseurl."search.".$config->php.
				"\" class=\"boxheader\">".

			lecho("Search")."</a>";


			return $this->html->sidebox($boxtitle,$tmp);
		} else {
			$tmp = "<form method=\"get\" action=\"".$config->baseurl.
				"search.".$config->php."\">".
				"<input type=\"text\" name=\"keywords\" size=\"20\"".
				" maxlength=\"100\" />&nbsp;".
				"<input type=\"hidden\" name=\"pos\" value=\"0\" />".
				"<input type=\"hidden\" name=\"step\" value=\"".
				$config->default_results_step."\" />".
				"<input type=\"hidden\" name=\"topic\" value=\"-1\" />".
				"<input type=\"hidden\" name=\"section\" value=\"-1\" />".
				"<input type=\"submit\" name=\"submit\" value=\"".
				lecho("Search")."\" />"."</form>";
			return $tmp;
		}
	}//searchbox

}

?>
