<?php
/**
 * Abstraction layer for databases.
 * Responsibility: all access to DB
 *
 * daCode http://www.dacode.org/
 * src/phplib/dbmysql.php3
 * $Id: dbmysql.php3,v 1.15.2.5 2002/06/01 21:29:50 ruffy Exp $
 *
 * booleen Db(host, login, passwd, database, persistant (0 ou 1));
 * booleen query($query_str);
 * free();
 * $array fetch_array();
 * int num_rows();
 * void error(); // affiche l erreur
 *
 * Depends: Config
 *
 *@author Fabien Seisen <seisen@linuxfr.org>
 *@package MySQL
 */
class Db {
	/**
	 * Db abstraction layer instance
	 *@var object Db
	 */
	var $db;

	/**
	 * a result index if the query has been successfully executed, false on failure.
	 *@var integer 
	 */
	var $results;

	/**
	 * Class constructor. Opens a connection to the database.
	 * Reads the necessary values in Config.
	 *@access public
	 */
	Function Db() {
		global $config;

		//echo '<br />Db';
		if ($config->sql_persistant == 1) {
			$this->pconnect($config->sql_host,
				$config->sql_user, $config->sql_passwd);
		} else {
			$this->connect($config->sql_host,
				$config->sql_user, $config->sql_passwd);
		}

		if (! $this->db) {
			// echo "Db->Db() failed<br />\n";
			$config->nodb = 1;
			return 0;
		}

		$ret = $this->select_db($config->sql_db, $this->db);
		return $ret;
	}

	/**
	 * Duplicates a DB maintaining consistency.
	 */
	Function clone() {
		$db2 = new Db("", "", "", "", "");
		$db2->db = $this->db;
		return $db2;
	}

	/**
	 * Connects to the database
	 *@param string the DB host
	 *@param string user login
	 *@param string user password
	 *@return int the dabase link identifier or NULL on failure(?)
	 @access private
	 */
	Function connect($host, $login, $passwd) {
		$this->db  = @mysql_connect($host, $login, $passwd);
		return $this->db;
	}

	/**
	 * Opens a persistent connection to the database
	 *@param string the DB host
	 *@param string user login
	 *@param string user password
	 *@return int the dabase link identifier or NULL on failure(?)
	 *@access private
	 */
	Function pconnect($host, $login, $passwd) {
		$this->db  = @mysql_pconnect($host, $login, $passwd);
		return $this->db;
	}

	/**
	 * Closes the connection to the database
	 *@return int return code of mysql_close().
	 *@access public
	 */
	Function close() {
		$this->ret = mysql_close($this->db);
		return $this->ret;
	}
	/**
	 * Really useful only for MySQL so far.
	 *@access private
	 */

	Function select_db($database) {
		return @mysql_select_db($database, $this->db);
	}
	/**
	 * Sends an SQL query, with limitations.
	 * WARNING: don't send unduly long queries with this method! That is, query 
	 * length shall be less than 8000 characters long, because of a PostgreSQL 
	 * limitation. This limit may be lowered when we add support for other databases.
	 *@param string the query to b exectuted
	 *@return int a result index if the query has been successfully executed, false on failure.
	 *@access public
	 */
	Function query($query) {
		global $config;

		if (!empty($config->sql_logfile)) {
			if (!($fp = fopen($config->sql_logfile,"ab"))) {
				echo "problem...";
			}
			$bytes_written = fputs($fp,$query."\n");
			fclose($fp);
			if ($bytes_written != strlen($query)+1) {
				@unlink($config->sql_logfile);
				$config->nosave = 1;
			}
		}

		$this->results = @mysql_query($query, $this->db);
		return $this->results;
	}

	/**
	 * Gets the value of fieldname in row nb.
	 * Row numbering starts at 0.
	 *@param int the number of the row
	 *@param the field to return
	 *@return mixed the value.
	 */
	Function result($nb, $fieldname) {
		return @mysql_result($this->results, $nb, $fieldname);
	}

	/**
	 * Frees the result buffer.
	 */
	Function free() {
		return mysql_free_result($this->results);
	}

	/**
	 * Gets the current row in data set.
	 * Automatically converts the "timestamp" field from mysql timestamp 
	 * to a MySQL one.
	 *@return array the fetched row; false if no more rows.
	 *@access public
	 */
	Function fetch_array() {
		return mysql_fetch_array($this->results);
	}

	/**
	 * Hmm, unused one?
	 * Call to mysql_fetch_array DOES NOT MATCH prototype
	 *@deprecated
	 */
	Function fetch_field() {
		return mysql_fetch_field($this->results);
	}

	/**
	 * Gets the number of rows in the result set
	 *@return int 
	 */
	Function num_rows() {
		return mysql_num_rows($this->results);
	}

	/**
	 * Gets the nuimber of fields in the result set.
	 *@return int (What else would you expect?)
	 */
	Function num_fields() {
		return mysql_num_fields($this->results);
	}

	/**
	 * Gets the last DBMS error message
	 *@return string the clear (hopefully!) english error message
	 *@access public
	 */
	Function error() {
		return mysql_error($this->db);
	}
	/**
	 * Gets last inserted ID
	 * REALLY USEFUL?
	 *@return int 
	 */

	Function last_insert_id() {
		return mysql_insert_id();
	}

	/**
	 * Returns the number of rows affected by last query.
	 *@return int
	 */
		Function affected_rows() {
		return mysql_affected_rows();
	}

	//   The compat_* functions are to handle with incompatibilities
	//   between SQL backends

	/**
	 * Creates a MySQL-compatible (specific?) LIMIT clause
	 *@param int the number of rows the result set should be limited to
	 *@param int the number of rows to be skipped before the result set.
	 *@retrn string a valid mysql LIMIT clause 
	 *@access public
	 */
	Function compat_limit($nb,$offset="0") {
		return 'LIMIT '.$offset.','.$nb;
	}

	/**
	 * Creates a SQL expression for now + sec
	 * Creates the SQL expression which will give a timestamp for 
	 * current time + sec seconds.
	 *@param int the number of seconds from now.
	 *@return the SQL order.
	 */
	Function compat_date_add($sec) {
		return 'DATE_ADD(CURRENT_TIMESTAMP,INTERVAL '.$sec.' SECOND)';
	}

	/**
	 * Converts a timestamp14 (YYYYMMDDhhmmss) into DBMS stamp
	 * (YYYYMMDDhhmmss for MySQL).
	 * @param int t timestamp14
	 * @return a MySQL timestamp
	 */
	Function timestamp14_to_dbms_stamp( $t) {
		return $t;
	}

	/**
	 * Converts a date8 (YYYYMMDD) into DBMS date (YYYYMMDD for MySQL).
	 * @param int t date8
	 * @return a MySQL date
	 */
	Function date8_to_dbms_date( $t) {
		return $t;
	}

	//Large objects interface implementaion, as this is NOT specified in any SQL standard (AFAIK)
	// IMPLEMENTATION NOTES
	// We store LOB into mysql BLOB fields, base64-encoded
	// Other implementation might use a filename instead.

	/**
	 * Inserts a LOB into the database. 
	 * Takes care of any encoding needed for LOB. Other values must be valid SQL ie strings inside ' '.
	 *@param string the name of the table
	 *@param array hash (column, value) pair; valid SQL except LOB fields which are raw data.
	 *@param array list of fields to be treated as LOB
	 *@return int true on success, false otherwise
	 */
	Function insertLob($table, $values, $lobFields) {
		//We encode the lob values (addslashes) + they shall be enclosed in quotes.
		reset($lobFields);
		while(list(,$f) = each($lobFields)) {
			$values[$f] = "'". addslashes($values[$f]) ."'";
		}

		//Now this has been saved. Create the INSERT command.
		$query= "INSERT INTO $table (";
		$flag = false;
		$columns = "";
		$vals = "";
		reset($values);
		while (list($cname, $val) = each($values)) {
			if (!$flag) {
				$flag = true;
			} else {
				$columns .= ", ";
				$vals .= ", ";
			}
			$columns .= $cname;
			$vals .= $val;
		}
		$query .= $columns . ") VALUES (" . $vals . ")";

		// OK, run the query
		$ret_val =  $this->query($query);
		if (!$ret_val) {
			$utils = LoadClass('Utils');
			echo "<!-- failed in insertLOB. See debug output for more. MySQL said: ".
				$this->error() . "-->";
			$utils = LoadClass('Utils');
			$utils->debug("Query was " . $query); 
		}
		return $ret_val;
	}
	
	/**
	 * Gets a LOB identified by its primary key
	 *@param string name of the table...
	 *@param string pkField the name of the primary key
	 *@param int pk the primary key itself
	 *@param string the name of the LOB field.
	 *@return string the LOB, false on error.
	 */
	Function getLobByID($table, $pkField, $pk, $lobField) {
		$r = $this->query("SELECT $lobField FROM $table WHERE $pkField = $pk");
		if (!$r) {
			echo "<!-- Error in getLibByID: " . 
					 $this->error() . 
					 " SELECT $lobField FROM $table WHERE $pkField = $pk -->";
			return false;
		}
		$row = $this->fetch_array();
		return $row[0];
	}

	/**
	 * Gets a row from current dataset containing LOBs
	 * Careful: you may run into inconsitencies if you use numeric indexes.
	 * Always use name indexes.
	 *@param array list of fields containing LOBs
	 *@return array the fethed row, with LOBs...
	 */
	Function fetchLOB($lobFields) {
		$row = mysql_fetch_array($this->results);
		return $row;
	}


	/**
	 * Deletes a row  containing a LOB knowing its ID
	 *@param string name of the table...
	 *@param string pkField the name of the primary key
	 *@param int pk the primary key itself
	 *@param string the name of the LOB field.
	 *@return int true on success
	 */
	Function deleteLOB($table, $pkField, $pk, $lobField) {

		$r = $this->query("DELETE FROM $table WHERE $pkField = $pk");
		if (!$r) {
			echo "<!-- Error deleting LOB: " . $this->error() . 
				"DELETE FROM $table WHERE $pkField = $pk -->";
			return false;
		}
		return true;
	}

}

?>
