#! /usr/bin/perl -w
#
# TrollBrowser.
#
# TrollBrowser is a GTK client designed for daCode-powered boards.
# By default, it reaches linuxfr.org, but you can modify it to reach other 
# boards.
#
# $Id: gtktrib.pl,v 1.1.2.1 2001/12/31 16:17:22 netsabes Exp $
#

use Gtk;         # load the Gtk-Perl module
use LWP::UserAgent;
use HTTP::Cookies;
use URI::Escape;
#use Gtk::HTML; fuck not installed by default !
#use strict;      # a good idea for all non-trivial Perl scripts

set_locale Gtk;  # internationalize
init Gtk;        # initialize Gtk-Perl
my %enc = ( 
nbsp   => chr(160),
iexcl  => chr(161),
cent   => chr(162),
pound  => chr(163),
curren => chr(164),
yen    => chr(165),
brvbar => chr(166),
sect   => chr(167),
uml    => chr(168),
copy   => chr(169),
ordf   => chr(170),
laquo  => chr(171),
not    => chr(172),
shy    => chr(173),
reg    => chr(174),
macr   => chr(175),
deg    => chr(176),
plusmn => chr(177),
sup2   => chr(178),
sup3   => chr(179),
acute  => chr(180),
micro  => chr(181),
para   => chr(182),
middot => chr(183),
cedil  => chr(184),
sup1   => chr(185),
ordm   => chr(186),
raquo  => chr(187),
frac14 => chr(188),
frac12 => chr(189),
frac34 => chr(190),
iquest => chr(191),
Agrave => chr(192),
Aacute => chr(193),
Acirc  => chr(194),
Atilde => chr(195),
Auml   => chr(196),
Aring  => chr(197),
AElig  => chr(198),
Ccedil => chr(199),
Egrave => chr(200),
Eacute => chr(201),
Ecirc  => chr(202),
Euml   => chr(203),
Igrave => chr(204),
Iacute => chr(205),
Icirc  => chr(206),
Iuml   => chr(207),
ETH    => chr(208),
Ntilde => chr(209),
Ograve => chr(210),
Oacute => chr(211),
Ocirc  => chr(212),
Otilde => chr(213),
Ouml   => chr(214),
times  => chr(215),
Oslash => chr(216),
Ugrave => chr(217),
Uacute => chr(218),
Ucirc  => chr(219),
Uuml   => chr(220),
Yacute => chr(221),
THORN  => chr(222),
szlig  => chr(223),
agrave => chr(224),
aacute => chr(225),
acirc  => chr(226),
atilde => chr(227),
auml   => chr(228),
aring  => chr(229),
aelig  => chr(230),
ccedil => chr(231),
egrave => chr(232),
eacute => chr(233),
ecirc  => chr(234),
euml   => chr(235),
igrave => chr(236),
iacute => chr(237),
icirc  => chr(238),
iuml   => chr(239),
eth    => chr(240),
ntilde => chr(241),
ograve => chr(242),
oacute => chr(243),
ocirc  => chr(244),
otilde => chr(245),
ouml   => chr(246),
divide => chr(247),
oslash => chr(248),
ugrave => chr(249),
uacute => chr(250),
ucirc  => chr(251),
uuml   => chr(252),
yacute => chr(253),
thorn  => chr(254),
yuml   => chr(255),
quot   => "\"",
"amp"    => "&",
"lt"     => "<",
"gt"     => ">");


my $lastid = 0;
my $http_proxy = $ENV{http_proxy};

my %news_ip;

# convenience variables for true and false
my $false = 0;
my $true = 1;

my $vbox1 = new Gtk::VBox( $false, 0 );
my $hbox = new Gtk::HBox( $false, 0 );
my $hbox1 = new Gtk::HBox( $false, 0 );
my $hbox2 = new Gtk::HBox( $false, 0 );
my $hbox3 = new Gtk::HBox( $false, 0 );


# widget creation
my $window = new Gtk::Window( "toplevel" );
$window->set_usize( 800, 400 );


my $button_quit = new Gtk::Button( "Quit" );
my $button_refresh = new Gtk::Button( "Refresh" );
my $button_submit = new Gtk::Button( "Submit" );
my $text = new Gtk::Text( undef, undef );
my $label_ua = new  Gtk::Label("User agent: ");

my $vscrollbar = new Gtk::VScrollbar( $text->vadj );
$vscrollbar->show();

my $text_msg = new Gtk::Entry( 200);
my $text_ua = new Gtk::Entry( 200);
$text_ua->set_text( "Troll browser/1.0 (not mozilla, not IE,... just troll)" );

#$text->set_alignment( 0, 0 );
$vbox1->pack_start($hbox1, $true, $true, 0);
$vbox1->pack_start($hbox, $false, $true, 0);
$vbox1->pack_start($hbox2, $false, $true, 0);
$vbox1->pack_start($hbox3, $false, $true, 0);

$hbox2->pack_start($label_ua, $false, $true, 0);
$hbox2->pack_start($text_ua, $true, $true, 0);

$hbox1->pack_start($text, $true, $true, 0);
$hbox1->pack_start($vscrollbar, $false, $true, 0);

$hbox->pack_start($button_quit, $false, $true, 0);
$hbox->pack_start($button_refresh, $false, $true, 0);
$hbox->pack_start($text_msg, $true, $true, 0);
$hbox->pack_start($button_submit, $false, $true, 0);

# check box
my $checkbutton_bold =  new Gtk::CheckButton("bold");
$hbox3->show();
$checkbutton_bold->show();
$hbox3->pack_start($checkbutton_bold, $false, $true, 0);
my $checkbutton_reverse =  new Gtk::CheckButton("reverse");
$hbox3->show();
$checkbutton_reverse->show();
$hbox3->pack_start($checkbutton_reverse, $false, $true, 0);
my $checkbutton_altcase =  new Gtk::CheckButton("alternate case");
$hbox3->show();
$checkbutton_altcase->show();
$hbox3->pack_start($checkbutton_altcase, $false, $true, 0);
my $checkbutton_leet =  new Gtk::CheckButton("l33t");
$hbox3->show();
$checkbutton_leet->show();
$hbox3->pack_start($checkbutton_leet, $false, $true, 0);
my $checkbutton_moment =  new Gtk::CheckButton("moment");
$hbox3->show();
$checkbutton_moment->show();
$hbox3->pack_start($checkbutton_moment, $false, $true, 0);

# news
# This is the scrolled window to put the List widget inside
my $hbox5 = new Gtk::HBox( $false, 0 );
my $scrolled_window = new Gtk::ScrolledWindow( undef, undef );
$scrolled_window->set_usize( 360, 100 );
$scrolled_window->set_policy( "automatic",
                              "automatic" );
$vbox1->pack_start( $hbox5, $false, $false, 0 );
$scrolled_window->show();

# Create the List widget.  Connect the sigh_print_selection() signal handler
# function to the "selection_changed" signal of the List to print out the
# selected items each time the selection has changed.
my $gtklist = new Gtk::List();
$gtklist->signal_connect( 'selection_changed', \&sigh_print_selection );
$scrolled_window->add_with_viewport( $gtklist );
$gtklist->show();
my $text_news = new Gtk::Text( undef, undef );
$text_news->set_word_wrap( $true );
$text_news->show();
$hbox5->pack_start($scrolled_window, $false, $true, 0 );
$hbox5->pack_start($text_news, $true, $true, 0 );
my $vscrollbar_news = new Gtk::VScrollbar( $text_news->vadj );
$vscrollbar_news->show();
$hbox5->pack_start($vscrollbar_news, $false, $true, 0 );


my $hbox4 = new Gtk::HBox( $false, 0 );
$vbox1->pack_start( $hbox4, $false, $true, 0 );
my $button_refresh_news =  new Gtk::Button("Refresh news");
$button_refresh_news->signal_connect( "clicked", \&refresh_news );
my $button_news_show =  new Gtk::Button("Show news");
$button_news_show->signal_connect( "clicked", \&news_show_hide );
$hbox4->pack_start($button_news_show, $false, $true, 0);
$button_news_show->show();
#$button_refresh_news->show();
$hbox4->pack_start($button_refresh_news, $false, $true, 0);
$hbox4->show();



# statusbar
$statusbar = new Gtk::Statusbar();
$vbox1->pack_start( $statusbar, $false, $true, 0 );
$statusbar->show();
my $statusbar_contextid = $statusbar->get_context_id("Statusbar");

# account_info
my $label_accinfo = new  Gtk::Label("Account info: ");
$hbox2->pack_start($label_accinfo, $false, $true, 0);
$label_accinfo->show();
my $text_accinfo = new Gtk::Entry(50);
$hbox2->pack_start($text_accinfo, $true, $true, 0);
$text_accinfo->show();
$text_accinfo->set_editable( $false );




# callback registration
$window->signal_connect( "delete_event", \&CloseAppWindow );   
$button_quit->signal_connect( "clicked", \&CloseAppWindow );
$button_refresh->signal_connect( "clicked", \&refresh );
$button_submit->signal_connect( "clicked", \&submit );
$text_msg->signal_connect( "activate", \&submit );


# show button
$button_quit->show();
$button_refresh->show();
$button_submit->show();
$label_ua->show();
$text_ua->show();

$text_msg->show();

$text->show();
$vbox1->show();
$hbox->show();
$hbox1->show();
$hbox2->show();

print "\nLoading news...\n";
refresh_news();
print "Loading account information...\n";
refresh_XP();
# set window attributes and show it
$window->border_width( 15 );
$window->add( $vbox1 );
$window->show();

print "Loading tribune libre for the first time...\n";
refresh();
$timer = Gtk->timeout_add( 7000, \&refresh, undef);
$timer2 = Gtk->timeout_add( 300 * 1000, \&refresh_XP, undef);

# Gtk event loop
main Gtk;

# Should never get here
exit( 0 );



### Callback function to close the window
sub CloseAppWindow
{
   Gtk->exit( 0 );
   return $false;
}

sub refresh_XP
{
  $useragent = $text_ua->get_text();
  my $doc = get_page_without_header("linuxfr.org","index,0,1,0,0.php3",
				    "index,0,1,0,0.php3", $useragent );

  $doc =~ /XP&nbsp;: ([0-9]+)<br \/>([0-9]+) votes par jour<br \/>reste: ([0-9]+)<br \/>vous tes un ([a-zA-Z]+)<br \/>/;

  if (! defined($1)) {
    $text_accinfo->set_text("N/A, copy Netscape cookies in /tmp/cookies.txt");
    return $true;
  }
  $text_accinfo->set_text("XP's: $1 Votes : $3/$2 Grade: $4");

  return $true;
}

sub news_show_hide
{
  if ($button_refresh_news->visible) {
    $button_refresh_news->hide();
    $hbox5->hide();
    $button_news_show->child->set( "Show news" );
  } else {
    $button_refresh_news->show();
    $hbox5->show();
    $button_news_show->child->set( "Hide news" );
  }
}

### Refresh tribune libre !
sub refresh
{
  $useragent = $text_ua->get_text();
#  $lastip = `lynx -source http://homeusers.brutele.be/apiron/lastip`;
#  chomp $lastip;
#  $doc = `lynx -source http://$lastip/~cdht/daroot/board/remote.xml`;

  my $succid = $lastid + 1;
  if ($lastid != 0 &&
      post_data_without_header( "linuxfr.org", "board/info.php3",
				"id=$succid",
				"http://linuxfr.org/board/index.php3",
				$useragent) =~ /^$/m) {
    return $true;
  }

  $doc = get_page_without_header("linuxfr.org","board/remote.xml",
				 "http://linuxfr.org/board/index.php3",
				 $useragent);
  my @posts = parse_trib($doc);

  my $text_bottom = $text->vadj->upper - $text->vadj->page_size;
  my $scroll = $text_bottom == $text->vadj->value;
  $text->freeze();
  
  foreach (reverse @posts) {
    if ($_->{id} > $lastid) {
      my $t = $_->{time};
      my $browser = defined($_->{info})?$_->{info}:"";
      my $msg = htmlchar2text($_->{message});
      my $nick = $_->{login};
          $lastid = $_->{id};
      # remove <b>, ...
    #  $msg =~ s/<\/?[bs]>|<a href=\"([^\"]*)\"><b>\[url\]<\/b><\/a>/defined($1)?"$1":""/mieg;
      $msg =~ s/<a href=\"([^\"]*)\"><b>\[url\]<\/b><\/a>/$1/mieg;

      $t = substr($t, 6, 2) . "/" . substr($t, 4, 2) . "/" . substr($t, 0, 4) . " " . substr($t, 8, 2) . ":" . substr($t, 10, 2) . ":" .substr($t, 12, 2);
      
      $browser =~ s/.*(galeon|troll|lynx|konqueror|w3m).*/$1/i;
      $browser =~ s/.*(wmcoincoin|palmipede|palmipde).*/wmcoincoin/i;
      $browser =~ s/.*(mozilla.*win).*/Mozilla \(windows\)/i;
      $browser =~ s/.*(mozilla.*linux).*/Mozilla \(linux\)/i;
      $browser =~ s/.*(mozilla\/).*/Mozilla \(os: unknown\)/i;
      $browser =~ s/.*ie.*/MSIE/i;
      chomp $browser;
      
      # see http://www.linuxgazette.com/issue65/padala.html for color codes
      $text->insert( undef, {red =>0xFFFF, green => 0, blue => 0} , undef,  "$t");
      $text->insert( undef, {red =>0, green => 0x9FFF, blue => 0}, undef, " [$browser]");
      $text->insert( undef, {red =>0, green => 0, blue => 0xFFFF}, undef, " <$nick>");

      my $name = "-*-*-bold-r-normal--14-*-iso8859-15";
      my $font = Gtk::Gdk::Font->load( $name );

      $text->insert( $font, undef, undef, "   $msg \n");

    }
  }
  $text->thaw();
  if ($scroll) {$text->vadj->set_value($text->vadj->upper - $text->vadj->page_size);}


  return $true;
}
### Refresh news !
sub refresh_news
{
  $useragent = $text_ua->get_text();

  $doc = get_page_without_header("linuxfr.org","backend.rdf",
				 "http://linuxfr.org/", $useragent );
  my @news = parse_news($doc);

  
# How to get size of this fucking list !
  $gtklist->clear_items(0, 100);
  %news_ip = ();
  foreach (@news) {
    my $anews = htmlchar2text($_->{title});
#    $news_ip{$anews} = $_->{link};
    my $label = new Gtk::Label( $anews );
    
    my $list_item = new Gtk::ListItem($anews);
    $gtklist->add( $list_item );
    $news_ip{$gtklist->child_position( $list_item )} = $_->{link};
    $list_item->show();
  }

  return $true;
}

sub sigh_print_selection
{
  my ( $gtklist ) = @_;
  
  # Fetch the currently selected list item which will be our next
  # prisoner
  my @dlist = $gtklist->selection;
  
  # If there are no selected items there is nothing more to do than
  # just telling the user so
  
  if ( @dlist ) {
    my $id = $news_ip{$gtklist->child_position( $dlist[0])};
    $id =~ s/.*\/([0-9]+),.*/$1/;
#    print $id . "\n";
    $doc = post_data_without_header("linuxfr.org","pda/news.php3", 
				    "news_id=$id",
				    "http://linuxfr.org/", $useragent );
#     print $doc;
    $doc =~ /<small>((.|\n)*)<\/small>/m;
    $doc = $1;

    $doc =~ s/<p>|<br>/\n/img;
    $doc =~ s/<a\s+href\s*=\s*\"([^\"]*)\"\s*>([^<>]*)<\/a>/[$2] $1/mig;
    $doc =~ s/<[^<>]+>//img;

    $doc = htmlchar2text($doc);

#    print $doc;
    $text_news->freeze();
    $text_news->delete_text(0,  length($text_news->get_chars( 0, -1 )) - 1);
    $text_news->insert( undef, undef , undef,  $doc);
    $text_news->thaw();
  } else {
#    print "Selection cleared\n";
  }
}



sub submit 
{
  $msg = $text_msg->get_text();
  if ($checkbutton_moment->active) {
    $msg = "====> Moment " . $msg . " <====";
  }

  if ($checkbutton_bold->active) {
    $msg = "<b>" . $msg . "</b>";
  }

  if ($checkbutton_leet->active) {
    $msg =~ tr/eosa/3054/;
    $msg =~ s/x/></g;
    $msg =~ s/k/|</g;
  }

  if ($checkbutton_altcase->active) {
    $msg =~ s/(.)(.)?/uc($1).lc($2)/eg;
  }

  if ($checkbutton_reverse->active) {
    chomp $msg;
    $msg = join("",reverse(split("",$msg)));
  }

  $msg = uri_escape($msg,"^A-Za-z");
        
  $host = "linuxfr.org";
  $param = "message=$msg" . "&board_section_=1";
  $file = "board/add.php3";
  $referer = "http://linuxfr.org/board/index.php3";
  $useragent = $text_ua->get_text();

  my $res = post_data($host, $file, $param, $referer, $useragent);
 

  my  ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
  if ($res =~ /Dsol mais vous ne pouvez pas rajouter deux messages de suite/m) {
    $statusbar->push( $statusbar_contextid, "$hour:$min:$sec Dsol mais vous ne pouvez pas rajouter deux messages de suite");
  } elsif ($res =~ /Dsol mais votre message contient des mots trop longs/m) {
    $statusbar->push( $statusbar_contextid, "$hour:$min:$sec Dsol mais votre message contient des mots trop longs");
  } elsif ($res =~ /HTTP\/.\.. 302 .*/im) {
    $statusbar->push( $statusbar_contextid, "$hour:$min:$sec Ok Sent");
    $text_msg->set_text( "" );
  } else {
    $statusbar->push( $statusbar_contextid, "$hour:$min:$sec Not send. Status on console");
    print $res . "\n";
  }
}

## post_data(host, file, param, referer, ua)
sub post_data 
{
 my $host = shift(@_);
 my $file = shift(@_);
 my $param = shift(@_);
 my $referer = shift(@_);
 my $useragent = shift(@_);
  
 my $ua = LWP::UserAgent->new;
 if (defined  $http_proxy) 
   {
     $ua->proxy(['http'], $http_proxy);
   }
 my $c = HTTP::Cookies::Netscape->new(
                          File     => "/tmp/cookies.txt",
                          AutoSave => 1,
                      );

 $ua->cookie_jar($c);

 my $req = HTTP::Request->new(POST => "http://$host/$file");
 $req->content_type('application/x-www-form-urlencoded');
 $req->content($param);
 $req->referer($referer);
 $req->user_agent($useragent);
 
 my $res = $ua->request($req);
# print $res->as_string;
# print "\n";

 return $res->as_string;
}

## post_data(host, file, param, referer, ua)
sub post_data_without_header {
  my $res = post_data(@_);

  $res =~ /\n\n((.|\n)*)/m;
  $res = $1;
# print $res . "\n";

 return $res;
}

## get_page(host, file, referer, ua)
sub get_page_without_header
{
 my $host = shift(@_);
 my $file = shift(@_);
 my $referer = shift(@_);
 my $useragent = shift(@_);
  
 my $ua = LWP::UserAgent->new;
 if (defined  $http_proxy) 
   {
     $ua->proxy(['http'], $http_proxy);
   }
 my $c = HTTP::Cookies::Netscape->new(
                          File     => "/tmp/cookies.txt",
                          AutoSave => 1,
                      );

 $ua->cookie_jar($c);

 my $req = HTTP::Request->new(GET => "http://$host/$file");
 $req->referer($referer);
 $req->user_agent($useragent);
 
 my $res = $ua->request($req);
# print $res->as_string;
# print "\n";
 $res = $res->as_string;
 $res =~ /\n\n((.|\n)*)/m;
 $res = $1;
# print $res . "\n";

 return $res;
}

sub htmlchar2text
{
  my $doc = shift @_;

  $doc =~ s/\&([[:alnum:]]+);/defined($enc{$1})?$enc{$1}:"&$1;"/gme;
  $doc =~ s/\&([[:alnum:]]+);/defined($enc{$1})?$enc{$1}:"&$1;"/gme;

  return $doc;
}

sub parse_trib
{
  my $doc = shift @_;
  my @trib;

  while (1) {
    if (! ($doc =~ s/<post time=\"(.*)\" id=\"(.*)\">\n\s*<info>(.*)<\/info>\n\s*<message>(.*)<\/message>\n\s*<login>(.*)<\/login>\n\s*<\/post>//m)) {
      last;
    }
    my $entry = {time => $1, id => $2, info => $3, message => $4, login => $5};
    push @trib, $entry;
#    print "$1 $2 \n $3 $4 $5\n";
    #$doc = $6;
  }
  return @trib;
}

sub parse_news
{
  my $doc = shift @_;
  my @news;

  while (1) {
    if (! ($doc =~ s/<item>\n\s*<title>(.*)<\/title>\n\s*<link>(.*)<\/link>\n\s*<\/item>//m)) {
      last;
    }
    my $entry = {title => $1, link => $2};
    push @news, $entry;
#    print "$1 \n$2\n";
    #$doc = $6;
  }
  return @news;
}
