#!/usr/bin/perl -w
#
# TribuneClient.
#
# TribuneClient is a perl script that allows you to browse boards on 
# daCode-powered websites in your term.
#
# $Id: tribune.pl,v 1.1.2.1 2001/12/31 16:17:22 netsabes Exp $
#

use LWP::UserAgent;
use HTTP::Request::Common;
use Getopt::Long;
use XML::Simple;

$version = "v1.2";
$debug = 0;
$httpServer = 'woof.lu';
$help = 0;

GetOptions('debug!' => \$debug, 'httpserver=s' => \$httpServer, 'help' => \$help, 'post=s' => \$post, 'get' => \$get, 'limit=i' =>
\$limit);

# Check if help wanted, if yes, print it out, and go away!
if($help) {
        print "TribuneClient v".$version." by Arnaud Willem <woof\@woof.lu>\n";
        print "Usage: ";
        print "tribune [--httpserver <httpserver>] [--debug] [--help]\n\n";
        print "--help\t\t\t\tThis help screen!\n";
        print "--debug\t\t\t\tTurns on debugging\n";
        print "--httpserver <httpserver>\tConnect to <httpserver> instead of the default one\n";
        print "--post <message>\t\tPosts <message> to the board.\n";
        print "--get\t\t\t\tGets the last messages from the board.\n";
        print "--limit <number>\t\tLimits to <number> the number of posts to retrieve\n\n";
        print "Default is --get\n";
        print "\n***This software is released under the GNU GPL LICENCE***\n";
        exit 0;
};

# Init all those weird things to fetch daCode stuff

$uaDacode = LWP::UserAgent->new;
$uaDacode->agent("TribuneClient/".$version." by woof -- woof\@woof.lu");

print "DEBUG: Set useragent, and loaded modules!\n" if $debug == 1;

# Get all that stuff

sub get {
        $itDacode = $uaDacode->request(GET 'http://'.$httpServer.'/board/remote.xml');

        print "DEBUG: Sucessfully built request!\n" if $debug == 1; 

        if($itDacode->is_success && $debug == 1) {
                print "\n".$httpServer." is sending me this: \n\n";
                print $itDacode->as_string;
        };

        @iDacode = split(/\n\n/,$itDacode->as_string);

        print "After splitting, i have: \n\n ------------- \n\n".$iDacode[1]."\n -------------------
        \n" if $debug == 1;

        $ref = XMLin($iDacode[1],  keyattr => "" );
         
        print "Site: ".$ref->{'site'}."\n";
          
        $pCount = @{$ref->{'post'}}-1;
        
        $i = $pCount;
        $i = $limit-1 if $limit;
        
        while(!($i < 0)) {
                print "Id: ".$ref->{'post'}[$i]->{'id'}." ";
                print "Time: ".$ref->{'post'}[$i]->{'time'}."\n";
                print "Content: ".$ref->{'post'}[$i]->{'message'}."\n";
                print "Info: ".$ref->{'post'}[$i]->{'info'}."\n------------\n";
                $i--;
        };
};

sub post {

        my $message = shift @_;

        $itDacode = $uaDacode->request(POST
        'http://'.$httpServer.'/board/add.php3', [message => $message]);
        
        print "DEBUG: Sucessfully bilt request.\n" if $debug == 1;
        print "DEBUG: Sucessfully (?) posted to the board!\n" if $debug == 1;
};

if($get || !$post) {

        get();
        
};
if($post) {

        post($post);

};
exit 0;
