/* $Id: c2c.h,v 1.30 2004/03/05 18:25:42 mad Exp $ */

/*
 * Copyright (c) 2003, Alexander Marx
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    - Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer. 
 *    - Redistributions in binary form must reproduce the above
 *      copyright notice, this list of conditions and the following
 *      disclaimer in the documentation and/or other materials provided
 *      with the distribution. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
 * ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 *
 * "This product includes software developed by Computing Services 
 *  at Carnegie Mellon University (http://www.cmu.edu/computing/)."
 *
 */


#ifndef __CYRUS2COURIER_H
#define	__CYRUS2COURIER_H

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include <fcntl.h>
#include <assert.h>
#include <dirent.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#if defined ( __APPLE__ ) || ( defined (__SVR4) && defined (__sun) ) || ( hpux ) || ( _AIX )
#include <unistd.h>
#else
#include <getopt.h>
#define HAVE_GETOPT_LONG
#endif
#if defined ( __TenDRA__)
#include <getopt.h>
#include <st_proto.h>
#define __FUNCTION__ __FILE__
#undef HAVE_GETOPT_LONG
#endif
# if defined ( __DECC )
#define __FUNCTION__ __func__
#endif

#include <time.h>

#include "str.h"
#include "cyrus.h"


/* ------------------------------------------------------------------------ */

#define C2C_EXIT_SUCCESS	0
#define C2C_EXIT_INFO		1
#define C2C_EXIT_WARN		5
#define	C2C_EXIT_FAIL		10

#define	C2C_DONE		(C2C_EXIT_SUCCESS)
#define	C2C_INFO		(C2C_EXIT_INFO)
#define	C2C_WARN		(C2C_EXIT_WARN)
#define	C2C_FAIL		(C2C_EXIT_FAIL)

#define MAXNAME 	256
#define MAXBUF		4096

#define CYRUS_FOLDERMAX	4096
#define CYRUS_SEENMAX	64000

#define COMMAND_PARAMETERS  "dVvq:x:hs:e:" 

#define	C2C_VERSION	"1.3"

#define C2C_SEENTYPE_FILES	1	/* Cyrus-Imap 1.x */
#define C2C_SEENTYPE_DB		2	/* Cyrus-Imap 2+ */



/* ------------------------------------------------------------------------ */

struct t_cyrus_seen {
	unsigned long left;
	unsigned long right;
};
struct t_seencache {
	unsigned long left;
	unsigned long right;
};

struct t_seenline {
	eSTR *id;
	eSTR *seen;
};

struct t_seenfile {
	int type;
	int len;
	struct t_seenline seen[CYRUS_FOLDERMAX+1];
	int cline;
	int clen;
	struct t_seencache cache[CYRUS_SEENMAX+1];
};


/* ------------------------------------------------------------------------ */

void usage(void);
void bail_out(int rc, char *where, char *msg, ...);
void verbose_print(int type, const char *where, const char *format, ...);

int traverse (char *root1, char *root2, char *path);
int cydump(char *path, char *dest, int is_root);
int courier_mkdir(char *root2, char *path, int rootfolder);
int courier_cpmail(char *src, unsigned long size, char *dst_a, 
	char *dst_b, unsigned long *rsize);
int courier_quota(char *root, char *dir, int is_root);
int courier_subscribe(char *root, char *dir, int is_root);

struct t_seenfile *read_seenfile(const char *_file, const int _type);
int isseen_seenfile(struct t_seenfile *_sf, unsigned long _uid);
int setfolder_seenfile(struct t_seenfile *_sf, const char *_mailbox, 
		const unsigned long _uidvalidity);
void flush_seenfile(struct t_seenfile *_sf);

int parse_seenfile(char *_seenfile, struct t_cyrus_seen *_seen);
int isSeen(unsigned long uid, struct t_cyrus_seen *_seen, int _len);
int verify_path(const char *path);

FILE *xfopen(const char *_p, const char *_m);


/* ------------------------------------------------------------------------ */

#endif
