/* Player.m - this file is part of Cynthiune
 *
 * Copyright (C) 2002-2004  Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <wolfgang@contre.com>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>

#define PLAYER_M 1
#import "Player.h"

static NSNotificationCenter *nc = nil;

NSString *PlayerPlayingNotification = @"PlayerPlayingNotification";
NSString *PlayerStoppedNotification = @"PlayerStoppedNotification";
NSString *PlayerPausedNotification = @"PlayerPausedNotification";
NSString *PlayerResumedNotification = @"PlayerResumedNotification";
NSString *PlayerSongEndedNotification = @"PlayerSongEndedNotification";

@implementation PlayerBase : NSObject

- (id) init
{
  if ((self = [super init]))
    {
      _delegate = nil;
      nc = [NSNotificationCenter defaultCenter];
    }

  return self;
}

- (id) delegate
{
  return _delegate;
}

- (void) setDelegate: (id) anObject
{
  if (_delegate)
    [nc removeObserver: _delegate name: nil object: self];

  _delegate = anObject;

  if ([_delegate respondsToSelector: @selector (playerPlaying:)])
    [nc addObserver: _delegate
	selector: @selector (playerPlaying:)
	name: PlayerPlayingNotification
	object: self];
  if ([_delegate respondsToSelector: @selector (playerStopped:)])
    [nc addObserver: _delegate
	selector: @selector (playerStopped:)
	name: PlayerStoppedNotification
	object: self];
  if ([_delegate respondsToSelector: @selector (playerPaused:)])
    [nc addObserver: _delegate
	selector: @selector (playerPaused:)
	name: PlayerPausedNotification
	object: self];
  if ([_delegate respondsToSelector: @selector (playerResumed:)])
    [nc addObserver: _delegate
	selector: @selector (playerResumed:)
	name: PlayerResumedNotification
	object: self];
  if ([_delegate respondsToSelector: @selector (playerSongEnded:)])
    [nc addObserver: _delegate
	selector: @selector (playerSongEnded:)
	name: PlayerSongEndedNotification
	object: self];
}

- (void) postSongEndedNotification
{
  [nc postNotificationName: PlayerSongEndedNotification object: self];
}

- (void) postPausedNotification
{
  [nc postNotificationName: PlayerPausedNotification object: self];
}

- (void) postResumedNotification
{
  [nc postNotificationName: PlayerResumedNotification object: self];
}

- (void) postPlayingNotification
{
  [nc postNotificationName: PlayerPlayingNotification object: self];
}

- (void) postStoppedNotification
{
  [nc postNotificationName: PlayerStoppedNotification object: self];
}

@end
