/* FormatTester.m - this file is part of Cynthiune
 *
 * Copyright (C) 2003, 2004  Wolfgang Sourdeau
 *
 * Author: Wolfgang Sourdeau <wolfgang@contre.com>
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>

#import "Format.h"
#import "FormatTester.h"

@implementation FormatTester : NSObject

+ (id) formatTester
{
  static FormatTester *singleton = nil;

  if (!singleton)
    singleton = [[self alloc] _init];

  return singleton;
}

- (FormatTester *) _init
{
  if ((self = [super init]))
    {
      formatList = [[NSMutableArray alloc] init];
      extensionsList = [[NSMutableArray alloc] init];
    }

  return self;
}

- (void) registerFormatClass: (Class) aClass
{
  if ([aClass conformsToProtocol: @protocol(Format)])
    {
      [formatList addObject: aClass];
      [extensionsList
        addObjectsFromArray: [aClass acceptedFileExtensions]];
    }
  else
    NSLog (@"Class '%@' not conform to 'Format' protocol...\n",
           NSStringFromClass (aClass));
}

- (NSArray *) acceptedFileExtensions
{
  return extensionsList;
}

- (int) fileType: (NSString *) filePath
{
  int fileType, count;

  fileType = -1;
  count = 0;

  while (fileType == -1
         && count < [formatList count])
    {
      Class streamClass = [formatList objectAtIndex: count];
      if ([streamClass streamTestOpen: filePath])
        fileType = count;
      else
        count++;
    }

  return fileType;
}

- (Class) classForFile: (NSString *) filePath
{
  Class streamClass, testClass;
  int count;

  streamClass = nil;
  count = 0;

  while (streamClass == nil
         && count < [formatList count])
    {
      testClass = [formatList objectAtIndex: count];

      if ([testClass streamTestOpen: filePath])
        streamClass = testClass;
      else
        count++;
    }

  return streamClass;
}

- (Class) classForFileType: (int) aFileType
{
  Class streamClass;

  if (aFileType > -1 && aFileType < [formatList count])
    streamClass = [formatList objectAtIndex: aFileType];
  else
    streamClass = nil;

  return streamClass;
}

@end
