/*
 * Copyright (C) 2003 Tommi Maekitalo
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * As a special exception, you may use this file as part of a free
 * software library without restriction. Specifically, if other files
 * instantiate templates or use macros or inline functions from this
 * file, or you compile this file and link it with other files to
 * produce an executable, this file does not by itself cause the
 * resulting executable to be covered by the GNU General Public
 * License. This exception does not however invalidate any other
 * reasons why the executable file might be covered by the GNU Library
 * General Public License.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef CXXTOOLS_HDSTREAM_H
#define CXXTOOLS_HDSTREAM_H

#include <iostream>

namespace cxxtools
{

class Hdstreambuf : public std::streambuf
{
    static const unsigned BUFFERSIZE = 16;
    
    std::streambuf::int_type overflow(std::streambuf::int_type ch);
    std::streambuf::int_type underflow();
    int sync();

    char Buffer[BUFFERSIZE];
    std::streambuf* Dest;
    unsigned offset;

  public:
    explicit Hdstreambuf(std::streambuf* dest)
      : Dest(dest),
        offset(0)
    {
      setp(Buffer, Buffer + BUFFERSIZE);
    }

    unsigned getOffset() const         { return offset; }
    void setOffset(unsigned offset_)   { offset = offset_; }
};

/**
 hexdumper as a outputstream.

 Data written to a hdostream are passed as a hexdump to the given sink.
 */
class Hdostream : public std::ostream
{
    typedef std::ostream base_class;
    Hdstreambuf streambuf;

  public:
    Hdostream()
      : base_class(0),
        streambuf(std::cout.rdbuf())
    {
      init(&streambuf);
    }
    explicit Hdostream(std::ostream& out)
      : base_class(0),
        streambuf(out.rdbuf())
    {
      init(&streambuf);
    }

    unsigned getOffset() const         { return streambuf.getOffset(); }
    void setOffset(unsigned offset_)   { streambuf.setOffset(offset_); }
};

}

#endif  // CXXTOOLS_HDSTREAM_H
