#!/usr/bin/ruby -w
# -*- ruby -*-

# A primitive "progress meter", for showing when something time-consuming is
# being done. If the global variable $verbose is set, then the tick() method
# displays the argument passed. If not set, the tick() method displays the
# spinning character with each tick.

class ProgressMeter

  def initialize(verbose)
    @progress = %w{ | \\ - / }
    @count = 0
    @verbose = verbose
  end
  
  def tick(what = "...")
    if @verbose
      # what.chomp! 
      # Log.log "processing #{what}"
    else
      print "\r"
      @count = (@count + 1) % 4
      print @progress[@count]
    end
  end

end
