#!/usr/bin/ruby -w
# -*- ruby -*-

if __FILE__ == $0
  # This is so this file can be loaded from another directory.
  dir = File.dirname($0)
  require dir + "/log"
end

# CVS requires that added directories and files be done in their own set. That
# is, it is invalid to give CVS the command "cvs add foo foo/bar.txt". That must
# be done as two separate commands.

class CVSEntry
  attr_accessor :added, :parent, :name, :setnumber, :incvs

  @@entries = Hash.new

  def CVSEntry.entries
    @@entries
  end
  
  def initialize(name)
    @name = name
    @incvs = File.exists?(name + "/CVS/Entries")
    @added = false

    @@entries[name] = self
    
    @parent = nil
    if (fd = File.dirname(name)) && fd != "."
      if @@entries.has_key?(fd)
        @parent = @@entries[fd]
      else
        @parent = CVSEntry.new(fd)
      end
    end
  end

  def to_s
    @name
  end

  # Adds to the given list, if it can. Returns whether successful.
  def add(addset)
    Log.log "(#{@name}, #{addset})"
    if @parent
      if @parent.incvs
        @setnumber = 0
      else
        unless @parent.added
          Log.log "adding parent"
          @parent.add(addset)
        end
        @setnumber = @parent.setnumber + 1
      end
    else
      Log.log "adding orphan to set 0"
      @setnumber = 0
    end
    addset.add(self, @setnumber)
    @added = true
  end
  
end

class CVSAddSet

  attr_reader :addlists

  def initialize(files)
    entries = files.collect { |f| CVSEntry.new(f) }

    @addlists = Array.new
    setnum = 0
    while entries.size > 0
      curlist = Array.new
      entries.each do |e|
        if e.add(self)
          entries.delete(e)
        end
      end
      setnum += 1      
    end
  end

  def add(entry, setnum)
    Log.log "(#{entry}, #{setnum})"
    unless al = @addlists[setnum]
      al = @addlists[setnum] = Array.new
    end
    al.push(entry) unless al.include?(entry)
  end

end


if __FILE__ == $0
  Log.verbose = true
  exec = CVSAddSet.new(%w{abc/zyz.bog
                          abc/def/foog.oqz
                          abc/def/foog.flt
                          ghi/jkl/mno/foo.txt
                          ghi/jkl/mno/pqr/fdfd.txt
                          ghi/jkl/mno/pqr/f111.txt
                          ghi/jkl/mno/pqr/f9df.txt
                          ghi/jkl/mno/pqr/lag3.txt
                          boo.txt
                          t/test_home_directory.rb
                          t/test_nonexistent.rb
                         })
end
