#
#   Copyright 2008 by Immanuel Halupczok
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

Theater={
  name="Theater"
  author="Immi"
  numexplode=6
  chaingrass=0
  pics[hard]=gelb,gruen,orange,rosa,rot,blau
  pics=gelb,gruen,orange,rosa,rot
  pics[easy]=gelb,gruen,orange,rosa
  bgcolor=50,0,0
  topcolor=45,0,0
  toppic=ithVorhang.xpm
  topoverlap=22
  topstop=15
  textcolor=150,0,0
  toptime=50
  startpic=sitz
  startdist="...****...",
            "**.****.**","**.****.**","**.****.**","**.****.**",
            "**.****.**","**.****.**","**.****.**","**.****.**",
            "**.****.**","**.****.**"
  startdist[easy]="...****...",
            "**.****.**","**.****.**","**.****.**","**.****.**",
            "**.****.**","**.****.**","**.****.**","**.****.**"
  greypic=dreck
  randomgreys[hard,1]=40
  randomgreys[1]=50
  randomgreys[easy,1]=-1
  nogreyprob=1
  description="Please keep quiet. Otherwise you will be blasted."
  
  <<
  var dy1 = 0, dy2 = 0, oddRow;

  global.row_up1 = { dy1+=1; };
  global.row_up2 = { dy2+=1; };
  global.row_down1 = { dy1-=1; };
  global.row_down2 = { dy2-=1; };

  calcEvenOdd = {
    if loc_p == 1 -> oddRow = (loc_y + dy1@) % 2
    else             oddRow = (loc_y + dy2@) % 2;
  };

  
  var fall_inhibit;
  
  semiglobal={
    # Hack, damit keine Explosionen stattfinden, whrend ein Blop
    # dabei ist, durch die Sitze zu fallen: fall_inhibit wird von
    # blobs auf eins gesetzt, wenn sie am fallen sind.
    # Und in der connect-Phase wird fall_inhibit ausgelesen
    fall_inhibit = 0;
  };

  malSitz={
    if oddRow -> {
      D*;
      A*@(0,-1);
      [qu=Q_TL] E@(1,0)*;
      [qu=Q_BL] E@(1,0)*;
      [qu=Q_BL] B*@(1,-1);
    } else -> {
      F*;
      C*@(0,-1);
      [qu=Q_TR] E@(-1,0)*;
      [qu=Q_BR] E@(-1,0)*;
      [qu=Q_BR] B*@(-1,-1);
    };
  };

  var sitzend = 0;
  var sitz_behaviour = goalblob+calculate_size+explodes_on_size: reapply;
  
  var guck=1:reapply;  # In welche Richtung gucken?
      # 1 = normal, 2 = li, 3 = re, 4 = vor, 5 = rueck
  var rede=0:reapply;  # Reden? Und: in welche Richtung?
  var pause=5:reapply; # Pause vor wieder in andere Richtung gucken
  var heimlich=0:reapply; # Heimlich auf einen Sitz gehen? Richtung?

  bla1L = {[qu=Q_TL_TR] *@(-1,0); [qu=Q_TR_TL] *};
  bla2L = {[qu=Q_BL_TR] *@(-1,0); [qu=Q_BR_TL] *};

  bla1R = {[qu=Q_TL_TR] *; [qu=Q_TR_TL] *@(1,0)};
  bla2R = {[qu=Q_BL_TR] *; [qu=Q_BR_TL] *@(1,0)};

  bla1V = {[qu=Q_TL_BL] *; [qu=Q_TR_BR] *};
  bla2V = {[qu=Q_BL_BL] *; [qu=Q_BR_BR] *};

  bla1H = {[qu=Q_TL_BL] *@(0,-1); [qu=Q_TR_BR] *@(0,-1)};
  bla2H = {[qu=Q_BL_BL] *@(0,-1); [qu=Q_BR_BR] *@(0,-1)};
  
  connKugel = {
    # Hack:
    # Wenn irgend jemand gesagt hat, dass er am weiterfallen ist,
    # dann keine Explosion machen
    #if kind@(0,1) == sitz ||
    #   kind@(0,-1) == sitz && kind@(0,-2) == kind
    if fall_inhibit@@()
          -> inhibit=DIR_U+DIR_D+DIR_L+DIR_R
    else  -> inhibit=0;
  };
  

  malSitzBenutzer = {
    # guck sollte der file-Wert sein mit den Bildern des Benutzers

    calcEvenOdd;
    
    # malen
    if sitzend -> {
      0; malSitz;
      file=guck;
      if oddRow -> {A*@(0,-1); C*;} else -> {B*@(0,-1); D*;};
    } else -> {
      file=guck;
      if oddRow -> E* else -> F*;
    };

  };

  fallAufNaechstenSitz = {
    # ggf. auf darunter liegenden Sitz weiterfallen

    # sitz_behaviour sollte der Wert meines Behaviour sein
    # wenn ich sitze

    if kind@(0,1) == sitz && loc_y < 19 -> {
      kind@(0,1) = kind;
      version@(0,1) = version;
      sitzend@(0,1) = 1;
      behaviour@(0,1) = sitz_behaviour;
      if sitzend -> {
        kind@(0,0) = sitz;
      } else -> kind@(0,0) = nothing;
      rede = 0;
      if kind != dreck -> fall_inhibit@@() = 1;
    };
  };

  landKugel = {
    # Beim landen sofort schauen, ob wir auf einen Sitz weiterfallen
    # koennen; das hat nicht nur den Vorteil, dass das Fallen so
    # fluessiger wird; es bewirkt ausserdem, dass schon beim landen
    # fall_inhibit gesetzt wird, so dass wir nicht im Lande-Moment
    # aus versehen eine Reaktion auslsen.
    fallAufNaechstenSitz;
  };
  

  malKugel = {
    if pause > 0 -> pause -= 1;
    if falling -> {
      6C*; pause=5;
    } else -> {
      switch {
        guck==2 -> {
          if kind@(-1,0) != kind ||
             1:20 && pause==0 && rede != 2 -> { guck=1; pause=10; }
        };
        guck==3 -> {
          if kind@(1,0) != kind ||
             1:20 && pause==0 && rede != 3 -> { guck=1; pause=10; }
        };
        guck==4 -> {
          if kind@(0,1) != kind ||
             1:20 && pause==0 && rede != 4 -> { guck=1; pause=10; }
        };
        guck==5 -> {
          if kind@(0,-1) != kind ||
             1:20 && pause==0 && rede != 5 -> { guck=1; pause=10; }
        };
        guck==1 && 1:4 -> {
          if kind@(-1,0) == kind && pause==0 -> {
            if 1:6 || guck@(-1,0) == 3 ->  { guck=2; pause=5; }
          };
        };
        guck==1 && 1:3 -> {
          if kind@(1,0) == kind && pause==0 -> {
            if 1:6 || guck@(1,0) == 2 ->  { guck=3; pause=5; }
          };
        };
        guck==1 && 1:2 -> {
          if kind@(0,1) == kind && pause==0 -> {
            if 1:6 || guck@(0,1) == 5 ->  { guck=4; pause=5; }
          };
        };
        guck==1 -> {
          if kind@(0,-1) == kind && pause==0 -> {
            if 1:6 || guck@(0,-1) == 4 ->  { guck=5; pause=5; }
          };
        };
      };

     # Variante A: Rede nicht, wenn die angesprochene Person
     # redet:
#      if rede == 0 && 1:20 -> {
#        if guck == 2 && rede@(-1,0) == 0  ||
#           guck == 3 && rede@(1,0) == 0  ||
#           guck == 4 && rede@(0,1) == 0  ||
#           guck == 5 && rede@(0,-1) == 0 ->
#          rede = guck;
#      };
      # Variante B: Rede nicht, wenn drumrum irgend jemand redet:
      if rede == 0 && 1:20 && guck != 1 &&
         rede@(-1,0) == 0 && rede@(1,0) == 0 &&
         rede@(0,1) == 0 && rede@(0,-1) == 0 ->
            rede = guck;

      if kind@(0,-1) == nothing && kind@(0,1) != kind &&
         kind@(-1,0) != kind && kind@(1,0) != kind -> {
        switch {
          heimlich == 0 && 1:120 ->
            if kind@(-1,0) == sitz && kind@(-1,1) != sitz ->
                       heimlich = 2;
          heimlich == 0 && 1:119 ->
            if kind@(1,0) == sitz && kind@(1,1) != sitz ->
                       heimlich = 3;
          heimlich == 2  ->
            if kind@(-1,0) != sitz || kind@(-1,1) == sitz ->
                       heimlich = 0;          
          heimlich == 3  ->
            if kind@(1,0) != sitz || kind@(1,1) == sitz ->
                       heimlich = 0;          
        };
        
        if heimlich != 0 -> {
          # Kein Doppelpfeil bei den ifs; die heimlich-Sequenz wird
          # sofort abgebrochen, wenn was dazwischen kommt
          guck = 1, guck = 1, guck = 1, guck = 1, guck = 1, guck = 1,
          guck = 5 - heimlich, guck = 5 - heimlich, guck = 5 - heimlich,
          guck = 5 - heimlich, guck = 5 - heimlich,
          guck = 1, guck = 1,
          guck = heimlich, guck = heimlich, guck = heimlich,
          guck = heimlich, guck = heimlich,
          guck = 1, guck = 1,
          guck = 5 - heimlich, guck = 5 - heimlich, guck = 5 - heimlich,
          guck = 5 - heimlich, guck = 5 - heimlich,
          guck = 1, guck = 1,
          guck = heimlich, guck = heimlich, {
            guck = heimlich;
            if heimlich == 2 -> {
              kind@(-1,0) = kind;
              sitzend@(-1,0) = 1;
              behaviour@(-1,0) = sitz_behaviour;
            } else -> {
              kind@(1,0) = kind;
              sitzend@(1,0) = 1;
              behaviour@(1,0) = sitz_behaviour;
            };
            kind@(0,0) = nothing;
          }
        };
        
      } else -> {
        heimlich = 0;
      };

      malSitzBenutzer;
      fallAufNaechstenSitz;

      6;
      if rede == 2 ->
        {A;bla1L},{A;bla1L},{A;bla2L},{A;bla2L},
        {B;bla1L},{B;bla1L},{B;bla2L},{B;bla2L;rede=0};
      if rede == 3 ->
        {A;bla1R},{A;bla1R},{A;bla2R},{A;bla2R},
        {B;bla1R},{B;bla1R},{B;bla2R},{B;bla2R;rede=0};
      if rede == 4 ->
        {A;bla1V},{A;bla1V},{A;bla2V},{A;bla2V},
        {B;bla1V},{B;bla1V},{B;bla2V},{B;bla2V;rede=0};
      if rede == 5 ->
        {A;bla1H},{A;bla1H},{A;bla2H},{A;bla2H},
        {B;bla1H},{B;bla1H},{B;bla2H},{B;bla2H;rede=0};
    };
  };
  
  
  >>
  gruen={
    pics=ithSitz.xpm,ithGruen.xpm,ithGruenL.xpm,ithGruenR.xpm,
                     ithGruenV.xpm,ithGruenH.xpm,ithGruenBlah.xpm
    << gruen=malKugel; gruen.connect=connKugel; gruen.land = landKugel; >>
  }
  gelb={
    pics=ithSitz.xpm,ithGelb.xpm,ithGelbL.xpm,ithGelbR.xpm,
                     ithGelbV.xpm,ithGelbH.xpm,ithGelbBlah.xpm
    << gelb=malKugel; gelb.connect=connKugel; gelb.land = landKugel; >>
  }
  orange={
    pics=ithSitz.xpm,ithOrange.xpm,ithOrangeL.xpm,ithOrangeR.xpm,
                     ithOrangeV.xpm,ithOrangeH.xpm,ithOrangeBlah.xpm
    << orange=malKugel; orange.connect=connKugel; orange.land = landKugel; >>
  }
  rosa={
    pics=ithSitz.xpm,ithRosa.xpm,ithRosaL.xpm,ithRosaR.xpm,
                     ithRosaV.xpm,ithRosaH.xpm,ithRosaBlah.xpm
    << rosa=malKugel; rosa.connect=connKugel; rosa.land = landKugel; >>
  }
  rot={
    pics=ithSitz.xpm,ithRot.xpm,ithRotL.xpm,ithRotR.xpm,
                     ithRotV.xpm,ithRotH.xpm,ithRotBlah.xpm
    << rot=malKugel; rot.connect=connKugel; rot.land = landKugel; >>
  }
  blau={
    pics=ithSitz.xpm,ithBlau.xpm,ithBlauL.xpm,ithBlauR.xpm,
                     ithBlauV.xpm,ithBlauH.xpm,ithBlauBlah.xpm
    << blau=malKugel; blau.connect=connKugel; blau.land = landKugel; >>
  }
  dreck={
    pics=ithSitz.xpm,ithDreckExpl.xpm,ithDreck1.xpm,ithDreck2.xpm,
         ithDreck3.xpm
    <<
    # *nicht* explode_on_explosion; das wird manuell gemacht, damit
    # die Explosion ggf. einen Sitz hinterlsst
    # Auch die nicht-sitzenden manuell, damit die Explosion gleich klein
    # aussieht, und damit sie keine weiteren Explosionen auf den Sitzen
    # veranlasst
    default behaviour = 0: reapply;
    default sitz_behaviour = goalblob: reapply;
    
    dreck.init={version = 2 + rnd(3);};
    
    dreck={
      if exploding@(1,0) == 1 ||
         exploding@(-1,0) == 1 ||
         exploding@(0,1) == 1 ||
         exploding@(0,-1) == 1 => {
        {malSitzBenutzer;1A*},
        {malSitzBenutzer;1B*},
        {malSitzBenutzer;1C*},
        {malSitzBenutzer;1D*},
        {0;if sitzend -> malSitz;1E*},
        {0;if sitzend -> malSitz;1F*},
        {0;if sitzend -> malSitz;1G*},
        {0;if sitzend -> malSitz;1H*;
           if sitzend -> kind=sitz else kind=nothing}
      } else -> {
        guck = version;
        malSitzBenutzer;
        fallAufNaechstenSitz;
      };
    };
    >>
  }
  sitz={
    pics="ithSitz.xpm"
    <<
    default behaviour = goalblob: reapply;
    sitz={
      calcEvenOdd;
      0;malSitz;
    };
    >>
  }
}
