/***************************************************************************
                          variable.cpp  -  description
                             -------------------
    begin                : Thu Jul 20 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "variable.h"
#include "definition.h"
#include "blop.h"
#include "cuyointl.h"


/** Erzeugt eine Mll-Variable. Wird verwendet, wenn es einen Fehler
    gab (blicherweise Variable nicht definiert). Die Mll-Variable
    versucht, Folgefehler zu vermeiden, so dass wenigstens noch fertig
    geparst werden kann. */
Variable::Variable():
  mDeklaration(0)
{
}


Variable::Variable(//__String datna, int znr, 
                   VarDefinition * d,
                   int dx, int dy /*= 0*/):
  //mDateiName(datna), mZeilenNr(znr),
  mDeklaration(d), mDX(dx), mDY(dy) {
  
}



__String Variable::toString() const {
  __String ret;
  if (mDX == variable_global) {
    ret.sprintf("%s@", getName().data());
  } else if (mDX == variable_lokal) {
    ret.sprintf("%s", getName().data());
  } else {
    ret.sprintf("%s@(%d,%d)", getName().data(), mDX, mDY);
  }
  return ret;
/*  __String ret2;
  ret2.sprintf("%s (%s:%d)", ret.data(), mDateiName.data(), mZeilenNr);
  return ret2;*/
}





/** Liefert die absoluten Koordinaten, so wie sie intern gebraucht
    werden (also ggf. gespiegelt und Hex-bereinigt). (y wird von
    getDX() zwar nicht gebraucht, aber so sieht's schner aus.) */
int Variable::getX(int x, int /*y*/) const {
  return x + mDX;
}

int Variable::getY(int x, int y) const {
  /* Hier findet das Spiegeln der relativen Variablenkoordinaten
     fr den Himmel-Level statt. (User will y nach unten eingeben;
     intern ist im Himmel-Level aber y nach oben.) */
  y += (ld->mSpiegeln ? -mDY : mDY);

  /* Und jetzt ggf. die Anpassung an die Hex-Koordinaten.
     Intern sind die relativen Koordinaten bei ungeradem dx so gespeichert,
     dass dy = 0 leicht schrg nach oben bedeutet. D. h. Fr die graden
     Spalten stimmts, fr die ungeraden muss noch verschoben werden.
  */
  if (ld->mSechseck) {
    if ((x & 1) && (mDX & 1))  // Oder: x & mDX & 1...
      y--;
  }

  return y;
}




int Variable::getNummer() const {
  if (!mDeklaration)
    return 0;
  return mDeklaration->mNummer;
}


int Variable::getOrt() const {
  if (mDX == variable_global || mDX == variable_lokal)
    return mDX;
  else
    return variable_relativ;
}


bool Variable::istKonstante() const {
  if (!mDeklaration) {
    /* Mllvariable sollten sich lieber fr Variablen als fr Konstanten
       halten. Das fhrt zu weniger Folgefehlern. */
    return false;
  }
  return mDeklaration->mArt == vd_konstante;
}


int Variable::getDefaultWert() const {
  if (!mDeklaration)
    return 0;
  return mDeklaration->mDefault;
}

__String Variable::getName() const {
  if (!mDeklaration)
    return _("<unknown>");
  return mDeklaration->mName;
}

