/***************************************************************************
                          leveldaten.cpp  -  description
                             -------------------
    begin                : Fri Jul 21 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <cstdlib>

#include <qbitmap.h>
#include <qpainter.h>

#include "leveldaten.h"
#include "cuyointl.h"
#include "fehler.h"
#include "pfaditerator.h"
#include "datendatei.h"
#include "knoten.h"
#include "prefsdaten.h"
#include "global.h"

#include "code.h"
#include "blop.h"



#define toptime_default 50



/* Globale Variable mit den Level-Daten */

LevelDaten * ld;

/** */
LevelDaten::LevelDaten(): mLevelConf(new DatenDatei()),
  mGeladen(false),
/* Wir basteln uns ein Array, dessen Indizierung nicht mit 0 beginnt...: */
  mSorten(mSortenIntern - blopart_min_sorte)
/* Uninitialisierte Blops entstehen sehr frh, und die haben auch schon
   einen Bildstapel. Und der greift auf mStapelHoehe() zu. */
 // mStapelHoehe(0)
{
  ld = this;
  mIntLevelNamen.setAutoDelete(true);
  ladLevelConf();
  
  /* Man knnte hier noch ladKeinenLevel() ausfhren wollen. Ist aber
     nicht ntig, da das in cuyo an der richtigen Stelle getan wird. */
}


/** */
LevelDaten::~LevelDaten() {
  delete mLevelConf;
}



void LevelDaten::ladLevelConf() {

  /* Jetzt ist erst mal nix mehr geladen. Erst wenn ladLevelConf()
     durchgelaufen ist, ist wieder was da. */
  mGeladen = false;
  
  /* Falls schon mal was geladen wurde: Erst mal alles
     wieder rausschmeien. */
  mLevelConf->leeren();

  /* Whrend laden() wird mIntLevelNamen ausgefllt. Falls da vorher
     noch Mll drin war, lschen wir das. (Ist hier eigentlich
     unntig; sieht aber sauberer aus. */
  mIntLevelNamen.clear();

  /* Hier findet das parsen statt. */
  mLevelConf->laden(LEVELDESCR);



  /* Hat der Benutzer noch eine eigene Leveldatei angegeben?
     Dann wird die jetzt auch noch geladen. */
  if (gDateiUebergeben) {
    
    if (!QFile(gLevelDatei).exists())
      throw Fehler(_("File \"%s\" does not exist."), gLevelDatei.data());
    
    /* Wenn der Benutzer eine Datei angegeben hat, sollen nur die Level
       aus seiner Datei Level werden. Also die bisherige Level-Liste
       wieder lschen. */
    mIntLevelNamen.clear();
    
    /* Und wir nehmen die bisher definierten Level aus dem Knoten-Baum
       wieder raus, damit wir keine doppelt definierten Level bekommen,
       wenn der Benutzer den Namen eines Levels bergeben hat, der schon
       von main.ld included wird. (loeschAlleLevel() lsst den Level
       Namens "Title" drin...) */
    mLevelConf->initSquirrel();
    mLevelConf->getSquirrelPos()->loeschAlleLevel();
    
    
    /* Hier findet schon wieder parsen statt. */
    mLevelConf->laden(gLevelDatei);

  } else {
  
    /* Benutzer hat keine eigene Datei angegeben. Dann holen wir
       uns doch die Level-Liste aus "level=..." */
    mLevelConf->setEinSpielerVersion(false);
    verlangeSchluessel("level");
    ListenKnoten * lena = mLevelConf->getListenEintrag("level");
    int l = lena->getLaenge();
    mIntLevelNamen.resize(l);
    for (int i = 0; i < l; i++)
      mIntLevelNamen.insert(i, new __String(lena->getWort(i)));
  }

  /* OK, Laden war erfolgreich. */
  mGeladen = true;
}




/** Wird whrend des Parsens (d. h. innerhalb von ladLevelConf() von
    DefKnoten aufgerufen, wenn ein neuer Level gefunden wurde. Daraus
    kann eine Level-Liste gebastelt werden, wenn "level=..." nicht
    verwendet werden soll. */
void LevelDaten::levelGefunden(__String lna) {
  int l = mIntLevelNamen.size();
  mIntLevelNamen.resize(l + 1);
  mIntLevelNamen.insert(l, new __String(lna));
}




/** fllt alle Daten in diesem Objekt fr Level nr aus; throwt bei Fehler */
void LevelDaten::ladLevel(int nr, int spz) {

  if (!mGeladen)
    throw Fehler(_("Sorry, no working level description file available."));

  /* In den obersten Abschnitt der level descr springen. Wir knnten uns
     woanders befinden, wenn es irgend wann mal einen Fehler gegeben hatte. */
  mLevelConf->initSquirrel();

  /* Nur fr den Fall eines frhen throws... */
  mLevelName = "";
  
  /** Fr bessere Fehlerausgaben. */
  __String fehlerpos = "";

  try {
  
    mIntLevelName = getIntLevelName(nr);

    /* In den Abschnitt dieses Levels springen. (Springt automatisch
       bei } wieder raus. */
    DatenDateiPush ddp(*mLevelConf, mIntLevelName);

    fehlerpos = mLevelConf->getSquirrelPos()->getDefString() +
                _(" (or somewhere below): ");
    
    /* Spielerzahlabhngige Unterschiede bercksichtigen */
    mSpielerZahl = spz;
    mLevelConf->setEinSpielerVersion(spz == 1);

    /* DefKnoten des Levels abspeichern. */
    mLevelKnoten = mLevelConf->getSquirrelPos();

    /* Level-Name */
    verlangeSchluessel("name");
    mLevelName = mLevelConf->getEintrag("name");

    /* Level-Autor */
    verlangeSchluessel("author");
    mLevelAutor = mLevelConf->getEintrag("author");

    /* Beschreibungstext (optional) */
    mBeschreibung = mLevelConf->getEintrag("description", "");

    /* Wie viele Steine mssen zusammen, damit sie platzen? */
    verlangeSchluessel("numexplode");
    mPlatzAnzahl = mLevelConf->getZahlEintrag("numexplode");
    if (mPlatzAnzahl < 1)
      throw Fehler(_("numexplode < 1"));

    /* Hintergrundfarbe... (optional; Default: wei)
       Achtung: Die Hintergrundfarbe muss gesetzt werden, _bevor_
       Bildchen geladen werden, da es als Bonus-Farbe im XPM
       "Background" gibt... (im Moment nur fr Explosion sinnvoll) */
    mHintergrundFarbe = mLevelConf->getFarbEintrag("bgcolor", __white);

    /* Hintergrundbilchen (optional) */
    mMitHintergrundbildchen = mLevelConf->hatEintrag("bgpic");
    if (mMitHintergrundbildchen)
      mHintergrundBild.laden(mLevelConf->getEintrag("bgpic"));

    /* Schriftfarbe... (optional; Default: dunkelgrau) */
    setSchriftFarbe(mLevelConf->getFarbEintrag("textcolor",
                                               QColor(40, 40, 40)));

    /* Hetzrandfarbe... (optional; Default: hellgrau) */
    hetzrandFarbe = mLevelConf->getFarbEintrag("topcolor", __lightGray);

    /* Hetzrandgeschwindigkeit (optional) */
    hetzrandZeit = mLevelConf->getZahlEintrag("toptime", toptime_default);
    if (hetzrandZeit < 1)
      throw Fehler(_("toptime < 1"));

    /* Hetzrandbildchen (optional) */
    mMitHetzbildchen = mLevelConf->hatEintrag("toppic");
    if (mMitHetzbildchen) {
      mHetzBild.laden(mLevelConf->getEintrag("toppic"));
  	
      /* Hetzrandberlapp (optional) */
      mHetzrandUeberlapp =
	mLevelConf->getZahlEintrag("topoverlap", mHetzBild.getHoehe());
    } else
      mHetzrandUeberlapp = 0;

    /* Gras nur bei Kettenreaktion? (optional) */
    mGrasBeiKettenreaktion = mLevelConf->getZahlEintrag("chaingrass", 0);

    /* Senkrecht spiegeln? (optional) */
    mSpiegeln = mLevelConf->getZahlEintrag("mirror");

    /* Andere Nachbarschaft? (optional) */
    mNachbarschaft =
      mLevelConf->getZahlEintrag("neighbours", nachbarschaft_normal);
    if (mNachbarschaft < 0 || mNachbarschaft > nachbarschaft_letzte)
      throw Fehler(_("neighbours out of range"));
    /* Sechseck-Raster? */
    mSechseck =
      mNachbarschaft == nachbarschaft_6 ||
      mNachbarschaft == nachbarschaft_6_schraeg ||
      mNachbarschaft == nachbarschaft_6_3d;


    /* Zufllige Graue? (optional) */
    mZufallsGraue =
      mLevelConf->getZahlEintrag("randomgreys", zufallsgraue_keine);
  	  	
    /* Wo sind welche Grasbildchen am Anfang? */
    verlangeSchluessel("startdist");
    mAnfangsZeilen = mLevelConf->getListenEintrag("startdist");

    /* Wie viele Farben gibts in diesem Level? Und wie heien die Bildchen? */
    ListenKnoten * picsnamen;
    verlangeSchluessel("pics");
    picsnamen = mLevelConf->getListenEintrag("pics");
    mAnzFarben = picsnamen->getLaenge();
    if (mAnzFarben < 1)
      throw Fehler(_("#pics < 1"));
  	
    if (mAnzFarben > max_farben_zahl) {
      __String s;
      s.sprintf(_("#pics > %d"), max_farben_zahl);
      throw Fehler(s);
    }


    /***** Noch ein paar einzelne Bilder laden *****/
    
    /* Explosion laden. Das darf erst nach dem Laden der Hintergrundfarbe
       passierren. */
    mExplosionBild.laden("explosion.xpm");

    /* Ziffern (fr Punkte und fr Debug-Ausgabe) laden. Punkte-Ziffern
       drfen erst geladen werden, nachdem die Schriftfarben geladen wurden. */
    mPktZiffernBild[0].laden("pktZiffern.xpm");
    mPktZiffernBild[1].laden("pktZiffern2.xpm");
    mDbgZiffernBild.laden("dbgZiffern.xpm");

    

    /***** Blops laden *****/

    /* Wie viele Bilder malt ein Blop in einem Schritt hchstens?
       Erst mal keine. Die Sorten erhhen diese Variablne selbst, wenn
       man sie ldt. */
    mStapelHoehe = 0;
    mNachbarStapelHoehe = 0;

    /* Farb-Bilder laden */
    for (int bnr = 0; bnr < mAnzFarben; bnr++)
      mSorten[bnr].laden(picsnamen->getWort(bnr), blopart_farbe);

    /* Grau-Bildchen laden */
    /* Achtung: "greypic" steht auch in knoten.cpp */
    verlangeSchluessel("greypic");
    mSorten[blopart_grau].laden(mLevelConf->getEintrag("greypic"),
                                blopart_grau);

    /* Grasbildchen laden */
    /* Achtung: "startpic" steht auch in knoten.cpp */
    verlangeSchluessel("startpic");
    mSorten[blopart_gras].laden(mLevelConf->getEintrag("startpic"),
                                blopart_gras);

    /* Leer-Bildchen (optional) */
    mMitLeerBildchen = mLevelConf->hatEintrag("emptypic");
    /* Auch, wenn es kein Leer-Bildchen gibt, soll es geladen werden;
       dann liefert getEintrag() "" zurck, und Sorte::laden() wei,
       dass es nur alle Werte auf Defaults setzen soll.
       Letztes true: Per default mit Rand verbinden */
    mSorten[blopart_keins].laden(mLevelConf->getEintrag("emptypic"),
                                 blopart_keins);

    /* Globaler Code (optional) */
    mSorten[blopart_global].laden("global", blopart_global);
    
    
    /* Ok, alle Sorten geladen. Wenn wir noch mNachbarStapelhoehe zu
       mStapelHoehe addieren, stimmt diese Variable.
       Ab jetzt drfen also Blops erzeugt werden
       (wenn man mchte). */
   //fprintf(stderr, "mStapelHoehe = %d, nsh = %d\n", mStapelHoehe, mNachbarStapelHoehe);    
   mStapelHoehe += mNachbarStapelHoehe;


  /***** KI-Player-Bewertungen *****/
    mKINHoehe =
      mLevelConf->getZahlEintrag("aiu_height", 10);
    mKINAnFarbe =
      mLevelConf->getZahlEintrag("aiu_color", 10 * mAnzFarben);
    mKINAnGras =
      mLevelConf->getZahlEintrag("aiu_grass", 20);
    mKINAnGrau =
      mLevelConf->getZahlEintrag("aiu_grey", 10);
    mKINZweiUeber =
      mLevelConf->getZahlEintrag("aiu_two_above", mKINAnFarbe / 2);
    mKINEinfarbigSenkrecht =
      mLevelConf->getZahlEintrag("aiu_monochromic_vertical", mKINAnFarbe);

  } catch (Fehler f) {
    __String fs = fehlerpos;
    /*if (!mLevelConf->getSquirrelPosString().isEmpty())
      fs += ", Section " + mLevelConf->getSquirrelPosString();
    fs += ":\n" + f.getText() + "\n";*/
    fs += f.getText() + "\n";
    
    if (!mLevelName.isEmpty())
      fs += _("(Level \"") + mLevelName + _("\")\n");
    throw Fehler(fs);
  }
	
} // ladLevel





/** Fllt das von den Daten aus, was auch ohne Level notwendig ist
    (Punkte-Icons, Schriftfarbe) */
void LevelDaten::ladKeinenLevel() {
  setSchriftFarbe(QColor(90, 40, 170));
  mPktZiffernBild[0].laden("pktZiffern.xpm");
  mPktZiffernBild[1].laden("pktZiffern2.xpm");
}




/** Throwt, wenn der angegebene Schlssel in level descr nicht existiert. */
void LevelDaten::verlangeSchluessel(const char * s) const {
  if (!mLevelConf->hatEintrag(s)) {
    __String t;
    t.sprintf(_("Key \"%s\" is missing"), s);
    throw Fehler(t);
  }
}



/** Sollte am Anfang des Levels aufgerufen werden; kmmert sich
    um den Global-Blop */
void LevelDaten::startLevel() const {
  Blop::gGlobalBlop = Blop(blopart_global);
  Blop::gGlobalBlop.setBesitzer(); // Damit Code ausgefhrt werden darf
}


/** Sollte einmal pro Spielschritt aufgerufen werden (bevor
    Spielfeld::spielSchritt() aufgerufen wird). Kmmert sich 
    um den Global-Blop */
void LevelDaten::spielSchritt() const {
  Blop::beginGleichzeitig();
  Blop::gGlobalBlop.animiere();
  Blop::endGleichzeitig();
}


/** Hilfsfunktion fr getLevelAnz und getIntLevelName. Sucht nach dem
    ersten "." in na. */
int getPunktPos(__String na) {
  for (int i = 0; i < (int) na.length(); i++)
    if (na[i] == '.') return i;
  return -1;
}


/** Liefert zurck, wie viele Level es gibt. */
int LevelDaten::getLevelAnz() const {
  if (!mLevelConf)
    throw Fehler(_("Sorry, no working level description file available."));
  
  if (gPrefs->getUnfertigeLevel())
    return mIntLevelNamen.size();
  else {
    int ret = 0;
    for (int i = 0; i < (int) mIntLevelNamen.size(); i++)
      if (getPunktPos(*mIntLevelNamen.at(i)) == -1)
        ret++;
    return ret;
  }
}


/** Liefert den internen Namen von Level nr zurck. */
__String LevelDaten::getIntLevelName(int nr) const {
  if (nr == level_titel)
    return __String("Title");

  int pos;

  if (gPrefs->getUnfertigeLevel())
    pos = nr - 1;
  else {
    pos = 0;
    int n = 0;
    while (n < nr) {
      if (getPunktPos(*mIntLevelNamen.at(pos)) == -1)
        n++;
      pos++;
    }
    pos--;
  
  }
  
  __String s = *mIntLevelNamen.at(pos);
  int pp = getPunktPos(s);
  if (pp == -1)
    return s;
  else
    return s.left(pp);
  
}

/** Liefert den Namen von Level nr zurck. Liefert "???" bei Fehler. */
__String LevelDaten::getLevelName(int nr) const {
  try {
    DatenDateiPush ddp(*mLevelConf, getIntLevelName(nr));

    verlangeSchluessel("name");
    return mLevelConf->getEintrag("name");

  } catch (Fehler f) {
    return "???";
  }
}


/** Liefert die Nummer des Levels mit dem angegebenen Namen zurck,
    oder 0, wenn der Level nicht existiert. */
int LevelDaten::getLevelNr(__String na) const {
  /** Alles noch seeehr ineffektiv... */
  int anz = getLevelAnz();
  for (int i = 1; i <= anz; i++)
    if (na == getIntLevelName(i))
      return i;
  return 0;
}



 /** Setzt mSchriftFarbe[...]. Berechnet also insbesondere die dunkle
     und die helle Farbe. */
void LevelDaten::setSchriftFarbe(QColor f) {
  /* Zum Abdunkeln und Aufhellen gibt's QColor::dark() und ::light().
     light() tut aber nicht das, was man mchte (sondern das Gegenteil
     von dark()). */
  mSchriftFarbe[schrift_dunkel] =
     QColor(f.red() / 2, f.green() / 2, f.blue() / 2);
  mSchriftFarbe[schrift_normal] = f;
  mSchriftFarbe[schrift_hell] =
     QColor(128 + f.red() / 2, 128 + f.green() / 2, 128 + f.blue() / 2);
}
