/***************************************************************************
                          cuyo.cpp  -  description
                             -------------------
    begin                : Mit Jul 12 22:54:51 MEST 2000
    copyright            : (C) 2000 by Immi
    email                : cuyo@pcpool.mathematik.uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/* 1 bedeutet, dass manche Signale abgefangen werden, um die Log-Datei
   abzuspeichern. */
#define signale_fangen 1



#include <cstdlib>
#include <cstdio>

#if signale_fangen
#include <csignal>
#endif

#include <qapplication.h>
#include <qaccel.h>


#include "cuyointl.h"
#include "aufnahme.h"
#include "prefsdaten.h"
#include "kiplayer.h"
#include "spielfeld.h"
#include "fehler.h"
#include "punktefeld.h"
#include "global.h"

#include "cuyo.h"

#define MENU_new_game 100
#define MENU_restart_level 101
#define MENU_start_at 102
#define MENU_pause_game 104
#define MENU_stop_game 105
#define MENU_preferences 110
#define MENU_quit 120

#define MENU_1_player 131
#define MENU_2_player 132
#define MENU_KI_player 133

/* # Zeitschritte, die nach der Zeitbonus-Animation noch gewartet wird */
#define nachbonus_wartezeit 50


/*** Defines fr Fenster-Layout ***/
/* Hhe von dem Bereich ber den Spielfeldern mit der Punkteanzeige */
#define L_oben_hoehe 32
/* Rand zwischen den verschiedenen Objekten */
#define L_rand 4
/* Fensterbreite */
#define L_fenster_breite (L_rand + (grx * gric + L_rand) * max_spielerzahl)



#if signale_fangen

void signalHandler(int s) {
  try {
    Aufnahme::speichern(getLogName());
    /* send_log_string ist in fehler.h definiert. */
    fprintf(stderr, "%s\n", send_log_string);
  } catch (Fehler) {}
  
  /* Braucht man das? Geht das? */
  raise(s);
}


void signaleAn() {
  /*{
    struct sigaction act; 
    act.sa_handler = speicherFehler;
    act.sa_mask = 0;
    act.sa_flags = SA_ONESHOT;
    sigaction(SIGSEGV, &act, 0);
  }*/
  signal(SIGILL, signalHandler);  // illegal instruction
  signal(SIGSEGV, signalHandler); // segmentation fault
  signal(SIGFPE, signalHandler);  // floating point exception
}

void signaleAus() {
  signal(SIGILL, SIG_DFL);  // illegal instruction
  signal(SIGSEGV, SIG_DFL); // segmentation fault
  signal(SIGFPE, SIG_DFL);  // floating point exception
}

#else
void signaleAn() {
}

void signaleAus() {
}
#endif



Cuyo * Cuyo::gCuyo;



Cuyo::Cuyo(QWidget*parent,const char* name):
  QWidget(parent,name),
  mEinzelschritt(false),
  mZeitlupe(false), mZaehlerZeitlupe(0), mRueberReihenTest(0),
  mAbspielen(0), mSchnellvorlauf(0),
  mPauseBild(0), mTimer(0)
{
  /** Uns selbst in die globale Variable speichern. */
  gCuyo = this;
  
  /* Preferences-Objekt erzeugen. Hier wird die .cuyo-Datei gelesen.
     PrefsDaten speichert sich selbst in die globale Variable gPrefs. */
  new PrefsDaten();

  /* Hier findet das parsen statt. (Fehler werden im try-catch-Block
     der main()-Routine ausgegeben.) Das LevelDaten-Objekt weist
     sich selber der globalen Variable ld zu. */
  new LevelDaten();
  
  
  /* Fenstergre schon mal provisorisch einstellen, damit die Menleiste
     die richtige Breite kriegt */
  resize(L_fenster_breite, gry*gric + 2 * L_rand + L_oben_hoehe);
  
  /* Menleiste erzeugen */
  MenuErz();
	

  /* Fenstergre richtig einstellen */
  int L_oben = L_rand + mMenuBar->height();
  int L_fenster_hoehe = gry*gric + L_oben + 2 * L_rand + L_oben_hoehe;
  resize(L_fenster_breite, L_fenster_hoehe);
  setMinimumSize(L_fenster_breite, L_fenster_hoehe);
  setMaximumSize(L_fenster_breite, L_fenster_hoehe);
	
  /* Fenster mit diversem Zeug fllen... */

  /* Punktelabel. Hoffentlich kommen die nicht auf die Idee, sich
     jetzt gleich zu malen. Das geht nmlich erst, wenn wir
     ld->ladKeinenLevel() aufgerufen haben. Und das wiederum geht
     erst nach dem Laden des Titelbilds. */
  for (int i = 0; i < max_spielerzahl; i++) {
    mPunkteFeld[i] = new Punktefeld(this);
    mPunkteFeld[i]->resize(grx * gric, L_oben_hoehe);
  }

  mPunkteFeld[0]->move(L_rand, L_oben);
  mPunkteFeld[1]->move(L_fenster_breite - L_rand - grx * gric, L_oben);
	

  for (int i = 0; i < max_spielerzahl; i++) {
    /* Spielfeld erzeugen */
    mSpielfeld[i] = new Spielfeld(i > 0, this); // (i > 0) = rechter Spieler
    mSpielfeld[i]->move(L_rand + (grx*gric+L_rand)*i,
			L_oben + L_rand + L_oben_hoehe );

    /* Titelbild erzeugen */
    try {
      ld->ladLevel(level_titel, i + 1);
      mSpielfeld[i]->erzeugTitelbild();
    } catch (Fehler f) {
      fprintf(stderr, _("Could not load Title:\n"));
      fprintf(stderr, "%s\n", f.getText().data());
    }
  } // for i

  /* Punkte-Icons laden und Schriftfarbe setzen. */
  ld->ladKeinenLevel();

  /* Pause-Bild laden */
  try {
    mPauseBild = new Bilddatei();
    mPauseBild->laden("pause.xpm");
  } catch (Fehler f) {
    fprintf(stderr, _("Could not load pause.xpm:\n"));
    fprintf(stderr, "%s\n", f.getText().data());
    mPauseBild = 0;
  }

  /* Signals verbinden ... */
  for (int i = 0; i < max_spielerzahl; i++) {
    __String s;
    /** VERSION wird in config.h definiert */
    s.sprintf(_("By Immi\nVersion %s\n%s\nPlayer %d\n\n"),
	      VERSION,
	      gDebug ? _("Debug-mode (h = help)\n") : "",
	      i + 1);
    mSpielfeld[i]->setText(s);

    connect(mSpielfeld[i], SIGNAL(sigTot()),
	    SLOT(spielerTot()));
 	
    connect(mSpielfeld[i], SIGNAL(sigBekommPunkte(bool, int)),
	    SLOT(neuePunkte(bool, int)));
    for (int j = 0; j < max_spielerzahl; j++)
      if (i != j) {
	connect(mSpielfeld[i], SIGNAL(sigSendeGraue(int)),
		mSpielfeld[j], SLOT(empfangeGraue(int)));
	connect(mSpielfeld[i], SIGNAL(sigWillReihe(int, int &)),
		mSpielfeld[j], SLOT(gebReihe(int, int &)));
	connect(mSpielfeld[i], SIGNAL(sigWillStein(Blop &)),
		mSpielfeld[j], SLOT(gebStein(Blop &)));
      }
    setPunkte(i, 0);
  }
	
  /* KI-Spieler erzeugen */
  mKI = new KIPlayer(mSpielfeld[1]);

  setSpielerZahl(1); // Sollte erst nach Erzeugen der Mens aufgerufen werden...

  /* Damit Weiterspielen grad nicht geht. */
  mLevelNr = 0;
		
  setGModus(gmodus_kein_spiel);
	
  mWarteAufTaste = false;
}

Cuyo::~Cuyo(){
  delete ld;
  delete mKI;
  delete gPrefs;
}

/**  */
void Cuyo::MenuErz(){
  mSpielMenu = new QPopupMenu;
  mSpielMenu->insertItem(_("&New Game"), MENU_new_game);
  mSpielMenu->insertItem(_("&Restart last level"), MENU_restart_level);
  mSpielMenu->insertItem(_("Start &at level..."), MENU_start_at);
  mSpielMenu->insertItem(_("&Pause Game"), MENU_pause_game);
  mSpielMenu->insertItem(_("&Stop Game"), MENU_stop_game);
  mSpielMenu->insertSeparator();
  mSpielMenu->insertItem(_("&1 Player"), MENU_1_player);
  mSpielMenu->insertItem(_("&2 Player"), MENU_2_player);
  mSpielMenu->insertItem(_("Player vs. &Computer"), MENU_KI_player);
  mSpielMenu->insertSeparator();
  mSpielMenu->insertItem(_("Pre&ferences..."), MENU_preferences);
  mSpielMenu->insertSeparator();
  mSpielMenu->insertItem(_("&Quit"), MENU_quit);

  /*
    #ifndef HAVE_KDE2
    QPopupMenu *hilfeMenu;
    __String aboutstring;
    aboutstring.sprintf(_("This is cuyo %s\nWritten by Immi\n"), VERSION);
    hilfeMenu = kapp->getHelpMenu(true, aboutstring);
    #endif
  */

  mMenuBar = new QMenuBar(this);
  mMenuBar->insertItem(_("&Game"), mSpielMenu);
  /*
    #ifndef HAVE_KDE2
    mMenuBar->insertSeparator();	
    mMenuBar->insertItem(_("&Help"), hilfeMenu);
    #endif
  */
		
  mMenuBar->setAccel(CTRL+Key_N, MENU_new_game);
  mMenuBar->setAccel(CTRL+Key_R, MENU_restart_level);
  mMenuBar->setAccel(CTRL+Key_A, MENU_start_at);
  mMenuBar->setAccel(CTRL+Key_P, MENU_pause_game);
  mMenuBar->setAccel(Key_Escape, MENU_stop_game);
  mMenuBar->setAccel(CTRL+Key_1, MENU_1_player);
  mMenuBar->setAccel(CTRL+Key_2, MENU_2_player);
  mMenuBar->setAccel(CTRL+Key_C, MENU_KI_player);
  mMenuBar->setAccel(CTRL+Key_F, MENU_preferences);
  mMenuBar->setAccel(CTRL+Key_Q, MENU_quit);
	
  mMenuBar->show();

  connect( mMenuBar, SIGNAL(activated(int)),
	   SLOT(MenuAufruf(int)) );
}

/** Fhrt alle Men-Befehle aus */
void Cuyo::MenuAufruf(int id) {
  switch (id) {
  case MENU_new_game:
    mLevelNr = 1;
    startSpiel();
    break;
			
  case MENU_restart_level:
    CASSERT(mLevelNr != 0);
    startSpiel();
    break;
			
  case MENU_start_at: {
    if (gPrefs->startAtDialog(this, mSpielerZahl > 1, mLevelNr))
      startSpiel();
    break;
  }

  case MENU_pause_game: {
    CASSERT(mGModus == gmodus_spiel);

    setGModus(gmodus_pause);
    for (int i = 0; i < mSpielerZahl; i++)
      mSpielfeld[i]->setText(_("Game paused\n\nSpace = Resume\n\n"));
    mWarteAufTaste = true;
    mWarteTimeout = 0;
    break;
  }
		
  case MENU_stop_game: {
    stopSpiel();
    for (int i = 0; i < max_spielerzahl; i++)
      mSpielfeld[i]->setText(_("Game stopped\n\n"));
    break;
  }
		
  case MENU_1_player:
    if (mSpielerZahl != 1) {
      setSpielerZahl(1);
      mLevelNr = 0;
      /* Ist restart level noch enabled? */
      aktualisiereMenuEnabled();
    }
    break;
			
  case MENU_2_player:
    if (mSpielerZahl != 2 || mGegenKI) {
      setSpielerZahl(2);
      mLevelNr = 0;
      /* Ist restart level noch enabled? */
      aktualisiereMenuEnabled();
    }
    break;

  case MENU_KI_player:
    if (!mGegenKI) {
      setSpielerZahl(spz_ki);
      mLevelNr = 0;
      /* Ist restart level noch enabled? */
      aktualisiereMenuEnabled();
    }
    break;
					
  case MENU_preferences: {
    /* Wenn der Benutzer umschaltet, welche Level aktiv sind, soll
       der Level mit dem selben Namen markiert bleiben, und nicht
       mit der selben Nummer... */
    __String levelname;
    if (mLevelNr)
      levelname = ld->getIntLevelName(mLevelNr);

    gPrefs->preferencesDialog(this);

    /* So, und jetzt wieder aus dem Namen die Nummer kriegen.
       (Ist evtl. 0, wenn der Level nicht mehr existiert) */
    if (mLevelNr)
      mLevelNr = ld->getLevelNr(levelname);

    /* Wenn jetzt pltzlich mLevelNr == 0 ist, darf "Restart Level"
       nicht mehr gehen. */
    aktualisiereMenuEnabled();


    break;
  }
  
  case MENU_quit:
    qApp->quit();
    break;
  }
}



/** Startet das Spiel fr die eingestellte Spielerzahl und mit dem
    eingestellten Level */
void Cuyo::startSpiel() {

  if (mGModus != gmodus_kein_spiel)
    stopSpiel();

  /* Damit der Level nicht schon beim Start angehalten ist oder schnell
     luft */
  mEinzelschritt = false;
  mSchnellvorlauf = false;

  if (mSpielerZahl == 1)
    mSpielfeld[1]->setText(_("Your ad here!\n\n"));

  for (int i = 0; i < max_spielerzahl; i++)
    setPunkte(i, 0);

  try {
    if (!startLevel())
      throw Fehler(_("There are no (more?) (working?) levels."));

  } catch (Fehler f) {
    fprintf(stderr, "%s\n", f.getText().data());
    for (int i = 0; i < mSpielerZahl; i++)	
      mSpielfeld[i]->setText(f.getText(), true, true);

    /* Sicherheitshalber...: */
    stopSpiel();

    return;
  }

  /* Timer erzeugen und verbinden... */	
  mTimer = new QTimer(this);
	
  connect(mTimer, SIGNAL(timeout()), SLOT(spielSchritt()));

  mTimer->start(80);

  aktualisiereMenuEnabled();
}


/** stoppt das Spiel sofort (egal, ob grad ein Level luft oder nicht) */
void Cuyo::stopSpiel(bool wegen_fehler/* = false*/) {
  /* Evtl. wird stopSpiel() aufgerufen, wenn das Spiel noch gar nicht
     richtig fertig gestartet wurde; dann wurde mGModus vielleicht noch
     nicht gesetzt, aber es soll trotzdem was gestoppt werden... */
  /*if (mGModus == gmodus_kein_spiel)
    return;*/

  stopLevel(true, wegen_fehler);

  /* Evtl. wird das Spiel zu einem Zeitpunkt gestoppt, zu dem
     noch gar kein Timer existiert... */
  if (mTimer)	
    delete mTimer;
  mTimer = 0;
	
  setGModus(gmodus_kein_spiel);

  ld->ladKeinenLevel();
  
  /* berall ndert sich die Textfarbe... */
  for (int i = 0; i < max_spielerzahl; i++) {
    mPunkteFeld[i]->update();
    mSpielfeld[i]->update();
  }
}






/** Die Haupt-Spielschritt-Routine, whrend das Spiel luft. Wird direkt
    von QT aufgerufen. Ruft alle anderen spielschritt()-Routinen auf. */
void Cuyo::spielSchritt() {
  CASSERT(mGModus != gmodus_kein_spiel);
  
  mInTime = true;

  /* Zeitlupen-Debug-Modus? */
  if (mZeitlupe) {
    mZaehlerZeitlupe++;
    if (mZaehlerZeitlupe == 5)
      mZaehlerZeitlupe = 0;
    else
      return;
  }
	
  /* Warten wir grad drauf, dass der Benutzer eine Taste drckt? */
  if (mWarteAufTaste) {

    if (mWarteTimeout) {
      /* Wir warten nicht beliebig lang */
      mWarteTimeout--;
      if (mWarteTimeout)
	return;
			
      /* Zu lange gewartet. Jetzt reicht's! */
      mWarteAufTaste = false;
    } else
      return;
  }
  
  /* Einzelschritt-Modus. Nach diesem Schritt gleich wieder auf
     Tastendruck warten. */
  if (mEinzelschritt) {
    mWarteAufTaste = true;
  }

  /* Ist grade eine Pause beendet? */
  if (mGModus == gmodus_pause) {
    setGModus(gmodus_spiel);
    for (int i = 0; i < mSpielerZahl; i++) {
      /* Das ist nicht ganz richtig: Wenn da grad ein Text am Blinken
         war, ist er jetzt erst mal weg. */
      mSpielfeld[i]->setText("");
    }
  }


  if (mGModus == gmodus_bonus_warte) {
    /* Wir haben grade ein bisschen gewartet, damit der Benutzer seine
       Level-Endpunkte bewundern kann. Jetzt geht's weiter mit dem nchsten
       Level... */
			
    /* Alten Level stoppen (ist vermutlich nicht wirklich ntig) */
    stopLevel(false);
 		
    /* neuer Level */
    
    mLevelNr++;
    try {
      if (!startLevel()) {
        /* Es gibt gar keine Level mehr; also Spiel beenden */
        stopSpiel();
        for (int i = 0; i < mSpielerZahl; i++) {
  	__String s;
  	s.sprintf(mSpielerZahl == 2 && mPunkte[i] > mPunkte[1-i] ? 
		    _("***\nYou won even a bit more!!!\n\nScore: %d\n***\n\n") :
		    _("***\nYou won!!!\n\nScore: %d\n***\n\n")  ,
	          mPunkte[i]);
  	mSpielfeld[i]->setText(s);
        }
        mLevelNr = 0; // Jetzt kann man nicht mehr Restart last level
        aktualisiereMenuEnabled();
      }
    } catch (Fehler fe) {
      printFehler(mSpielerZahl, _("Could not start level:\n"), fe);
      stopSpiel();
    }
    return;
  } 	
	
  /* Spiel grade erst gestartet? Dann Texte lschen */
  if (mGModus == gmodus_spiel_start) {
    for (int i = 0; i < mSpielerZahl; i++)
      mSpielfeld[i]->setText("");
    setGModus(gmodus_spiel);
  }


  /* Anfang der Schnellvorlauf-Schleife */
  int i_sv = 0;
schnellvorlauf:  


  /* Ok, hier kommt der eigentliche Spielschritt */
  if (mGModus != gmodus_bonus_animation) {

    /* Evtl. Signale abfangen, um die Logdatei abspeichern zu knnen. */
    signaleAn();
    
    try {
    
      /* Den Schritt aufnehmen bzw. abspielen. Beim Abspielen werden
         hier auch ggf. Tastendrcke abgespielt. */
      Aufnahme::recSchritt(mSpielfeld);
      
      /* Erst mal den normalen Spielschritt... in einer Gleichzeit, fr
         evtl. auftretende Events. (Init-Events nicht nicht dabei; die
	 werden erst beim darauffolgenden animiere() behandelt.) */
      Blop::beginGleichzeitig();
      for (int i = 0; i < mSpielerZahl; i++)
        mSpielfeld[i]->spielSchritt();
      Blop::endGleichzeitig();

      /* Animationen und Grafik-Ausgabe */
      animiere();

      /* Ggf. auch einen Spielschritt fr die KI */
      if (mGegenKI)
        mKI->spielSchritt();

    } catch (Fehler fe) {
      signaleAus();
      bool log_gespeichert = false;

      try {
        Aufnahme::speichern(getLogName());
	log_gespeichert = true;
      } catch (Fehler) {}

      /* Im Debug-Modus soll das Spielfeld weiter angezeigt werden,
         wenn ein Fehler whrend des Spiels passiert. */
      stopSpiel(gDebug);
      
      /* Wenn das Speichern der log-Datei geklappt hat, soll ggf.
         die "send log to..."-Meldung ausgegeben werden. */
      printFehler(mSpielerZahl, _("Error during the game:\n"), fe,
                  log_gespeichert);

      return;
    }
    	      
    signaleAus();
  }

  if (mGModus == gmodus_spiel) {
    /* Wurde grade das restliche Gras vernichtet? */
    for (int i = 0; i < mSpielerZahl; i++)
      if (mSpielfeld[i]->istGrasDa())
        goto noch_gras_da;
      
    /* Dann warten wir jetzt nur noch auf einen guten Moment zum beenden. */
    setGModus(gmodus_warte_level);
      
noch_gras_da:;
  }



  /* Ende der Schnellvorlauf-Schleife. Evtl. gleich zwei weitere
     Spielschritte ausfhren. */
  if (mSchnellvorlauf && i_sv < 3) {
    i_sv++;
    goto schnellvorlauf;
  }

  
			
  if (mGModus == gmodus_warte_level ||
      mGModus == gmodus_warte_tot) {
    /* Spiel (Level) soll beendet werden; aber sind auch beide
       Spieler bereit? */
			
    bool bereit = true;
    for (int i = 0; i < mSpielerZahl; i++)
      if (!mSpielfeld[i]->bereitZumStoppen())
	bereit = false;

    if (bereit) {
      /* OK, alle bereit. */
			
      /* Gewonnen oder verloren? */
      if (mGModus == gmodus_warte_level) {
				
	/* Hier darf noch nicht stopLevel() aufgerufen werden, weil sonst
	   das Spielfeld nicht mehr angezeigt wird */
	
	/* Gewonnen. Level als gewonnen abspeichern. Aber nicht im
	   Debug-Modus. */
	if (!gDebug)
	  gPrefs->schreibGewonnenenLevel(mSpielerZahl > 1, mLevelNr);
				
	/* Jetzt kommt die Zeitbonus-Animation */
	setGModus(gmodus_bonus_animation);
				
	/* Noch keine Bonus-Punkte */
	mZeitBonus = 0;
      } else {
	/* Spiel zu Ende weil verloren */
	stopSpiel();
				
	for (int i = 0; i < mSpielerZahl; i++) {
	  __String s;
	  s.sprintf(_("Game over\n\nScore: %d\n\n"), mPunkte[i]);
	  mSpielfeld[i]->setText(s);
	}
      }
					
    }	// Ende: if bereit
  } // Ende: if warten, bis alle fr's Spielende bereit sind


  if (mGModus == gmodus_bonus_animation) {
    /* Hetzrand runterrutschen lassen */
    bool ba_fertig = true; // "= true" nur um eine Warnung zu ersparen
		
    mZeitBonus += punkte_fuer_zeitbonus;

    for (int i = 0; i < mSpielerZahl; i++) {

      /* Neuen Text (mit neuer Punkt-Zahl) schreiben */
      __String s;
      s.sprintf(_("Level %s complete!\n\nTime Bonus: %d\nScore: %d\n\n"),
		ld->mLevelName.data(), mZeitBonus, mPunkte[i]);
      /* Kein update-Event; bei bonusSchritt wird eh neu gemalt. */
      mSpielfeld[i]->setText(s, false);

      /* Rand runterrutschen lassen */		
      ba_fertig = mSpielfeld[i]->bonusSchritt();
 		
      /* Punkte bekommen */
      setPunkte(i, mPunkte[i] + punkte_fuer_zeitbonus);
    }
				
    /* Unten angekommen? */
    if (ba_fertig) {
      setGModus(gmodus_bonus_warte);

      for (int i = 0; i < mSpielerZahl; i++) {
        __String s;
        s.sprintf(_("Level %s complete!\n\nTime Bonus: %d\nScore: %d\n\nSpace = Continue"),
	  	ld->mLevelName.data(), mZeitBonus, mPunkte[i]);
        mSpielfeld[i]->setText(s);
      }
 			
      mWarteAufTaste = true;
      /* Kein Warte-Timeout mehr. Einfach Leertaste drcken */
      //mWarteTimeout = nachbonus_wartezeit;
    } // Ende: if Bonus-Animation fertig
  } // Ende: if Bonus-Animation
}




/** Wird von startLevel() und von spielSchritt() aufgerufen. Lsst
    smtliche Blops animieren und updatet die Grafik. */
void Cuyo::animiere() {

  /* Vielleicht htten gerne einige Blops noch ein Init-Event... */
  Blop::sendeFehlendeInitEvents();

  /* Erst mal das globale Blop ausfhren. */
  ld->spielSchritt();
  
  /* Jetzt alle anderen... in *einer* Gleichzeit */
  Blop::beginGleichzeitig();
  
  /* Alle Grafiken lschen */
  Blop::lazyInitStapel();
  
  /* Alles neu malen  */
  for (int i = 0; i < mSpielerZahl; i++)
    mSpielfeld[i]->animiere(); // updatet auch die Grafik
    
  Blop::endGleichzeitig();
}



/**  */
void Cuyo::neuePunkte(bool reSp, int pt){
  if (reSp) setPunkte(1, mPunkte[1] + pt);
  else setPunkte(0, mPunkte[0] + pt);
}


/**  */
void Cuyo::setPunkte(int sp, int pu){
  mPunkte[sp] = pu;
  mPunkteFeld[sp]->setPunkte(pu);
}





/** tut alles, was beim Starten eines Levels
    getan werden muss; liefert false, wenn es
    den Level gar nicht mehr gibt. Throwt bei Fehler. */
bool Cuyo::startLevel() {

  /* So viele Level gibt's doch gar nicht */
  if (mLevelNr > ld->getLevelAnz())
    return false;

  /* Level-Daten laden */
  for (int i = 0; i < mSpielerZahl; i++) {
    __String s;
    s.sprintf(_("Score: %d\n\nLoading Level %d...\n\n"),
	      mPunkte[i], mLevelNr);
    mSpielfeld[i]->setText(s);
    /* Das false besagt: Nicht erst Lschen */
    mSpielfeld[i]->repaint(0, 0,
              mSpielfeld[i]->width(), mSpielfeld[i]->height(), false);
  }
  ld->ladLevel(mLevelNr, mSpielerZahl);
  
  for (int i = 0; i < max_spielerzahl; i++) {
    /* Punkte-Anzeige jetzt in passender Farbe */
    mPunkteFeld[i]->update();
  }
  /* Und das "Your ad here" auch... */
  if (mSpielerZahl == 1)
    mSpielfeld[1]->update();
	
  /* Aufnehmen / Abspielen starten */
  Aufnahme::init(mAbspielen, mGegenKI ? spz_ki : mSpielerZahl);

  /***** Allen Leuten erzhlen, dass jetzt ein Level anfngt. *****/
  
  /* Fr den Global-Blop... */
  ld->startLevel();

  /* Hier ist die Stelle, wo wir darauf gucken, wie viele Spieler mitspielen;
     nur fr so viele Spieler wird das Spiel wirklich gestartet */
  for (int i = 0; i < mSpielerZahl; i++) {
    
    mSpielfeld[i]->startLevel();
    __String s;
    s.sprintf(_("Score: %d\n\n"
                "Level %d\n%s\nby %s\n\n"
                "%d blops explode\n%s\n"
		"%s\n\n"
		"Space = Start"),
	    mPunkte[i],
	    mLevelNr, ld->mLevelName.data(), ld->mLevelAutor.data(),
	    ld->mPlatzAnzahl,
	    ld->mGrasBeiKettenreaktion ? "Chain reaction necessary\n" : "",
	    ld->mBeschreibung.data());
    /* Kein update-Event verschicken; beim animiere()-Aufruf wird
       eh neu gemalt. */
    mSpielfeld[i]->setText(s, false);
  }
  
  /* Alle Blops einmal animieren, damit sie wissen, wie sie aussehen.
     Dabei werden auch die ganzen Init-Events verschickt. */
  animiere();

  /* Auch die KI mchte wissen, wenn ein neuer Level anfngt. */
  if (mGegenKI)
    mKI->startLevel();

	
  setGModus(gmodus_spiel_start);
  mWarteAufTaste = true;
  mWarteTimeout = 0;
  return true;
}



/** tut alles, was beim Stoppen eines Levels
    getan werden muss (ohne Animation, d. h. entweder
    ist die Animation schon vorbei oder es gibt halt keine).
    Wenn malen = true ist, Bildschirm sofort updaten */
void Cuyo::stopLevel(bool malen, bool wegen_fehler /*= false*/) {
			
  for (int i = 0; i < mSpielerZahl; i++)
    mSpielfeld[i]->stopLevel(malen, wegen_fehler);
}





/** liefert true, wenn das Spiel normal luft, false
		wenn das Spiel am zuende gehen ist */
bool Cuyo::spielLaeuft() {
  CASSERT(mGModus != gmodus_kein_spiel);
  return mGModus == gmodus_spiel || mGModus == gmodus_pause;
}



/** wird aufgerufen, wenn ein Spieler tot ist */
void Cuyo::spielerTot() {
  setGModus(gmodus_warte_tot);
}



/** wird aufgerufen, wenn der Benutzer was-auch-immer
    fertiggelesen (und eine Taste gedrckt) hat. */
void Cuyo::tasteWeiter() {
  mWarteAufTaste = false;
  mWarteTimeout = 0;
}


/** Liefert ein Spielfeld zurck. */
Spielfeld * Cuyo::getSpielfeld(bool reSp) {
  return mSpielfeld[reSp];
}

/** Liefert zurck, ob die Zeit fr Grafik grade reicht */
bool Cuyo::getInTime() const {
  return mInTime;
}


/** Liefert die Anzahl der Mitspieler zurck. */
bool Cuyo::getSpielerZahl() const {
  return mSpielerZahl;
}

/** Ein key-Event halt... (Kmmert sich um alle Tasten,
    die whrend des Spiels so gedrckt werden...) */
void Cuyo::keyPressEvent(QKeyEvent * e) {
  int k = e->key();
  bool acc = false;
  if (mGModus == gmodus_spiel) {
    int sp, t;
    if (gPrefs->getTaste(k, sp, t)) {
      /* Im 1-Spieler-Modus und im KI-Modus alle Tastendrcke an
	 Spieler 1 senden: */
      if (mSpielerZahl == 1 || mGegenKI) sp = 0;

      Aufnahme::recTaste(sp, t);
      mSpielfeld[sp]->taste(t);
      acc = true;
    }
  } // if spiel luft
  
  if (mWarteAufTaste)
    if (k == Key_Space || k == Key_Return || k == Key_Enter) {
      tasteWeiter();
      acc = true;
    }

  /* Event noch nicht verarbeitet */
  if (!acc) {

    /* Debug-Taste? */
    if (gDebug) {
      char a = e->ascii();

      if (a == 'b') {
	for (int i = 0; i < mSpielerZahl; i++)
	  mSpielfeld[i]->empfangeGraue(1);
	fprintf(stderr, "Debug: Bekomme Graue\n");
	return; 
      }

      if (a == 'e') {
	mEinzelschritt = !mEinzelschritt;
	fprintf(stderr, "Debug: Einzelschritt = %d\n", mEinzelschritt);
        if (!mEinzelschritt) {
          /* Nicht noch ein letztes Mal auf Taste warten... */
          mWarteAufTaste = false;
        }
	return;
      }

      if (a == 'L') {
	fprintf(stderr, "Debug: Logdatei laden\n");
        Aufnahme::laden(getLogName());
	setSpielerZahl(Aufnahme::getSpZ());
	__String lna = Aufnahme::getLevelName();
        int leanz = ld->getLevelAnz();

	mLevelNr = 0;
        /* Level durchgehen */
        for (int lenr = 1; lenr <= leanz; lenr++) {
          if (ld->getIntLevelName(lenr) == lna) {
	    mLevelNr = lenr;
	  }
	}
	
	fprintf(stderr, "Level %s (%d)\n",
	        lna.data(), mLevelNr);
	fprintf(stderr, "Zum Abspielen ctrl-r drcken.\n");
	mAbspielen = true;
	
        aktualisiereMenuEnabled();
      }

      if (a == 'l') {
	mAbspielen = !mAbspielen;
	fprintf(stderr, "Debug: Log abspielen = %d\n", mAbspielen);
	return;
      }

      if (a == 'g') {
        /* Hoffentlich darf man gModus einfach so ndern... */
        
        if (mGModus == gmodus_spiel) {
          setGModus(gmodus_warte_level);
	  fprintf(stderr, "Debug: Gewinnen\n");
        }
	return;
      }

      if (a == 'h') {
	fprintf(stderr, "Debug: Hilfe\n");
	fprintf(stderr, "  b: Bekomme Graue\n");
	fprintf(stderr, "  e: Einzelschrittmodus an/aus\n");
	fprintf(stderr, "  g: Gewinnen\n");
	fprintf(stderr, "  h: Hilfe\n");
	fprintf(stderr, "  L: Log laden\n");
	fprintf(stderr, "  l: Log abspielen an/aus\n");
	//fprintf(stderr, "  n: Neue Animationen testen\n");
	fprintf(stderr, "  r: Reload levelconf\n");
	fprintf(stderr, "  S: Log speichern\n");
	fprintf(stderr, "  t: Test Rber-Reihe an/aus\n");
	fprintf(stderr, "  v: Schnellvorlauf an/aus\n");
	fprintf(stderr, "  z: Zeitlupe an/aus\n");
	return;
      }
      /*
      if (a == 'n') {

      }*/

      if (a == 'r') {
        if (mGModus == gmodus_kein_spiel) {
	  fprintf(stderr, "Debug: Reload levelconf\n");
          try {
   	    ld->ladLevelConf();
	  } catch (Fehler fe) {
	    printFehler(2, "Could not reload the level description file:\n",
	        	fe);
	  }
	} else
	  fprintf(stderr, "Debug: *Nicht* reload levelconf whrend Spiel luft.\n");
	return;
      }

      if (a == 'S') {
	fprintf(stderr, "Debug: Logdatei speichern\n");
        Aufnahme::speichern(getLogName());
	return;
      }

      if (a == 't') {
	mRueberReihenTest = !mRueberReihenTest;
	fprintf(stderr, "Debug: Test Rber-Reihe = %d\n", mRueberReihenTest);
	return;
      }

      if (a == 'v') {
	mSchnellvorlauf = !mSchnellvorlauf;
	fprintf(stderr, "Debug: Schnellvorlauf = %d\n", mSchnellvorlauf);
	return;
      }

      if (a == 'z') {
	mZeitlupe = !mZeitlupe;
	fprintf(stderr, "Debug: Zeitlupe = %d\n", mZeitlupe);
	return;
      }

    }

    e->ignore();
  }
}

/** Setzt die Anzahl der Spieler. Auch in der Menleiste. 
    Bei a == spz_ki wird auf ki-Modus geschaltet. (spz_ki wird in
    aufnahme.h definiert, weil es dort auch gebraucht wird.) */
void Cuyo::setSpielerZahl(int a){
  mGegenKI = a == spz_ki;
  mSpielerZahl = mGegenKI ? 2 : a;
  mSpielMenu->setItemChecked(MENU_1_player, a == 1);
  mSpielMenu->setItemChecked(MENU_2_player, a == 2);
  mSpielMenu->setItemChecked(MENU_KI_player, a == spz_ki);
}

/** ndert mGModus und aktualisiert das Enabled-Sein der Mens. */
void Cuyo::setGModus(int gm) {
  mGModus = gm;
  aktualisiereMenuEnabled();
}


/** Setzt das Enabled-Sein der Mens auf das Richtige,
    abhngig von mGModus und mLevelNr */
void Cuyo::aktualisiereMenuEnabled() {
  bool ks = mGModus == gmodus_kein_spiel;
  mSpielMenu->setItemEnabled(MENU_new_game, ks);
  mSpielMenu->setItemEnabled(MENU_restart_level, ks && mLevelNr > 0);
  mSpielMenu->setItemEnabled(MENU_start_at, ks);
  mSpielMenu->setItemEnabled(MENU_pause_game, mGModus == gmodus_spiel);
  mSpielMenu->setItemEnabled(MENU_stop_game, !ks);
  mSpielMenu->setItemEnabled(MENU_1_player, ks);
  mSpielMenu->setItemEnabled(MENU_2_player, ks);
  mSpielMenu->setItemEnabled(MENU_KI_player, ks);
  mSpielMenu->setItemEnabled(MENU_preferences, ks);
}



/** Gibt die Fehlermeldung bestehend aus t und fe aus:
    Sowohl als Text im Cuyo-Fenster
    (bei anz_sp vielen Spielern) als auch auf stderr. 
    mitLog wird an fe.getText() weitergegeben. (D. h.: soll
    ggf. die Send-Log-Meldung ausgegeben werden?) */
void Cuyo::printFehler(int anz_sp, __String t, Fehler fe,
                       bool mitLog /*= false*/) {
  t += fe.getText(mitLog);
  fprintf(stderr, "%s\n", t.data());
  for (int i = 0; i < anz_sp; i++) {
    /* zweites true = Kleine Schrift... */
    mSpielfeld[i]->setText(t, true, true);
  }
}




/***** Die nachfolgenden Funktionen gehren nicht zum Cuyo-Objekt *****/



/** Liefert den Namen und Pfad der Log-Datei zurck
    ($HOME/cuyo.log) */
__String getLogName() {
  char * ho = getenv("HOME");
  if (!ho) {
    /* Unter Windows zum Beispiel... */
    fprintf(stderr, _("Warning: Env-Variable $HOME not found. Using the current cirectory for cuyo.log"));
    return "cuyo.log";
  }
  if (ho[strlen(ho) - 1] == '/')
    return __String(ho) + "cuyo.log";
  else
    return __String(ho) + "/cuyo.log";
}
