/* tct.cxx
     $Id: tct.cxx,v 1.6 2001/11/27 23:57:36 elf Exp $

   written by Marc Singer
   26 July 1997

   This file is part of the project CurVeS.  See the file README for
   more information.

   Copyright (C) 1997,1998 Marc Singer

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   with your Debian GNU/Linux system, in
   /usr/share/common-licenses/GPL, or with the Debian GNU/Linux hello
   source package as the file COPYING. If not, write to the Free
   Software Foundation, Inc., 59 Temple Place -Suite 330, MA
   02111-1307, USA.

   -----------
   DESCRIPTION
   -----------

*/

#include "std.h"

#include "mman.h"
#include "term.h"

char g_szProgram[1];

int main (int /* argc */, char** /* argv */)
{
  LTerm term;
  term.init ();
  
  term.cls ();
  term.moveto (0, 3);
  term.sprintf ("Howdy");
  term.flush ();

  term.moveto (2, 3);
  term.set_attribute (attrBold, attrAllMode);
  term.sprintf ("Bold");
  term.moveto (3, 3);
  term.set_attribute (attrUnderline, attrAllMode);
  term.sprintf ("Underline");
  term.moveto (4, 3);
  term.set_attribute (attrInverse, attrAllMode);
  term.sprintf ("Inverse");
  term.moveto (5, 3);
  term.set_attribute (attrStandout, attrAllMode);
  term.sprintf ("Standout");
  term.flush ();

  term.moveto (2, 20);
  term.set_attribute (attrFgRed);
  term.sprintf ("Red");
  term.set_attribute (attrFgBright, attrFgBright);
  term.sprintf (" -> Bright red");
  term.set_attribute (attrBgBlue, attrBgMask);
  term.sprintf (" -> on Blue");
  term.set_attribute (attrFgDefault, attrFgMask);
  term.sprintf (" -> plain on Blue");
  term.moveto (3, 20);
  term.set_attribute (attrBgDefault, attrBgMask);
  term.sprintf (" -> Bold only");
  term.flush ();

#if 1
  Termcap& termcap = term.termcap ();
  int cch = 0;
  char sz[2048];

  cch += termcap.compose (termcapClearScreen, sz + cch);
  cch += termcap.compose (termcapMoveHome, sz + cch);
  cch += termcap.compose (termcapDownOne, sz + cch);
  cch += termcap.compose (termcapDownOne, sz + cch);
  cch += sprintf (sz + cch, "Howdy, yuk yuk");
  cch += termcap.compose (termcapMoveHome, sz + cch);
  cch += sprintf (sz + cch, "Back home");
  cch += sprintf (sz + cch, " %d %d", termcap.num (termcapNumLines),
		  termcap.num (termcapNumColumns));
  printf (sz);
  getchar ();

  cch = 0;
  cch += termcap.compose (termcapMoveTo, sz + cch, 1, 1);
  cch += sprintf (sz + cch, "1");
  cch += termcap.compose (termcapMoveTo, sz + cch, 2, 2);
  cch += sprintf (sz + cch, "2");
  cch += termcap.compose (termcapMoveTo, sz + cch, 3, 3);
  cch += sprintf (sz + cch, "3");
  cch += termcap.compose (termcapMoveTo, sz + cch, 4, 4);
  cch += sprintf (sz + cch, "4");
  cch += termcap.compose (termcapMoveTo, sz + cch, 5, 5);
  cch += sprintf (sz + cch, "5");
  printf (sz);
  getchar ();

  for (int i = 0; i < 10; ++i) {
    cch = 0;
    cch += termcap.compose (termcapMoveTo, sz + cch, i, 20);
    cch += termcap.compose (termcapSetAnsiForeground, sz + cch, i);
    cch += sprintf (sz + cch, "Color %d", i);
    printf (sz);
  }
  getchar ();
  for (int i = 0; i < 10; ++i) {
    cch = 0;
    cch += termcap.compose (termcapMoveTo, sz + cch, i, 30);
    cch += termcap.compose (termcapSetAnsiBackground, sz + cch, i);
    cch += sprintf (sz + cch, "Color %d", i);
    printf (sz);
  }

  for (int i = 0; i < 10; ++i) {
    cch = 0;
    cch += termcap.compose (termcapMoveTo, sz + cch, i, 40);
    cch += sprintf (sz + cch, "\E[%dm", i + 90);
    cch += sprintf (sz + cch, "Color %d", i);
    printf (sz);
  }

  for (int i = 0; i < 10; ++i) {
    cch = 0;
    cch += termcap.compose (termcapMoveTo, sz + cch, i, 50);
    cch += sprintf (sz + cch, "\E[%dm", i + 100);
    cch += sprintf (sz + cch, "Color %d", i);
    cch += sprintf (sz + cch, "\E[0m*");
    printf (sz);
  }

  for (int i = 0; i < 10; ++i) {
    cch = 0;
    cch += termcap.compose (termcapMoveTo, sz + cch, i + 12, 20);
    cch += sprintf (sz + cch, "\E[%dm", i + 30);
    cch += sprintf (sz + cch, "\E[1m");
    cch += sprintf (sz + cch, "Col\E[4mor %d", i);
    printf (sz);
  }

  for (int i = 0; i < 10; ++i) {
    cch = 0;
    cch += termcap.compose (termcapMoveTo, sz + cch, i + 12, 30);
    cch += sprintf (sz + cch, "\E[%dm", i + 30);
    cch += sprintf (sz + cch, "\E[4m");
    cch += sprintf (sz + cch, "Color %d", i);
    printf (sz);
  }

  for (int i = 0; i < 10; ++i) {
    cch = 0;
    cch += termcap.compose (termcapMoveTo, sz + cch, i + 12, 40);
    cch += sprintf (sz + cch, "\E[%dm", i + 30);
    cch += sprintf (sz + cch, "\E[5m");
    cch += sprintf (sz + cch, "Color %d", i);
    printf (sz);
  }

  for (int i = 0; i < 10; ++i) {
    cch = 0;
    cch += termcap.compose (termcapMoveTo, sz + cch, i + 12, 50);
    cch += sprintf (sz + cch, "\E[%dm", i + 30);
    cch += sprintf (sz + cch, "\E[7m");
    cch += sprintf (sz + cch, "Color %d", i);
    printf (sz);
  }

				// ---------------------------

  printf ("\e[0m");
  for (int i = 0; i < 10; ++i) {
    cch = 0;
    cch += termcap.compose (termcapMoveTo, sz + cch, i + 12, 0);
    cch += termcap.compose (termcapSetAnsiForeground, sz + cch, i);
    cch += sprintf (sz + cch, "\e[1mColor %d", i);
    printf (sz);
  }

  getchar ();

  cch = 0;
  cch += termcap.compose (termcapClearScreen, sz + cch);
  cch += termcap.compose (termcapMoveTo, sz + cch, 1, 1);
  cch += termcap.translate (termcapACS, sz + cch, "+,-.0I`afghjkmnoqstuvwx~");
  cch += termcap.compose (termcapMoveTo, sz + cch, 2, 1);
  //  cch += termcap.compose (termcapEnableACS, sz + cch);
  cch += termcap.compose (termcapStartACS, sz + cch);
  cch += termcap.translate (termcapACS, sz + cch, "+,-.0I`afghjkmnoqstuvwx~");
  cch += termcap.compose (termcapEndACS, sz + cch);
  cch += termcap.compose (termcapMoveTo, sz + cch, 3, 1);
  cch += termcap.translate (termcapACS, sz + cch, "+,-.0I`afghjkmnoqstuvwx~");

  printf (sz);

#endif

  getchar ();
}


