
/*
 * Copyright (c) 2000 David Stes.
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published 
 * by the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: condstmt.m,v 1.4 2002/06/15 19:19:30 stes Exp $
 */

#include <assert.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>
#include <Object.h>
#include "process.h"
#include "condstmt.h"

@implementation CondStatement

- lhs:v
{
  lhs = v; return self;
}

- what:(STR)w
{
  what= w;return self;
}

- rhs:v
{
  rhs = v;return self;
}

- go
{
  int ok;

  [lhs setsrcfd:srcfd];
  if (dstbuf) [lhs setdstbuf:dstbuf]; else [lhs setdstfd:dstfd];
  if (errbuf) [lhs seterrbuf:errbuf]; else [lhs seterrfd:errfd];
  [lhs go];
  exitcode = [lhs exitcode];
  
  if ((!strcmp(what,"&&")&&exitcode==0)||(!strcmp(what,"||")&&exitcode!=0)) { 
    [rhs setsrcfd:srcfd];
    if (dstbuf) [rhs setdstbuf:dstbuf]; else [rhs setdstfd:dstfd];
    if (errbuf) [rhs seterrbuf:errbuf]; else [rhs seterrfd:errfd];
    [rhs go];
    exitcode = [rhs exitcode];
  }

  return self;
}

@end

