/*
 * PT
 * Copyright (C) 2002  The Printing Tool Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * pt.c
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"


gint main (gint argc, gchar *argv[])
{
	GtkWidget *program_window;

#ifdef ENABLE_NLS
	bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain (PACKAGE);
#endif

	gtk_set_locale ();
	gtk_init (&argc, &argv);

	add_pixmap_directory (PACKAGE_DATA_DIR "/pixmaps");
	add_pixmap_directory (PACKAGE_SOURCE_DIR "/pixmaps");

	/*
	 * The following code was added by Glade to create one of each component
 	* (except popup menus), just so that you see something after building
 	* the project. Delete any components that you don't want shown initially.
	 */

	program_window = p_create_program_window ();
	gtk_widget_show (program_window);
	p_rewrite_clist (gtk_object_get_data (GTK_OBJECT (program_window), "clist"));
	gtk_object_set_data (GTK_OBJECT (gtk_object_get_data (GTK_OBJECT (program_window), "clist")), "timer_id",
		GUINT_TO_POINTER (gtk_timeout_add ((GPOINTER_TO_INT (gtk_object_get_data (GTK_OBJECT (program_window), "tmp")) * 1000),
			(GtkFunction) p_timer_rewrite_clist, gtk_object_get_data (GTK_OBJECT (program_window), "clist"))));
	gtk_object_remove_data (GTK_OBJECT (program_window), "tmp");		
	gdk_window_set_icon (program_window->window, NULL,
		gtk_object_get_data (GTK_OBJECT (program_window), "pixmap"),
			gtk_object_get_data (GTK_OBJECT (program_window), "bitmap"));

	gtk_main ();
	return 0;
}

