/*
 * PT
 * Copyright (C) 2002, 2003  The Printing Tool Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * interface.h
 */

#ifndef INTERFACE_H
#define INTERFACE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /*HAVE_CONFIG_H*/

#include <gtk/gtk.h>
#include "printsys.h"

#ifndef DEFINITIONS_H
#include "definitions.h"
#endif /*DEFINITIONS_H*/


/*
 * functions
 */

GtkWidget *p_create_program_window (void);
void p_apply_preferences (GtkWidget *widget);
void p_rewrite_clist (GtkCList *clist);
gint p_timer_rewrite_clist (GtkCList *clist);
void p_start_polling (GtkCList *clist);
void p_stop_polling (GtkCList *clist);
void p_call_multi_request (GtkCList *clist, ipp_op_t w,
	const multi_arg_t multi_arg);
void p_delete (GtkCList *clist);
void p_up (GtkCList *clist);
void p_down (GtkCList *clist);
void p_change_priority (GtkCList *clist, gint change_arg);
void p_hold (GtkCList *clist);
void p_release (GtkCList *clist);
void p_show_move_dialog (GtkCList *clist);
void p_exit (GtkWidget *widget);
void p_sort (GtkCList *clist, gint column);
gint p_gtk_compare (GtkCList *clist, gconstpointer p_1, gconstpointer p_2);
void p_select (GtkCList *clist, gint row, gint column,
	GdkEventButton *event);
void p_unselect (GtkCList *clist, gint row, gint column,
	GdkEventButton *event);
void p_dest_select (GtkCList *clist, gint row, gint column,
	GdkEventButton *event);
void p_left_button_pressed (GtkWidget *widget, GdkEventButton *event);
void p_left_button_released (GtkWidget *widget, GdkEventButton *event);
void p_right_button_pressed (GtkWidget *widget, GdkEventButton *event);
void p_show_info_dialog (GtkWidget *widget);
void p_reset_transient (GtkWidget *widget);
void p_show_preferences_dialog (GtkWidget *widget);
void p_preferences_change_action (GtkWidget *widget);
void p_preferences_ok (GtkWidget *widget);
void p_get_filter (GtkWidget *widget);
gint p_g_compare (gconstpointer p_1, gconstpointer p_2);
void p_get_host (GtkEntry *entry);
void p_get_port (GtkSpinButton *spinbutton);
void p_get_refresh (GtkSpinButton *spinbutton);
void p_get_change (GtkSpinButton *spinbutton);
void p_get_user (GtkEntry *entry);
void p_get_ssl_buttons (GtkWidget *widget);
gint p_get_ssl_value (GtkWidget *widget);
const gchar *p_password_callback (const gchar *prompt);
void p_show_password_dialog (void);
void p_skip_password (GtkWidget *widget);
void p_submit_password (GtkWidget *widget);

#endif /*INTERFACE_H*/
