# structures.rb, copyright (c) 2006 by Vincent Fourmond: 
# The code file for fancy structural elements.
  
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
  
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details (in the COPYING file).

require 'Dobjects/Dvector'
require 'CTioga/debug'
require 'CTioga/log'

require 'CTioga/elements'

module CTioga

  # A subplot class for handling plot with alternative axes.
  class SharedAxisPlot < SubPlot

    # The positions concerned by the axis type in the
    # arrays returned by get_boundaries and the like.
    BoundaryPositions = {
      :y => [2,3],
      :x => [0,1]
    }

    # Some pseudo-accessors:
    def shared_axis
      if @axis == :y
        :x
      else
        :y
      end
    end

    def private_axis
      @axis
    end

    # Creates a subplot of _parent_ which will use alternative
    # axes for _axis_. _axis_ is the axis which is *not* shared !
    def initialize(axis = :y, parent = nil)
      super(:subplot, parent)
      @axis = axis
      # We forward all legend information to the parent
      @accept_legend = false
    end

    # Report appropriate values for the axes to the parent
    # plot.
    def get_boundaries
      bounds = internal_get_boundaries
      for i in BoundaryPositions[private_axis]
        bounds[i] = 0.0/0.0     # NaN is ignored
      end
      return bounds
    end

    # We use the parents boundary for the shared axis.
    def compute_boundaries
      # First, we compute the boundaries using the standard
      # Subplot function
      bounds = super
      
      # Then we override the shared values using the parents:
      parents = parent.compute_boundaries
      for i in BoundaryPositions[shared_axis]
        bounds[i] = parents[i]  # We use the parents boundaries.
      end
      return bounds
    end

  end
  
end
