CTIOGA="--xpdf --clean-all --display-commandline"
export CTIOGA

 ctioga --math 'exp(x)'

 ctioga --math 'exp(x)' --title 'My exponential'

 ctioga --math-xrange -5:1 --math 'exp(x)' -t 'My exponential'

 ctioga --xrange -1:1 --math 'sin(10 * x)' \
        -t 'badly sampled sine'

 ctioga --math-xrange -1:1 --math 'sin(10 * x)' \
        -t 'well sampled sine'

 ctioga --xrange -3:3 --math-xrange -2:0 --math 'x+1'    \
                      --math-xrange 0:2         'exp(x)' \
                      -t 'Strange exponential'

 ctioga --yrange -2:8 --xrange -3:3         \
        --math-xrange -2:0 --math 'x+1'     \
        --math-xrange  0:2        'exp(x)'  \
        -t 'Strange exponential' 

 ctioga --math --math-trange -3.1415:3.1415 \
        'sin(2*t):cos(3*t)'                 \
        -t 'parametric curve'

 ctioga --include include_1.rb --math 'pol(x)' -t 'Polynomial function'

 ctioga trig.dat -t 'data sine'

 ctioga trig.dat trigh.dat -t 'data sine and hyperbolic tangente'

 ctioga trig.dat@1:3 -t 'data cosine'

 ctioga trig.dat@2:3 -t 'Circle'

 ctioga trig.dat @1:3 @2:3 -t 'Some trigonometry'

 ctioga trig.dat trigh.dat @1:3 @2:3 -t 'Mixing 1'

 ctioga trig.dat @1:3 trigh.dat @2:3 -t 'Mixing 2'

 ctioga trig.dat @1:3 @2:3 trigh.dat -t 'Mixing 3'

 ctioga --legend sine trig.dat     \
        -l cosine @1:3             \
        -l 'beautiful circle' @2:3 \
        -t 'Some trigonometry'

 ctioga -l '$\sin(x)$' trig.dat                          \
        -l '$\cos(x)$' @1:3                              \
        -l '$r = \sqrt{\cos^2(x) + \sin^2(x)} = 1$' @2:3 \
        -t 'Some trigonometry'

 ctioga -t 'Use of expansion' trig.dat@1:2##3

 ctioga -t 'Math and expansion' --math 'sin(x + 1##4)'

 ctioga -t 'Unsorted' noise.dat

 ctioga -t 'Sorted' --sort noise.dat

 ctioga -t 'Smoothing' --sort --smooth 3 noise.dat

 ctioga -t 'Comparison' --sort -l 'Noise' noise.dat \
                        --smooth 3 -l 'Smoothing' noise.dat

 ctioga -t 'Sorting second'                             \
        -l 'Sorting second' --smooth 3 --sort noise.dat \
        --filter-clear                                  \
        -l 'Sorting first'  --sort --smooth 3 noise.dat

 ctioga -t 'Cumulative distribution'                         \
        --math --math-xrange 0:40 --yrange 1:4.5 --ylog      \
        -l 'data'                                            \
        --histogram    --math-sample 21  'x**3-30*x**2+4100' \
        -l 'fit'                                             \
        --no-histogram --math-sample 200 'x**3-30*x**2+4100' 

 ctioga -t 'Everybody likes to go there' \
        -l 'Max value'                    \
        trig.dat@'$1:[$2,$3].max'

 ctioga -t 'First and third quarter' \
        -l 'Conditionnal drawing'    \
        trig.dat@'$2:(if $3*$2 > 0 ; $3 else 0.0/0.0 ; end)'

 ctioga -t 'Square root summation'   \
        -N trig.dat@'$1:sqrt($2##4)' \
        -l 'Sum using Dvectors'      \
        trig.dat@'$1:Dvector[$2,$3,$4].safe_sqrt.sum'

 ctioga --color Violet trig.dat \
        -c Blue @1:3            \
        -c Turquoise @2:3       \
        -c PowderBlue trigh.dat \
        -t 'Blue tones'

 ctioga --background Ivory trig.dat -l 'Ivory background'

 ctioga --mono trig.dat @1:3 @2:3 -t 'Black trigonometry'

 ctioga --line-style Line_Type_Dot trig.dat       \
        --line-style Line_Type_Dash @2:3          \
        --line-style Line_Type_Dot_Long_Dash @1:3 \
        -t 'Some line types'

 ctioga --line-width 0.5 trig.dat @1:3 \
        --line-width 2 @2:3            \
        -t 'See the circle ?'

 ctioga -l 'model' --math --xrange -4:4 'sin(x)'                \
        -l 'data'  --text --marker Plus --line-width 0 trig.dat \
        -t 'comparison data/model'

 ctioga --marker Plus --marker-color Blue trig.dat \
        -t 'Bicolored graph'

 ctioga -l '$x = \cos(t)$' --math 'cos(x)' -x '$t$' -y '$x$' \
        -t 'Evolution of position $x$ in time'

 ctioga trig.dat @1:3 @2:3 -t 'Gold trigonometry' --golden-ratio

 ctioga trig.dat @1:3 @2:3             \
        -t 'Silver trigonometry'       \
        --aspect-ratio 2

 ctioga trig.dat @1:3 @2:3             \
        -t 'Bronze trigonometry'       \
        --aspect-ratio 0.5

 ctioga trig.dat --margin 0.1          \
        -t '10\% air on both sides'

 ctioga trig.dat --margin 0.1 --xrange -3.14:3.14 \
        -t '10\% air on vertical side'

 ctioga trig.dat @1:3 @2:3 trigh.dat @1:3 @2:3 \
        -t 'default color-set'

 ctioga --color-set colorblind                 \
        trig.dat @1:3 @2:3 trigh.dat @1:3 @2:3 \
        -t 'colorblind color-set'

 ctioga --color-set gradient:Blue--Red,6       \
        trig.dat @1:3 @2:3 trigh.dat @1:3 @2:3 \
        -t 'Gradient feature with 6 steps'

 ctioga --color-set gradient:Blue--Red,3       \
        trig.dat @1:3 @2:3 trigh.dat @1:3 @2:3 \
        -t 'Gradient feature with 3 steps'

 ctioga -m --marker-set default trig.dat @1:3 @2:3  \
        -t 'Using Markers'

 ctioga --mono --line-style-set default trig.dat @1:3 @2:3  \
        -t 'Using line-styles (which is already the default...)'

 ctioga -m --marker-set default        \
        --marker-color-set colorblind  \
        trig.dat @1:3 @2:3             \
        -t 'Using Markers'

 ctioga --ylog --math 'exp(x)' -t 'Some straight line'

 ctioga --xlog --ylog --math-xrange 0.001:1000 \
        --math '1/x**2' '1/x**3' -t 'Power laws'

 ctioga --xlog --ylog --math                                       \
        --math-xrange 0.1:1  -l 'Low masses' '1/x**1.3'            \
        --math-xrange 1:10   -l 'Intermediate masses' '1/x**2.35'  \
        --math-xrange 10:100 -l 'High masses' '1/x**4*10**1.65'    \
        -x '$\log_{10}(M/M_\odot)$' -y '$\log_{10}(dN/dM)$'        \
        -t 'Kroupa IMF' --golden-ratio

 ctioga --xlog --ylog --xrange -2:3 --math                         \
        --math-xrange 0.1:1  -l 'Low masses' '1/x**1.3'            \
        --math-xrange 1:10   -l 'Intermediate masses' '1/x**2.35'  \
        --math-xrange 10:100 -l 'High masses' '1/x**4*10**1.65'    \
        -x '$\log_{10}(M/M_\odot)$' -y '$\log_{10}(dN/dM)$'        \
        -t 'Kroupa IMF' --golden-ratio

 ctioga trig.dat @1:4 -t 'Scaling problem'

 ctioga trig.dat --xfact 0.5 --yfact 5 @1:4 -t 'Scaling resolved'

 ctioga -t 'RC circuit decay' -N --math --math-xrange 0:9 \
        -x '$t$' -y '$U_C$'                               \
        'exp(-x/2)' --yrange 0:1

 ctioga -t 'RC circuit decay' -N --math --math-xrange 0:9 \
        -x '$t$' -y '$U_C$'                               \
        'exp(-x/2)' --yrange 0:1                          \
        --draw "arrow: 6,0.2 6,0.07"

 ctioga -t 'RC circuit decay' -N --math --math-xrange 0:9 \
        -x '$t$' -y '$U_C$'                               \
        'exp(-x/2)' --yrange 0:1                          \
        --draw "arrow: 6,0.2 6,0.07 tail_scale=0.1 head_scale=0.5" 

 ctioga -t 'RC circuit decay' -N --math --math-xrange 0:9 \
        -x '$t$' -y '$U_C$'                               \
        'exp(-x/2)' --yrange 0:1                          \
        --draw "arrow: 6,0.2 6,0.07 tail_scale=0.1 head_scale=0.5" \
        --draw "text: 6,0.22 '\$95\\%\$ decay'"

 ctioga -t 'RC circuit decay' -N --math --math-xrange 0:9 \
        -x '$t$' -y '$U_C$'                               \
        'exp(-x/2)' --yrange 0:1                          \
        --draw "arrow: 6,0.2 6,0.07 tail_scale=0.1 head_scale=0.5" \
        --draw "text: 6,0.22 '\$95\\%\$ decay'"           \
        --draw "tangent: 0.5 head_scale=0.7"

 ctioga -t 'RC circuit decay' -N --math --math-xrange -1:9 \
        -x '$t$' -y '$U_C$'                                \
        'exp(-x/2)' --yrange 0:1 --xrange 0:9              \
        --draw "arrow: 6,0.2 6,0.07 tail_scale=0.1 head_scale=0.5" \
        --draw "text: 6,0.22 '\$95\\%\$ decay'"            \
        --draw "tangent: 0.5 head_scale=0.7"               \
        --draw "tangent: 0.1 head_scale=0.1 xextent=2 color=Black" 

 ctioga -t 'RC circuit decay' -N --math --math-xrange -1:9 \
        -x '$t$' -y '$U_C$'                                \
        'exp(-x/2)' --yrange 0:1 --xrange 0:9              \
        --draw "arrow: 6,0.2 6,0.07 tail_scale=0.1 head_scale=0.5" \
        --draw "text: 6,0.22 '\$95\\%\$ decay'"            \
        --draw "tangent: 0.5 head_scale=0.7"               \
        --draw "tangent: 0.1 head_scale=0.1 yextent=-1 color=Black" 

 ctioga -t 'RC circuit decay' -N --math --math-xrange -1:9 \
        -x '$t$' -y '$U_C$'                                \
        'exp(-x/2)' --yrange 0:1 --xrange 0:9              \
        --draw "arrow: 6,0.2 6,0.07 tail_scale=0.1 head_scale=0.5"  \
        --draw "text: 6,0.22 '\$95\\%\$ decay'"            \
        --draw "tangent: 0.5 head_scale=0.7"               \
        --draw "tangent: 0.1 head_scale=0.1 yextent=-1 color=Black" \
        --draw "text: 1.9,0.15 '\$\\tau=RC\$'              \
        angle=-77 scale=2 color=Blue"

 ctioga -t 'RC circuit decay' -N --math --math-xrange -1:9 \
        -x '$t$' -y '$U_C$'                                \
        'exp(-x/2)' --yrange 0:1 --xrange 0:9              \
        --draw "arrow: 6,0.2 6,0.07 tail_scale=0.1 head_scale=0.5"  \
        --draw "text: 6,0.22 '\$95\\%\$ decay'"            \
        --draw "tangent: 0.5 head_scale=0.7"               \
        --draw "tangent: 0.1 head_scale=0.1 yextent=-1 color=Black" \
        --draw "text: 1.9,0.15 '\$\\tau=RC\$'              \
        angle=-77 scale=2 color=Blue"                      \
        --draw "marker: 1.5,0.05 OtherHand                 \
        angle=-45 scale=2 color=Blue"

 ctioga --multitext '[trig.dat@2]:[trigh.dat@2]' \
        -t "two files in one plot"

 ctioga --multitext '[trig.dat@2]:[trigh.dat@2] + [trig.dat@3]'   \
        -t "Some computation on different files"

 ctioga --multitext '[trig.dat@2]**2:[trigh.dat@2] * [trig.dat@3]'\
        -t "Some more computation on different files"

 ctioga --text-separator ';' trig.csv -t "CSV trigonometry"

 CTIOGA="--xpdf --clean-all --display-commandline" \
		export CTIOGA

 ctioga --viewer gv trig.dat

