# test_description.rb: the test suite for the description system.
# Copyright (C) 2006 Vincent Fourmond
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA


require 'MetaBuilder/metabuilder'
require 'test/unit'
require 'optparse'

class TestDescription < Test::Unit::TestCase

  include MetaBuilder

  class Described
    # Include support for descriptions
    include MetaBuilder::DescriptionInclude
    extend  MetaBuilder::DescriptionExtend

    describe 'biniou'
    param_accessor :size, 'size', "Size", {:type => :integer}, "The size ?"

    group 'dummy', "Dummy group", "A nice dummy group"
    param_accessor :group_size, 'groupsize', "Group Size", {:type => :integer},
    "The size ? in the group"

    attr_reader :a

    def initialize
      @size = 0
      @a = 0
    end

    def set_a(a)
      @a = 2 * a
    end

    def get_a
      return @a/2
    end
    param :set_a, :get_a, 'a', 'a', {:type => :integer}
  end

  def test_param_direct_access
    d = Described.new
    assert_equal(d.size, d.get_param_raw('size'))
    d.set_param('size', '123')
    assert_equal(d.get_param('size'), '123')
    d.set_param_raw('size', 56)
    assert_equal(d.size, 56)
  end

  def test_param_no_access_direct_access
    d = Described.new
    d.set_param('a', '24')
    assert_equal(d.a, 48)
    assert_equal(d.get_param('a'), '24')
  end

  def test_option_parser
    d = Described.new
    oo = OptionParser.new
    d.option_parser_options(oo, false)
    oo.parse!(["--size", "64",
               "--groupsize", "52"])
    assert_equal(d.size, 64)
    assert_equal(d.group_size, 52)
  end
  

  class Base
    include MetaBuilder::DescriptionInclude
    extend  MetaBuilder::DescriptionExtend

    create_factory

    describe 'biniou'

  end
  
  class Child1 < Base
    describe 'bidule'
  end

  class Child2 < Base
    describe 'truc'
  end

  def test_factory
    assert_equal(Child2.factory_class('bidule'), Child1)
    assert_equal(Child2.factory_class('truc'), Child2)
  end

end

