# smooth.rb : A simple averageing filter
# Copyright (C) 2006 Vincent Fourmond

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA

module SciYAG

  module Backends

    # A simple gaussian filter. You'd better give it an odd number.
    class SmoothFilter < Filter
      include Dobjects

      describe "smooth", "Smooth", "Simple gaussian-like convolution filter"

      init_param 'nb', "Number", Integer, 
      "The number of points over which to average"

      def initialize(nb) 
        nb = nb.to_i
        if nb < 2
          warn "Invalid parameter nb #{nb}, using 5"
          nb = 5
        end
        # initializes to binomial coefficients
        @kernel = Dvector.new(nb) { |i|
          SmoothFilter.cnk(nb,i)
        }
        @mid = nb - nb/2 - 1
      end


      # Binomial coefficients.
      def SmoothFilter.cnk(n,k)
        res = 1.0
        n.downto(n - k) { |i| res *= i}
        k.downto(1) {|i| res = res/i }
        return res
      end

      # There you go: a simple averageing filter.
      def apply(f)
        return Function.new(f.x, f.y.convolve(@kernel, @mid))
      end

      def apply!(f)
        f.y.replace(f.y.convolve(@kernel, @mid))
      end
    end
  end
end
