// generated by Fast Light User Interface Designer (fluid) version 1.0107

#include "CsoundGUI.hpp"

void CsoundPerformanceSettingsPanel::cb_window_i(Fl_Double_Window*, void*) {
  status = 1;
}
void CsoundPerformanceSettingsPanel::cb_window(Fl_Double_Window* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->user_data()))->cb_window_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_orcNameInput_i(Fl_Input* o, void*) {
  {
  CsoundGUIMain::stripString(performanceSettings.orcName, o->value());
  if (CsoundGUIMain::isCSDFile(performanceSettings.orcName)) {
    scoNameInput->deactivate();
    scoNameButton->deactivate();
    scoNameInput->value("");
  }
  else {
    scoNameInput->activate();
    scoNameButton->activate();
    scoNameInput->value(performanceSettings.scoName.c_str());
  }
};
}
void CsoundPerformanceSettingsPanel::cb_orcNameInput(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_orcNameInput_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_orcNameButton_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(performanceSettings.orcName, "Select orchestra or CSD file", CSOUND5GUI_FILETYPE_ORC_CSD, false);
  orcNameInput->value(performanceSettings.orcName.c_str());
  if (CsoundGUIMain::isCSDFile(performanceSettings.orcName)) {
    scoNameInput->deactivate();
    scoNameButton->deactivate();
    scoNameInput->value("");
  }
  else {
    scoNameInput->activate();
    scoNameButton->activate();
    scoNameInput->value(performanceSettings.scoName.c_str());
  }
};
}
void CsoundPerformanceSettingsPanel::cb_orcNameButton(Fl_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_orcNameButton_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_scoNameInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.scoName, o->value());
}
void CsoundPerformanceSettingsPanel::cb_scoNameInput(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_scoNameInput_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_scoNameButton_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(performanceSettings.scoName, "Select score file", CSOUND5GUI_FILETYPE_SCORE, false);
  scoNameInput->value(performanceSettings.scoName.c_str());
};
}
void CsoundPerformanceSettingsPanel::cb_scoNameButton(Fl_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_scoNameButton_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_lineInputDeviceInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.lineInput, o->value());
}
void CsoundPerformanceSettingsPanel::cb_lineInputDeviceInput(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_lineInputDeviceInput_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_lineInputDeviceButton_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(performanceSettings.lineInput, "Select line input device file", CSOUND5GUI_FILETYPE_ALL, false);
  lineInputDeviceInput->value(performanceSettings.lineInput.c_str());
};
}
void CsoundPerformanceSettingsPanel::cb_lineInputDeviceButton(Fl_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_lineInputDeviceButton_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_pluginLibsInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.pluginLibs, o->value());
}
void CsoundPerformanceSettingsPanel::cb_pluginLibsInput(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_pluginLibsInput_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_pluginLibsButton_i(Fl_Button*, void*) {
  {
  std::string tmp;
  tmp = "";
  if (CsoundGUIMain::browseFile(tmp, "Select a plugin library", CSOUND5GUI_FILETYPE_ALL, false)) {
    if (CsoundGUIMain::isEmptyString(performanceSettings.pluginLibs))
      performanceSettings.pluginLibs = tmp;
    else {
      CsoundGUIMain::stripString(performanceSettings.pluginLibs, (char*) 0);
      performanceSettings.pluginLibs += ',';
      performanceSettings.pluginLibs += tmp;
    }
  }
  pluginLibsInput->value(performanceSettings.pluginLibs.c_str());
};
}
void CsoundPerformanceSettingsPanel::cb_pluginLibsButton(Fl_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_pluginLibsButton_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Display_i(Fl_Choice* o, void*) {
  performanceSettings.displayMode = o->value() & 3;
}
void CsoundPerformanceSettingsPanel::cb_Display(Fl_Choice* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Display_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Message_i(Fl_Value_Input* o, void*) {
  performanceSettings.messageLevel = (int) (o->value() + 0.5) & 231;
}
void CsoundPerformanceSettingsPanel::cb_Message(Fl_Value_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Message_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Heartbeat_i(Fl_Choice* o, void*) {
  performanceSettings.heartBeatMode = o->value() & 7;
}
void CsoundPerformanceSettingsPanel::cb_Heartbeat(Fl_Choice* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Heartbeat_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Verbose_i(Fl_Check_Button* o, void*) {
  performanceSettings.verbose = (o->value() == 0 ? false : true);
}
void CsoundPerformanceSettingsPanel::cb_Verbose(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Verbose_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_sampleRateInput_i(Fl_Value_Input* o, void*) {
  {
  performanceSettings.sampleRateOverride = o->value();
  if (performanceSettings.sampleRateOverride <= 0.0) {
    performanceSettings.controlRateOverride = -1.0;
    controlRateInput->value(performanceSettings.controlRateOverride);
  }
  else if (performanceSettings.controlRateOverride <= 0.0) {
    performanceSettings.controlRateOverride = performanceSettings.sampleRateOverride;
    controlRateInput->value(performanceSettings.controlRateOverride);
  }
};
}
void CsoundPerformanceSettingsPanel::cb_sampleRateInput(Fl_Value_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_sampleRateInput_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_controlRateInput_i(Fl_Value_Input* o, void*) {
  {
  performanceSettings.controlRateOverride = o->value();
  if (performanceSettings.controlRateOverride <= 0.0) {
    performanceSettings.sampleRateOverride = -1.0;
    sampleRateInput->value(performanceSettings.sampleRateOverride);
  }
  else if (performanceSettings.sampleRateOverride <= 0.0) {
    performanceSettings.sampleRateOverride = performanceSettings.controlRateOverride;
    sampleRateInput->value(performanceSettings.sampleRateOverride);
  }
};
}
void CsoundPerformanceSettingsPanel::cb_controlRateInput(Fl_Value_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_controlRateInput_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Score_i(Fl_Value_Input* o, void*) {
  {
  performanceSettings.scoreOffsetSeconds = o->value();
  if (performanceSettings.scoreOffsetSeconds < 0.0)
    performanceSettings.scoreOffsetSeconds = 0.0;
};
}
void CsoundPerformanceSettingsPanel::cb_Score(Fl_Value_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Score_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Initial_i(Fl_Value_Input* o, void*) {
  performanceSettings.beatModeTempo = o->value();
}
void CsoundPerformanceSettingsPanel::cb_Initial(Fl_Value_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Initial_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_String_i(Fl_Value_Input* o, void*) {
  performanceSettings.maxStrLen = (int) (o->value() + 0.5);
}
void CsoundPerformanceSettingsPanel::cb_String(Fl_Value_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_String_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Optimize_i(Fl_Check_Button* o, void*) {
  performanceSettings.enableExpressionOpt = (o->value() == 0 ? false : true);
}
void CsoundPerformanceSettingsPanel::cb_Optimize(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Optimize_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Skip_i(Fl_Check_Button* o, void*) {
  performanceSettings.ignoreCSDOptions = (o->value() == 0 ? false : true);
}
void CsoundPerformanceSettingsPanel::cb_Skip(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Skip_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_I_i(Fl_Check_Button* o, void*) {
  performanceSettings.iTimeOnly = (o->value() == 0 ? false : true);
}
void CsoundPerformanceSettingsPanel::cb_I(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_I_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Defer_i(Fl_Check_Button* o, void*) {
  performanceSettings.deferGEN1 = (o->value() == 0 ? false : true);
}
void CsoundPerformanceSettingsPanel::cb_Defer(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Defer_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_useAdditionalFlagsToggle_i(Fl_Check_Button* o, void*) {
  performanceSettings.useAdditionalFlags = (o->value() == 0 ? false : true);
if (o->value() == 1)
  additionalFlagsInput->activate();
else
  additionalFlagsInput->deactivate();
}
void CsoundPerformanceSettingsPanel::cb_useAdditionalFlagsToggle(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_useAdditionalFlagsToggle_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_additionalFlagsInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.additionalFlags, o->value());
}
void CsoundPerformanceSettingsPanel::cb_additionalFlagsInput(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_additionalFlagsInput_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_inputFileBox_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.inputFileName, o->value());
}
void CsoundPerformanceSettingsPanel::cb_inputFileBox(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_inputFileBox_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb__i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(performanceSettings.inputFileName, "Select input sound file", CSOUND5GUI_FILETYPE_AUDIO, false);
  inputFileBox->value(performanceSettings.inputFileName.c_str());
};
}
void CsoundPerformanceSettingsPanel::cb_(Fl_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb__i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_outputFileBox_i(Fl_Input* o, void*) {
  if (!performanceSettings.runRealtime)
  CsoundGUIMain::stripString(performanceSettings.outputFileName, o->value());
}
void CsoundPerformanceSettingsPanel::cb_outputFileBox(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_outputFileBox_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_1_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(performanceSettings.outputFileName, "Select output sound file", CSOUND5GUI_FILETYPE_AUDIO, true);
  outputFileBox->value(performanceSettings.outputFileName.c_str());
};
}
void CsoundPerformanceSettingsPanel::cb_1(Fl_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_1_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_File_i(Fl_Choice* o, void*) {
  performanceSettings.soundFileType = performanceSettings.indexToFileType(o->value());
}
void CsoundPerformanceSettingsPanel::cb_File(Fl_Choice* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_File_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Sample_i(Fl_Choice* o, void*) {
  performanceSettings.soundSampleFormat = performanceSettings.indexToSampleFormat(o->value());
}
void CsoundPerformanceSettingsPanel::cb_Sample(Fl_Choice* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_Sample_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Peak_i(Fl_Check_Button* o, void*) {
  performanceSettings.enablePeakChunks = (o->value() == 0 ? false : true);
}
void CsoundPerformanceSettingsPanel::cb_Peak(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_Peak_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Enable_i(Fl_Check_Button* o, void*) {
  performanceSettings.enableDither = (o->value() == 0 ? false : true);
}
void CsoundPerformanceSettingsPanel::cb_Enable(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_Enable_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Rewrite_i(Fl_Check_Button* o, void*) {
  performanceSettings.rewriteHeader = (o->value() == 0 ? false : true);
}
void CsoundPerformanceSettingsPanel::cb_Rewrite(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_Rewrite_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Artist_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.sndidArtist, o->value());
}
void CsoundPerformanceSettingsPanel::cb_Artist(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Artist_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Comment_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.sndidComment, o->value());
}
void CsoundPerformanceSettingsPanel::cb_Comment(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Comment_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Copyright_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.sndidCopyright, o->value());
}
void CsoundPerformanceSettingsPanel::cb_Copyright(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Copyright_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Date_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.sndidDate, o->value());
}
void CsoundPerformanceSettingsPanel::cb_Date(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Date_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Software_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.sndidSoftware, o->value());
}
void CsoundPerformanceSettingsPanel::cb_Software(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Software_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Title_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.sndidTitle, o->value());
}
void CsoundPerformanceSettingsPanel::cb_Title(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Title_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Do_i(Fl_Check_Button* o, void*) {
  performanceSettings.disableDiskOutput = (o->value() == 0 ? false : true);
}
void CsoundPerformanceSettingsPanel::cb_Do(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_Do_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Buffer_i(Fl_Choice* o, void*) {
  {
  performanceSettings.bufFrames_SW = (1 << ((int) o->value() + 3));
  if (performanceSettings.bufFrames_SW < 16)
    numBuffersInput->deactivate();
  else
    numBuffersInput->activate();
};
}
void CsoundPerformanceSettingsPanel::cb_Buffer(Fl_Choice* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_Buffer_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_numBuffersInput_i(Fl_Spinner* o, void*) {
  performanceSettings.nBuffers = (int) (o->value() + 0.5);
}
void CsoundPerformanceSettingsPanel::cb_numBuffersInput(Fl_Spinner* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_numBuffersInput_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Perform_i(Fl_Check_Button* o, void*) {
  performanceSettings.useThreads = (o->value() == 0 ? false : true);
}
void CsoundPerformanceSettingsPanel::cb_Perform(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_Perform_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_rtAudioInputDeviceInput_i(Fl_Input_Choice* o, void*) {
  Fl_Menu_Button *button_ = o->menubutton();
Fl_Input *input_ = o->input();
if (!button_->text()) return;
if ( strcmp(button_->text(),input_->value()) == 0 or button_->changed() )
  makeAudioDeviceName(std::string(o->value()), true);
else
  CsoundGUIMain::stripString(performanceSettings.rtAudioInputDevice, input_->value());
}
void CsoundPerformanceSettingsPanel::cb_rtAudioInputDeviceInput(Fl_Input_Choice* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_rtAudioInputDeviceInput_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_rtAudioOutputDeviceInput_i(Fl_Input_Choice* o, void*) {
  Fl_Menu_Button *button_ = o->menubutton();
Fl_Input *input_ = o->input();
if (!button_->text()) return;
if ( strcmp(button_->text(),input_->value()) == 0 or button_->changed() )
  makeAudioDeviceName(std::string(o->value()), false);
else
  CsoundGUIMain::stripString(performanceSettings.rtAudioOutputDevice, input_->value());
}
void CsoundPerformanceSettingsPanel::cb_rtAudioOutputDeviceInput(Fl_Input_Choice* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_rtAudioOutputDeviceInput_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_jackClientNameInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.jackClientName, o->value());
}
void CsoundPerformanceSettingsPanel::cb_jackClientNameInput(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_jackClientNameInput_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_rtAudioModuleInput_i(Fl_Choice* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.rtAudioModule,
                           rtAudioModules[o->value()].c_str());
querySoundDevices();
rtAudioOutputDeviceInput->value("dac");
rtAudioInputDeviceInput->value("adc");
performanceSettings.rtAudioOutputDevice = "dac";
performanceSettings.rtAudioInputDevice = "adc";
}
void CsoundPerformanceSettingsPanel::cb_rtAudioModuleInput(Fl_Choice* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_rtAudioModuleInput_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_midiInFileNameInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.midiInFileName, o->value());
}
void CsoundPerformanceSettingsPanel::cb_midiInFileNameInput(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_midiInFileNameInput_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_2_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(performanceSettings.midiInFileName, "Select MIDI input file", CSOUND5GUI_FILETYPE_MIDI, false);
  midiInFileNameInput->value(performanceSettings.midiInFileName.c_str());
};
}
void CsoundPerformanceSettingsPanel::cb_2(Fl_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_2_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Mute_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.midiFileMuteTracks, o->value());
}
void CsoundPerformanceSettingsPanel::cb_Mute(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Mute_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Terminate_i(Fl_Check_Button* o, void*) {
  performanceSettings.terminateOnMidi = (o->value() == 0 ? false : true);
}
void CsoundPerformanceSettingsPanel::cb_Terminate(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_Terminate_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_midiOutFileNameInput_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.midiOutFileName, o->value());
}
void CsoundPerformanceSettingsPanel::cb_midiOutFileNameInput(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_midiOutFileNameInput_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_3_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(performanceSettings.midiOutFileName, "Select MIDI output file", CSOUND5GUI_FILETYPE_MIDI, true);
  midiOutFileNameInput->value(performanceSettings.midiOutFileName.c_str());
};
}
void CsoundPerformanceSettingsPanel::cb_3(Fl_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_3_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_rtMidiModulesChoice_i(Fl_Choice* o, void*) {
  performanceSettings.rtMidiModule = rtMidiModules[o->value()];
queryMidiDevices();
if (performanceSettings.rtMidiModule == "virtual") {
  rtMidiOutputDeviceInput->value("0");
  rtMidiInputDeviceInput->value("0");
  performanceSettings.midiOutDevName = "0";
  performanceSettings.midiInDevName = "0";
}
else {
  rtMidiOutputDeviceInput->value("Set device here");
  rtMidiInputDeviceInput->value("Set device here");
  performanceSettings.midiOutDevName = "";
  performanceSettings.midiInDevName = "";
};
}
void CsoundPerformanceSettingsPanel::cb_rtMidiModulesChoice(Fl_Choice* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_rtMidiModulesChoice_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_rtMidiInputDeviceInput_i(Fl_Input_Choice* o, void*) {
  Fl_Menu_Button *button_ = o->menubutton();
Fl_Input *input_ = o->input();
if (!button_->text()) return;
if ( strcmp(button_->text(),input_->value()) == 0 or button_->changed() )
  makeMidiDeviceName(std::string(o->value()), true);
else
  CsoundGUIMain::stripString(performanceSettings.midiInDevName, input_->value());
}
void CsoundPerformanceSettingsPanel::cb_rtMidiInputDeviceInput(Fl_Input_Choice* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_rtMidiInputDeviceInput_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_rtMidiOutputDeviceInput_i(Fl_Input_Choice* o, void*) {
  Fl_Menu_Button *button_ = o->menubutton();
Fl_Input *input_ = o->input();
if (!button_->text()) return;
if ( strcmp(button_->text(),input_->value()) == 0 or button_->changed() )
  makeMidiDeviceName(std::string(o->value()), false);
else
  CsoundGUIMain::stripString(performanceSettings.midiOutDevName, input_->value());
}
void CsoundPerformanceSettingsPanel::cb_rtMidiOutputDeviceInput(Fl_Input_Choice* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_rtMidiOutputDeviceInput_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Raw_i(Fl_Check_Button* o, void*) {
  performanceSettings.rawControllerMode = (o->value() == 0 ? false : true);
}
void CsoundPerformanceSettingsPanel::cb_Raw(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->user_data()))->cb_Raw_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_midiKeyMidiSpinner_i(Fl_Spinner* o, void*) {
  performanceSettings.midiKeyMidi = (int) o->value();
}
void CsoundPerformanceSettingsPanel::cb_midiKeyMidiSpinner(Fl_Spinner* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_midiKeyMidiSpinner_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_midiKeyMidiOn_i(Fl_Check_Button* o, void*) {
  if (o->value() == 1) {
midiKeyCpsOn->clear();
midiKeyOctOn->clear();
midiKeyPchOn->clear();
}
updateGUIState_Midi();
}
void CsoundPerformanceSettingsPanel::cb_midiKeyMidiOn(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_midiKeyMidiOn_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_midiKeyCpsSpinner_i(Fl_Spinner* o, void*) {
  performanceSettings.midiKeyCps = (int) o->value();
}
void CsoundPerformanceSettingsPanel::cb_midiKeyCpsSpinner(Fl_Spinner* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_midiKeyCpsSpinner_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_midiKeyCpsOn_i(Fl_Check_Button* o, void*) {
  if (o->value() == 1) {
midiKeyMidiOn->clear();
midiKeyOctOn->clear();
midiKeyPchOn->clear();
}
updateGUIState_Midi();
}
void CsoundPerformanceSettingsPanel::cb_midiKeyCpsOn(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_midiKeyCpsOn_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_midiKeyOctSpinner_i(Fl_Spinner* o, void*) {
  performanceSettings.midiKeyOct = (int) o->value();
}
void CsoundPerformanceSettingsPanel::cb_midiKeyOctSpinner(Fl_Spinner* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_midiKeyOctSpinner_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_midiKeyOctOn_i(Fl_Check_Button* o, void*) {
  if (o->value() == 1) {
midiKeyMidiOn->clear();
midiKeyCpsOn->clear();
midiKeyPchOn->clear();
}
updateGUIState_Midi();
}
void CsoundPerformanceSettingsPanel::cb_midiKeyOctOn(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_midiKeyOctOn_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_midiKeyPchSpinner_i(Fl_Spinner* o, void*) {
  performanceSettings.midiKeyPch = (int) o->value();
}
void CsoundPerformanceSettingsPanel::cb_midiKeyPchSpinner(Fl_Spinner* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_midiKeyPchSpinner_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_midiKeyPchOn_i(Fl_Check_Button* o, void*) {
  if (o->value() == 1) {
midiKeyMidiOn->clear();
midiKeyCpsOn->clear();
midiKeyOctOn->clear();
}
updateGUIState_Midi();
}
void CsoundPerformanceSettingsPanel::cb_midiKeyPchOn(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_midiKeyPchOn_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_midiVelMidiSpinner_i(Fl_Spinner* o, void*) {
  performanceSettings.midiVelMidi = (int) o->value();
}
void CsoundPerformanceSettingsPanel::cb_midiVelMidiSpinner(Fl_Spinner* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_midiVelMidiSpinner_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_midiVelMidiOn_i(Fl_Check_Button* o, void*) {
  if (o->value() == 1) {
midiVelAmpOn->clear();
}
updateGUIState_Midi();
}
void CsoundPerformanceSettingsPanel::cb_midiVelMidiOn(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_midiVelMidiOn_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_midiVelAmpSpinner_i(Fl_Spinner* o, void*) {
  performanceSettings.midiVelAmp = (int) o->value();
}
void CsoundPerformanceSettingsPanel::cb_midiVelAmpSpinner(Fl_Spinner* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_midiVelAmpSpinner_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_midiVelAmpOn_i(Fl_Check_Button* o, void*) {
  if (o->value() == 1) {
midiVelMidiOn->clear();
}
updateGUIState_Midi();
}
void CsoundPerformanceSettingsPanel::cb_midiVelAmpOn(Fl_Check_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_midiVelAmpOn_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_sadirBox_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.sadirPath, o->value());
}
void CsoundPerformanceSettingsPanel::cb_sadirBox(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_sadirBox_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_4_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(performanceSettings.sadirPath, "Select directory for analysis files", CSOUND5GUI_FILETYPE_DIRECTORY, false);
  sadirBox->value(performanceSettings.sadirPath.c_str());
};
}
void CsoundPerformanceSettingsPanel::cb_4(Fl_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_4_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_ssdirBox_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.ssdirPath, o->value());
}
void CsoundPerformanceSettingsPanel::cb_ssdirBox(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_ssdirBox_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_5_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(performanceSettings.ssdirPath, "Select directory for sound file input", CSOUND5GUI_FILETYPE_DIRECTORY, false);
  ssdirBox->value(performanceSettings.ssdirPath.c_str());
};
}
void CsoundPerformanceSettingsPanel::cb_5(Fl_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_5_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_sfdirBox_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.sfdirPath, o->value());
}
void CsoundPerformanceSettingsPanel::cb_sfdirBox(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_sfdirBox_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_6_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(performanceSettings.sfdirPath, "Select directory for sound file output", CSOUND5GUI_FILETYPE_DIRECTORY, false);
  sfdirBox->value(performanceSettings.sfdirPath.c_str());
};
}
void CsoundPerformanceSettingsPanel::cb_6(Fl_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_6_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_incdirBox_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.incdirPath, o->value());
}
void CsoundPerformanceSettingsPanel::cb_incdirBox(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_incdirBox_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_7_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(performanceSettings.incdirPath, "Select directory for include files", CSOUND5GUI_FILETYPE_DIRECTORY, false);
  incdirBox->value(performanceSettings.incdirPath.c_str());
};
}
void CsoundPerformanceSettingsPanel::cb_7(Fl_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_7_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_csdocdirBox_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.csdocdirPath, o->value());
}
void CsoundPerformanceSettingsPanel::cb_csdocdirBox(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_csdocdirBox_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_8_i(Fl_Button*, void*) {
  {
  CsoundGUIMain::browseFile(performanceSettings.csdocdirPath, "Select directory for include files", CSOUND5GUI_FILETYPE_DIRECTORY, false);
  csdocdirBox->value(performanceSettings.csdocdirPath.c_str());
};
}
void CsoundPerformanceSettingsPanel::cb_8(Fl_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_8_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_11_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.strsets[0], o->value());
}
void CsoundPerformanceSettingsPanel::cb_11(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_11_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_21_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.strsets[1], o->value());
}
void CsoundPerformanceSettingsPanel::cb_21(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_21_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_31_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.strsets[2], o->value());
}
void CsoundPerformanceSettingsPanel::cb_31(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_31_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_41_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.strsets[3], o->value());
}
void CsoundPerformanceSettingsPanel::cb_41(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_41_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_51_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.strsets[4], o->value());
}
void CsoundPerformanceSettingsPanel::cb_51(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_51_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_61_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.strsets[5], o->value());
}
void CsoundPerformanceSettingsPanel::cb_61(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_61_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_71_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.strsets[6], o->value());
}
void CsoundPerformanceSettingsPanel::cb_71(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_71_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_81_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.strsets[7], o->value());
}
void CsoundPerformanceSettingsPanel::cb_81(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_81_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_9_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.strsets[8], o->value());
}
void CsoundPerformanceSettingsPanel::cb_9(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_9_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_10_i(Fl_Input* o, void*) {
  CsoundGUIMain::stripString(performanceSettings.strsets[9], o->value());
}
void CsoundPerformanceSettingsPanel::cb_10(Fl_Input* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_10_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_OK_i(Fl_Button*, void*) {
  status = 1;
}
void CsoundPerformanceSettingsPanel::cb_OK(Fl_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->user_data()))->cb_OK_i(o,v);
}

void CsoundPerformanceSettingsPanel::cb_Cancel_i(Fl_Button*, void*) {
  status = -1;
}
void CsoundPerformanceSettingsPanel::cb_Cancel(Fl_Button* o, void* v) {
  ((CsoundPerformanceSettingsPanel*)(o->parent()->user_data()))->cb_Cancel_i(o,v);
}

CsoundPerformanceSettingsPanel::CsoundPerformanceSettingsPanel(CsoundPerformanceSettings& p) {
  Fl_Double_Window* w;
  {
  status = 0;
  window = (Fl_Double_Window*) 0;
  performanceSettings = p;
}
  { Fl_Double_Window* o = window = new Fl_Double_Window(405, 540, "Csound performance settings");
    w = o;
    o->color((Fl_Color)139);
    o->callback((Fl_Callback*)cb_window, (void*)(this));
    { Fl_Tabs* o = tabs = new Fl_Tabs(0, 0, 405, 505);
      o->box(FL_PLASTIC_THIN_UP_BOX);
      o->color((Fl_Color)139);
      o->selection_color((Fl_Color)55);
      { Fl_Group* o = new Fl_Group(0, 25, 405, 480, "General");
        o->color((Fl_Color)139);
        { Fl_Input* o = orcNameInput = new Fl_Input(10, 45, 220, 25, "Orchestra/CSD");
          o->box(FL_THIN_DOWN_BOX);
          o->callback((Fl_Callback*)cb_orcNameInput);
          o->align(FL_ALIGN_RIGHT);
          o->value(performanceSettings.orcName.c_str());
        }
        { Fl_Button* o = orcNameButton = new Fl_Button(345, 45, 25, 25, "...");
          o->tooltip("Browse orchestra or CSD file");
          o->box(FL_PLASTIC_UP_BOX);
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_orcNameButton);
        }
        { Fl_Input* o = scoNameInput = new Fl_Input(10, 80, 220, 25, "Score file");
          o->box(FL_THIN_DOWN_BOX);
          o->callback((Fl_Callback*)cb_scoNameInput);
          o->align(FL_ALIGN_RIGHT);
          if (CsoundGUIMain::isCSDFile(performanceSettings.orcName)) { o->deactivate(); o->value(""); } else { o->activate(); o->value(performanceSettings.scoName.c_str()); }
        }
        { Fl_Button* o = scoNameButton = new Fl_Button(345, 80, 25, 25, "...");
          o->tooltip("Browse score file");
          o->box(FL_PLASTIC_UP_BOX);
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_scoNameButton);
          if (CsoundGUIMain::isCSDFile(performanceSettings.orcName)) o->deactivate();
        }
        { Fl_Input* o = lineInputDeviceInput = new Fl_Input(10, 115, 220, 25, "Line input");
          o->tooltip("Line input device (stdin for standard input)");
          o->box(FL_THIN_DOWN_BOX);
          o->callback((Fl_Callback*)cb_lineInputDeviceInput);
          o->align(FL_ALIGN_RIGHT);
          o->value(performanceSettings.lineInput.c_str());
        }
        { Fl_Button* o = lineInputDeviceButton = new Fl_Button(345, 115, 25, 25, "...");
          o->tooltip("Browse line input device file");
          o->box(FL_PLASTIC_UP_BOX);
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_lineInputDeviceButton);
        }
        { Fl_Input* o = pluginLibsInput = new Fl_Input(10, 150, 220, 25, "Plugin libraries");
          o->tooltip("Comma separated list of additional plugins to load");
          o->box(FL_THIN_DOWN_BOX);
          o->callback((Fl_Callback*)cb_pluginLibsInput);
          o->align(FL_ALIGN_RIGHT);
          o->value(performanceSettings.pluginLibs.c_str());
        }
        { Fl_Button* o = pluginLibsButton = new Fl_Button(345, 150, 25, 25, "...");
          o->tooltip("Browse plugin library");
          o->box(FL_PLASTIC_UP_BOX);
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_pluginLibsButton);
        }
        { Fl_Group* o = new Fl_Group(10, 185, 385, 215);
          o->box(FL_PLASTIC_UP_FRAME);
          { Fl_Choice* o = new Fl_Choice(20, 195, 75, 25, "Display mode");
            o->box(FL_THIN_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->callback((Fl_Callback*)cb_Display);
            o->align(FL_ALIGN_RIGHT);
            o->add("None|Full|ASCII|PostScript");
            o->value(performanceSettings.displayMode);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(205, 195, 60, 25, "Message level");
            o->box(FL_THIN_DOWN_BOX);
            o->maximum(231);
            o->step(1);
            o->callback((Fl_Callback*)cb_Message);
            o->align(FL_ALIGN_RIGHT);
            o->value((double) performanceSettings.messageLevel);
          }
          { Fl_Choice* o = new Fl_Choice(20, 230, 75, 25, "Heartbeat");
            o->box(FL_THIN_DOWN_BOX);
            o->down_box(FL_BORDER_BOX);
            o->callback((Fl_Callback*)cb_Heartbeat);
            o->align(FL_ALIGN_RIGHT);
            o->add("None|Bar|Dot|Time|Bell");
            o->value(performanceSettings.heartBeatMode);
          }
          { Fl_Check_Button* o = new Fl_Check_Button(205, 230, 20, 25, "Verbose messages");
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Verbose);
            o->value(performanceSettings.verbose ? 1 : 0);
          }
          { Fl_Value_Input* o = sampleRateInput = new Fl_Value_Input(20, 265, 75, 25, "Sample rate");
            o->tooltip("Sample rate override (<= 0: none) (-r)");
            o->box(FL_THIN_DOWN_BOX);
            o->minimum(-1);
            o->maximum(1e+06);
            o->callback((Fl_Callback*)cb_sampleRateInput);
            o->align(FL_ALIGN_RIGHT);
            o->when(FL_WHEN_RELEASE);
            o->value(performanceSettings.sampleRateOverride);
          }
          { Fl_Value_Input* o = controlRateInput = new Fl_Value_Input(205, 265, 75, 25, "Control rate");
            o->tooltip("Control rate override (<= 0: none) (-k)");
            o->box(FL_THIN_DOWN_BOX);
            o->minimum(-1);
            o->maximum(1e+06);
            o->callback((Fl_Callback*)cb_controlRateInput);
            o->align(FL_ALIGN_RIGHT);
            o->when(FL_WHEN_RELEASE);
            o->value(performanceSettings.controlRateOverride);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(20, 300, 75, 25, "Score offset");
            o->tooltip("Score offset in seconds (-+skip_seconds=)");
            o->box(FL_THIN_DOWN_BOX);
            o->maximum(10000);
            o->callback((Fl_Callback*)cb_Score);
            o->align(FL_ALIGN_RIGHT);
            o->value(performanceSettings.scoreOffsetSeconds);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(205, 300, 75, 25, "Initial tempo");
            o->tooltip("If greater than zero, enable beat mode with this initial tempo (EXPERIMENTAL)\
 (-t)");
            o->box(FL_THIN_DOWN_BOX);
            o->minimum(-1);
            o->maximum(10000);
            o->callback((Fl_Callback*)cb_Initial);
            o->align(FL_ALIGN_RIGHT);
            o->value(performanceSettings.beatModeTempo);
          }
          { Fl_Value_Input* o = new Fl_Value_Input(20, 335, 75, 25, "String length");
            o->tooltip("Maximum length of string variables (-+max_str_len= )");
            o->box(FL_THIN_DOWN_BOX);
            o->minimum(9);
            o->maximum(9999);
            o->step(1);
            o->callback((Fl_Callback*)cb_String);
            o->align(FL_ALIGN_RIGHT);
            o->value((double) performanceSettings.maxStrLen);
          }
          { Fl_Check_Button* o = new Fl_Check_Button(205, 335, 20, 25, "Optimize expressions");
            o->tooltip("Enable experimental optimization of orchestra expressions (--expression-opt)");
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Optimize);
            o->value(performanceSettings.enableExpressionOpt ? 1 : 0);
          }
          { Fl_Check_Button* o = new Fl_Check_Button(20, 370, 25, 25, "Skip CsOptions");
            o->tooltip("Ignore command line flags specified in CSD files");
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Skip);
            o->value(performanceSettings.ignoreCSDOptions ? 1 : 0);
          }
          { Fl_Check_Button* o = new Fl_Check_Button(155, 370, 20, 25, "I-time only");
            o->tooltip("Init time only performace. No audio output (-I)");
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_I);
            o->value(performanceSettings.iTimeOnly ? 1 : 0);
          }
          { Fl_Check_Button* o = new Fl_Check_Button(260, 370, 20, 25, "Defer GEN01");
            o->tooltip("Defer GEN01 sound file loads (-D)");
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Defer);
            o->value(performanceSettings.deferGEN1 ? 1 : 0);
          }
          o->end();
        }
        { Fl_Group* o = new Fl_Group(10, 415, 385, 60);
          o->box(FL_PLASTIC_UP_FRAME);
          { Fl_Check_Button* o = useAdditionalFlagsToggle = new Fl_Check_Button(15, 445, 20, 15);
            o->tooltip("Enables the use of additional command line flags");
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_useAdditionalFlagsToggle);
            o->value(performanceSettings.useAdditionalFlags? 1 : 0);
          }
          { Fl_Input* o = additionalFlagsInput = new Fl_Input(35, 440, 340, 25, "Additional command line flags");
            o->tooltip("Type any addtional command line flags to be used");
            o->callback((Fl_Callback*)cb_additionalFlagsInput);
            o->align(FL_ALIGN_TOP);
            o->deactivate();
            if (performanceSettings.useAdditionalFlags) o->activate();
            o->value(performanceSettings.additionalFlags.c_str());
          }
          o->end();
        }
        o->end();
      }
      { Fl_Group* o = new Fl_Group(0, 25, 400, 460, "File I/O");
        o->color((Fl_Color)139);
        o->hide();
        { Fl_Input* o = inputFileBox = new Fl_Input(10, 45, 260, 25, "Input file");
          o->tooltip("Name of input file (-i)");
          o->box(FL_THIN_DOWN_BOX);
          o->callback((Fl_Callback*)cb_inputFileBox);
          o->align(FL_ALIGN_RIGHT);
          o->value(performanceSettings.inputFileName.c_str());
        }
        { Fl_Button* o = new Fl_Button(355, 45, 25, 25, "...");
          o->tooltip("Browse input sound file");
          o->box(FL_PLASTIC_UP_BOX);
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_);
        }
        { Fl_Input* o = outputFileBox = new Fl_Input(10, 80, 260, 25, "Output file");
          o->tooltip("Name of output file (-o)");
          o->box(FL_THIN_DOWN_BOX);
          o->callback((Fl_Callback*)cb_outputFileBox);
          o->align(FL_ALIGN_RIGHT);
          if (CsoundGUIMain::isRtAudioDevice(performanceSettings.outputFileName, true))
          o->value("test");
          else
          o->value(performanceSettings.outputFileName.c_str());
        }
        { Fl_Button* o = new Fl_Button(355, 80, 25, 25, "...");
          o->tooltip("Browse output sound file");
          o->box(FL_PLASTIC_UP_BOX);
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_1);
        }
        { Fl_Choice* o = new Fl_Choice(10, 125, 80, 25, "File type");
          o->tooltip("Output File type");
          o->box(FL_THIN_DOWN_BOX);
          o->down_box(FL_BORDER_BOX);
          o->callback((Fl_Callback*)cb_File);
          o->align(FL_ALIGN_RIGHT);
          for (int i = 0; performanceSettings.indexToFileType(i) != (char*) 0; i++) o->add(performanceSettings.indexToFileType(i));
          o->value(performanceSettings.fileTypeToIndex(performanceSettings.soundFileType.c_str()));
        }
        { Fl_Choice* o = new Fl_Choice(175, 125, 80, 25, "Sample format");
          o->tooltip("Output File format");
          o->box(FL_THIN_DOWN_BOX);
          o->down_box(FL_BORDER_BOX);
          o->callback((Fl_Callback*)cb_Sample);
          o->align(FL_ALIGN_RIGHT);
          for (int i = 0; performanceSettings.indexToSampleFormat(i) != (char*) 0; i++) o->add(performanceSettings.indexToSampleFormat(i));
          o->value(performanceSettings.sampleFormatToIndex(performanceSettings.soundSampleFormat.c_str()));
        }
        { Fl_Check_Button* o = new Fl_Check_Button(10, 160, 20, 25, "Peak chunks");
          o->tooltip("Write peak chunks in file header (opposite of -K)");
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_Peak);
          o->value(performanceSettings.enablePeakChunks ? 1 : 0);
        }
        { Fl_Check_Button* o = new Fl_Check_Button(135, 160, 20, 25, "Enable dither");
          o->tooltip("Switch on dithering of output (-Z)");
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_Enable);
          o->value(performanceSettings.enableDither ? 1 : 0);
        }
        { Fl_Check_Button* o = new Fl_Check_Button(260, 160, 20, 25, "Rewrite header");
          o->tooltip("Continually rewrite the header to WAV or AIFF output soundfiles  (-R)");
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_Rewrite);
          o->value(performanceSettings.rewriteHeader ? 1 : 0);
        }
        { Fl_Group* o = new Fl_Group(10, 245, 380, 225, "Soundfile tags");
          o->box(FL_PLASTIC_UP_FRAME);
          o->align(FL_ALIGN_TOP_LEFT);
          { Fl_Input* o = new Fl_Input(20, 255, 290, 25, "Artist");
            o->box(FL_THIN_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Artist);
            o->align(FL_ALIGN_RIGHT);
            o->value(performanceSettings.sndidArtist.c_str());
          }
          { Fl_Input* o = new Fl_Input(20, 290, 290, 25, "Comment");
            o->box(FL_THIN_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Comment);
            o->align(FL_ALIGN_RIGHT);
            o->value(performanceSettings.sndidComment.c_str());
          }
          { Fl_Input* o = new Fl_Input(20, 325, 290, 25, "Copyright");
            o->box(FL_THIN_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Copyright);
            o->align(FL_ALIGN_RIGHT);
            o->value(performanceSettings.sndidCopyright.c_str());
          }
          { Fl_Input* o = new Fl_Input(20, 360, 290, 25, "Date");
            o->box(FL_THIN_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Date);
            o->align(FL_ALIGN_RIGHT);
            o->value(performanceSettings.sndidDate.c_str());
          }
          { Fl_Input* o = new Fl_Input(20, 395, 290, 25, "Software");
            o->box(FL_THIN_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Software);
            o->align(FL_ALIGN_RIGHT);
            o->value(performanceSettings.sndidSoftware.c_str());
          }
          { Fl_Input* o = new Fl_Input(20, 430, 290, 25, "Title");
            o->box(FL_THIN_DOWN_BOX);
            o->callback((Fl_Callback*)cb_Title);
            o->align(FL_ALIGN_RIGHT);
            o->value(performanceSettings.sndidTitle.c_str());
          }
          o->end();
        }
        { Fl_Check_Button* o = new Fl_Check_Button(10, 190, 20, 25, "Do not write output to disk");
          o->tooltip("Do not write sound output to disk (-n)");
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_Do);
          o->value(performanceSettings.disableDiskOutput ? 1 : 0);
        }
        o->end();
      }
      { Fl_Group* o = RTaudioTab = new Fl_Group(0, 25, 400, 480, "Real time audio");
        o->color((Fl_Color)139);
        o->hide();
        { Fl_Choice* o = new Fl_Choice(10, 230, 80, 25, "Buffer size in sample frames (-b)");
          o->tooltip("Set software buffer size (-b)");
          o->box(FL_THIN_DOWN_BOX);
          o->down_box(FL_BORDER_BOX);
          o->callback((Fl_Callback*)cb_Buffer);
          o->align(FL_ALIGN_RIGHT);
          o->add("default|16|32|64|128|256|512|1024|2048|4096|8192|16384");
          o->value((int) (std::log((double) performanceSettings.bufFrames_SW) / std::log(2.0) + 0.5) - 3);
        }
        { Fl_Spinner* o = numBuffersInput = new Fl_Spinner(10, 265, 80, 25, "Number of buffers");
          o->tooltip("Number of software buffers for hardware buffer (-B / -b)");
          o->box(FL_THIN_DOWN_BOX);
          o->callback((Fl_Callback*)cb_numBuffersInput);
          o->align(FL_ALIGN_RIGHT);
          o->range(2.0, 64.0);
          o->step(1.0);
          o->value((double) performanceSettings.nBuffers);
          if (performanceSettings.bufFrames_SW < 16) o->deactivate();
        }
        { Fl_Check_Button* o = new Fl_Check_Button(10, 305, 20, 25, "Perform in a separate thread");
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->callback((Fl_Callback*)cb_Perform);
          o->value(performanceSettings.useThreads ? 1 : 0);
        }
        { Fl_Input_Choice* o = rtAudioInputDeviceInput = new Fl_Input_Choice(10, 140, 380, 25, "Input Device");
          o->tooltip("Select realtime Audio Input device from list, or type directly in text field");
          o->callback((Fl_Callback*)cb_rtAudioInputDeviceInput);
          o->align(FL_ALIGN_TOP);
          o->when(3);
        }
        { Fl_Input_Choice* o = rtAudioOutputDeviceInput = new Fl_Input_Choice(10, 90, 380, 25, "Output Device");
          o->tooltip("Select realtime Audio Ouput device from list or type name or number directly \
in text field");
          o->callback((Fl_Callback*)cb_rtAudioOutputDeviceInput);
          o->align(FL_ALIGN_TOP);
          o->when(3);
        }
        { Fl_Input* o = jackClientNameInput = new Fl_Input(10, 190, 380, 25, "Jack client name (Linux and Mac OS X only)");
          o->tooltip("Necessary when running more than one instance of Csound5 (leave empty for def\
ault)");
          o->box(FL_THIN_DOWN_BOX);
          o->callback((Fl_Callback*)cb_jackClientNameInput);
          o->align(FL_ALIGN_TOP);
          o->deactivate();
          o->value(performanceSettings.jackClientName.c_str());
        }
        { Fl_Choice* o = rtAudioModuleInput = new Fl_Choice(10, 40, 210, 25, "Real time audio module");
          o->tooltip("Select realtime Audio Module (-+rtaudio)");
          o->box(FL_THIN_DOWN_BOX);
          o->down_box(FL_BORDER_BOX);
          o->callback((Fl_Callback*)cb_rtAudioModuleInput);
          o->align(FL_ALIGN_RIGHT);
          o->when(FL_WHEN_CHANGED);
        }
        RTaudioTab = o;
        o->end();
      }
      { Fl_Group* o = new Fl_Group(0, 25, 405, 470, "MIDI");
        o->color((Fl_Color)139);
        o->hide();
        { Fl_Group* o = new Fl_Group(10, 55, 385, 120, "MIDI file I/O");
          o->box(FL_PLASTIC_UP_FRAME);
          o->labelsize(12);
          o->align(FL_ALIGN_TOP_LEFT);
          { Fl_Input* o = midiInFileNameInput = new Fl_Input(20, 65, 240, 20, "Input file");
            o->tooltip("MIDI Input Filename (-F)");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_midiInFileNameInput);
            o->align(FL_ALIGN_RIGHT);
            o->value(performanceSettings.midiInFileName.c_str());
          }
          { Fl_Button* o = new Fl_Button(345, 65, 20, 20, "...");
            o->tooltip("Browse MIDI input file");
            o->box(FL_PLASTIC_UP_BOX);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->labelsize(12);
            o->callback((Fl_Callback*)cb_2);
          }
          { Fl_Input* o = new Fl_Input(20, 95, 240, 20, "Mute track pattern");
            o->tooltip("MIDI file tracks to be muted, defined by a pattern of 0 (not muted) and 1 (mu\
ted) characters (-+mute_tracks=)");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_Mute);
            o->align(FL_ALIGN_RIGHT);
            o->value(performanceSettings.midiFileMuteTracks.c_str());
          }
          { Fl_Check_Button* o = new Fl_Check_Button(20, 120, 20, 20, "Terminate performance on end of MIDI input file");
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->labelsize(12);
            o->callback((Fl_Callback*)cb_Terminate);
            o->value(performanceSettings.terminateOnMidi ? 1 : 0);
          }
          { Fl_Input* o = midiOutFileNameInput = new Fl_Input(20, 145, 240, 20, "Output file");
            o->tooltip("MIDI Input Filename (--midioutfile=)");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_midiOutFileNameInput);
            o->align(FL_ALIGN_RIGHT);
            o->value(performanceSettings.midiOutFileName.c_str());
          }
          { Fl_Button* o = new Fl_Button(345, 145, 20, 20, "...");
            o->tooltip("Browse MIDI output file");
            o->box(FL_PLASTIC_UP_BOX);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->labelsize(12);
            o->callback((Fl_Callback*)cb_3);
          }
          o->end();
        }
        { Fl_Group* o = new Fl_Group(10, 195, 385, 125, "Real time MIDI");
          o->box(FL_PLASTIC_UP_FRAME);
          o->labelsize(12);
          o->align(FL_ALIGN_TOP_LEFT);
          { Fl_Choice* o = rtMidiModulesChoice = new Fl_Choice(20, 205, 205, 20, "Real time MIDI module");
            o->tooltip("Selects MIDI module used for MIDI input and output (-+rtmidi)");
            o->down_box(FL_BORDER_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_rtMidiModulesChoice);
            o->align(FL_ALIGN_RIGHT);
          }
          { Fl_Input_Choice* o = rtMidiInputDeviceInput = new Fl_Input_Choice(20, 235, 205, 20, "Input Device");
            o->tooltip("Select realtime Audio Ouput device from list or type name or number directly \
in text field");
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_rtMidiInputDeviceInput);
            o->align(FL_ALIGN_RIGHT);
            o->when(3);
            //o->value(performanceSettings.midiInDevName.c_str());
          }
          { Fl_Input_Choice* o = rtMidiOutputDeviceInput = new Fl_Input_Choice(20, 265, 205, 20, "Output Device");
            o->tooltip("Select realtime Audio Ouput device from list or type name or number directly \
in text field");
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_rtMidiOutputDeviceInput);
            o->align(FL_ALIGN_RIGHT);
            o->when(3);
            //o->value(performanceSettings.midiOutDevName.c_str());
          }
          o->end();
        }
        { Fl_Check_Button* o = new Fl_Check_Button(20, 289, 20, 26, "Raw controller mode");
          o->tooltip("Disable special handling of MIDI controllers like sustain pedal, all notes of\
f etc., allowing the use of all the 128 controllers for any purpose. (-+raw_co\
ntroller_mode=)");
          o->down_box(FL_PLASTIC_DOWN_BOX);
          o->labelsize(12);
          o->callback((Fl_Callback*)cb_Raw);
          o->value(performanceSettings.rawControllerMode ? 1 : 0);
        }
        { Fl_Group* o = new Fl_Group(10, 340, 385, 125, "MIDI to p-field routing");
          o->box(FL_PLASTIC_UP_FRAME);
          o->labelsize(12);
          o->align(FL_ALIGN_TOP_LEFT);
          { Fl_Spinner* o = midiKeyMidiSpinner = new Fl_Spinner(35, 355, 65, 20, "MIDI key (MIDI)");
            o->tooltip("Passes the MIDI key values as the specified p-field of the realtime triggered\
 instrument");
            o->labelsize(12);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_midiKeyMidiSpinner);
            o->align(FL_ALIGN_RIGHT);
            o->deactivate();
            o->value((double) performanceSettings.midiKeyMidi);
            if (o->value() > 0) o->activate();
          }
          { Fl_Check_Button* o = midiKeyMidiOn = new Fl_Check_Button(195, 355, 20, 20);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_midiKeyMidiOn);
            if (performanceSettings.midiKeyMidi > 0) {o->set();}
          }
          { Fl_Spinner* o = midiKeyCpsSpinner = new Fl_Spinner(35, 380, 65, 20, "MIDI key (CPS)");
            o->tooltip("Passes the MIDI key values in Hz as the specified p-field of the realtime tri\
ggered instrument");
            o->labelsize(12);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_midiKeyCpsSpinner);
            o->align(FL_ALIGN_RIGHT);
            o->deactivate();
            o->value((double) performanceSettings.midiKeyCps);
            if (o->value() > 0) o->activate();
          }
          { Fl_Check_Button* o = midiKeyCpsOn = new Fl_Check_Button(195, 380, 20, 20);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_midiKeyCpsOn);
            if (performanceSettings.midiKeyCps > 0) {o->set();}
          }
          { Fl_Spinner* o = midiKeyOctSpinner = new Fl_Spinner(35, 405, 65, 20, "MIDI key (OCT)");
            o->tooltip("Passes the MIDI key values in linear octave value as the specified p-field of\
 the realtime triggered instrument");
            o->labelsize(12);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_midiKeyOctSpinner);
            o->align(FL_ALIGN_RIGHT);
            o->deactivate();
            o->value((double) performanceSettings.midiKeyOct);
            if (o->value() > 0) o->activate();
          }
          { Fl_Check_Button* o = midiKeyOctOn = new Fl_Check_Button(195, 405, 20, 20);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_midiKeyOctOn);
            if (performanceSettings.midiKeyOct > 0) {o->set();}
          }
          { Fl_Spinner* o = midiKeyPchSpinner = new Fl_Spinner(35, 430, 65, 20, "MIDI key (PCH)");
            o->tooltip("Passes the MIDI key values in pitch class noatation as the specified p-field \
of the realtime triggered instrument");
            o->labelsize(12);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_midiKeyPchSpinner);
            o->align(FL_ALIGN_RIGHT);
            o->deactivate();
            o->value((double) performanceSettings.midiKeyPch);
            if (o->value() > 0) o->activate();
          }
          { Fl_Check_Button* o = midiKeyPchOn = new Fl_Check_Button(195, 430, 20, 20);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_midiKeyPchOn);
            if (performanceSettings.midiKeyPch > 0) {o->set();}
          }
          { Fl_Spinner* o = midiVelMidiSpinner = new Fl_Spinner(235, 380, 120, 20, "MIDI velocity (MIDI)");
            o->tooltip("Passes");
            o->labelsize(12);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_midiVelMidiSpinner);
            o->align(FL_ALIGN_TOP);
            o->deactivate();
            o->value((double) performanceSettings.midiVelMidi);
            if (o->value() > 0) o->activate();
          }
          { Fl_Check_Button* o = midiVelMidiOn = new Fl_Check_Button(355, 380, 20, 20);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_midiVelMidiOn);
            if (performanceSettings.midiVelMidi > 0) {o->set();}
          }
          { Fl_Spinner* o = midiVelAmpSpinner = new Fl_Spinner(235, 415, 120, 20, "MIDI velocity (AMP)");
            o->tooltip("Passes");
            o->labelsize(12);
            o->textsize(11);
            o->callback((Fl_Callback*)cb_midiVelAmpSpinner);
            o->align(FL_ALIGN_TOP_RIGHT);
            o->deactivate();
            o->value((double) performanceSettings.midiVelAmp);
            if (o->value() > 0) o->activate();
          }
          { Fl_Check_Button* o = midiVelAmpOn = new Fl_Check_Button(355, 415, 20, 20);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_midiVelAmpOn);
            if (performanceSettings.midiVelAmp > 0) {o->set();}
          }
          o->end();
        }
        o->end();
      }
      { Fl_Group* o = new Fl_Group(0, 25, 400, 480, "Environment");
        o->color((Fl_Color)139);
        o->hide();
        { Fl_Group* o = new Fl_Group(10, 50, 380, 160, "Environment variables");
          o->tooltip("Environment varibles set locally only on compilation");
          o->box(FL_PLASTIC_UP_FRAME);
          o->align(FL_ALIGN_TOP_LEFT);
          { Fl_Input* o = sadirBox = new Fl_Input(20, 60, 270, 20, "SADIR");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_sadirBox);
            o->align(FL_ALIGN_RIGHT);
            o->value(performanceSettings.sadirPath.c_str());
          }
          { Fl_Button* o = new Fl_Button(360, 60, 20, 20, "...");
            o->box(FL_PLASTIC_UP_BOX);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_4);
          }
          { Fl_Input* o = ssdirBox = new Fl_Input(20, 90, 270, 20, "SSDIR");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_ssdirBox);
            o->align(FL_ALIGN_RIGHT);
            o->value(performanceSettings.ssdirPath.c_str());
          }
          { Fl_Button* o = new Fl_Button(360, 90, 20, 20, "...");
            o->box(FL_PLASTIC_UP_BOX);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_5);
          }
          { Fl_Input* o = sfdirBox = new Fl_Input(20, 120, 270, 20, "SFDIR");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_sfdirBox);
            o->align(FL_ALIGN_RIGHT);
            o->value(performanceSettings.sfdirPath.c_str());
          }
          { Fl_Button* o = new Fl_Button(360, 120, 20, 20, "...");
            o->box(FL_PLASTIC_UP_BOX);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_6);
          }
          { Fl_Input* o = incdirBox = new Fl_Input(20, 150, 270, 20, "INCDIR");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_incdirBox);
            o->align(FL_ALIGN_RIGHT);
            o->value(performanceSettings.incdirPath.c_str());
          }
          { Fl_Button* o = new Fl_Button(360, 150, 20, 20, "...");
            o->box(FL_PLASTIC_UP_BOX);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_7);
          }
          { Fl_Input* o = csdocdirBox = new Fl_Input(20, 180, 270, 20, "CSDOCDIR");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_csdocdirBox);
            o->align(FL_ALIGN_RIGHT);
            o->value(performanceSettings.csdocdirPath.c_str());
          }
          { Fl_Button* o = new Fl_Button(360, 180, 20, 20, "...");
            o->box(FL_PLASTIC_UP_BOX);
            o->down_box(FL_PLASTIC_DOWN_BOX);
            o->callback((Fl_Callback*)cb_8);
          }
          o->end();
        }
        { Fl_Group* o = new Fl_Group(10, 230, 380, 265, "Set strings (strset)");
          o->box(FL_PLASTIC_UP_FRAME);
          o->align(FL_ALIGN_TOP_LEFT);
          { Fl_Input* o = new Fl_Input(35, 240, 345, 20, "1");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_11);
            o->value(performanceSettings.strsets[0].c_str());
          }
          { Fl_Input* o = new Fl_Input(35, 265, 345, 20, "2");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_21);
            o->value(performanceSettings.strsets[1].c_str());
          }
          { Fl_Input* o = new Fl_Input(35, 290, 345, 20, "3");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_31);
            o->value(performanceSettings.strsets[2].c_str());
          }
          { Fl_Input* o = new Fl_Input(35, 315, 345, 20, "4");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_41);
            o->value(performanceSettings.strsets[3].c_str());
          }
          { Fl_Input* o = new Fl_Input(35, 340, 345, 20, "5");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_51);
            o->value(performanceSettings.strsets[4].c_str());
          }
          { Fl_Input* o = new Fl_Input(35, 365, 345, 20, "6");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_61);
            o->value(performanceSettings.strsets[5].c_str());
          }
          { Fl_Input* o = new Fl_Input(35, 390, 345, 20, "7");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_71);
            o->value(performanceSettings.strsets[6].c_str());
          }
          { Fl_Input* o = new Fl_Input(35, 415, 345, 20, "8");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_81);
            o->value(performanceSettings.strsets[7].c_str());
          }
          { Fl_Input* o = new Fl_Input(35, 440, 345, 20, "9");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_9);
            o->value(performanceSettings.strsets[8].c_str());
          }
          { Fl_Input* o = new Fl_Input(35, 465, 345, 20, "10");
            o->box(FL_THIN_DOWN_BOX);
            o->labelsize(12);
            o->textsize(12);
            o->callback((Fl_Callback*)cb_10);
            o->value(performanceSettings.strsets[9].c_str());
          }
          o->end();
        }
        o->end();
      }
      tabs = o;
      o->end();
    }
    { Fl_Button* o = new Fl_Button(255, 510, 60, 25, "OK");
      o->box(FL_PLASTIC_UP_BOX);
      o->down_box(FL_PLASTIC_DOWN_BOX);
      o->callback((Fl_Callback*)cb_OK);
    }
    { Fl_Button* o = new Fl_Button(320, 510, 60, 25, "Cancel");
      o->box(FL_PLASTIC_UP_BOX);
      o->down_box(FL_PLASTIC_DOWN_BOX);
      o->callback((Fl_Callback*)cb_Cancel);
    }
    window = o;
    o->end();
  }
  {
setPerformanceSettingsWindow(0);
querySoundDevices();
queryMidiDevices();
}
}

CsoundPerformanceSettingsPanel::~CsoundPerformanceSettingsPanel() {
  {
  if (window) {
    delete window;
    window = (Fl_Double_Window*) 0;
  }
}
}
#include "CsoundPerformanceSettingsPanel.cpp"
