/* fout_poly.orc */
; Initialize the global variables.
sr = 44100
kr = 44100
ksmps = 1
nchnls = 1

; Initialize the global audio signal.
gaudio init 0

; Instrument #1 - Play an audio file.
instr 1
  ; Generate an audio signal using 
  ; the audio file "beats.wav".
  asig soundin "beats.wav"

  ; Add this audio signal to the global one.
  vincr gaudio, asig
endin

; Instrument #2 - Create a basic tone.
instr 2
  iamp = 5000
  icps = 440
  iphs = 0

  ; Create an audio signal.
  asig oscils iamp, icps, iphs

  ; Add this audio signal to the global one.
  vincr gaudio, asig
endin

; Instrument #99 - Save the global signal to a file.
instr 99
  ; Write the global audio signal to a headerless 
  ; audio file called "fout_poly.raw".
  fout "fout_poly.raw", 1, gaudio

  ; Clear the global audio signal, preparing it 
  ; for the next round.
  clear gaudio
endin
/* fout_poly.orc */
