/*
  Copyright (C) 2002 by Anders Stenberg

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*

 Please be careful when changing this file. It's the result of roughly
 78 hours of work, where approximately 14 liters of coffee where consumed,
 the keyboard been replaced 4 times due to worn-out cut'n'paste combo keys
 and two ambulance calls because of near-fatal RSI syndroms. Every line has
 been thought of carefully and has been highly optimized by 3 members of a
 Zen buddhist religion in a Tibetian monastry. Thus modifications, as they
 touch the core OpenGL support, could severely affect performance. Beware!
 Okay, maybe this was a bit exaggerated... this file is autogenerated.
 
 */


#ifndef __CS_GLEXTENSIONMANAGER_H__
#define __CS_GLEXTENSIONMANAGER_H__



/**********************************************************************
 * Begin system-specific stuff.
 */
#if defined(__BEOS__)
#include <stdlib.h>     /* to get some BeOS-isms */
#endif

#if !defined(OPENSTEP) && (defined(NeXT) || defined(NeXT_PDO))
#define OPENSTEP
#endif

#if defined(_WIN32) && !defined(__WIN32__) && !defined(__CYGWIN__)
#define __WIN32__
#endif

#if !defined(GLAPI)
#  if !defined(OPENSTEP) && (defined(__WIN32__) && !defined(__CYGWIN__))
#    if defined(_MSC_VER) && defined(BUILD_GL32) /* tag specify we're building mesa as a DLL */
#      define GLAPI __declspec(dllexport)
#    elif defined(_MSC_VER) && defined(_DLL) /* tag specifying we're building for DLL runtime support */
#      define GLAPI __declspec(dllimport)
#    else /* for use with static link lib build of Win32 edition only */
#      define GLAPI extern
#    endif /* _STATIC_MESA support */
#    define GLAPIENTRY __stdcall
#  else
/* non-Windows compilation */
#    define GLAPI extern
#    define GLAPIENTRY
#  endif /* WIN32 / CYGWIN bracket */
#endif

//#if defined(_WIN32) && !defined(_WINGDI_) && !defined(__CYGWIN__) && !defined(_GNU_H_WINDOWS32_DEFINES) && !defined(OPENSTEP)
//#include <gl/mesa_wgl.h>
//#endif

#if defined(macintosh) && PRAGMA_IMPORT_SUPPORTED
#pragma import on
#endif

#if defined(_WIN32) && !defined(APIENTRY) && !defined(__CYGWIN__)
#define WIN32_LEAN_AND_MEAN 1
#include <windows.h>
#endif

#ifndef csAPIENTRY
#ifndef APIENTRY
#define csAPIENTRY
#else
#define csAPIENTRY APIENTRY
#endif
#endif

// In CS, we ignore Cygwin's graphical offerings and use the Windows versions.
#if defined(__CYGWIN__) && !defined(_WIN32)
#define _WIN32
#endif

/*
 * End system-specific stuff.
 **********************************************************************/

#if defined(CS_OPENGL_PATH)
#include CS_HEADER_GLOBAL(CS_OPENGL_PATH,gl.h)
#else
#include <GL/gl.h>
#endif

/*
  Appear in the ARB_shader_objects ext spec.
 */
typedef char GLcharARB;
typedef uint32 GLhandleARB;

#include "iutil/cmdline.h"
#include "iutil/objreg.h"
#include "ivaria/reporter.h"
#include "plugins/video/canvas/openglcommon/iogl.h"
#include "ivideo/graph2d.h"
#include "csutil/cfgacc.h"

// GL_version_1_2
#ifndef GL_UNSIGNED_BYTE_3_3_2
#define GL_UNSIGNED_BYTE_3_3_2                                        32818
#endif

#ifndef GL_UNSIGNED_SHORT_4_4_4_4
#define GL_UNSIGNED_SHORT_4_4_4_4                                     32819
#endif

#ifndef GL_UNSIGNED_SHORT_5_5_5_1
#define GL_UNSIGNED_SHORT_5_5_5_1                                     32820
#endif

#ifndef GL_UNSIGNED_INT_8_8_8_8
#define GL_UNSIGNED_INT_8_8_8_8                                       32821
#endif

#ifndef GL_UNSIGNED_INT_10_10_10_2
#define GL_UNSIGNED_INT_10_10_10_2                                    32822
#endif

#ifndef GL_RESCALE_NORMAL
#define GL_RESCALE_NORMAL                                             32826
#endif

#ifndef GL_UNSIGNED_BYTE_2_3_3_REV
#define GL_UNSIGNED_BYTE_2_3_3_REV                                    33634
#endif

#ifndef GL_UNSIGNED_SHORT_5_6_5
#define GL_UNSIGNED_SHORT_5_6_5                                       33635
#endif

#ifndef GL_UNSIGNED_SHORT_5_6_5_REV
#define GL_UNSIGNED_SHORT_5_6_5_REV                                   33636
#endif

#ifndef GL_UNSIGNED_SHORT_4_4_4_4_REV
#define GL_UNSIGNED_SHORT_4_4_4_4_REV                                 33637
#endif

#ifndef GL_UNSIGNED_SHORT_1_5_5_5_REV
#define GL_UNSIGNED_SHORT_1_5_5_5_REV                                 33638
#endif

#ifndef GL_UNSIGNED_INT_8_8_8_8_REV
#define GL_UNSIGNED_INT_8_8_8_8_REV                                   33639
#endif

#ifndef GL_UNSIGNED_INT_2_10_10_10_REV
#define GL_UNSIGNED_INT_2_10_10_10_REV                                33640
#endif

#ifndef GL_BGR
#define GL_BGR                                                        32992
#endif

#ifndef GL_BGRA
#define GL_BGRA                                                       32993
#endif

#ifndef GL_MAX_ELEMENTS_VERTICES
#define GL_MAX_ELEMENTS_VERTICES                                      33000
#endif

#ifndef GL_MAX_ELEMENTS_INDICES
#define GL_MAX_ELEMENTS_INDICES                                       33001
#endif

#ifndef GL_CLAMP_TO_EDGE
#define GL_CLAMP_TO_EDGE                                              33071
#endif

#ifndef GL_TEXTURE_MIN_LOD
#define GL_TEXTURE_MIN_LOD                                            33082
#endif

#ifndef GL_TEXTURE_MAX_LOD
#define GL_TEXTURE_MAX_LOD                                            33083
#endif

#ifndef GL_TEXTURE_BASE_LEVEL
#define GL_TEXTURE_BASE_LEVEL                                         33084
#endif

#ifndef GL_TEXTURE_MAX_LEVEL
#define GL_TEXTURE_MAX_LEVEL                                          33085
#endif

#ifndef GL_LIGHT_MODEL_COLOR_CONTROL
#define GL_LIGHT_MODEL_COLOR_CONTROL                                  33272
#endif

#ifndef GL_SINGLE_COLOR
#define GL_SINGLE_COLOR                                               33273
#endif

#ifndef GL_SEPARATE_SPECULAR_COLOR
#define GL_SEPARATE_SPECULAR_COLOR                                    33274
#endif

#ifndef GL_SMOOTH_POINT_SIZE_RANGE
#define GL_SMOOTH_POINT_SIZE_RANGE                                     2834
#endif

#ifndef GL_SMOOTH_POINT_SIZE_GRANULARITY
#define GL_SMOOTH_POINT_SIZE_GRANULARITY                               2835
#endif

#ifndef GL_SMOOTH_LINE_WIDTH_RANGE
#define GL_SMOOTH_LINE_WIDTH_RANGE                                     2850
#endif

#ifndef GL_SMOOTH_LINE_WIDTH_GRANULARITY
#define GL_SMOOTH_LINE_WIDTH_GRANULARITY                               2851
#endif

#ifndef GL_ALIASED_POINT_SIZE_RANGE
#define GL_ALIASED_POINT_SIZE_RANGE                                   33901
#endif

#ifndef GL_ALIASED_LINE_WIDTH_RANGE
#define GL_ALIASED_LINE_WIDTH_RANGE                                   33902
#endif

#ifndef GL_PACK_SKIP_IMAGES
#define GL_PACK_SKIP_IMAGES                                           32875
#endif

#ifndef GL_PACK_IMAGE_HEIGHT
#define GL_PACK_IMAGE_HEIGHT                                          32876
#endif

#ifndef GL_UNPACK_SKIP_IMAGES
#define GL_UNPACK_SKIP_IMAGES                                         32877
#endif

#ifndef GL_UNPACK_IMAGE_HEIGHT
#define GL_UNPACK_IMAGE_HEIGHT                                        32878
#endif

#ifndef GL_TEXTURE_3D
#define GL_TEXTURE_3D                                                 32879
#endif

#ifndef GL_PROXY_TEXTURE_3D
#define GL_PROXY_TEXTURE_3D                                           32880
#endif

#ifndef GL_TEXTURE_DEPTH
#define GL_TEXTURE_DEPTH                                              32881
#endif

#ifndef GL_TEXTURE_WRAP_R
#define GL_TEXTURE_WRAP_R                                             32882
#endif

#ifndef GL_MAX_3D_TEXTURE_SIZE
#define GL_MAX_3D_TEXTURE_SIZE                                        32883
#endif


typedef GLvoid (csAPIENTRY* csGLDRAWRANGEELEMENTS) (GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid* indices);
typedef GLvoid (csAPIENTRY* csGLTEXIMAGE3D) (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid* pixels);
typedef GLvoid (csAPIENTRY* csGLTEXSUBIMAGE3D) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid* pixels);
typedef GLvoid (csAPIENTRY* csGLCOPYTEXSUBIMAGE3D) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);

// GL_version_1_3
#ifndef GL_TEXTURE0
#define GL_TEXTURE0                                                   33984
#endif

#ifndef GL_TEXTURE1
#define GL_TEXTURE1                                                   33985
#endif

#ifndef GL_TEXTURE2
#define GL_TEXTURE2                                                   33986
#endif

#ifndef GL_TEXTURE3
#define GL_TEXTURE3                                                   33987
#endif

#ifndef GL_TEXTURE4
#define GL_TEXTURE4                                                   33988
#endif

#ifndef GL_TEXTURE5
#define GL_TEXTURE5                                                   33989
#endif

#ifndef GL_TEXTURE6
#define GL_TEXTURE6                                                   33990
#endif

#ifndef GL_TEXTURE7
#define GL_TEXTURE7                                                   33991
#endif

#ifndef GL_TEXTURE8
#define GL_TEXTURE8                                                   33992
#endif

#ifndef GL_TEXTURE9
#define GL_TEXTURE9                                                   33993
#endif

#ifndef GL_TEXTURE10
#define GL_TEXTURE10                                                  33994
#endif

#ifndef GL_TEXTURE11
#define GL_TEXTURE11                                                  33995
#endif

#ifndef GL_TEXTURE12
#define GL_TEXTURE12                                                  33996
#endif

#ifndef GL_TEXTURE13
#define GL_TEXTURE13                                                  33997
#endif

#ifndef GL_TEXTURE14
#define GL_TEXTURE14                                                  33998
#endif

#ifndef GL_TEXTURE15
#define GL_TEXTURE15                                                  33999
#endif

#ifndef GL_TEXTURE16
#define GL_TEXTURE16                                                  34000
#endif

#ifndef GL_TEXTURE17
#define GL_TEXTURE17                                                  34001
#endif

#ifndef GL_TEXTURE18
#define GL_TEXTURE18                                                  34002
#endif

#ifndef GL_TEXTURE19
#define GL_TEXTURE19                                                  34003
#endif

#ifndef GL_TEXTURE20
#define GL_TEXTURE20                                                  34004
#endif

#ifndef GL_TEXTURE21
#define GL_TEXTURE21                                                  34005
#endif

#ifndef GL_TEXTURE22
#define GL_TEXTURE22                                                  34006
#endif

#ifndef GL_TEXTURE23
#define GL_TEXTURE23                                                  34007
#endif

#ifndef GL_TEXTURE24
#define GL_TEXTURE24                                                  34008
#endif

#ifndef GL_TEXTURE25
#define GL_TEXTURE25                                                  34009
#endif

#ifndef GL_TEXTURE26
#define GL_TEXTURE26                                                  34010
#endif

#ifndef GL_TEXTURE27
#define GL_TEXTURE27                                                  34011
#endif

#ifndef GL_TEXTURE28
#define GL_TEXTURE28                                                  34012
#endif

#ifndef GL_TEXTURE29
#define GL_TEXTURE29                                                  34013
#endif

#ifndef GL_TEXTURE30
#define GL_TEXTURE30                                                  34014
#endif

#ifndef GL_TEXTURE31
#define GL_TEXTURE31                                                  34015
#endif

#ifndef GL_ACTIVE_TEXTURE
#define GL_ACTIVE_TEXTURE                                             34016
#endif

#ifndef GL_CLIENT_ACTIVE_TEXTURE
#define GL_CLIENT_ACTIVE_TEXTURE                                      34017
#endif

#ifndef GL_MAX_TEXTURE_UNITS
#define GL_MAX_TEXTURE_UNITS                                          34018
#endif

#ifndef GL_TRANSPOSE_MODELVIEW_MATRIX
#define GL_TRANSPOSE_MODELVIEW_MATRIX                                 34019
#endif

#ifndef GL_TRANSPOSE_PROJECTION_MATRIX
#define GL_TRANSPOSE_PROJECTION_MATRIX                                34020
#endif

#ifndef GL_TRANSPOSE_TEXTURE_MATRIX
#define GL_TRANSPOSE_TEXTURE_MATRIX                                   34021
#endif

#ifndef GL_TRANSPOSE_COLOR_MATRIX
#define GL_TRANSPOSE_COLOR_MATRIX                                     34022
#endif

#ifndef GL_MULTISAMPLE
#define GL_MULTISAMPLE                                                32925
#endif

#ifndef GL_SAMPLE_ALPHA_TO_COVERAGE
#define GL_SAMPLE_ALPHA_TO_COVERAGE                                   32926
#endif

#ifndef GL_SAMPLE_ALPHA_TO_ONE
#define GL_SAMPLE_ALPHA_TO_ONE                                        32927
#endif

#ifndef GL_SAMPLE_COVERAGE
#define GL_SAMPLE_COVERAGE                                            32928
#endif

#ifndef GL_SAMPLE_BUFFERS
#define GL_SAMPLE_BUFFERS                                             32936
#endif

#ifndef GL_SAMPLES
#define GL_SAMPLES                                                    32937
#endif

#ifndef GL_SAMPLE_COVERAGE_VALUE
#define GL_SAMPLE_COVERAGE_VALUE                                      32938
#endif

#ifndef GL_SAMPLE_COVERAGE_INVERT
#define GL_SAMPLE_COVERAGE_INVERT                                     32939
#endif

#ifndef GL_MULTISAMPLE_BIT
#define GL_MULTISAMPLE_BIT                                           536870912
#endif

#ifndef GL_NORMAL_MAP
#define GL_NORMAL_MAP                                                 34065
#endif

#ifndef GL_REFLECTION_MAP
#define GL_REFLECTION_MAP                                             34066
#endif

#ifndef GL_TEXTURE_CUBE_MAP
#define GL_TEXTURE_CUBE_MAP                                           34067
#endif

#ifndef GL_TEXTURE_BINDING_CUBE_MAP
#define GL_TEXTURE_BINDING_CUBE_MAP                                   34068
#endif

#ifndef GL_TEXTURE_CUBE_MAP_POSITIVE_X
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X                                34069
#endif

#ifndef GL_TEXTURE_CUBE_MAP_NEGATIVE_X
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X                                34070
#endif

#ifndef GL_TEXTURE_CUBE_MAP_POSITIVE_Y
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y                                34071
#endif

#ifndef GL_TEXTURE_CUBE_MAP_NEGATIVE_Y
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y                                34072
#endif

#ifndef GL_TEXTURE_CUBE_MAP_POSITIVE_Z
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z                                34073
#endif

#ifndef GL_TEXTURE_CUBE_MAP_NEGATIVE_Z
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z                                34074
#endif

#ifndef GL_PROXY_TEXTURE_CUBE_MAP
#define GL_PROXY_TEXTURE_CUBE_MAP                                     34075
#endif

#ifndef GL_MAX_CUBE_MAP_TEXTURE_SIZE
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE                                  34076
#endif

#ifndef GL_COMPRESSED_ALPHA
#define GL_COMPRESSED_ALPHA                                           34025
#endif

#ifndef GL_COMPRESSED_LUMINANCE
#define GL_COMPRESSED_LUMINANCE                                       34026
#endif

#ifndef GL_COMPRESSED_LUMINANCE_ALPHA
#define GL_COMPRESSED_LUMINANCE_ALPHA                                 34027
#endif

#ifndef GL_COMPRESSED_INTENSITY
#define GL_COMPRESSED_INTENSITY                                       34028
#endif

#ifndef GL_COMPRESSED_RGB
#define GL_COMPRESSED_RGB                                             34029
#endif

#ifndef GL_COMPRESSED_RGBA
#define GL_COMPRESSED_RGBA                                            34030
#endif

#ifndef GL_TEXTURE_COMPRESSION_HINT
#define GL_TEXTURE_COMPRESSION_HINT                                   34031
#endif

#ifndef GL_TEXTURE_COMPRESSED_IMAGE_SIZE
#define GL_TEXTURE_COMPRESSED_IMAGE_SIZE                              34464
#endif

#ifndef GL_TEXTURE_COMPRESSED
#define GL_TEXTURE_COMPRESSED                                         34465
#endif

#ifndef GL_NUM_COMPRESSED_TEXTURE_FORMATS
#define GL_NUM_COMPRESSED_TEXTURE_FORMATS                             34466
#endif

#ifndef GL_COMPRESSED_TEXTURE_FORMATS
#define GL_COMPRESSED_TEXTURE_FORMATS                                 34467
#endif

#ifndef GL_CLAMP_TO_BORDER
#define GL_CLAMP_TO_BORDER                                            33069
#endif

#ifndef GL_CLAMP_TO_BORDER_SGIS
#define GL_CLAMP_TO_BORDER_SGIS                                       33069
#endif

#ifndef GL_COMBINE
#define GL_COMBINE                                                    34160
#endif

#ifndef GL_COMBINE_RGB
#define GL_COMBINE_RGB                                                34161
#endif

#ifndef GL_COMBINE_ALPHA
#define GL_COMBINE_ALPHA                                              34162
#endif

#ifndef GL_SOURCE0_RGB
#define GL_SOURCE0_RGB                                                34176
#endif

#ifndef GL_SOURCE1_RGB
#define GL_SOURCE1_RGB                                                34177
#endif

#ifndef GL_SOURCE2_RGB
#define GL_SOURCE2_RGB                                                34178
#endif

#ifndef GL_SOURCE0_ALPHA
#define GL_SOURCE0_ALPHA                                              34184
#endif

#ifndef GL_SOURCE1_ALPHA
#define GL_SOURCE1_ALPHA                                              34185
#endif

#ifndef GL_SOURCE2_ALPHA
#define GL_SOURCE2_ALPHA                                              34186
#endif

#ifndef GL_OPERAND0_RGB
#define GL_OPERAND0_RGB                                               34192
#endif

#ifndef GL_OPERAND1_RGB
#define GL_OPERAND1_RGB                                               34193
#endif

#ifndef GL_OPERAND2_RGB
#define GL_OPERAND2_RGB                                               34194
#endif

#ifndef GL_OPERAND0_ALPHA
#define GL_OPERAND0_ALPHA                                             34200
#endif

#ifndef GL_OPERAND1_ALPHA
#define GL_OPERAND1_ALPHA                                             34201
#endif

#ifndef GL_OPERAND2_ALPHA
#define GL_OPERAND2_ALPHA                                             34202
#endif

#ifndef GL_RGB_SCALE
#define GL_RGB_SCALE                                                  34163
#endif

#ifndef GL_ADD_SIGNED
#define GL_ADD_SIGNED                                                 34164
#endif

#ifndef GL_INTERPOLATE
#define GL_INTERPOLATE                                                34165
#endif

#ifndef GL_SUBTRACT
#define GL_SUBTRACT                                                   34023
#endif

#ifndef GL_CONSTANT
#define GL_CONSTANT                                                   34166
#endif

#ifndef GL_PRIMARY_COLOR
#define GL_PRIMARY_COLOR                                              34167
#endif

#ifndef GL_PREVIOUS
#define GL_PREVIOUS                                                   34168
#endif

#ifndef GL_DOT3_RGB
#define GL_DOT3_RGB                                                   34478
#endif

#ifndef GL_DOT3_RGBA
#define GL_DOT3_RGBA                                                  34479
#endif


typedef GLvoid (csAPIENTRY* csGLACTIVETEXTURE) (GLenum texture);
typedef GLvoid (csAPIENTRY* csGLCLIENTACTIVETEXTURE) (GLenum texture);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD1D) (GLenum target, GLdouble s);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD1DV) (GLenum target, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD1F) (GLenum target, GLfloat s);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD1FV) (GLenum target, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD1I) (GLenum target, GLint s);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD1IV) (GLenum target, const GLint* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD1S) (GLenum target, GLshort s);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD1SV) (GLenum target, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD2D) (GLenum target, GLdouble s, GLdouble t);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD2DV) (GLenum target, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD2F) (GLenum target, GLfloat s, GLfloat t);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD2FV) (GLenum target, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD2I) (GLenum target, GLint s, GLint t);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD2IV) (GLenum target, const GLint* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD2S) (GLenum target, GLshort s, GLshort t);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD2SV) (GLenum target, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD3D) (GLenum target, GLdouble s, GLdouble t, GLdouble r);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD3DV) (GLenum target, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD3F) (GLenum target, GLfloat s, GLfloat t, GLfloat r);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD3FV) (GLenum target, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD3I) (GLenum target, GLint s, GLint t, GLint r);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD3IV) (GLenum target, const GLint* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD3S) (GLenum target, GLshort s, GLshort t, GLshort r);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD3SV) (GLenum target, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD4D) (GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD4DV) (GLenum target, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD4F) (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD4FV) (GLenum target, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD4I) (GLenum target, GLint s, GLint t, GLint r, GLint q);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD4IV) (GLenum target, const GLint* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD4S) (GLenum target, GLshort s, GLshort t, GLshort r, GLshort q);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD4SV) (GLenum target, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLLOADTRANSPOSEMATRIXF) (const GLfloat* m);
typedef GLvoid (csAPIENTRY* csGLLOADTRANSPOSEMATRIXD) (const GLdouble* m);
typedef GLvoid (csAPIENTRY* csGLMULTTRANSPOSEMATRIXF) (const GLfloat* m);
typedef GLvoid (csAPIENTRY* csGLMULTTRANSPOSEMATRIXD) (const GLdouble* m);
typedef GLvoid (csAPIENTRY* csGLSAMPLECOVERAGE) (GLclampf value, GLboolean invert);
typedef GLvoid (csAPIENTRY* csGLCOMPRESSEDTEXIMAGE3D) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLCOMPRESSEDTEXIMAGE2D) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLCOMPRESSEDTEXIMAGE1D) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLCOMPRESSEDTEXSUBIMAGE3D) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLCOMPRESSEDTEXSUBIMAGE2D) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLCOMPRESSEDTEXSUBIMAGE1D) (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLGETCOMPRESSEDTEXIMAGE) (GLenum target, GLint level, GLvoid* img);

// GL_ARB_imaging
#ifndef GL_CONSTANT_COLOR
#define GL_CONSTANT_COLOR                                             32769
#endif

#ifndef GL_ONE_MINUS_CONSTANT_COLOR
#define GL_ONE_MINUS_CONSTANT_COLOR                                   32770
#endif

#ifndef GL_CONSTANT_ALPHA
#define GL_CONSTANT_ALPHA                                             32771
#endif

#ifndef GL_ONE_MINUS_CONSTANT_ALPHA
#define GL_ONE_MINUS_CONSTANT_ALPHA                                   32772
#endif

#ifndef GL_BLEND_COLOR
#define GL_BLEND_COLOR                                                32773
#endif

#ifndef GL_FUNC_ADD
#define GL_FUNC_ADD                                                   32774
#endif

#ifndef GL_MIN
#define GL_MIN                                                        32775
#endif

#ifndef GL_MAX
#define GL_MAX                                                        32776
#endif

#ifndef GL_BLEND_EQUATION
#define GL_BLEND_EQUATION                                             32777
#endif

#ifndef GL_FUNC_SUBTRACT
#define GL_FUNC_SUBTRACT                                              32778
#endif

#ifndef GL_FUNC_REVERSE_SUBTRACT
#define GL_FUNC_REVERSE_SUBTRACT                                      32779
#endif

#ifndef GL_CONVOLUTION_1D
#define GL_CONVOLUTION_1D                                             32784
#endif

#ifndef GL_CONVOLUTION_2D
#define GL_CONVOLUTION_2D                                             32785
#endif

#ifndef GL_SEPARABLE_2D
#define GL_SEPARABLE_2D                                               32786
#endif

#ifndef GL_CONVOLUTION_BORDER_MODE
#define GL_CONVOLUTION_BORDER_MODE                                    32787
#endif

#ifndef GL_CONVOLUTION_FILTER_SCALE
#define GL_CONVOLUTION_FILTER_SCALE                                   32788
#endif

#ifndef GL_CONVOLUTION_FILTER_BIAS
#define GL_CONVOLUTION_FILTER_BIAS                                    32789
#endif

#ifndef GL_REDUCE
#define GL_REDUCE                                                     32790
#endif

#ifndef GL_CONVOLUTION_FORMAT
#define GL_CONVOLUTION_FORMAT                                         32791
#endif

#ifndef GL_CONVOLUTION_WIDTH
#define GL_CONVOLUTION_WIDTH                                          32792
#endif

#ifndef GL_CONVOLUTION_HEIGHT
#define GL_CONVOLUTION_HEIGHT                                         32793
#endif

#ifndef GL_MAX_CONVOLUTION_WIDTH
#define GL_MAX_CONVOLUTION_WIDTH                                      32794
#endif

#ifndef GL_MAX_CONVOLUTION_HEIGHT
#define GL_MAX_CONVOLUTION_HEIGHT                                     32795
#endif

#ifndef GL_POST_CONVOLUTION_RED_SCALE
#define GL_POST_CONVOLUTION_RED_SCALE                                 32796
#endif

#ifndef GL_POST_CONVOLUTION_GREEN_SCALE
#define GL_POST_CONVOLUTION_GREEN_SCALE                               32797
#endif

#ifndef GL_POST_CONVOLUTION_BLUE_SCALE
#define GL_POST_CONVOLUTION_BLUE_SCALE                                32798
#endif

#ifndef GL_POST_CONVOLUTION_ALPHA_SCALE
#define GL_POST_CONVOLUTION_ALPHA_SCALE                               32799
#endif

#ifndef GL_POST_CONVOLUTION_RED_BIAS
#define GL_POST_CONVOLUTION_RED_BIAS                                  32800
#endif

#ifndef GL_POST_CONVOLUTION_GREEN_BIAS
#define GL_POST_CONVOLUTION_GREEN_BIAS                                32801
#endif

#ifndef GL_POST_CONVOLUTION_BLUE_BIAS
#define GL_POST_CONVOLUTION_BLUE_BIAS                                 32802
#endif

#ifndef GL_POST_CONVOLUTION_ALPHA_BIAS
#define GL_POST_CONVOLUTION_ALPHA_BIAS                                32803
#endif

#ifndef GL_HISTOGRAM
#define GL_HISTOGRAM                                                  32804
#endif

#ifndef GL_PROXY_HISTOGRAM
#define GL_PROXY_HISTOGRAM                                            32805
#endif

#ifndef GL_HISTOGRAM_WIDTH
#define GL_HISTOGRAM_WIDTH                                            32806
#endif

#ifndef GL_HISTOGRAM_FORMAT
#define GL_HISTOGRAM_FORMAT                                           32807
#endif

#ifndef GL_HISTOGRAM_RED_SIZE
#define GL_HISTOGRAM_RED_SIZE                                         32808
#endif

#ifndef GL_HISTOGRAM_GREEN_SIZE
#define GL_HISTOGRAM_GREEN_SIZE                                       32809
#endif

#ifndef GL_HISTOGRAM_BLUE_SIZE
#define GL_HISTOGRAM_BLUE_SIZE                                        32810
#endif

#ifndef GL_HISTOGRAM_ALPHA_SIZE
#define GL_HISTOGRAM_ALPHA_SIZE                                       32811
#endif

#ifndef GL_HISTOGRAM_LUMINANCE_SIZE
#define GL_HISTOGRAM_LUMINANCE_SIZE                                   32812
#endif

#ifndef GL_HISTOGRAM_SINK
#define GL_HISTOGRAM_SINK                                             32813
#endif

#ifndef GL_MINMAX
#define GL_MINMAX                                                     32814
#endif

#ifndef GL_MINMAX_FORMAT
#define GL_MINMAX_FORMAT                                              32815
#endif

#ifndef GL_MINMAX_SINK
#define GL_MINMAX_SINK                                                32816
#endif

#ifndef GL_TABLE_TOO_LARGE
#define GL_TABLE_TOO_LARGE                                            32817
#endif

#ifndef GL_COLOR_MATRIX
#define GL_COLOR_MATRIX                                               32945
#endif

#ifndef GL_COLOR_MATRIX_STACK_DEPTH
#define GL_COLOR_MATRIX_STACK_DEPTH                                   32946
#endif

#ifndef GL_MAX_COLOR_MATRIX_STACK_DEPTH
#define GL_MAX_COLOR_MATRIX_STACK_DEPTH                               32947
#endif

#ifndef GL_POST_COLOR_MATRIX_RED_SCALE
#define GL_POST_COLOR_MATRIX_RED_SCALE                                32948
#endif

#ifndef GL_POST_COLOR_MATRIX_GREEN_SCALE
#define GL_POST_COLOR_MATRIX_GREEN_SCALE                              32949
#endif

#ifndef GL_POST_COLOR_MATRIX_BLUE_SCALE
#define GL_POST_COLOR_MATRIX_BLUE_SCALE                               32950
#endif

#ifndef GL_POST_COLOR_MATRIX_ALPHA_SCALE
#define GL_POST_COLOR_MATRIX_ALPHA_SCALE                              32951
#endif

#ifndef GL_POST_COLOR_MATRIX_RED_BIAS
#define GL_POST_COLOR_MATRIX_RED_BIAS                                 32952
#endif

#ifndef GL_POST_COLOR_MATRIX_GREEN_BIAS
#define GL_POST_COLOR_MATRIX_GREEN_BIAS                               32953
#endif

#ifndef GL_POST_COLOR_MATRIX_BLUE_BIAS
#define GL_POST_COLOR_MATRIX_BLUE_BIAS                                32954
#endif

#ifndef GL_POST_COLOR_MATIX_ALPHA_BIAS
#define GL_POST_COLOR_MATIX_ALPHA_BIAS                                32955
#endif

#ifndef GL_COLOR_TABLE
#define GL_COLOR_TABLE                                                32976
#endif

#ifndef GL_POST_CONVOLUTION_COLOR_TABLE
#define GL_POST_CONVOLUTION_COLOR_TABLE                               32977
#endif

#ifndef GL_POST_COLOR_MATRIX_COLOR_TABLE
#define GL_POST_COLOR_MATRIX_COLOR_TABLE                              32978
#endif

#ifndef GL_PROXY_COLOR_TABLE
#define GL_PROXY_COLOR_TABLE                                          32979
#endif

#ifndef GL_PROXY_POST_CONVOLUTION_COLOR_TABLE
#define GL_PROXY_POST_CONVOLUTION_COLOR_TABLE                         32980
#endif

#ifndef GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE
#define GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE                        32981
#endif

#ifndef GL_COLOR_TABLE_SCALE
#define GL_COLOR_TABLE_SCALE                                          32982
#endif

#ifndef GL_COLOR_TABLE_BIAS
#define GL_COLOR_TABLE_BIAS                                           32983
#endif

#ifndef GL_COLOR_TABLE_FORMAT
#define GL_COLOR_TABLE_FORMAT                                         32984
#endif

#ifndef GL_COLOR_TABLE_WIDTH
#define GL_COLOR_TABLE_WIDTH                                          32985
#endif

#ifndef GL_COLOR_TABLE_RED_SIZE
#define GL_COLOR_TABLE_RED_SIZE                                       32986
#endif

#ifndef GL_COLOR_TABLE_GREEN_SIZE
#define GL_COLOR_TABLE_GREEN_SIZE                                     32987
#endif

#ifndef GL_COLOR_TABLE_BLUE_SIZE
#define GL_COLOR_TABLE_BLUE_SIZE                                      32988
#endif

#ifndef GL_COLOR_TABLE_ALPHA_SIZE
#define GL_COLOR_TABLE_ALPHA_SIZE                                     32989
#endif

#ifndef GL_COLOR_TABLE_LUMINANCE_SIZE
#define GL_COLOR_TABLE_LUMINANCE_SIZE                                 32990
#endif

#ifndef GL_COLOR_TABLE_INTENSITY_SIZE
#define GL_COLOR_TABLE_INTENSITY_SIZE                                 32991
#endif

#ifndef GL_IGNORE_BORDER
#define GL_IGNORE_BORDER                                              33104
#endif

#ifndef GL_CONSTANT_BORDER
#define GL_CONSTANT_BORDER                                            33105
#endif

#ifndef GL_WRAP_BORDER
#define GL_WRAP_BORDER                                                33106
#endif

#ifndef GL_REPLICATE_BORDER
#define GL_REPLICATE_BORDER                                           33107
#endif

#ifndef GL_CONVOLUTION_BORDER_COLOR
#define GL_CONVOLUTION_BORDER_COLOR                                   33108
#endif


typedef GLvoid (csAPIENTRY* csGLCOLORTABLE) (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid* table);
typedef GLvoid (csAPIENTRY* csGLCOLORTABLEPARAMETERFV) (GLenum target, GLenum pname, const GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLCOLORTABLEPARAMETERIV) (GLenum target, GLenum pname, const GLint* params);
typedef GLvoid (csAPIENTRY* csGLCOPYCOLORTABLE) (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
typedef GLvoid (csAPIENTRY* csGLGETCOLORTABLE) (GLenum target, GLenum format, GLenum type, GLvoid* table);
typedef GLvoid (csAPIENTRY* csGLGETCOLORTABLEPARAMETERFV) (GLenum target, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETCOLORTABLEPARAMETERIV) (GLenum target, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLCOLORSUBTABLE) (GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLCOPYCOLORSUBTABLE) (GLenum target, GLsizei start, GLint x, GLint y, GLsizei width);
typedef GLvoid (csAPIENTRY* csGLCONVOLUTIONFILTER1D) (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid* image);
typedef GLvoid (csAPIENTRY* csGLCONVOLUTIONFILTER2D) (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid* image);
typedef GLvoid (csAPIENTRY* csGLCONVOLUTIONPARAMETERF) (GLenum target, GLenum pname, GLfloat params);
typedef GLvoid (csAPIENTRY* csGLCONVOLUTIONPARAMETERFV) (GLenum target, GLenum pname, const GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLCONVOLUTIONPARAMETERI) (GLenum target, GLenum pname, GLint params);
typedef GLvoid (csAPIENTRY* csGLCONVOLUTIONPARAMETERIV) (GLenum target, GLenum pname, const GLint* params);
typedef GLvoid (csAPIENTRY* csGLCOPYCONVOLUTIONFILTER1D) (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
typedef GLvoid (csAPIENTRY* csGLCOPYCONVOLUTIONFILTER2D) (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height);
typedef GLvoid (csAPIENTRY* csGLGETCONVOLUTIONFILTER) (GLenum target, GLenum format, GLenum type, GLvoid* image);
typedef GLvoid (csAPIENTRY* csGLGETCONVOLUTIONPARAMETERFV) (GLenum target, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETCONVOLUTIONPARAMETERIV) (GLenum target, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETSEPARABLEFILTER) (GLenum target, GLenum format, GLenum type, GLvoid* row, GLvoid* column, GLvoid* span);
typedef GLvoid (csAPIENTRY* csGLSEPARABLEFILTER2D) (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid* row, const GLvoid* column);
typedef GLvoid (csAPIENTRY* csGLGETHISTOGRAM) (GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid* values);
typedef GLvoid (csAPIENTRY* csGLGETHISTOGRAMPARAMETERFV) (GLenum target, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETHISTOGRAMPARAMETERIV) (GLenum target, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETMINMAX) (GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid* values);
typedef GLvoid (csAPIENTRY* csGLGETMINMAXPARAMETERFV) (GLenum target, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETMINMAXPARAMETERIV) (GLenum target, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLHISTOGRAM) (GLenum target, GLsizei width, GLenum internalformat, GLboolean sink);
typedef GLvoid (csAPIENTRY* csGLMINMAX) (GLenum target, GLenum internalformat, GLboolean sink);
typedef GLvoid (csAPIENTRY* csGLRESETHISTOGRAM) (GLenum target);
typedef GLvoid (csAPIENTRY* csGLRESETMINMAX) (GLenum target);
typedef GLvoid (csAPIENTRY* csGLBLENDCOLOR) (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);
typedef GLvoid (csAPIENTRY* csGLBLENDEQUATION) (GLenum mode);

// GL_ARB_multitexture
#ifndef GL_TEXTURE0_ARB
#define GL_TEXTURE0_ARB                                               33984
#endif

#ifndef GL_TEXTURE1_ARB
#define GL_TEXTURE1_ARB                                               33985
#endif

#ifndef GL_TEXTURE2_ARB
#define GL_TEXTURE2_ARB                                               33986
#endif

#ifndef GL_TEXTURE3_ARB
#define GL_TEXTURE3_ARB                                               33987
#endif

#ifndef GL_TEXTURE4_ARB
#define GL_TEXTURE4_ARB                                               33988
#endif

#ifndef GL_TEXTURE5_ARB
#define GL_TEXTURE5_ARB                                               33989
#endif

#ifndef GL_TEXTURE6_ARB
#define GL_TEXTURE6_ARB                                               33990
#endif

#ifndef GL_TEXTURE7_ARB
#define GL_TEXTURE7_ARB                                               33991
#endif

#ifndef GL_TEXTURE8_ARB
#define GL_TEXTURE8_ARB                                               33992
#endif

#ifndef GL_TEXTURE9_ARB
#define GL_TEXTURE9_ARB                                               33993
#endif

#ifndef GL_TEXTURE10_ARB
#define GL_TEXTURE10_ARB                                              33994
#endif

#ifndef GL_TEXTURE11_ARB
#define GL_TEXTURE11_ARB                                              33995
#endif

#ifndef GL_TEXTURE12_ARB
#define GL_TEXTURE12_ARB                                              33996
#endif

#ifndef GL_TEXTURE13_ARB
#define GL_TEXTURE13_ARB                                              33997
#endif

#ifndef GL_TEXTURE14_ARB
#define GL_TEXTURE14_ARB                                              33998
#endif

#ifndef GL_TEXTURE15_ARB
#define GL_TEXTURE15_ARB                                              33999
#endif

#ifndef GL_TEXTURE16_ARB
#define GL_TEXTURE16_ARB                                              34000
#endif

#ifndef GL_TEXTURE17_ARB
#define GL_TEXTURE17_ARB                                              34001
#endif

#ifndef GL_TEXTURE18_ARB
#define GL_TEXTURE18_ARB                                              34002
#endif

#ifndef GL_TEXTURE19_ARB
#define GL_TEXTURE19_ARB                                              34003
#endif

#ifndef GL_TEXTURE20_ARB
#define GL_TEXTURE20_ARB                                              34004
#endif

#ifndef GL_TEXTURE21_ARB
#define GL_TEXTURE21_ARB                                              34005
#endif

#ifndef GL_TEXTURE22_ARB
#define GL_TEXTURE22_ARB                                              34006
#endif

#ifndef GL_TEXTURE23_ARB
#define GL_TEXTURE23_ARB                                              34007
#endif

#ifndef GL_TEXTURE24_ARB
#define GL_TEXTURE24_ARB                                              34008
#endif

#ifndef GL_TEXTURE25_ARB
#define GL_TEXTURE25_ARB                                              34009
#endif

#ifndef GL_TEXTURE26_ARB
#define GL_TEXTURE26_ARB                                              34010
#endif

#ifndef GL_TEXTURE27_ARB
#define GL_TEXTURE27_ARB                                              34011
#endif

#ifndef GL_TEXTURE28_ARB
#define GL_TEXTURE28_ARB                                              34012
#endif

#ifndef GL_TEXTURE29_ARB
#define GL_TEXTURE29_ARB                                              34013
#endif

#ifndef GL_TEXTURE30_ARB
#define GL_TEXTURE30_ARB                                              34014
#endif

#ifndef GL_TEXTURE31_ARB
#define GL_TEXTURE31_ARB                                              34015
#endif

#ifndef GL_ACTIVE_TEXTURE_ARB
#define GL_ACTIVE_TEXTURE_ARB                                         34016
#endif

#ifndef GL_CLIENT_ACTIVE_TEXTURE_ARB
#define GL_CLIENT_ACTIVE_TEXTURE_ARB                                  34017
#endif

#ifndef GL_MAX_TEXTURE_UNITS_ARB
#define GL_MAX_TEXTURE_UNITS_ARB                                      34018
#endif


typedef GLvoid (csAPIENTRY* csGLACTIVETEXTUREARB) (GLenum texture);
typedef GLvoid (csAPIENTRY* csGLCLIENTACTIVETEXTUREARB) (GLenum texture);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD1DARB) (GLenum target, GLdouble s);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD1DVARB) (GLenum target, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD1FARB) (GLenum target, GLfloat s);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD1FVARB) (GLenum target, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD1IARB) (GLenum target, GLint s);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD1IVARB) (GLenum target, const GLint* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD1SARB) (GLenum target, GLshort s);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD1SVARB) (GLenum target, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD2DARB) (GLenum target, GLdouble s, GLdouble t);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD2DVARB) (GLenum target, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD2FARB) (GLenum target, GLfloat s, GLfloat t);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD2FVARB) (GLenum target, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD2IARB) (GLenum target, GLint s, GLint t);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD2IVARB) (GLenum target, const GLint* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD2SARB) (GLenum target, GLshort s, GLshort t);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD2SVARB) (GLenum target, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD3DARB) (GLenum target, GLdouble s, GLdouble t, GLdouble r);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD3DVARB) (GLenum target, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD3FARB) (GLenum target, GLfloat s, GLfloat t, GLfloat r);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD3FVARB) (GLenum target, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD3IARB) (GLenum target, GLint s, GLint t, GLint r);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD3IVARB) (GLenum target, const GLint* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD3SARB) (GLenum target, GLshort s, GLshort t, GLshort r);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD3SVARB) (GLenum target, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD4DARB) (GLenum target, GLdouble s, GLdouble t, GLdouble r, GLdouble q);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD4DVARB) (GLenum target, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD4FARB) (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD4FVARB) (GLenum target, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD4IARB) (GLenum target, GLint s, GLint t, GLint r, GLint q);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD4IVARB) (GLenum target, const GLint* v);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD4SARB) (GLenum target, GLshort s, GLshort t, GLshort r, GLshort q);
typedef GLvoid (csAPIENTRY* csGLMULTITEXCOORD4SVARB) (GLenum target, const GLshort* v);

// GL_ARB_transpose_matrix
#ifndef GL_TRANSPOSE_MODELVIEW_MATRIX_ARB
#define GL_TRANSPOSE_MODELVIEW_MATRIX_ARB                             34019
#endif

#ifndef GL_TRANSPOSE_PROJECTION_MATRIX_ARB
#define GL_TRANSPOSE_PROJECTION_MATRIX_ARB                            34020
#endif

#ifndef GL_TRANSPOSE_TEXTURE_MATRIX_ARB
#define GL_TRANSPOSE_TEXTURE_MATRIX_ARB                               34021
#endif

#ifndef GL_TRANSPOSE_COLOR_MATRIX_ARB
#define GL_TRANSPOSE_COLOR_MATRIX_ARB                                 34022
#endif


typedef GLvoid (csAPIENTRY* csGLLOADTRANSPOSEMATRIXFARB) (GLfloat* m);
typedef GLvoid (csAPIENTRY* csGLLOADTRANSPOSEMATRIXDARB) (GLdouble* m);
typedef GLvoid (csAPIENTRY* csGLMULTTRANSPOSEMATRIXFARB) (GLfloat* m);
typedef GLvoid (csAPIENTRY* csGLMULTTRANSPOSEMATRIXDARB) (GLdouble* m);

// GL_ARB_multisample
#ifndef WGL_SAMPLE_BUFFERS_ARB
#define WGL_SAMPLE_BUFFERS_ARB                                         8257
#endif

#ifndef WGL_SAMPLES_ARB
#define WGL_SAMPLES_ARB                                                8258
#endif

#ifndef GL_MULTISAMPLE_ARB
#define GL_MULTISAMPLE_ARB                                            32925
#endif

#ifndef GL_SAMPLE_ALPHA_TO_COVERAGE_ARB
#define GL_SAMPLE_ALPHA_TO_COVERAGE_ARB                               32926
#endif

#ifndef GL_SAMPLE_ALPHA_TO_ONE_ARB
#define GL_SAMPLE_ALPHA_TO_ONE_ARB                                    32927
#endif

#ifndef GL_SAMPLE_COVERAGE_ARB
#define GL_SAMPLE_COVERAGE_ARB                                        32928
#endif

#ifndef GL_MULTISAMPLE_BIT_ARB
#define GL_MULTISAMPLE_BIT_ARB                                       536870912
#endif

#ifndef GL_SAMPLE_BUFFERS_ARB
#define GL_SAMPLE_BUFFERS_ARB                                         32936
#endif

#ifndef GL_SAMPLES_ARB
#define GL_SAMPLES_ARB                                                32937
#endif

#ifndef GL_SAMPLE_COVERAGE_VALUE_ARB
#define GL_SAMPLE_COVERAGE_VALUE_ARB                                  32938
#endif

#ifndef GL_SAMPLE_COVERAGE_INVERT_ARB
#define GL_SAMPLE_COVERAGE_INVERT_ARB                                 32939
#endif


typedef GLvoid (csAPIENTRY* csGLSAMPLECOVERAGEARB) (GLclampf value, GLboolean invert);

// GL_ARB_texture_env_add


// WGL_ARB_extensions_string
#ifdef _WIN32

typedef char* (csAPIENTRY* csWGLGETEXTENSIONSSTRINGARB) (HDC hdc);

#endif

// WGL_ARB_buffer_region
#ifdef _WIN32
#ifndef WGL_FRONT_COLOR_BUFFER_BIT_ARB
#define WGL_FRONT_COLOR_BUFFER_BIT_ARB                                    1
#endif

#ifndef WGL_BACK_COLOR_BUFFER_BIT_ARB
#define WGL_BACK_COLOR_BUFFER_BIT_ARB                                     2
#endif

#ifndef WGL_DEPTH_BUFFER_BIT_ARB
#define WGL_DEPTH_BUFFER_BIT_ARB                                          4
#endif

#ifndef WGL_STENCIL_BUFFER_BIT_ARB
#define WGL_STENCIL_BUFFER_BIT_ARB                                        8
#endif


typedef HANDLE (csAPIENTRY* csWGLCREATEBUFFERREGIONARB) (HDC hDC, GLint iLayerPlane, GLuint uType);
typedef GLvoid (csAPIENTRY* csWGLDELETEBUFFERREGIONARB) (HANDLE hRegion);
typedef BOOL (csAPIENTRY* csWGLSAVEBUFFERREGIONARB) (HANDLE hRegion, GLint x, GLint y, GLint width, GLint height);
typedef BOOL (csAPIENTRY* csWGLRESTOREBUFFERREGIONARB) (HANDLE hRegion, GLint x, GLint y, GLint width, GLint height, GLint xSrc, GLint ySrc);

#endif

// GL_ARB_texture_cube_map
#ifndef GL_NORMAL_MAP_ARB
#define GL_NORMAL_MAP_ARB                                             34065
#endif

#ifndef GL_REFLECTION_MAP_ARB
#define GL_REFLECTION_MAP_ARB                                         34066
#endif

#ifndef GL_TEXTURE_CUBE_MAP_ARB
#define GL_TEXTURE_CUBE_MAP_ARB                                       34067
#endif

#ifndef GL_TEXTURE_BINDING_CUBE_MAP_ARB
#define GL_TEXTURE_BINDING_CUBE_MAP_ARB                               34068
#endif

#ifndef GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB                            34069
#endif

#ifndef GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB                            34070
#endif

#ifndef GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB                            34071
#endif

#ifndef GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB                            34072
#endif

#ifndef GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB                            34073
#endif

#ifndef GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB                            34074
#endif

#ifndef GL_PROXY_TEXTURE_CUBE_MAP_ARB
#define GL_PROXY_TEXTURE_CUBE_MAP_ARB                                 34075
#endif

#ifndef GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB                              34076
#endif



// GL_ARB_depth_texture
#ifndef GL_DEPTH_COMPONENT16_ARB
#define GL_DEPTH_COMPONENT16_ARB                                      33189
#endif

#ifndef GL_DEPTH_COMPONENT24_ARB
#define GL_DEPTH_COMPONENT24_ARB                                      33190
#endif

#ifndef GL_DEPTH_COMPONENT32_ARB
#define GL_DEPTH_COMPONENT32_ARB                                      33191
#endif

#ifndef GL_TEXTURE_DEPTH_SIZE_ARB
#define GL_TEXTURE_DEPTH_SIZE_ARB                                     34890
#endif

#ifndef GL_DEPTH_TEXTURE_MODE_ARB
#define GL_DEPTH_TEXTURE_MODE_ARB                                     34891
#endif



// GL_ARB_point_parameters
#ifndef GL_POINT_SIZE_MIN_ARB
#define GL_POINT_SIZE_MIN_ARB                                         33062
#endif

#ifndef GL_POINT_SIZE_MAX_ARB
#define GL_POINT_SIZE_MAX_ARB                                         33063
#endif

#ifndef GL_POINT_FADE_THRESHOLD_SIZE_ARB
#define GL_POINT_FADE_THRESHOLD_SIZE_ARB                              33064
#endif

#ifndef GL_POINT_DISTANCE_ATTENUATION_ARB
#define GL_POINT_DISTANCE_ATTENUATION_ARB                             33065
#endif


typedef GLvoid (csAPIENTRY* csGLPOINTPARAMETERFARB) (GLenum pname, GLfloat param);
typedef GLvoid (csAPIENTRY* csGLPOINTPARAMETERFVARB) (GLenum pname, GLfloat* params);

// GL_ARB_shadow
#ifndef GL_TEXTURE_COMPARE_MODE_ARB
#define GL_TEXTURE_COMPARE_MODE_ARB                                   34892
#endif

#ifndef GL_TEXTURE_COMPARE_FUNC_ARB
#define GL_TEXTURE_COMPARE_FUNC_ARB                                   34893
#endif

#ifndef GL_COMPARE_R_TO_TEXTURE_ARB
#define GL_COMPARE_R_TO_TEXTURE_ARB                                   34894
#endif



// GL_ARB_shadow_ambient
#ifndef GL_TEXTURE_COMPARE_FAIL_VALUE_ARB
#define GL_TEXTURE_COMPARE_FAIL_VALUE_ARB                             32959
#endif



// GL_ARB_texture_border_clamp
#ifndef GL_CLAMP_TO_BORDER_ARB
#define GL_CLAMP_TO_BORDER_ARB                                        33069
#endif



// GL_ARB_texture_compression
#ifndef GL_COMPRESSED_ALPHA_ARB
#define GL_COMPRESSED_ALPHA_ARB                                       34025
#endif

#ifndef GL_COMPRESSED_LUMINANCE_ARB
#define GL_COMPRESSED_LUMINANCE_ARB                                   34026
#endif

#ifndef GL_COMPRESSED_LUMINANCE_ALPHA_ARB
#define GL_COMPRESSED_LUMINANCE_ALPHA_ARB                             34027
#endif

#ifndef GL_COMPRESSED_INTENSITY_ARB
#define GL_COMPRESSED_INTENSITY_ARB                                   34028
#endif

#ifndef GL_COMPRESSED_RGB_ARB
#define GL_COMPRESSED_RGB_ARB                                         34029
#endif

#ifndef GL_COMPRESSED_RGBA_ARB
#define GL_COMPRESSED_RGBA_ARB                                        34030
#endif

#ifndef GL_TEXTURE_COMPRESSION_HINT_ARB
#define GL_TEXTURE_COMPRESSION_HINT_ARB                               34031
#endif

#ifndef GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB
#define GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB                          34464
#endif

#ifndef GL_TEXTURE_COMPRESSED_ARB
#define GL_TEXTURE_COMPRESSED_ARB                                     34465
#endif

#ifndef GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB
#define GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB                         34466
#endif

#ifndef GL_COMPRESSED_TEXTURE_FORMATS_ARB
#define GL_COMPRESSED_TEXTURE_FORMATS_ARB                             34467
#endif


typedef GLvoid (csAPIENTRY* csGLCOMPRESSEDTEXIMAGE3DARB) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLCOMPRESSEDTEXIMAGE2DARB) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLCOMPRESSEDTEXIMAGE1DARB) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLCOMPRESSEDTEXSUBIMAGE3DARB) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLCOMPRESSEDTEXSUBIMAGE2DARB) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLCOMPRESSEDTEXSUBIMAGE1DARB) (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLGETCOMPRESSEDTEXIMAGEARB) (GLenum target, GLint lod, GLvoid* img);

// GL_ARB_texture_env_combine
#ifndef GL_COMBINE_ARB
#define GL_COMBINE_ARB                                                34160
#endif

#ifndef GL_COMBINE_RGB_ARB
#define GL_COMBINE_RGB_ARB                                            34161
#endif

#ifndef GL_COMBINE_ALPHA_ARB
#define GL_COMBINE_ALPHA_ARB                                          34162
#endif

#ifndef GL_SOURCE0_RGB_ARB
#define GL_SOURCE0_RGB_ARB                                            34176
#endif

#ifndef GL_SOURCE1_RGB_ARB
#define GL_SOURCE1_RGB_ARB                                            34177
#endif

#ifndef GL_SOURCE2_RGB_ARB
#define GL_SOURCE2_RGB_ARB                                            34178
#endif

#ifndef GL_SOURCE0_ALPHA_ARB
#define GL_SOURCE0_ALPHA_ARB                                          34184
#endif

#ifndef GL_SOURCE1_ALPHA_ARB
#define GL_SOURCE1_ALPHA_ARB                                          34185
#endif

#ifndef GL_SOURCE2_ALPHA_ARB
#define GL_SOURCE2_ALPHA_ARB                                          34186
#endif

#ifndef GL_OPERAND0_RGB_ARB
#define GL_OPERAND0_RGB_ARB                                           34192
#endif

#ifndef GL_OPERAND1_RGB_ARB
#define GL_OPERAND1_RGB_ARB                                           34193
#endif

#ifndef GL_OPERAND2_RGB_ARB
#define GL_OPERAND2_RGB_ARB                                           34194
#endif

#ifndef GL_OPERAND0_ALPHA_ARB
#define GL_OPERAND0_ALPHA_ARB                                         34200
#endif

#ifndef GL_OPERAND1_ALPHA_ARB
#define GL_OPERAND1_ALPHA_ARB                                         34201
#endif

#ifndef GL_OPERAND2_ALPHA_ARB
#define GL_OPERAND2_ALPHA_ARB                                         34202
#endif

#ifndef GL_RGB_SCALE_ARB
#define GL_RGB_SCALE_ARB                                              34163
#endif

#ifndef GL_ADD_SIGNED_ARB
#define GL_ADD_SIGNED_ARB                                             34164
#endif

#ifndef GL_INTERPOLATE_ARB
#define GL_INTERPOLATE_ARB                                            34165
#endif

#ifndef GL_SUBTRACT_ARB
#define GL_SUBTRACT_ARB                                               34023
#endif

#ifndef GL_CONSTANT_ARB
#define GL_CONSTANT_ARB                                               34166
#endif

#ifndef GL_PRIMARY_COLOR_ARB
#define GL_PRIMARY_COLOR_ARB                                          34167
#endif

#ifndef GL_PREVIOUS_ARB
#define GL_PREVIOUS_ARB                                               34168
#endif



// GL_ARB_texture_env_crossbar


// GL_ARB_texture_env_dot3
#ifndef GL_DOT3_RGB_ARB
#define GL_DOT3_RGB_ARB                                               34478
#endif

#ifndef GL_DOT3_RGBA_ARB
#define GL_DOT3_RGBA_ARB                                              34479
#endif



// GL_ARB_texture_mirrored_repeat
#ifndef GL_MIRRORED_REPEAT_ARB
#define GL_MIRRORED_REPEAT_ARB                                        33648
#endif



// GL_ARB_vertex_blend
#ifndef GL_MAX_VERTEX_UNITS_ARB
#define GL_MAX_VERTEX_UNITS_ARB                                       34468
#endif

#ifndef GL_ACTIVE_VERTEX_UNITS_ARB
#define GL_ACTIVE_VERTEX_UNITS_ARB                                    34469
#endif

#ifndef GL_WEIGHT_SUM_UNITY_ARB
#define GL_WEIGHT_SUM_UNITY_ARB                                       34470
#endif

#ifndef GL_VERTEX_BLEND_ARB
#define GL_VERTEX_BLEND_ARB                                           34471
#endif

#ifndef GL_MODELVIEW0_ARB
#define GL_MODELVIEW0_ARB                                              5888
#endif

#ifndef GL_MODELVIEW1_ARB
#define GL_MODELVIEW1_ARB                                             34058
#endif

#ifndef GL_MODELVIEW2_ARB
#define GL_MODELVIEW2_ARB                                             34594
#endif

#ifndef GL_MODELVIEW3_ARB
#define GL_MODELVIEW3_ARB                                             34595
#endif

#ifndef GL_MODELVIEW4_ARB
#define GL_MODELVIEW4_ARB                                             34596
#endif

#ifndef GL_MODELVIEW5_ARB
#define GL_MODELVIEW5_ARB                                             34597
#endif

#ifndef GL_MODELVIEW6_ARB
#define GL_MODELVIEW6_ARB                                             34598
#endif

#ifndef GL_MODELVIEW7_ARB
#define GL_MODELVIEW7_ARB                                             34599
#endif

#ifndef GL_MODELVIEW8_ARB
#define GL_MODELVIEW8_ARB                                             34600
#endif

#ifndef GL_MODELVIEW9_ARB
#define GL_MODELVIEW9_ARB                                             34601
#endif

#ifndef GL_MODELVIEW10_ARB
#define GL_MODELVIEW10_ARB                                            34602
#endif

#ifndef GL_MODELVIEW11_ARB
#define GL_MODELVIEW11_ARB                                            34603
#endif

#ifndef GL_MODELVIEW12_ARB
#define GL_MODELVIEW12_ARB                                            34604
#endif

#ifndef GL_MODELVIEW13_ARB
#define GL_MODELVIEW13_ARB                                            34605
#endif

#ifndef GL_MODELVIEW14_ARB
#define GL_MODELVIEW14_ARB                                            34606
#endif

#ifndef GL_MODELVIEW15_ARB
#define GL_MODELVIEW15_ARB                                            34607
#endif

#ifndef GL_MODELVIEW16_ARB
#define GL_MODELVIEW16_ARB                                            34608
#endif

#ifndef GL_MODELVIEW17_ARB
#define GL_MODELVIEW17_ARB                                            34609
#endif

#ifndef GL_MODELVIEW18_ARB
#define GL_MODELVIEW18_ARB                                            34610
#endif

#ifndef GL_MODELVIEW19_ARB
#define GL_MODELVIEW19_ARB                                            34611
#endif

#ifndef GL_MODELVIEW20_ARB
#define GL_MODELVIEW20_ARB                                            34612
#endif

#ifndef GL_MODELVIEW21_ARB
#define GL_MODELVIEW21_ARB                                            34613
#endif

#ifndef GL_MODELVIEW22_ARB
#define GL_MODELVIEW22_ARB                                            34614
#endif

#ifndef GL_MODELVIEW23_ARB
#define GL_MODELVIEW23_ARB                                            34615
#endif

#ifndef GL_MODELVIEW24_ARB
#define GL_MODELVIEW24_ARB                                            34616
#endif

#ifndef GL_MODELVIEW25_ARB
#define GL_MODELVIEW25_ARB                                            34617
#endif

#ifndef GL_MODELVIEW26_ARB
#define GL_MODELVIEW26_ARB                                            34618
#endif

#ifndef GL_MODELVIEW27_ARB
#define GL_MODELVIEW27_ARB                                            34619
#endif

#ifndef GL_MODELVIEW28_ARB
#define GL_MODELVIEW28_ARB                                            34620
#endif

#ifndef GL_MODELVIEW29_ARB
#define GL_MODELVIEW29_ARB                                            34621
#endif

#ifndef GL_MODELVIEW30_ARB
#define GL_MODELVIEW30_ARB                                            34622
#endif

#ifndef GL_MODELVIEW31_ARB
#define GL_MODELVIEW31_ARB                                            34623
#endif

#ifndef GL_CURRENT_WEIGHT_ARB
#define GL_CURRENT_WEIGHT_ARB                                         34472
#endif

#ifndef GL_WEIGHT_ARRAY_TYPE_ARB
#define GL_WEIGHT_ARRAY_TYPE_ARB                                      34473
#endif

#ifndef GL_WEIGHT_ARRAY_STRIDE_ARB
#define GL_WEIGHT_ARRAY_STRIDE_ARB                                    34474
#endif

#ifndef GL_WEIGHT_ARRAY_SIZE_ARB
#define GL_WEIGHT_ARRAY_SIZE_ARB                                      34475
#endif

#ifndef GL_WEIGHT_ARRAY_POINTER_ARB
#define GL_WEIGHT_ARRAY_POINTER_ARB                                   34476
#endif

#ifndef GL_WEIGHT_ARRAY_ARB
#define GL_WEIGHT_ARRAY_ARB                                           34477
#endif


typedef GLvoid (csAPIENTRY* csGLWEIGHTBVARB) (GLint size, GLbyte* weights);
typedef GLvoid (csAPIENTRY* csGLWEIGHTSVARB) (GLint size, GLshort* weights);
typedef GLvoid (csAPIENTRY* csGLWEIGHTIVARB) (GLint size, GLint* weights);
typedef GLvoid (csAPIENTRY* csGLWEIGHTFVARB) (GLint size, GLfloat* weights);
typedef GLvoid (csAPIENTRY* csGLWEIGHTDVARB) (GLint size, GLdouble* weights);
typedef GLvoid (csAPIENTRY* csGLWEIGHTVARB) (GLint size, GLdouble* weights);
typedef GLvoid (csAPIENTRY* csGLWEIGHTUBVARB) (GLint size, GLubyte* weights);
typedef GLvoid (csAPIENTRY* csGLWEIGHTUSVARB) (GLint size, GLushort* weights);
typedef GLvoid (csAPIENTRY* csGLWEIGHTUIVARB) (GLint size, GLuint* weights);
typedef GLvoid (csAPIENTRY* csGLWEIGHTPOINTERARB) (GLint size, GLenum type, GLsizei stride, GLvoid* pointer);
typedef GLvoid (csAPIENTRY* csGLVERTEXBLENDARB) (GLint count);

// GL_ARB_vertex_program
#ifndef GL_VERTEX_PROGRAM_ARB
#define GL_VERTEX_PROGRAM_ARB                                         34336
#endif

#ifndef GL_VERTEX_PROGRAM_POINT_SIZE_ARB
#define GL_VERTEX_PROGRAM_POINT_SIZE_ARB                              34370
#endif

#ifndef GL_VERTEX_PROGRAM_TWO_SIDE_ARB
#define GL_VERTEX_PROGRAM_TWO_SIDE_ARB                                34371
#endif

#ifndef GL_COLOR_SUM_ARB
#define GL_COLOR_SUM_ARB                                              33880
#endif

#ifndef GL_PROGRAM_FORMAT_ASCII_ARB
#define GL_PROGRAM_FORMAT_ASCII_ARB                                   34933
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB
#define GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB                            34338
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB
#define GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB                               34339
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB
#define GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB                             34340
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB
#define GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB                               34341
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB
#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB                         34922
#endif

#ifndef GL_CURRENT_VERTEX_ATTRIB_ARB
#define GL_CURRENT_VERTEX_ATTRIB_ARB                                  34342
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB
#define GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB                            34373
#endif

#ifndef GL_PROGRAM_LENGTH_ARB
#define GL_PROGRAM_LENGTH_ARB                                         34343
#endif

#ifndef GL_PROGRAM_FORMAT_ARB
#define GL_PROGRAM_FORMAT_ARB                                         34934
#endif

#ifndef GL_PROGRAM_BINDING_ARB
#define GL_PROGRAM_BINDING_ARB                                        34423
#endif

#ifndef GL_PROGRAM_INSTRUCTIONS_ARB
#define GL_PROGRAM_INSTRUCTIONS_ARB                                   34976
#endif

#ifndef GL_MAX_PROGRAM_INSTRUCTIONS_ARB
#define GL_MAX_PROGRAM_INSTRUCTIONS_ARB                               34977
#endif

#ifndef GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB
#define GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB                            34978
#endif

#ifndef GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB
#define GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB                        34979
#endif

#ifndef GL_PROGRAM_TEMPORARIES_ARB
#define GL_PROGRAM_TEMPORARIES_ARB                                    34980
#endif

#ifndef GL_MAX_PROGRAM_TEMPORARIES_ARB
#define GL_MAX_PROGRAM_TEMPORARIES_ARB                                34981
#endif

#ifndef GL_PROGRAM_NATIVE_TEMPORARIES_ARB
#define GL_PROGRAM_NATIVE_TEMPORARIES_ARB                             34982
#endif

#ifndef GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB
#define GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB                         34983
#endif

#ifndef GL_PROGRAM_PARAMETERS_ARB
#define GL_PROGRAM_PARAMETERS_ARB                                     34984
#endif

#ifndef GL_MAX_PROGRAM_PARAMETERS_ARB
#define GL_MAX_PROGRAM_PARAMETERS_ARB                                 34985
#endif

#ifndef GL_PROGRAM_NATIVE_PARAMETERS_ARB
#define GL_PROGRAM_NATIVE_PARAMETERS_ARB                              34986
#endif

#ifndef GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB
#define GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB                          34987
#endif

#ifndef GL_PROGRAM_ATTRIBS_ARB
#define GL_PROGRAM_ATTRIBS_ARB                                        34988
#endif

#ifndef GL_MAX_PROGRAM_ATTRIBS_ARB
#define GL_MAX_PROGRAM_ATTRIBS_ARB                                    34989
#endif

#ifndef GL_PROGRAM_NATIVE_ATTRIBS_ARB
#define GL_PROGRAM_NATIVE_ATTRIBS_ARB                                 34990
#endif

#ifndef GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB
#define GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB                             34991
#endif

#ifndef GL_PROGRAM_ADDRESS_REGISTERS_ARB
#define GL_PROGRAM_ADDRESS_REGISTERS_ARB                              34992
#endif

#ifndef GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB
#define GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB                          34993
#endif

#ifndef GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB
#define GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB                       34994
#endif

#ifndef GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB
#define GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB                   34995
#endif

#ifndef GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB
#define GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB                           34996
#endif

#ifndef GL_MAX_PROGRAM_ENV_PARAMETERS_ARB
#define GL_MAX_PROGRAM_ENV_PARAMETERS_ARB                             34997
#endif

#ifndef GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB
#define GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB                            34998
#endif

#ifndef GL_PROGRAM_STRING_ARB
#define GL_PROGRAM_STRING_ARB                                         34344
#endif

#ifndef GL_PROGRAM_ERROR_POSITION_ARB
#define GL_PROGRAM_ERROR_POSITION_ARB                                 34379
#endif

#ifndef GL_CURRENT_MATRIX_ARB
#define GL_CURRENT_MATRIX_ARB                                         34369
#endif

#ifndef GL_TRANSPOSE_CURRENT_MATRIX_ARB
#define GL_TRANSPOSE_CURRENT_MATRIX_ARB                               34999
#endif

#ifndef GL_CURRENT_MATRIX_STACK_DEPTH_ARB
#define GL_CURRENT_MATRIX_STACK_DEPTH_ARB                             34368
#endif

#ifndef GL_MAX_VERTEX_ATTRIBS_ARB
#define GL_MAX_VERTEX_ATTRIBS_ARB                                     34921
#endif

#ifndef GL_MAX_PROGRAM_MATRICES_ARB
#define GL_MAX_PROGRAM_MATRICES_ARB                                   34351
#endif

#ifndef GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB
#define GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB                         34350
#endif

#ifndef GL_PROGRAM_ERROR_STRING_ARB
#define GL_PROGRAM_ERROR_STRING_ARB                                   34932
#endif

#ifndef GL_MATRIX0_ARB
#define GL_MATRIX0_ARB                                                35008
#endif

#ifndef GL_MATRIX1_ARB
#define GL_MATRIX1_ARB                                                35009
#endif

#ifndef GL_MATRIX2_ARB
#define GL_MATRIX2_ARB                                                35010
#endif

#ifndef GL_MATRIX3_ARB
#define GL_MATRIX3_ARB                                                35011
#endif

#ifndef GL_MATRIX4_ARB
#define GL_MATRIX4_ARB                                                35012
#endif

#ifndef GL_MATRIX5_ARB
#define GL_MATRIX5_ARB                                                35013
#endif

#ifndef GL_MATRIX6_ARB
#define GL_MATRIX6_ARB                                                35014
#endif

#ifndef GL_MATRIX7_ARB
#define GL_MATRIX7_ARB                                                35015
#endif

#ifndef GL_MATRIX8_ARB
#define GL_MATRIX8_ARB                                                35016
#endif

#ifndef GL_MATRIX9_ARB
#define GL_MATRIX9_ARB                                                35017
#endif

#ifndef GL_MATRIX10_ARB
#define GL_MATRIX10_ARB                                               35018
#endif

#ifndef GL_MATRIX11_ARB
#define GL_MATRIX11_ARB                                               35019
#endif

#ifndef GL_MATRIX12_ARB
#define GL_MATRIX12_ARB                                               35020
#endif

#ifndef GL_MATRIX13_ARB
#define GL_MATRIX13_ARB                                               35021
#endif

#ifndef GL_MATRIX14_ARB
#define GL_MATRIX14_ARB                                               35022
#endif

#ifndef GL_MATRIX15_ARB
#define GL_MATRIX15_ARB                                               35023
#endif

#ifndef GL_MATRIX16_ARB
#define GL_MATRIX16_ARB                                               35024
#endif

#ifndef GL_MATRIX17_ARB
#define GL_MATRIX17_ARB                                               35025
#endif

#ifndef GL_MATRIX18_ARB
#define GL_MATRIX18_ARB                                               35026
#endif

#ifndef GL_MATRIX19_ARB
#define GL_MATRIX19_ARB                                               35027
#endif

#ifndef GL_MATRIX20_ARB
#define GL_MATRIX20_ARB                                               35028
#endif

#ifndef GL_MATRIX21_ARB
#define GL_MATRIX21_ARB                                               35029
#endif

#ifndef GL_MATRIX22_ARB
#define GL_MATRIX22_ARB                                               35030
#endif

#ifndef GL_MATRIX23_ARB
#define GL_MATRIX23_ARB                                               35031
#endif

#ifndef GL_MATRIX24_ARB
#define GL_MATRIX24_ARB                                               35032
#endif

#ifndef GL_MATRIX25_ARB
#define GL_MATRIX25_ARB                                               35033
#endif

#ifndef GL_MATRIX26_ARB
#define GL_MATRIX26_ARB                                               35034
#endif

#ifndef GL_MATRIX27_ARB
#define GL_MATRIX27_ARB                                               35035
#endif

#ifndef GL_MATRIX28_ARB
#define GL_MATRIX28_ARB                                               35036
#endif

#ifndef GL_MATRIX29_ARB
#define GL_MATRIX29_ARB                                               35037
#endif

#ifndef GL_MATRIX30_ARB
#define GL_MATRIX30_ARB                                               35038
#endif

#ifndef GL_MATRIX31_ARB
#define GL_MATRIX31_ARB                                               35039
#endif


typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB1SARB) (GLuint index, GLshort x);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB1FARB) (GLuint index, GLfloat x);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB1DARB) (GLuint index, GLdouble x);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB2SARB) (GLuint index, GLshort x, GLshort y);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB2FARB) (GLuint index, GLfloat x, GLfloat y);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB2DARB) (GLuint index, GLdouble x, GLdouble y);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB3SARB) (GLuint index, GLshort x, GLshort y, GLshort z);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB3FARB) (GLuint index, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB3DARB) (GLuint index, GLdouble x, GLdouble y, GLdouble z);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4SARB) (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4FARB) (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4DARB) (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4NUBARB) (GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB1SVARB) (GLuint index, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB1FVARB) (GLuint index, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB1DVARB) (GLuint index, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB2SVARB) (GLuint index, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB2FVARB) (GLuint index, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB2DVARB) (GLuint index, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB3SVARB) (GLuint index, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB3FVARB) (GLuint index, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB3DVARB) (GLuint index, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4BVARB) (GLuint index, const GLbyte* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4SVARB) (GLuint index, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4IVARB) (GLuint index, const GLint* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4UBVARB) (GLuint index, const GLubyte* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4USVARB) (GLuint index, const GLushort* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4UIVARB) (GLuint index, const GLuint* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4FVARB) (GLuint index, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4DVARB) (GLuint index, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4NBVARB) (GLuint index, const GLbyte* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4NSVARB) (GLuint index, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4NIVARB) (GLuint index, const GLint* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4NUBVARB) (GLuint index, const GLubyte* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4NUSVARB) (GLuint index, const GLushort* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4NUIVARB) (GLuint index, const GLuint* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIBPOINTERARB) (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid* pointer);
typedef GLvoid (csAPIENTRY* csGLENABLEVERTEXATTRIBARRAYARB) (GLuint index);
typedef GLvoid (csAPIENTRY* csGLDISABLEVERTEXATTRIBARRAYARB) (GLuint index);
typedef GLvoid (csAPIENTRY* csGLPROGRAMSTRINGARB) (GLenum target, GLenum format, GLsizei len, const GLvoid* string);
typedef GLvoid (csAPIENTRY* csGLBINDPROGRAMARB) (GLenum target, GLuint program);
typedef GLvoid (csAPIENTRY* csGLDELETEPROGRAMSARB) (GLsizei n, const GLuint* programs);
typedef GLvoid (csAPIENTRY* csGLGENPROGRAMSARB) (GLsizei n, GLuint* programs);
typedef GLvoid (csAPIENTRY* csGLPROGRAMENVPARAMETER4DARB) (GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
typedef GLvoid (csAPIENTRY* csGLPROGRAMENVPARAMETER4DVARB) (GLenum target, GLuint index, const GLdouble* params);
typedef GLvoid (csAPIENTRY* csGLPROGRAMENVPARAMETER4FARB) (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef GLvoid (csAPIENTRY* csGLPROGRAMENVPARAMETER4FVARB) (GLenum target, GLuint index, const GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLPROGRAMLOCALPARAMETER4DARB) (GLenum target, GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
typedef GLvoid (csAPIENTRY* csGLPROGRAMLOCALPARAMETER4DVARB) (GLenum target, GLuint index, const GLdouble* params);
typedef GLvoid (csAPIENTRY* csGLPROGRAMLOCALPARAMETER4FARB) (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef GLvoid (csAPIENTRY* csGLPROGRAMLOCALPARAMETER4FVARB) (GLenum target, GLuint index, const GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETPROGRAMENVPARAMETERDVARB) (GLenum target, GLuint index, GLdouble* params);
typedef GLvoid (csAPIENTRY* csGLGETPROGRAMENVPARAMETERFVARB) (GLenum target, GLuint index, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETPROGRAMLOCALPARAMETERDVARB) (GLenum target, GLuint index, GLdouble* params);
typedef GLvoid (csAPIENTRY* csGLGETPROGRAMLOCALPARAMETERFVARB) (GLenum target, GLuint index, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETPROGRAMIVARB) (GLenum target, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETPROGRAMSTRINGARB) (GLenum target, GLenum pname, GLvoid* string);
typedef GLvoid (csAPIENTRY* csGLGETVERTEXATTRIBDVARB) (GLuint index, GLenum pname, GLdouble* params);
typedef GLvoid (csAPIENTRY* csGLGETVERTEXATTRIBFVARB) (GLuint index, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETVERTEXATTRIBIVARB) (GLuint index, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETVERTEXATTRIBPOINTERVARB) (GLuint index, GLenum pname, GLvoid** pointer);
typedef GLboolean (csAPIENTRY* csGLISPROGRAMARB) (GLuint program);

// GL_ARB_window_pos

typedef GLvoid (csAPIENTRY* csGLWINDOWPOS2DARB) (GLdouble x, GLdouble y);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS2FARB) (GLfloat x, GLfloat y);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS2IARB) (GLint x, GLint y);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS2SARB) (GLshort x, GLshort y);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS2DVARB) (const GLdouble* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS2FVARB) (const GLfloat* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS2IVARB) (const GLint* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS2SVARB) (const GLshort* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS3DARB) (GLdouble x, GLdouble y, GLdouble z);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS3FARB) (GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS3IARB) (GLint x, GLint y, GLint z);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS3SARB) (GLshort x, GLshort y, GLshort z);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS3DVARB) (const GLdouble* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS3FVARB) (const GLfloat* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS3IVARB) (const GLint* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS3SVARB) (const GLshort* p);

// GL_EXT_422_pixels
#ifndef GL_422_EXT
#define GL_422_EXT                                                    32972
#endif

#ifndef GL_422_REV_EXT
#define GL_422_REV_EXT                                                32973
#endif

#ifndef GL_422_AVERAGE_EXT
#define GL_422_AVERAGE_EXT                                            32974
#endif

#ifndef GL_422_REV_AVERAGE_EXT
#define GL_422_REV_AVERAGE_EXT                                        32975
#endif



// GL_EXT_abgr
#ifndef GL_ABGR_EXT
#define GL_ABGR_EXT                                                   32768
#endif



// GL_EXT_bgra
#ifndef GL_BGR_EXT
#define GL_BGR_EXT                                                    32992
#endif

#ifndef GL_BGRA_EXT
#define GL_BGRA_EXT                                                   32993
#endif



// GL_EXT_blend_color
#ifndef GL_CONSTANT_COLOR_EXT
#define GL_CONSTANT_COLOR_EXT                                         32769
#endif

#ifndef GL_ONE_MINUS_CONSTANT_COLOR_EXT
#define GL_ONE_MINUS_CONSTANT_COLOR_EXT                               32770
#endif

#ifndef GL_CONSTANT_ALPHA_EXT
#define GL_CONSTANT_ALPHA_EXT                                         32771
#endif

#ifndef GL_ONE_MINUS_CONSTANT_ALPHA_EXT
#define GL_ONE_MINUS_CONSTANT_ALPHA_EXT                               32772
#endif

#ifndef GL_BLEND_COLOR_EXT
#define GL_BLEND_COLOR_EXT                                            32773
#endif


typedef GLvoid (csAPIENTRY* csGLBLENDCOLOREXT) (GLclampf red, GLclampf green, GLclampf blue, GLclampf alpha);

// GL_EXT_blend_func_separate
#ifndef GL_BLEND_DST_RGB_EXT
#define GL_BLEND_DST_RGB_EXT                                          32968
#endif

#ifndef GL_BLEND_SRC_RGB_EXT
#define GL_BLEND_SRC_RGB_EXT                                          32969
#endif

#ifndef GL_BLEND_DST_ALPHA_EXT
#define GL_BLEND_DST_ALPHA_EXT                                        32970
#endif

#ifndef GL_BLEND_SRC_ALPHA_EXT
#define GL_BLEND_SRC_ALPHA_EXT                                        32971
#endif


typedef GLvoid (csAPIENTRY* csGLBLENDFUNCSEPARATEEXT) (GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);

// GL_EXT_blend_logic_op


// GL_EXT_blend_minmax
#ifndef GL_FUNC_ADD_EXT
#define GL_FUNC_ADD_EXT                                               32774
#endif

#ifndef GL_MIN_EXT
#define GL_MIN_EXT                                                    32775
#endif

#ifndef GL_MAX_EXT
#define GL_MAX_EXT                                                    32776
#endif

#ifndef GL_BLEND_EQUATION_EXT
#define GL_BLEND_EQUATION_EXT                                         32777
#endif


typedef GLvoid (csAPIENTRY* csGLBLENDEQUATIONEXT) (GLenum mode);

// GL_EXT_blend_subtract
#ifndef GL_FUNC_SUBTRACT_EXT
#define GL_FUNC_SUBTRACT_EXT                                          32778
#endif

#ifndef GL_FUNC_REVERSE_SUBTRACT_EXT
#define GL_FUNC_REVERSE_SUBTRACT_EXT                                  32779
#endif



// GL_EXT_clip_volume_hint
#ifndef GL_CLIP_VOLUME_CLIPPING_HINT_EXT
#define GL_CLIP_VOLUME_CLIPPING_HINT_EXT                              33008
#endif



// GL_EXT_color_subtable

typedef GLvoid (csAPIENTRY* csGLCOLORSUBTABLEEXT) (GLenum target, GLsizei start, GLsizei count, GLenum format, GLenum type, const GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLCOPYCOLORSUBTABLEEXT) (GLenum target, GLsizei start, GLint x, GLint y, GLsizei width);

// GL_EXT_compiled_vertex_array
#ifndef GL_ARRAY_ELEMENT_LOCK_FIRST_EXT
#define GL_ARRAY_ELEMENT_LOCK_FIRST_EXT                               33192
#endif

#ifndef GL_ARRAY_ELEMENT_LOCK_COUNT_EXT
#define GL_ARRAY_ELEMENT_LOCK_COUNT_EXT                               33193
#endif


typedef GLvoid (csAPIENTRY* csGLLOCKARRAYSEXT) (GLint first, GLsizei count);
typedef GLvoid (csAPIENTRY* csGLUNLOCKARRAYSEXT) ();

// GL_EXT_convolution
#ifndef GL_CONVOLUTION_1D_EXT
#define GL_CONVOLUTION_1D_EXT                                         32784
#endif

#ifndef GL_CONVOLUTION_2D_EXT
#define GL_CONVOLUTION_2D_EXT                                         32785
#endif

#ifndef GL_SEPARABLE_2D_EXT
#define GL_SEPARABLE_2D_EXT                                           32786
#endif

#ifndef GL_CONVOLUTION_BORDER_MODE_EXT
#define GL_CONVOLUTION_BORDER_MODE_EXT                                32787
#endif

#ifndef GL_CONVOLUTION_FILTER_SCALE_EXT
#define GL_CONVOLUTION_FILTER_SCALE_EXT                               32788
#endif

#ifndef GL_CONVOLUTION_FILTER_BIAS_EXT
#define GL_CONVOLUTION_FILTER_BIAS_EXT                                32789
#endif

#ifndef GL_REDUCE_EXT
#define GL_REDUCE_EXT                                                 32790
#endif

#ifndef GL_CONVOLUTION_FORMAT_EXT
#define GL_CONVOLUTION_FORMAT_EXT                                     32791
#endif

#ifndef GL_CONVOLUTION_WIDTH_EXT
#define GL_CONVOLUTION_WIDTH_EXT                                      32792
#endif

#ifndef GL_CONVOLUTION_HEIGHT_EXT
#define GL_CONVOLUTION_HEIGHT_EXT                                     32793
#endif

#ifndef GL_MAX_CONVOLUTION_WIDTH_EXT
#define GL_MAX_CONVOLUTION_WIDTH_EXT                                  32794
#endif

#ifndef GL_MAX_CONVOLUTION_HEIGHT_EXT
#define GL_MAX_CONVOLUTION_HEIGHT_EXT                                 32795
#endif

#ifndef GL_POST_CONVOLUTION_RED_SCALE_EXT
#define GL_POST_CONVOLUTION_RED_SCALE_EXT                             32796
#endif

#ifndef GL_POST_CONVOLUTION_GREEN_SCALE_EXT
#define GL_POST_CONVOLUTION_GREEN_SCALE_EXT                           32797
#endif

#ifndef GL_POST_CONVOLUTION_BLUE_SCALE_EXT
#define GL_POST_CONVOLUTION_BLUE_SCALE_EXT                            32798
#endif

#ifndef GL_POST_CONVOLUTION_ALPHA_SCALE_EXT
#define GL_POST_CONVOLUTION_ALPHA_SCALE_EXT                           32799
#endif

#ifndef GL_POST_CONVOLUTION_RED_BIAS_EXT
#define GL_POST_CONVOLUTION_RED_BIAS_EXT                              32800
#endif

#ifndef GL_POST_CONVOLUTION_GREEN_BIAS_EXT
#define GL_POST_CONVOLUTION_GREEN_BIAS_EXT                            32801
#endif

#ifndef GL_POST_CONVOLUTION_BLUE_BIAS_EXT
#define GL_POST_CONVOLUTION_BLUE_BIAS_EXT                             32802
#endif

#ifndef GL_POST_CONVOLUTION_ALPHA_BIAS_EXT
#define GL_POST_CONVOLUTION_ALPHA_BIAS_EXT                            32803
#endif


typedef GLvoid (csAPIENTRY* csGLCONVOLUTIONFILTER1DEXT) (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid* image);
typedef GLvoid (csAPIENTRY* csGLCONVOLUTIONFILTER2DEXT) (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid* image);
typedef GLvoid (csAPIENTRY* csGLCOPYCONVOLUTIONFILTER1DEXT) (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
typedef GLvoid (csAPIENTRY* csGLCOPYCONVOLUTIONFILTER2DEXT) (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height);
typedef GLvoid (csAPIENTRY* csGLGETCONVOLUTIONFILTEREXT) (GLenum target, GLenum format, GLenum type, GLvoid* image);
typedef GLvoid (csAPIENTRY* csGLSEPARABLEFILTER2DEXT) (GLenum target, GLenum internalformat, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid* row, const GLvoid* column);
typedef GLvoid (csAPIENTRY* csGLGETSEPARABLEFILTEREXT) (GLenum target, GLenum format, GLenum type, GLvoid* row, GLvoid* column, GLvoid* span);
typedef GLvoid (csAPIENTRY* csGLCONVOLUTIONPARAMETERIEXT) (GLenum target, GLenum pname, GLint param);
typedef GLvoid (csAPIENTRY* csGLCONVOLUTIONPARAMETERIVEXT) (GLenum target, GLenum pname, const GLint* params);
typedef GLvoid (csAPIENTRY* csGLCONVOLUTIONPARAMETERFEXT) (GLenum target, GLenum pname, GLfloat param);
typedef GLvoid (csAPIENTRY* csGLCONVOLUTIONPARAMETERFVEXT) (GLenum target, GLenum pname, const GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETCONVOLUTIONPARAMETERIVEXT) (GLenum target, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETCONVOLUTIONPARAMETERFVEXT) (GLenum target, GLenum pname, GLfloat* params);

// GL_EXT_fog_coord
#ifndef GL_FOG_COORDINATE_SOURCE_EXT
#define GL_FOG_COORDINATE_SOURCE_EXT                                  33872
#endif

#ifndef GL_FOG_COORDINATE_EXT
#define GL_FOG_COORDINATE_EXT                                         33873
#endif

#ifndef GL_FRAGMENT_DEPTH_EXT
#define GL_FRAGMENT_DEPTH_EXT                                         33874
#endif

#ifndef GL_CURRENT_FOG_COORDINATE_EXT
#define GL_CURRENT_FOG_COORDINATE_EXT                                 33875
#endif

#ifndef GL_FOG_COORDINATE_ARRAY_TYPE_EXT
#define GL_FOG_COORDINATE_ARRAY_TYPE_EXT                              33876
#endif

#ifndef GL_FOG_COORDINATE_ARRAY_STRIDE_EXT
#define GL_FOG_COORDINATE_ARRAY_STRIDE_EXT                            33877
#endif

#ifndef GL_FOG_COORDINATE_ARRAY_POINTER_EXT
#define GL_FOG_COORDINATE_ARRAY_POINTER_EXT                           33878
#endif

#ifndef GL_FOG_COORDINATE_ARRAY_EXT
#define GL_FOG_COORDINATE_ARRAY_EXT                                   33879
#endif


typedef GLvoid (csAPIENTRY* csGLFOGCOORDFEXFLOAT) (GLfloat coord);
typedef GLvoid (csAPIENTRY* csGLFOGCOORDDEXDOUBLE) (GLdouble coord);
typedef GLvoid (csAPIENTRY* csGLFOGCOORDFVEXFLOAT) (GLfloat coord);
typedef GLvoid (csAPIENTRY* csGLFOGCOORDDVEXDOUBLE) (GLdouble coord);
typedef GLvoid (csAPIENTRY* csGLFOGCOORDPOINTEREXT) (GLenum type, GLsizei stride, GLvoid* pointer);

// GL_EXT_histogram
#ifndef GL_HISTOGRAM_EXT
#define GL_HISTOGRAM_EXT                                              32804
#endif

#ifndef GL_PROXY_HISTOGRAM_EXT
#define GL_PROXY_HISTOGRAM_EXT                                        32805
#endif

#ifndef GL_HISTOGRAM_WIDTH_EXT
#define GL_HISTOGRAM_WIDTH_EXT                                        32806
#endif

#ifndef GL_HISTOGRAM_FORMAT_EXT
#define GL_HISTOGRAM_FORMAT_EXT                                       32807
#endif

#ifndef GL_HISTOGRAM_RED_SIZE_EXT
#define GL_HISTOGRAM_RED_SIZE_EXT                                     32808
#endif

#ifndef GL_HISTOGRAM_GREEN_SIZE_EXT
#define GL_HISTOGRAM_GREEN_SIZE_EXT                                   32809
#endif

#ifndef GL_HISTOGRAM_BLUE_SIZE_EXT
#define GL_HISTOGRAM_BLUE_SIZE_EXT                                    32810
#endif

#ifndef GL_HISTOGRAM_ALPHA_SIZE_EXT
#define GL_HISTOGRAM_ALPHA_SIZE_EXT                                   32811
#endif

#ifndef GL_HISTOGRAM_LUMINANCE_SIZE_EXT
#define GL_HISTOGRAM_LUMINANCE_SIZE_EXT                               32812
#endif

#ifndef GL_HISTOGRAM_SINK_EXT
#define GL_HISTOGRAM_SINK_EXT                                         32813
#endif

#ifndef GL_MINMAX_EXT
#define GL_MINMAX_EXT                                                 32814
#endif

#ifndef GL_MINMAX_FORMAT_EXT
#define GL_MINMAX_FORMAT_EXT                                          32815
#endif

#ifndef GL_MINMAX_SINK_EXT
#define GL_MINMAX_SINK_EXT                                            32816
#endif


typedef GLvoid (csAPIENTRY* csGLHISTOGRAMEXT) (GLenum target, GLsizei width, GLenum internalformat, GLboolean sink);
typedef GLvoid (csAPIENTRY* csGLRESETHISTOGRAMEXT) (GLenum target);
typedef GLvoid (csAPIENTRY* csGLGETHISTOGRAMEXT) (GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid* values);
typedef GLvoid (csAPIENTRY* csGLGETHISTOGRAMPARAMETERIVEXT) (GLenum target, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETHISTOGRAMPARAMETERFVEXT) (GLenum target, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLMINMAXEXT) (GLenum target, GLenum internalformat, GLboolean sink);
typedef GLvoid (csAPIENTRY* csGLRESETMINMAXEXT) (GLenum target);
typedef GLvoid (csAPIENTRY* csGLGETMINMAXEXT) (GLenum target, GLboolean reset, GLenum format, GLenum type, GLvoid* values);
typedef GLvoid (csAPIENTRY* csGLGETMINMAXPARAMETERIVEXT) (GLenum target, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETMINMAXPARAMETERFVEXT) (GLenum target, GLenum pname, GLfloat* params);

// GL_EXT_multi_draw_arrays

typedef GLvoid (csAPIENTRY* csGLMULTIDRAWARRAYSEXT) (GLenum mode, GLint* first, GLsizei* count, GLsizei primcount);
typedef GLvoid (csAPIENTRY* csGLMULTIDRAWELEMENTSEXT) (GLenum mode, GLsizei* count, GLenum type, const GLvoid* indices, GLsizei primcount);

// GL_EXT_packed_pixels
#ifndef GL_UNSIGNED_BYTE_3_3_2_EXT
#define GL_UNSIGNED_BYTE_3_3_2_EXT                                    32818
#endif

#ifndef GL_UNSIGNED_SHORT_4_4_4_4_EXT
#define GL_UNSIGNED_SHORT_4_4_4_4_EXT                                 32819
#endif

#ifndef GL_UNSIGNED_SHORT_5_5_5_1_EXT
#define GL_UNSIGNED_SHORT_5_5_5_1_EXT                                 32820
#endif

#ifndef GL_UNSIGNED_INT_8_8_8_8_EXT
#define GL_UNSIGNED_INT_8_8_8_8_EXT                                   32821
#endif

#ifndef GL_UNSIGNED_INT_10_10_10_2_EXT
#define GL_UNSIGNED_INT_10_10_10_2_EXT                                32822
#endif



// GL_EXT_paletted_texture
#ifndef GL_COLOR_INDEX1_EXT
#define GL_COLOR_INDEX1_EXT                                           32994
#endif

#ifndef GL_COLOR_INDEX2_EXT
#define GL_COLOR_INDEX2_EXT                                           32995
#endif

#ifndef GL_COLOR_INDEX4_EXT
#define GL_COLOR_INDEX4_EXT                                           32996
#endif

#ifndef GL_COLOR_INDEX8_EXT
#define GL_COLOR_INDEX8_EXT                                           32997
#endif

#ifndef GL_COLOR_INDEX12_EXT
#define GL_COLOR_INDEX12_EXT                                          32998
#endif

#ifndef GL_COLOR_INDEX16_EXT
#define GL_COLOR_INDEX16_EXT                                          32999
#endif

#ifndef GL_COLOR_TABLE_FORMAT_EXT
#define GL_COLOR_TABLE_FORMAT_EXT                                     32984
#endif

#ifndef GL_COLOR_TABLE_WIDTH_EXT
#define GL_COLOR_TABLE_WIDTH_EXT                                      32985
#endif

#ifndef GL_COLOR_TABLE_RED_SIZE_EXT
#define GL_COLOR_TABLE_RED_SIZE_EXT                                   32986
#endif

#ifndef GL_COLOR_TABLE_GREEN_SIZE_EXT
#define GL_COLOR_TABLE_GREEN_SIZE_EXT                                 32987
#endif

#ifndef GL_COLOR_TABLE_BLUE_SIZE_EXT
#define GL_COLOR_TABLE_BLUE_SIZE_EXT                                  32988
#endif

#ifndef GL_COLOR_TABLE_ALPHA_SIZE_EXT
#define GL_COLOR_TABLE_ALPHA_SIZE_EXT                                 32989
#endif

#ifndef GL_COLOR_TABLE_LUMINANCE_SIZE_EXT
#define GL_COLOR_TABLE_LUMINANCE_SIZE_EXT                             32990
#endif

#ifndef GL_COLOR_TABLE_INTENSITY_SIZE_EXT
#define GL_COLOR_TABLE_INTENSITY_SIZE_EXT                             32991
#endif

#ifndef GL_TEXTURE_INDEX_SIZE_EXT
#define GL_TEXTURE_INDEX_SIZE_EXT                                     33005
#endif

#ifndef GL_TEXTURE_1D
#define GL_TEXTURE_1D                                                  3552
#endif

#ifndef GL_TEXTURE_2D
#define GL_TEXTURE_2D                                                  3553
#endif

#ifndef GL_TEXTURE_3D_EXT
#define GL_TEXTURE_3D_EXT                                             32879
#endif

#ifndef GL_TEXTURE_CUBE_MAP_ARB
#define GL_TEXTURE_CUBE_MAP_ARB                                       34067
#endif

#ifndef GL_PROXY_TEXTURE_1D
#define GL_PROXY_TEXTURE_1D                                           32867
#endif

#ifndef GL_PROXY_TEXTURE_2D
#define GL_PROXY_TEXTURE_2D                                           32868
#endif

#ifndef GL_PROXY_TEXTURE_3D_EXT
#define GL_PROXY_TEXTURE_3D_EXT                                       32880
#endif

#ifndef GL_PROXY_TEXTURE_CUBE_MAP_ARB
#define GL_PROXY_TEXTURE_CUBE_MAP_ARB                                 34075
#endif

#ifndef GL_TEXTURE_1D
#define GL_TEXTURE_1D                                                  3552
#endif

#ifndef GL_TEXTURE_2D
#define GL_TEXTURE_2D                                                  3553
#endif

#ifndef GL_TEXTURE_3D_EXT
#define GL_TEXTURE_3D_EXT                                             32879
#endif

#ifndef GL_TEXTURE_CUBE_MAP_ARB
#define GL_TEXTURE_CUBE_MAP_ARB                                       34067
#endif


typedef GLvoid (csAPIENTRY* csGLCOLORTABLEEXT) (GLenum target, GLenum internalFormat, GLsizei width, GLenum format, GLenum type, const GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLGETCOLORTABLEEXT) (GLenum target, GLenum format, GLenum type, GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLGETCOLORTABLEPARAMETERIVEXT) (GLenum target, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETCOLORTABLEPARAMETERFVEXT) (GLenum target, GLenum pname, GLfloat* params);

// GL_EXT_point_parameters
#ifndef GL_POINT_SIZE_MIN_EXT
#define GL_POINT_SIZE_MIN_EXT                                         33062
#endif

#ifndef GL_POINT_SIZE_MAX_EXT
#define GL_POINT_SIZE_MAX_EXT                                         33063
#endif

#ifndef GL_POINT_FADE_THRESHOLD_SIZE_EXT
#define GL_POINT_FADE_THRESHOLD_SIZE_EXT                              33064
#endif

#ifndef GL_DISTANCE_ATTENUATION_EXT
#define GL_DISTANCE_ATTENUATION_EXT                                   33065
#endif


typedef GLvoid (csAPIENTRY* csGLPOINTPARAMETERFEXT) (GLenum pname, GLfloat param);
typedef GLvoid (csAPIENTRY* csGLPOINTPARAMETERFVEXT) (GLenum pname, GLfloat* params);

// GL_EXT_polygon_offset
#ifndef GL_POLYGON_OFFSET_EXT
#define GL_POLYGON_OFFSET_EXT                                         32823
#endif

#ifndef GL_POLYGON_OFFSET_FACTOR_EXT
#define GL_POLYGON_OFFSET_FACTOR_EXT                                  32824
#endif

#ifndef GL_POLYGON_OFFSET_BIAS_EXT
#define GL_POLYGON_OFFSET_BIAS_EXT                                    32825
#endif


typedef GLvoid (csAPIENTRY* csGLPOLYGONOFFSETEXT) (GLfloat factor, GLfloat bias);

// GL_EXT_secondary_color
#ifndef GL_COLOR_SUM_EXT
#define GL_COLOR_SUM_EXT                                              33880
#endif

#ifndef GL_CURRENT_SECONDARY_COLOR_EXT
#define GL_CURRENT_SECONDARY_COLOR_EXT                                33881
#endif

#ifndef GL_SECONDARY_COLOR_ARRAY_SIZE_EXT
#define GL_SECONDARY_COLOR_ARRAY_SIZE_EXT                             33882
#endif

#ifndef GL_SECONDARY_COLOR_ARRAY_TYPE_EXT
#define GL_SECONDARY_COLOR_ARRAY_TYPE_EXT                             33883
#endif

#ifndef GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT
#define GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT                           33884
#endif

#ifndef GL_SECONDARY_COLOR_ARRAY_POINTER_EXT
#define GL_SECONDARY_COLOR_ARRAY_POINTER_EXT                          33885
#endif

#ifndef GL_SECONDARY_COLOR_ARRAY_EXT
#define GL_SECONDARY_COLOR_ARRAY_EXT                                  33886
#endif


typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLOR3BEXT) (GLbyte components);
typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLOR3SEXT) (GLshort components);
typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLOR3IEXT) (GLint components);
typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLOR3FEXT) (GLfloat components);
typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLOR3DEXT) (GLdouble components);
typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLOR3UBEXT) (GLubyte components);
typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLOR3USEXT) (GLushort components);
typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLOR3UIEXT) (GLuint components);
typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLOR3BVEXT) (GLbyte components);
typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLOR3SVEXT) (GLshort components);
typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLOR3IVEXT) (GLint components);
typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLOR3FVEXT) (GLfloat components);
typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLOR3DVEXT) (GLdouble components);
typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLOR3UBVEXT) (GLubyte components);
typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLOR3USVEXT) (GLushort components);
typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLOR3UIVEXT) (GLuint components);
typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLORPOINTEREXT) (GLint size, GLenum type, GLsizei stride, GLvoid* pointer);

// GL_EXT_separate_specular_color
#ifndef GL_LIGHT_MODEL_COLOR_CONTROL_EXT
#define GL_LIGHT_MODEL_COLOR_CONTROL_EXT                              33272
#endif

#ifndef GL_SINGLE_COLOR_EXT
#define GL_SINGLE_COLOR_EXT                                           33273
#endif

#ifndef GL_SEPARATE_SPECULAR_COLOR_EXT
#define GL_SEPARATE_SPECULAR_COLOR_EXT                                33274
#endif



// GL_EXT_shadow_funcs


// GL_EXT_shared_texture_palette
#ifndef GL_SHARED_TEXTURE_PALETTE_EXT
#define GL_SHARED_TEXTURE_PALETTE_EXT                                 33275
#endif



// GL_EXT_stencil_two_side
#ifndef GL_STENCIL_TEST_TWO_SIDE_EXT
#define GL_STENCIL_TEST_TWO_SIDE_EXT                                  35088
#endif

#ifndef GL_ACTIVE_STENCIL_FACE_EXT
#define GL_ACTIVE_STENCIL_FACE_EXT                                    35089
#endif


typedef GLvoid (csAPIENTRY* csGLACTIVESTENCILFACEEXT) (GLenum face);

// GL_EXT_stencil_wrap
#ifndef GL_INCR_WRAP_EXT
#define GL_INCR_WRAP_EXT                                              34055
#endif

#ifndef GL_DECR_WRAP_EXT
#define GL_DECR_WRAP_EXT                                              34056
#endif



// GL_EXT_subtexture

typedef GLvoid (csAPIENTRY* csGLTEXSUBIMAGE1DEXT) (GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid* pixels);
typedef GLvoid (csAPIENTRY* csGLTEXSUBIMAGE2DEXT) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid* pixels);
typedef GLvoid (csAPIENTRY* csGLTEXSUBIMAGE3DEXT) (GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid* pixels);

// GL_EXT_texture3D
#ifndef GL_PACK_SKIP_IMAGES_EXT
#define GL_PACK_SKIP_IMAGES_EXT                                       32875
#endif

#ifndef GL_PACK_IMAGE_HEIGHT_EXT
#define GL_PACK_IMAGE_HEIGHT_EXT                                      32876
#endif

#ifndef GL_UNPACK_SKIP_IMAGES_EXT
#define GL_UNPACK_SKIP_IMAGES_EXT                                     32877
#endif

#ifndef GL_UNPACK_IMAGE_HEIGHT_EXT
#define GL_UNPACK_IMAGE_HEIGHT_EXT                                    32878
#endif

#ifndef GL_TEXTURE_3D_EXT
#define GL_TEXTURE_3D_EXT                                             32879
#endif

#ifndef GL_PROXY_TEXTURE_3D_EXT
#define GL_PROXY_TEXTURE_3D_EXT                                       32880
#endif

#ifndef GL_TEXTURE_DEPTH_EXT
#define GL_TEXTURE_DEPTH_EXT                                          32881
#endif

#ifndef GL_TEXTURE_WRAP_R_EXT
#define GL_TEXTURE_WRAP_R_EXT                                         32882
#endif

#ifndef GL_MAX_3D_TEXTURE_SIZE_EXT
#define GL_MAX_3D_TEXTURE_SIZE_EXT                                    32883
#endif


typedef GLvoid (csAPIENTRY* csGLTEXIMAGE3DEXT) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid* pixels);

// GL_EXT_texture_compression_s3tc
#ifndef GL_COMPRESSED_RGB_S3TC_DXT1_EXT
#define GL_COMPRESSED_RGB_S3TC_DXT1_EXT                               33776
#endif

#ifndef GL_COMPRESSED_RGBA_S3TC_DXT1_EXT
#define GL_COMPRESSED_RGBA_S3TC_DXT1_EXT                              33777
#endif

#ifndef GL_COMPRESSED_RGBA_S3TC_DXT3_EXT
#define GL_COMPRESSED_RGBA_S3TC_DXT3_EXT                              33778
#endif

#ifndef GL_COMPRESSED_RGBA_S3TC_DXT5_EXT
#define GL_COMPRESSED_RGBA_S3TC_DXT5_EXT                              33779
#endif



// GL_EXT_texture_env_add


// GL_EXT_texture_env_combine
#ifndef GL_COMBINE_EXT
#define GL_COMBINE_EXT                                                34160
#endif

#ifndef GL_COMBINE_RGB_EXT
#define GL_COMBINE_RGB_EXT                                            34161
#endif

#ifndef GL_COMBINE_ALPHA_EXT
#define GL_COMBINE_ALPHA_EXT                                          34162
#endif

#ifndef GL_SOURCE0_RGB_EXT
#define GL_SOURCE0_RGB_EXT                                            34176
#endif

#ifndef GL_SOURCE1_RGB_EXT
#define GL_SOURCE1_RGB_EXT                                            34177
#endif

#ifndef GL_SOURCE2_RGB_EXT
#define GL_SOURCE2_RGB_EXT                                            34178
#endif

#ifndef GL_SOURCE0_ALPHA_EXT
#define GL_SOURCE0_ALPHA_EXT                                          34184
#endif

#ifndef GL_SOURCE1_ALPHA_EXT
#define GL_SOURCE1_ALPHA_EXT                                          34185
#endif

#ifndef GL_SOURCE2_ALPHA_EXT
#define GL_SOURCE2_ALPHA_EXT                                          34186
#endif

#ifndef GL_OPERAND0_RGB_EXT
#define GL_OPERAND0_RGB_EXT                                           34192
#endif

#ifndef GL_OPERAND1_RGB_EXT
#define GL_OPERAND1_RGB_EXT                                           34193
#endif

#ifndef GL_OPERAND2_RGB_EXT
#define GL_OPERAND2_RGB_EXT                                           34194
#endif

#ifndef GL_OPERAND0_ALPHA_EXT
#define GL_OPERAND0_ALPHA_EXT                                         34200
#endif

#ifndef GL_OPERAND1_ALPHA_EXT
#define GL_OPERAND1_ALPHA_EXT                                         34201
#endif

#ifndef GL_OPERAND2_ALPHA_EXT
#define GL_OPERAND2_ALPHA_EXT                                         34202
#endif

#ifndef GL_RGB_SCALE_EXT
#define GL_RGB_SCALE_EXT                                              34163
#endif

#ifndef GL_ADD_SIGNED_EXT
#define GL_ADD_SIGNED_EXT                                             34164
#endif

#ifndef GL_INTERPOLATE_EXT
#define GL_INTERPOLATE_EXT                                            34165
#endif

#ifndef GL_CONSTANT_EXT
#define GL_CONSTANT_EXT                                               34166
#endif

#ifndef GL_PRIMARY_COLOR_EXT
#define GL_PRIMARY_COLOR_EXT                                          34167
#endif

#ifndef GL_PREVIOUS_EXT
#define GL_PREVIOUS_EXT                                               34168
#endif



// GL_EXT_texture_env_dot3
#ifndef GL_DOT3_RGB_EXT
#define GL_DOT3_RGB_EXT                                               34624
#endif

#ifndef GL_DOT3_RGBA_EXT
#define GL_DOT3_RGBA_EXT                                              34625
#endif



// GL_EXT_texture_filter_anisotropic
#ifndef GL_TEXTURE_MAX_ANISOTROPY_EXT
#define GL_TEXTURE_MAX_ANISOTROPY_EXT                                 34046
#endif

#ifndef GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT
#define GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT                             34047
#endif



// GL_EXT_texture_lod_bias
#ifndef GL_TEXTURE_FILTER_CONTROL_EXT
#define GL_TEXTURE_FILTER_CONTROL_EXT                                 34048
#endif

#ifndef GL_TEXTURE_LOD_BIAS_EXT
#define GL_TEXTURE_LOD_BIAS_EXT                                       34049
#endif

#ifndef GL_MAX_TEXTURE_LOD_BIAS_EXT
#define GL_MAX_TEXTURE_LOD_BIAS_EXT                                   34045
#endif



// GL_EXT_texture_object
#ifndef GL_TEXTURE_PRIORITY_EXT
#define GL_TEXTURE_PRIORITY_EXT                                       32870
#endif

#ifndef GL_TEXTURE_RESIDENT_EXT
#define GL_TEXTURE_RESIDENT_EXT                                       32871
#endif

#ifndef GL_TEXTURE_1D_BINDING_EXT
#define GL_TEXTURE_1D_BINDING_EXT                                     32872
#endif

#ifndef GL_TEXTURE_2D_BINDING_EXT
#define GL_TEXTURE_2D_BINDING_EXT                                     32873
#endif

#ifndef GL_TEXTURE_3D_BINDING_EXT
#define GL_TEXTURE_3D_BINDING_EXT                                     32874
#endif


typedef GLvoid (csAPIENTRY* csGLGENTEXTURESEXT) (GLsizei n, GLuint* textures);
typedef GLvoid (csAPIENTRY* csGLDELETETEXTURESEXT) (GLsizei n, const GLuint* textures);
typedef GLvoid (csAPIENTRY* csGLBINDTEXTUREEXT) (GLenum target, GLuint texture);
typedef GLvoid (csAPIENTRY* csGLPRIORITIZETEXTURESEXT) (GLsizei n, const GLuint* textures, const GLclampf* priorities);
typedef GLboolean (csAPIENTRY* csGLARETEXTURESRESIDENTEXT) (GLsizei n, const GLuint* textures, GLboolean* residences);
typedef GLboolean (csAPIENTRY* csGLISTEXTUREEXT) (GLuint texture);

// GL_EXT_vertex_array
#ifndef GL_VERTEX_ARRAY_EXT
#define GL_VERTEX_ARRAY_EXT                                           32884
#endif

#ifndef GL_NORMAL_ARRAY_EXT
#define GL_NORMAL_ARRAY_EXT                                           32885
#endif

#ifndef GL_COLOR_ARRAY_EXT
#define GL_COLOR_ARRAY_EXT                                            32886
#endif

#ifndef GL_INDEX_ARRAY_EXT
#define GL_INDEX_ARRAY_EXT                                            32887
#endif

#ifndef GL_TEXTURE_COORD_ARRAY_EXT
#define GL_TEXTURE_COORD_ARRAY_EXT                                    32888
#endif

#ifndef GL_EDGE_FLAG_ARRAY_EXT
#define GL_EDGE_FLAG_ARRAY_EXT                                        32889
#endif

#ifndef GL_DOUBLE_EXT
#define GL_DOUBLE_EXT                                                  5130
#endif

#ifndef GL_VERTEX_ARRAY_SIZE_EXT
#define GL_VERTEX_ARRAY_SIZE_EXT                                      32890
#endif

#ifndef GL_VERTEX_ARRAY_TYPE_EXT
#define GL_VERTEX_ARRAY_TYPE_EXT                                      32891
#endif

#ifndef GL_VERTEX_ARRAY_STRIDE_EXT
#define GL_VERTEX_ARRAY_STRIDE_EXT                                    32892
#endif

#ifndef GL_VERTEX_ARRAY_COUNT_EXT
#define GL_VERTEX_ARRAY_COUNT_EXT                                     32893
#endif

#ifndef GL_NORMAL_ARRAY_TYPE_EXT
#define GL_NORMAL_ARRAY_TYPE_EXT                                      32894
#endif

#ifndef GL_NORMAL_ARRAY_STRIDE_EXT
#define GL_NORMAL_ARRAY_STRIDE_EXT                                    32895
#endif

#ifndef GL_NORMAL_ARRAY_COUNT_EXT
#define GL_NORMAL_ARRAY_COUNT_EXT                                     32896
#endif

#ifndef GL_COLOR_ARRAY_SIZE_EXT
#define GL_COLOR_ARRAY_SIZE_EXT                                       32897
#endif

#ifndef GL_COLOR_ARRAY_TYPE_EXT
#define GL_COLOR_ARRAY_TYPE_EXT                                       32898
#endif

#ifndef GL_COLOR_ARRAY_STRIDE_EXT
#define GL_COLOR_ARRAY_STRIDE_EXT                                     32899
#endif

#ifndef GL_COLOR_ARRAY_COUNT_EXT
#define GL_COLOR_ARRAY_COUNT_EXT                                      32900
#endif

#ifndef GL_INDEX_ARRAY_TYPE_EXT
#define GL_INDEX_ARRAY_TYPE_EXT                                       32901
#endif

#ifndef GL_INDEX_ARRAY_STRIDE_EXT
#define GL_INDEX_ARRAY_STRIDE_EXT                                     32902
#endif

#ifndef GL_INDEX_ARRAY_COUNT_EXT
#define GL_INDEX_ARRAY_COUNT_EXT                                      32903
#endif

#ifndef GL_TEXTURE_COORD_ARRAY_SIZE_EXT
#define GL_TEXTURE_COORD_ARRAY_SIZE_EXT                               32904
#endif

#ifndef GL_TEXTURE_COORD_ARRAY_TYPE_EXT
#define GL_TEXTURE_COORD_ARRAY_TYPE_EXT                               32905
#endif

#ifndef GL_TEXTURE_COORD_ARRAY_STRIDE_EXT
#define GL_TEXTURE_COORD_ARRAY_STRIDE_EXT                             32906
#endif

#ifndef GL_TEXTURE_COORD_ARRAY_COUNT_EXT
#define GL_TEXTURE_COORD_ARRAY_COUNT_EXT                              32907
#endif

#ifndef GL_EDGE_FLAG_ARRAY_STRIDE_EXT
#define GL_EDGE_FLAG_ARRAY_STRIDE_EXT                                 32908
#endif

#ifndef GL_EDGE_FLAG_ARRAY_COUNT_EXT
#define GL_EDGE_FLAG_ARRAY_COUNT_EXT                                  32909
#endif

#ifndef GL_VERTEX_ARRAY_POINTER_EXT
#define GL_VERTEX_ARRAY_POINTER_EXT                                   32910
#endif

#ifndef GL_NORMAL_ARRAY_POINTER_EXT
#define GL_NORMAL_ARRAY_POINTER_EXT                                   32911
#endif

#ifndef GL_COLOR_ARRAY_POINTER_EXT
#define GL_COLOR_ARRAY_POINTER_EXT                                    32912
#endif

#ifndef GL_INDEX_ARRAY_POINTER_EXT
#define GL_INDEX_ARRAY_POINTER_EXT                                    32913
#endif

#ifndef GL_TEXTURE_COORD_ARRAY_POINTER_EXT
#define GL_TEXTURE_COORD_ARRAY_POINTER_EXT                            32914
#endif

#ifndef GL_EDGE_FLAG_ARRAY_POINTER_EXT
#define GL_EDGE_FLAG_ARRAY_POINTER_EXT                                32915
#endif


typedef GLvoid (csAPIENTRY* csGLARRAYELEMENTEXT) (GLint i);
typedef GLvoid (csAPIENTRY* csGLDRAWARRAYSEXT) (GLenum mode, GLint first, GLsizei count);
typedef GLvoid (csAPIENTRY* csGLVERTEXPOINTEREXT) (GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid* pointer);
typedef GLvoid (csAPIENTRY* csGLNORMALPOINTEREXT) (GLenum type, GLsizei stride, GLsizei count, const GLvoid* pointer);
typedef GLvoid (csAPIENTRY* csGLCOLORPOINTEREXT) (GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid* pointer);
typedef GLvoid (csAPIENTRY* csGLINDEXPOINTEREXT) (GLenum type, GLsizei stride, GLsizei count, const GLvoid* pointer);
typedef GLvoid (csAPIENTRY* csGLTEXCOORDPOINTEREXT) (GLint size, GLenum type, GLsizei stride, GLsizei count, const GLvoid* pointer);
typedef GLvoid (csAPIENTRY* csGLEDGEFLAGPOINTEREXT) (GLsizei stride, GLsizei count, const GLboolean* pointer);
typedef GLvoid (csAPIENTRY* csGLGETPOINTERVEXT) (GLenum pname, GLvoid* params);

// GL_EXT_vertex_shader
#ifndef GL_VERTEX_SHADER_EXT
#define GL_VERTEX_SHADER_EXT                                          34688
#endif

#ifndef GL_VARIANT_VALUE_EXT
#define GL_VARIANT_VALUE_EXT                                          34788
#endif

#ifndef GL_VARIANT_DATATYPE_EXT
#define GL_VARIANT_DATATYPE_EXT                                       34789
#endif

#ifndef GL_VARIANT_ARRAY_STRIDE_EXT
#define GL_VARIANT_ARRAY_STRIDE_EXT                                   34790
#endif

#ifndef GL_VARIANT_ARRAY_TYPE_EXT
#define GL_VARIANT_ARRAY_TYPE_EXT                                     34791
#endif

#ifndef GL_VARIANT_ARRAY_EXT
#define GL_VARIANT_ARRAY_EXT                                          34792
#endif

#ifndef GL_VARIANT_ARRAY_POINTER_EXT
#define GL_VARIANT_ARRAY_POINTER_EXT                                  34793
#endif

#ifndef GL_INVARIANT_VALUE_EXT
#define GL_INVARIANT_VALUE_EXT                                        34794
#endif

#ifndef GL_INVARIANT_DATATYPE_EXT
#define GL_INVARIANT_DATATYPE_EXT                                     34795
#endif

#ifndef GL_LOCAL_CONSTANT_VALUE_EXT
#define GL_LOCAL_CONSTANT_VALUE_EXT                                   34796
#endif

#ifndef GL_LOCAL_CONSTANT_DATATYPE_EXT
#define GL_LOCAL_CONSTANT_DATATYPE_EXT                                34797
#endif

#ifndef GL_OP_INDEX_EXT
#define GL_OP_INDEX_EXT                                               34690
#endif

#ifndef GL_OP_NEGATE_EXT
#define GL_OP_NEGATE_EXT                                              34691
#endif

#ifndef GL_OP_DOT3_EXT
#define GL_OP_DOT3_EXT                                                34692
#endif

#ifndef GL_OP_DOT4_EXT
#define GL_OP_DOT4_EXT                                                34693
#endif

#ifndef GL_OP_MUL_EXT
#define GL_OP_MUL_EXT                                                 34694
#endif

#ifndef GL_OP_ADD_EXT
#define GL_OP_ADD_EXT                                                 34695
#endif

#ifndef GL_OP_MADD_EXT
#define GL_OP_MADD_EXT                                                34696
#endif

#ifndef GL_OP_FRAC_EXT
#define GL_OP_FRAC_EXT                                                34697
#endif

#ifndef GL_OP_MAX_EXT
#define GL_OP_MAX_EXT                                                 34698
#endif

#ifndef GL_OP_MIN_EXT
#define GL_OP_MIN_EXT                                                 34699
#endif

#ifndef GL_OP_SET_GE_EXT
#define GL_OP_SET_GE_EXT                                              34700
#endif

#ifndef GL_OP_SET_LT_EXT
#define GL_OP_SET_LT_EXT                                              34701
#endif

#ifndef GL_OP_CLAMP_EXT
#define GL_OP_CLAMP_EXT                                               34702
#endif

#ifndef GL_OP_FLOOR_EXT
#define GL_OP_FLOOR_EXT                                               34703
#endif

#ifndef GL_OP_ROUND_EXT
#define GL_OP_ROUND_EXT                                               34704
#endif

#ifndef GL_OP_EXP_BASE_2_EXT
#define GL_OP_EXP_BASE_2_EXT                                          34705
#endif

#ifndef GL_OP_LOG_BASE_2_EXT
#define GL_OP_LOG_BASE_2_EXT                                          34706
#endif

#ifndef GL_OP_POWER_EXT
#define GL_OP_POWER_EXT                                               34707
#endif

#ifndef GL_OP_RECIP_EXT
#define GL_OP_RECIP_EXT                                               34708
#endif

#ifndef GL_OP_RECIP_SQRT_EXT
#define GL_OP_RECIP_SQRT_EXT                                          34709
#endif

#ifndef GL_OP_SUB_EXT
#define GL_OP_SUB_EXT                                                 34710
#endif

#ifndef GL_OP_CROSS_PRODUCT_EXT
#define GL_OP_CROSS_PRODUCT_EXT                                       34711
#endif

#ifndef GL_OP_MULTIPLY_MATRIX_EXT
#define GL_OP_MULTIPLY_MATRIX_EXT                                     34712
#endif

#ifndef GL_OP_MOV_EXT
#define GL_OP_MOV_EXT                                                 34713
#endif

#ifndef GL_OUTPUT_VERTEX_EXT
#define GL_OUTPUT_VERTEX_EXT                                          34714
#endif

#ifndef GL_OUTPUT_COLOR0_EXT
#define GL_OUTPUT_COLOR0_EXT                                          34715
#endif

#ifndef GL_OUTPUT_COLOR1_EXT
#define GL_OUTPUT_COLOR1_EXT                                          34716
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD0_EXT
#define GL_OUTPUT_TEXTURE_COORD0_EXT                                  34717
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD1_EXT
#define GL_OUTPUT_TEXTURE_COORD1_EXT                                  34718
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD2_EXT
#define GL_OUTPUT_TEXTURE_COORD2_EXT                                  34719
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD3_EXT
#define GL_OUTPUT_TEXTURE_COORD3_EXT                                  34720
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD4_EXT
#define GL_OUTPUT_TEXTURE_COORD4_EXT                                  34721
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD5_EXT
#define GL_OUTPUT_TEXTURE_COORD5_EXT                                  34722
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD6_EXT
#define GL_OUTPUT_TEXTURE_COORD6_EXT                                  34723
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD7_EXT
#define GL_OUTPUT_TEXTURE_COORD7_EXT                                  34724
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD8_EXT
#define GL_OUTPUT_TEXTURE_COORD8_EXT                                  34725
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD9_EXT
#define GL_OUTPUT_TEXTURE_COORD9_EXT                                  34726
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD10_EXT
#define GL_OUTPUT_TEXTURE_COORD10_EXT                                 34727
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD11_EXT
#define GL_OUTPUT_TEXTURE_COORD11_EXT                                 34728
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD12_EXT
#define GL_OUTPUT_TEXTURE_COORD12_EXT                                 34729
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD13_EXT
#define GL_OUTPUT_TEXTURE_COORD13_EXT                                 34730
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD14_EXT
#define GL_OUTPUT_TEXTURE_COORD14_EXT                                 34731
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD15_EXT
#define GL_OUTPUT_TEXTURE_COORD15_EXT                                 34732
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD16_EXT
#define GL_OUTPUT_TEXTURE_COORD16_EXT                                 34733
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD17_EXT
#define GL_OUTPUT_TEXTURE_COORD17_EXT                                 34734
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD18_EXT
#define GL_OUTPUT_TEXTURE_COORD18_EXT                                 34735
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD19_EXT
#define GL_OUTPUT_TEXTURE_COORD19_EXT                                 34736
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD20_EXT
#define GL_OUTPUT_TEXTURE_COORD20_EXT                                 34737
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD21_EXT
#define GL_OUTPUT_TEXTURE_COORD21_EXT                                 34738
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD22_EXT
#define GL_OUTPUT_TEXTURE_COORD22_EXT                                 34739
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD23_EXT
#define GL_OUTPUT_TEXTURE_COORD23_EXT                                 34740
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD24_EXT
#define GL_OUTPUT_TEXTURE_COORD24_EXT                                 34741
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD25_EXT
#define GL_OUTPUT_TEXTURE_COORD25_EXT                                 34742
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD26_EXT
#define GL_OUTPUT_TEXTURE_COORD26_EXT                                 34743
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD27_EXT
#define GL_OUTPUT_TEXTURE_COORD27_EXT                                 34744
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD28_EXT
#define GL_OUTPUT_TEXTURE_COORD28_EXT                                 34745
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD29_EXT
#define GL_OUTPUT_TEXTURE_COORD29_EXT                                 34746
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD30_EXT
#define GL_OUTPUT_TEXTURE_COORD30_EXT                                 34747
#endif

#ifndef GL_OUTPUT_TEXTURE_COORD31_EXT
#define GL_OUTPUT_TEXTURE_COORD31_EXT                                 34748
#endif

#ifndef GL_OUTPUT_FOG_EXT
#define GL_OUTPUT_FOG_EXT                                             34749
#endif

#ifndef GL_SCALAR_EXT
#define GL_SCALAR_EXT                                                 34750
#endif

#ifndef GL_VECTOR_EXT
#define GL_VECTOR_EXT                                                 34751
#endif

#ifndef GL_MATRIX_EXT
#define GL_MATRIX_EXT                                                 34752
#endif

#ifndef GL_VARIANT_EXT
#define GL_VARIANT_EXT                                                34753
#endif

#ifndef GL_INVARIANT_EXT
#define GL_INVARIANT_EXT                                              34754
#endif

#ifndef GL_LOCAL_CONSTANT_EXT
#define GL_LOCAL_CONSTANT_EXT                                         34755
#endif

#ifndef GL_LOCAL_EXT
#define GL_LOCAL_EXT                                                  34756
#endif

#ifndef GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT
#define GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT                         34757
#endif

#ifndef GL_MAX_VERTEX_SHADER_VARIANTS_EXT
#define GL_MAX_VERTEX_SHADER_VARIANTS_EXT                             34758
#endif

#ifndef GL_MAX_VERTEX_SHADER_INVARIANTS_EXT
#define GL_MAX_VERTEX_SHADER_INVARIANTS_EXT                           34759
#endif

#ifndef GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
#define GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT                      34760
#endif

#ifndef GL_MAX_VERTEX_SHADER_LOCALS_EXT
#define GL_MAX_VERTEX_SHADER_LOCALS_EXT                               34761
#endif

#ifndef GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT
#define GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT               34762
#endif

#ifndef GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT
#define GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT                   34763
#endif

#ifndef GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
#define GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT            34764
#endif

#ifndef GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT
#define GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT                 34765
#endif

#ifndef GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT
#define GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT                     34766
#endif

#ifndef GL_VERTEX_SHADER_INSTRUCTIONS_EXT
#define GL_VERTEX_SHADER_INSTRUCTIONS_EXT                             34767
#endif

#ifndef GL_VERTEX_SHADER_VARIANTS_EXT
#define GL_VERTEX_SHADER_VARIANTS_EXT                                 34768
#endif

#ifndef GL_VERTEX_SHADER_INVARIANTS_EXT
#define GL_VERTEX_SHADER_INVARIANTS_EXT                               34769
#endif

#ifndef GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT
#define GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT                          34770
#endif

#ifndef GL_VERTEX_SHADER_LOCALS_EXT
#define GL_VERTEX_SHADER_LOCALS_EXT                                   34771
#endif

#ifndef GL_VERTEX_SHADER_BINDING_EXT
#define GL_VERTEX_SHADER_BINDING_EXT                                  34689
#endif

#ifndef GL_VERTEX_SHADER_OPTIMIZED_EXT
#define GL_VERTEX_SHADER_OPTIMIZED_EXT                                34772
#endif

#ifndef GL_X_EXT
#define GL_X_EXT                                                      34773
#endif

#ifndef GL_Y_EXT
#define GL_Y_EXT                                                      34774
#endif

#ifndef GL_Z_EXT
#define GL_Z_EXT                                                      34775
#endif

#ifndef GL_W_EXT
#define GL_W_EXT                                                      34776
#endif

#ifndef GL_NEGATIVE_X_EXT
#define GL_NEGATIVE_X_EXT                                             34777
#endif

#ifndef GL_NEGATIVE_Y_EXT
#define GL_NEGATIVE_Y_EXT                                             34778
#endif

#ifndef GL_NEGATIVE_Z_EXT
#define GL_NEGATIVE_Z_EXT                                             34779
#endif

#ifndef GL_NEGATIVE_W_EXT
#define GL_NEGATIVE_W_EXT                                             34780
#endif

#ifndef GL_ZERO_EXT
#define GL_ZERO_EXT                                                   34781
#endif

#ifndef GL_ONE_EXT
#define GL_ONE_EXT                                                    34782
#endif

#ifndef GL_NEGATIVE_ONE_EXT
#define GL_NEGATIVE_ONE_EXT                                           34783
#endif

#ifndef GL_NORMALIZED_RANGE_EXT
#define GL_NORMALIZED_RANGE_EXT                                       34784
#endif

#ifndef GL_FULL_RANGE_EXT
#define GL_FULL_RANGE_EXT                                             34785
#endif

#ifndef GL_CURRENT_VERTEX_EXT
#define GL_CURRENT_VERTEX_EXT                                         34786
#endif

#ifndef GL_MVP_MATRIX_EXT
#define GL_MVP_MATRIX_EXT                                             34787
#endif


typedef GLvoid (csAPIENTRY* csGLBEGINVERTEXSHADEREXT) ();
typedef GLvoid (csAPIENTRY* csGLENDVERTEXSHADEREXT) ();
typedef GLvoid (csAPIENTRY* csGLBINDVERTEXSHADEREXT) (GLuint id);
typedef GLuint (csAPIENTRY* csGLGENVERTEXSHADERSEXT) (GLuint range);
typedef GLvoid (csAPIENTRY* csGLDELETEVERTEXSHADEREXT) (GLuint id);
typedef GLvoid (csAPIENTRY* csGLSHADEROP1EXT) (GLenum op, GLuint res, GLuint arg1);
typedef GLvoid (csAPIENTRY* csGLSHADEROP2EXT) (GLenum op, GLuint res, GLuint arg1, GLuint arg2);
typedef GLvoid (csAPIENTRY* csGLSHADEROP3EXT) (GLenum op, GLuint res, GLuint arg1, GLuint arg2, GLuint arg3);
typedef GLvoid (csAPIENTRY* csGLSWIZZLEEXT) (GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW);
typedef GLvoid (csAPIENTRY* csGLWRITEMASKEXT) (GLuint res, GLuint in, GLenum outX, GLenum outY, GLenum outZ, GLenum outW);
typedef GLvoid (csAPIENTRY* csGLINSERTCOMPONENTEXT) (GLuint res, GLuint src, GLuint num);
typedef GLvoid (csAPIENTRY* csGLEXTRACTCOMPONENTEXT) (GLuint res, GLuint src, GLuint num);
typedef GLuint (csAPIENTRY* csGLGENSYMBOLSEXT) (GLenum datatype, GLenum storagetype, GLenum range, GLuint components);
typedef GLvoid (csAPIENTRY* csGLSETINVARIANTEXT) (GLuint id, GLenum type, GLvoid* addr);
typedef GLvoid (csAPIENTRY* csGLSETLOCALCONSTANTEXT) (GLuint id, GLenum type, GLvoid* addr);
typedef GLvoid (csAPIENTRY* csGLVARIANTBVEXT) (GLuint id, GLbyte* addr);
typedef GLvoid (csAPIENTRY* csGLVARIANTSVEXT) (GLuint id, GLshort* addr);
typedef GLvoid (csAPIENTRY* csGLVARIANTIVEXT) (GLuint id, GLint* addr);
typedef GLvoid (csAPIENTRY* csGLVARIANTFVEXT) (GLuint id, GLfloat* addr);
typedef GLvoid (csAPIENTRY* csGLVARIANTDVEXT) (GLuint id, GLdouble* addr);
typedef GLvoid (csAPIENTRY* csGLVARIANTUBVEXT) (GLuint id, GLubyte* addr);
typedef GLvoid (csAPIENTRY* csGLVARIANTUSVEXT) (GLuint id, GLushort* addr);
typedef GLvoid (csAPIENTRY* csGLVARIANTUIVEXT) (GLuint id, GLuint* addr);
typedef GLvoid (csAPIENTRY* csGLVARIANTPOINTEREXT) (GLuint id, GLenum type, GLuint stride, GLvoid* addr);
typedef GLvoid (csAPIENTRY* csGLENABLEVARIANTCLIENTSTATEEXT) (GLuint id);
typedef GLvoid (csAPIENTRY* csGLDISABLEVARIANTCLIENTSTATEEXT) (GLuint id);
typedef GLuint (csAPIENTRY* csGLBINDLIGHTPARAMETEREXT) (GLenum light, GLenum value);
typedef GLuint (csAPIENTRY* csGLBINDMATERIALPARAMETEREXT) (GLenum face, GLenum value);
typedef GLuint (csAPIENTRY* csGLBINDTEXGENPARAMETEREXT) (GLenum unit, GLenum coord, GLenum value);
typedef GLuint (csAPIENTRY* csGLBINDTEXTUREUNITPARAMETEREXT) (GLenum unit, GLenum value);
typedef GLuint (csAPIENTRY* csGLBINDPARAMETEREXT) (GLenum value);
typedef GLboolean (csAPIENTRY* csGLISVARIANTENABLEDEXT) (GLuint id, GLenum cap);
typedef GLvoid (csAPIENTRY* csGLGETVARIANTBOOLEANVEXT) (GLuint id, GLenum value, GLboolean* data);
typedef GLvoid (csAPIENTRY* csGLGETVARIANTINTEGERVEXT) (GLuint id, GLenum value, GLint* data);
typedef GLvoid (csAPIENTRY* csGLGETVARIANTFLOATVEXT) (GLuint id, GLenum value, GLfloat* data);
typedef GLvoid (csAPIENTRY* csGLGETVARIANTPOINTERVEXT) (GLuint id, GLenum value, GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLGETINVARIANTBOOLEANVEXT) (GLuint id, GLenum value, GLboolean* data);
typedef GLvoid (csAPIENTRY* csGLGETINVARIANTINTEGERVEXT) (GLuint id, GLenum value, GLint* data);
typedef GLvoid (csAPIENTRY* csGLGETINVARIANTFLOATVEXT) (GLuint id, GLenum value, GLfloat* data);
typedef GLvoid (csAPIENTRY* csGLGETLOCALCONSTANTBOOLEANVEXT) (GLuint id, GLenum value, GLboolean* data);
typedef GLvoid (csAPIENTRY* csGLGETLOCALCONSTANTINTEGERVEXT) (GLuint id, GLenum value, GLint* data);
typedef GLvoid (csAPIENTRY* csGLGETLOCALCONSTANTFLOATVEXT) (GLuint id, GLenum value, GLfloat* data);

// GL_EXT_vertex_weighting
#ifndef GL_VERTEX_WEIGHTING_EXT
#define GL_VERTEX_WEIGHTING_EXT                                       34057
#endif

#ifndef GL_MODELVIEW0_EXT
#define GL_MODELVIEW0_EXT                                              5888
#endif

#ifndef GL_MODELVIEW1_EXT
#define GL_MODELVIEW1_EXT                                             34058
#endif

#ifndef GL_MODELVIEW0_MATRIX_EXT
#define GL_MODELVIEW0_MATRIX_EXT                                       2982
#endif

#ifndef GL_MODELVIEW1_MATRIX_EXT
#define GL_MODELVIEW1_MATRIX_EXT                                      34054
#endif

#ifndef GL_CURRENT_VERTEX_WEIGHT_EXT
#define GL_CURRENT_VERTEX_WEIGHT_EXT                                  34059
#endif

#ifndef GL_VERTEX_WEIGHT_ARRAY_EXT
#define GL_VERTEX_WEIGHT_ARRAY_EXT                                    34060
#endif

#ifndef GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT
#define GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT                               34061
#endif

#ifndef GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT
#define GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT                               34062
#endif

#ifndef GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT
#define GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT                             34063
#endif

#ifndef GL_MODELVIEW0_STACK_DEPTH_EXT
#define GL_MODELVIEW0_STACK_DEPTH_EXT                                  2979
#endif

#ifndef GL_MODELVIEW1_STACK_DEPTH_EXT
#define GL_MODELVIEW1_STACK_DEPTH_EXT                                 34050
#endif

#ifndef GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT
#define GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT                            34064
#endif


typedef GLvoid (csAPIENTRY* csGLVERTEXWEIGHTFEXT) (GLfloat weight);
typedef GLvoid (csAPIENTRY* csGLVERTEXWEIGHTFVEXT) (GLfloat* weight);
typedef GLvoid (csAPIENTRY* csGLVERTEXWEIGHTPOINTEREXT) (GLint size, GLenum type, GLsizei stride, GLvoid* pointer);

// GL_HP_occlusion_test
#ifndef GL_OCCLUSION_TEST_HP
#define GL_OCCLUSION_TEST_HP                                          33125
#endif

#ifndef GL_OCCLUSION_TEST_RESULT_HP
#define GL_OCCLUSION_TEST_RESULT_HP                                   33126
#endif



// GL_NV_blend_square


// GL_NV_copy_depth_to_color
#ifndef GL_DEPTH_STENCIL_TO_RGBA_NV
#define GL_DEPTH_STENCIL_TO_RGBA_NV                                   34926
#endif

#ifndef GL_DEPTH_STENCIL_TO_BGRA_NV
#define GL_DEPTH_STENCIL_TO_BGRA_NV                                   34927
#endif



// GL_NV_depth_clamp
#ifndef GL_DEPTH_CLAMP_NV
#define GL_DEPTH_CLAMP_NV                                             34383
#endif



// GL_NV_evaluators
#ifndef GL_EVAL_2D_NV
#define GL_EVAL_2D_NV                                                 34496
#endif

#ifndef GL_EVAL_TRIANGULAR_2D_NV
#define GL_EVAL_TRIANGULAR_2D_NV                                      34497
#endif

#ifndef GL_MAP_TESSELLATION_NV
#define GL_MAP_TESSELLATION_NV                                        34498
#endif

#ifndef GL_MAP_ATTRIB_U_ORDER_NV
#define GL_MAP_ATTRIB_U_ORDER_NV                                      34499
#endif

#ifndef GL_MAP_ATTRIB_V_ORDER_NV
#define GL_MAP_ATTRIB_V_ORDER_NV                                      34500
#endif

#ifndef GL_EVAL_FRACTIONAL_TESSELLATION_NV
#define GL_EVAL_FRACTIONAL_TESSELLATION_NV                            34501
#endif

#ifndef GL_EVAL_VERTEX_ATTRIB0_NV
#define GL_EVAL_VERTEX_ATTRIB0_NV                                     34502
#endif

#ifndef GL_EVAL_VERTEX_ATTRIB1_NV
#define GL_EVAL_VERTEX_ATTRIB1_NV                                     34503
#endif

#ifndef GL_EVAL_VERTEX_ATTRIB2_NV
#define GL_EVAL_VERTEX_ATTRIB2_NV                                     34504
#endif

#ifndef GL_EVAL_VERTEX_ATTRIB3_NV
#define GL_EVAL_VERTEX_ATTRIB3_NV                                     34505
#endif

#ifndef GL_EVAL_VERTEX_ATTRIB4_NV
#define GL_EVAL_VERTEX_ATTRIB4_NV                                     34506
#endif

#ifndef GL_EVAL_VERTEX_ATTRIB5_NV
#define GL_EVAL_VERTEX_ATTRIB5_NV                                     34507
#endif

#ifndef GL_EVAL_VERTEX_ATTRIB6_NV
#define GL_EVAL_VERTEX_ATTRIB6_NV                                     34508
#endif

#ifndef GL_EVAL_VERTEX_ATTRIB7_NV
#define GL_EVAL_VERTEX_ATTRIB7_NV                                     34509
#endif

#ifndef GL_EVAL_VERTEX_ATTRIB8_NV
#define GL_EVAL_VERTEX_ATTRIB8_NV                                     34510
#endif

#ifndef GL_EVAL_VERTEX_ATTRIB9_NV
#define GL_EVAL_VERTEX_ATTRIB9_NV                                     34511
#endif

#ifndef GL_EVAL_VERTEX_ATTRIB10_NV
#define GL_EVAL_VERTEX_ATTRIB10_NV                                    34512
#endif

#ifndef GL_EVAL_VERTEX_ATTRIB11_NV
#define GL_EVAL_VERTEX_ATTRIB11_NV                                    34513
#endif

#ifndef GL_EVAL_VERTEX_ATTRIB12_NV
#define GL_EVAL_VERTEX_ATTRIB12_NV                                    34514
#endif

#ifndef GL_EVAL_VERTEX_ATTRIB13_NV
#define GL_EVAL_VERTEX_ATTRIB13_NV                                    34515
#endif

#ifndef GL_EVAL_VERTEX_ATTRIB14_NV
#define GL_EVAL_VERTEX_ATTRIB14_NV                                    34516
#endif

#ifndef GL_EVAL_VERTEX_ATTRIB15_NV
#define GL_EVAL_VERTEX_ATTRIB15_NV                                    34517
#endif

#ifndef GL_MAX_MAP_TESSELLATION_NV
#define GL_MAX_MAP_TESSELLATION_NV                                    34518
#endif

#ifndef GL_MAX_RATIONAL_EVAL_ORDER_NV
#define GL_MAX_RATIONAL_EVAL_ORDER_NV                                 34519
#endif


typedef GLvoid (csAPIENTRY* csGLMAPCONTROLPOINTSNV) (GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLint uorder, GLint vorder, GLboolean packed, const GLvoid* points);
typedef GLvoid (csAPIENTRY* csGLMAPPARAMETERIVNV) (GLenum target, GLenum pname, const GLint* params);
typedef GLvoid (csAPIENTRY* csGLMAPPARAMETERFVNV) (GLenum target, GLenum pname, const GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETMAPCONTROLPOINTSNV) (GLenum target, GLuint index, GLenum type, GLsizei ustride, GLsizei vstride, GLboolean packed, GLvoid* points);
typedef GLvoid (csAPIENTRY* csGLGETMAPPARAMETERIVNV) (GLenum target, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETMAPPARAMETERFVNV) (GLenum target, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETMAPATTRIBPARAMETERIVNV) (GLenum target, GLuint index, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETMAPATTRIBPARAMETERFVNV) (GLenum target, GLuint index, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLEVALMAPSNV) (GLenum target, GLenum mode);

// GL_NV_fence
#ifndef GL_ALL_COMPLETED_NV
#define GL_ALL_COMPLETED_NV                                           34034
#endif

#ifndef GL_FENCE_STATUS_NV
#define GL_FENCE_STATUS_NV                                            34035
#endif

#ifndef GL_FENCE_CONDITION_NV
#define GL_FENCE_CONDITION_NV                                         34036
#endif


typedef GLvoid (csAPIENTRY* csGLGENFENCESNV) (GLsizei n, GLuint* fences);
typedef GLvoid (csAPIENTRY* csGLDELETEFENCESNV) (GLsizei n, const GLuint* fences);
typedef GLvoid (csAPIENTRY* csGLSETFENCENV) (GLuint fence, GLenum condition);
typedef GLboolean (csAPIENTRY* csGLTESTFENCENV) (GLuint fence);
typedef GLvoid (csAPIENTRY* csGLFINISHFENCENV) (GLuint fence);
typedef GLboolean (csAPIENTRY* csGLISFENCENV) (GLuint fence);
typedef GLvoid (csAPIENTRY* csGLGETFENCEIVNV) (GLuint fence, GLenum pname, GLint* params);

// GL_NV_fog_distance
#ifndef GL_FOG_DISTANCE_MODE_NV
#define GL_FOG_DISTANCE_MODE_NV                                       34138
#endif

#ifndef GL_EYE_RADIAL_NV
#define GL_EYE_RADIAL_NV                                              34139
#endif

#ifndef GL_EYE_PLANE_ABSOLUTE_NV
#define GL_EYE_PLANE_ABSOLUTE_NV                                      34140
#endif



// GL_NV_light_max_exponent
#ifndef GL_MAX_SHININESS_NV
#define GL_MAX_SHININESS_NV                                           34052
#endif

#ifndef GL_MAX_SPOT_EXPONENT_NV
#define GL_MAX_SPOT_EXPONENT_NV                                       34053
#endif



// GL_NV_multisample_filter_hint
#ifndef GL_MULTISAMPLE_FILTER_HINT_NV
#define GL_MULTISAMPLE_FILTER_HINT_NV                                 34100
#endif



// GL_NV_occlusion_query
#ifndef GL_OCCLUSION_TEST_HP
#define GL_OCCLUSION_TEST_HP                                          33125
#endif

#ifndef GL_OCCLUSION_TEST_RESULT_HP
#define GL_OCCLUSION_TEST_RESULT_HP                                   33126
#endif

#ifndef GL_PIXEL_COUNTER_BITS_NV
#define GL_PIXEL_COUNTER_BITS_NV                                      34916
#endif

#ifndef GL_CURRENT_OCCLUSION_QUERY_ID_NV
#define GL_CURRENT_OCCLUSION_QUERY_ID_NV                              34917
#endif

#ifndef GL_PIXEL_COUNT_NV
#define GL_PIXEL_COUNT_NV                                             34918
#endif

#ifndef GL_PIXEL_COUNT_AVAILABLE_NV
#define GL_PIXEL_COUNT_AVAILABLE_NV                                   34919
#endif


typedef GLvoid (csAPIENTRY* csGLGENOCCLUSIONQUERIESNV) (GLsizei n, GLuint* ids);
typedef GLvoid (csAPIENTRY* csGLDELETEOCCLUSIONQUERIESNV) (GLsizei n, const GLuint* ids);
typedef GLboolean (csAPIENTRY* csGLISOCCLUSIONQUERYNV) (GLuint id);
typedef GLvoid (csAPIENTRY* csGLBEGINOCCLUSIONQUERYNV) (GLuint id);
typedef GLvoid (csAPIENTRY* csGLENDOCCLUSIONQUERYNV) ();
typedef GLvoid (csAPIENTRY* csGLGETOCCLUSIONQUERYIVNV) (GLuint id, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETOCCLUSIONQUERYUIVNV) (GLuint id, GLenum pname, GLuint* params);

// GL_NV_packed_depth_stencil
#ifndef GL_DEPTH_STENCIL_NV
#define GL_DEPTH_STENCIL_NV                                           34041
#endif

#ifndef GL_UNSIGNED_INT_24_8_NV
#define GL_UNSIGNED_INT_24_8_NV                                       34042
#endif



// GL_NV_point_sprite
#ifndef GL_POINT_SPRITE_NV
#define GL_POINT_SPRITE_NV                                            34913
#endif

#ifndef GL_COORD_REPLACE_NV
#define GL_COORD_REPLACE_NV                                           34914
#endif

#ifndef GL_POINT_SPRITE_R_MODE_NV
#define GL_POINT_SPRITE_R_MODE_NV                                     34915
#endif


typedef GLvoid (csAPIENTRY* csGLPOINTPARAMETERINV) (GLenum pname, GLint param);
typedef GLvoid (csAPIENTRY* csGLPOINTPARAMETERIVNV) (GLenum pname, const GLint* params);

// GL_NV_register_combiners
#ifndef GL_REGISTER_COMBINERS_NV
#define GL_REGISTER_COMBINERS_NV                                      34082
#endif

#ifndef GL_COMBINER0_NV
#define GL_COMBINER0_NV                                               34128
#endif

#ifndef GL_COMBINER1_NV
#define GL_COMBINER1_NV                                               34129
#endif

#ifndef GL_COMBINER2_NV
#define GL_COMBINER2_NV                                               34130
#endif

#ifndef GL_COMBINER3_NV
#define GL_COMBINER3_NV                                               34131
#endif

#ifndef GL_COMBINER4_NV
#define GL_COMBINER4_NV                                               34132
#endif

#ifndef GL_COMBINER5_NV
#define GL_COMBINER5_NV                                               34133
#endif

#ifndef GL_COMBINER6_NV
#define GL_COMBINER6_NV                                               34134
#endif

#ifndef GL_COMBINER7_NV
#define GL_COMBINER7_NV                                               34135
#endif

#ifndef GL_VARIABLE_A_NV
#define GL_VARIABLE_A_NV                                              34083
#endif

#ifndef GL_VARIABLE_B_NV
#define GL_VARIABLE_B_NV                                              34084
#endif

#ifndef GL_VARIABLE_C_NV
#define GL_VARIABLE_C_NV                                              34085
#endif

#ifndef GL_VARIABLE_D_NV
#define GL_VARIABLE_D_NV                                              34086
#endif

#ifndef GL_VARIABLE_E_NV
#define GL_VARIABLE_E_NV                                              34087
#endif

#ifndef GL_VARIABLE_F_NV
#define GL_VARIABLE_F_NV                                              34088
#endif

#ifndef GL_VARIABLE_G_NV
#define GL_VARIABLE_G_NV                                              34089
#endif

#ifndef GL_CONSTANT_COLOR0_NV
#define GL_CONSTANT_COLOR0_NV                                         34090
#endif

#ifndef GL_CONSTANT_COLOR1_NV
#define GL_CONSTANT_COLOR1_NV                                         34091
#endif

#ifndef GL_PRIMARY_COLOR_NV
#define GL_PRIMARY_COLOR_NV                                           34092
#endif

#ifndef GL_SECONDARY_COLOR_NV
#define GL_SECONDARY_COLOR_NV                                         34093
#endif

#ifndef GL_SPARE0_NV
#define GL_SPARE0_NV                                                  34094
#endif

#ifndef GL_SPARE1_NV
#define GL_SPARE1_NV                                                  34095
#endif

#ifndef GL_UNSIGNED_IDENTITY_NV
#define GL_UNSIGNED_IDENTITY_NV                                       34102
#endif

#ifndef GL_UNSIGNED_INVERT_NV
#define GL_UNSIGNED_INVERT_NV                                         34103
#endif

#ifndef GL_EXPAND_NORMAL_NV
#define GL_EXPAND_NORMAL_NV                                           34104
#endif

#ifndef GL_EXPAND_NEGATE_NV
#define GL_EXPAND_NEGATE_NV                                           34105
#endif

#ifndef GL_HALF_BIAS_NORMAL_NV
#define GL_HALF_BIAS_NORMAL_NV                                        34106
#endif

#ifndef GL_HALF_BIAS_NEGATE_NV
#define GL_HALF_BIAS_NEGATE_NV                                        34107
#endif

#ifndef GL_SIGNED_IDENTITY_NV
#define GL_SIGNED_IDENTITY_NV                                         34108
#endif

#ifndef GL_SIGNED_NEGATE_NV
#define GL_SIGNED_NEGATE_NV                                           34109
#endif

#ifndef GL_E_TIMES_F_NV
#define GL_E_TIMES_F_NV                                               34097
#endif

#ifndef GL_SPARE0_PLUS_SECONDARY_COLOR_NV
#define GL_SPARE0_PLUS_SECONDARY_COLOR_NV                             34098
#endif

#ifndef GL_SCALE_BY_TWO_NV
#define GL_SCALE_BY_TWO_NV                                            34110
#endif

#ifndef GL_SCALE_BY_FOUR_NV
#define GL_SCALE_BY_FOUR_NV                                           34111
#endif

#ifndef GL_SCALE_BY_ONE_HALF_NV
#define GL_SCALE_BY_ONE_HALF_NV                                       34112
#endif

#ifndef GL_BIAS_BY_NEGATIVE_ONE_HALF_NV
#define GL_BIAS_BY_NEGATIVE_ONE_HALF_NV                               34113
#endif

#ifndef GL_DISCARD_NV
#define GL_DISCARD_NV                                                 34096
#endif

#ifndef GL_COMBINER_INPUT_NV
#define GL_COMBINER_INPUT_NV                                          34114
#endif

#ifndef GL_COMBINER_MAPPING_NV
#define GL_COMBINER_MAPPING_NV                                        34115
#endif

#ifndef GL_COMBINER_COMPONENT_USAGE_NV
#define GL_COMBINER_COMPONENT_USAGE_NV                                34116
#endif

#ifndef GL_COMBINER_AB_DOT_PRODUCT_NV
#define GL_COMBINER_AB_DOT_PRODUCT_NV                                 34117
#endif

#ifndef GL_COMBINER_CD_DOT_PRODUCT_NV
#define GL_COMBINER_CD_DOT_PRODUCT_NV                                 34118
#endif

#ifndef GL_COMBINER_MUX_SUM_NV
#define GL_COMBINER_MUX_SUM_NV                                        34119
#endif

#ifndef GL_COMBINER_SCALE_NV
#define GL_COMBINER_SCALE_NV                                          34120
#endif

#ifndef GL_COMBINER_BIAS_NV
#define GL_COMBINER_BIAS_NV                                           34121
#endif

#ifndef GL_COMBINER_AB_OUTPUT_NV
#define GL_COMBINER_AB_OUTPUT_NV                                      34122
#endif

#ifndef GL_COMBINER_CD_OUTPUT_NV
#define GL_COMBINER_CD_OUTPUT_NV                                      34123
#endif

#ifndef GL_COMBINER_SUM_OUTPUT_NV
#define GL_COMBINER_SUM_OUTPUT_NV                                     34124
#endif

#ifndef GL_NUM_GENERAL_COMBINERS_NV
#define GL_NUM_GENERAL_COMBINERS_NV                                   34126
#endif

#ifndef GL_COLOR_SUM_CLAMP_NV
#define GL_COLOR_SUM_CLAMP_NV                                         34127
#endif

#ifndef GL_MAX_GENERAL_COMBINERS_NV
#define GL_MAX_GENERAL_COMBINERS_NV                                   34125
#endif


typedef GLvoid (csAPIENTRY* csGLCOMBINERPARAMETERFVNV) (GLenum pname, const GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLCOMBINERPARAMETERIVNV) (GLenum pname, const GLint* params);
typedef GLvoid (csAPIENTRY* csGLCOMBINERPARAMETERFNV) (GLenum pname, GLfloat param);
typedef GLvoid (csAPIENTRY* csGLCOMBINERPARAMETERINV) (GLenum pname, GLint param);
typedef GLvoid (csAPIENTRY* csGLCOMBINERINPUTNV) (GLenum stage, GLenum portion, GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage);
typedef GLvoid (csAPIENTRY* csGLCOMBINEROUTPUTNV) (GLenum stage, GLenum portion, GLenum abOutput, GLenum cdOutput, GLenum sumOutput, GLenum scale, GLenum bias, GLboolean abDotProduct, GLboolean cdDotProduct, GLboolean muxSum);
typedef GLvoid (csAPIENTRY* csGLFINALCOMBINERINPUTNV) (GLenum variable, GLenum input, GLenum mapping, GLenum componentUsage);
typedef GLvoid (csAPIENTRY* csGLGETCOMBINERINPUTPARAMETERFVNV) (GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETCOMBINERINPUTPARAMETERIVNV) (GLenum stage, GLenum portion, GLenum variable, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETCOMBINEROUTPUTPARAMETERFVNV) (GLenum stage, GLenum portion, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETCOMBINEROUTPUTPARAMETERIVNV) (GLenum stage, GLenum portion, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETFINALCOMBINERINPUTPARAMETERFVNV) (GLenum variable, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETFINALCOMBINERINPUTPARAMETERIVNV) (GLenum variable, GLenum pname, GLint* params);

// GL_NV_register_combiners2
#ifndef GL_PER_STAGE_CONSTANTS_NV
#define GL_PER_STAGE_CONSTANTS_NV                                     34101
#endif


typedef GLvoid (csAPIENTRY* csGLCOMBINERSTAGEPARAMETERFVNV) (GLenum stage, GLenum pname, const GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETCOMBINERSTAGEPARAMETERFVNV) (GLenum stage, GLenum pname, GLfloat* params);

// GL_NV_texgen_emboss
#ifndef GL_EMBOSS_MAP_NV
#define GL_EMBOSS_MAP_NV                                              34143
#endif

#ifndef GL_EMBOSS_LIGHT_NV
#define GL_EMBOSS_LIGHT_NV                                            34141
#endif

#ifndef GL_EMBOSS_CONSTANT_NV
#define GL_EMBOSS_CONSTANT_NV                                         34142
#endif



// GL_NV_texgen_reflection
#ifndef GL_NORMAL_MAP_NV
#define GL_NORMAL_MAP_NV                                              34065
#endif

#ifndef GL_REFLECTION_MAP_NV
#define GL_REFLECTION_MAP_NV                                          34066
#endif



// GL_NV_texture_compression_vtc
#ifndef GL_COMPRESSED_RGB_S3TC_DXT1_EXT
#define GL_COMPRESSED_RGB_S3TC_DXT1_EXT                               33776
#endif

#ifndef GL_COMPRESSED_RGBA_S3TC_DXT1_EXT
#define GL_COMPRESSED_RGBA_S3TC_DXT1_EXT                              33777
#endif

#ifndef GL_COMPRESSED_RGBA_S3TC_DXT3_EXT
#define GL_COMPRESSED_RGBA_S3TC_DXT3_EXT                              33778
#endif

#ifndef GL_COMPRESSED_RGBA_S3TC_DXT5_EXT
#define GL_COMPRESSED_RGBA_S3TC_DXT5_EXT                              33779
#endif



// GL_NV_texture_env_combine4
#ifndef GL_COMBINE4_NV
#define GL_COMBINE4_NV                                                34051
#endif

#ifndef GL_SOURCE3_RGB_NV
#define GL_SOURCE3_RGB_NV                                             34179
#endif

#ifndef GL_SOURCE3_ALPHA_NV
#define GL_SOURCE3_ALPHA_NV                                           34187
#endif

#ifndef GL_OPERAND3_RGB_NV
#define GL_OPERAND3_RGB_NV                                            34195
#endif

#ifndef GL_OPERAND3_ALPHA_NV
#define GL_OPERAND3_ALPHA_NV                                          34203
#endif



// GL_NV_texture_rectangle
#ifndef GL_TEXTURE_RECTANGLE_NV
#define GL_TEXTURE_RECTANGLE_NV                                       34037
#endif

#ifndef GL_TEXTURE_BINDING_RECTANGLE_NV
#define GL_TEXTURE_BINDING_RECTANGLE_NV                               34038
#endif

#ifndef GL_PROXY_TEXTURE_RECTANGLE_NV
#define GL_PROXY_TEXTURE_RECTANGLE_NV                                 34039
#endif

#ifndef GL_MAX_RECTANGLE_TEXTURE_SIZE_NV
#define GL_MAX_RECTANGLE_TEXTURE_SIZE_NV                              34040
#endif



// GL_NV_texture_shader
#ifndef GL_TEXTURE_SHADER_NV
#define GL_TEXTURE_SHADER_NV                                          34526
#endif

#ifndef GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV
#define GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV                       34521
#endif

#ifndef GL_SHADER_OPERATION_NV
#define GL_SHADER_OPERATION_NV                                        34527
#endif

#ifndef GL_CULL_MODES_NV
#define GL_CULL_MODES_NV                                              34528
#endif

#ifndef GL_OFFSET_TEXTURE_MATRIX_NV
#define GL_OFFSET_TEXTURE_MATRIX_NV                                   34529
#endif

#ifndef GL_OFFSET_TEXTURE_SCALE_NV
#define GL_OFFSET_TEXTURE_SCALE_NV                                    34530
#endif

#ifndef GL_OFFSET_TEXTURE_BIAS_NV
#define GL_OFFSET_TEXTURE_BIAS_NV                                     34531
#endif

#ifndef GL_PREVIOUS_TEXTURE_INPUT_NV
#define GL_PREVIOUS_TEXTURE_INPUT_NV                                  34532
#endif

#ifndef GL_CONST_EYE_NV
#define GL_CONST_EYE_NV                                               34533
#endif

#ifndef GL_SHADER_CONSISTENT_NV
#define GL_SHADER_CONSISTENT_NV                                       34525
#endif

#ifndef GL_PASS_THROUGH_NV
#define GL_PASS_THROUGH_NV                                            34534
#endif

#ifndef GL_CULL_FRAGMENT_NV
#define GL_CULL_FRAGMENT_NV                                           34535
#endif

#ifndef GL_OFFSET_TEXTURE_2D_NV
#define GL_OFFSET_TEXTURE_2D_NV                                       34536
#endif

#ifndef GL_OFFSET_TEXTURE_RECTANGLE_NV
#define GL_OFFSET_TEXTURE_RECTANGLE_NV                                34380
#endif

#ifndef GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV
#define GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV                          34381
#endif

#ifndef GL_DEPENDENT_AR_TEXTURE_2D_NV
#define GL_DEPENDENT_AR_TEXTURE_2D_NV                                 34537
#endif

#ifndef GL_DEPENDENT_GB_TEXTURE_2D_NV
#define GL_DEPENDENT_GB_TEXTURE_2D_NV                                 34538
#endif

#ifndef GL_DOT_PRODUCT_NV
#define GL_DOT_PRODUCT_NV                                             34540
#endif

#ifndef GL_DOT_PRODUCT_DEPTH_REPLACE_NV
#define GL_DOT_PRODUCT_DEPTH_REPLACE_NV                               34541
#endif

#ifndef GL_DOT_PRODUCT_TEXTURE_2D_NV
#define GL_DOT_PRODUCT_TEXTURE_2D_NV                                  34542
#endif

#ifndef GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV
#define GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV                           34382
#endif

#ifndef GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV
#define GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV                            34544
#endif

#ifndef GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV
#define GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV                            34545
#endif

#ifndef GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV
#define GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV                            34546
#endif

#ifndef GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV
#define GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV                  34547
#endif

#ifndef GL_HILO_NV
#define GL_HILO_NV                                                    34548
#endif

#ifndef GL_DSDT_NV
#define GL_DSDT_NV                                                    34549
#endif

#ifndef GL_DSDT_MAG_NV
#define GL_DSDT_MAG_NV                                                34550
#endif

#ifndef GL_DSDT_MAG_VIB_NV
#define GL_DSDT_MAG_VIB_NV                                            34551
#endif

#ifndef GL_UNSIGNED_INT_S8_S8_8_8_NV
#define GL_UNSIGNED_INT_S8_S8_8_8_NV                                  34522
#endif

#ifndef GL_UNSIGNED_INT_8_8_S8_S8_REV_NV
#define GL_UNSIGNED_INT_8_8_S8_S8_REV_NV                              34523
#endif

#ifndef GL_SIGNED_RGBA_NV
#define GL_SIGNED_RGBA_NV                                             34555
#endif

#ifndef GL_SIGNED_RGBA8_NV
#define GL_SIGNED_RGBA8_NV                                            34556
#endif

#ifndef GL_SIGNED_RGB_NV
#define GL_SIGNED_RGB_NV                                              34558
#endif

#ifndef GL_SIGNED_RGB8_NV
#define GL_SIGNED_RGB8_NV                                             34559
#endif

#ifndef GL_SIGNED_LUMINANCE_NV
#define GL_SIGNED_LUMINANCE_NV                                        34561
#endif

#ifndef GL_SIGNED_LUMINANCE8_NV
#define GL_SIGNED_LUMINANCE8_NV                                       34562
#endif

#ifndef GL_SIGNED_LUMINANCE_ALPHA_NV
#define GL_SIGNED_LUMINANCE_ALPHA_NV                                  34563
#endif

#ifndef GL_SIGNED_LUMINANCE8_ALPHA8_NV
#define GL_SIGNED_LUMINANCE8_ALPHA8_NV                                34564
#endif

#ifndef GL_SIGNED_ALPHA_NV
#define GL_SIGNED_ALPHA_NV                                            34565
#endif

#ifndef GL_SIGNED_ALPHA8_NV
#define GL_SIGNED_ALPHA8_NV                                           34566
#endif

#ifndef GL_SIGNED_INTENSITY_NV
#define GL_SIGNED_INTENSITY_NV                                        34567
#endif

#ifndef GL_SIGNED_INTENSITY8_NV
#define GL_SIGNED_INTENSITY8_NV                                       34568
#endif

#ifndef GL_SIGNED_RGB_UNSIGNED_ALPHA_NV
#define GL_SIGNED_RGB_UNSIGNED_ALPHA_NV                               34572
#endif

#ifndef GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV
#define GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV                             34573
#endif

#ifndef GL_HILO16_NV
#define GL_HILO16_NV                                                  34552
#endif

#ifndef GL_SIGNED_HILO_NV
#define GL_SIGNED_HILO_NV                                             34553
#endif

#ifndef GL_SIGNED_HILO16_NV
#define GL_SIGNED_HILO16_NV                                           34554
#endif

#ifndef GL_DSDT8_NV
#define GL_DSDT8_NV                                                   34569
#endif

#ifndef GL_DSDT8_MAG8_NV
#define GL_DSDT8_MAG8_NV                                              34570
#endif

#ifndef GL_DSDT_MAG_INTENSITY_NV
#define GL_DSDT_MAG_INTENSITY_NV                                      34524
#endif

#ifndef GL_DSDT8_MAG8_INTENSITY8_NV
#define GL_DSDT8_MAG8_INTENSITY8_NV                                   34571
#endif

#ifndef GL_HI_SCALE_NV
#define GL_HI_SCALE_NV                                                34574
#endif

#ifndef GL_LO_SCALE_NV
#define GL_LO_SCALE_NV                                                34575
#endif

#ifndef GL_DS_SCALE_NV
#define GL_DS_SCALE_NV                                                34576
#endif

#ifndef GL_DT_SCALE_NV
#define GL_DT_SCALE_NV                                                34577
#endif

#ifndef GL_MAGNITUDE_SCALE_NV
#define GL_MAGNITUDE_SCALE_NV                                         34578
#endif

#ifndef GL_VIBRANCE_SCALE_NV
#define GL_VIBRANCE_SCALE_NV                                          34579
#endif

#ifndef GL_HI_BIAS_NV
#define GL_HI_BIAS_NV                                                 34580
#endif

#ifndef GL_LO_BIAS_NV
#define GL_LO_BIAS_NV                                                 34581
#endif

#ifndef GL_DS_BIAS_NV
#define GL_DS_BIAS_NV                                                 34582
#endif

#ifndef GL_DT_BIAS_NV
#define GL_DT_BIAS_NV                                                 34583
#endif

#ifndef GL_MAGNITUDE_BIAS_NV
#define GL_MAGNITUDE_BIAS_NV                                          34584
#endif

#ifndef GL_VIBRANCE_BIAS_NV
#define GL_VIBRANCE_BIAS_NV                                           34585
#endif

#ifndef GL_TEXTURE_BORDER_VALUES_NV
#define GL_TEXTURE_BORDER_VALUES_NV                                   34586
#endif

#ifndef GL_TEXTURE_HI_SIZE_NV
#define GL_TEXTURE_HI_SIZE_NV                                         34587
#endif

#ifndef GL_TEXTURE_LO_SIZE_NV
#define GL_TEXTURE_LO_SIZE_NV                                         34588
#endif

#ifndef GL_TEXTURE_DS_SIZE_NV
#define GL_TEXTURE_DS_SIZE_NV                                         34589
#endif

#ifndef GL_TEXTURE_DT_SIZE_NV
#define GL_TEXTURE_DT_SIZE_NV                                         34590
#endif

#ifndef GL_TEXTURE_MAG_SIZE_NV
#define GL_TEXTURE_MAG_SIZE_NV                                        34591
#endif



// GL_NV_texture_shader2
#ifndef GL_DOT_PRODUCT_TEXTURE_3D_NV
#define GL_DOT_PRODUCT_TEXTURE_3D_NV                                  34543
#endif

#ifndef GL_HILO_NV
#define GL_HILO_NV                                                    34548
#endif

#ifndef GL_DSDT_NV
#define GL_DSDT_NV                                                    34549
#endif

#ifndef GL_DSDT_MAG_NV
#define GL_DSDT_MAG_NV                                                34550
#endif

#ifndef GL_DSDT_MAG_VIB_NV
#define GL_DSDT_MAG_VIB_NV                                            34551
#endif

#ifndef GL_UNSIGNED_INT_S8_S8_8_8_NV
#define GL_UNSIGNED_INT_S8_S8_8_8_NV                                  34522
#endif

#ifndef GL_UNSIGNED_INT_8_8_S8_S8_REV_NV
#define GL_UNSIGNED_INT_8_8_S8_S8_REV_NV                              34523
#endif

#ifndef GL_SIGNED_RGBA_NV
#define GL_SIGNED_RGBA_NV                                             34555
#endif

#ifndef GL_SIGNED_RGBA8_NV
#define GL_SIGNED_RGBA8_NV                                            34556
#endif

#ifndef GL_SIGNED_RGB_NV
#define GL_SIGNED_RGB_NV                                              34558
#endif

#ifndef GL_SIGNED_RGB8_NV
#define GL_SIGNED_RGB8_NV                                             34559
#endif

#ifndef GL_SIGNED_LUMINANCE_NV
#define GL_SIGNED_LUMINANCE_NV                                        34561
#endif

#ifndef GL_SIGNED_LUMINANCE8_NV
#define GL_SIGNED_LUMINANCE8_NV                                       34562
#endif

#ifndef GL_SIGNED_LUMINANCE_ALPHA_NV
#define GL_SIGNED_LUMINANCE_ALPHA_NV                                  34563
#endif

#ifndef GL_SIGNED_LUMINANCE8_ALPHA8_NV
#define GL_SIGNED_LUMINANCE8_ALPHA8_NV                                34564
#endif

#ifndef GL_SIGNED_ALPHA_NV
#define GL_SIGNED_ALPHA_NV                                            34565
#endif

#ifndef GL_SIGNED_ALPHA8_NV
#define GL_SIGNED_ALPHA8_NV                                           34566
#endif

#ifndef GL_SIGNED_INTENSITY_NV
#define GL_SIGNED_INTENSITY_NV                                        34567
#endif

#ifndef GL_SIGNED_INTENSITY8_NV
#define GL_SIGNED_INTENSITY8_NV                                       34568
#endif

#ifndef GL_SIGNED_RGB_UNSIGNED_ALPHA_NV
#define GL_SIGNED_RGB_UNSIGNED_ALPHA_NV                               34572
#endif

#ifndef GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV
#define GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV                             34573
#endif

#ifndef GL_HILO16_NV
#define GL_HILO16_NV                                                  34552
#endif

#ifndef GL_SIGNED_HILO_NV
#define GL_SIGNED_HILO_NV                                             34553
#endif

#ifndef GL_SIGNED_HILO16_NV
#define GL_SIGNED_HILO16_NV                                           34554
#endif

#ifndef GL_DSDT8_NV
#define GL_DSDT8_NV                                                   34569
#endif

#ifndef GL_DSDT8_MAG8_NV
#define GL_DSDT8_MAG8_NV                                              34570
#endif

#ifndef GL_DSDT_MAG_INTENSITY_NV
#define GL_DSDT_MAG_INTENSITY_NV                                      34524
#endif

#ifndef GL_DSDT8_MAG8_INTENSITY8_NV
#define GL_DSDT8_MAG8_INTENSITY8_NV                                   34571
#endif



// GL_NV_texture_shader3
#ifndef GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV
#define GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV                            34896
#endif

#ifndef GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV
#define GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV                      34897
#endif

#ifndef GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV
#define GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV                     34898
#endif

#ifndef GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV
#define GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV               34899
#endif

#ifndef GL_OFFSET_HILO_TEXTURE_2D_NV
#define GL_OFFSET_HILO_TEXTURE_2D_NV                                  34900
#endif

#ifndef GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV
#define GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV                           34901
#endif

#ifndef GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV
#define GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV                       34902
#endif

#ifndef GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV
#define GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV                34903
#endif

#ifndef GL_DEPENDENT_HILO_TEXTURE_2D_NV
#define GL_DEPENDENT_HILO_TEXTURE_2D_NV                               34904
#endif

#ifndef GL_DEPENDENT_RGB_TEXTURE_3D_NV
#define GL_DEPENDENT_RGB_TEXTURE_3D_NV                                34905
#endif

#ifndef GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV
#define GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV                          34906
#endif

#ifndef GL_DOT_PRODUCT_PASS_THROUGH_NV
#define GL_DOT_PRODUCT_PASS_THROUGH_NV                                34907
#endif

#ifndef GL_DOT_PRODUCT_TEXTURE_1D_NV
#define GL_DOT_PRODUCT_TEXTURE_1D_NV                                  34908
#endif

#ifndef GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV
#define GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV                        34909
#endif

#ifndef GL_HILO8_NV
#define GL_HILO8_NV                                                   34910
#endif

#ifndef GL_SIGNED_HILO8_NV
#define GL_SIGNED_HILO8_NV                                            34911
#endif

#ifndef GL_FORCE_BLUE_TO_ONE_NV
#define GL_FORCE_BLUE_TO_ONE_NV                                       34912
#endif



// GL_NV_vertex_array_range
#ifndef GL_VERTEX_ARRAY_RANGE_NV
#define GL_VERTEX_ARRAY_RANGE_NV                                      34077
#endif

#ifndef GL_VERTEX_ARRAY_RANGE_LENGTH_NV
#define GL_VERTEX_ARRAY_RANGE_LENGTH_NV                               34078
#endif

#ifndef GL_VERTEX_ARRAY_RANGE_VALID_NV
#define GL_VERTEX_ARRAY_RANGE_VALID_NV                                34079
#endif

#ifndef GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV
#define GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV                          34080
#endif

#ifndef GL_VERTEX_ARRAY_RANGE_POINTER_NV
#define GL_VERTEX_ARRAY_RANGE_POINTER_NV                              34081
#endif


typedef GLvoid (csAPIENTRY* csGLVERTEXARRAYRANGENV) (GLsizei length, GLvoid* pointer);
typedef GLvoid (csAPIENTRY* csGLFLUSHVERTEXARRAYRANGENV) ();
typedef GLvoid* (csAPIENTRY* csWGLALLOCATEMEMORYNV) (GLsizei size, GLfloat readFrequency, GLfloat writeFrequency, GLfloat priority);
typedef GLvoid (csAPIENTRY* csWGLFREEMEMORYNV) (GLvoid* pointer);

// GL_NV_vertex_array_range2
#ifndef GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV
#define GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV                        34099
#endif



// GL_NV_vertex_program
#ifndef GL_VERTEX_PROGRAM_NV
#define GL_VERTEX_PROGRAM_NV                                          34336
#endif

#ifndef GL_VERTEX_PROGRAM_POINT_SIZE_NV
#define GL_VERTEX_PROGRAM_POINT_SIZE_NV                               34370
#endif

#ifndef GL_VERTEX_PROGRAM_TWO_SIDE_NV
#define GL_VERTEX_PROGRAM_TWO_SIDE_NV                                 34371
#endif

#ifndef GL_VERTEX_STATE_PROGRAM_NV
#define GL_VERTEX_STATE_PROGRAM_NV                                    34337
#endif

#ifndef GL_ATTRIB_ARRAY_SIZE_NV
#define GL_ATTRIB_ARRAY_SIZE_NV                                       34339
#endif

#ifndef GL_ATTRIB_ARRAY_STRIDE_NV
#define GL_ATTRIB_ARRAY_STRIDE_NV                                     34340
#endif

#ifndef GL_ATTRIB_ARRAY_TYPE_NV
#define GL_ATTRIB_ARRAY_TYPE_NV                                       34341
#endif

#ifndef GL_CURRENT_ATTRIB_NV
#define GL_CURRENT_ATTRIB_NV                                          34342
#endif

#ifndef GL_PROGRAM_PARAMETER_NV
#define GL_PROGRAM_PARAMETER_NV                                       34372
#endif

#ifndef GL_ATTRIB_ARRAY_POINTER_NV
#define GL_ATTRIB_ARRAY_POINTER_NV                                    34373
#endif

#ifndef GL_PROGRAM_TARGET_NV
#define GL_PROGRAM_TARGET_NV                                          34374
#endif

#ifndef GL_PROGRAM_LENGTH_NV
#define GL_PROGRAM_LENGTH_NV                                          34343
#endif

#ifndef GL_PROGRAM_RESIDENT_NV
#define GL_PROGRAM_RESIDENT_NV                                        34375
#endif

#ifndef GL_PROGRAM_STRING_NV
#define GL_PROGRAM_STRING_NV                                          34344
#endif

#ifndef GL_TRACK_MATRIX_NV
#define GL_TRACK_MATRIX_NV                                            34376
#endif

#ifndef GL_TRACK_MATRIX_TRANSFORM_NV
#define GL_TRACK_MATRIX_TRANSFORM_NV                                  34377
#endif

#ifndef GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV
#define GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV                            34350
#endif

#ifndef GL_MAX_TRACK_MATRICES_NV
#define GL_MAX_TRACK_MATRICES_NV                                      34351
#endif

#ifndef GL_CURRENT_MATRIX_STACK_DEPTH_NV
#define GL_CURRENT_MATRIX_STACK_DEPTH_NV                              34368
#endif

#ifndef GL_CURRENT_MATRIX_NV
#define GL_CURRENT_MATRIX_NV                                          34369
#endif

#ifndef GL_VERTEX_PROGRAM_BINDING_NV
#define GL_VERTEX_PROGRAM_BINDING_NV                                  34378
#endif

#ifndef GL_PROGRAM_ERROR_POSITION_NV
#define GL_PROGRAM_ERROR_POSITION_NV                                  34379
#endif

#ifndef GL_MODELVIEW_PROJECTION_NV
#define GL_MODELVIEW_PROJECTION_NV                                    34345
#endif

#ifndef GL_MATRIX0_NV
#define GL_MATRIX0_NV                                                 34352
#endif

#ifndef GL_MATRIX1_NV
#define GL_MATRIX1_NV                                                 34353
#endif

#ifndef GL_MATRIX2_NV
#define GL_MATRIX2_NV                                                 34354
#endif

#ifndef GL_MATRIX3_NV
#define GL_MATRIX3_NV                                                 34355
#endif

#ifndef GL_MATRIX4_NV
#define GL_MATRIX4_NV                                                 34356
#endif

#ifndef GL_MATRIX5_NV
#define GL_MATRIX5_NV                                                 34357
#endif

#ifndef GL_MATRIX6_NV
#define GL_MATRIX6_NV                                                 34358
#endif

#ifndef GL_MATRIX7_NV
#define GL_MATRIX7_NV                                                 34359
#endif

#ifndef GL_IDENTITY_NV
#define GL_IDENTITY_NV                                                34346
#endif

#ifndef GL_INVERSE_NV
#define GL_INVERSE_NV                                                 34347
#endif

#ifndef GL_TRANSPOSE_NV
#define GL_TRANSPOSE_NV                                               34348
#endif

#ifndef GL_INVERSE_TRANSPOSE_NV
#define GL_INVERSE_TRANSPOSE_NV                                       34349
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY0_NV
#define GL_VERTEX_ATTRIB_ARRAY0_NV                                    34384
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY1_NV
#define GL_VERTEX_ATTRIB_ARRAY1_NV                                    34385
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY2_NV
#define GL_VERTEX_ATTRIB_ARRAY2_NV                                    34386
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY3_NV
#define GL_VERTEX_ATTRIB_ARRAY3_NV                                    34387
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY4_NV
#define GL_VERTEX_ATTRIB_ARRAY4_NV                                    34388
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY5_NV
#define GL_VERTEX_ATTRIB_ARRAY5_NV                                    34389
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY6_NV
#define GL_VERTEX_ATTRIB_ARRAY6_NV                                    34390
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY7_NV
#define GL_VERTEX_ATTRIB_ARRAY7_NV                                    34391
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY8_NV
#define GL_VERTEX_ATTRIB_ARRAY8_NV                                    34392
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY9_NV
#define GL_VERTEX_ATTRIB_ARRAY9_NV                                    34393
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY10_NV
#define GL_VERTEX_ATTRIB_ARRAY10_NV                                   34394
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY11_NV
#define GL_VERTEX_ATTRIB_ARRAY11_NV                                   34395
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY12_NV
#define GL_VERTEX_ATTRIB_ARRAY12_NV                                   34396
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY13_NV
#define GL_VERTEX_ATTRIB_ARRAY13_NV                                   34397
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY14_NV
#define GL_VERTEX_ATTRIB_ARRAY14_NV                                   34398
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY15_NV
#define GL_VERTEX_ATTRIB_ARRAY15_NV                                   34399
#endif

#ifndef GL_MAP1_VERTEX_ATTRIB0_4_NV
#define GL_MAP1_VERTEX_ATTRIB0_4_NV                                   34400
#endif

#ifndef GL_MAP1_VERTEX_ATTRIB1_4_NV
#define GL_MAP1_VERTEX_ATTRIB1_4_NV                                   34401
#endif

#ifndef GL_MAP1_VERTEX_ATTRIB2_4_NV
#define GL_MAP1_VERTEX_ATTRIB2_4_NV                                   34402
#endif

#ifndef GL_MAP1_VERTEX_ATTRIB3_4_NV
#define GL_MAP1_VERTEX_ATTRIB3_4_NV                                   34403
#endif

#ifndef GL_MAP1_VERTEX_ATTRIB4_4_NV
#define GL_MAP1_VERTEX_ATTRIB4_4_NV                                   34404
#endif

#ifndef GL_MAP1_VERTEX_ATTRIB5_4_NV
#define GL_MAP1_VERTEX_ATTRIB5_4_NV                                   34405
#endif

#ifndef GL_MAP1_VERTEX_ATTRIB6_4_NV
#define GL_MAP1_VERTEX_ATTRIB6_4_NV                                   34406
#endif

#ifndef GL_MAP1_VERTEX_ATTRIB7_4_NV
#define GL_MAP1_VERTEX_ATTRIB7_4_NV                                   34407
#endif

#ifndef GL_MAP1_VERTEX_ATTRIB8_4_NV
#define GL_MAP1_VERTEX_ATTRIB8_4_NV                                   34408
#endif

#ifndef GL_MAP1_VERTEX_ATTRIB9_4_NV
#define GL_MAP1_VERTEX_ATTRIB9_4_NV                                   34409
#endif

#ifndef GL_MAP1_VERTEX_ATTRIB10_4_NV
#define GL_MAP1_VERTEX_ATTRIB10_4_NV                                  34410
#endif

#ifndef GL_MAP1_VERTEX_ATTRIB11_4_NV
#define GL_MAP1_VERTEX_ATTRIB11_4_NV                                  34411
#endif

#ifndef GL_MAP1_VERTEX_ATTRIB12_4_NV
#define GL_MAP1_VERTEX_ATTRIB12_4_NV                                  34412
#endif

#ifndef GL_MAP1_VERTEX_ATTRIB13_4_NV
#define GL_MAP1_VERTEX_ATTRIB13_4_NV                                  34413
#endif

#ifndef GL_MAP1_VERTEX_ATTRIB14_4_NV
#define GL_MAP1_VERTEX_ATTRIB14_4_NV                                  34414
#endif

#ifndef GL_MAP1_VERTEX_ATTRIB15_4_NV
#define GL_MAP1_VERTEX_ATTRIB15_4_NV                                  34415
#endif

#ifndef GL_MAP2_VERTEX_ATTRIB0_4_NV
#define GL_MAP2_VERTEX_ATTRIB0_4_NV                                   34416
#endif

#ifndef GL_MAP2_VERTEX_ATTRIB1_4_NV
#define GL_MAP2_VERTEX_ATTRIB1_4_NV                                   34417
#endif

#ifndef GL_MAP2_VERTEX_ATTRIB2_4_NV
#define GL_MAP2_VERTEX_ATTRIB2_4_NV                                   34418
#endif

#ifndef GL_MAP2_VERTEX_ATTRIB3_4_NV
#define GL_MAP2_VERTEX_ATTRIB3_4_NV                                   34419
#endif

#ifndef GL_MAP2_VERTEX_ATTRIB4_4_NV
#define GL_MAP2_VERTEX_ATTRIB4_4_NV                                   34420
#endif

#ifndef GL_MAP2_VERTEX_ATTRIB5_4_NV
#define GL_MAP2_VERTEX_ATTRIB5_4_NV                                   34421
#endif

#ifndef GL_MAP2_VERTEX_ATTRIB6_4_NV
#define GL_MAP2_VERTEX_ATTRIB6_4_NV                                   34422
#endif

#ifndef GL_MAP2_VERTEX_ATTRIB7_4_NV
#define GL_MAP2_VERTEX_ATTRIB7_4_NV                                   34423
#endif

#ifndef GL_MAP2_VERTEX_ATTRIB8_4_NV
#define GL_MAP2_VERTEX_ATTRIB8_4_NV                                   34424
#endif

#ifndef GL_MAP2_VERTEX_ATTRIB9_4_NV
#define GL_MAP2_VERTEX_ATTRIB9_4_NV                                   34425
#endif

#ifndef GL_MAP2_VERTEX_ATTRIB10_4_NV
#define GL_MAP2_VERTEX_ATTRIB10_4_NV                                  34426
#endif

#ifndef GL_MAP2_VERTEX_ATTRIB11_4_NV
#define GL_MAP2_VERTEX_ATTRIB11_4_NV                                  34427
#endif

#ifndef GL_MAP2_VERTEX_ATTRIB12_4_NV
#define GL_MAP2_VERTEX_ATTRIB12_4_NV                                  34428
#endif

#ifndef GL_MAP2_VERTEX_ATTRIB13_4_NV
#define GL_MAP2_VERTEX_ATTRIB13_4_NV                                  34429
#endif

#ifndef GL_MAP2_VERTEX_ATTRIB14_4_NV
#define GL_MAP2_VERTEX_ATTRIB14_4_NV                                  34430
#endif

#ifndef GL_MAP2_VERTEX_ATTRIB15_4_NV
#define GL_MAP2_VERTEX_ATTRIB15_4_NV                                  34431
#endif


typedef GLvoid (csAPIENTRY* csGLBINDPROGRAMNV) (GLenum target, GLuint id);
typedef GLvoid (csAPIENTRY* csGLDELETEPROGRAMSNV) (GLsizei n, const GLuint* ids);
typedef GLvoid (csAPIENTRY* csGLEXECUTEPROGRAMNV) (GLenum target, GLuint id, const GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGENPROGRAMSNV) (GLsizei n, GLuint* ids);
typedef GLboolean (csAPIENTRY* csGLAREPROGRAMSRESIDENTNV) (GLsizei n, const GLuint* ids, GLboolean* residences);
typedef GLvoid (csAPIENTRY* csGLREQUESTRESIDENTPROGRAMSNV) (GLsizei n, GLuint* ids);
typedef GLvoid (csAPIENTRY* csGLGETPROGRAMPARAMETERFVNV) (GLenum target, GLuint index, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETPROGRAMPARAMETERDVNV) (GLenum target, GLuint index, GLenum pname, GLdouble* params);
typedef GLvoid (csAPIENTRY* csGLGETPROGRAMIVNV) (GLuint id, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETPROGRAMSTRINGNV) (GLuint id, GLenum pname, GLubyte* program);
typedef GLvoid (csAPIENTRY* csGLGETTRACKMATRIXIVNV) (GLenum target, GLuint address, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETVERTEXATTRIBDVNV) (GLuint index, GLenum pname, GLdouble* params);
typedef GLvoid (csAPIENTRY* csGLGETVERTEXATTRIBFVNV) (GLuint index, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETVERTEXATTRIBIVNV) (GLuint index, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETVERTEXATTRIBPOINTERVNV) (GLuint index, GLenum pname, GLvoid* pointer);
typedef GLboolean (csAPIENTRY* csGLISPROGRAMNV) (GLuint id);
typedef GLvoid (csAPIENTRY* csGLLOADPROGRAMNV) (GLenum target, GLuint id, GLsizei len, const GLubyte* program);
typedef GLvoid (csAPIENTRY* csGLPROGRAMPARAMETER4FNV) (GLenum target, GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef GLvoid (csAPIENTRY* csGLPROGRAMPARAMETER4FVNV) (GLenum target, GLuint index, const GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLPROGRAMPARAMETERS4DVNV) (GLenum target, GLuint index, GLuint num, const GLdouble* params);
typedef GLvoid (csAPIENTRY* csGLPROGRAMPARAMETERS4FVNV) (GLenum target, GLuint index, GLuint num, const GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLTRACKMATRIXNV) (GLenum target, GLuint address, GLenum matrix, GLenum transform);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIBPOINTERNV) (GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid* pointer);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB1SNV) (GLuint index, GLshort x);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB1FNV) (GLuint index, GLfloat x);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB1DNV) (GLuint index, GLdouble x);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB2SNV) (GLuint index, GLshort x, GLshort y);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB2FNV) (GLuint index, GLfloat x, GLfloat y);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB2DNV) (GLuint index, GLdouble x, GLdouble y);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB3SNV) (GLuint index, GLshort x, GLshort y, GLshort z);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB3FNV) (GLuint index, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB3DNV) (GLuint index, GLdouble x, GLdouble y, GLdouble z);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4SNV) (GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4FNV) (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4DNV) (GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4UBNV) (GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB1SVNV) (GLuint index, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB1FVNV) (GLuint index, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB1DVNV) (GLuint index, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB2SVNV) (GLuint index, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB2FVNV) (GLuint index, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB2DVNV) (GLuint index, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB3SVNV) (GLuint index, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB3FVNV) (GLuint index, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB3DVNV) (GLuint index, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4SVNV) (GLuint index, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4FVNV) (GLuint index, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4DVNV) (GLuint index, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIB4UBVNV) (GLuint index, const GLubyte* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIBS1SVNV) (GLuint index, GLsizei n, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIBS1FVNV) (GLuint index, GLsizei n, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIBS1DVNV) (GLuint index, GLsizei n, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIBS2SVNV) (GLuint index, GLsizei n, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIBS2FVNV) (GLuint index, GLsizei n, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIBS2DVNV) (GLuint index, GLsizei n, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIBS3SVNV) (GLuint index, GLsizei n, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIBS3FVNV) (GLuint index, GLsizei n, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIBS3DVNV) (GLuint index, GLsizei n, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIBS4SVNV) (GLuint index, GLsizei n, const GLshort* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIBS4FVNV) (GLuint index, GLsizei n, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIBS4DVNV) (GLuint index, GLsizei n, const GLdouble* v);
typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIBS4UBVNV) (GLuint index, GLsizei n, const GLubyte* v);

// GL_NV_vertex_program1_1


// GL_ATI_element_array
#ifndef GL_ELEMENT_ARRAY_ATI
#define GL_ELEMENT_ARRAY_ATI                                          34664
#endif

#ifndef GL_ELEMENT_ARRAY_TYPE_ATI
#define GL_ELEMENT_ARRAY_TYPE_ATI                                     34665
#endif

#ifndef GL_ELEMENT_ARRAY_POINTER_ATI
#define GL_ELEMENT_ARRAY_POINTER_ATI                                  34666
#endif


typedef GLvoid (csAPIENTRY* csGLELEMENTPOINTERATI) (GLenum type, const GLvoid* pointer);
typedef GLvoid (csAPIENTRY* csGLDRAWELEMENTARRAYATI) (GLenum mode, GLsizei count);
typedef GLvoid (csAPIENTRY* csGLDRAWRANGEELEMENTARRAYATI) (GLenum mode, GLuint start, GLuint end, GLsizei count);

// GL_ATI_envmap_bumpmap
#ifndef GL_BUMP_ROT_MATRIX_ATI
#define GL_BUMP_ROT_MATRIX_ATI                                        34677
#endif

#ifndef GL_BUMP_ROT_MATRIX_SIZE_ATI
#define GL_BUMP_ROT_MATRIX_SIZE_ATI                                   34678
#endif

#ifndef GL_BUMP_NUM_TEX_UNITS_ATI
#define GL_BUMP_NUM_TEX_UNITS_ATI                                     34679
#endif

#ifndef GL_BUMP_TEX_UNITS_ATI
#define GL_BUMP_TEX_UNITS_ATI                                         34680
#endif

#ifndef GL_DUDV_ATI
#define GL_DUDV_ATI                                                   34681
#endif

#ifndef GL_DU8DV8_ATI
#define GL_DU8DV8_ATI                                                 34682
#endif

#ifndef GL_BUMP_ENVMAP_ATI
#define GL_BUMP_ENVMAP_ATI                                            34683
#endif

#ifndef GL_BUMP_TARGET_ATI
#define GL_BUMP_TARGET_ATI                                            34684
#endif


typedef GLvoid (csAPIENTRY* csGLTEXBUMPPARAMETERIVATI) (GLenum pname, GLint* param);
typedef GLvoid (csAPIENTRY* csGLTEXBUMPPARAMETERFVATI) (GLenum pname, GLfloat* param);
typedef GLvoid (csAPIENTRY* csGLGETTEXBUMPPARAMETERIVATI) (GLenum pname, GLint* param);
typedef GLvoid (csAPIENTRY* csGLGETTEXBUMPPARAMETERFVATI) (GLenum pname, GLfloat* param);

// GL_ATI_fragment_shader
#ifndef GL_FRAGMENT_SHADER_ATI
#define GL_FRAGMENT_SHADER_ATI                                        35104
#endif

#ifndef GL_REG_0_ATI
#define GL_REG_0_ATI                                                  35105
#endif

#ifndef GL_REG_1_ATI
#define GL_REG_1_ATI                                                  35106
#endif

#ifndef GL_REG_2_ATI
#define GL_REG_2_ATI                                                  35107
#endif

#ifndef GL_REG_3_ATI
#define GL_REG_3_ATI                                                  35108
#endif

#ifndef GL_REG_4_ATI
#define GL_REG_4_ATI                                                  35109
#endif

#ifndef GL_REG_5_ATI
#define GL_REG_5_ATI                                                  35110
#endif

#ifndef GL_CON_0_ATI
#define GL_CON_0_ATI                                                  35137
#endif

#ifndef GL_CON_1_ATI
#define GL_CON_1_ATI                                                  35138
#endif

#ifndef GL_CON_2_ATI
#define GL_CON_2_ATI                                                  35139
#endif

#ifndef GL_CON_3_ATI
#define GL_CON_3_ATI                                                  35140
#endif

#ifndef GL_CON_4_ATI
#define GL_CON_4_ATI                                                  35141
#endif

#ifndef GL_CON_5_ATI
#define GL_CON_5_ATI                                                  35142
#endif

#ifndef GL_CON_6_ATI
#define GL_CON_6_ATI                                                  35143
#endif

#ifndef GL_CON_7_ATI
#define GL_CON_7_ATI                                                  35144
#endif

#ifndef GL_MOV_ATI
#define GL_MOV_ATI                                                    35169
#endif

#ifndef GL_ADD_ATI
#define GL_ADD_ATI                                                    35171
#endif

#ifndef GL_MUL_ATI
#define GL_MUL_ATI                                                    35172
#endif

#ifndef GL_SUB_ATI
#define GL_SUB_ATI                                                    35173
#endif

#ifndef GL_DOT3_ATI
#define GL_DOT3_ATI                                                   35174
#endif

#ifndef GL_DOT4_ATI
#define GL_DOT4_ATI                                                   35175
#endif

#ifndef GL_MAD_ATI
#define GL_MAD_ATI                                                    35176
#endif

#ifndef GL_LERP_ATI
#define GL_LERP_ATI                                                   35177
#endif

#ifndef GL_CND_ATI
#define GL_CND_ATI                                                    35178
#endif

#ifndef GL_CND0_ATI
#define GL_CND0_ATI                                                   35179
#endif

#ifndef GL_DOT2_ADD_ATI
#define GL_DOT2_ADD_ATI                                               35180
#endif

#ifndef GL_SECONDARY_INTERPOLATOR_ATI
#define GL_SECONDARY_INTERPOLATOR_ATI                                 35181
#endif

#ifndef GL_SWIZZLE_STR_ATI
#define GL_SWIZZLE_STR_ATI                                            35190
#endif

#ifndef GL_SWIZZLE_STQ_ATI
#define GL_SWIZZLE_STQ_ATI                                            35191
#endif

#ifndef GL_SWIZZLE_STR_DR_ATI
#define GL_SWIZZLE_STR_DR_ATI                                         35192
#endif

#ifndef GL_SWIZZLE_STQ_DQ_ATI
#define GL_SWIZZLE_STQ_DQ_ATI                                         35193
#endif

#ifndef GL_RED_BIT_ATI
#define GL_RED_BIT_ATI                                                    1
#endif

#ifndef GL_GREEN_BIT_ATI
#define GL_GREEN_BIT_ATI                                                  2
#endif

#ifndef GL_BLUE_BIT_ATI
#define GL_BLUE_BIT_ATI                                                   4
#endif

#ifndef GL_2X_BIT_ATI
#define GL_2X_BIT_ATI                                                     1
#endif

#ifndef GL_4X_BIT_ATI
#define GL_4X_BIT_ATI                                                     2
#endif

#ifndef GL_8X_BIT_ATI
#define GL_8X_BIT_ATI                                                     4
#endif

#ifndef GL_HALF_BIT_ATI
#define GL_HALF_BIT_ATI                                                   8
#endif

#ifndef GL_QUARTER_BIT_ATI
#define GL_QUARTER_BIT_ATI                                               16
#endif

#ifndef GL_EIGHTH_BIT_ATI
#define GL_EIGHTH_BIT_ATI                                                32
#endif

#ifndef GL_SATURATE_BIT_ATI
#define GL_SATURATE_BIT_ATI                                              64
#endif

#ifndef GL_2X_BIT_ATI
#define GL_2X_BIT_ATI                                                     1
#endif

#ifndef GL_COMP_BIT_ATI
#define GL_COMP_BIT_ATI                                                   2
#endif

#ifndef GL_NEGATE_BIT_ATI
#define GL_NEGATE_BIT_ATI                                                 4
#endif

#ifndef GL_BIAS_BIT_ATI
#define GL_BIAS_BIT_ATI                                                   8
#endif


typedef GLuint (csAPIENTRY* csGLGENFRAGMENTSHADERSATI) (GLuint range);
typedef GLvoid (csAPIENTRY* csGLBINDFRAGMENTSHADERATI) (GLuint id);
typedef GLvoid (csAPIENTRY* csGLDELETEFRAGMENTSHADERATI) (GLuint id);
typedef GLvoid (csAPIENTRY* csGLBEGINFRAGMENTSHADERATI) ();
typedef GLvoid (csAPIENTRY* csGLENDFRAGMENTSHADERATI) ();
typedef GLvoid (csAPIENTRY* csGLPASSTEXCOORDATI) (GLuint dst, GLuint coord, GLenum swizzle);
typedef GLvoid (csAPIENTRY* csGLSAMPLEMAPATI) (GLuint dst, GLuint interp, GLenum swizzle);
typedef GLvoid (csAPIENTRY* csGLCOLORFRAGMENTOP1ATI) (GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod);
typedef GLvoid (csAPIENTRY* csGLCOLORFRAGMENTOP2ATI) (GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod);
typedef GLvoid (csAPIENTRY* csGLCOLORFRAGMENTOP3ATI) (GLenum op, GLuint dst, GLuint dstMask, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod);
typedef GLvoid (csAPIENTRY* csGLALPHAFRAGMENTOP1ATI) (GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod);
typedef GLvoid (csAPIENTRY* csGLALPHAFRAGMENTOP2ATI) (GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod);
typedef GLvoid (csAPIENTRY* csGLALPHAFRAGMENTOP3ATI) (GLenum op, GLuint dst, GLuint dstMod, GLuint arg1, GLuint arg1Rep, GLuint arg1Mod, GLuint arg2, GLuint arg2Rep, GLuint arg2Mod, GLuint arg3, GLuint arg3Rep, GLuint arg3Mod);
typedef GLvoid (csAPIENTRY* csGLSETFRAGMENTSHADERCONSTANTATI) (GLuint dst, const GLfloat* value);

// GL_ATI_pn_triangles
#ifndef GL_PN_TRIANGLES_ATI
#define GL_PN_TRIANGLES_ATI                                           34800
#endif

#ifndef GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI
#define GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI                     34801
#endif

#ifndef GL_PN_TRIANGLES_POINT_MODE_ATI
#define GL_PN_TRIANGLES_POINT_MODE_ATI                                34802
#endif

#ifndef GL_PN_TRIANGLES_NORMAL_MODE_ATI
#define GL_PN_TRIANGLES_NORMAL_MODE_ATI                               34803
#endif

#ifndef GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI
#define GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI                         34804
#endif

#ifndef GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI
#define GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI                         34805
#endif

#ifndef GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI
#define GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI                          34806
#endif

#ifndef GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI
#define GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI                        34807
#endif

#ifndef GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI
#define GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI                     34808
#endif


typedef GLvoid (csAPIENTRY* csGLPNTRIANGLESIATI) (GLenum pname, GLint param);
typedef GLvoid (csAPIENTRY* csGLPNTRIANGLESFATI) (GLenum pname, GLfloat param);

// GL_ATI_texture_mirror_once
#ifndef GL_MIRROR_CLAMP_ATI
#define GL_MIRROR_CLAMP_ATI                                           34626
#endif

#ifndef GL_MIRROR_CLAMP_TO_EDGE_ATI
#define GL_MIRROR_CLAMP_TO_EDGE_ATI                                   34627
#endif



// GL_ATI_vertex_array_object
#ifndef GL_STATIC_ATI
#define GL_STATIC_ATI                                                 34656
#endif

#ifndef GL_DYNAMIC_ATI
#define GL_DYNAMIC_ATI                                                34657
#endif

#ifndef GL_PRESERVE_ATI
#define GL_PRESERVE_ATI                                               34658
#endif

#ifndef GL_DISCARD_ATI
#define GL_DISCARD_ATI                                                34659
#endif

#ifndef GL_OBJECT_BUFFER_SIZE_ATI
#define GL_OBJECT_BUFFER_SIZE_ATI                                     34660
#endif

#ifndef GL_OBJECT_BUFFER_USAGE_ATI
#define GL_OBJECT_BUFFER_USAGE_ATI                                    34661
#endif

#ifndef GL_ARRAY_OBJECT_BUFFER_ATI
#define GL_ARRAY_OBJECT_BUFFER_ATI                                    34662
#endif

#ifndef GL_ARRAY_OBJECT_OFFSET_ATI
#define GL_ARRAY_OBJECT_OFFSET_ATI                                    34663
#endif


typedef GLuint (csAPIENTRY* csGLNEWOBJECTBUFFERATI) (GLsizei size, const GLvoid* pointer, GLenum usage);
typedef GLboolean (csAPIENTRY* csGLISOBJECTBUFFERATI) (GLuint buffer);
typedef GLvoid (csAPIENTRY* csGLUPDATEOBJECTBUFFERATI) (GLuint buffer, GLuint offset, GLsizei size, const GLvoid* pointer, GLenum preserve);
typedef GLvoid (csAPIENTRY* csGLGETOBJECTBUFFERFVATI) (GLuint buffer, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETOBJECTBUFFERIVATI) (GLuint buffer, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLFREEOBJECTBUFFERATI) (GLuint buffer);
typedef GLvoid (csAPIENTRY* csGLARRAYOBJECTATI) (GLenum array, GLint size, GLenum type, GLsizei stride, GLuint buffer, GLuint offset);
typedef GLvoid (csAPIENTRY* csGLGETARRAYOBJECTFVATI) (GLenum array, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETARRAYOBJECTIVATI) (GLenum array, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLVARIANTARRAYOBJECTATI) (GLuint id, GLenum type, GLsizei stride, GLuint buffer, GLuint offset);
typedef GLvoid (csAPIENTRY* csGLGETVARIANTARRAYOBJECTFVATI) (GLuint id, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETVARIANTARRAYOBJECTIVATI) (GLuint id, GLenum pname, GLint* params);

// GL_ATI_vertex_attrib_array_object

typedef GLvoid (csAPIENTRY* csGLVERTEXATTRIBARRAYOBJECTATI) (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, GLuint buffer, GLuint offset);
typedef GLvoid (csAPIENTRY* csGLGETVERTEXATTRIBARRAYOBJECTFVATI) (GLuint index, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETVERTEXATTRIBARRAYOBJECTIVATI) (GLuint index, GLenum pname, GLint* params);

// GL_ATI_vertex_streams
#ifndef GL_MAX_VERTEX_STREAMS_ATI
#define GL_MAX_VERTEX_STREAMS_ATI                                     34667
#endif

#ifndef GL_VERTEX_STREAM0_ATI
#define GL_VERTEX_STREAM0_ATI                                         34668
#endif

#ifndef GL_VERTEX_STREAM1_ATI
#define GL_VERTEX_STREAM1_ATI                                         34669
#endif

#ifndef GL_VERTEX_STREAM2_ATI
#define GL_VERTEX_STREAM2_ATI                                         34670
#endif

#ifndef GL_VERTEX_STREAM3_ATI
#define GL_VERTEX_STREAM3_ATI                                         34671
#endif

#ifndef GL_VERTEX_STREAM4_ATI
#define GL_VERTEX_STREAM4_ATI                                         34672
#endif

#ifndef GL_VERTEX_STREAM5_ATI
#define GL_VERTEX_STREAM5_ATI                                         34673
#endif

#ifndef GL_VERTEX_STREAM6_ATI
#define GL_VERTEX_STREAM6_ATI                                         34674
#endif

#ifndef GL_VERTEX_STREAM7_ATI
#define GL_VERTEX_STREAM7_ATI                                         34675
#endif

#ifndef GL_VERTEX_SOURCE_ATI
#define GL_VERTEX_SOURCE_ATI                                          34676
#endif


typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM1S) (GLenum stream, GLshort coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM1I) (GLenum stream, GLint coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM1F) (GLenum stream, GLfloat coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM1D) (GLenum stream, GLdouble coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM1SV) (GLenum stream, GLshort coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM1IV) (GLenum stream, GLint coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM1FV) (GLenum stream, GLfloat coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM1DV) (GLenum stream, GLdouble coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM2S) (GLenum stream, GLshort coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM2I) (GLenum stream, GLint coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM2F) (GLenum stream, GLfloat coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM2D) (GLenum stream, GLdouble coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM2SV) (GLenum stream, GLshort coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM2IV) (GLenum stream, GLint coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM2FV) (GLenum stream, GLfloat coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM2DV) (GLenum stream, GLdouble coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM3S) (GLenum stream, GLshort coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM3I) (GLenum stream, GLint coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM3F) (GLenum stream, GLfloat coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM3D) (GLenum stream, GLdouble coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM3SV) (GLenum stream, GLshort coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM3IV) (GLenum stream, GLint coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM3FV) (GLenum stream, GLfloat coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM3DV) (GLenum stream, GLdouble coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM4S) (GLenum stream, GLshort coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM4I) (GLenum stream, GLint coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM4F) (GLenum stream, GLfloat coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM4D) (GLenum stream, GLdouble coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM4SV) (GLenum stream, GLshort coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM4IV) (GLenum stream, GLint coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM4FV) (GLenum stream, GLfloat coords);
typedef GLvoid (csAPIENTRY* csGLVERTEXSTREAM4DV) (GLenum stream, GLdouble coords);
typedef GLvoid (csAPIENTRY* csGLNORMALSTREAM3B) (GLenum stream, GLbyte coords);
typedef GLvoid (csAPIENTRY* csGLNORMALSTREAM3S) (GLenum stream, GLshort coords);
typedef GLvoid (csAPIENTRY* csGLNORMALSTREAM3I) (GLenum stream, GLint coords);
typedef GLvoid (csAPIENTRY* csGLNORMALSTREAM3F) (GLenum stream, GLfloat coords);
typedef GLvoid (csAPIENTRY* csGLNORMALSTREAM3D) (GLenum stream, GLdouble coords);
typedef GLvoid (csAPIENTRY* csGLNORMALSTREAM3BV) (GLenum stream, GLbyte coords);
typedef GLvoid (csAPIENTRY* csGLNORMALSTREAM3SV) (GLenum stream, GLshort coords);
typedef GLvoid (csAPIENTRY* csGLNORMALSTREAM3IV) (GLenum stream, GLint coords);
typedef GLvoid (csAPIENTRY* csGLNORMALSTREAM3FV) (GLenum stream, GLfloat coords);
typedef GLvoid (csAPIENTRY* csGLNORMALSTREAM3DV) (GLenum stream, GLdouble coords);
typedef GLvoid (csAPIENTRY* csGLCLIENTACTIVEVERTEXSTREAM) (GLenum stream);
typedef GLvoid (csAPIENTRY* csGLVERTEXBLENDENVI) (GLenum pname, GLint param);
typedef GLvoid (csAPIENTRY* csGLVERTEXBLENDENVF) (GLenum pname, GLfloat param);

// WGL_I3D_image_buffer
#ifdef _WIN32
#ifndef WGL_IMAGE_BUFFER_MIN_ACCESS_I3D
#define WGL_IMAGE_BUFFER_MIN_ACCESS_I3D                                   1
#endif

#ifndef WGL_IMAGE_BUFFER_LOCK_I3D
#define WGL_IMAGE_BUFFER_LOCK_I3D                                         2
#endif


typedef GLvoid* (csAPIENTRY* csWGLCREATEIMAGEBUFFERI3D) (HDC hDC, DWORD dwSize, UINT uFlags);
typedef BOOL (csAPIENTRY* csWGLDESTROYIMAGEBUFFERI3D) (HDC hDC, GLvoid* pAddress);
typedef BOOL (csAPIENTRY* csWGLASSOCIATEIMAGEBUFFEREVENTSI3D) (HDC hdc, HANDLE* pEvent, GLvoid* pAddress, DWORD* pSize, UINT count);
typedef BOOL (csAPIENTRY* csWGLRELEASEIMAGEBUFFEREVENTSI3D) (HDC hdc, GLvoid* pAddress, UINT count);

#endif

// WGL_I3D_swap_frame_lock
#ifdef _WIN32

typedef BOOL (csAPIENTRY* csWGLENABLEFRAMELOCKI3D) ();
typedef BOOL (csAPIENTRY* csWGLDISABLEFRAMELOCKI3D) ();
typedef BOOL (csAPIENTRY* csWGLISENABLEDFRAMELOCKI3D) (BOOL* pFlag);
typedef BOOL (csAPIENTRY* csWGLQUERYFRAMELOCKMASTERI3D) (BOOL* pFlag);

#endif

// WGL_I3D_swap_frame_usage
#ifdef _WIN32

typedef BOOL (csAPIENTRY* csWGLGETFRAMEUSAGEI3D) (GLfloat* pUsage);
typedef BOOL (csAPIENTRY* csWGLBEGINFRAMETRACKINGI3D) ();
typedef BOOL (csAPIENTRY* csWGLENDFRAMETRACKINGI3D) ();
typedef BOOL (csAPIENTRY* csWGLQUERYFRAMETRACKINGI3D) (DWORD* pFrameCount, DWORD* pMissedFrames, GLfloat* pLastMissedUsage);

#endif

// GL_3DFX_texture_compression_FXT1
#ifndef GL_COMPRESSED_RGB_FXT1_3DFX
#define GL_COMPRESSED_RGB_FXT1_3DFX                                   34480
#endif

#ifndef GL_COMPRESSED_RGBA_FXT1_3DFX
#define GL_COMPRESSED_RGBA_FXT1_3DFX                                  34481
#endif



// GL_IBM_cull_vertex
#ifndef GL_CULL_VERTEX_IBM
#define GL_CULL_VERTEX_IBM                                           103050
#endif



// GL_IBM_multimode_draw_arrays

typedef GLvoid (csAPIENTRY* csGLMULTIMODEDRAWARRAYSIBM) (GLenum* mode, GLint* first, GLsizei* count, GLsizei primcount, GLint modestride);
typedef GLvoid (csAPIENTRY* csGLMULTIMODEDRAWELEMENTSIBM) (GLenum* mode, GLsizei* count, GLenum type, const GLvoid* indices, GLsizei primcount, GLint modestride);

// GL_IBM_raster_pos_clip
#ifndef GL_RASTER_POSITION_UNCLIPPED_IBM
#define GL_RASTER_POSITION_UNCLIPPED_IBM                             103010
#endif



// GL_IBM_texture_mirrored_repeat
#ifndef GL_MIRRORED_REPEAT_IBM
#define GL_MIRRORED_REPEAT_IBM                                        33648
#endif



// GL_IBM_vertex_array_lists
#ifndef GL_VERTEX_ARRAY_LIST_IBM
#define GL_VERTEX_ARRAY_LIST_IBM                                     103070
#endif

#ifndef GL_NORMAL_ARRAY_LIST_IBM
#define GL_NORMAL_ARRAY_LIST_IBM                                     103071
#endif

#ifndef GL_COLOR_ARRAY_LIST_IBM
#define GL_COLOR_ARRAY_LIST_IBM                                      103072
#endif

#ifndef GL_INDEX_ARRAY_LIST_IBM
#define GL_INDEX_ARRAY_LIST_IBM                                      103073
#endif

#ifndef GL_TEXTURE_COORD_ARRAY_LIST_IBM
#define GL_TEXTURE_COORD_ARRAY_LIST_IBM                              103074
#endif

#ifndef GL_EDGE_FLAG_ARRAY_LIST_IBM
#define GL_EDGE_FLAG_ARRAY_LIST_IBM                                  103075
#endif

#ifndef GL_FOG_COORDINATE_ARRAY_LIST_IBM
#define GL_FOG_COORDINATE_ARRAY_LIST_IBM                             103076
#endif

#ifndef GL_SECONDARY_COLOR_ARRAY_LIST_IBM
#define GL_SECONDARY_COLOR_ARRAY_LIST_IBM                            103077
#endif

#ifndef GL_VERTEX_ARRAY_LIST_STRIDE_IBM
#define GL_VERTEX_ARRAY_LIST_STRIDE_IBM                              103080
#endif

#ifndef GL_NORMAL_ARRAY_LIST_STRIDE_IBM
#define GL_NORMAL_ARRAY_LIST_STRIDE_IBM                              103081
#endif

#ifndef GL_COLOR_ARRAY_LIST_STRIDE_IBM
#define GL_COLOR_ARRAY_LIST_STRIDE_IBM                               103082
#endif

#ifndef GL_INDEX_ARRAY_LIST_STRIDE_IBM
#define GL_INDEX_ARRAY_LIST_STRIDE_IBM                               103083
#endif

#ifndef GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM
#define GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM                       103084
#endif

#ifndef GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM
#define GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM                           103085
#endif

#ifndef GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM
#define GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM                      103086
#endif

#ifndef GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM
#define GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM                     103087
#endif


typedef GLvoid (csAPIENTRY* csGLCOLORPOINTERLISTIBM) (GLint size, GLenum type, GLint stride, const GLvoid* pointer, GLint ptrstride);
typedef GLvoid (csAPIENTRY* csGLSECONDARYCOLORPOINTERLISTIBM) (GLint size, GLenum type, GLint stride, const GLvoid* pointer, GLint ptrstride);
typedef GLvoid (csAPIENTRY* csGLEDGEFLAGPOINTERLISTIBM) (GLint stride, const GLboolean* pointer, GLint ptrstride);
typedef GLvoid (csAPIENTRY* csGLFOGCOORDPOINTERLISTIBM) (GLenum type, GLint stride, const GLvoid* pointer, GLint ptrstride);
typedef GLvoid (csAPIENTRY* csGLNORMALPOINTERLISTIBM) (GLenum type, GLint stride, const GLvoid* pointer, GLint ptrstride);
typedef GLvoid (csAPIENTRY* csGLTEXCOORDPOINTERLISTIBM) (GLint size, GLenum type, GLint stride, const GLvoid* pointer, GLint ptrstride);
typedef GLvoid (csAPIENTRY* csGLVERTEXPOINTERLISTIBM) (GLint size, GLenum type, GLint stride, const GLvoid* pointer, GLint ptrstride);

// GL_MESA_resize_buffers

typedef GLvoid (csAPIENTRY* csGLRESIZEBUFFERSMESA) ();

// GL_MESA_window_pos

typedef GLvoid (csAPIENTRY* csGLWINDOWPOS2DMESA) (GLdouble x, GLdouble y);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS2FMESA) (GLfloat x, GLfloat y);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS2IMESA) (GLint x, GLint y);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS2SMESA) (GLshort x, GLshort y);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS2IVMESA) (const GLint* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS2SVMESA) (const GLshort* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS2FVMESA) (const GLfloat* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS2DVMESA) (const GLdouble* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS3IMESA) (GLint x, GLint y, GLint z);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS3SMESA) (GLshort x, GLshort y, GLshort z);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS3FMESA) (GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS3DMESA) (GLdouble x, GLdouble y, GLdouble z);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS3IVMESA) (const GLint* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS3SVMESA) (const GLshort* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS3FVMESA) (const GLfloat* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS3DVMESA) (const GLdouble* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS4IMESA) (GLint x, GLint y, GLint z, GLint w);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS4SMESA) (GLshort x, GLshort y, GLshort z, GLshort w);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS4FMESA) (GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS4DMESA) (GLdouble x, GLdouble y, GLdouble z, GLdouble w);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS4IVMESA) (const GLint* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS4SVMESA) (const GLshort* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS4FVMESA) (const GLfloat* p);
typedef GLvoid (csAPIENTRY* csGLWINDOWPOS4DVMESA) (const GLdouble* p);

// GL_OML_interlace
#ifndef GL_INTERLACE_OML
#define GL_INTERLACE_OML                                              35200
#endif

#ifndef GL_INTERLACE_READ_OML
#define GL_INTERLACE_READ_OML                                         35201
#endif



// GL_OML_resample
#ifndef GL_PACK_RESAMPLE_OML
#define GL_PACK_RESAMPLE_OML                                          35204
#endif

#ifndef GL_UNPACK_RESAMPLE_OML
#define GL_UNPACK_RESAMPLE_OML                                        35205
#endif

#ifndef GL_RESAMPLE_REPLICATE_OML
#define GL_RESAMPLE_REPLICATE_OML                                     35206
#endif

#ifndef GL_RESAMPLE_ZERO_FILL_OML
#define GL_RESAMPLE_ZERO_FILL_OML                                     35207
#endif

#ifndef GL_RESAMPLE_AVERAGE_OML
#define GL_RESAMPLE_AVERAGE_OML                                       35208
#endif

#ifndef GL_RESAMPLE_DECIMATE_OML
#define GL_RESAMPLE_DECIMATE_OML                                      35209
#endif

#ifndef GL_RESAMPLE_AVERAGE_OML
#define GL_RESAMPLE_AVERAGE_OML                                       35208
#endif



// GL_OML_subsample
#ifndef GL_FORMAT_SUBSAMPLE_24_24_OML
#define GL_FORMAT_SUBSAMPLE_24_24_OML                                 35202
#endif

#ifndef GL_FORMAT_SUBSAMPLE_244_244_OML
#define GL_FORMAT_SUBSAMPLE_244_244_OML                               35203
#endif



// GL_SGIS_generate_mipmap
#ifndef GL_GENERATE_MIPMAP_SGIS
#define GL_GENERATE_MIPMAP_SGIS                                       33169
#endif

#ifndef GL_GENERATE_MIPMAP_HINT_SGIS
#define GL_GENERATE_MIPMAP_HINT_SGIS                                  33170
#endif



// GL_SGIS_multisample
#ifndef GLX_SAMPLE_BUFFERS_SGIS
#define GLX_SAMPLE_BUFFERS_SGIS                                      100000
#endif

#ifndef GLX_SAMPLES_SGIS
#define GLX_SAMPLES_SGIS                                             100001
#endif

#ifndef GL_MULTISAMPLE_SGIS
#define GL_MULTISAMPLE_SGIS                                           32925
#endif

#ifndef GL_SAMPLE_ALPHA_TO_MASK_SGIS
#define GL_SAMPLE_ALPHA_TO_MASK_SGIS                                  32926
#endif

#ifndef GL_SAMPLE_ALPHA_TO_ONE_SGIS
#define GL_SAMPLE_ALPHA_TO_ONE_SGIS                                   32927
#endif

#ifndef GL_SAMPLE_MASK_SGIS
#define GL_SAMPLE_MASK_SGIS                                           32928
#endif

#ifndef GL_MULTISAMPLE_BIT_EXT
#define GL_MULTISAMPLE_BIT_EXT                                       536870912
#endif

#ifndef GL_1PASS_SGIS
#define GL_1PASS_SGIS                                                 32929
#endif

#ifndef GL_2PASS_0_SGIS
#define GL_2PASS_0_SGIS                                               32930
#endif

#ifndef GL_2PASS_1_SGIS
#define GL_2PASS_1_SGIS                                               32931
#endif

#ifndef GL_4PASS_0_SGIS
#define GL_4PASS_0_SGIS                                               32932
#endif

#ifndef GL_4PASS_1_SGIS
#define GL_4PASS_1_SGIS                                               32933
#endif

#ifndef GL_4PASS_2_SGIS
#define GL_4PASS_2_SGIS                                               32934
#endif

#ifndef GL_4PASS_3_SGIS
#define GL_4PASS_3_SGIS                                               32935
#endif

#ifndef GL_SAMPLE_BUFFERS_SGIS
#define GL_SAMPLE_BUFFERS_SGIS                                        32936
#endif

#ifndef GL_SAMPLES_SGIS
#define GL_SAMPLES_SGIS                                               32937
#endif

#ifndef GL_SAMPLE_MASK_VALUE_SGIS
#define GL_SAMPLE_MASK_VALUE_SGIS                                     32938
#endif

#ifndef GL_SAMPLE_MASK_INVERT_SGIS
#define GL_SAMPLE_MASK_INVERT_SGIS                                    32939
#endif

#ifndef GL_SAMPLE_PATTERN_SGIS
#define GL_SAMPLE_PATTERN_SGIS                                        32940
#endif


typedef GLvoid (csAPIENTRY* csGLSAMPLEMASKSGIS) (GLclampf value, GLboolean invert);
typedef GLvoid (csAPIENTRY* csGLSAMPLEPATTERNSGIS) (GLenum pattern);

// GL_SGIS_pixel_texture
#ifndef GL_PIXEL_TEXTURE_SGIS
#define GL_PIXEL_TEXTURE_SGIS                                         33619
#endif

#ifndef GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS
#define GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS                             33620
#endif

#ifndef GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS
#define GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS                           33621
#endif

#ifndef GL_PIXEL_GROUP_COLOR_SGIS
#define GL_PIXEL_GROUP_COLOR_SGIS                                     33622
#endif


typedef GLvoid (csAPIENTRY* csGLPIXELTEXGENPARAMETERISGIS) (GLenum pname, GLint param);
typedef GLvoid (csAPIENTRY* csGLPIXELTEXGENPARAMETERFSGIS) (GLenum pname, GLfloat param);
typedef GLvoid (csAPIENTRY* csGLGETPIXELTEXGENPARAMETERIVSGIS) (GLenum pname, GLint params);
typedef GLvoid (csAPIENTRY* csGLGETPIXELTEXGENPARAMETERFVSGIS) (GLenum pname, GLfloat params);

// GL_SGIS_texture_border_clamp
#ifndef GL_CLAMP_TO_BORDER_SGIS
#define GL_CLAMP_TO_BORDER_SGIS                                       33069
#endif



// GL_SGIS_texture_color_mask
#ifndef GL_TEXTURE_COLOR_WRITEMASK_SGIS
#define GL_TEXTURE_COLOR_WRITEMASK_SGIS                               33263
#endif


typedef GLvoid (csAPIENTRY* csGLTEXTURECOLORMASKSGIS) (GLboolean r, GLboolean g, GLboolean b, GLboolean a);

// GL_SGIS_texture_edge_clamp
#ifndef GL_CLAMP_TO_EDGE_SGIS
#define GL_CLAMP_TO_EDGE_SGIS                                         33071
#endif



// GL_SGIS_texture_lod
#ifndef GL_TEXTURE_MIN_LOD_SGIS
#define GL_TEXTURE_MIN_LOD_SGIS                                       33082
#endif

#ifndef GL_TEXTURE_MAX_LOD_SGIS
#define GL_TEXTURE_MAX_LOD_SGIS                                       33083
#endif

#ifndef GL_TEXTURE_BASE_LEVEL_SGIS
#define GL_TEXTURE_BASE_LEVEL_SGIS                                    33084
#endif

#ifndef GL_TEXTURE_MAX_LEVEL_SGIS
#define GL_TEXTURE_MAX_LEVEL_SGIS                                     33085
#endif



// GL_SGIS_depth_texture
#ifndef GL_DEPTH_COMPONENT16_SGIX
#define GL_DEPTH_COMPONENT16_SGIX                                     33189
#endif

#ifndef GL_DEPTH_COMPONENT24_SGIX
#define GL_DEPTH_COMPONENT24_SGIX                                     33190
#endif

#ifndef GL_DEPTH_COMPONENT32_SGIX
#define GL_DEPTH_COMPONENT32_SGIX                                     33191
#endif



// GL_SGIX_fog_offset
#ifndef GL_FOG_OFFSET_SGIX
#define GL_FOG_OFFSET_SGIX                                            33176
#endif

#ifndef GL_FOG_OFFSET_VALUE_SGIX
#define GL_FOG_OFFSET_VALUE_SGIX                                      33177
#endif



// GL_SGIX_interlace
#ifndef GL_INTERLACE_SGIX
#define GL_INTERLACE_SGIX                                             32916
#endif



// GL_SGIX_shadow_ambient
#ifndef GL_SHADOW_AMBIENT_SGIX
#define GL_SHADOW_AMBIENT_SGIX                                        32959
#endif



// GL_SGI_color_matrix
#ifndef GL_COLOR_MATRIX_SGI
#define GL_COLOR_MATRIX_SGI                                           32945
#endif

#ifndef GL_COLOR_MATRIX_STACK_DEPTH_SGI
#define GL_COLOR_MATRIX_STACK_DEPTH_SGI                               32946
#endif

#ifndef GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI
#define GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI                           32947
#endif

#ifndef GL_POST_COLOR_MATRIX_RED_SCALE_SGI
#define GL_POST_COLOR_MATRIX_RED_SCALE_SGI                            32948
#endif

#ifndef GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI
#define GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI                          32949
#endif

#ifndef GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI
#define GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI                           32950
#endif

#ifndef GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI
#define GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI                          32951
#endif

#ifndef GL_POST_COLOR_MATRIX_RED_BIAS_SGI
#define GL_POST_COLOR_MATRIX_RED_BIAS_SGI                             32952
#endif

#ifndef GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI
#define GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI                           32953
#endif

#ifndef GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI
#define GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI                            32954
#endif

#ifndef GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI
#define GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI                           32955
#endif



// GL_SGI_color_table
#ifndef GL_COLOR_TABLE_SGI
#define GL_COLOR_TABLE_SGI                                            32976
#endif

#ifndef GL_POST_CONVOLUTION_COLOR_TABLE_SGI
#define GL_POST_CONVOLUTION_COLOR_TABLE_SGI                           32977
#endif

#ifndef GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI
#define GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI                          32978
#endif

#ifndef GL_PROXY_COLOR_TABLE_SGI
#define GL_PROXY_COLOR_TABLE_SGI                                      32979
#endif

#ifndef GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI
#define GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI                     32980
#endif

#ifndef GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI
#define GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI                    32981
#endif

#ifndef GL_COLOR_TABLE_SCALE_SGI
#define GL_COLOR_TABLE_SCALE_SGI                                      32982
#endif

#ifndef GL_COLOR_TABLE_BIAS_SGI
#define GL_COLOR_TABLE_BIAS_SGI                                       32983
#endif

#ifndef GL_COLOR_TABLE_FORMAT_SGI
#define GL_COLOR_TABLE_FORMAT_SGI                                     32984
#endif

#ifndef GL_COLOR_TABLE_WIDTH_SGI
#define GL_COLOR_TABLE_WIDTH_SGI                                      32985
#endif

#ifndef GL_COLOR_TABLE_RED_SIZE_SGI
#define GL_COLOR_TABLE_RED_SIZE_SGI                                   32986
#endif

#ifndef GL_COLOR_TABLE_GREEN_SIZE_SGI
#define GL_COLOR_TABLE_GREEN_SIZE_SGI                                 32987
#endif

#ifndef GL_COLOR_TABLE_BLUE_SIZE_SGI
#define GL_COLOR_TABLE_BLUE_SIZE_SGI                                  32988
#endif

#ifndef GL_COLOR_TABLE_ALPHA_SIZE_SGI
#define GL_COLOR_TABLE_ALPHA_SIZE_SGI                                 32989
#endif

#ifndef GL_COLOR_TABLE_LUMINANCE_SIZE_SGI
#define GL_COLOR_TABLE_LUMINANCE_SIZE_SGI                             32990
#endif

#ifndef GL_COLOR_TABLE_INTENSITY_SIZE_SGI
#define GL_COLOR_TABLE_INTENSITY_SIZE_SGI                             32991
#endif


typedef GLvoid (csAPIENTRY* csGLCOLORTABLESGI) (GLenum target, GLenum internalformat, GLsizei width, GLenum format, GLenum type, const GLvoid* table);
typedef GLvoid (csAPIENTRY* csGLCOPYCOLORTABLESGI) (GLenum target, GLenum internalformat, GLint x, GLint y, GLsizei width);
typedef GLvoid (csAPIENTRY* csGLCOLORTABLEPARAMETERIVSGI) (GLenum target, GLenum pname, const GLint* params);
typedef GLvoid (csAPIENTRY* csGLCOLORTABLEPARAMETERFVSGI) (GLenum target, GLenum pname, const GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETCOLORTABLESGI) (GLenum target, GLenum format, GLenum type, GLvoid* table);
typedef GLvoid (csAPIENTRY* csGLGETCOLORTABLEPARAMETERIVSGI) (GLenum target, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETCOLORTABLEPARAMETERFVSGI) (GLenum target, GLenum pname, GLfloat* params);

// GL_SGI_texture_color_table
#ifndef GL_TEXTURE_COLOR_TABLE_SGI
#define GL_TEXTURE_COLOR_TABLE_SGI                                    32956
#endif

#ifndef GL_PROXY_TEXTURE_COLOR_TABLE_SGI
#define GL_PROXY_TEXTURE_COLOR_TABLE_SGI                              32957
#endif



// GL_SUN_vertex

typedef GLvoid (csAPIENTRY* csGLCOLOR4UBVERTEX2FSUN) (GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y);
typedef GLvoid (csAPIENTRY* csGLCOLOR4UBVERTEX2FVSUN) (const GLubyte* c, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLCOLOR4UBVERTEX3FSUN) (GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLCOLOR4UBVERTEX3FVSUN) (const GLubyte* c, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLCOLOR3FVERTEX3FSUN) (GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLCOLOR3FVERTEX3FVSUN) (const GLfloat* c, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLNORMAL3FVERTEX3FSUN) (GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLNORMAL3FVERTEX3FVSUN) (const GLfloat* n, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLCOLOR4FNORMAL3FVERTEX3FSUN) (GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLCOLOR4FNORMAL3FVERTEX3FVSUN) (const GLfloat* c, const GLfloat* n, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLTEXCOORD2FVERTEX3FSUN) (GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLTEXCOORD2FVERTEX3FVSUN) (const GLfloat* tc, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLTEXCOORD4FVERTEX4FSUN) (GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef GLvoid (csAPIENTRY* csGLTEXCOORD4FVERTEX4FVSUN) (const GLfloat* tc, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLTEXCOORD2FCOLOR4UBVERTEX3FSUN) (GLfloat s, GLfloat t, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLTEXCOORD2FCOLOR4UBVERTEX3FVSUN) (const GLfloat* tc, const GLubyte* c, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLTEXCOORD2FCOLOR3FVERTEX3FSUN) (GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLTEXCOORD2FCOLOR3FVERTEX3FVSUN) (const GLfloat* tc, const GLfloat* c, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLTEXCOORD2FNORMAL3FVERTEX3FSUN) (GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLTEXCOORD2FNORMAL3FVERTEX3FVSUN) (const GLfloat* tc, const GLfloat* n, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUN) (GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUN) (const GLfloat* tc, const GLfloat* c, const GLfloat* n, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FSUN) (GLfloat s, GLfloat t, GLfloat p, GLfloat q, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef GLvoid (csAPIENTRY* csGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FVSUN) (const GLfloat* tc, const GLfloat* c, const GLfloat* n, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLREPLACEMENTCODEUIVERTEX3FSUN) (GLuint rc, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLREPLACEMENTCODEUIVERTEX3FVSUN) (const GLuint* rc, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLREPLACEMENTCODEUICOLOR4UBVERTEX3FSUN) (GLuint rc, GLubyte r, GLubyte g, GLubyte b, GLubyte a, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLREPLACEMENTCODEUICOLOR4UBVERTEX3FVSUN) (const GLuint* rc, const GLubyte* c, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLREPLACEMENTCODEUICOLOR3FVERTEX3FSUN) (GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLREPLACEMENTCODEUICOLOR3FVERTEX3FVSUN) (const GLuint* rc, const GLfloat* c, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLREPLACEMENTCODEUINORMAL3FVERTEX3FSUN) (GLuint rc, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLREPLACEMENTCODEUINORMAL3FVERTEX3FVSUN) (const GLuint* rc, const GLfloat* n, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FSUN) (GLuint rc, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FVSUN) (const GLuint* rc, const GLfloat* c, const GLfloat* n, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FSUN) (GLuint rc, GLfloat s, GLfloat t, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FVSUN) (const GLuint* rc, const GLfloat* tc, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FSUN) (GLuint rc, GLfloat s, GLfloat t, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FVSUN) (const GLuint* rc, const GLfloat* tc, const GLfloat* n, const GLfloat* v);
typedef GLvoid (csAPIENTRY* csGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUN) (GLuint rc, GLfloat s, GLfloat t, GLfloat r, GLfloat g, GLfloat b, GLfloat a, GLfloat nx, GLfloat ny, GLfloat nz, GLfloat x, GLfloat y, GLfloat z);
typedef GLvoid (csAPIENTRY* csGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUN) (const GLuint* rc, const GLfloat* tc, const GLfloat* c, const GLfloat* n, const GLfloat* v);

// GL_ARB_fragment_program
#ifndef GL_FRAGMENT_PROGRAM_ARB
#define GL_FRAGMENT_PROGRAM_ARB                                       34820
#endif

#ifndef GL_PROGRAM_FORMAT_ASCII_ARB
#define GL_PROGRAM_FORMAT_ASCII_ARB                                   34933
#endif

#ifndef GL_PROGRAM_LENGTH_ARB
#define GL_PROGRAM_LENGTH_ARB                                         34343
#endif

#ifndef GL_PROGRAM_FORMAT_ARB
#define GL_PROGRAM_FORMAT_ARB                                         34934
#endif

#ifndef GL_PROGRAM_BINDING_ARB
#define GL_PROGRAM_BINDING_ARB                                        34423
#endif

#ifndef GL_PROGRAM_INSTRUCTIONS_ARB
#define GL_PROGRAM_INSTRUCTIONS_ARB                                   34976
#endif

#ifndef GL_MAX_PROGRAM_INSTRUCTIONS_ARB
#define GL_MAX_PROGRAM_INSTRUCTIONS_ARB                               34977
#endif

#ifndef GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB
#define GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB                            34978
#endif

#ifndef GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB
#define GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB                        34979
#endif

#ifndef GL_PROGRAM_TEMPORARIES_ARB
#define GL_PROGRAM_TEMPORARIES_ARB                                    34980
#endif

#ifndef GL_MAX_PROGRAM_TEMPORARIES_ARB
#define GL_MAX_PROGRAM_TEMPORARIES_ARB                                34981
#endif

#ifndef GL_PROGRAM_NATIVE_TEMPORARIES_ARB
#define GL_PROGRAM_NATIVE_TEMPORARIES_ARB                             34982
#endif

#ifndef GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB
#define GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB                         34983
#endif

#ifndef GL_PROGRAM_PARAMETERS_ARB
#define GL_PROGRAM_PARAMETERS_ARB                                     34984
#endif

#ifndef GL_MAX_PROGRAM_PARAMETERS_ARB
#define GL_MAX_PROGRAM_PARAMETERS_ARB                                 34985
#endif

#ifndef GL_PROGRAM_NATIVE_PARAMETERS_ARB
#define GL_PROGRAM_NATIVE_PARAMETERS_ARB                              34986
#endif

#ifndef GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB
#define GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB                          34987
#endif

#ifndef GL_PROGRAM_ATTRIBS_ARB
#define GL_PROGRAM_ATTRIBS_ARB                                        34988
#endif

#ifndef GL_MAX_PROGRAM_ATTRIBS_ARB
#define GL_MAX_PROGRAM_ATTRIBS_ARB                                    34989
#endif

#ifndef GL_PROGRAM_NATIVE_ATTRIBS_ARB
#define GL_PROGRAM_NATIVE_ATTRIBS_ARB                                 34990
#endif

#ifndef GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB
#define GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB                             34991
#endif

#ifndef GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB
#define GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB                           34996
#endif

#ifndef GL_MAX_PROGRAM_ENV_PARAMETERS_ARB
#define GL_MAX_PROGRAM_ENV_PARAMETERS_ARB                             34997
#endif

#ifndef GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB
#define GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB                            34998
#endif

#ifndef GL_PROGRAM_ALU_INSTRUCTIONS_ARB
#define GL_PROGRAM_ALU_INSTRUCTIONS_ARB                               34821
#endif

#ifndef GL_PROGRAM_TEX_INSTRUCTIONS_ARB
#define GL_PROGRAM_TEX_INSTRUCTIONS_ARB                               34822
#endif

#ifndef GL_PROGRAM_TEX_INDIRECTIONS_ARB
#define GL_PROGRAM_TEX_INDIRECTIONS_ARB                               34823
#endif

#ifndef GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB
#define GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB                        34824
#endif

#ifndef GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB
#define GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB                        34825
#endif

#ifndef GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB
#define GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB                        34826
#endif

#ifndef GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB
#define GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB                           34827
#endif

#ifndef GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB
#define GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB                           34828
#endif

#ifndef GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB
#define GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB                           34829
#endif

#ifndef GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB
#define GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB                    34830
#endif

#ifndef GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB
#define GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB                    34831
#endif

#ifndef GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB
#define GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB                    34832
#endif

#ifndef GL_PROGRAM_STRING_ARB
#define GL_PROGRAM_STRING_ARB                                         34344
#endif

#ifndef GL_PROGRAM_ERROR_POSITION_ARB
#define GL_PROGRAM_ERROR_POSITION_ARB                                 34379
#endif

#ifndef GL_CURRENT_MATRIX_ARB
#define GL_CURRENT_MATRIX_ARB                                         34369
#endif

#ifndef GL_TRANSPOSE_CURRENT_MATRIX_ARB
#define GL_TRANSPOSE_CURRENT_MATRIX_ARB                               34999
#endif

#ifndef GL_CURRENT_MATRIX_STACK_DEPTH_ARB
#define GL_CURRENT_MATRIX_STACK_DEPTH_ARB                             34368
#endif

#ifndef GL_MAX_PROGRAM_MATRICES_ARB
#define GL_MAX_PROGRAM_MATRICES_ARB                                   34351
#endif

#ifndef GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB
#define GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB                         34350
#endif

#ifndef GL_MAX_TEXTURE_COORDS_ARB
#define GL_MAX_TEXTURE_COORDS_ARB                                     34929
#endif

#ifndef GL_MAX_TEXTURE_IMAGE_UNITS_ARB
#define GL_MAX_TEXTURE_IMAGE_UNITS_ARB                                34930
#endif

#ifndef GL_PROGRAM_ERROR_STRING_ARB
#define GL_PROGRAM_ERROR_STRING_ARB                                   34932
#endif

#ifndef GL_MATRIX0_ARB
#define GL_MATRIX0_ARB                                                35008
#endif

#ifndef GL_MATRIX1_ARB
#define GL_MATRIX1_ARB                                                35009
#endif

#ifndef GL_MATRIX2_ARB
#define GL_MATRIX2_ARB                                                35010
#endif

#ifndef GL_MATRIX3_ARB
#define GL_MATRIX3_ARB                                                35011
#endif

#ifndef GL_MATRIX4_ARB
#define GL_MATRIX4_ARB                                                35012
#endif

#ifndef GL_MATRIX5_ARB
#define GL_MATRIX5_ARB                                                35013
#endif

#ifndef GL_MATRIX6_ARB
#define GL_MATRIX6_ARB                                                35014
#endif

#ifndef GL_MATRIX7_ARB
#define GL_MATRIX7_ARB                                                35015
#endif

#ifndef GL_MATRIX8_ARB
#define GL_MATRIX8_ARB                                                35016
#endif

#ifndef GL_MATRIX9_ARB
#define GL_MATRIX9_ARB                                                35017
#endif

#ifndef GL_MATRIX10_ARB
#define GL_MATRIX10_ARB                                               35018
#endif

#ifndef GL_MATRIX11_ARB
#define GL_MATRIX11_ARB                                               35019
#endif

#ifndef GL_MATRIX12_ARB
#define GL_MATRIX12_ARB                                               35020
#endif

#ifndef GL_MATRIX13_ARB
#define GL_MATRIX13_ARB                                               35021
#endif

#ifndef GL_MATRIX14_ARB
#define GL_MATRIX14_ARB                                               35022
#endif

#ifndef GL_MATRIX15_ARB
#define GL_MATRIX15_ARB                                               35023
#endif

#ifndef GL_MATRIX16_ARB
#define GL_MATRIX16_ARB                                               35024
#endif

#ifndef GL_MATRIX17_ARB
#define GL_MATRIX17_ARB                                               35025
#endif

#ifndef GL_MATRIX18_ARB
#define GL_MATRIX18_ARB                                               35026
#endif

#ifndef GL_MATRIX19_ARB
#define GL_MATRIX19_ARB                                               35027
#endif

#ifndef GL_MATRIX20_ARB
#define GL_MATRIX20_ARB                                               35028
#endif

#ifndef GL_MATRIX21_ARB
#define GL_MATRIX21_ARB                                               35029
#endif

#ifndef GL_MATRIX22_ARB
#define GL_MATRIX22_ARB                                               35030
#endif

#ifndef GL_MATRIX23_ARB
#define GL_MATRIX23_ARB                                               35031
#endif

#ifndef GL_MATRIX24_ARB
#define GL_MATRIX24_ARB                                               35032
#endif

#ifndef GL_MATRIX25_ARB
#define GL_MATRIX25_ARB                                               35033
#endif

#ifndef GL_MATRIX26_ARB
#define GL_MATRIX26_ARB                                               35034
#endif

#ifndef GL_MATRIX27_ARB
#define GL_MATRIX27_ARB                                               35035
#endif

#ifndef GL_MATRIX28_ARB
#define GL_MATRIX28_ARB                                               35036
#endif

#ifndef GL_MATRIX29_ARB
#define GL_MATRIX29_ARB                                               35037
#endif

#ifndef GL_MATRIX30_ARB
#define GL_MATRIX30_ARB                                               35038
#endif

#ifndef GL_MATRIX31_ARB
#define GL_MATRIX31_ARB                                               35039
#endif



// GL_ATI_text_fragment_shader
#ifndef GL_TEXT_FRAGMENT_SHADER_ATI
#define GL_TEXT_FRAGMENT_SHADER_ATI                                   33280
#endif



// GL_APPLE_client_storage
#ifndef GL_UNPACK_CLIENT_STORAGE_APPLE
#define GL_UNPACK_CLIENT_STORAGE_APPLE                                34226
#endif



// GL_APPLE_element_array
#ifndef GL_ELEMENT_ARRAY_APPLE
#define GL_ELEMENT_ARRAY_APPLE                                        34664
#endif

#ifndef GL_ELEMENT_ARRAY_TYPE_APPLE
#define GL_ELEMENT_ARRAY_TYPE_APPLE                                   34665
#endif

#ifndef GL_ELEMENT_ARRAY_POINTER_APPLE
#define GL_ELEMENT_ARRAY_POINTER_APPLE                                34666
#endif


typedef GLvoid (csAPIENTRY* csGLELEMENTPOINTERAPPLE) (GLenum type, const GLvoid* pointer);
typedef GLvoid (csAPIENTRY* csGLDRAWELEMENTARRAYAPPLE) (GLenum mode, GLint first, GLsizei count);
typedef GLvoid (csAPIENTRY* csGLDRAWRANGEELEMENTARRAYAPPLE) (GLenum mode, GLuint start, GLuint end, GLint first, GLsizei count);
typedef GLvoid (csAPIENTRY* csGLMULTIDRAWELEMENTARRAYAPPLE) (GLenum mode, const GLint* first, const GLsizei* count, GLsizei primcount);
typedef GLvoid (csAPIENTRY* csGLMULTIDRAWRANGEELEMENTARRAYAPPLE) (GLenum mode, GLuint start, GLuint end, const GLint* first, const GLsizei* count, GLsizei primcount);

// GL_APPLE_fence
#ifndef GL_DRAW_PIXELS_APPLE
#define GL_DRAW_PIXELS_APPLE                                          35338
#endif

#ifndef GL_FENCE_APPLE
#define GL_FENCE_APPLE                                                35339
#endif


typedef GLvoid (csAPIENTRY* csGLGENFENCESAPPLE) (GLsizei n, GLuint* fences);
typedef GLvoid (csAPIENTRY* csGLDELETEFENCESAPPLE) (GLsizei n, const GLuint* fences);
typedef GLvoid (csAPIENTRY* csGLSETFENCEAPPLE) (GLuint fence);
typedef GLboolean (csAPIENTRY* csGLISFENCEAPPLE) (GLuint fence);
typedef GLboolean (csAPIENTRY* csGLTESTFENCEAPPLE) (GLuint fence);
typedef GLvoid (csAPIENTRY* csGLFINISHFENCEAPPLE) (GLuint fence);
typedef GLboolean (csAPIENTRY* csGLTESTOBJECTAPPLE) (GLenum object, GLuint name);
typedef GLvoid (csAPIENTRY* csGLFINISHOBJECTAPPLE) (GLenum object, GLint name);

// GL_APPLE_vertex_array_object
#ifndef GL_VERTEX_ARRAY_BINDING_APPLE
#define GL_VERTEX_ARRAY_BINDING_APPLE                                 34229
#endif


typedef GLvoid (csAPIENTRY* csGLBINDVERTEXARRAYAPPLE) (GLuint array);
typedef GLvoid (csAPIENTRY* csGLDELETEVERTEXARRAYSAPPLE) (GLsizei n, const GLuint* arrays);
typedef GLvoid (csAPIENTRY* csGLGENVERTEXARRAYSAPPLE) (GLsizei n, const GLuint* arrays);
typedef GLboolean (csAPIENTRY* csGLISVERTEXARRAYAPPLE) (GLuint array);

// GL_APPLE_vertex_array_range
#ifndef GL_VERTEX_ARRAY_RANGE_APPLE
#define GL_VERTEX_ARRAY_RANGE_APPLE                                   34077
#endif

#ifndef GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE
#define GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE                            34078
#endif

#ifndef GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_APPLE
#define GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_APPLE                       34080
#endif

#ifndef GL_VERTEX_ARRAY_RANGE_POINTER_APPLE
#define GL_VERTEX_ARRAY_RANGE_POINTER_APPLE                           34081
#endif

#ifndef GL_VERTEX_ARRAY_STORAGE_HINT_APPLE
#define GL_VERTEX_ARRAY_STORAGE_HINT_APPLE                            34079
#endif

#ifndef GL_STORAGE_CACHED_APPLE
#define GL_STORAGE_CACHED_APPLE                                       34238
#endif

#ifndef GL_STORAGE_SHARED_APPLE
#define GL_STORAGE_SHARED_APPLE                                       34239
#endif


typedef GLvoid (csAPIENTRY* csGLVERTEXARRAYRANGEAPPLE) (GLsizei length, GLvoid* pointer);
typedef GLvoid (csAPIENTRY* csGLFLUSHVERTEXARRAYRANGEAPPLE) (GLsizei length, GLvoid* pointer);
typedef GLvoid (csAPIENTRY* csGLVERTEXARRAYPARAMETERIAPPLE) (GLenum pname, GLint param);

// WGL_ARB_pixel_format
#ifdef _WIN32
#ifndef WGL_NUMBER_PIXEL_FORMATS_ARB
#define WGL_NUMBER_PIXEL_FORMATS_ARB                                   8192
#endif

#ifndef WGL_DRAW_TO_WINDOW_ARB
#define WGL_DRAW_TO_WINDOW_ARB                                         8193
#endif

#ifndef WGL_DRAW_TO_BITMAP_ARB
#define WGL_DRAW_TO_BITMAP_ARB                                         8194
#endif

#ifndef WGL_ACCELERATION_ARB
#define WGL_ACCELERATION_ARB                                           8195
#endif

#ifndef WGL_NEED_PALETTE_ARB
#define WGL_NEED_PALETTE_ARB                                           8196
#endif

#ifndef WGL_NEED_SYSTEM_PALETTE_ARB
#define WGL_NEED_SYSTEM_PALETTE_ARB                                    8197
#endif

#ifndef WGL_SWAP_LAYER_BUFFERS_ARB
#define WGL_SWAP_LAYER_BUFFERS_ARB                                     8198
#endif

#ifndef WGL_SWAP_METHOD_ARB
#define WGL_SWAP_METHOD_ARB                                            8199
#endif

#ifndef WGL_NUMBER_OVERLAYS_ARB
#define WGL_NUMBER_OVERLAYS_ARB                                        8200
#endif

#ifndef WGL_NUMBER_UNDERLAYS_ARB
#define WGL_NUMBER_UNDERLAYS_ARB                                       8201
#endif

#ifndef WGL_TRANSPARENT_ARB
#define WGL_TRANSPARENT_ARB                                            8202
#endif

#ifndef WGL_TRANSPARENT_RED_VALUE_ARB
#define WGL_TRANSPARENT_RED_VALUE_ARB                                  8247
#endif

#ifndef WGL_TRANSPARENT_GREEN_VALUE_ARB
#define WGL_TRANSPARENT_GREEN_VALUE_ARB                                8248
#endif

#ifndef WGL_TRANSPARENT_BLUE_VALUE_ARB
#define WGL_TRANSPARENT_BLUE_VALUE_ARB                                 8249
#endif

#ifndef WGL_TRANSPARENT_ALPHA_VALUE_ARB
#define WGL_TRANSPARENT_ALPHA_VALUE_ARB                                8250
#endif

#ifndef WGL_TRANSPARENT_INDEX_VALUE_ARB
#define WGL_TRANSPARENT_INDEX_VALUE_ARB                                8251
#endif

#ifndef WGL_SHARE_DEPTH_ARB
#define WGL_SHARE_DEPTH_ARB                                            8204
#endif

#ifndef WGL_SHARE_STENCIL_ARB
#define WGL_SHARE_STENCIL_ARB                                          8205
#endif

#ifndef WGL_SHARE_ACCUM_ARB
#define WGL_SHARE_ACCUM_ARB                                            8206
#endif

#ifndef WGL_SUPPORT_GDI_ARB
#define WGL_SUPPORT_GDI_ARB                                            8207
#endif

#ifndef WGL_SUPPORT_OPENGL_ARB
#define WGL_SUPPORT_OPENGL_ARB                                         8208
#endif

#ifndef WGL_DOUBLE_BUFFER_ARB
#define WGL_DOUBLE_BUFFER_ARB                                          8209
#endif

#ifndef WGL_STEREO_ARB
#define WGL_STEREO_ARB                                                 8210
#endif

#ifndef WGL_PIXEL_TYPE_ARB
#define WGL_PIXEL_TYPE_ARB                                             8211
#endif

#ifndef WGL_COLOR_BITS_ARB
#define WGL_COLOR_BITS_ARB                                             8212
#endif

#ifndef WGL_RED_BITS_ARB
#define WGL_RED_BITS_ARB                                               8213
#endif

#ifndef WGL_RED_SHIFT_ARB
#define WGL_RED_SHIFT_ARB                                              8214
#endif

#ifndef WGL_GREEN_BITS_ARB
#define WGL_GREEN_BITS_ARB                                             8215
#endif

#ifndef WGL_GREEN_SHIFT_ARB
#define WGL_GREEN_SHIFT_ARB                                            8216
#endif

#ifndef WGL_BLUE_BITS_ARB
#define WGL_BLUE_BITS_ARB                                              8217
#endif

#ifndef WGL_BLUE_SHIFT_ARB
#define WGL_BLUE_SHIFT_ARB                                             8218
#endif

#ifndef WGL_ALPHA_BITS_ARB
#define WGL_ALPHA_BITS_ARB                                             8219
#endif

#ifndef WGL_ALPHA_SHIFT_ARB
#define WGL_ALPHA_SHIFT_ARB                                            8220
#endif

#ifndef WGL_ACCUM_BITS_ARB
#define WGL_ACCUM_BITS_ARB                                             8221
#endif

#ifndef WGL_ACCUM_RED_BITS_ARB
#define WGL_ACCUM_RED_BITS_ARB                                         8222
#endif

#ifndef WGL_ACCUM_GREEN_BITS_ARB
#define WGL_ACCUM_GREEN_BITS_ARB                                       8223
#endif

#ifndef WGL_ACCUM_BLUE_BITS_ARB
#define WGL_ACCUM_BLUE_BITS_ARB                                        8224
#endif

#ifndef WGL_ACCUM_ALPHA_BITS_ARB
#define WGL_ACCUM_ALPHA_BITS_ARB                                       8225
#endif

#ifndef WGL_DEPTH_BITS_ARB
#define WGL_DEPTH_BITS_ARB                                             8226
#endif

#ifndef WGL_STENCIL_BITS_ARB
#define WGL_STENCIL_BITS_ARB                                           8227
#endif

#ifndef WGL_AUX_BUFFERS_ARB
#define WGL_AUX_BUFFERS_ARB                                            8228
#endif

#ifndef WGL_NO_ACCELERATION_ARB
#define WGL_NO_ACCELERATION_ARB                                        8229
#endif

#ifndef WGL_GENERIC_ACCELERATION_ARB
#define WGL_GENERIC_ACCELERATION_ARB                                   8230
#endif

#ifndef WGL_FULL_ACCELERATION_ARB
#define WGL_FULL_ACCELERATION_ARB                                      8231
#endif

#ifndef WGL_SWAP_EXCHANGE_ARB
#define WGL_SWAP_EXCHANGE_ARB                                          8232
#endif

#ifndef WGL_SWAP_COPY_ARB
#define WGL_SWAP_COPY_ARB                                              8233
#endif

#ifndef WGL_SWAP_UNDEFINED_ARB
#define WGL_SWAP_UNDEFINED_ARB                                         8234
#endif

#ifndef WGL_TYPE_RGBA_ARB
#define WGL_TYPE_RGBA_ARB                                              8235
#endif

#ifndef WGL_TYPE_COLORINDEX_ARB
#define WGL_TYPE_COLORINDEX_ARB                                        8236
#endif


typedef BOOL (csAPIENTRY* csWGLGETPIXELFORMATATTRIBIVARB) (HDC hdc, GLint iPixelFormat, GLint iLayerPlane, GLuint nAttributes, const GLint* piAttributes, GLint* piValues);
typedef BOOL (csAPIENTRY* csWGLGETPIXELFORMATATTRIBFVARB) (HDC hdc, GLint iPixelFormat, GLint iLayerPlane, GLuint nAttributes, const GLint* piAttributes, GLfloat* pfValues);
typedef BOOL (csAPIENTRY* csWGLCHOOSEPIXELFORMATARB) (HDC hdc, const GLint* piAttribIList, const GLfloat* pfAttribFList, GLuint nMaxFormats, GLint* piFormats, GLuint* nNumFormats);

#endif

// WGL_ARB_make_current_read
#ifdef _WIN32
#ifndef WGL_ERROR_INVALID_PIXEL_TYPE_ARB
#define WGL_ERROR_INVALID_PIXEL_TYPE_ARB                               8259
#endif

#ifndef WGL_ERROR_INCOMPATIBLE_DEVICE_CONTEXTS_ARB
#define WGL_ERROR_INCOMPATIBLE_DEVICE_CONTEXTS_ARB                     8276
#endif


typedef BOOL (csAPIENTRY* csWGLMAKECONTEXTCURRENTARB) (HDC hDrawDC, HDC hReadDC, HGLRC hglrc);
typedef HDC (csAPIENTRY* csWGLGETCURRENTREADDCARB) ();

#endif

// WGL_ARB_pbuffer
#ifdef _WIN32
#ifndef WGL_DRAW_TO_PBUFFER_ARB
#define WGL_DRAW_TO_PBUFFER_ARB                                        8237
#endif

#ifndef WGL_DRAW_TO_PBUFFER_ARB
#define WGL_DRAW_TO_PBUFFER_ARB                                        8237
#endif

#ifndef WGL_MAX_PBUFFER_PIXELS_ARB
#define WGL_MAX_PBUFFER_PIXELS_ARB                                     8238
#endif

#ifndef WGL_MAX_PBUFFER_WIDTH_ARB
#define WGL_MAX_PBUFFER_WIDTH_ARB                                      8239
#endif

#ifndef WGL_MAX_PBUFFER_HEIGHT_ARB
#define WGL_MAX_PBUFFER_HEIGHT_ARB                                     8240
#endif

#ifndef WGL_PBUFFER_LARGEST_ARB
#define WGL_PBUFFER_LARGEST_ARB                                        8243
#endif

#ifndef WGL_PBUFFER_WIDTH_ARB
#define WGL_PBUFFER_WIDTH_ARB                                          8244
#endif

#ifndef WGL_PBUFFER_HEIGHT_ARB
#define WGL_PBUFFER_HEIGHT_ARB                                         8245
#endif

#ifndef WGL_PBUFFER_LOST_ARB
#define WGL_PBUFFER_LOST_ARB                                           8246
#endif


typedef HANDLE (csAPIENTRY* csWGLCREATEPBUFFERARB) (HDC hDC, GLint iPixelFormat, GLint iWidth, GLint iHeight, const GLint* piAttribList);
typedef HDC (csAPIENTRY* csWGLGETPBUFFERDCARB) (HANDLE hPbuffer);
typedef GLint (csAPIENTRY* csWGLRELEASEPBUFFERDCARB) (HANDLE hPbuffer, HDC hDC);
typedef BOOL (csAPIENTRY* csWGLDESTROYPBUFFERARB) (HANDLE hPbuffer);
typedef BOOL (csAPIENTRY* csWGLQUERYPBUFFERARB) (HANDLE hPbuffer, GLint iAttribute, GLint* piValue);

#endif

// WGL_EXT_swap_control
#ifdef _WIN32

typedef BOOL (csAPIENTRY* csWGLSWAPINTERVALEXT) (GLint interval);
typedef GLint (csAPIENTRY* csWGLGETSWAPINTERVALEXT) ();

#endif

// WGL_ARB_render_texture
#ifdef _WIN32
#ifndef WGL_BIND_TO_TEXTURE_RGB_ARB
#define WGL_BIND_TO_TEXTURE_RGB_ARB                                    8304
#endif

#ifndef WGL_BIND_TO_TEXTURE_RGBA_ARB
#define WGL_BIND_TO_TEXTURE_RGBA_ARB                                   8305
#endif

#ifndef WGL_TEXTURE_FORMAT_ARB
#define WGL_TEXTURE_FORMAT_ARB                                         8306
#endif

#ifndef WGL_TEXTURE_TARGET_ARB
#define WGL_TEXTURE_TARGET_ARB                                         8307
#endif

#ifndef WGL_MIPMAP_TEXTURE_ARB
#define WGL_MIPMAP_TEXTURE_ARB                                         8308
#endif

#ifndef WGL_TEXTURE_RGB_ARB
#define WGL_TEXTURE_RGB_ARB                                            8309
#endif

#ifndef WGL_TEXTURE_RGBA_ARB
#define WGL_TEXTURE_RGBA_ARB                                           8310
#endif

#ifndef WGL_NO_TEXTURE_ARB
#define WGL_NO_TEXTURE_ARB                                             8311
#endif

#ifndef WGL_TEXTURE_CUBE_MAP_ARB
#define WGL_TEXTURE_CUBE_MAP_ARB                                       8312
#endif

#ifndef WGL_TEXTURE_1D_ARB
#define WGL_TEXTURE_1D_ARB                                             8313
#endif

#ifndef WGL_TEXTURE_2D_ARB
#define WGL_TEXTURE_2D_ARB                                             8314
#endif

#ifndef WGL_NO_TEXTURE_ARB
#define WGL_NO_TEXTURE_ARB                                             8311
#endif

#ifndef WGL_MIPMAP_LEVEL_ARB
#define WGL_MIPMAP_LEVEL_ARB                                           8315
#endif

#ifndef WGL_CUBE_MAP_FACE_ARB
#define WGL_CUBE_MAP_FACE_ARB                                          8316
#endif

#ifndef WGL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB
#define WGL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB                            8317
#endif

#ifndef WGL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB
#define WGL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB                            8318
#endif

#ifndef WGL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB
#define WGL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB                            8319
#endif

#ifndef WGL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB
#define WGL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB                            8320
#endif

#ifndef WGL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB
#define WGL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB                            8321
#endif

#ifndef WGL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB
#define WGL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB                            8322
#endif

#ifndef WGL_FRONT_LEFT_ARB
#define WGL_FRONT_LEFT_ARB                                             8323
#endif

#ifndef WGL_FRONT_RIGHT_ARB
#define WGL_FRONT_RIGHT_ARB                                            8324
#endif

#ifndef WGL_BACK_LEFT_ARB
#define WGL_BACK_LEFT_ARB                                              8325
#endif

#ifndef WGL_BACK_RIGHT_ARB
#define WGL_BACK_RIGHT_ARB                                             8326
#endif

#ifndef WGL_AUX0_ARB
#define WGL_AUX0_ARB                                                   8327
#endif

#ifndef WGL_AUX1_ARB
#define WGL_AUX1_ARB                                                   8328
#endif

#ifndef WGL_AUX2_ARB
#define WGL_AUX2_ARB                                                   8329
#endif

#ifndef WGL_AUX3_ARB
#define WGL_AUX3_ARB                                                   8330
#endif

#ifndef WGL_AUX4_ARB
#define WGL_AUX4_ARB                                                   8331
#endif

#ifndef WGL_AUX5_ARB
#define WGL_AUX5_ARB                                                   8332
#endif

#ifndef WGL_AUX6_ARB
#define WGL_AUX6_ARB                                                   8333
#endif

#ifndef WGL_AUX7_ARB
#define WGL_AUX7_ARB                                                   8334
#endif

#ifndef WGL_AUX8_ARB
#define WGL_AUX8_ARB                                                   8335
#endif

#ifndef WGL_AUX9_ARB
#define WGL_AUX9_ARB                                                   8336
#endif


typedef BOOL (csAPIENTRY* csWGLBINDTEXIMAGEARB) (HANDLE hPbuffer, GLint iBuffer);
typedef BOOL (csAPIENTRY* csWGLRELEASETEXIMAGEARB) (HANDLE hPbuffer, GLint iBuffer);
typedef BOOL (csAPIENTRY* csWGLSETPBUFFERATTRIBARB) (HANDLE hPbuffer, const GLint* piAttribList);

#endif

// WGL_EXT_extensions_string
#ifdef _WIN32

typedef char* (csAPIENTRY* csWGLGETEXTENSIONSSTRINGEXT) ();

#endif

// WGL_EXT_make_current_read
#ifdef _WIN32

typedef BOOL (csAPIENTRY* csWGLMAKECONTEXTCURRENTEXT) (HDC hDrawDC, HDC hReadDC, HGLRC hglrc);
typedef HDC (csAPIENTRY* csWGLGETCURRENTREADDCEXT) ();

#endif

// WGL_EXT_pbuffer
#ifdef _WIN32
#ifndef WGL_DRAW_TO_PBUFFER_EXT
#define WGL_DRAW_TO_PBUFFER_EXT                                        8237
#endif

#ifndef WGL_MAX_PBUFFER_PIXELS_EXT
#define WGL_MAX_PBUFFER_PIXELS_EXT                                     8238
#endif

#ifndef WGL_MAX_PBUFFER_WIDTH_EXT
#define WGL_MAX_PBUFFER_WIDTH_EXT                                      8239
#endif

#ifndef WGL_MAX_PBUFFER_HEIGHT_EXT
#define WGL_MAX_PBUFFER_HEIGHT_EXT                                     8240
#endif

#ifndef WGL_OPTIMAL_PBUFFER_WIDTH_EXT
#define WGL_OPTIMAL_PBUFFER_WIDTH_EXT                                  8241
#endif

#ifndef WGL_OPTIMAL_PBUFFER_HEIGHT_EXT
#define WGL_OPTIMAL_PBUFFER_HEIGHT_EXT                                 8242
#endif

#ifndef WGL_PBUFFER_LARGEST_EXT
#define WGL_PBUFFER_LARGEST_EXT                                        8243
#endif

#ifndef WGL_PBUFFER_WIDTH_EXT
#define WGL_PBUFFER_WIDTH_EXT                                          8244
#endif

#ifndef WGL_PBUFFER_HEIGHT_EXT
#define WGL_PBUFFER_HEIGHT_EXT                                         8245
#endif


typedef HANDLE (csAPIENTRY* csWGLCREATEPBUFFEREXT) (HDC hDC, GLint iPixelFormat, GLint iWidth, GLint iHeight, const GLint* piAttribList);
typedef HDC (csAPIENTRY* csWGLGETPBUFFERDCEXT) (HANDLE hPbuffer);
typedef GLint (csAPIENTRY* csWGLRELEASEPBUFFERDCEXT) (HANDLE hPbuffer, HDC hDC);
typedef BOOL (csAPIENTRY* csWGLDESTROYPBUFFEREXT) (HANDLE hPbuffer);
typedef BOOL (csAPIENTRY* csWGLQUERYPBUFFEREXT) (HANDLE hPbuffer, GLint iAttribute, GLint* piValue);

#endif

// WGL_EXT_pixel_format
#ifdef _WIN32
#ifndef WGL_NUMBER_PIXEL_FORMATS_EXT
#define WGL_NUMBER_PIXEL_FORMATS_EXT                                   8192
#endif

#ifndef WGL_DRAW_TO_WINDOW_EXT
#define WGL_DRAW_TO_WINDOW_EXT                                         8193
#endif

#ifndef WGL_DRAW_TO_BITMAP_EXT
#define WGL_DRAW_TO_BITMAP_EXT                                         8194
#endif

#ifndef WGL_ACCELERATION_EXT
#define WGL_ACCELERATION_EXT                                           8195
#endif

#ifndef WGL_NEED_PALETTE_EXT
#define WGL_NEED_PALETTE_EXT                                           8196
#endif

#ifndef WGL_NEED_SYSTEM_PALETTE_EXT
#define WGL_NEED_SYSTEM_PALETTE_EXT                                    8197
#endif

#ifndef WGL_SWAP_LAYER_BUFFERS_EXT
#define WGL_SWAP_LAYER_BUFFERS_EXT                                     8198
#endif

#ifndef WGL_SWAP_METHOD_EXT
#define WGL_SWAP_METHOD_EXT                                            8199
#endif

#ifndef WGL_NUMBER_OVERLAYS_EXT
#define WGL_NUMBER_OVERLAYS_EXT                                        8200
#endif

#ifndef WGL_NUMBER_UNDERLAYS_EXT
#define WGL_NUMBER_UNDERLAYS_EXT                                       8201
#endif

#ifndef WGL_TRANSPARENT_EXT
#define WGL_TRANSPARENT_EXT                                            8202
#endif

#ifndef WGL_TRANSPARENT_VALUE_EXT
#define WGL_TRANSPARENT_VALUE_EXT                                      8203
#endif

#ifndef WGL_SHARE_DEPTH_EXT
#define WGL_SHARE_DEPTH_EXT                                            8204
#endif

#ifndef WGL_SHARE_STENCIL_EXT
#define WGL_SHARE_STENCIL_EXT                                          8205
#endif

#ifndef WGL_SHARE_ACCUM_EXT
#define WGL_SHARE_ACCUM_EXT                                            8206
#endif

#ifndef WGL_SUPPORT_GDI_EXT
#define WGL_SUPPORT_GDI_EXT                                            8207
#endif

#ifndef WGL_SUPPORT_OPENGL_EXT
#define WGL_SUPPORT_OPENGL_EXT                                         8208
#endif

#ifndef WGL_DOUBLE_BUFFER_EXT
#define WGL_DOUBLE_BUFFER_EXT                                          8209
#endif

#ifndef WGL_STEREO_EXT
#define WGL_STEREO_EXT                                                 8210
#endif

#ifndef WGL_PIXEL_TYPE_EXT
#define WGL_PIXEL_TYPE_EXT                                             8211
#endif

#ifndef WGL_COLOR_BITS_EXT
#define WGL_COLOR_BITS_EXT                                             8212
#endif

#ifndef WGL_RED_BITS_EXT
#define WGL_RED_BITS_EXT                                               8213
#endif

#ifndef WGL_RED_SHIFT_EXT
#define WGL_RED_SHIFT_EXT                                              8214
#endif

#ifndef WGL_GREEN_BITS_EXT
#define WGL_GREEN_BITS_EXT                                             8215
#endif

#ifndef WGL_GREEN_SHIFT_EXT
#define WGL_GREEN_SHIFT_EXT                                            8216
#endif

#ifndef WGL_BLUE_BITS_EXT
#define WGL_BLUE_BITS_EXT                                              8217
#endif

#ifndef WGL_BLUE_SHIFT_EXT
#define WGL_BLUE_SHIFT_EXT                                             8218
#endif

#ifndef WGL_ALPHA_BITS_EXT
#define WGL_ALPHA_BITS_EXT                                             8219
#endif

#ifndef WGL_ALPHA_SHIFT_EXT
#define WGL_ALPHA_SHIFT_EXT                                            8220
#endif

#ifndef WGL_ACCUM_BITS_EXT
#define WGL_ACCUM_BITS_EXT                                             8221
#endif

#ifndef WGL_ACCUM_RED_BITS_EXT
#define WGL_ACCUM_RED_BITS_EXT                                         8222
#endif

#ifndef WGL_ACCUM_GREEN_BITS_EXT
#define WGL_ACCUM_GREEN_BITS_EXT                                       8223
#endif

#ifndef WGL_ACCUM_BLUE_BITS_EXT
#define WGL_ACCUM_BLUE_BITS_EXT                                        8224
#endif

#ifndef WGL_ACCUM_ALPHA_BITS_EXT
#define WGL_ACCUM_ALPHA_BITS_EXT                                       8225
#endif

#ifndef WGL_DEPTH_BITS_EXT
#define WGL_DEPTH_BITS_EXT                                             8226
#endif

#ifndef WGL_STENCIL_BITS_EXT
#define WGL_STENCIL_BITS_EXT                                           8227
#endif

#ifndef WGL_AUX_BUFFERS_EXT
#define WGL_AUX_BUFFERS_EXT                                            8228
#endif

#ifndef WGL_NO_ACCELERATION_EXT
#define WGL_NO_ACCELERATION_EXT                                        8229
#endif

#ifndef WGL_GENERIC_ACCELERATION_EXT
#define WGL_GENERIC_ACCELERATION_EXT                                   8230
#endif

#ifndef WGL_FULL_ACCELERATION_EXT
#define WGL_FULL_ACCELERATION_EXT                                      8231
#endif

#ifndef WGL_SWAP_EXCHANGE_EXT
#define WGL_SWAP_EXCHANGE_EXT                                          8232
#endif

#ifndef WGL_SWAP_COPY_EXT
#define WGL_SWAP_COPY_EXT                                              8233
#endif

#ifndef WGL_SWAP_UNDEFINED_EXT
#define WGL_SWAP_UNDEFINED_EXT                                         8234
#endif

#ifndef WGL_TYPE_RGBA_EXT
#define WGL_TYPE_RGBA_EXT                                              8235
#endif

#ifndef WGL_TYPE_COLORINDEX_EXT
#define WGL_TYPE_COLORINDEX_EXT                                        8236
#endif


typedef BOOL (csAPIENTRY* csWGLGETPIXELFORMATATTRIBIVEXT) (HDC hdc, GLint iPixelFormat, GLint iLayerPlane, GLuint nAttributes, GLint* piAttributes, GLint* piValues);
typedef BOOL (csAPIENTRY* csWGLGETPIXELFORMATATTRIBFVEXT) (HDC hdc, GLint iPixelFormat, GLint iLayerPlane, GLuint nAttributes, GLint* piAttributes, GLfloat* pfValues);
typedef BOOL (csAPIENTRY* csWGLCHOOSEPIXELFORMATEXT) (HDC hdc, const GLint* piAttribIList, const GLfloat* pfAttribFList, GLuint nMaxFormats, GLint* piFormats, GLuint* nNumFormats);

#endif

// WGL_I3D_digital_video_control
#ifdef _WIN32
#ifndef WGL_DIGITAL_VIDEO_CURSOR_ALPHA_FRAMEBUFFER_I3D
#define WGL_DIGITAL_VIDEO_CURSOR_ALPHA_FRAMEBUFFER_I3D                 8272
#endif

#ifndef WGL_DIGITAL_VIDEO_CURSOR_ALPHA_VALUE_I3D
#define WGL_DIGITAL_VIDEO_CURSOR_ALPHA_VALUE_I3D                       8273
#endif

#ifndef WGL_DIGITAL_VIDEO_CURSOR_INCLUDED_I3D
#define WGL_DIGITAL_VIDEO_CURSOR_INCLUDED_I3D                          8274
#endif

#ifndef WGL_DIGITAL_VIDEO_GAMMA_CORRECTED_I3D
#define WGL_DIGITAL_VIDEO_GAMMA_CORRECTED_I3D                          8275
#endif


typedef BOOL (csAPIENTRY* csWGLGETDIGITALVIDEOPARAMETERSI3D) (HDC hDC, GLint iAttribute, GLint* piValue);
typedef BOOL (csAPIENTRY* csWGLSETDIGITALVIDEOPARAMETERSI3D) (HDC hDC, GLint iAttribute, const GLint* piValue);

#endif

// WGL_I3D_gamma
#ifdef _WIN32
#ifndef WGL_GAMMA_TABLE_SIZE_I3D
#define WGL_GAMMA_TABLE_SIZE_I3D                                       8270
#endif

#ifndef WGL_GAMMA_EXCLUDE_DESKTOP_I3D
#define WGL_GAMMA_EXCLUDE_DESKTOP_I3D                                  8271
#endif

#ifndef WGL_GAMMA_EXCLUDE_DESKTOP_I3D
#define WGL_GAMMA_EXCLUDE_DESKTOP_I3D                                  8271
#endif


typedef BOOL (csAPIENTRY* csWGLGETGAMMATABLEPARAMETERSI3D) (HDC hDC, GLint iAttribute, GLint* piValue);
typedef BOOL (csAPIENTRY* csWGLSETGAMMATABLEPARAMETERSI3D) (HDC hDC, GLint iAttribute, const GLint* piValue);
typedef BOOL (csAPIENTRY* csWGLGETGAMMATABLEI3D) (HDC hDC, GLint iEntries, GLushort* puRed, GLushort* puGreen, GLushort* puBlue);
typedef BOOL (csAPIENTRY* csWGLSETGAMMATABLEI3D) (HDC hDC, GLint iEntries, const GLushort* puRed, const GLushort* puGreen, const GLushort* puBlue);

#endif

// WGL_I3D_genlock
#ifdef _WIN32
#ifndef WGL_GENLOCK_SOURCE_MULTIVIEW_I3D
#define WGL_GENLOCK_SOURCE_MULTIVIEW_I3D                               8260
#endif

#ifndef WGL_GENLOCK_SOURCE_EXTERNAL_SYNC_I3D
#define WGL_GENLOCK_SOURCE_EXTERNAL_SYNC_I3D                           8261
#endif

#ifndef WGL_GENLOCK_SOURCE_EXTERNAL_FIELD_I3D
#define WGL_GENLOCK_SOURCE_EXTERNAL_FIELD_I3D                          8262
#endif

#ifndef WGL_GENLOCK_SOURCE_EXTERNAL_TTL_I3D
#define WGL_GENLOCK_SOURCE_EXTERNAL_TTL_I3D                            8263
#endif

#ifndef WGL_GENLOCK_SOURCE_DIGITAL_SYNC_I3D
#define WGL_GENLOCK_SOURCE_DIGITAL_SYNC_I3D                            8264
#endif

#ifndef WGL_GENLOCK_SOURCE_DIGITAL_FIELD_I3D
#define WGL_GENLOCK_SOURCE_DIGITAL_FIELD_I3D                           8265
#endif

#ifndef WGL_GENLOCK_SOURCE_EDGE_FALLING_I3D
#define WGL_GENLOCK_SOURCE_EDGE_FALLING_I3D                            8266
#endif

#ifndef WGL_GENLOCK_SOURCE_EDGE_RISING_I3D
#define WGL_GENLOCK_SOURCE_EDGE_RISING_I3D                             8267
#endif

#ifndef WGL_GENLOCK_SOURCE_EDGE_BOTH_I3D
#define WGL_GENLOCK_SOURCE_EDGE_BOTH_I3D                               8268
#endif


typedef BOOL (csAPIENTRY* csWGLENABLEGENLOCKI3D) (HDC hDC);
typedef BOOL (csAPIENTRY* csWGLDISABLEGENLOCKI3D) (HDC hDC);
typedef BOOL (csAPIENTRY* csWGLISENABLEDGENLOCKI3D) (HDC hDC, BOOL* pFlag);
typedef BOOL (csAPIENTRY* csWGLGENLOCKSOURCEI3D) (HDC hDC, GLuint uSource);
typedef BOOL (csAPIENTRY* csWGLGETGENLOCKSOURCEI3D) (HDC hDC, GLuint* uSource);
typedef BOOL (csAPIENTRY* csWGLGENLOCKSOURCEEDGEI3D) (HDC hDC, GLuint uEdge);
typedef BOOL (csAPIENTRY* csWGLGETGENLOCKSOURCEEDGEI3D) (HDC hDC, GLuint* uEdge);
typedef BOOL (csAPIENTRY* csWGLGENLOCKSAMPLERATEI3D) (HDC hDC, GLuint uRate);
typedef BOOL (csAPIENTRY* csWGLGETGENLOCKSAMPLERATEI3D) (HDC hDC, GLuint* uRate);
typedef BOOL (csAPIENTRY* csWGLGENLOCKSOURCEDELAYI3D) (HDC hDC, GLuint uDelay);
typedef BOOL (csAPIENTRY* csWGLGETGENLOCKSOURCEDELAYI3D) (HDC hDC, GLuint* uDelay);
typedef BOOL (csAPIENTRY* csWGLQUERYGENLOCKMAXSOURCEDELAYI3D) (HDC hDC, GLuint* uMaxLineDelay, GLuint* uMaxPixelDelay);

#endif

// GL_ARB_matrix_palette
#ifndef GL_MATRIX_PALETTE_ARB
#define GL_MATRIX_PALETTE_ARB                                         34880
#endif

#ifndef GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB
#define GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB                         34881
#endif

#ifndef GL_MAX_PALETTE_MATRICES_ARB
#define GL_MAX_PALETTE_MATRICES_ARB                                   34882
#endif

#ifndef GL_CURRENT_PALETTE_MATRIX_ARB
#define GL_CURRENT_PALETTE_MATRIX_ARB                                 34883
#endif

#ifndef GL_MATRIX_INDEX_ARRAY_ARB
#define GL_MATRIX_INDEX_ARRAY_ARB                                     34884
#endif

#ifndef GL_CURRENT_MATRIX_INDEX_ARB
#define GL_CURRENT_MATRIX_INDEX_ARB                                   34885
#endif

#ifndef GL_MATRIX_INDEX_ARRAY_SIZE_ARB
#define GL_MATRIX_INDEX_ARRAY_SIZE_ARB                                34886
#endif

#ifndef GL_MATRIX_INDEX_ARRAY_TYPE_ARB
#define GL_MATRIX_INDEX_ARRAY_TYPE_ARB                                34887
#endif

#ifndef GL_MATRIX_INDEX_ARRAY_STRIDE_ARB
#define GL_MATRIX_INDEX_ARRAY_STRIDE_ARB                              34888
#endif

#ifndef GL_MATRIX_INDEX_ARRAY_POINTER_ARB
#define GL_MATRIX_INDEX_ARRAY_POINTER_ARB                             34889
#endif


typedef GLvoid (csAPIENTRY* csGLCURRENTPALETTEMATRIXARB) (GLint index);
typedef GLvoid (csAPIENTRY* csGLMATRIXINDEXUBVARB) (GLint size, GLubyte* indices);
typedef GLvoid (csAPIENTRY* csGLMATRIXINDEXUSVARB) (GLint size, GLushort* indices);
typedef GLvoid (csAPIENTRY* csGLMATRIXINDEXUIVARB) (GLint size, GLuint* indices);
typedef GLvoid (csAPIENTRY* csGLMATRIXINDEXPOINTERARB) (GLint size, GLenum type, GLsizei stride, GLvoid* pointer);

// GL_NV_element_array
#ifndef GL_ELEMENT_ARRAY_TYPE_NV
#define GL_ELEMENT_ARRAY_TYPE_NV                                      34665
#endif

#ifndef GL_ELEMENT_ARRAY_POINTER_NV
#define GL_ELEMENT_ARRAY_POINTER_NV                                   34666
#endif


typedef GLvoid (csAPIENTRY* csGLELEMENTPOINTERNV) (GLenum type, const GLvoid* pointer);
typedef GLvoid (csAPIENTRY* csGLDRAWELEMENTARRAYNV) (GLenum mode, GLint first, GLsizei count);
typedef GLvoid (csAPIENTRY* csGLDRAWRANGEELEMENTARRAYNV) (GLenum mode, GLuint start, GLuint end, GLint first, GLsizei count);
typedef GLvoid (csAPIENTRY* csGLMULTIDRAWELEMENTARRAYNV) (GLenum mode, const GLint* first, const GLsizei* count, GLsizei primcount);
typedef GLvoid (csAPIENTRY* csGLMULTIDRAWRANGEELEMENTARRAYNV) (GLenum mode, GLuint start, GLuint end, const GLint* first, const GLsizei* count, GLsizei primcount);

// GL_NV_float_buffer
#ifndef GL_FLOAT_R_NV
#define GL_FLOAT_R_NV                                                 34944
#endif

#ifndef GL_FLOAT_RG_NV
#define GL_FLOAT_RG_NV                                                34945
#endif

#ifndef GL_FLOAT_RGB_NV
#define GL_FLOAT_RGB_NV                                               34946
#endif

#ifndef GL_FLOAT_RGBA_NV
#define GL_FLOAT_RGBA_NV                                              34947
#endif

#ifndef GL_FLOAT_R16_NV
#define GL_FLOAT_R16_NV                                               34948
#endif

#ifndef GL_FLOAT_R32_NV
#define GL_FLOAT_R32_NV                                               34949
#endif

#ifndef GL_FLOAT_RG16_NV
#define GL_FLOAT_RG16_NV                                              34950
#endif

#ifndef GL_FLOAT_RG32_NV
#define GL_FLOAT_RG32_NV                                              34951
#endif

#ifndef GL_FLOAT_RGB16_NV
#define GL_FLOAT_RGB16_NV                                             34952
#endif

#ifndef GL_FLOAT_RGB32_NV
#define GL_FLOAT_RGB32_NV                                             34953
#endif

#ifndef GL_FLOAT_RGBA16_NV
#define GL_FLOAT_RGBA16_NV                                            34954
#endif

#ifndef GL_FLOAT_RGBA32_NV
#define GL_FLOAT_RGBA32_NV                                            34955
#endif

#ifndef GL_TEXTURE_FLOAT_COMPONENTS_NV
#define GL_TEXTURE_FLOAT_COMPONENTS_NV                                34956
#endif

#ifndef GL_FLOAT_CLEAR_COLOR_VALUE_NV
#define GL_FLOAT_CLEAR_COLOR_VALUE_NV                                 34957
#endif

#ifndef GL_FLOAT_RGBA_MODE_NV
#define GL_FLOAT_RGBA_MODE_NV                                         34958
#endif

#ifndef WGL_FLOAT_COMPONENTS_NV
#define WGL_FLOAT_COMPONENTS_NV                                        8368
#endif

#ifndef WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_R_NV
#define WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_R_NV                       8369
#endif

#ifndef WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RG_NV
#define WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RG_NV                      8370
#endif

#ifndef WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RGB_NV
#define WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RGB_NV                     8371
#endif

#ifndef WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RGBA_NV
#define WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RGBA_NV                    8372
#endif

#ifndef WGL_TEXTURE_FLOAT_R_NV
#define WGL_TEXTURE_FLOAT_R_NV                                         8373
#endif

#ifndef WGL_TEXTURE_FLOAT_RG_NV
#define WGL_TEXTURE_FLOAT_RG_NV                                        8374
#endif

#ifndef WGL_TEXTURE_FLOAT_RGB_NV
#define WGL_TEXTURE_FLOAT_RGB_NV                                       8375
#endif

#ifndef WGL_TEXTURE_FLOAT_RGBA_NV
#define WGL_TEXTURE_FLOAT_RGBA_NV                                      8376
#endif



// GL_NV_fragment_program
#ifndef GL_FRAGMENT_PROGRAM_NV
#define GL_FRAGMENT_PROGRAM_NV                                        34928
#endif

#ifndef GL_MAX_TEXTURE_COORDS_NV
#define GL_MAX_TEXTURE_COORDS_NV                                      34929
#endif

#ifndef GL_MAX_TEXTURE_IMAGE_UNITS_NV
#define GL_MAX_TEXTURE_IMAGE_UNITS_NV                                 34930
#endif

#ifndef GL_FRAGMENT_PROGRAM_BINDING_NV
#define GL_FRAGMENT_PROGRAM_BINDING_NV                                34931
#endif

#ifndef GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV
#define GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV                   34920
#endif

#ifndef GL_PROGRAM_ERROR_STRING_NV
#define GL_PROGRAM_ERROR_STRING_NV                                    34932
#endif


typedef GLvoid (csAPIENTRY* csGLPROGRAMNAMEDPARAMETER4FNV) (GLuint id, GLsizei len, const GLubyte* name, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef GLvoid (csAPIENTRY* csGLPROGRAMNAMEDPARAMETER4DNV) (GLuint id, GLsizei len, const GLubyte* name, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
typedef GLvoid (csAPIENTRY* csGLGETPROGRAMNAMEDPARAMETERFVNV) (GLuint id, GLsizei len, const GLubyte* name, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETPROGRAMNAMEDPARAMETERDVNV) (GLuint id, GLsizei len, const GLubyte* name, GLdouble* params);

// GL_NV_primitive_restart
#ifndef GL_PRIMITIVE_RESTART_NV
#define GL_PRIMITIVE_RESTART_NV                                       34136
#endif

#ifndef GL_PRIMITIVE_RESTART_INDEX_NV
#define GL_PRIMITIVE_RESTART_INDEX_NV                                 34137
#endif


typedef GLvoid (csAPIENTRY* csGLPRIMITIVERESTARTNV) ();
typedef GLvoid (csAPIENTRY* csGLPRIMITIVERESTARTINDEXNV) (GLuint index);

// GL_NV_vertex_program2


// GL_ARB_vertex_buffer_object
#ifndef GL_ARRAY_BUFFER_ARB
#define GL_ARRAY_BUFFER_ARB                                           34962
#endif

#ifndef GL_ELEMENT_ARRAY_BUFFER_ARB
#define GL_ELEMENT_ARRAY_BUFFER_ARB                                   34963
#endif

#ifndef GL_ARRAY_BUFFER_BINDING_ARB
#define GL_ARRAY_BUFFER_BINDING_ARB                                   34964
#endif

#ifndef GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB
#define GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB                           34965
#endif

#ifndef GL_VERTEX_ARRAY_BUFFER_BINDING_ARB
#define GL_VERTEX_ARRAY_BUFFER_BINDING_ARB                            34966
#endif

#ifndef GL_NORMAL_ARRAY_BUFFER_BINDING_ARB
#define GL_NORMAL_ARRAY_BUFFER_BINDING_ARB                            34967
#endif

#ifndef GL_COLOR_ARRAY_BUFFER_BINDING_ARB
#define GL_COLOR_ARRAY_BUFFER_BINDING_ARB                             34968
#endif

#ifndef GL_INDEX_ARRAY_BUFFER_BINDING_ARB
#define GL_INDEX_ARRAY_BUFFER_BINDING_ARB                             34969
#endif

#ifndef GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB
#define GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB                     34970
#endif

#ifndef GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB
#define GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB                         34971
#endif

#ifndef GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB
#define GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB                   34972
#endif

#ifndef GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB
#define GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB                    34973
#endif

#ifndef GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB
#define GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB                            34974
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB
#define GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB                     34975
#endif

#ifndef GL_STREAM_DRAW_ARB
#define GL_STREAM_DRAW_ARB                                            35040
#endif

#ifndef GL_STREAM_READ_ARB
#define GL_STREAM_READ_ARB                                            35041
#endif

#ifndef GL_STREAM_COPY_ARB
#define GL_STREAM_COPY_ARB                                            35042
#endif

#ifndef GL_STATIC_DRAW_ARB
#define GL_STATIC_DRAW_ARB                                            35044
#endif

#ifndef GL_STATIC_READ_ARB
#define GL_STATIC_READ_ARB                                            35045
#endif

#ifndef GL_STATIC_COPY_ARB
#define GL_STATIC_COPY_ARB                                            35046
#endif

#ifndef GL_DYNAMIC_DRAW_ARB
#define GL_DYNAMIC_DRAW_ARB                                           35048
#endif

#ifndef GL_DYNAMIC_READ_ARB
#define GL_DYNAMIC_READ_ARB                                           35049
#endif

#ifndef GL_DYNAMIC_COPY_ARB
#define GL_DYNAMIC_COPY_ARB                                           35050
#endif

#ifndef GL_READ_ONLY_ARB
#define GL_READ_ONLY_ARB                                              35000
#endif

#ifndef GL_WRITE_ONLY_ARB
#define GL_WRITE_ONLY_ARB                                             35001
#endif

#ifndef GL_READ_WRITE_ARB
#define GL_READ_WRITE_ARB                                             35002
#endif

#ifndef GL_BUFFER_SIZE_ARB
#define GL_BUFFER_SIZE_ARB                                            34660
#endif

#ifndef GL_BUFFER_USAGE_ARB
#define GL_BUFFER_USAGE_ARB                                           34661
#endif

#ifndef GL_BUFFER_ACCESS_ARB
#define GL_BUFFER_ACCESS_ARB                                          35003
#endif

#ifndef GL_BUFFER_MAPPED_ARB
#define GL_BUFFER_MAPPED_ARB                                          35004
#endif

#ifndef GL_BUFFER_MAP_POINTER_ARB
#define GL_BUFFER_MAP_POINTER_ARB                                     35005
#endif


typedef GLvoid (csAPIENTRY* csGLBINDBUFFERARB) (GLenum target, GLuint buffer);
typedef GLvoid (csAPIENTRY* csGLDELETEBUFFERSARB) (GLsizei n, const GLuint* buffers);
typedef GLvoid (csAPIENTRY* csGLGENBUFFERSARB) (GLsizei n, GLuint* buffers);
typedef GLvoid (csAPIENTRY* csGLBUFFERDATAARB) (GLenum target, GLsizei size, const GLvoid* data, GLenum usage);
typedef GLvoid (csAPIENTRY* csGLBUFFERSUBDATAARB) (GLenum target, GLsizei offset, GLsizei size, const GLvoid* data);
typedef GLvoid* (csAPIENTRY* csGLMAPBUFFERARB) (GLenum target, GLenum access);
typedef GLboolean (csAPIENTRY* csGLUNMAPBUFFERARB) (GLenum target);
typedef GLboolean (csAPIENTRY* csGLISBUFFERARB) (GLuint buffer);
typedef GLvoid (csAPIENTRY* csGLGETBUFFERSUBDATAARB) (GLenum target, GLsizei offset, GLsizei size, GLvoid* data);
typedef GLvoid (csAPIENTRY* csGLGETBUFFERPOINTERVARB) (GLenum target, GLenum pname, GLvoid** params);
typedef GLvoid (csAPIENTRY* csGLGETBUFFERPARAMETERIVARB) (GLenum target, GLenum pname, GLint* params);

// GL_ATI_separate_stencil
#ifndef GL_STENCIL_BACK_FUNC_ATI
#define GL_STENCIL_BACK_FUNC_ATI                                     0x8800
#endif

#ifndef GL_STENCIL_BACK_FAIL_ATI
#define GL_STENCIL_BACK_FAIL_ATI                                     0x8801
#endif

#ifndef GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI
#define GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI                          0x8802
#endif

#ifndef GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI
#define GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI                          0x8803
#endif


typedef GLvoid (csAPIENTRY* csGLSTENCILOPSEPARATEATI) (GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass);
typedef GLvoid (csAPIENTRY* csGLSTENCILFUNCSEPARATEATI) (GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask);

// GL_ARB_texture_non_power_of_two


// GL_ARB_point_sprite
#ifndef GL_POINT_SPRITE_ARB
#define GL_POINT_SPRITE_ARB                                          0x8861
#endif

#ifndef GL_COORD_REPLACE_ARB
#define GL_COORD_REPLACE_ARB                                         0x8862
#endif



// GL_ARB_shading_language_100


// GL_ARB_shader_objects
#ifndef GL_PROGRAM_OBJECT_ARB
#define GL_PROGRAM_OBJECT_ARB                                        0x8B40
#endif

#ifndef GL_OBJECT_TYPE_ARB
#define GL_OBJECT_TYPE_ARB                                           0x8B4E
#endif

#ifndef GL_OBJECT_SUBTYPE_ARB
#define GL_OBJECT_SUBTYPE_ARB                                        0x8B4F
#endif

#ifndef GL_OBJECT_DELETE_STATUS_ARB
#define GL_OBJECT_DELETE_STATUS_ARB                                  0x8B80
#endif

#ifndef GL_OBJECT_COMPILE_STATUS_ARB
#define GL_OBJECT_COMPILE_STATUS_ARB                                 0x8B81
#endif

#ifndef GL_OBJECT_LINK_STATUS_ARB
#define GL_OBJECT_LINK_STATUS_ARB                                    0x8B82
#endif

#ifndef GL_OBJECT_VALIDATE_STATUS_ARB
#define GL_OBJECT_VALIDATE_STATUS_ARB                                0x8B83
#endif

#ifndef GL_OBJECT_INFO_LOG_LENGTH_ARB
#define GL_OBJECT_INFO_LOG_LENGTH_ARB                                0x8B84
#endif

#ifndef GL_OBJECT_ATTACHED_OBJECTS_ARB
#define GL_OBJECT_ATTACHED_OBJECTS_ARB                               0x8B85
#endif

#ifndef GL_OBJECT_ACTIVE_UNIFORMS_ARB
#define GL_OBJECT_ACTIVE_UNIFORMS_ARB                                0x8B86
#endif

#ifndef GL_OBJECT_ACTIVE_UNIFORMS_MAX_LENGTH_ARB
#define GL_OBJECT_ACTIVE_UNIFORMS_MAX_LENGTH_ARB                     0x8B87
#endif

#ifndef GL_OBJECT_SHADER_SOURCE_LENGTH_ARB
#define GL_OBJECT_SHADER_SOURCE_LENGTH_ARB                           0x8B88
#endif

#ifndef GL_SHADER_OBJECT_ARB
#define GL_SHADER_OBJECT_ARB                                         0x8B48
#endif

#ifndef GL_FLOAT_VEC2_ARB
#define GL_FLOAT_VEC2_ARB                                            0x8B50
#endif

#ifndef GL_FLOAT_VEC3_ARB
#define GL_FLOAT_VEC3_ARB                                            0x8B51
#endif

#ifndef GL_FLOAT_VEC4_ARB
#define GL_FLOAT_VEC4_ARB                                            0x8B52
#endif

#ifndef GL_INT_VEC2_ARB
#define GL_INT_VEC2_ARB                                              0x8B53
#endif

#ifndef GL_INT_VEC3_ARB
#define GL_INT_VEC3_ARB                                              0x8B54
#endif

#ifndef GL_INT_VEC4_ARB
#define GL_INT_VEC4_ARB                                              0x8B55
#endif

#ifndef GL_BOOL
#define GL_BOOL                                                      0x8B56
#endif

#ifndef GL_BOOL_VEC2_ARB
#define GL_BOOL_VEC2_ARB                                             0x8B57
#endif

#ifndef GL_BOOL_VEC3_ARB
#define GL_BOOL_VEC3_ARB                                             0x8B58
#endif

#ifndef GL_BOOL_VEC4_ARB
#define GL_BOOL_VEC4_ARB                                             0x8B59
#endif

#ifndef GL_FLOAT_MAT2_ARB
#define GL_FLOAT_MAT2_ARB                                            0x8B5A
#endif

#ifndef GL_FLOAT_MAT3_ARB
#define GL_FLOAT_MAT3_ARB                                            0x8B5B
#endif

#ifndef GL_FLOAT_MAT4_ARB
#define GL_FLOAT_MAT4_ARB                                            0x8B5C
#endif


typedef GLvoid (csAPIENTRY* csGLDELETEOBJECTARB) (GLhandleARB obj);
typedef GLhandleARB (csAPIENTRY* csGLGETHANDLEARB) (GLenum pname);
typedef GLvoid (csAPIENTRY* csGLDETACHOBJECTARB) (GLhandleARB containerObj, GLhandleARB attachedObj);
typedef GLhandleARB (csAPIENTRY* csGLCREATESHADEROBJECTARB) (GLenum shaderType);
typedef GLvoid (csAPIENTRY* csGLSHADERSOURCEARB) (GLhandleARB shaderObj, GLsizei count, const GLcharARB** string, const GLint* length);
typedef GLvoid (csAPIENTRY* csGLCOMPILESHADERARB) (GLhandleARB shaderObj);
typedef GLhandleARB (csAPIENTRY* csGLCREATEPROGRAMOBJECTARB) ();
typedef GLvoid (csAPIENTRY* csGLATTACHOBJECTARB) (GLhandleARB containerObj, GLhandleARB Obj);
typedef GLvoid (csAPIENTRY* csGLLINKPROGRAMARB) (GLhandleARB programObj);
typedef GLvoid (csAPIENTRY* csGLUSEPROGRAMOBJECTARB) (GLhandleARB programObj);
typedef GLvoid (csAPIENTRY* csGLVALIDATEPROGRAMARB) (GLhandleARB programObj);
typedef GLvoid (csAPIENTRY* csGLUNIFORM1FARB) (GLint location, GLfloat v0);
typedef GLvoid (csAPIENTRY* csGLUNIFORM2FARB) (GLint location, GLfloat v0, GLfloat v1);
typedef GLvoid (csAPIENTRY* csGLUNIFORM3FARB) (GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
typedef GLvoid (csAPIENTRY* csGLUNIFORM4FARB) (GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
typedef GLvoid (csAPIENTRY* csGLUNIFORM1IARB) (GLint location, GLint v0);
typedef GLvoid (csAPIENTRY* csGLUNIFORM2IARB) (GLint location, GLint v0, GLint v1);
typedef GLvoid (csAPIENTRY* csGLUNIFORM3IARB) (GLint location, GLint v0, GLint v1, GLint v2);
typedef GLvoid (csAPIENTRY* csGLUNIFORM4IARB) (GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
typedef GLvoid (csAPIENTRY* csGLUNIFORM1FVARB) (GLint location, GLsizei count, GLfloat* value);
typedef GLvoid (csAPIENTRY* csGLUNIFORM2FVARB) (GLint location, GLsizei count, GLfloat* value);
typedef GLvoid (csAPIENTRY* csGLUNIFORM3FVARB) (GLint location, GLsizei count, GLfloat* value);
typedef GLvoid (csAPIENTRY* csGLUNIFORM4FVARB) (GLint location, GLsizei count, GLfloat* value);
typedef GLvoid (csAPIENTRY* csGLUNIFORM1IVARB) (GLint location, GLsizei count, GLint* value);
typedef GLvoid (csAPIENTRY* csGLUNIFORM2IVARB) (GLint location, GLsizei count, GLint* value);
typedef GLvoid (csAPIENTRY* csGLUNIFORM3IVARB) (GLint location, GLsizei count, GLint* value);
typedef GLvoid (csAPIENTRY* csGLUNIFORM4IVARB) (GLint location, GLsizei count, GLint* value);
typedef GLvoid (csAPIENTRY* csGLUNIFORMMATRIX2FVARB) (GLint location, GLsizei count, GLboolean transpose, GLfloat* value);
typedef GLvoid (csAPIENTRY* csGLUNIFORMMATRIX3FVARB) (GLint location, GLsizei count, GLboolean transpose, GLfloat* value);
typedef GLvoid (csAPIENTRY* csGLUNIFORMMATRIX4FVARB) (GLint location, GLsizei count, GLboolean transpose, GLfloat* value);
typedef GLvoid (csAPIENTRY* csGLGETOBJECTPARAMETERFVARB) (GLhandleARB obj, GLenum pname, GLfloat* params);
typedef GLvoid (csAPIENTRY* csGLGETOBJECTPARAMETERIVARB) (GLhandleARB obj, GLenum pname, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETINFOLOGARB) (GLhandleARB obj, GLsizei maxLength, GLsizei* length, GLcharARB* infoLog);
typedef GLvoid (csAPIENTRY* csGLGETATTACHEDOBJECTSARB) (GLhandleARB containerObj, GLsizei maxCount, GLsizei* count, GLhandleARB* obj);
typedef GLint (csAPIENTRY* csGLGETUNIFORMLOCATIONARB) (GLhandleARB programObj, const GLcharARB* name);
typedef GLvoid (csAPIENTRY* csGLGETACTIVEUNIFORMARB) (GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei* length, GLint* size, GLenum* type, GLcharARB* name);
typedef GLint (csAPIENTRY* csGLGETUNIFORMFVARB) (GLhandleARB programObj, GLint location, GLfloat* params);
typedef GLint (csAPIENTRY* csGLGETUNIFORMIVARB) (GLhandleARB programObj, GLint location, GLint* params);
typedef GLvoid (csAPIENTRY* csGLGETSHADERSOURCEARB) (GLhandleARB obj, GLsizei maxLength, GLsizei* length, GLcharARB* source);

// GL_ARB_fragment_shader
#ifndef GL_FRAGMENT_SHADER_ARB
#define GL_FRAGMENT_SHADER_ARB                                       0x8B30
#endif

#ifndef GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB
#define GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB                       0x8B49
#endif

#ifndef GL_MAX_TEXTURE_COORDS_ARB
#define GL_MAX_TEXTURE_COORDS_ARB                                    0x8871
#endif

#ifndef GL_MAX_TEXTURE_IMAGE_UNITS_ARB
#define GL_MAX_TEXTURE_IMAGE_UNITS_ARB                               0x8872
#endif

#ifndef GL_OBJECT_TYPE_ARB
#define GL_OBJECT_TYPE_ARB                                           0x8B4E
#endif

#ifndef GL_OBJECT_SUBTYPE_ARB
#define GL_OBJECT_SUBTYPE_ARB                                        0x8B4F
#endif

#ifndef GL_SHADER_OBJECT_ARB
#define GL_SHADER_OBJECT_ARB                                         0x8B48
#endif



// GL_ARB_vertex_shader
#ifndef GL_VERTEX_SHADER_ARB
#define GL_VERTEX_SHADER_ARB                                         0x8B31
#endif

#ifndef GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB
#define GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB                         0x8B4A
#endif

#ifndef GL_MAX_VARYING_FLOATS_ARB
#define GL_MAX_VARYING_FLOATS_ARB                                    0x8B4B
#endif

#ifndef GL_MAX_VERTEX_ATTRIBS_ARB
#define GL_MAX_VERTEX_ATTRIBS_ARB                                    0x8869
#endif

#ifndef GL_MAX_TEXTURE_IMAGE_UNITS_ARB
#define GL_MAX_TEXTURE_IMAGE_UNITS_ARB                               0x8872
#endif

#ifndef GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB
#define GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB                        0x884C
#endif

#ifndef GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB
#define GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB                      0x884D
#endif

#ifndef GL_MAX_TEXTURE_COORDS_ARB
#define GL_MAX_TEXTURE_COORDS_ARB                                    0x8871
#endif

#ifndef GL_VERTEX_PROGRAM_POINT_SIZE_ARB
#define GL_VERTEX_PROGRAM_POINT_SIZE_ARB                             0x8642
#endif

#ifndef GL_VERTEX_PROGRAM_TWO_SIDE_ARB
#define GL_VERTEX_PROGRAM_TWO_SIDE_ARB                               0x8643
#endif

#ifndef GL_OBJECT_TYPE_ARB
#define GL_OBJECT_TYPE_ARB                                           0x8B4E
#endif

#ifndef GL_OBJECT_SUBTYPE_ARB
#define GL_OBJECT_SUBTYPE_ARB                                        0x8B4F
#endif

#ifndef GL_OBJECT_ACTIVE_ATTRIBUTES_ARB
#define GL_OBJECT_ACTIVE_ATTRIBUTES_ARB                              0x8B89
#endif

#ifndef GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB
#define GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB                    0x8B8A
#endif

#ifndef GL_SHADER_OBJECT_ARB
#define GL_SHADER_OBJECT_ARB                                         0x8B48
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB
#define GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB                           0x8622
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB
#define GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB                              0x8623
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB
#define GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB                            0x8624
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB
#define GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB                              0x8625
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB
#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB                        0x886A
#endif

#ifndef GL_CURRENT_VERTEX_ATTRIB_ARB
#define GL_CURRENT_VERTEX_ATTRIB_ARB                                 0x8626
#endif

#ifndef GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB
#define GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB                           0x8645
#endif

#ifndef GL_FLOAT_VEC2_ARB
#define GL_FLOAT_VEC2_ARB                                            0x8B50
#endif

#ifndef GL_FLOAT_VEC3_ARB
#define GL_FLOAT_VEC3_ARB                                            0x8B51
#endif

#ifndef GL_FLOAT_VEC4_ARB
#define GL_FLOAT_VEC4_ARB                                            0x8B52
#endif

#ifndef GL_FLOAT_MAT2_ARB
#define GL_FLOAT_MAT2_ARB                                            0x8B5A
#endif

#ifndef GL_FLOAT_MAT3_ARB
#define GL_FLOAT_MAT3_ARB                                            0x8B5B
#endif

#ifndef GL_FLOAT_MAT4_ARB
#define GL_FLOAT_MAT4_ARB                                            0x8B5C
#endif


typedef GLvoid (csAPIENTRY* csGLBINDATTRIBLOCATIONARB) (GLhandleARB programObj, GLuint index, const GLcharARB* name);
typedef GLvoid (csAPIENTRY* csGLGETACTIVEATTRIBARB) (GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei* length, GLint* size, GLenum* type, GLcharARB* name);
typedef GLint (csAPIENTRY* csGLGETATTRIBLOCATIONARB) (GLhandleARB programObj, const GLcharARB* name);



// end of definitions

#ifdef CS_DEBUG
#  define REPORT_MISSING_ENTRIES true
#else
#  define REPORT_MISSING_ENTRIES false
#endif

#define EXTMGR_FUNC_INIT(nameNC, nameUC) \
      funcTest = ((nameNC = (cs##nameUC) gl->GetProcAddress (#nameNC)) != 0); \
      if (!funcTest && config->GetBool ("Video.OpenGL.ReportMissingEntries", \
	REPORT_MISSING_ENTRIES)) \
      { \
	Report (msgExtRetrieveFail, #nameNC); \
      } \
      allclear &= funcTest; \

#define EXTMGR_REPORT_INIT_RESULT(exttype, nameNC) \
      if (CS_##nameNC = allclear) \
      { \
        CS_##nameNC &= config->GetBool (cfgkey, true); \
        if (CS_##nameNC) \
        { \
          Report (msgExtFoundAndUsed, exttype, ext); \
        } \
        else \
        { \
          Report (msgExtFoundAndNotUsed, exttype, ext); \
        } \
      } \
      else \
      { \
        Report (msgExtInitFail, exttype, ext); \
      } 

struct csGLExtensionFunctions
{
public:
  // GL_version_1_2
  #ifndef GLDRAWRANGEELEMENTS_DECL
  #define GLDRAWRANGEELEMENTS_DECL
  csGLDRAWRANGEELEMENTS glDrawRangeElements;
  #endif

  #ifndef GLTEXIMAGE3D_DECL
  #define GLTEXIMAGE3D_DECL
  csGLTEXIMAGE3D glTexImage3D;
  #endif

  #ifndef GLTEXSUBIMAGE3D_DECL
  #define GLTEXSUBIMAGE3D_DECL
  csGLTEXSUBIMAGE3D glTexSubImage3D;
  #endif

  #ifndef GLCOPYTEXSUBIMAGE3D_DECL
  #define GLCOPYTEXSUBIMAGE3D_DECL
  csGLCOPYTEXSUBIMAGE3D glCopyTexSubImage3D;
  #endif


  // GL_version_1_3
  #ifndef GLACTIVETEXTURE_DECL
  #define GLACTIVETEXTURE_DECL
  csGLACTIVETEXTURE glActiveTexture;
  #endif

  #ifndef GLCLIENTACTIVETEXTURE_DECL
  #define GLCLIENTACTIVETEXTURE_DECL
  csGLCLIENTACTIVETEXTURE glClientActiveTexture;
  #endif

  #ifndef GLMULTITEXCOORD1D_DECL
  #define GLMULTITEXCOORD1D_DECL
  csGLMULTITEXCOORD1D glMultiTexCoord1d;
  #endif

  #ifndef GLMULTITEXCOORD1DV_DECL
  #define GLMULTITEXCOORD1DV_DECL
  csGLMULTITEXCOORD1DV glMultiTexCoord1dv;
  #endif

  #ifndef GLMULTITEXCOORD1F_DECL
  #define GLMULTITEXCOORD1F_DECL
  csGLMULTITEXCOORD1F glMultiTexCoord1f;
  #endif

  #ifndef GLMULTITEXCOORD1FV_DECL
  #define GLMULTITEXCOORD1FV_DECL
  csGLMULTITEXCOORD1FV glMultiTexCoord1fv;
  #endif

  #ifndef GLMULTITEXCOORD1I_DECL
  #define GLMULTITEXCOORD1I_DECL
  csGLMULTITEXCOORD1I glMultiTexCoord1i;
  #endif

  #ifndef GLMULTITEXCOORD1IV_DECL
  #define GLMULTITEXCOORD1IV_DECL
  csGLMULTITEXCOORD1IV glMultiTexCoord1iv;
  #endif

  #ifndef GLMULTITEXCOORD1S_DECL
  #define GLMULTITEXCOORD1S_DECL
  csGLMULTITEXCOORD1S glMultiTexCoord1s;
  #endif

  #ifndef GLMULTITEXCOORD1SV_DECL
  #define GLMULTITEXCOORD1SV_DECL
  csGLMULTITEXCOORD1SV glMultiTexCoord1sv;
  #endif

  #ifndef GLMULTITEXCOORD2D_DECL
  #define GLMULTITEXCOORD2D_DECL
  csGLMULTITEXCOORD2D glMultiTexCoord2d;
  #endif

  #ifndef GLMULTITEXCOORD2DV_DECL
  #define GLMULTITEXCOORD2DV_DECL
  csGLMULTITEXCOORD2DV glMultiTexCoord2dv;
  #endif

  #ifndef GLMULTITEXCOORD2F_DECL
  #define GLMULTITEXCOORD2F_DECL
  csGLMULTITEXCOORD2F glMultiTexCoord2f;
  #endif

  #ifndef GLMULTITEXCOORD2FV_DECL
  #define GLMULTITEXCOORD2FV_DECL
  csGLMULTITEXCOORD2FV glMultiTexCoord2fv;
  #endif

  #ifndef GLMULTITEXCOORD2I_DECL
  #define GLMULTITEXCOORD2I_DECL
  csGLMULTITEXCOORD2I glMultiTexCoord2i;
  #endif

  #ifndef GLMULTITEXCOORD2IV_DECL
  #define GLMULTITEXCOORD2IV_DECL
  csGLMULTITEXCOORD2IV glMultiTexCoord2iv;
  #endif

  #ifndef GLMULTITEXCOORD2S_DECL
  #define GLMULTITEXCOORD2S_DECL
  csGLMULTITEXCOORD2S glMultiTexCoord2s;
  #endif

  #ifndef GLMULTITEXCOORD2SV_DECL
  #define GLMULTITEXCOORD2SV_DECL
  csGLMULTITEXCOORD2SV glMultiTexCoord2sv;
  #endif

  #ifndef GLMULTITEXCOORD3D_DECL
  #define GLMULTITEXCOORD3D_DECL
  csGLMULTITEXCOORD3D glMultiTexCoord3d;
  #endif

  #ifndef GLMULTITEXCOORD3DV_DECL
  #define GLMULTITEXCOORD3DV_DECL
  csGLMULTITEXCOORD3DV glMultiTexCoord3dv;
  #endif

  #ifndef GLMULTITEXCOORD3F_DECL
  #define GLMULTITEXCOORD3F_DECL
  csGLMULTITEXCOORD3F glMultiTexCoord3f;
  #endif

  #ifndef GLMULTITEXCOORD3FV_DECL
  #define GLMULTITEXCOORD3FV_DECL
  csGLMULTITEXCOORD3FV glMultiTexCoord3fv;
  #endif

  #ifndef GLMULTITEXCOORD3I_DECL
  #define GLMULTITEXCOORD3I_DECL
  csGLMULTITEXCOORD3I glMultiTexCoord3i;
  #endif

  #ifndef GLMULTITEXCOORD3IV_DECL
  #define GLMULTITEXCOORD3IV_DECL
  csGLMULTITEXCOORD3IV glMultiTexCoord3iv;
  #endif

  #ifndef GLMULTITEXCOORD3S_DECL
  #define GLMULTITEXCOORD3S_DECL
  csGLMULTITEXCOORD3S glMultiTexCoord3s;
  #endif

  #ifndef GLMULTITEXCOORD3SV_DECL
  #define GLMULTITEXCOORD3SV_DECL
  csGLMULTITEXCOORD3SV glMultiTexCoord3sv;
  #endif

  #ifndef GLMULTITEXCOORD4D_DECL
  #define GLMULTITEXCOORD4D_DECL
  csGLMULTITEXCOORD4D glMultiTexCoord4d;
  #endif

  #ifndef GLMULTITEXCOORD4DV_DECL
  #define GLMULTITEXCOORD4DV_DECL
  csGLMULTITEXCOORD4DV glMultiTexCoord4dv;
  #endif

  #ifndef GLMULTITEXCOORD4F_DECL
  #define GLMULTITEXCOORD4F_DECL
  csGLMULTITEXCOORD4F glMultiTexCoord4f;
  #endif

  #ifndef GLMULTITEXCOORD4FV_DECL
  #define GLMULTITEXCOORD4FV_DECL
  csGLMULTITEXCOORD4FV glMultiTexCoord4fv;
  #endif

  #ifndef GLMULTITEXCOORD4I_DECL
  #define GLMULTITEXCOORD4I_DECL
  csGLMULTITEXCOORD4I glMultiTexCoord4i;
  #endif

  #ifndef GLMULTITEXCOORD4IV_DECL
  #define GLMULTITEXCOORD4IV_DECL
  csGLMULTITEXCOORD4IV glMultiTexCoord4iv;
  #endif

  #ifndef GLMULTITEXCOORD4S_DECL
  #define GLMULTITEXCOORD4S_DECL
  csGLMULTITEXCOORD4S glMultiTexCoord4s;
  #endif

  #ifndef GLMULTITEXCOORD4SV_DECL
  #define GLMULTITEXCOORD4SV_DECL
  csGLMULTITEXCOORD4SV glMultiTexCoord4sv;
  #endif

  #ifndef GLLOADTRANSPOSEMATRIXF_DECL
  #define GLLOADTRANSPOSEMATRIXF_DECL
  csGLLOADTRANSPOSEMATRIXF glLoadTransposeMatrixf;
  #endif

  #ifndef GLLOADTRANSPOSEMATRIXD_DECL
  #define GLLOADTRANSPOSEMATRIXD_DECL
  csGLLOADTRANSPOSEMATRIXD glLoadTransposeMatrixd;
  #endif

  #ifndef GLMULTTRANSPOSEMATRIXF_DECL
  #define GLMULTTRANSPOSEMATRIXF_DECL
  csGLMULTTRANSPOSEMATRIXF glMultTransposeMatrixf;
  #endif

  #ifndef GLMULTTRANSPOSEMATRIXD_DECL
  #define GLMULTTRANSPOSEMATRIXD_DECL
  csGLMULTTRANSPOSEMATRIXD glMultTransposeMatrixd;
  #endif

  #ifndef GLSAMPLECOVERAGE_DECL
  #define GLSAMPLECOVERAGE_DECL
  csGLSAMPLECOVERAGE glSampleCoverage;
  #endif

  #ifndef GLCOMPRESSEDTEXIMAGE3D_DECL
  #define GLCOMPRESSEDTEXIMAGE3D_DECL
  csGLCOMPRESSEDTEXIMAGE3D glCompressedTexImage3D;
  #endif

  #ifndef GLCOMPRESSEDTEXIMAGE2D_DECL
  #define GLCOMPRESSEDTEXIMAGE2D_DECL
  csGLCOMPRESSEDTEXIMAGE2D glCompressedTexImage2D;
  #endif

  #ifndef GLCOMPRESSEDTEXIMAGE1D_DECL
  #define GLCOMPRESSEDTEXIMAGE1D_DECL
  csGLCOMPRESSEDTEXIMAGE1D glCompressedTexImage1D;
  #endif

  #ifndef GLCOMPRESSEDTEXSUBIMAGE3D_DECL
  #define GLCOMPRESSEDTEXSUBIMAGE3D_DECL
  csGLCOMPRESSEDTEXSUBIMAGE3D glCompressedTexSubImage3D;
  #endif

  #ifndef GLCOMPRESSEDTEXSUBIMAGE2D_DECL
  #define GLCOMPRESSEDTEXSUBIMAGE2D_DECL
  csGLCOMPRESSEDTEXSUBIMAGE2D glCompressedTexSubImage2D;
  #endif

  #ifndef GLCOMPRESSEDTEXSUBIMAGE1D_DECL
  #define GLCOMPRESSEDTEXSUBIMAGE1D_DECL
  csGLCOMPRESSEDTEXSUBIMAGE1D glCompressedTexSubImage1D;
  #endif

  #ifndef GLGETCOMPRESSEDTEXIMAGE_DECL
  #define GLGETCOMPRESSEDTEXIMAGE_DECL
  csGLGETCOMPRESSEDTEXIMAGE glGetCompressedTexImage;
  #endif


  // GL_ARB_imaging
  #ifndef GLCOLORTABLE_DECL
  #define GLCOLORTABLE_DECL
  csGLCOLORTABLE glColorTable;
  #endif

  #ifndef GLCOLORTABLEPARAMETERFV_DECL
  #define GLCOLORTABLEPARAMETERFV_DECL
  csGLCOLORTABLEPARAMETERFV glColorTableParameterfv;
  #endif

  #ifndef GLCOLORTABLEPARAMETERIV_DECL
  #define GLCOLORTABLEPARAMETERIV_DECL
  csGLCOLORTABLEPARAMETERIV glColorTableParameteriv;
  #endif

  #ifndef GLCOPYCOLORTABLE_DECL
  #define GLCOPYCOLORTABLE_DECL
  csGLCOPYCOLORTABLE glCopyColorTable;
  #endif

  #ifndef GLGETCOLORTABLE_DECL
  #define GLGETCOLORTABLE_DECL
  csGLGETCOLORTABLE glGetColorTable;
  #endif

  #ifndef GLGETCOLORTABLEPARAMETERFV_DECL
  #define GLGETCOLORTABLEPARAMETERFV_DECL
  csGLGETCOLORTABLEPARAMETERFV glGetColorTableParameterfv;
  #endif

  #ifndef GLGETCOLORTABLEPARAMETERIV_DECL
  #define GLGETCOLORTABLEPARAMETERIV_DECL
  csGLGETCOLORTABLEPARAMETERIV glGetColorTableParameteriv;
  #endif

  #ifndef GLCOLORSUBTABLE_DECL
  #define GLCOLORSUBTABLE_DECL
  csGLCOLORSUBTABLE glColorSubTable;
  #endif

  #ifndef GLCOPYCOLORSUBTABLE_DECL
  #define GLCOPYCOLORSUBTABLE_DECL
  csGLCOPYCOLORSUBTABLE glCopyColorSubTable;
  #endif

  #ifndef GLCONVOLUTIONFILTER1D_DECL
  #define GLCONVOLUTIONFILTER1D_DECL
  csGLCONVOLUTIONFILTER1D glConvolutionFilter1D;
  #endif

  #ifndef GLCONVOLUTIONFILTER2D_DECL
  #define GLCONVOLUTIONFILTER2D_DECL
  csGLCONVOLUTIONFILTER2D glConvolutionFilter2D;
  #endif

  #ifndef GLCONVOLUTIONPARAMETERF_DECL
  #define GLCONVOLUTIONPARAMETERF_DECL
  csGLCONVOLUTIONPARAMETERF glConvolutionParameterf;
  #endif

  #ifndef GLCONVOLUTIONPARAMETERFV_DECL
  #define GLCONVOLUTIONPARAMETERFV_DECL
  csGLCONVOLUTIONPARAMETERFV glConvolutionParameterfv;
  #endif

  #ifndef GLCONVOLUTIONPARAMETERI_DECL
  #define GLCONVOLUTIONPARAMETERI_DECL
  csGLCONVOLUTIONPARAMETERI glConvolutionParameteri;
  #endif

  #ifndef GLCONVOLUTIONPARAMETERIV_DECL
  #define GLCONVOLUTIONPARAMETERIV_DECL
  csGLCONVOLUTIONPARAMETERIV glConvolutionParameteriv;
  #endif

  #ifndef GLCOPYCONVOLUTIONFILTER1D_DECL
  #define GLCOPYCONVOLUTIONFILTER1D_DECL
  csGLCOPYCONVOLUTIONFILTER1D glCopyConvolutionFilter1D;
  #endif

  #ifndef GLCOPYCONVOLUTIONFILTER2D_DECL
  #define GLCOPYCONVOLUTIONFILTER2D_DECL
  csGLCOPYCONVOLUTIONFILTER2D glCopyConvolutionFilter2D;
  #endif

  #ifndef GLGETCONVOLUTIONFILTER_DECL
  #define GLGETCONVOLUTIONFILTER_DECL
  csGLGETCONVOLUTIONFILTER glGetConvolutionFilter;
  #endif

  #ifndef GLGETCONVOLUTIONPARAMETERFV_DECL
  #define GLGETCONVOLUTIONPARAMETERFV_DECL
  csGLGETCONVOLUTIONPARAMETERFV glGetConvolutionParameterfv;
  #endif

  #ifndef GLGETCONVOLUTIONPARAMETERIV_DECL
  #define GLGETCONVOLUTIONPARAMETERIV_DECL
  csGLGETCONVOLUTIONPARAMETERIV glGetConvolutionParameteriv;
  #endif

  #ifndef GLGETSEPARABLEFILTER_DECL
  #define GLGETSEPARABLEFILTER_DECL
  csGLGETSEPARABLEFILTER glGetSeparableFilter;
  #endif

  #ifndef GLSEPARABLEFILTER2D_DECL
  #define GLSEPARABLEFILTER2D_DECL
  csGLSEPARABLEFILTER2D glSeparableFilter2D;
  #endif

  #ifndef GLGETHISTOGRAM_DECL
  #define GLGETHISTOGRAM_DECL
  csGLGETHISTOGRAM glGetHistogram;
  #endif

  #ifndef GLGETHISTOGRAMPARAMETERFV_DECL
  #define GLGETHISTOGRAMPARAMETERFV_DECL
  csGLGETHISTOGRAMPARAMETERFV glGetHistogramParameterfv;
  #endif

  #ifndef GLGETHISTOGRAMPARAMETERIV_DECL
  #define GLGETHISTOGRAMPARAMETERIV_DECL
  csGLGETHISTOGRAMPARAMETERIV glGetHistogramParameteriv;
  #endif

  #ifndef GLGETMINMAX_DECL
  #define GLGETMINMAX_DECL
  csGLGETMINMAX glGetMinmax;
  #endif

  #ifndef GLGETMINMAXPARAMETERFV_DECL
  #define GLGETMINMAXPARAMETERFV_DECL
  csGLGETMINMAXPARAMETERFV glGetMinmaxParameterfv;
  #endif

  #ifndef GLGETMINMAXPARAMETERIV_DECL
  #define GLGETMINMAXPARAMETERIV_DECL
  csGLGETMINMAXPARAMETERIV glGetMinmaxParameteriv;
  #endif

  #ifndef GLHISTOGRAM_DECL
  #define GLHISTOGRAM_DECL
  csGLHISTOGRAM glHistogram;
  #endif

  #ifndef GLMINMAX_DECL
  #define GLMINMAX_DECL
  csGLMINMAX glMinmax;
  #endif

  #ifndef GLRESETHISTOGRAM_DECL
  #define GLRESETHISTOGRAM_DECL
  csGLRESETHISTOGRAM glResetHistogram;
  #endif

  #ifndef GLRESETMINMAX_DECL
  #define GLRESETMINMAX_DECL
  csGLRESETMINMAX glResetMinmax;
  #endif

  #ifndef GLBLENDCOLOR_DECL
  #define GLBLENDCOLOR_DECL
  csGLBLENDCOLOR glBlendColor;
  #endif

  #ifndef GLBLENDEQUATION_DECL
  #define GLBLENDEQUATION_DECL
  csGLBLENDEQUATION glBlendEquation;
  #endif


  // GL_ARB_multitexture
  #ifndef GLACTIVETEXTUREARB_DECL
  #define GLACTIVETEXTUREARB_DECL
  csGLACTIVETEXTUREARB glActiveTextureARB;
  #endif

  #ifndef GLCLIENTACTIVETEXTUREARB_DECL
  #define GLCLIENTACTIVETEXTUREARB_DECL
  csGLCLIENTACTIVETEXTUREARB glClientActiveTextureARB;
  #endif

  #ifndef GLMULTITEXCOORD1DARB_DECL
  #define GLMULTITEXCOORD1DARB_DECL
  csGLMULTITEXCOORD1DARB glMultiTexCoord1dARB;
  #endif

  #ifndef GLMULTITEXCOORD1DVARB_DECL
  #define GLMULTITEXCOORD1DVARB_DECL
  csGLMULTITEXCOORD1DVARB glMultiTexCoord1dvARB;
  #endif

  #ifndef GLMULTITEXCOORD1FARB_DECL
  #define GLMULTITEXCOORD1FARB_DECL
  csGLMULTITEXCOORD1FARB glMultiTexCoord1fARB;
  #endif

  #ifndef GLMULTITEXCOORD1FVARB_DECL
  #define GLMULTITEXCOORD1FVARB_DECL
  csGLMULTITEXCOORD1FVARB glMultiTexCoord1fvARB;
  #endif

  #ifndef GLMULTITEXCOORD1IARB_DECL
  #define GLMULTITEXCOORD1IARB_DECL
  csGLMULTITEXCOORD1IARB glMultiTexCoord1iARB;
  #endif

  #ifndef GLMULTITEXCOORD1IVARB_DECL
  #define GLMULTITEXCOORD1IVARB_DECL
  csGLMULTITEXCOORD1IVARB glMultiTexCoord1ivARB;
  #endif

  #ifndef GLMULTITEXCOORD1SARB_DECL
  #define GLMULTITEXCOORD1SARB_DECL
  csGLMULTITEXCOORD1SARB glMultiTexCoord1sARB;
  #endif

  #ifndef GLMULTITEXCOORD1SVARB_DECL
  #define GLMULTITEXCOORD1SVARB_DECL
  csGLMULTITEXCOORD1SVARB glMultiTexCoord1svARB;
  #endif

  #ifndef GLMULTITEXCOORD2DARB_DECL
  #define GLMULTITEXCOORD2DARB_DECL
  csGLMULTITEXCOORD2DARB glMultiTexCoord2dARB;
  #endif

  #ifndef GLMULTITEXCOORD2DVARB_DECL
  #define GLMULTITEXCOORD2DVARB_DECL
  csGLMULTITEXCOORD2DVARB glMultiTexCoord2dvARB;
  #endif

  #ifndef GLMULTITEXCOORD2FARB_DECL
  #define GLMULTITEXCOORD2FARB_DECL
  csGLMULTITEXCOORD2FARB glMultiTexCoord2fARB;
  #endif

  #ifndef GLMULTITEXCOORD2FVARB_DECL
  #define GLMULTITEXCOORD2FVARB_DECL
  csGLMULTITEXCOORD2FVARB glMultiTexCoord2fvARB;
  #endif

  #ifndef GLMULTITEXCOORD2IARB_DECL
  #define GLMULTITEXCOORD2IARB_DECL
  csGLMULTITEXCOORD2IARB glMultiTexCoord2iARB;
  #endif

  #ifndef GLMULTITEXCOORD2IVARB_DECL
  #define GLMULTITEXCOORD2IVARB_DECL
  csGLMULTITEXCOORD2IVARB glMultiTexCoord2ivARB;
  #endif

  #ifndef GLMULTITEXCOORD2SARB_DECL
  #define GLMULTITEXCOORD2SARB_DECL
  csGLMULTITEXCOORD2SARB glMultiTexCoord2sARB;
  #endif

  #ifndef GLMULTITEXCOORD2SVARB_DECL
  #define GLMULTITEXCOORD2SVARB_DECL
  csGLMULTITEXCOORD2SVARB glMultiTexCoord2svARB;
  #endif

  #ifndef GLMULTITEXCOORD3DARB_DECL
  #define GLMULTITEXCOORD3DARB_DECL
  csGLMULTITEXCOORD3DARB glMultiTexCoord3dARB;
  #endif

  #ifndef GLMULTITEXCOORD3DVARB_DECL
  #define GLMULTITEXCOORD3DVARB_DECL
  csGLMULTITEXCOORD3DVARB glMultiTexCoord3dvARB;
  #endif

  #ifndef GLMULTITEXCOORD3FARB_DECL
  #define GLMULTITEXCOORD3FARB_DECL
  csGLMULTITEXCOORD3FARB glMultiTexCoord3fARB;
  #endif

  #ifndef GLMULTITEXCOORD3FVARB_DECL
  #define GLMULTITEXCOORD3FVARB_DECL
  csGLMULTITEXCOORD3FVARB glMultiTexCoord3fvARB;
  #endif

  #ifndef GLMULTITEXCOORD3IARB_DECL
  #define GLMULTITEXCOORD3IARB_DECL
  csGLMULTITEXCOORD3IARB glMultiTexCoord3iARB;
  #endif

  #ifndef GLMULTITEXCOORD3IVARB_DECL
  #define GLMULTITEXCOORD3IVARB_DECL
  csGLMULTITEXCOORD3IVARB glMultiTexCoord3ivARB;
  #endif

  #ifndef GLMULTITEXCOORD3SARB_DECL
  #define GLMULTITEXCOORD3SARB_DECL
  csGLMULTITEXCOORD3SARB glMultiTexCoord3sARB;
  #endif

  #ifndef GLMULTITEXCOORD3SVARB_DECL
  #define GLMULTITEXCOORD3SVARB_DECL
  csGLMULTITEXCOORD3SVARB glMultiTexCoord3svARB;
  #endif

  #ifndef GLMULTITEXCOORD4DARB_DECL
  #define GLMULTITEXCOORD4DARB_DECL
  csGLMULTITEXCOORD4DARB glMultiTexCoord4dARB;
  #endif

  #ifndef GLMULTITEXCOORD4DVARB_DECL
  #define GLMULTITEXCOORD4DVARB_DECL
  csGLMULTITEXCOORD4DVARB glMultiTexCoord4dvARB;
  #endif

  #ifndef GLMULTITEXCOORD4FARB_DECL
  #define GLMULTITEXCOORD4FARB_DECL
  csGLMULTITEXCOORD4FARB glMultiTexCoord4fARB;
  #endif

  #ifndef GLMULTITEXCOORD4FVARB_DECL
  #define GLMULTITEXCOORD4FVARB_DECL
  csGLMULTITEXCOORD4FVARB glMultiTexCoord4fvARB;
  #endif

  #ifndef GLMULTITEXCOORD4IARB_DECL
  #define GLMULTITEXCOORD4IARB_DECL
  csGLMULTITEXCOORD4IARB glMultiTexCoord4iARB;
  #endif

  #ifndef GLMULTITEXCOORD4IVARB_DECL
  #define GLMULTITEXCOORD4IVARB_DECL
  csGLMULTITEXCOORD4IVARB glMultiTexCoord4ivARB;
  #endif

  #ifndef GLMULTITEXCOORD4SARB_DECL
  #define GLMULTITEXCOORD4SARB_DECL
  csGLMULTITEXCOORD4SARB glMultiTexCoord4sARB;
  #endif

  #ifndef GLMULTITEXCOORD4SVARB_DECL
  #define GLMULTITEXCOORD4SVARB_DECL
  csGLMULTITEXCOORD4SVARB glMultiTexCoord4svARB;
  #endif


  // GL_ARB_transpose_matrix
  #ifndef GLLOADTRANSPOSEMATRIXFARB_DECL
  #define GLLOADTRANSPOSEMATRIXFARB_DECL
  csGLLOADTRANSPOSEMATRIXFARB glLoadTransposeMatrixfARB;
  #endif

  #ifndef GLLOADTRANSPOSEMATRIXDARB_DECL
  #define GLLOADTRANSPOSEMATRIXDARB_DECL
  csGLLOADTRANSPOSEMATRIXDARB glLoadTransposeMatrixdARB;
  #endif

  #ifndef GLMULTTRANSPOSEMATRIXFARB_DECL
  #define GLMULTTRANSPOSEMATRIXFARB_DECL
  csGLMULTTRANSPOSEMATRIXFARB glMultTransposeMatrixfARB;
  #endif

  #ifndef GLMULTTRANSPOSEMATRIXDARB_DECL
  #define GLMULTTRANSPOSEMATRIXDARB_DECL
  csGLMULTTRANSPOSEMATRIXDARB glMultTransposeMatrixdARB;
  #endif


  // GL_ARB_multisample
  #ifndef GLSAMPLECOVERAGEARB_DECL
  #define GLSAMPLECOVERAGEARB_DECL
  csGLSAMPLECOVERAGEARB glSampleCoverageARB;
  #endif


  // GL_ARB_texture_env_add

  // WGL_ARB_extensions_string
#ifdef _WIN32
  #ifndef WGLGETEXTENSIONSSTRINGARB_DECL
  #define WGLGETEXTENSIONSSTRINGARB_DECL
  csWGLGETEXTENSIONSSTRINGARB wglGetExtensionsStringARB;
  #endif


#endif // _WIN32

  // WGL_ARB_buffer_region
#ifdef _WIN32
  #ifndef WGLCREATEBUFFERREGIONARB_DECL
  #define WGLCREATEBUFFERREGIONARB_DECL
  csWGLCREATEBUFFERREGIONARB wglCreateBufferRegionARB;
  #endif

  #ifndef WGLDELETEBUFFERREGIONARB_DECL
  #define WGLDELETEBUFFERREGIONARB_DECL
  csWGLDELETEBUFFERREGIONARB wglDeleteBufferRegionARB;
  #endif

  #ifndef WGLSAVEBUFFERREGIONARB_DECL
  #define WGLSAVEBUFFERREGIONARB_DECL
  csWGLSAVEBUFFERREGIONARB wglSaveBufferRegionARB;
  #endif

  #ifndef WGLRESTOREBUFFERREGIONARB_DECL
  #define WGLRESTOREBUFFERREGIONARB_DECL
  csWGLRESTOREBUFFERREGIONARB wglRestoreBufferRegionARB;
  #endif


#endif // _WIN32

  // GL_ARB_texture_cube_map

  // GL_ARB_depth_texture

  // GL_ARB_point_parameters
  #ifndef GLPOINTPARAMETERFARB_DECL
  #define GLPOINTPARAMETERFARB_DECL
  csGLPOINTPARAMETERFARB glPointParameterfARB;
  #endif

  #ifndef GLPOINTPARAMETERFVARB_DECL
  #define GLPOINTPARAMETERFVARB_DECL
  csGLPOINTPARAMETERFVARB glPointParameterfvARB;
  #endif


  // GL_ARB_shadow

  // GL_ARB_shadow_ambient

  // GL_ARB_texture_border_clamp

  // GL_ARB_texture_compression
  #ifndef GLCOMPRESSEDTEXIMAGE3DARB_DECL
  #define GLCOMPRESSEDTEXIMAGE3DARB_DECL
  csGLCOMPRESSEDTEXIMAGE3DARB glCompressedTexImage3DARB;
  #endif

  #ifndef GLCOMPRESSEDTEXIMAGE2DARB_DECL
  #define GLCOMPRESSEDTEXIMAGE2DARB_DECL
  csGLCOMPRESSEDTEXIMAGE2DARB glCompressedTexImage2DARB;
  #endif

  #ifndef GLCOMPRESSEDTEXIMAGE1DARB_DECL
  #define GLCOMPRESSEDTEXIMAGE1DARB_DECL
  csGLCOMPRESSEDTEXIMAGE1DARB glCompressedTexImage1DARB;
  #endif

  #ifndef GLCOMPRESSEDTEXSUBIMAGE3DARB_DECL
  #define GLCOMPRESSEDTEXSUBIMAGE3DARB_DECL
  csGLCOMPRESSEDTEXSUBIMAGE3DARB glCompressedTexSubImage3DARB;
  #endif

  #ifndef GLCOMPRESSEDTEXSUBIMAGE2DARB_DECL
  #define GLCOMPRESSEDTEXSUBIMAGE2DARB_DECL
  csGLCOMPRESSEDTEXSUBIMAGE2DARB glCompressedTexSubImage2DARB;
  #endif

  #ifndef GLCOMPRESSEDTEXSUBIMAGE1DARB_DECL
  #define GLCOMPRESSEDTEXSUBIMAGE1DARB_DECL
  csGLCOMPRESSEDTEXSUBIMAGE1DARB glCompressedTexSubImage1DARB;
  #endif

  #ifndef GLGETCOMPRESSEDTEXIMAGEARB_DECL
  #define GLGETCOMPRESSEDTEXIMAGEARB_DECL
  csGLGETCOMPRESSEDTEXIMAGEARB glGetCompressedTexImageARB;
  #endif


  // GL_ARB_texture_env_combine

  // GL_ARB_texture_env_crossbar

  // GL_ARB_texture_env_dot3

  // GL_ARB_texture_mirrored_repeat

  // GL_ARB_vertex_blend
  #ifndef GLWEIGHTBVARB_DECL
  #define GLWEIGHTBVARB_DECL
  csGLWEIGHTBVARB glWeightbvARB;
  #endif

  #ifndef GLWEIGHTSVARB_DECL
  #define GLWEIGHTSVARB_DECL
  csGLWEIGHTSVARB glWeightsvARB;
  #endif

  #ifndef GLWEIGHTIVARB_DECL
  #define GLWEIGHTIVARB_DECL
  csGLWEIGHTIVARB glWeightivARB;
  #endif

  #ifndef GLWEIGHTFVARB_DECL
  #define GLWEIGHTFVARB_DECL
  csGLWEIGHTFVARB glWeightfvARB;
  #endif

  #ifndef GLWEIGHTDVARB_DECL
  #define GLWEIGHTDVARB_DECL
  csGLWEIGHTDVARB glWeightdvARB;
  #endif

  #ifndef GLWEIGHTVARB_DECL
  #define GLWEIGHTVARB_DECL
  csGLWEIGHTVARB glWeightvARB;
  #endif

  #ifndef GLWEIGHTUBVARB_DECL
  #define GLWEIGHTUBVARB_DECL
  csGLWEIGHTUBVARB glWeightubvARB;
  #endif

  #ifndef GLWEIGHTUSVARB_DECL
  #define GLWEIGHTUSVARB_DECL
  csGLWEIGHTUSVARB glWeightusvARB;
  #endif

  #ifndef GLWEIGHTUIVARB_DECL
  #define GLWEIGHTUIVARB_DECL
  csGLWEIGHTUIVARB glWeightuivARB;
  #endif

  #ifndef GLWEIGHTPOINTERARB_DECL
  #define GLWEIGHTPOINTERARB_DECL
  csGLWEIGHTPOINTERARB glWeightPointerARB;
  #endif

  #ifndef GLVERTEXBLENDARB_DECL
  #define GLVERTEXBLENDARB_DECL
  csGLVERTEXBLENDARB glVertexBlendARB;
  #endif


  // GL_ARB_vertex_program
  #ifndef GLVERTEXATTRIB1SARB_DECL
  #define GLVERTEXATTRIB1SARB_DECL
  csGLVERTEXATTRIB1SARB glVertexAttrib1sARB;
  #endif

  #ifndef GLVERTEXATTRIB1FARB_DECL
  #define GLVERTEXATTRIB1FARB_DECL
  csGLVERTEXATTRIB1FARB glVertexAttrib1fARB;
  #endif

  #ifndef GLVERTEXATTRIB1DARB_DECL
  #define GLVERTEXATTRIB1DARB_DECL
  csGLVERTEXATTRIB1DARB glVertexAttrib1dARB;
  #endif

  #ifndef GLVERTEXATTRIB2SARB_DECL
  #define GLVERTEXATTRIB2SARB_DECL
  csGLVERTEXATTRIB2SARB glVertexAttrib2sARB;
  #endif

  #ifndef GLVERTEXATTRIB2FARB_DECL
  #define GLVERTEXATTRIB2FARB_DECL
  csGLVERTEXATTRIB2FARB glVertexAttrib2fARB;
  #endif

  #ifndef GLVERTEXATTRIB2DARB_DECL
  #define GLVERTEXATTRIB2DARB_DECL
  csGLVERTEXATTRIB2DARB glVertexAttrib2dARB;
  #endif

  #ifndef GLVERTEXATTRIB3SARB_DECL
  #define GLVERTEXATTRIB3SARB_DECL
  csGLVERTEXATTRIB3SARB glVertexAttrib3sARB;
  #endif

  #ifndef GLVERTEXATTRIB3FARB_DECL
  #define GLVERTEXATTRIB3FARB_DECL
  csGLVERTEXATTRIB3FARB glVertexAttrib3fARB;
  #endif

  #ifndef GLVERTEXATTRIB3DARB_DECL
  #define GLVERTEXATTRIB3DARB_DECL
  csGLVERTEXATTRIB3DARB glVertexAttrib3dARB;
  #endif

  #ifndef GLVERTEXATTRIB4SARB_DECL
  #define GLVERTEXATTRIB4SARB_DECL
  csGLVERTEXATTRIB4SARB glVertexAttrib4sARB;
  #endif

  #ifndef GLVERTEXATTRIB4FARB_DECL
  #define GLVERTEXATTRIB4FARB_DECL
  csGLVERTEXATTRIB4FARB glVertexAttrib4fARB;
  #endif

  #ifndef GLVERTEXATTRIB4DARB_DECL
  #define GLVERTEXATTRIB4DARB_DECL
  csGLVERTEXATTRIB4DARB glVertexAttrib4dARB;
  #endif

  #ifndef GLVERTEXATTRIB4NUBARB_DECL
  #define GLVERTEXATTRIB4NUBARB_DECL
  csGLVERTEXATTRIB4NUBARB glVertexAttrib4NubARB;
  #endif

  #ifndef GLVERTEXATTRIB1SVARB_DECL
  #define GLVERTEXATTRIB1SVARB_DECL
  csGLVERTEXATTRIB1SVARB glVertexAttrib1svARB;
  #endif

  #ifndef GLVERTEXATTRIB1FVARB_DECL
  #define GLVERTEXATTRIB1FVARB_DECL
  csGLVERTEXATTRIB1FVARB glVertexAttrib1fvARB;
  #endif

  #ifndef GLVERTEXATTRIB1DVARB_DECL
  #define GLVERTEXATTRIB1DVARB_DECL
  csGLVERTEXATTRIB1DVARB glVertexAttrib1dvARB;
  #endif

  #ifndef GLVERTEXATTRIB2SVARB_DECL
  #define GLVERTEXATTRIB2SVARB_DECL
  csGLVERTEXATTRIB2SVARB glVertexAttrib2svARB;
  #endif

  #ifndef GLVERTEXATTRIB2FVARB_DECL
  #define GLVERTEXATTRIB2FVARB_DECL
  csGLVERTEXATTRIB2FVARB glVertexAttrib2fvARB;
  #endif

  #ifndef GLVERTEXATTRIB2DVARB_DECL
  #define GLVERTEXATTRIB2DVARB_DECL
  csGLVERTEXATTRIB2DVARB glVertexAttrib2dvARB;
  #endif

  #ifndef GLVERTEXATTRIB3SVARB_DECL
  #define GLVERTEXATTRIB3SVARB_DECL
  csGLVERTEXATTRIB3SVARB glVertexAttrib3svARB;
  #endif

  #ifndef GLVERTEXATTRIB3FVARB_DECL
  #define GLVERTEXATTRIB3FVARB_DECL
  csGLVERTEXATTRIB3FVARB glVertexAttrib3fvARB;
  #endif

  #ifndef GLVERTEXATTRIB3DVARB_DECL
  #define GLVERTEXATTRIB3DVARB_DECL
  csGLVERTEXATTRIB3DVARB glVertexAttrib3dvARB;
  #endif

  #ifndef GLVERTEXATTRIB4BVARB_DECL
  #define GLVERTEXATTRIB4BVARB_DECL
  csGLVERTEXATTRIB4BVARB glVertexAttrib4bvARB;
  #endif

  #ifndef GLVERTEXATTRIB4SVARB_DECL
  #define GLVERTEXATTRIB4SVARB_DECL
  csGLVERTEXATTRIB4SVARB glVertexAttrib4svARB;
  #endif

  #ifndef GLVERTEXATTRIB4IVARB_DECL
  #define GLVERTEXATTRIB4IVARB_DECL
  csGLVERTEXATTRIB4IVARB glVertexAttrib4ivARB;
  #endif

  #ifndef GLVERTEXATTRIB4UBVARB_DECL
  #define GLVERTEXATTRIB4UBVARB_DECL
  csGLVERTEXATTRIB4UBVARB glVertexAttrib4ubvARB;
  #endif

  #ifndef GLVERTEXATTRIB4USVARB_DECL
  #define GLVERTEXATTRIB4USVARB_DECL
  csGLVERTEXATTRIB4USVARB glVertexAttrib4usvARB;
  #endif

  #ifndef GLVERTEXATTRIB4UIVARB_DECL
  #define GLVERTEXATTRIB4UIVARB_DECL
  csGLVERTEXATTRIB4UIVARB glVertexAttrib4uivARB;
  #endif

  #ifndef GLVERTEXATTRIB4FVARB_DECL
  #define GLVERTEXATTRIB4FVARB_DECL
  csGLVERTEXATTRIB4FVARB glVertexAttrib4fvARB;
  #endif

  #ifndef GLVERTEXATTRIB4DVARB_DECL
  #define GLVERTEXATTRIB4DVARB_DECL
  csGLVERTEXATTRIB4DVARB glVertexAttrib4dvARB;
  #endif

  #ifndef GLVERTEXATTRIB4NBVARB_DECL
  #define GLVERTEXATTRIB4NBVARB_DECL
  csGLVERTEXATTRIB4NBVARB glVertexAttrib4NbvARB;
  #endif

  #ifndef GLVERTEXATTRIB4NSVARB_DECL
  #define GLVERTEXATTRIB4NSVARB_DECL
  csGLVERTEXATTRIB4NSVARB glVertexAttrib4NsvARB;
  #endif

  #ifndef GLVERTEXATTRIB4NIVARB_DECL
  #define GLVERTEXATTRIB4NIVARB_DECL
  csGLVERTEXATTRIB4NIVARB glVertexAttrib4NivARB;
  #endif

  #ifndef GLVERTEXATTRIB4NUBVARB_DECL
  #define GLVERTEXATTRIB4NUBVARB_DECL
  csGLVERTEXATTRIB4NUBVARB glVertexAttrib4NubvARB;
  #endif

  #ifndef GLVERTEXATTRIB4NUSVARB_DECL
  #define GLVERTEXATTRIB4NUSVARB_DECL
  csGLVERTEXATTRIB4NUSVARB glVertexAttrib4NusvARB;
  #endif

  #ifndef GLVERTEXATTRIB4NUIVARB_DECL
  #define GLVERTEXATTRIB4NUIVARB_DECL
  csGLVERTEXATTRIB4NUIVARB glVertexAttrib4NuivARB;
  #endif

  #ifndef GLVERTEXATTRIBPOINTERARB_DECL
  #define GLVERTEXATTRIBPOINTERARB_DECL
  csGLVERTEXATTRIBPOINTERARB glVertexAttribPointerARB;
  #endif

  #ifndef GLENABLEVERTEXATTRIBARRAYARB_DECL
  #define GLENABLEVERTEXATTRIBARRAYARB_DECL
  csGLENABLEVERTEXATTRIBARRAYARB glEnableVertexAttribArrayARB;
  #endif

  #ifndef GLDISABLEVERTEXATTRIBARRAYARB_DECL
  #define GLDISABLEVERTEXATTRIBARRAYARB_DECL
  csGLDISABLEVERTEXATTRIBARRAYARB glDisableVertexAttribArrayARB;
  #endif

  #ifndef GLPROGRAMSTRINGARB_DECL
  #define GLPROGRAMSTRINGARB_DECL
  csGLPROGRAMSTRINGARB glProgramStringARB;
  #endif

  #ifndef GLBINDPROGRAMARB_DECL
  #define GLBINDPROGRAMARB_DECL
  csGLBINDPROGRAMARB glBindProgramARB;
  #endif

  #ifndef GLDELETEPROGRAMSARB_DECL
  #define GLDELETEPROGRAMSARB_DECL
  csGLDELETEPROGRAMSARB glDeleteProgramsARB;
  #endif

  #ifndef GLGENPROGRAMSARB_DECL
  #define GLGENPROGRAMSARB_DECL
  csGLGENPROGRAMSARB glGenProgramsARB;
  #endif

  #ifndef GLPROGRAMENVPARAMETER4DARB_DECL
  #define GLPROGRAMENVPARAMETER4DARB_DECL
  csGLPROGRAMENVPARAMETER4DARB glProgramEnvParameter4dARB;
  #endif

  #ifndef GLPROGRAMENVPARAMETER4DVARB_DECL
  #define GLPROGRAMENVPARAMETER4DVARB_DECL
  csGLPROGRAMENVPARAMETER4DVARB glProgramEnvParameter4dvARB;
  #endif

  #ifndef GLPROGRAMENVPARAMETER4FARB_DECL
  #define GLPROGRAMENVPARAMETER4FARB_DECL
  csGLPROGRAMENVPARAMETER4FARB glProgramEnvParameter4fARB;
  #endif

  #ifndef GLPROGRAMENVPARAMETER4FVARB_DECL
  #define GLPROGRAMENVPARAMETER4FVARB_DECL
  csGLPROGRAMENVPARAMETER4FVARB glProgramEnvParameter4fvARB;
  #endif

  #ifndef GLPROGRAMLOCALPARAMETER4DARB_DECL
  #define GLPROGRAMLOCALPARAMETER4DARB_DECL
  csGLPROGRAMLOCALPARAMETER4DARB glProgramLocalParameter4dARB;
  #endif

  #ifndef GLPROGRAMLOCALPARAMETER4DVARB_DECL
  #define GLPROGRAMLOCALPARAMETER4DVARB_DECL
  csGLPROGRAMLOCALPARAMETER4DVARB glProgramLocalParameter4dvARB;
  #endif

  #ifndef GLPROGRAMLOCALPARAMETER4FARB_DECL
  #define GLPROGRAMLOCALPARAMETER4FARB_DECL
  csGLPROGRAMLOCALPARAMETER4FARB glProgramLocalParameter4fARB;
  #endif

  #ifndef GLPROGRAMLOCALPARAMETER4FVARB_DECL
  #define GLPROGRAMLOCALPARAMETER4FVARB_DECL
  csGLPROGRAMLOCALPARAMETER4FVARB glProgramLocalParameter4fvARB;
  #endif

  #ifndef GLGETPROGRAMENVPARAMETERDVARB_DECL
  #define GLGETPROGRAMENVPARAMETERDVARB_DECL
  csGLGETPROGRAMENVPARAMETERDVARB glGetProgramEnvParameterdvARB;
  #endif

  #ifndef GLGETPROGRAMENVPARAMETERFVARB_DECL
  #define GLGETPROGRAMENVPARAMETERFVARB_DECL
  csGLGETPROGRAMENVPARAMETERFVARB glGetProgramEnvParameterfvARB;
  #endif

  #ifndef GLGETPROGRAMLOCALPARAMETERDVARB_DECL
  #define GLGETPROGRAMLOCALPARAMETERDVARB_DECL
  csGLGETPROGRAMLOCALPARAMETERDVARB glGetProgramLocalParameterdvARB;
  #endif

  #ifndef GLGETPROGRAMLOCALPARAMETERFVARB_DECL
  #define GLGETPROGRAMLOCALPARAMETERFVARB_DECL
  csGLGETPROGRAMLOCALPARAMETERFVARB glGetProgramLocalParameterfvARB;
  #endif

  #ifndef GLGETPROGRAMIVARB_DECL
  #define GLGETPROGRAMIVARB_DECL
  csGLGETPROGRAMIVARB glGetProgramivARB;
  #endif

  #ifndef GLGETPROGRAMSTRINGARB_DECL
  #define GLGETPROGRAMSTRINGARB_DECL
  csGLGETPROGRAMSTRINGARB glGetProgramStringARB;
  #endif

  #ifndef GLGETVERTEXATTRIBDVARB_DECL
  #define GLGETVERTEXATTRIBDVARB_DECL
  csGLGETVERTEXATTRIBDVARB glGetVertexAttribdvARB;
  #endif

  #ifndef GLGETVERTEXATTRIBFVARB_DECL
  #define GLGETVERTEXATTRIBFVARB_DECL
  csGLGETVERTEXATTRIBFVARB glGetVertexAttribfvARB;
  #endif

  #ifndef GLGETVERTEXATTRIBIVARB_DECL
  #define GLGETVERTEXATTRIBIVARB_DECL
  csGLGETVERTEXATTRIBIVARB glGetVertexAttribivARB;
  #endif

  #ifndef GLGETVERTEXATTRIBPOINTERVARB_DECL
  #define GLGETVERTEXATTRIBPOINTERVARB_DECL
  csGLGETVERTEXATTRIBPOINTERVARB glGetVertexAttribPointervARB;
  #endif

  #ifndef GLISPROGRAMARB_DECL
  #define GLISPROGRAMARB_DECL
  csGLISPROGRAMARB glIsProgramARB;
  #endif


  // GL_ARB_window_pos
  #ifndef GLWINDOWPOS2DARB_DECL
  #define GLWINDOWPOS2DARB_DECL
  csGLWINDOWPOS2DARB glWindowPos2dARB;
  #endif

  #ifndef GLWINDOWPOS2FARB_DECL
  #define GLWINDOWPOS2FARB_DECL
  csGLWINDOWPOS2FARB glWindowPos2fARB;
  #endif

  #ifndef GLWINDOWPOS2IARB_DECL
  #define GLWINDOWPOS2IARB_DECL
  csGLWINDOWPOS2IARB glWindowPos2iARB;
  #endif

  #ifndef GLWINDOWPOS2SARB_DECL
  #define GLWINDOWPOS2SARB_DECL
  csGLWINDOWPOS2SARB glWindowPos2sARB;
  #endif

  #ifndef GLWINDOWPOS2DVARB_DECL
  #define GLWINDOWPOS2DVARB_DECL
  csGLWINDOWPOS2DVARB glWindowPos2dvARB;
  #endif

  #ifndef GLWINDOWPOS2FVARB_DECL
  #define GLWINDOWPOS2FVARB_DECL
  csGLWINDOWPOS2FVARB glWindowPos2fvARB;
  #endif

  #ifndef GLWINDOWPOS2IVARB_DECL
  #define GLWINDOWPOS2IVARB_DECL
  csGLWINDOWPOS2IVARB glWindowPos2ivARB;
  #endif

  #ifndef GLWINDOWPOS2SVARB_DECL
  #define GLWINDOWPOS2SVARB_DECL
  csGLWINDOWPOS2SVARB glWindowPos2svARB;
  #endif

  #ifndef GLWINDOWPOS3DARB_DECL
  #define GLWINDOWPOS3DARB_DECL
  csGLWINDOWPOS3DARB glWindowPos3dARB;
  #endif

  #ifndef GLWINDOWPOS3FARB_DECL
  #define GLWINDOWPOS3FARB_DECL
  csGLWINDOWPOS3FARB glWindowPos3fARB;
  #endif

  #ifndef GLWINDOWPOS3IARB_DECL
  #define GLWINDOWPOS3IARB_DECL
  csGLWINDOWPOS3IARB glWindowPos3iARB;
  #endif

  #ifndef GLWINDOWPOS3SARB_DECL
  #define GLWINDOWPOS3SARB_DECL
  csGLWINDOWPOS3SARB glWindowPos3sARB;
  #endif

  #ifndef GLWINDOWPOS3DVARB_DECL
  #define GLWINDOWPOS3DVARB_DECL
  csGLWINDOWPOS3DVARB glWindowPos3dvARB;
  #endif

  #ifndef GLWINDOWPOS3FVARB_DECL
  #define GLWINDOWPOS3FVARB_DECL
  csGLWINDOWPOS3FVARB glWindowPos3fvARB;
  #endif

  #ifndef GLWINDOWPOS3IVARB_DECL
  #define GLWINDOWPOS3IVARB_DECL
  csGLWINDOWPOS3IVARB glWindowPos3ivARB;
  #endif

  #ifndef GLWINDOWPOS3SVARB_DECL
  #define GLWINDOWPOS3SVARB_DECL
  csGLWINDOWPOS3SVARB glWindowPos3svARB;
  #endif


  // GL_EXT_422_pixels

  // GL_EXT_abgr

  // GL_EXT_bgra

  // GL_EXT_blend_color
  #ifndef GLBLENDCOLOREXT_DECL
  #define GLBLENDCOLOREXT_DECL
  csGLBLENDCOLOREXT glBlendColorEXT;
  #endif


  // GL_EXT_blend_func_separate
  #ifndef GLBLENDFUNCSEPARATEEXT_DECL
  #define GLBLENDFUNCSEPARATEEXT_DECL
  csGLBLENDFUNCSEPARATEEXT glBlendFuncSeparateEXT;
  #endif


  // GL_EXT_blend_logic_op

  // GL_EXT_blend_minmax
  #ifndef GLBLENDEQUATIONEXT_DECL
  #define GLBLENDEQUATIONEXT_DECL
  csGLBLENDEQUATIONEXT glBlendEquationEXT;
  #endif


  // GL_EXT_blend_subtract

  // GL_EXT_clip_volume_hint

  // GL_EXT_color_subtable
  #ifndef GLCOLORSUBTABLEEXT_DECL
  #define GLCOLORSUBTABLEEXT_DECL
  csGLCOLORSUBTABLEEXT glColorSubTableEXT;
  #endif

  #ifndef GLCOPYCOLORSUBTABLEEXT_DECL
  #define GLCOPYCOLORSUBTABLEEXT_DECL
  csGLCOPYCOLORSUBTABLEEXT glCopyColorSubTableEXT;
  #endif


  // GL_EXT_compiled_vertex_array
  #ifndef GLLOCKARRAYSEXT_DECL
  #define GLLOCKARRAYSEXT_DECL
  csGLLOCKARRAYSEXT glLockArraysEXT;
  #endif

  #ifndef GLUNLOCKARRAYSEXT_DECL
  #define GLUNLOCKARRAYSEXT_DECL
  csGLUNLOCKARRAYSEXT glUnlockArraysEXT;
  #endif


  // GL_EXT_convolution
  #ifndef GLCONVOLUTIONFILTER1DEXT_DECL
  #define GLCONVOLUTIONFILTER1DEXT_DECL
  csGLCONVOLUTIONFILTER1DEXT glConvolutionFilter1DEXT;
  #endif

  #ifndef GLCONVOLUTIONFILTER2DEXT_DECL
  #define GLCONVOLUTIONFILTER2DEXT_DECL
  csGLCONVOLUTIONFILTER2DEXT glConvolutionFilter2DEXT;
  #endif

  #ifndef GLCOPYCONVOLUTIONFILTER1DEXT_DECL
  #define GLCOPYCONVOLUTIONFILTER1DEXT_DECL
  csGLCOPYCONVOLUTIONFILTER1DEXT glCopyConvolutionFilter1DEXT;
  #endif

  #ifndef GLCOPYCONVOLUTIONFILTER2DEXT_DECL
  #define GLCOPYCONVOLUTIONFILTER2DEXT_DECL
  csGLCOPYCONVOLUTIONFILTER2DEXT glCopyConvolutionFilter2DEXT;
  #endif

  #ifndef GLGETCONVOLUTIONFILTEREXT_DECL
  #define GLGETCONVOLUTIONFILTEREXT_DECL
  csGLGETCONVOLUTIONFILTEREXT glGetConvolutionFilterEXT;
  #endif

  #ifndef GLSEPARABLEFILTER2DEXT_DECL
  #define GLSEPARABLEFILTER2DEXT_DECL
  csGLSEPARABLEFILTER2DEXT glSeparableFilter2DEXT;
  #endif

  #ifndef GLGETSEPARABLEFILTEREXT_DECL
  #define GLGETSEPARABLEFILTEREXT_DECL
  csGLGETSEPARABLEFILTEREXT glGetSeparableFilterEXT;
  #endif

  #ifndef GLCONVOLUTIONPARAMETERIEXT_DECL
  #define GLCONVOLUTIONPARAMETERIEXT_DECL
  csGLCONVOLUTIONPARAMETERIEXT glConvolutionParameteriEXT;
  #endif

  #ifndef GLCONVOLUTIONPARAMETERIVEXT_DECL
  #define GLCONVOLUTIONPARAMETERIVEXT_DECL
  csGLCONVOLUTIONPARAMETERIVEXT glConvolutionParameterivEXT;
  #endif

  #ifndef GLCONVOLUTIONPARAMETERFEXT_DECL
  #define GLCONVOLUTIONPARAMETERFEXT_DECL
  csGLCONVOLUTIONPARAMETERFEXT glConvolutionParameterfEXT;
  #endif

  #ifndef GLCONVOLUTIONPARAMETERFVEXT_DECL
  #define GLCONVOLUTIONPARAMETERFVEXT_DECL
  csGLCONVOLUTIONPARAMETERFVEXT glConvolutionParameterfvEXT;
  #endif

  #ifndef GLGETCONVOLUTIONPARAMETERIVEXT_DECL
  #define GLGETCONVOLUTIONPARAMETERIVEXT_DECL
  csGLGETCONVOLUTIONPARAMETERIVEXT glGetConvolutionParameterivEXT;
  #endif

  #ifndef GLGETCONVOLUTIONPARAMETERFVEXT_DECL
  #define GLGETCONVOLUTIONPARAMETERFVEXT_DECL
  csGLGETCONVOLUTIONPARAMETERFVEXT glGetConvolutionParameterfvEXT;
  #endif


  // GL_EXT_fog_coord
  #ifndef GLFOGCOORDFEXFLOAT_DECL
  #define GLFOGCOORDFEXFLOAT_DECL
  csGLFOGCOORDFEXFLOAT glFogCoordfEXfloat;
  #endif

  #ifndef GLFOGCOORDDEXDOUBLE_DECL
  #define GLFOGCOORDDEXDOUBLE_DECL
  csGLFOGCOORDDEXDOUBLE glFogCoorddEXdouble;
  #endif

  #ifndef GLFOGCOORDFVEXFLOAT_DECL
  #define GLFOGCOORDFVEXFLOAT_DECL
  csGLFOGCOORDFVEXFLOAT glFogCoordfvEXfloat;
  #endif

  #ifndef GLFOGCOORDDVEXDOUBLE_DECL
  #define GLFOGCOORDDVEXDOUBLE_DECL
  csGLFOGCOORDDVEXDOUBLE glFogCoorddvEXdouble;
  #endif

  #ifndef GLFOGCOORDPOINTEREXT_DECL
  #define GLFOGCOORDPOINTEREXT_DECL
  csGLFOGCOORDPOINTEREXT glFogCoordPointerEXT;
  #endif


  // GL_EXT_histogram
  #ifndef GLHISTOGRAMEXT_DECL
  #define GLHISTOGRAMEXT_DECL
  csGLHISTOGRAMEXT glHistogramEXT;
  #endif

  #ifndef GLRESETHISTOGRAMEXT_DECL
  #define GLRESETHISTOGRAMEXT_DECL
  csGLRESETHISTOGRAMEXT glResetHistogramEXT;
  #endif

  #ifndef GLGETHISTOGRAMEXT_DECL
  #define GLGETHISTOGRAMEXT_DECL
  csGLGETHISTOGRAMEXT glGetHistogramEXT;
  #endif

  #ifndef GLGETHISTOGRAMPARAMETERIVEXT_DECL
  #define GLGETHISTOGRAMPARAMETERIVEXT_DECL
  csGLGETHISTOGRAMPARAMETERIVEXT glGetHistogramParameterivEXT;
  #endif

  #ifndef GLGETHISTOGRAMPARAMETERFVEXT_DECL
  #define GLGETHISTOGRAMPARAMETERFVEXT_DECL
  csGLGETHISTOGRAMPARAMETERFVEXT glGetHistogramParameterfvEXT;
  #endif

  #ifndef GLMINMAXEXT_DECL
  #define GLMINMAXEXT_DECL
  csGLMINMAXEXT glMinmaxEXT;
  #endif

  #ifndef GLRESETMINMAXEXT_DECL
  #define GLRESETMINMAXEXT_DECL
  csGLRESETMINMAXEXT glResetMinmaxEXT;
  #endif

  #ifndef GLGETMINMAXEXT_DECL
  #define GLGETMINMAXEXT_DECL
  csGLGETMINMAXEXT glGetMinmaxEXT;
  #endif

  #ifndef GLGETMINMAXPARAMETERIVEXT_DECL
  #define GLGETMINMAXPARAMETERIVEXT_DECL
  csGLGETMINMAXPARAMETERIVEXT glGetMinmaxParameterivEXT;
  #endif

  #ifndef GLGETMINMAXPARAMETERFVEXT_DECL
  #define GLGETMINMAXPARAMETERFVEXT_DECL
  csGLGETMINMAXPARAMETERFVEXT glGetMinmaxParameterfvEXT;
  #endif


  // GL_EXT_multi_draw_arrays
  #ifndef GLMULTIDRAWARRAYSEXT_DECL
  #define GLMULTIDRAWARRAYSEXT_DECL
  csGLMULTIDRAWARRAYSEXT glMultiDrawArraysEXT;
  #endif

  #ifndef GLMULTIDRAWELEMENTSEXT_DECL
  #define GLMULTIDRAWELEMENTSEXT_DECL
  csGLMULTIDRAWELEMENTSEXT glMultiDrawElementsEXT;
  #endif


  // GL_EXT_packed_pixels

  // GL_EXT_paletted_texture
  #ifndef GLCOLORTABLEEXT_DECL
  #define GLCOLORTABLEEXT_DECL
  csGLCOLORTABLEEXT glColorTableEXT;
  #endif

  #ifndef GLGETCOLORTABLEEXT_DECL
  #define GLGETCOLORTABLEEXT_DECL
  csGLGETCOLORTABLEEXT glGetColorTableEXT;
  #endif

  #ifndef GLGETCOLORTABLEPARAMETERIVEXT_DECL
  #define GLGETCOLORTABLEPARAMETERIVEXT_DECL
  csGLGETCOLORTABLEPARAMETERIVEXT glGetColorTableParameterivEXT;
  #endif

  #ifndef GLGETCOLORTABLEPARAMETERFVEXT_DECL
  #define GLGETCOLORTABLEPARAMETERFVEXT_DECL
  csGLGETCOLORTABLEPARAMETERFVEXT glGetColorTableParameterfvEXT;
  #endif


  // GL_EXT_point_parameters
  #ifndef GLPOINTPARAMETERFEXT_DECL
  #define GLPOINTPARAMETERFEXT_DECL
  csGLPOINTPARAMETERFEXT glPointParameterfEXT;
  #endif

  #ifndef GLPOINTPARAMETERFVEXT_DECL
  #define GLPOINTPARAMETERFVEXT_DECL
  csGLPOINTPARAMETERFVEXT glPointParameterfvEXT;
  #endif


  // GL_EXT_polygon_offset
  #ifndef GLPOLYGONOFFSETEXT_DECL
  #define GLPOLYGONOFFSETEXT_DECL
  csGLPOLYGONOFFSETEXT glPolygonOffsetEXT;
  #endif


  // GL_EXT_secondary_color
  #ifndef GLSECONDARYCOLOR3BEXT_DECL
  #define GLSECONDARYCOLOR3BEXT_DECL
  csGLSECONDARYCOLOR3BEXT glSecondaryColor3bEXT;
  #endif

  #ifndef GLSECONDARYCOLOR3SEXT_DECL
  #define GLSECONDARYCOLOR3SEXT_DECL
  csGLSECONDARYCOLOR3SEXT glSecondaryColor3sEXT;
  #endif

  #ifndef GLSECONDARYCOLOR3IEXT_DECL
  #define GLSECONDARYCOLOR3IEXT_DECL
  csGLSECONDARYCOLOR3IEXT glSecondaryColor3iEXT;
  #endif

  #ifndef GLSECONDARYCOLOR3FEXT_DECL
  #define GLSECONDARYCOLOR3FEXT_DECL
  csGLSECONDARYCOLOR3FEXT glSecondaryColor3fEXT;
  #endif

  #ifndef GLSECONDARYCOLOR3DEXT_DECL
  #define GLSECONDARYCOLOR3DEXT_DECL
  csGLSECONDARYCOLOR3DEXT glSecondaryColor3dEXT;
  #endif

  #ifndef GLSECONDARYCOLOR3UBEXT_DECL
  #define GLSECONDARYCOLOR3UBEXT_DECL
  csGLSECONDARYCOLOR3UBEXT glSecondaryColor3ubEXT;
  #endif

  #ifndef GLSECONDARYCOLOR3USEXT_DECL
  #define GLSECONDARYCOLOR3USEXT_DECL
  csGLSECONDARYCOLOR3USEXT glSecondaryColor3usEXT;
  #endif

  #ifndef GLSECONDARYCOLOR3UIEXT_DECL
  #define GLSECONDARYCOLOR3UIEXT_DECL
  csGLSECONDARYCOLOR3UIEXT glSecondaryColor3uiEXT;
  #endif

  #ifndef GLSECONDARYCOLOR3BVEXT_DECL
  #define GLSECONDARYCOLOR3BVEXT_DECL
  csGLSECONDARYCOLOR3BVEXT glSecondaryColor3bvEXT;
  #endif

  #ifndef GLSECONDARYCOLOR3SVEXT_DECL
  #define GLSECONDARYCOLOR3SVEXT_DECL
  csGLSECONDARYCOLOR3SVEXT glSecondaryColor3svEXT;
  #endif

  #ifndef GLSECONDARYCOLOR3IVEXT_DECL
  #define GLSECONDARYCOLOR3IVEXT_DECL
  csGLSECONDARYCOLOR3IVEXT glSecondaryColor3ivEXT;
  #endif

  #ifndef GLSECONDARYCOLOR3FVEXT_DECL
  #define GLSECONDARYCOLOR3FVEXT_DECL
  csGLSECONDARYCOLOR3FVEXT glSecondaryColor3fvEXT;
  #endif

  #ifndef GLSECONDARYCOLOR3DVEXT_DECL
  #define GLSECONDARYCOLOR3DVEXT_DECL
  csGLSECONDARYCOLOR3DVEXT glSecondaryColor3dvEXT;
  #endif

  #ifndef GLSECONDARYCOLOR3UBVEXT_DECL
  #define GLSECONDARYCOLOR3UBVEXT_DECL
  csGLSECONDARYCOLOR3UBVEXT glSecondaryColor3ubvEXT;
  #endif

  #ifndef GLSECONDARYCOLOR3USVEXT_DECL
  #define GLSECONDARYCOLOR3USVEXT_DECL
  csGLSECONDARYCOLOR3USVEXT glSecondaryColor3usvEXT;
  #endif

  #ifndef GLSECONDARYCOLOR3UIVEXT_DECL
  #define GLSECONDARYCOLOR3UIVEXT_DECL
  csGLSECONDARYCOLOR3UIVEXT glSecondaryColor3uivEXT;
  #endif

  #ifndef GLSECONDARYCOLORPOINTEREXT_DECL
  #define GLSECONDARYCOLORPOINTEREXT_DECL
  csGLSECONDARYCOLORPOINTEREXT glSecondaryColorPointerEXT;
  #endif


  // GL_EXT_separate_specular_color

  // GL_EXT_shadow_funcs

  // GL_EXT_shared_texture_palette

  // GL_EXT_stencil_two_side
  #ifndef GLACTIVESTENCILFACEEXT_DECL
  #define GLACTIVESTENCILFACEEXT_DECL
  csGLACTIVESTENCILFACEEXT glActiveStencilFaceEXT;
  #endif


  // GL_EXT_stencil_wrap

  // GL_EXT_subtexture
  #ifndef GLTEXSUBIMAGE1DEXT_DECL
  #define GLTEXSUBIMAGE1DEXT_DECL
  csGLTEXSUBIMAGE1DEXT glTexSubImage1DEXT;
  #endif

  #ifndef GLTEXSUBIMAGE2DEXT_DECL
  #define GLTEXSUBIMAGE2DEXT_DECL
  csGLTEXSUBIMAGE2DEXT glTexSubImage2DEXT;
  #endif

  #ifndef GLTEXSUBIMAGE3DEXT_DECL
  #define GLTEXSUBIMAGE3DEXT_DECL
  csGLTEXSUBIMAGE3DEXT glTexSubImage3DEXT;
  #endif


  // GL_EXT_texture3D
  #ifndef GLTEXIMAGE3DEXT_DECL
  #define GLTEXIMAGE3DEXT_DECL
  csGLTEXIMAGE3DEXT glTexImage3DEXT;
  #endif


  // GL_EXT_texture_compression_s3tc

  // GL_EXT_texture_env_add

  // GL_EXT_texture_env_combine

  // GL_EXT_texture_env_dot3

  // GL_EXT_texture_filter_anisotropic

  // GL_EXT_texture_lod_bias

  // GL_EXT_texture_object
  #ifndef GLGENTEXTURESEXT_DECL
  #define GLGENTEXTURESEXT_DECL
  csGLGENTEXTURESEXT glGenTexturesEXT;
  #endif

  #ifndef GLDELETETEXTURESEXT_DECL
  #define GLDELETETEXTURESEXT_DECL
  csGLDELETETEXTURESEXT glDeleteTexturesEXT;
  #endif

  #ifndef GLBINDTEXTUREEXT_DECL
  #define GLBINDTEXTUREEXT_DECL
  csGLBINDTEXTUREEXT glBindTextureEXT;
  #endif

  #ifndef GLPRIORITIZETEXTURESEXT_DECL
  #define GLPRIORITIZETEXTURESEXT_DECL
  csGLPRIORITIZETEXTURESEXT glPrioritizeTexturesEXT;
  #endif

  #ifndef GLARETEXTURESRESIDENTEXT_DECL
  #define GLARETEXTURESRESIDENTEXT_DECL
  csGLARETEXTURESRESIDENTEXT glAreTexturesResidentEXT;
  #endif

  #ifndef GLISTEXTUREEXT_DECL
  #define GLISTEXTUREEXT_DECL
  csGLISTEXTUREEXT glIsTextureEXT;
  #endif


  // GL_EXT_vertex_array
  #ifndef GLARRAYELEMENTEXT_DECL
  #define GLARRAYELEMENTEXT_DECL
  csGLARRAYELEMENTEXT glArrayElementEXT;
  #endif

  #ifndef GLDRAWARRAYSEXT_DECL
  #define GLDRAWARRAYSEXT_DECL
  csGLDRAWARRAYSEXT glDrawArraysEXT;
  #endif

  #ifndef GLVERTEXPOINTEREXT_DECL
  #define GLVERTEXPOINTEREXT_DECL
  csGLVERTEXPOINTEREXT glVertexPointerEXT;
  #endif

  #ifndef GLNORMALPOINTEREXT_DECL
  #define GLNORMALPOINTEREXT_DECL
  csGLNORMALPOINTEREXT glNormalPointerEXT;
  #endif

  #ifndef GLCOLORPOINTEREXT_DECL
  #define GLCOLORPOINTEREXT_DECL
  csGLCOLORPOINTEREXT glColorPointerEXT;
  #endif

  #ifndef GLINDEXPOINTEREXT_DECL
  #define GLINDEXPOINTEREXT_DECL
  csGLINDEXPOINTEREXT glIndexPointerEXT;
  #endif

  #ifndef GLTEXCOORDPOINTEREXT_DECL
  #define GLTEXCOORDPOINTEREXT_DECL
  csGLTEXCOORDPOINTEREXT glTexCoordPointerEXT;
  #endif

  #ifndef GLEDGEFLAGPOINTEREXT_DECL
  #define GLEDGEFLAGPOINTEREXT_DECL
  csGLEDGEFLAGPOINTEREXT glEdgeFlagPointerEXT;
  #endif

  #ifndef GLGETPOINTERVEXT_DECL
  #define GLGETPOINTERVEXT_DECL
  csGLGETPOINTERVEXT glGetPointervEXT;
  #endif


  // GL_EXT_vertex_shader
  #ifndef GLBEGINVERTEXSHADEREXT_DECL
  #define GLBEGINVERTEXSHADEREXT_DECL
  csGLBEGINVERTEXSHADEREXT glBeginVertexShaderEXT;
  #endif

  #ifndef GLENDVERTEXSHADEREXT_DECL
  #define GLENDVERTEXSHADEREXT_DECL
  csGLENDVERTEXSHADEREXT glEndVertexShaderEXT;
  #endif

  #ifndef GLBINDVERTEXSHADEREXT_DECL
  #define GLBINDVERTEXSHADEREXT_DECL
  csGLBINDVERTEXSHADEREXT glBindVertexShaderEXT;
  #endif

  #ifndef GLGENVERTEXSHADERSEXT_DECL
  #define GLGENVERTEXSHADERSEXT_DECL
  csGLGENVERTEXSHADERSEXT glGenVertexShadersEXT;
  #endif

  #ifndef GLDELETEVERTEXSHADEREXT_DECL
  #define GLDELETEVERTEXSHADEREXT_DECL
  csGLDELETEVERTEXSHADEREXT glDeleteVertexShaderEXT;
  #endif

  #ifndef GLSHADEROP1EXT_DECL
  #define GLSHADEROP1EXT_DECL
  csGLSHADEROP1EXT glShaderOp1EXT;
  #endif

  #ifndef GLSHADEROP2EXT_DECL
  #define GLSHADEROP2EXT_DECL
  csGLSHADEROP2EXT glShaderOp2EXT;
  #endif

  #ifndef GLSHADEROP3EXT_DECL
  #define GLSHADEROP3EXT_DECL
  csGLSHADEROP3EXT glShaderOp3EXT;
  #endif

  #ifndef GLSWIZZLEEXT_DECL
  #define GLSWIZZLEEXT_DECL
  csGLSWIZZLEEXT glSwizzleEXT;
  #endif

  #ifndef GLWRITEMASKEXT_DECL
  #define GLWRITEMASKEXT_DECL
  csGLWRITEMASKEXT glWriteMaskEXT;
  #endif

  #ifndef GLINSERTCOMPONENTEXT_DECL
  #define GLINSERTCOMPONENTEXT_DECL
  csGLINSERTCOMPONENTEXT glInsertComponentEXT;
  #endif

  #ifndef GLEXTRACTCOMPONENTEXT_DECL
  #define GLEXTRACTCOMPONENTEXT_DECL
  csGLEXTRACTCOMPONENTEXT glExtractComponentEXT;
  #endif

  #ifndef GLGENSYMBOLSEXT_DECL
  #define GLGENSYMBOLSEXT_DECL
  csGLGENSYMBOLSEXT glGenSymbolsEXT;
  #endif

  #ifndef GLSETINVARIANTEXT_DECL
  #define GLSETINVARIANTEXT_DECL
  csGLSETINVARIANTEXT glSetInvariantEXT;
  #endif

  #ifndef GLSETLOCALCONSTANTEXT_DECL
  #define GLSETLOCALCONSTANTEXT_DECL
  csGLSETLOCALCONSTANTEXT glSetLocalConstantEXT;
  #endif

  #ifndef GLVARIANTBVEXT_DECL
  #define GLVARIANTBVEXT_DECL
  csGLVARIANTBVEXT glVariantbvEXT;
  #endif

  #ifndef GLVARIANTSVEXT_DECL
  #define GLVARIANTSVEXT_DECL
  csGLVARIANTSVEXT glVariantsvEXT;
  #endif

  #ifndef GLVARIANTIVEXT_DECL
  #define GLVARIANTIVEXT_DECL
  csGLVARIANTIVEXT glVariantivEXT;
  #endif

  #ifndef GLVARIANTFVEXT_DECL
  #define GLVARIANTFVEXT_DECL
  csGLVARIANTFVEXT glVariantfvEXT;
  #endif

  #ifndef GLVARIANTDVEXT_DECL
  #define GLVARIANTDVEXT_DECL
  csGLVARIANTDVEXT glVariantdvEXT;
  #endif

  #ifndef GLVARIANTUBVEXT_DECL
  #define GLVARIANTUBVEXT_DECL
  csGLVARIANTUBVEXT glVariantubvEXT;
  #endif

  #ifndef GLVARIANTUSVEXT_DECL
  #define GLVARIANTUSVEXT_DECL
  csGLVARIANTUSVEXT glVariantusvEXT;
  #endif

  #ifndef GLVARIANTUIVEXT_DECL
  #define GLVARIANTUIVEXT_DECL
  csGLVARIANTUIVEXT glVariantuivEXT;
  #endif

  #ifndef GLVARIANTPOINTEREXT_DECL
  #define GLVARIANTPOINTEREXT_DECL
  csGLVARIANTPOINTEREXT glVariantPointerEXT;
  #endif

  #ifndef GLENABLEVARIANTCLIENTSTATEEXT_DECL
  #define GLENABLEVARIANTCLIENTSTATEEXT_DECL
  csGLENABLEVARIANTCLIENTSTATEEXT glEnableVariantClientStateEXT;
  #endif

  #ifndef GLDISABLEVARIANTCLIENTSTATEEXT_DECL
  #define GLDISABLEVARIANTCLIENTSTATEEXT_DECL
  csGLDISABLEVARIANTCLIENTSTATEEXT glDisableVariantClientStateEXT;
  #endif

  #ifndef GLBINDLIGHTPARAMETEREXT_DECL
  #define GLBINDLIGHTPARAMETEREXT_DECL
  csGLBINDLIGHTPARAMETEREXT glBindLightParameterEXT;
  #endif

  #ifndef GLBINDMATERIALPARAMETEREXT_DECL
  #define GLBINDMATERIALPARAMETEREXT_DECL
  csGLBINDMATERIALPARAMETEREXT glBindMaterialParameterEXT;
  #endif

  #ifndef GLBINDTEXGENPARAMETEREXT_DECL
  #define GLBINDTEXGENPARAMETEREXT_DECL
  csGLBINDTEXGENPARAMETEREXT glBindTexGenParameterEXT;
  #endif

  #ifndef GLBINDTEXTUREUNITPARAMETEREXT_DECL
  #define GLBINDTEXTUREUNITPARAMETEREXT_DECL
  csGLBINDTEXTUREUNITPARAMETEREXT glBindTextureUnitParameterEXT;
  #endif

  #ifndef GLBINDPARAMETEREXT_DECL
  #define GLBINDPARAMETEREXT_DECL
  csGLBINDPARAMETEREXT glBindParameterEXT;
  #endif

  #ifndef GLISVARIANTENABLEDEXT_DECL
  #define GLISVARIANTENABLEDEXT_DECL
  csGLISVARIANTENABLEDEXT glIsVariantEnabledEXT;
  #endif

  #ifndef GLGETVARIANTBOOLEANVEXT_DECL
  #define GLGETVARIANTBOOLEANVEXT_DECL
  csGLGETVARIANTBOOLEANVEXT glGetVariantBooleanvEXT;
  #endif

  #ifndef GLGETVARIANTINTEGERVEXT_DECL
  #define GLGETVARIANTINTEGERVEXT_DECL
  csGLGETVARIANTINTEGERVEXT glGetVariantIntegervEXT;
  #endif

  #ifndef GLGETVARIANTFLOATVEXT_DECL
  #define GLGETVARIANTFLOATVEXT_DECL
  csGLGETVARIANTFLOATVEXT glGetVariantFloatvEXT;
  #endif

  #ifndef GLGETVARIANTPOINTERVEXT_DECL
  #define GLGETVARIANTPOINTERVEXT_DECL
  csGLGETVARIANTPOINTERVEXT glGetVariantPointervEXT;
  #endif

  #ifndef GLGETINVARIANTBOOLEANVEXT_DECL
  #define GLGETINVARIANTBOOLEANVEXT_DECL
  csGLGETINVARIANTBOOLEANVEXT glGetInvariantBooleanvEXT;
  #endif

  #ifndef GLGETINVARIANTINTEGERVEXT_DECL
  #define GLGETINVARIANTINTEGERVEXT_DECL
  csGLGETINVARIANTINTEGERVEXT glGetInvariantIntegervEXT;
  #endif

  #ifndef GLGETINVARIANTFLOATVEXT_DECL
  #define GLGETINVARIANTFLOATVEXT_DECL
  csGLGETINVARIANTFLOATVEXT glGetInvariantFloatvEXT;
  #endif

  #ifndef GLGETLOCALCONSTANTBOOLEANVEXT_DECL
  #define GLGETLOCALCONSTANTBOOLEANVEXT_DECL
  csGLGETLOCALCONSTANTBOOLEANVEXT glGetLocalConstantBooleanvEXT;
  #endif

  #ifndef GLGETLOCALCONSTANTINTEGERVEXT_DECL
  #define GLGETLOCALCONSTANTINTEGERVEXT_DECL
  csGLGETLOCALCONSTANTINTEGERVEXT glGetLocalConstantIntegervEXT;
  #endif

  #ifndef GLGETLOCALCONSTANTFLOATVEXT_DECL
  #define GLGETLOCALCONSTANTFLOATVEXT_DECL
  csGLGETLOCALCONSTANTFLOATVEXT glGetLocalConstantFloatvEXT;
  #endif


  // GL_EXT_vertex_weighting
  #ifndef GLVERTEXWEIGHTFEXT_DECL
  #define GLVERTEXWEIGHTFEXT_DECL
  csGLVERTEXWEIGHTFEXT glVertexWeightfEXT;
  #endif

  #ifndef GLVERTEXWEIGHTFVEXT_DECL
  #define GLVERTEXWEIGHTFVEXT_DECL
  csGLVERTEXWEIGHTFVEXT glVertexWeightfvEXT;
  #endif

  #ifndef GLVERTEXWEIGHTPOINTEREXT_DECL
  #define GLVERTEXWEIGHTPOINTEREXT_DECL
  csGLVERTEXWEIGHTPOINTEREXT glVertexWeightPointerEXT;
  #endif


  // GL_HP_occlusion_test

  // GL_NV_blend_square

  // GL_NV_copy_depth_to_color

  // GL_NV_depth_clamp

  // GL_NV_evaluators
  #ifndef GLMAPCONTROLPOINTSNV_DECL
  #define GLMAPCONTROLPOINTSNV_DECL
  csGLMAPCONTROLPOINTSNV glMapControlPointsNV;
  #endif

  #ifndef GLMAPPARAMETERIVNV_DECL
  #define GLMAPPARAMETERIVNV_DECL
  csGLMAPPARAMETERIVNV glMapParameterivNV;
  #endif

  #ifndef GLMAPPARAMETERFVNV_DECL
  #define GLMAPPARAMETERFVNV_DECL
  csGLMAPPARAMETERFVNV glMapParameterfvNV;
  #endif

  #ifndef GLGETMAPCONTROLPOINTSNV_DECL
  #define GLGETMAPCONTROLPOINTSNV_DECL
  csGLGETMAPCONTROLPOINTSNV glGetMapControlPointsNV;
  #endif

  #ifndef GLGETMAPPARAMETERIVNV_DECL
  #define GLGETMAPPARAMETERIVNV_DECL
  csGLGETMAPPARAMETERIVNV glGetMapParameterivNV;
  #endif

  #ifndef GLGETMAPPARAMETERFVNV_DECL
  #define GLGETMAPPARAMETERFVNV_DECL
  csGLGETMAPPARAMETERFVNV glGetMapParameterfvNV;
  #endif

  #ifndef GLGETMAPATTRIBPARAMETERIVNV_DECL
  #define GLGETMAPATTRIBPARAMETERIVNV_DECL
  csGLGETMAPATTRIBPARAMETERIVNV glGetMapAttribParameterivNV;
  #endif

  #ifndef GLGETMAPATTRIBPARAMETERFVNV_DECL
  #define GLGETMAPATTRIBPARAMETERFVNV_DECL
  csGLGETMAPATTRIBPARAMETERFVNV glGetMapAttribParameterfvNV;
  #endif

  #ifndef GLEVALMAPSNV_DECL
  #define GLEVALMAPSNV_DECL
  csGLEVALMAPSNV glEvalMapsNV;
  #endif


  // GL_NV_fence
  #ifndef GLGENFENCESNV_DECL
  #define GLGENFENCESNV_DECL
  csGLGENFENCESNV glGenFencesNV;
  #endif

  #ifndef GLDELETEFENCESNV_DECL
  #define GLDELETEFENCESNV_DECL
  csGLDELETEFENCESNV glDeleteFencesNV;
  #endif

  #ifndef GLSETFENCENV_DECL
  #define GLSETFENCENV_DECL
  csGLSETFENCENV glSetFenceNV;
  #endif

  #ifndef GLTESTFENCENV_DECL
  #define GLTESTFENCENV_DECL
  csGLTESTFENCENV glTestFenceNV;
  #endif

  #ifndef GLFINISHFENCENV_DECL
  #define GLFINISHFENCENV_DECL
  csGLFINISHFENCENV glFinishFenceNV;
  #endif

  #ifndef GLISFENCENV_DECL
  #define GLISFENCENV_DECL
  csGLISFENCENV glIsFenceNV;
  #endif

  #ifndef GLGETFENCEIVNV_DECL
  #define GLGETFENCEIVNV_DECL
  csGLGETFENCEIVNV glGetFenceivNV;
  #endif


  // GL_NV_fog_distance

  // GL_NV_light_max_exponent

  // GL_NV_multisample_filter_hint

  // GL_NV_occlusion_query
  #ifndef GLGENOCCLUSIONQUERIESNV_DECL
  #define GLGENOCCLUSIONQUERIESNV_DECL
  csGLGENOCCLUSIONQUERIESNV glGenOcclusionQueriesNV;
  #endif

  #ifndef GLDELETEOCCLUSIONQUERIESNV_DECL
  #define GLDELETEOCCLUSIONQUERIESNV_DECL
  csGLDELETEOCCLUSIONQUERIESNV glDeleteOcclusionQueriesNV;
  #endif

  #ifndef GLISOCCLUSIONQUERYNV_DECL
  #define GLISOCCLUSIONQUERYNV_DECL
  csGLISOCCLUSIONQUERYNV glIsOcclusionQueryNV;
  #endif

  #ifndef GLBEGINOCCLUSIONQUERYNV_DECL
  #define GLBEGINOCCLUSIONQUERYNV_DECL
  csGLBEGINOCCLUSIONQUERYNV glBeginOcclusionQueryNV;
  #endif

  #ifndef GLENDOCCLUSIONQUERYNV_DECL
  #define GLENDOCCLUSIONQUERYNV_DECL
  csGLENDOCCLUSIONQUERYNV glEndOcclusionQueryNV;
  #endif

  #ifndef GLGETOCCLUSIONQUERYIVNV_DECL
  #define GLGETOCCLUSIONQUERYIVNV_DECL
  csGLGETOCCLUSIONQUERYIVNV glGetOcclusionQueryivNV;
  #endif

  #ifndef GLGETOCCLUSIONQUERYUIVNV_DECL
  #define GLGETOCCLUSIONQUERYUIVNV_DECL
  csGLGETOCCLUSIONQUERYUIVNV glGetOcclusionQueryuivNV;
  #endif


  // GL_NV_packed_depth_stencil

  // GL_NV_point_sprite
  #ifndef GLPOINTPARAMETERINV_DECL
  #define GLPOINTPARAMETERINV_DECL
  csGLPOINTPARAMETERINV glPointParameteriNV;
  #endif

  #ifndef GLPOINTPARAMETERIVNV_DECL
  #define GLPOINTPARAMETERIVNV_DECL
  csGLPOINTPARAMETERIVNV glPointParameterivNV;
  #endif


  // GL_NV_register_combiners
  #ifndef GLCOMBINERPARAMETERFVNV_DECL
  #define GLCOMBINERPARAMETERFVNV_DECL
  csGLCOMBINERPARAMETERFVNV glCombinerParameterfvNV;
  #endif

  #ifndef GLCOMBINERPARAMETERIVNV_DECL
  #define GLCOMBINERPARAMETERIVNV_DECL
  csGLCOMBINERPARAMETERIVNV glCombinerParameterivNV;
  #endif

  #ifndef GLCOMBINERPARAMETERFNV_DECL
  #define GLCOMBINERPARAMETERFNV_DECL
  csGLCOMBINERPARAMETERFNV glCombinerParameterfNV;
  #endif

  #ifndef GLCOMBINERPARAMETERINV_DECL
  #define GLCOMBINERPARAMETERINV_DECL
  csGLCOMBINERPARAMETERINV glCombinerParameteriNV;
  #endif

  #ifndef GLCOMBINERINPUTNV_DECL
  #define GLCOMBINERINPUTNV_DECL
  csGLCOMBINERINPUTNV glCombinerInputNV;
  #endif

  #ifndef GLCOMBINEROUTPUTNV_DECL
  #define GLCOMBINEROUTPUTNV_DECL
  csGLCOMBINEROUTPUTNV glCombinerOutputNV;
  #endif

  #ifndef GLFINALCOMBINERINPUTNV_DECL
  #define GLFINALCOMBINERINPUTNV_DECL
  csGLFINALCOMBINERINPUTNV glFinalCombinerInputNV;
  #endif

  #ifndef GLGETCOMBINERINPUTPARAMETERFVNV_DECL
  #define GLGETCOMBINERINPUTPARAMETERFVNV_DECL
  csGLGETCOMBINERINPUTPARAMETERFVNV glGetCombinerInputParameterfvNV;
  #endif

  #ifndef GLGETCOMBINERINPUTPARAMETERIVNV_DECL
  #define GLGETCOMBINERINPUTPARAMETERIVNV_DECL
  csGLGETCOMBINERINPUTPARAMETERIVNV glGetCombinerInputParameterivNV;
  #endif

  #ifndef GLGETCOMBINEROUTPUTPARAMETERFVNV_DECL
  #define GLGETCOMBINEROUTPUTPARAMETERFVNV_DECL
  csGLGETCOMBINEROUTPUTPARAMETERFVNV glGetCombinerOutputParameterfvNV;
  #endif

  #ifndef GLGETCOMBINEROUTPUTPARAMETERIVNV_DECL
  #define GLGETCOMBINEROUTPUTPARAMETERIVNV_DECL
  csGLGETCOMBINEROUTPUTPARAMETERIVNV glGetCombinerOutputParameterivNV;
  #endif

  #ifndef GLGETFINALCOMBINERINPUTPARAMETERFVNV_DECL
  #define GLGETFINALCOMBINERINPUTPARAMETERFVNV_DECL
  csGLGETFINALCOMBINERINPUTPARAMETERFVNV glGetFinalCombinerInputParameterfvNV;
  #endif

  #ifndef GLGETFINALCOMBINERINPUTPARAMETERIVNV_DECL
  #define GLGETFINALCOMBINERINPUTPARAMETERIVNV_DECL
  csGLGETFINALCOMBINERINPUTPARAMETERIVNV glGetFinalCombinerInputParameterivNV;
  #endif


  // GL_NV_register_combiners2
  #ifndef GLCOMBINERSTAGEPARAMETERFVNV_DECL
  #define GLCOMBINERSTAGEPARAMETERFVNV_DECL
  csGLCOMBINERSTAGEPARAMETERFVNV glCombinerStageParameterfvNV;
  #endif

  #ifndef GLGETCOMBINERSTAGEPARAMETERFVNV_DECL
  #define GLGETCOMBINERSTAGEPARAMETERFVNV_DECL
  csGLGETCOMBINERSTAGEPARAMETERFVNV glGetCombinerStageParameterfvNV;
  #endif


  // GL_NV_texgen_emboss

  // GL_NV_texgen_reflection

  // GL_NV_texture_compression_vtc

  // GL_NV_texture_env_combine4

  // GL_NV_texture_rectangle

  // GL_NV_texture_shader

  // GL_NV_texture_shader2

  // GL_NV_texture_shader3

  // GL_NV_vertex_array_range
  #ifndef GLVERTEXARRAYRANGENV_DECL
  #define GLVERTEXARRAYRANGENV_DECL
  csGLVERTEXARRAYRANGENV glVertexArrayRangeNV;
  #endif

  #ifndef GLFLUSHVERTEXARRAYRANGENV_DECL
  #define GLFLUSHVERTEXARRAYRANGENV_DECL
  csGLFLUSHVERTEXARRAYRANGENV glFlushVertexArrayRangeNV;
  #endif

  #ifndef WGLALLOCATEMEMORYNV_DECL
  #define WGLALLOCATEMEMORYNV_DECL
  csWGLALLOCATEMEMORYNV wglAllocateMemoryNV;
  #endif

  #ifndef WGLFREEMEMORYNV_DECL
  #define WGLFREEMEMORYNV_DECL
  csWGLFREEMEMORYNV wglFreeMemoryNV;
  #endif


  // GL_NV_vertex_array_range2

  // GL_NV_vertex_program
  #ifndef GLBINDPROGRAMNV_DECL
  #define GLBINDPROGRAMNV_DECL
  csGLBINDPROGRAMNV glBindProgramNV;
  #endif

  #ifndef GLDELETEPROGRAMSNV_DECL
  #define GLDELETEPROGRAMSNV_DECL
  csGLDELETEPROGRAMSNV glDeleteProgramsNV;
  #endif

  #ifndef GLEXECUTEPROGRAMNV_DECL
  #define GLEXECUTEPROGRAMNV_DECL
  csGLEXECUTEPROGRAMNV glExecuteProgramNV;
  #endif

  #ifndef GLGENPROGRAMSNV_DECL
  #define GLGENPROGRAMSNV_DECL
  csGLGENPROGRAMSNV glGenProgramsNV;
  #endif

  #ifndef GLAREPROGRAMSRESIDENTNV_DECL
  #define GLAREPROGRAMSRESIDENTNV_DECL
  csGLAREPROGRAMSRESIDENTNV glAreProgramsResidentNV;
  #endif

  #ifndef GLREQUESTRESIDENTPROGRAMSNV_DECL
  #define GLREQUESTRESIDENTPROGRAMSNV_DECL
  csGLREQUESTRESIDENTPROGRAMSNV glRequestResidentProgramsNV;
  #endif

  #ifndef GLGETPROGRAMPARAMETERFVNV_DECL
  #define GLGETPROGRAMPARAMETERFVNV_DECL
  csGLGETPROGRAMPARAMETERFVNV glGetProgramParameterfvNV;
  #endif

  #ifndef GLGETPROGRAMPARAMETERDVNV_DECL
  #define GLGETPROGRAMPARAMETERDVNV_DECL
  csGLGETPROGRAMPARAMETERDVNV glGetProgramParameterdvNV;
  #endif

  #ifndef GLGETPROGRAMIVNV_DECL
  #define GLGETPROGRAMIVNV_DECL
  csGLGETPROGRAMIVNV glGetProgramivNV;
  #endif

  #ifndef GLGETPROGRAMSTRINGNV_DECL
  #define GLGETPROGRAMSTRINGNV_DECL
  csGLGETPROGRAMSTRINGNV glGetProgramStringNV;
  #endif

  #ifndef GLGETTRACKMATRIXIVNV_DECL
  #define GLGETTRACKMATRIXIVNV_DECL
  csGLGETTRACKMATRIXIVNV glGetTrackMatrixivNV;
  #endif

  #ifndef GLGETVERTEXATTRIBDVNV_DECL
  #define GLGETVERTEXATTRIBDVNV_DECL
  csGLGETVERTEXATTRIBDVNV glGetVertexAttribdvNV;
  #endif

  #ifndef GLGETVERTEXATTRIBFVNV_DECL
  #define GLGETVERTEXATTRIBFVNV_DECL
  csGLGETVERTEXATTRIBFVNV glGetVertexAttribfvNV;
  #endif

  #ifndef GLGETVERTEXATTRIBIVNV_DECL
  #define GLGETVERTEXATTRIBIVNV_DECL
  csGLGETVERTEXATTRIBIVNV glGetVertexAttribivNV;
  #endif

  #ifndef GLGETVERTEXATTRIBPOINTERVNV_DECL
  #define GLGETVERTEXATTRIBPOINTERVNV_DECL
  csGLGETVERTEXATTRIBPOINTERVNV glGetVertexAttribPointervNV;
  #endif

  #ifndef GLISPROGRAMNV_DECL
  #define GLISPROGRAMNV_DECL
  csGLISPROGRAMNV glIsProgramNV;
  #endif

  #ifndef GLLOADPROGRAMNV_DECL
  #define GLLOADPROGRAMNV_DECL
  csGLLOADPROGRAMNV glLoadProgramNV;
  #endif

  #ifndef GLPROGRAMPARAMETER4FNV_DECL
  #define GLPROGRAMPARAMETER4FNV_DECL
  csGLPROGRAMPARAMETER4FNV glProgramParameter4fNV;
  #endif

  #ifndef GLPROGRAMPARAMETER4FVNV_DECL
  #define GLPROGRAMPARAMETER4FVNV_DECL
  csGLPROGRAMPARAMETER4FVNV glProgramParameter4fvNV;
  #endif

  #ifndef GLPROGRAMPARAMETERS4DVNV_DECL
  #define GLPROGRAMPARAMETERS4DVNV_DECL
  csGLPROGRAMPARAMETERS4DVNV glProgramParameters4dvNV;
  #endif

  #ifndef GLPROGRAMPARAMETERS4FVNV_DECL
  #define GLPROGRAMPARAMETERS4FVNV_DECL
  csGLPROGRAMPARAMETERS4FVNV glProgramParameters4fvNV;
  #endif

  #ifndef GLTRACKMATRIXNV_DECL
  #define GLTRACKMATRIXNV_DECL
  csGLTRACKMATRIXNV glTrackMatrixNV;
  #endif

  #ifndef GLVERTEXATTRIBPOINTERNV_DECL
  #define GLVERTEXATTRIBPOINTERNV_DECL
  csGLVERTEXATTRIBPOINTERNV glVertexAttribPointerNV;
  #endif

  #ifndef GLVERTEXATTRIB1SNV_DECL
  #define GLVERTEXATTRIB1SNV_DECL
  csGLVERTEXATTRIB1SNV glVertexAttrib1sNV;
  #endif

  #ifndef GLVERTEXATTRIB1FNV_DECL
  #define GLVERTEXATTRIB1FNV_DECL
  csGLVERTEXATTRIB1FNV glVertexAttrib1fNV;
  #endif

  #ifndef GLVERTEXATTRIB1DNV_DECL
  #define GLVERTEXATTRIB1DNV_DECL
  csGLVERTEXATTRIB1DNV glVertexAttrib1dNV;
  #endif

  #ifndef GLVERTEXATTRIB2SNV_DECL
  #define GLVERTEXATTRIB2SNV_DECL
  csGLVERTEXATTRIB2SNV glVertexAttrib2sNV;
  #endif

  #ifndef GLVERTEXATTRIB2FNV_DECL
  #define GLVERTEXATTRIB2FNV_DECL
  csGLVERTEXATTRIB2FNV glVertexAttrib2fNV;
  #endif

  #ifndef GLVERTEXATTRIB2DNV_DECL
  #define GLVERTEXATTRIB2DNV_DECL
  csGLVERTEXATTRIB2DNV glVertexAttrib2dNV;
  #endif

  #ifndef GLVERTEXATTRIB3SNV_DECL
  #define GLVERTEXATTRIB3SNV_DECL
  csGLVERTEXATTRIB3SNV glVertexAttrib3sNV;
  #endif

  #ifndef GLVERTEXATTRIB3FNV_DECL
  #define GLVERTEXATTRIB3FNV_DECL
  csGLVERTEXATTRIB3FNV glVertexAttrib3fNV;
  #endif

  #ifndef GLVERTEXATTRIB3DNV_DECL
  #define GLVERTEXATTRIB3DNV_DECL
  csGLVERTEXATTRIB3DNV glVertexAttrib3dNV;
  #endif

  #ifndef GLVERTEXATTRIB4SNV_DECL
  #define GLVERTEXATTRIB4SNV_DECL
  csGLVERTEXATTRIB4SNV glVertexAttrib4sNV;
  #endif

  #ifndef GLVERTEXATTRIB4FNV_DECL
  #define GLVERTEXATTRIB4FNV_DECL
  csGLVERTEXATTRIB4FNV glVertexAttrib4fNV;
  #endif

  #ifndef GLVERTEXATTRIB4DNV_DECL
  #define GLVERTEXATTRIB4DNV_DECL
  csGLVERTEXATTRIB4DNV glVertexAttrib4dNV;
  #endif

  #ifndef GLVERTEXATTRIB4UBNV_DECL
  #define GLVERTEXATTRIB4UBNV_DECL
  csGLVERTEXATTRIB4UBNV glVertexAttrib4ubNV;
  #endif

  #ifndef GLVERTEXATTRIB1SVNV_DECL
  #define GLVERTEXATTRIB1SVNV_DECL
  csGLVERTEXATTRIB1SVNV glVertexAttrib1svNV;
  #endif

  #ifndef GLVERTEXATTRIB1FVNV_DECL
  #define GLVERTEXATTRIB1FVNV_DECL
  csGLVERTEXATTRIB1FVNV glVertexAttrib1fvNV;
  #endif

  #ifndef GLVERTEXATTRIB1DVNV_DECL
  #define GLVERTEXATTRIB1DVNV_DECL
  csGLVERTEXATTRIB1DVNV glVertexAttrib1dvNV;
  #endif

  #ifndef GLVERTEXATTRIB2SVNV_DECL
  #define GLVERTEXATTRIB2SVNV_DECL
  csGLVERTEXATTRIB2SVNV glVertexAttrib2svNV;
  #endif

  #ifndef GLVERTEXATTRIB2FVNV_DECL
  #define GLVERTEXATTRIB2FVNV_DECL
  csGLVERTEXATTRIB2FVNV glVertexAttrib2fvNV;
  #endif

  #ifndef GLVERTEXATTRIB2DVNV_DECL
  #define GLVERTEXATTRIB2DVNV_DECL
  csGLVERTEXATTRIB2DVNV glVertexAttrib2dvNV;
  #endif

  #ifndef GLVERTEXATTRIB3SVNV_DECL
  #define GLVERTEXATTRIB3SVNV_DECL
  csGLVERTEXATTRIB3SVNV glVertexAttrib3svNV;
  #endif

  #ifndef GLVERTEXATTRIB3FVNV_DECL
  #define GLVERTEXATTRIB3FVNV_DECL
  csGLVERTEXATTRIB3FVNV glVertexAttrib3fvNV;
  #endif

  #ifndef GLVERTEXATTRIB3DVNV_DECL
  #define GLVERTEXATTRIB3DVNV_DECL
  csGLVERTEXATTRIB3DVNV glVertexAttrib3dvNV;
  #endif

  #ifndef GLVERTEXATTRIB4SVNV_DECL
  #define GLVERTEXATTRIB4SVNV_DECL
  csGLVERTEXATTRIB4SVNV glVertexAttrib4svNV;
  #endif

  #ifndef GLVERTEXATTRIB4FVNV_DECL
  #define GLVERTEXATTRIB4FVNV_DECL
  csGLVERTEXATTRIB4FVNV glVertexAttrib4fvNV;
  #endif

  #ifndef GLVERTEXATTRIB4DVNV_DECL
  #define GLVERTEXATTRIB4DVNV_DECL
  csGLVERTEXATTRIB4DVNV glVertexAttrib4dvNV;
  #endif

  #ifndef GLVERTEXATTRIB4UBVNV_DECL
  #define GLVERTEXATTRIB4UBVNV_DECL
  csGLVERTEXATTRIB4UBVNV glVertexAttrib4ubvNV;
  #endif

  #ifndef GLVERTEXATTRIBS1SVNV_DECL
  #define GLVERTEXATTRIBS1SVNV_DECL
  csGLVERTEXATTRIBS1SVNV glVertexAttribs1svNV;
  #endif

  #ifndef GLVERTEXATTRIBS1FVNV_DECL
  #define GLVERTEXATTRIBS1FVNV_DECL
  csGLVERTEXATTRIBS1FVNV glVertexAttribs1fvNV;
  #endif

  #ifndef GLVERTEXATTRIBS1DVNV_DECL
  #define GLVERTEXATTRIBS1DVNV_DECL
  csGLVERTEXATTRIBS1DVNV glVertexAttribs1dvNV;
  #endif

  #ifndef GLVERTEXATTRIBS2SVNV_DECL
  #define GLVERTEXATTRIBS2SVNV_DECL
  csGLVERTEXATTRIBS2SVNV glVertexAttribs2svNV;
  #endif

  #ifndef GLVERTEXATTRIBS2FVNV_DECL
  #define GLVERTEXATTRIBS2FVNV_DECL
  csGLVERTEXATTRIBS2FVNV glVertexAttribs2fvNV;
  #endif

  #ifndef GLVERTEXATTRIBS2DVNV_DECL
  #define GLVERTEXATTRIBS2DVNV_DECL
  csGLVERTEXATTRIBS2DVNV glVertexAttribs2dvNV;
  #endif

  #ifndef GLVERTEXATTRIBS3SVNV_DECL
  #define GLVERTEXATTRIBS3SVNV_DECL
  csGLVERTEXATTRIBS3SVNV glVertexAttribs3svNV;
  #endif

  #ifndef GLVERTEXATTRIBS3FVNV_DECL
  #define GLVERTEXATTRIBS3FVNV_DECL
  csGLVERTEXATTRIBS3FVNV glVertexAttribs3fvNV;
  #endif

  #ifndef GLVERTEXATTRIBS3DVNV_DECL
  #define GLVERTEXATTRIBS3DVNV_DECL
  csGLVERTEXATTRIBS3DVNV glVertexAttribs3dvNV;
  #endif

  #ifndef GLVERTEXATTRIBS4SVNV_DECL
  #define GLVERTEXATTRIBS4SVNV_DECL
  csGLVERTEXATTRIBS4SVNV glVertexAttribs4svNV;
  #endif

  #ifndef GLVERTEXATTRIBS4FVNV_DECL
  #define GLVERTEXATTRIBS4FVNV_DECL
  csGLVERTEXATTRIBS4FVNV glVertexAttribs4fvNV;
  #endif

  #ifndef GLVERTEXATTRIBS4DVNV_DECL
  #define GLVERTEXATTRIBS4DVNV_DECL
  csGLVERTEXATTRIBS4DVNV glVertexAttribs4dvNV;
  #endif

  #ifndef GLVERTEXATTRIBS4UBVNV_DECL
  #define GLVERTEXATTRIBS4UBVNV_DECL
  csGLVERTEXATTRIBS4UBVNV glVertexAttribs4ubvNV;
  #endif


  // GL_NV_vertex_program1_1

  // GL_ATI_element_array
  #ifndef GLELEMENTPOINTERATI_DECL
  #define GLELEMENTPOINTERATI_DECL
  csGLELEMENTPOINTERATI glElementPointerATI;
  #endif

  #ifndef GLDRAWELEMENTARRAYATI_DECL
  #define GLDRAWELEMENTARRAYATI_DECL
  csGLDRAWELEMENTARRAYATI glDrawElementArrayATI;
  #endif

  #ifndef GLDRAWRANGEELEMENTARRAYATI_DECL
  #define GLDRAWRANGEELEMENTARRAYATI_DECL
  csGLDRAWRANGEELEMENTARRAYATI glDrawRangeElementArrayATI;
  #endif


  // GL_ATI_envmap_bumpmap
  #ifndef GLTEXBUMPPARAMETERIVATI_DECL
  #define GLTEXBUMPPARAMETERIVATI_DECL
  csGLTEXBUMPPARAMETERIVATI glTexBumpParameterivATI;
  #endif

  #ifndef GLTEXBUMPPARAMETERFVATI_DECL
  #define GLTEXBUMPPARAMETERFVATI_DECL
  csGLTEXBUMPPARAMETERFVATI glTexBumpParameterfvATI;
  #endif

  #ifndef GLGETTEXBUMPPARAMETERIVATI_DECL
  #define GLGETTEXBUMPPARAMETERIVATI_DECL
  csGLGETTEXBUMPPARAMETERIVATI glGetTexBumpParameterivATI;
  #endif

  #ifndef GLGETTEXBUMPPARAMETERFVATI_DECL
  #define GLGETTEXBUMPPARAMETERFVATI_DECL
  csGLGETTEXBUMPPARAMETERFVATI glGetTexBumpParameterfvATI;
  #endif


  // GL_ATI_fragment_shader
  #ifndef GLGENFRAGMENTSHADERSATI_DECL
  #define GLGENFRAGMENTSHADERSATI_DECL
  csGLGENFRAGMENTSHADERSATI glGenFragmentShadersATI;
  #endif

  #ifndef GLBINDFRAGMENTSHADERATI_DECL
  #define GLBINDFRAGMENTSHADERATI_DECL
  csGLBINDFRAGMENTSHADERATI glBindFragmentShaderATI;
  #endif

  #ifndef GLDELETEFRAGMENTSHADERATI_DECL
  #define GLDELETEFRAGMENTSHADERATI_DECL
  csGLDELETEFRAGMENTSHADERATI glDeleteFragmentShaderATI;
  #endif

  #ifndef GLBEGINFRAGMENTSHADERATI_DECL
  #define GLBEGINFRAGMENTSHADERATI_DECL
  csGLBEGINFRAGMENTSHADERATI glBeginFragmentShaderATI;
  #endif

  #ifndef GLENDFRAGMENTSHADERATI_DECL
  #define GLENDFRAGMENTSHADERATI_DECL
  csGLENDFRAGMENTSHADERATI glEndFragmentShaderATI;
  #endif

  #ifndef GLPASSTEXCOORDATI_DECL
  #define GLPASSTEXCOORDATI_DECL
  csGLPASSTEXCOORDATI glPassTexCoordATI;
  #endif

  #ifndef GLSAMPLEMAPATI_DECL
  #define GLSAMPLEMAPATI_DECL
  csGLSAMPLEMAPATI glSampleMapATI;
  #endif

  #ifndef GLCOLORFRAGMENTOP1ATI_DECL
  #define GLCOLORFRAGMENTOP1ATI_DECL
  csGLCOLORFRAGMENTOP1ATI glColorFragmentOp1ATI;
  #endif

  #ifndef GLCOLORFRAGMENTOP2ATI_DECL
  #define GLCOLORFRAGMENTOP2ATI_DECL
  csGLCOLORFRAGMENTOP2ATI glColorFragmentOp2ATI;
  #endif

  #ifndef GLCOLORFRAGMENTOP3ATI_DECL
  #define GLCOLORFRAGMENTOP3ATI_DECL
  csGLCOLORFRAGMENTOP3ATI glColorFragmentOp3ATI;
  #endif

  #ifndef GLALPHAFRAGMENTOP1ATI_DECL
  #define GLALPHAFRAGMENTOP1ATI_DECL
  csGLALPHAFRAGMENTOP1ATI glAlphaFragmentOp1ATI;
  #endif

  #ifndef GLALPHAFRAGMENTOP2ATI_DECL
  #define GLALPHAFRAGMENTOP2ATI_DECL
  csGLALPHAFRAGMENTOP2ATI glAlphaFragmentOp2ATI;
  #endif

  #ifndef GLALPHAFRAGMENTOP3ATI_DECL
  #define GLALPHAFRAGMENTOP3ATI_DECL
  csGLALPHAFRAGMENTOP3ATI glAlphaFragmentOp3ATI;
  #endif

  #ifndef GLSETFRAGMENTSHADERCONSTANTATI_DECL
  #define GLSETFRAGMENTSHADERCONSTANTATI_DECL
  csGLSETFRAGMENTSHADERCONSTANTATI glSetFragmentShaderConstantATI;
  #endif


  // GL_ATI_pn_triangles
  #ifndef GLPNTRIANGLESIATI_DECL
  #define GLPNTRIANGLESIATI_DECL
  csGLPNTRIANGLESIATI glPNTrianglesiATI;
  #endif

  #ifndef GLPNTRIANGLESFATI_DECL
  #define GLPNTRIANGLESFATI_DECL
  csGLPNTRIANGLESFATI glPNTrianglesfATI;
  #endif


  // GL_ATI_texture_mirror_once

  // GL_ATI_vertex_array_object
  #ifndef GLNEWOBJECTBUFFERATI_DECL
  #define GLNEWOBJECTBUFFERATI_DECL
  csGLNEWOBJECTBUFFERATI glNewObjectBufferATI;
  #endif

  #ifndef GLISOBJECTBUFFERATI_DECL
  #define GLISOBJECTBUFFERATI_DECL
  csGLISOBJECTBUFFERATI glIsObjectBufferATI;
  #endif

  #ifndef GLUPDATEOBJECTBUFFERATI_DECL
  #define GLUPDATEOBJECTBUFFERATI_DECL
  csGLUPDATEOBJECTBUFFERATI glUpdateObjectBufferATI;
  #endif

  #ifndef GLGETOBJECTBUFFERFVATI_DECL
  #define GLGETOBJECTBUFFERFVATI_DECL
  csGLGETOBJECTBUFFERFVATI glGetObjectBufferfvATI;
  #endif

  #ifndef GLGETOBJECTBUFFERIVATI_DECL
  #define GLGETOBJECTBUFFERIVATI_DECL
  csGLGETOBJECTBUFFERIVATI glGetObjectBufferivATI;
  #endif

  #ifndef GLFREEOBJECTBUFFERATI_DECL
  #define GLFREEOBJECTBUFFERATI_DECL
  csGLFREEOBJECTBUFFERATI glFreeObjectBufferATI;
  #endif

  #ifndef GLARRAYOBJECTATI_DECL
  #define GLARRAYOBJECTATI_DECL
  csGLARRAYOBJECTATI glArrayObjectATI;
  #endif

  #ifndef GLGETARRAYOBJECTFVATI_DECL
  #define GLGETARRAYOBJECTFVATI_DECL
  csGLGETARRAYOBJECTFVATI glGetArrayObjectfvATI;
  #endif

  #ifndef GLGETARRAYOBJECTIVATI_DECL
  #define GLGETARRAYOBJECTIVATI_DECL
  csGLGETARRAYOBJECTIVATI glGetArrayObjectivATI;
  #endif

  #ifndef GLVARIANTARRAYOBJECTATI_DECL
  #define GLVARIANTARRAYOBJECTATI_DECL
  csGLVARIANTARRAYOBJECTATI glVariantArrayObjectATI;
  #endif

  #ifndef GLGETVARIANTARRAYOBJECTFVATI_DECL
  #define GLGETVARIANTARRAYOBJECTFVATI_DECL
  csGLGETVARIANTARRAYOBJECTFVATI glGetVariantArrayObjectfvATI;
  #endif

  #ifndef GLGETVARIANTARRAYOBJECTIVATI_DECL
  #define GLGETVARIANTARRAYOBJECTIVATI_DECL
  csGLGETVARIANTARRAYOBJECTIVATI glGetVariantArrayObjectivATI;
  #endif


  // GL_ATI_vertex_attrib_array_object
  #ifndef GLVERTEXATTRIBARRAYOBJECTATI_DECL
  #define GLVERTEXATTRIBARRAYOBJECTATI_DECL
  csGLVERTEXATTRIBARRAYOBJECTATI glVertexAttribArrayObjectATI;
  #endif

  #ifndef GLGETVERTEXATTRIBARRAYOBJECTFVATI_DECL
  #define GLGETVERTEXATTRIBARRAYOBJECTFVATI_DECL
  csGLGETVERTEXATTRIBARRAYOBJECTFVATI glGetVertexAttribArrayObjectfvATI;
  #endif

  #ifndef GLGETVERTEXATTRIBARRAYOBJECTIVATI_DECL
  #define GLGETVERTEXATTRIBARRAYOBJECTIVATI_DECL
  csGLGETVERTEXATTRIBARRAYOBJECTIVATI glGetVertexAttribArrayObjectivATI;
  #endif


  // GL_ATI_vertex_streams
  #ifndef GLVERTEXSTREAM1S_DECL
  #define GLVERTEXSTREAM1S_DECL
  csGLVERTEXSTREAM1S glVertexStream1s;
  #endif

  #ifndef GLVERTEXSTREAM1I_DECL
  #define GLVERTEXSTREAM1I_DECL
  csGLVERTEXSTREAM1I glVertexStream1i;
  #endif

  #ifndef GLVERTEXSTREAM1F_DECL
  #define GLVERTEXSTREAM1F_DECL
  csGLVERTEXSTREAM1F glVertexStream1f;
  #endif

  #ifndef GLVERTEXSTREAM1D_DECL
  #define GLVERTEXSTREAM1D_DECL
  csGLVERTEXSTREAM1D glVertexStream1d;
  #endif

  #ifndef GLVERTEXSTREAM1SV_DECL
  #define GLVERTEXSTREAM1SV_DECL
  csGLVERTEXSTREAM1SV glVertexStream1sv;
  #endif

  #ifndef GLVERTEXSTREAM1IV_DECL
  #define GLVERTEXSTREAM1IV_DECL
  csGLVERTEXSTREAM1IV glVertexStream1iv;
  #endif

  #ifndef GLVERTEXSTREAM1FV_DECL
  #define GLVERTEXSTREAM1FV_DECL
  csGLVERTEXSTREAM1FV glVertexStream1fv;
  #endif

  #ifndef GLVERTEXSTREAM1DV_DECL
  #define GLVERTEXSTREAM1DV_DECL
  csGLVERTEXSTREAM1DV glVertexStream1dv;
  #endif

  #ifndef GLVERTEXSTREAM2S_DECL
  #define GLVERTEXSTREAM2S_DECL
  csGLVERTEXSTREAM2S glVertexStream2s;
  #endif

  #ifndef GLVERTEXSTREAM2I_DECL
  #define GLVERTEXSTREAM2I_DECL
  csGLVERTEXSTREAM2I glVertexStream2i;
  #endif

  #ifndef GLVERTEXSTREAM2F_DECL
  #define GLVERTEXSTREAM2F_DECL
  csGLVERTEXSTREAM2F glVertexStream2f;
  #endif

  #ifndef GLVERTEXSTREAM2D_DECL
  #define GLVERTEXSTREAM2D_DECL
  csGLVERTEXSTREAM2D glVertexStream2d;
  #endif

  #ifndef GLVERTEXSTREAM2SV_DECL
  #define GLVERTEXSTREAM2SV_DECL
  csGLVERTEXSTREAM2SV glVertexStream2sv;
  #endif

  #ifndef GLVERTEXSTREAM2IV_DECL
  #define GLVERTEXSTREAM2IV_DECL
  csGLVERTEXSTREAM2IV glVertexStream2iv;
  #endif

  #ifndef GLVERTEXSTREAM2FV_DECL
  #define GLVERTEXSTREAM2FV_DECL
  csGLVERTEXSTREAM2FV glVertexStream2fv;
  #endif

  #ifndef GLVERTEXSTREAM2DV_DECL
  #define GLVERTEXSTREAM2DV_DECL
  csGLVERTEXSTREAM2DV glVertexStream2dv;
  #endif

  #ifndef GLVERTEXSTREAM3S_DECL
  #define GLVERTEXSTREAM3S_DECL
  csGLVERTEXSTREAM3S glVertexStream3s;
  #endif

  #ifndef GLVERTEXSTREAM3I_DECL
  #define GLVERTEXSTREAM3I_DECL
  csGLVERTEXSTREAM3I glVertexStream3i;
  #endif

  #ifndef GLVERTEXSTREAM3F_DECL
  #define GLVERTEXSTREAM3F_DECL
  csGLVERTEXSTREAM3F glVertexStream3f;
  #endif

  #ifndef GLVERTEXSTREAM3D_DECL
  #define GLVERTEXSTREAM3D_DECL
  csGLVERTEXSTREAM3D glVertexStream3d;
  #endif

  #ifndef GLVERTEXSTREAM3SV_DECL
  #define GLVERTEXSTREAM3SV_DECL
  csGLVERTEXSTREAM3SV glVertexStream3sv;
  #endif

  #ifndef GLVERTEXSTREAM3IV_DECL
  #define GLVERTEXSTREAM3IV_DECL
  csGLVERTEXSTREAM3IV glVertexStream3iv;
  #endif

  #ifndef GLVERTEXSTREAM3FV_DECL
  #define GLVERTEXSTREAM3FV_DECL
  csGLVERTEXSTREAM3FV glVertexStream3fv;
  #endif

  #ifndef GLVERTEXSTREAM3DV_DECL
  #define GLVERTEXSTREAM3DV_DECL
  csGLVERTEXSTREAM3DV glVertexStream3dv;
  #endif

  #ifndef GLVERTEXSTREAM4S_DECL
  #define GLVERTEXSTREAM4S_DECL
  csGLVERTEXSTREAM4S glVertexStream4s;
  #endif

  #ifndef GLVERTEXSTREAM4I_DECL
  #define GLVERTEXSTREAM4I_DECL
  csGLVERTEXSTREAM4I glVertexStream4i;
  #endif

  #ifndef GLVERTEXSTREAM4F_DECL
  #define GLVERTEXSTREAM4F_DECL
  csGLVERTEXSTREAM4F glVertexStream4f;
  #endif

  #ifndef GLVERTEXSTREAM4D_DECL
  #define GLVERTEXSTREAM4D_DECL
  csGLVERTEXSTREAM4D glVertexStream4d;
  #endif

  #ifndef GLVERTEXSTREAM4SV_DECL
  #define GLVERTEXSTREAM4SV_DECL
  csGLVERTEXSTREAM4SV glVertexStream4sv;
  #endif

  #ifndef GLVERTEXSTREAM4IV_DECL
  #define GLVERTEXSTREAM4IV_DECL
  csGLVERTEXSTREAM4IV glVertexStream4iv;
  #endif

  #ifndef GLVERTEXSTREAM4FV_DECL
  #define GLVERTEXSTREAM4FV_DECL
  csGLVERTEXSTREAM4FV glVertexStream4fv;
  #endif

  #ifndef GLVERTEXSTREAM4DV_DECL
  #define GLVERTEXSTREAM4DV_DECL
  csGLVERTEXSTREAM4DV glVertexStream4dv;
  #endif

  #ifndef GLNORMALSTREAM3B_DECL
  #define GLNORMALSTREAM3B_DECL
  csGLNORMALSTREAM3B glNormalStream3b;
  #endif

  #ifndef GLNORMALSTREAM3S_DECL
  #define GLNORMALSTREAM3S_DECL
  csGLNORMALSTREAM3S glNormalStream3s;
  #endif

  #ifndef GLNORMALSTREAM3I_DECL
  #define GLNORMALSTREAM3I_DECL
  csGLNORMALSTREAM3I glNormalStream3i;
  #endif

  #ifndef GLNORMALSTREAM3F_DECL
  #define GLNORMALSTREAM3F_DECL
  csGLNORMALSTREAM3F glNormalStream3f;
  #endif

  #ifndef GLNORMALSTREAM3D_DECL
  #define GLNORMALSTREAM3D_DECL
  csGLNORMALSTREAM3D glNormalStream3d;
  #endif

  #ifndef GLNORMALSTREAM3BV_DECL
  #define GLNORMALSTREAM3BV_DECL
  csGLNORMALSTREAM3BV glNormalStream3bv;
  #endif

  #ifndef GLNORMALSTREAM3SV_DECL
  #define GLNORMALSTREAM3SV_DECL
  csGLNORMALSTREAM3SV glNormalStream3sv;
  #endif

  #ifndef GLNORMALSTREAM3IV_DECL
  #define GLNORMALSTREAM3IV_DECL
  csGLNORMALSTREAM3IV glNormalStream3iv;
  #endif

  #ifndef GLNORMALSTREAM3FV_DECL
  #define GLNORMALSTREAM3FV_DECL
  csGLNORMALSTREAM3FV glNormalStream3fv;
  #endif

  #ifndef GLNORMALSTREAM3DV_DECL
  #define GLNORMALSTREAM3DV_DECL
  csGLNORMALSTREAM3DV glNormalStream3dv;
  #endif

  #ifndef GLCLIENTACTIVEVERTEXSTREAM_DECL
  #define GLCLIENTACTIVEVERTEXSTREAM_DECL
  csGLCLIENTACTIVEVERTEXSTREAM glClientActiveVertexStream;
  #endif

  #ifndef GLVERTEXBLENDENVI_DECL
  #define GLVERTEXBLENDENVI_DECL
  csGLVERTEXBLENDENVI glVertexBlendEnvi;
  #endif

  #ifndef GLVERTEXBLENDENVF_DECL
  #define GLVERTEXBLENDENVF_DECL
  csGLVERTEXBLENDENVF glVertexBlendEnvf;
  #endif


  // WGL_I3D_image_buffer
#ifdef _WIN32
  #ifndef WGLCREATEIMAGEBUFFERI3D_DECL
  #define WGLCREATEIMAGEBUFFERI3D_DECL
  csWGLCREATEIMAGEBUFFERI3D wglCreateImageBufferI3D;
  #endif

  #ifndef WGLDESTROYIMAGEBUFFERI3D_DECL
  #define WGLDESTROYIMAGEBUFFERI3D_DECL
  csWGLDESTROYIMAGEBUFFERI3D wglDestroyImageBufferI3D;
  #endif

  #ifndef WGLASSOCIATEIMAGEBUFFEREVENTSI3D_DECL
  #define WGLASSOCIATEIMAGEBUFFEREVENTSI3D_DECL
  csWGLASSOCIATEIMAGEBUFFEREVENTSI3D wglAssociateImageBufferEventsI3D;
  #endif

  #ifndef WGLRELEASEIMAGEBUFFEREVENTSI3D_DECL
  #define WGLRELEASEIMAGEBUFFEREVENTSI3D_DECL
  csWGLRELEASEIMAGEBUFFEREVENTSI3D wglReleaseImageBufferEventsI3D;
  #endif


#endif // _WIN32

  // WGL_I3D_swap_frame_lock
#ifdef _WIN32
  #ifndef WGLENABLEFRAMELOCKI3D_DECL
  #define WGLENABLEFRAMELOCKI3D_DECL
  csWGLENABLEFRAMELOCKI3D wglEnableFrameLockI3D;
  #endif

  #ifndef WGLDISABLEFRAMELOCKI3D_DECL
  #define WGLDISABLEFRAMELOCKI3D_DECL
  csWGLDISABLEFRAMELOCKI3D wglDisableFrameLockI3D;
  #endif

  #ifndef WGLISENABLEDFRAMELOCKI3D_DECL
  #define WGLISENABLEDFRAMELOCKI3D_DECL
  csWGLISENABLEDFRAMELOCKI3D wglIsEnabledFrameLockI3D;
  #endif

  #ifndef WGLQUERYFRAMELOCKMASTERI3D_DECL
  #define WGLQUERYFRAMELOCKMASTERI3D_DECL
  csWGLQUERYFRAMELOCKMASTERI3D wglQueryFrameLockMasterI3D;
  #endif


#endif // _WIN32

  // WGL_I3D_swap_frame_usage
#ifdef _WIN32
  #ifndef WGLGETFRAMEUSAGEI3D_DECL
  #define WGLGETFRAMEUSAGEI3D_DECL
  csWGLGETFRAMEUSAGEI3D wglGetFrameUsageI3D;
  #endif

  #ifndef WGLBEGINFRAMETRACKINGI3D_DECL
  #define WGLBEGINFRAMETRACKINGI3D_DECL
  csWGLBEGINFRAMETRACKINGI3D wglBeginFrameTrackingI3D;
  #endif

  #ifndef WGLENDFRAMETRACKINGI3D_DECL
  #define WGLENDFRAMETRACKINGI3D_DECL
  csWGLENDFRAMETRACKINGI3D wglEndFrameTrackingI3D;
  #endif

  #ifndef WGLQUERYFRAMETRACKINGI3D_DECL
  #define WGLQUERYFRAMETRACKINGI3D_DECL
  csWGLQUERYFRAMETRACKINGI3D wglQueryFrameTrackingI3D;
  #endif


#endif // _WIN32

  // GL_3DFX_texture_compression_FXT1

  // GL_IBM_cull_vertex

  // GL_IBM_multimode_draw_arrays
  #ifndef GLMULTIMODEDRAWARRAYSIBM_DECL
  #define GLMULTIMODEDRAWARRAYSIBM_DECL
  csGLMULTIMODEDRAWARRAYSIBM glMultiModeDrawArraysIBM;
  #endif

  #ifndef GLMULTIMODEDRAWELEMENTSIBM_DECL
  #define GLMULTIMODEDRAWELEMENTSIBM_DECL
  csGLMULTIMODEDRAWELEMENTSIBM glMultiModeDrawElementsIBM;
  #endif


  // GL_IBM_raster_pos_clip

  // GL_IBM_texture_mirrored_repeat

  // GL_IBM_vertex_array_lists
  #ifndef GLCOLORPOINTERLISTIBM_DECL
  #define GLCOLORPOINTERLISTIBM_DECL
  csGLCOLORPOINTERLISTIBM glColorPointerListIBM;
  #endif

  #ifndef GLSECONDARYCOLORPOINTERLISTIBM_DECL
  #define GLSECONDARYCOLORPOINTERLISTIBM_DECL
  csGLSECONDARYCOLORPOINTERLISTIBM glSecondaryColorPointerListIBM;
  #endif

  #ifndef GLEDGEFLAGPOINTERLISTIBM_DECL
  #define GLEDGEFLAGPOINTERLISTIBM_DECL
  csGLEDGEFLAGPOINTERLISTIBM glEdgeFlagPointerListIBM;
  #endif

  #ifndef GLFOGCOORDPOINTERLISTIBM_DECL
  #define GLFOGCOORDPOINTERLISTIBM_DECL
  csGLFOGCOORDPOINTERLISTIBM glFogCoordPointerListIBM;
  #endif

  #ifndef GLNORMALPOINTERLISTIBM_DECL
  #define GLNORMALPOINTERLISTIBM_DECL
  csGLNORMALPOINTERLISTIBM glNormalPointerListIBM;
  #endif

  #ifndef GLTEXCOORDPOINTERLISTIBM_DECL
  #define GLTEXCOORDPOINTERLISTIBM_DECL
  csGLTEXCOORDPOINTERLISTIBM glTexCoordPointerListIBM;
  #endif

  #ifndef GLVERTEXPOINTERLISTIBM_DECL
  #define GLVERTEXPOINTERLISTIBM_DECL
  csGLVERTEXPOINTERLISTIBM glVertexPointerListIBM;
  #endif


  // GL_MESA_resize_buffers
  #ifndef GLRESIZEBUFFERSMESA_DECL
  #define GLRESIZEBUFFERSMESA_DECL
  csGLRESIZEBUFFERSMESA glResizeBuffersMESA;
  #endif


  // GL_MESA_window_pos
  #ifndef GLWINDOWPOS2DMESA_DECL
  #define GLWINDOWPOS2DMESA_DECL
  csGLWINDOWPOS2DMESA glWindowPos2dMESA;
  #endif

  #ifndef GLWINDOWPOS2FMESA_DECL
  #define GLWINDOWPOS2FMESA_DECL
  csGLWINDOWPOS2FMESA glWindowPos2fMESA;
  #endif

  #ifndef GLWINDOWPOS2IMESA_DECL
  #define GLWINDOWPOS2IMESA_DECL
  csGLWINDOWPOS2IMESA glWindowPos2iMESA;
  #endif

  #ifndef GLWINDOWPOS2SMESA_DECL
  #define GLWINDOWPOS2SMESA_DECL
  csGLWINDOWPOS2SMESA glWindowPos2sMESA;
  #endif

  #ifndef GLWINDOWPOS2IVMESA_DECL
  #define GLWINDOWPOS2IVMESA_DECL
  csGLWINDOWPOS2IVMESA glWindowPos2ivMESA;
  #endif

  #ifndef GLWINDOWPOS2SVMESA_DECL
  #define GLWINDOWPOS2SVMESA_DECL
  csGLWINDOWPOS2SVMESA glWindowPos2svMESA;
  #endif

  #ifndef GLWINDOWPOS2FVMESA_DECL
  #define GLWINDOWPOS2FVMESA_DECL
  csGLWINDOWPOS2FVMESA glWindowPos2fvMESA;
  #endif

  #ifndef GLWINDOWPOS2DVMESA_DECL
  #define GLWINDOWPOS2DVMESA_DECL
  csGLWINDOWPOS2DVMESA glWindowPos2dvMESA;
  #endif

  #ifndef GLWINDOWPOS3IMESA_DECL
  #define GLWINDOWPOS3IMESA_DECL
  csGLWINDOWPOS3IMESA glWindowPos3iMESA;
  #endif

  #ifndef GLWINDOWPOS3SMESA_DECL
  #define GLWINDOWPOS3SMESA_DECL
  csGLWINDOWPOS3SMESA glWindowPos3sMESA;
  #endif

  #ifndef GLWINDOWPOS3FMESA_DECL
  #define GLWINDOWPOS3FMESA_DECL
  csGLWINDOWPOS3FMESA glWindowPos3fMESA;
  #endif

  #ifndef GLWINDOWPOS3DMESA_DECL
  #define GLWINDOWPOS3DMESA_DECL
  csGLWINDOWPOS3DMESA glWindowPos3dMESA;
  #endif

  #ifndef GLWINDOWPOS3IVMESA_DECL
  #define GLWINDOWPOS3IVMESA_DECL
  csGLWINDOWPOS3IVMESA glWindowPos3ivMESA;
  #endif

  #ifndef GLWINDOWPOS3SVMESA_DECL
  #define GLWINDOWPOS3SVMESA_DECL
  csGLWINDOWPOS3SVMESA glWindowPos3svMESA;
  #endif

  #ifndef GLWINDOWPOS3FVMESA_DECL
  #define GLWINDOWPOS3FVMESA_DECL
  csGLWINDOWPOS3FVMESA glWindowPos3fvMESA;
  #endif

  #ifndef GLWINDOWPOS3DVMESA_DECL
  #define GLWINDOWPOS3DVMESA_DECL
  csGLWINDOWPOS3DVMESA glWindowPos3dvMESA;
  #endif

  #ifndef GLWINDOWPOS4IMESA_DECL
  #define GLWINDOWPOS4IMESA_DECL
  csGLWINDOWPOS4IMESA glWindowPos4iMESA;
  #endif

  #ifndef GLWINDOWPOS4SMESA_DECL
  #define GLWINDOWPOS4SMESA_DECL
  csGLWINDOWPOS4SMESA glWindowPos4sMESA;
  #endif

  #ifndef GLWINDOWPOS4FMESA_DECL
  #define GLWINDOWPOS4FMESA_DECL
  csGLWINDOWPOS4FMESA glWindowPos4fMESA;
  #endif

  #ifndef GLWINDOWPOS4DMESA_DECL
  #define GLWINDOWPOS4DMESA_DECL
  csGLWINDOWPOS4DMESA glWindowPos4dMESA;
  #endif

  #ifndef GLWINDOWPOS4IVMESA_DECL
  #define GLWINDOWPOS4IVMESA_DECL
  csGLWINDOWPOS4IVMESA glWindowPos4ivMESA;
  #endif

  #ifndef GLWINDOWPOS4SVMESA_DECL
  #define GLWINDOWPOS4SVMESA_DECL
  csGLWINDOWPOS4SVMESA glWindowPos4svMESA;
  #endif

  #ifndef GLWINDOWPOS4FVMESA_DECL
  #define GLWINDOWPOS4FVMESA_DECL
  csGLWINDOWPOS4FVMESA glWindowPos4fvMESA;
  #endif

  #ifndef GLWINDOWPOS4DVMESA_DECL
  #define GLWINDOWPOS4DVMESA_DECL
  csGLWINDOWPOS4DVMESA glWindowPos4dvMESA;
  #endif


  // GL_OML_interlace

  // GL_OML_resample

  // GL_OML_subsample

  // GL_SGIS_generate_mipmap

  // GL_SGIS_multisample
  #ifndef GLSAMPLEMASKSGIS_DECL
  #define GLSAMPLEMASKSGIS_DECL
  csGLSAMPLEMASKSGIS glSampleMaskSGIS;
  #endif

  #ifndef GLSAMPLEPATTERNSGIS_DECL
  #define GLSAMPLEPATTERNSGIS_DECL
  csGLSAMPLEPATTERNSGIS glSamplePatternSGIS;
  #endif


  // GL_SGIS_pixel_texture
  #ifndef GLPIXELTEXGENPARAMETERISGIS_DECL
  #define GLPIXELTEXGENPARAMETERISGIS_DECL
  csGLPIXELTEXGENPARAMETERISGIS glPixelTexGenParameteriSGIS;
  #endif

  #ifndef GLPIXELTEXGENPARAMETERFSGIS_DECL
  #define GLPIXELTEXGENPARAMETERFSGIS_DECL
  csGLPIXELTEXGENPARAMETERFSGIS glPixelTexGenParameterfSGIS;
  #endif

  #ifndef GLGETPIXELTEXGENPARAMETERIVSGIS_DECL
  #define GLGETPIXELTEXGENPARAMETERIVSGIS_DECL
  csGLGETPIXELTEXGENPARAMETERIVSGIS glGetPixelTexGenParameterivSGIS;
  #endif

  #ifndef GLGETPIXELTEXGENPARAMETERFVSGIS_DECL
  #define GLGETPIXELTEXGENPARAMETERFVSGIS_DECL
  csGLGETPIXELTEXGENPARAMETERFVSGIS glGetPixelTexGenParameterfvSGIS;
  #endif


  // GL_SGIS_texture_border_clamp

  // GL_SGIS_texture_color_mask
  #ifndef GLTEXTURECOLORMASKSGIS_DECL
  #define GLTEXTURECOLORMASKSGIS_DECL
  csGLTEXTURECOLORMASKSGIS glTextureColorMaskSGIS;
  #endif


  // GL_SGIS_texture_edge_clamp

  // GL_SGIS_texture_lod

  // GL_SGIS_depth_texture

  // GL_SGIX_fog_offset

  // GL_SGIX_interlace

  // GL_SGIX_shadow_ambient

  // GL_SGI_color_matrix

  // GL_SGI_color_table
  #ifndef GLCOLORTABLESGI_DECL
  #define GLCOLORTABLESGI_DECL
  csGLCOLORTABLESGI glColorTableSGI;
  #endif

  #ifndef GLCOPYCOLORTABLESGI_DECL
  #define GLCOPYCOLORTABLESGI_DECL
  csGLCOPYCOLORTABLESGI glCopyColorTableSGI;
  #endif

  #ifndef GLCOLORTABLEPARAMETERIVSGI_DECL
  #define GLCOLORTABLEPARAMETERIVSGI_DECL
  csGLCOLORTABLEPARAMETERIVSGI glColorTableParameterivSGI;
  #endif

  #ifndef GLCOLORTABLEPARAMETERFVSGI_DECL
  #define GLCOLORTABLEPARAMETERFVSGI_DECL
  csGLCOLORTABLEPARAMETERFVSGI glColorTableParameterfvSGI;
  #endif

  #ifndef GLGETCOLORTABLESGI_DECL
  #define GLGETCOLORTABLESGI_DECL
  csGLGETCOLORTABLESGI glGetColorTableSGI;
  #endif

  #ifndef GLGETCOLORTABLEPARAMETERIVSGI_DECL
  #define GLGETCOLORTABLEPARAMETERIVSGI_DECL
  csGLGETCOLORTABLEPARAMETERIVSGI glGetColorTableParameterivSGI;
  #endif

  #ifndef GLGETCOLORTABLEPARAMETERFVSGI_DECL
  #define GLGETCOLORTABLEPARAMETERFVSGI_DECL
  csGLGETCOLORTABLEPARAMETERFVSGI glGetColorTableParameterfvSGI;
  #endif


  // GL_SGI_texture_color_table

  // GL_SUN_vertex
  #ifndef GLCOLOR4UBVERTEX2FSUN_DECL
  #define GLCOLOR4UBVERTEX2FSUN_DECL
  csGLCOLOR4UBVERTEX2FSUN glColor4ubVertex2fSUN;
  #endif

  #ifndef GLCOLOR4UBVERTEX2FVSUN_DECL
  #define GLCOLOR4UBVERTEX2FVSUN_DECL
  csGLCOLOR4UBVERTEX2FVSUN glColor4ubVertex2fvSUN;
  #endif

  #ifndef GLCOLOR4UBVERTEX3FSUN_DECL
  #define GLCOLOR4UBVERTEX3FSUN_DECL
  csGLCOLOR4UBVERTEX3FSUN glColor4ubVertex3fSUN;
  #endif

  #ifndef GLCOLOR4UBVERTEX3FVSUN_DECL
  #define GLCOLOR4UBVERTEX3FVSUN_DECL
  csGLCOLOR4UBVERTEX3FVSUN glColor4ubVertex3fvSUN;
  #endif

  #ifndef GLCOLOR3FVERTEX3FSUN_DECL
  #define GLCOLOR3FVERTEX3FSUN_DECL
  csGLCOLOR3FVERTEX3FSUN glColor3fVertex3fSUN;
  #endif

  #ifndef GLCOLOR3FVERTEX3FVSUN_DECL
  #define GLCOLOR3FVERTEX3FVSUN_DECL
  csGLCOLOR3FVERTEX3FVSUN glColor3fVertex3fvSUN;
  #endif

  #ifndef GLNORMAL3FVERTEX3FSUN_DECL
  #define GLNORMAL3FVERTEX3FSUN_DECL
  csGLNORMAL3FVERTEX3FSUN glNormal3fVertex3fSUN;
  #endif

  #ifndef GLNORMAL3FVERTEX3FVSUN_DECL
  #define GLNORMAL3FVERTEX3FVSUN_DECL
  csGLNORMAL3FVERTEX3FVSUN glNormal3fVertex3fvSUN;
  #endif

  #ifndef GLCOLOR4FNORMAL3FVERTEX3FSUN_DECL
  #define GLCOLOR4FNORMAL3FVERTEX3FSUN_DECL
  csGLCOLOR4FNORMAL3FVERTEX3FSUN glColor4fNormal3fVertex3fSUN;
  #endif

  #ifndef GLCOLOR4FNORMAL3FVERTEX3FVSUN_DECL
  #define GLCOLOR4FNORMAL3FVERTEX3FVSUN_DECL
  csGLCOLOR4FNORMAL3FVERTEX3FVSUN glColor4fNormal3fVertex3fvSUN;
  #endif

  #ifndef GLTEXCOORD2FVERTEX3FSUN_DECL
  #define GLTEXCOORD2FVERTEX3FSUN_DECL
  csGLTEXCOORD2FVERTEX3FSUN glTexCoord2fVertex3fSUN;
  #endif

  #ifndef GLTEXCOORD2FVERTEX3FVSUN_DECL
  #define GLTEXCOORD2FVERTEX3FVSUN_DECL
  csGLTEXCOORD2FVERTEX3FVSUN glTexCoord2fVertex3fvSUN;
  #endif

  #ifndef GLTEXCOORD4FVERTEX4FSUN_DECL
  #define GLTEXCOORD4FVERTEX4FSUN_DECL
  csGLTEXCOORD4FVERTEX4FSUN glTexCoord4fVertex4fSUN;
  #endif

  #ifndef GLTEXCOORD4FVERTEX4FVSUN_DECL
  #define GLTEXCOORD4FVERTEX4FVSUN_DECL
  csGLTEXCOORD4FVERTEX4FVSUN glTexCoord4fVertex4fvSUN;
  #endif

  #ifndef GLTEXCOORD2FCOLOR4UBVERTEX3FSUN_DECL
  #define GLTEXCOORD2FCOLOR4UBVERTEX3FSUN_DECL
  csGLTEXCOORD2FCOLOR4UBVERTEX3FSUN glTexCoord2fColor4ubVertex3fSUN;
  #endif

  #ifndef GLTEXCOORD2FCOLOR4UBVERTEX3FVSUN_DECL
  #define GLTEXCOORD2FCOLOR4UBVERTEX3FVSUN_DECL
  csGLTEXCOORD2FCOLOR4UBVERTEX3FVSUN glTexCoord2fColor4ubVertex3fvSUN;
  #endif

  #ifndef GLTEXCOORD2FCOLOR3FVERTEX3FSUN_DECL
  #define GLTEXCOORD2FCOLOR3FVERTEX3FSUN_DECL
  csGLTEXCOORD2FCOLOR3FVERTEX3FSUN glTexCoord2fColor3fVertex3fSUN;
  #endif

  #ifndef GLTEXCOORD2FCOLOR3FVERTEX3FVSUN_DECL
  #define GLTEXCOORD2FCOLOR3FVERTEX3FVSUN_DECL
  csGLTEXCOORD2FCOLOR3FVERTEX3FVSUN glTexCoord2fColor3fVertex3fvSUN;
  #endif

  #ifndef GLTEXCOORD2FNORMAL3FVERTEX3FSUN_DECL
  #define GLTEXCOORD2FNORMAL3FVERTEX3FSUN_DECL
  csGLTEXCOORD2FNORMAL3FVERTEX3FSUN glTexCoord2fNormal3fVertex3fSUN;
  #endif

  #ifndef GLTEXCOORD2FNORMAL3FVERTEX3FVSUN_DECL
  #define GLTEXCOORD2FNORMAL3FVERTEX3FVSUN_DECL
  csGLTEXCOORD2FNORMAL3FVERTEX3FVSUN glTexCoord2fNormal3fVertex3fvSUN;
  #endif

  #ifndef GLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUN_DECL
  #define GLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUN_DECL
  csGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUN glTexCoord2fColor4fNormal3fVertex3fSUN;
  #endif

  #ifndef GLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUN_DECL
  #define GLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUN_DECL
  csGLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUN glTexCoord2fColor4fNormal3fVertex3fvSUN;
  #endif

  #ifndef GLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FSUN_DECL
  #define GLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FSUN_DECL
  csGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FSUN glTexCoord4fColor4fNormal3fVertex4fSUN;
  #endif

  #ifndef GLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FVSUN_DECL
  #define GLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FVSUN_DECL
  csGLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FVSUN glTexCoord4fColor4fNormal3fVertex4fvSUN;
  #endif

  #ifndef GLREPLACEMENTCODEUIVERTEX3FSUN_DECL
  #define GLREPLACEMENTCODEUIVERTEX3FSUN_DECL
  csGLREPLACEMENTCODEUIVERTEX3FSUN glReplacementCodeuiVertex3fSUN;
  #endif

  #ifndef GLREPLACEMENTCODEUIVERTEX3FVSUN_DECL
  #define GLREPLACEMENTCODEUIVERTEX3FVSUN_DECL
  csGLREPLACEMENTCODEUIVERTEX3FVSUN glReplacementCodeuiVertex3fvSUN;
  #endif

  #ifndef GLREPLACEMENTCODEUICOLOR4UBVERTEX3FSUN_DECL
  #define GLREPLACEMENTCODEUICOLOR4UBVERTEX3FSUN_DECL
  csGLREPLACEMENTCODEUICOLOR4UBVERTEX3FSUN glReplacementCodeuiColor4ubVertex3fSUN;
  #endif

  #ifndef GLREPLACEMENTCODEUICOLOR4UBVERTEX3FVSUN_DECL
  #define GLREPLACEMENTCODEUICOLOR4UBVERTEX3FVSUN_DECL
  csGLREPLACEMENTCODEUICOLOR4UBVERTEX3FVSUN glReplacementCodeuiColor4ubVertex3fvSUN;
  #endif

  #ifndef GLREPLACEMENTCODEUICOLOR3FVERTEX3FSUN_DECL
  #define GLREPLACEMENTCODEUICOLOR3FVERTEX3FSUN_DECL
  csGLREPLACEMENTCODEUICOLOR3FVERTEX3FSUN glReplacementCodeuiColor3fVertex3fSUN;
  #endif

  #ifndef GLREPLACEMENTCODEUICOLOR3FVERTEX3FVSUN_DECL
  #define GLREPLACEMENTCODEUICOLOR3FVERTEX3FVSUN_DECL
  csGLREPLACEMENTCODEUICOLOR3FVERTEX3FVSUN glReplacementCodeuiColor3fVertex3fvSUN;
  #endif

  #ifndef GLREPLACEMENTCODEUINORMAL3FVERTEX3FSUN_DECL
  #define GLREPLACEMENTCODEUINORMAL3FVERTEX3FSUN_DECL
  csGLREPLACEMENTCODEUINORMAL3FVERTEX3FSUN glReplacementCodeuiNormal3fVertex3fSUN;
  #endif

  #ifndef GLREPLACEMENTCODEUINORMAL3FVERTEX3FVSUN_DECL
  #define GLREPLACEMENTCODEUINORMAL3FVERTEX3FVSUN_DECL
  csGLREPLACEMENTCODEUINORMAL3FVERTEX3FVSUN glReplacementCodeuiNormal3fVertex3fvSUN;
  #endif

  #ifndef GLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FSUN_DECL
  #define GLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FSUN_DECL
  csGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FSUN glReplacementCodeuiColor4fNormal3fVertex3fSUN;
  #endif

  #ifndef GLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FVSUN_DECL
  #define GLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FVSUN_DECL
  csGLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FVSUN glReplacementCodeuiColor4fNormal3fVertex3fvSUN;
  #endif

  #ifndef GLREPLACEMENTCODEUITEXCOORD2FVERTEX3FSUN_DECL
  #define GLREPLACEMENTCODEUITEXCOORD2FVERTEX3FSUN_DECL
  csGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FSUN glReplacementCodeuiTexCoord2fVertex3fSUN;
  #endif

  #ifndef GLREPLACEMENTCODEUITEXCOORD2FVERTEX3FVSUN_DECL
  #define GLREPLACEMENTCODEUITEXCOORD2FVERTEX3FVSUN_DECL
  csGLREPLACEMENTCODEUITEXCOORD2FVERTEX3FVSUN glReplacementCodeuiTexCoord2fVertex3fvSUN;
  #endif

  #ifndef GLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FSUN_DECL
  #define GLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FSUN_DECL
  csGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FSUN glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN;
  #endif

  #ifndef GLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FVSUN_DECL
  #define GLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FVSUN_DECL
  csGLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FVSUN glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN;
  #endif

  #ifndef GLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUN_DECL
  #define GLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUN_DECL
  csGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUN glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN;
  #endif

  #ifndef GLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUN_DECL
  #define GLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUN_DECL
  csGLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUN glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN;
  #endif


  // GL_ARB_fragment_program

  // GL_ATI_text_fragment_shader

  // GL_APPLE_client_storage

  // GL_APPLE_element_array
  #ifndef GLELEMENTPOINTERAPPLE_DECL
  #define GLELEMENTPOINTERAPPLE_DECL
  csGLELEMENTPOINTERAPPLE glElementPointerAPPLE;
  #endif

  #ifndef GLDRAWELEMENTARRAYAPPLE_DECL
  #define GLDRAWELEMENTARRAYAPPLE_DECL
  csGLDRAWELEMENTARRAYAPPLE glDrawElementArrayAPPLE;
  #endif

  #ifndef GLDRAWRANGEELEMENTARRAYAPPLE_DECL
  #define GLDRAWRANGEELEMENTARRAYAPPLE_DECL
  csGLDRAWRANGEELEMENTARRAYAPPLE glDrawRangeElementArrayAPPLE;
  #endif

  #ifndef GLMULTIDRAWELEMENTARRAYAPPLE_DECL
  #define GLMULTIDRAWELEMENTARRAYAPPLE_DECL
  csGLMULTIDRAWELEMENTARRAYAPPLE glMultiDrawElementArrayAPPLE;
  #endif

  #ifndef GLMULTIDRAWRANGEELEMENTARRAYAPPLE_DECL
  #define GLMULTIDRAWRANGEELEMENTARRAYAPPLE_DECL
  csGLMULTIDRAWRANGEELEMENTARRAYAPPLE glMultiDrawRangeElementArrayAPPLE;
  #endif


  // GL_APPLE_fence
  #ifndef GLGENFENCESAPPLE_DECL
  #define GLGENFENCESAPPLE_DECL
  csGLGENFENCESAPPLE glGenFencesAPPLE;
  #endif

  #ifndef GLDELETEFENCESAPPLE_DECL
  #define GLDELETEFENCESAPPLE_DECL
  csGLDELETEFENCESAPPLE glDeleteFencesAPPLE;
  #endif

  #ifndef GLSETFENCEAPPLE_DECL
  #define GLSETFENCEAPPLE_DECL
  csGLSETFENCEAPPLE glSetFenceAPPLE;
  #endif

  #ifndef GLISFENCEAPPLE_DECL
  #define GLISFENCEAPPLE_DECL
  csGLISFENCEAPPLE glIsFenceAPPLE;
  #endif

  #ifndef GLTESTFENCEAPPLE_DECL
  #define GLTESTFENCEAPPLE_DECL
  csGLTESTFENCEAPPLE glTestFenceAPPLE;
  #endif

  #ifndef GLFINISHFENCEAPPLE_DECL
  #define GLFINISHFENCEAPPLE_DECL
  csGLFINISHFENCEAPPLE glFinishFenceAPPLE;
  #endif

  #ifndef GLTESTOBJECTAPPLE_DECL
  #define GLTESTOBJECTAPPLE_DECL
  csGLTESTOBJECTAPPLE glTestObjectAPPLE;
  #endif

  #ifndef GLFINISHOBJECTAPPLE_DECL
  #define GLFINISHOBJECTAPPLE_DECL
  csGLFINISHOBJECTAPPLE glFinishObjectAPPLE;
  #endif


  // GL_APPLE_vertex_array_object
  #ifndef GLBINDVERTEXARRAYAPPLE_DECL
  #define GLBINDVERTEXARRAYAPPLE_DECL
  csGLBINDVERTEXARRAYAPPLE glBindVertexArrayAPPLE;
  #endif

  #ifndef GLDELETEVERTEXARRAYSAPPLE_DECL
  #define GLDELETEVERTEXARRAYSAPPLE_DECL
  csGLDELETEVERTEXARRAYSAPPLE glDeleteVertexArraysAPPLE;
  #endif

  #ifndef GLGENVERTEXARRAYSAPPLE_DECL
  #define GLGENVERTEXARRAYSAPPLE_DECL
  csGLGENVERTEXARRAYSAPPLE glGenVertexArraysAPPLE;
  #endif

  #ifndef GLISVERTEXARRAYAPPLE_DECL
  #define GLISVERTEXARRAYAPPLE_DECL
  csGLISVERTEXARRAYAPPLE glIsVertexArrayAPPLE;
  #endif


  // GL_APPLE_vertex_array_range
  #ifndef GLVERTEXARRAYRANGEAPPLE_DECL
  #define GLVERTEXARRAYRANGEAPPLE_DECL
  csGLVERTEXARRAYRANGEAPPLE glVertexArrayRangeAPPLE;
  #endif

  #ifndef GLFLUSHVERTEXARRAYRANGEAPPLE_DECL
  #define GLFLUSHVERTEXARRAYRANGEAPPLE_DECL
  csGLFLUSHVERTEXARRAYRANGEAPPLE glFlushVertexArrayRangeAPPLE;
  #endif

  #ifndef GLVERTEXARRAYPARAMETERIAPPLE_DECL
  #define GLVERTEXARRAYPARAMETERIAPPLE_DECL
  csGLVERTEXARRAYPARAMETERIAPPLE glVertexArrayParameteriAPPLE;
  #endif


  // WGL_ARB_pixel_format
#ifdef _WIN32
  #ifndef WGLGETPIXELFORMATATTRIBIVARB_DECL
  #define WGLGETPIXELFORMATATTRIBIVARB_DECL
  csWGLGETPIXELFORMATATTRIBIVARB wglGetPixelFormatAttribivARB;
  #endif

  #ifndef WGLGETPIXELFORMATATTRIBFVARB_DECL
  #define WGLGETPIXELFORMATATTRIBFVARB_DECL
  csWGLGETPIXELFORMATATTRIBFVARB wglGetPixelFormatAttribfvARB;
  #endif

  #ifndef WGLCHOOSEPIXELFORMATARB_DECL
  #define WGLCHOOSEPIXELFORMATARB_DECL
  csWGLCHOOSEPIXELFORMATARB wglChoosePixelFormatARB;
  #endif


#endif // _WIN32

  // WGL_ARB_make_current_read
#ifdef _WIN32
  #ifndef WGLMAKECONTEXTCURRENTARB_DECL
  #define WGLMAKECONTEXTCURRENTARB_DECL
  csWGLMAKECONTEXTCURRENTARB wglMakeContextCurrentARB;
  #endif

  #ifndef WGLGETCURRENTREADDCARB_DECL
  #define WGLGETCURRENTREADDCARB_DECL
  csWGLGETCURRENTREADDCARB wglGetCurrentReadDCARB;
  #endif


#endif // _WIN32

  // WGL_ARB_pbuffer
#ifdef _WIN32
  #ifndef WGLCREATEPBUFFERARB_DECL
  #define WGLCREATEPBUFFERARB_DECL
  csWGLCREATEPBUFFERARB wglCreatePbufferARB;
  #endif

  #ifndef WGLGETPBUFFERDCARB_DECL
  #define WGLGETPBUFFERDCARB_DECL
  csWGLGETPBUFFERDCARB wglGetPbufferDCARB;
  #endif

  #ifndef WGLRELEASEPBUFFERDCARB_DECL
  #define WGLRELEASEPBUFFERDCARB_DECL
  csWGLRELEASEPBUFFERDCARB wglReleasePbufferDCARB;
  #endif

  #ifndef WGLDESTROYPBUFFERARB_DECL
  #define WGLDESTROYPBUFFERARB_DECL
  csWGLDESTROYPBUFFERARB wglDestroyPbufferARB;
  #endif

  #ifndef WGLQUERYPBUFFERARB_DECL
  #define WGLQUERYPBUFFERARB_DECL
  csWGLQUERYPBUFFERARB wglQueryPbufferARB;
  #endif


#endif // _WIN32

  // WGL_EXT_swap_control
#ifdef _WIN32
  #ifndef WGLSWAPINTERVALEXT_DECL
  #define WGLSWAPINTERVALEXT_DECL
  csWGLSWAPINTERVALEXT wglSwapIntervalEXT;
  #endif

  #ifndef WGLGETSWAPINTERVALEXT_DECL
  #define WGLGETSWAPINTERVALEXT_DECL
  csWGLGETSWAPINTERVALEXT wglGetSwapIntervalEXT;
  #endif


#endif // _WIN32

  // WGL_ARB_render_texture
#ifdef _WIN32
  #ifndef WGLBINDTEXIMAGEARB_DECL
  #define WGLBINDTEXIMAGEARB_DECL
  csWGLBINDTEXIMAGEARB wglBindTexImageARB;
  #endif

  #ifndef WGLRELEASETEXIMAGEARB_DECL
  #define WGLRELEASETEXIMAGEARB_DECL
  csWGLRELEASETEXIMAGEARB wglReleaseTexImageARB;
  #endif

  #ifndef WGLSETPBUFFERATTRIBARB_DECL
  #define WGLSETPBUFFERATTRIBARB_DECL
  csWGLSETPBUFFERATTRIBARB wglSetPbufferAttribARB;
  #endif


#endif // _WIN32

  // WGL_EXT_extensions_string
#ifdef _WIN32
  #ifndef WGLGETEXTENSIONSSTRINGEXT_DECL
  #define WGLGETEXTENSIONSSTRINGEXT_DECL
  csWGLGETEXTENSIONSSTRINGEXT wglGetExtensionsStringEXT;
  #endif


#endif // _WIN32

  // WGL_EXT_make_current_read
#ifdef _WIN32
  #ifndef WGLMAKECONTEXTCURRENTEXT_DECL
  #define WGLMAKECONTEXTCURRENTEXT_DECL
  csWGLMAKECONTEXTCURRENTEXT wglMakeContextCurrentEXT;
  #endif

  #ifndef WGLGETCURRENTREADDCEXT_DECL
  #define WGLGETCURRENTREADDCEXT_DECL
  csWGLGETCURRENTREADDCEXT wglGetCurrentReadDCEXT;
  #endif


#endif // _WIN32

  // WGL_EXT_pbuffer
#ifdef _WIN32
  #ifndef WGLCREATEPBUFFEREXT_DECL
  #define WGLCREATEPBUFFEREXT_DECL
  csWGLCREATEPBUFFEREXT wglCreatePbufferEXT;
  #endif

  #ifndef WGLGETPBUFFERDCEXT_DECL
  #define WGLGETPBUFFERDCEXT_DECL
  csWGLGETPBUFFERDCEXT wglGetPbufferDCEXT;
  #endif

  #ifndef WGLRELEASEPBUFFERDCEXT_DECL
  #define WGLRELEASEPBUFFERDCEXT_DECL
  csWGLRELEASEPBUFFERDCEXT wglReleasePbufferDCEXT;
  #endif

  #ifndef WGLDESTROYPBUFFEREXT_DECL
  #define WGLDESTROYPBUFFEREXT_DECL
  csWGLDESTROYPBUFFEREXT wglDestroyPbufferEXT;
  #endif

  #ifndef WGLQUERYPBUFFEREXT_DECL
  #define WGLQUERYPBUFFEREXT_DECL
  csWGLQUERYPBUFFEREXT wglQueryPbufferEXT;
  #endif


#endif // _WIN32

  // WGL_EXT_pixel_format
#ifdef _WIN32
  #ifndef WGLGETPIXELFORMATATTRIBIVEXT_DECL
  #define WGLGETPIXELFORMATATTRIBIVEXT_DECL
  csWGLGETPIXELFORMATATTRIBIVEXT wglGetPixelFormatAttribivEXT;
  #endif

  #ifndef WGLGETPIXELFORMATATTRIBFVEXT_DECL
  #define WGLGETPIXELFORMATATTRIBFVEXT_DECL
  csWGLGETPIXELFORMATATTRIBFVEXT wglGetPixelFormatAttribfvEXT;
  #endif

  #ifndef WGLCHOOSEPIXELFORMATEXT_DECL
  #define WGLCHOOSEPIXELFORMATEXT_DECL
  csWGLCHOOSEPIXELFORMATEXT wglChoosePixelFormatEXT;
  #endif


#endif // _WIN32

  // WGL_I3D_digital_video_control
#ifdef _WIN32
  #ifndef WGLGETDIGITALVIDEOPARAMETERSI3D_DECL
  #define WGLGETDIGITALVIDEOPARAMETERSI3D_DECL
  csWGLGETDIGITALVIDEOPARAMETERSI3D wglGetDigitalVideoParametersI3D;
  #endif

  #ifndef WGLSETDIGITALVIDEOPARAMETERSI3D_DECL
  #define WGLSETDIGITALVIDEOPARAMETERSI3D_DECL
  csWGLSETDIGITALVIDEOPARAMETERSI3D wglSetDigitalVideoParametersI3D;
  #endif


#endif // _WIN32

  // WGL_I3D_gamma
#ifdef _WIN32
  #ifndef WGLGETGAMMATABLEPARAMETERSI3D_DECL
  #define WGLGETGAMMATABLEPARAMETERSI3D_DECL
  csWGLGETGAMMATABLEPARAMETERSI3D wglGetGammaTableParametersI3D;
  #endif

  #ifndef WGLSETGAMMATABLEPARAMETERSI3D_DECL
  #define WGLSETGAMMATABLEPARAMETERSI3D_DECL
  csWGLSETGAMMATABLEPARAMETERSI3D wglSetGammaTableParametersI3D;
  #endif

  #ifndef WGLGETGAMMATABLEI3D_DECL
  #define WGLGETGAMMATABLEI3D_DECL
  csWGLGETGAMMATABLEI3D wglGetGammaTableI3D;
  #endif

  #ifndef WGLSETGAMMATABLEI3D_DECL
  #define WGLSETGAMMATABLEI3D_DECL
  csWGLSETGAMMATABLEI3D wglSetGammaTableI3D;
  #endif


#endif // _WIN32

  // WGL_I3D_genlock
#ifdef _WIN32
  #ifndef WGLENABLEGENLOCKI3D_DECL
  #define WGLENABLEGENLOCKI3D_DECL
  csWGLENABLEGENLOCKI3D wglEnableGenlockI3D;
  #endif

  #ifndef WGLDISABLEGENLOCKI3D_DECL
  #define WGLDISABLEGENLOCKI3D_DECL
  csWGLDISABLEGENLOCKI3D wglDisableGenlockI3D;
  #endif

  #ifndef WGLISENABLEDGENLOCKI3D_DECL
  #define WGLISENABLEDGENLOCKI3D_DECL
  csWGLISENABLEDGENLOCKI3D wglIsEnabledGenlockI3D;
  #endif

  #ifndef WGLGENLOCKSOURCEI3D_DECL
  #define WGLGENLOCKSOURCEI3D_DECL
  csWGLGENLOCKSOURCEI3D wglGenlockSourceI3D;
  #endif

  #ifndef WGLGETGENLOCKSOURCEI3D_DECL
  #define WGLGETGENLOCKSOURCEI3D_DECL
  csWGLGETGENLOCKSOURCEI3D wglGetGenlockSourceI3D;
  #endif

  #ifndef WGLGENLOCKSOURCEEDGEI3D_DECL
  #define WGLGENLOCKSOURCEEDGEI3D_DECL
  csWGLGENLOCKSOURCEEDGEI3D wglGenlockSourceEdgeI3D;
  #endif

  #ifndef WGLGETGENLOCKSOURCEEDGEI3D_DECL
  #define WGLGETGENLOCKSOURCEEDGEI3D_DECL
  csWGLGETGENLOCKSOURCEEDGEI3D wglGetGenlockSourceEdgeI3D;
  #endif

  #ifndef WGLGENLOCKSAMPLERATEI3D_DECL
  #define WGLGENLOCKSAMPLERATEI3D_DECL
  csWGLGENLOCKSAMPLERATEI3D wglGenlockSampleRateI3D;
  #endif

  #ifndef WGLGETGENLOCKSAMPLERATEI3D_DECL
  #define WGLGETGENLOCKSAMPLERATEI3D_DECL
  csWGLGETGENLOCKSAMPLERATEI3D wglGetGenlockSampleRateI3D;
  #endif

  #ifndef WGLGENLOCKSOURCEDELAYI3D_DECL
  #define WGLGENLOCKSOURCEDELAYI3D_DECL
  csWGLGENLOCKSOURCEDELAYI3D wglGenlockSourceDelayI3D;
  #endif

  #ifndef WGLGETGENLOCKSOURCEDELAYI3D_DECL
  #define WGLGETGENLOCKSOURCEDELAYI3D_DECL
  csWGLGETGENLOCKSOURCEDELAYI3D wglGetGenlockSourceDelayI3D;
  #endif

  #ifndef WGLQUERYGENLOCKMAXSOURCEDELAYI3D_DECL
  #define WGLQUERYGENLOCKMAXSOURCEDELAYI3D_DECL
  csWGLQUERYGENLOCKMAXSOURCEDELAYI3D wglQueryGenlockMaxSourceDelayI3D;
  #endif


#endif // _WIN32

  // GL_ARB_matrix_palette
  #ifndef GLCURRENTPALETTEMATRIXARB_DECL
  #define GLCURRENTPALETTEMATRIXARB_DECL
  csGLCURRENTPALETTEMATRIXARB glCurrentPaletteMatrixARB;
  #endif

  #ifndef GLMATRIXINDEXUBVARB_DECL
  #define GLMATRIXINDEXUBVARB_DECL
  csGLMATRIXINDEXUBVARB glMatrixIndexubvARB;
  #endif

  #ifndef GLMATRIXINDEXUSVARB_DECL
  #define GLMATRIXINDEXUSVARB_DECL
  csGLMATRIXINDEXUSVARB glMatrixIndexusvARB;
  #endif

  #ifndef GLMATRIXINDEXUIVARB_DECL
  #define GLMATRIXINDEXUIVARB_DECL
  csGLMATRIXINDEXUIVARB glMatrixIndexuivARB;
  #endif

  #ifndef GLMATRIXINDEXPOINTERARB_DECL
  #define GLMATRIXINDEXPOINTERARB_DECL
  csGLMATRIXINDEXPOINTERARB glMatrixIndexPointerARB;
  #endif


  // GL_NV_element_array
  #ifndef GLELEMENTPOINTERNV_DECL
  #define GLELEMENTPOINTERNV_DECL
  csGLELEMENTPOINTERNV glElementPointerNV;
  #endif

  #ifndef GLDRAWELEMENTARRAYNV_DECL
  #define GLDRAWELEMENTARRAYNV_DECL
  csGLDRAWELEMENTARRAYNV glDrawElementArrayNV;
  #endif

  #ifndef GLDRAWRANGEELEMENTARRAYNV_DECL
  #define GLDRAWRANGEELEMENTARRAYNV_DECL
  csGLDRAWRANGEELEMENTARRAYNV glDrawRangeElementArrayNV;
  #endif

  #ifndef GLMULTIDRAWELEMENTARRAYNV_DECL
  #define GLMULTIDRAWELEMENTARRAYNV_DECL
  csGLMULTIDRAWELEMENTARRAYNV glMultiDrawElementArrayNV;
  #endif

  #ifndef GLMULTIDRAWRANGEELEMENTARRAYNV_DECL
  #define GLMULTIDRAWRANGEELEMENTARRAYNV_DECL
  csGLMULTIDRAWRANGEELEMENTARRAYNV glMultiDrawRangeElementArrayNV;
  #endif


  // GL_NV_float_buffer

  // GL_NV_fragment_program
  #ifndef GLPROGRAMNAMEDPARAMETER4FNV_DECL
  #define GLPROGRAMNAMEDPARAMETER4FNV_DECL
  csGLPROGRAMNAMEDPARAMETER4FNV glProgramNamedParameter4fNV;
  #endif

  #ifndef GLPROGRAMNAMEDPARAMETER4DNV_DECL
  #define GLPROGRAMNAMEDPARAMETER4DNV_DECL
  csGLPROGRAMNAMEDPARAMETER4DNV glProgramNamedParameter4dNV;
  #endif

  #ifndef GLGETPROGRAMNAMEDPARAMETERFVNV_DECL
  #define GLGETPROGRAMNAMEDPARAMETERFVNV_DECL
  csGLGETPROGRAMNAMEDPARAMETERFVNV glGetProgramNamedParameterfvNV;
  #endif

  #ifndef GLGETPROGRAMNAMEDPARAMETERDVNV_DECL
  #define GLGETPROGRAMNAMEDPARAMETERDVNV_DECL
  csGLGETPROGRAMNAMEDPARAMETERDVNV glGetProgramNamedParameterdvNV;
  #endif


  // GL_NV_primitive_restart
  #ifndef GLPRIMITIVERESTARTNV_DECL
  #define GLPRIMITIVERESTARTNV_DECL
  csGLPRIMITIVERESTARTNV glPrimitiveRestartNV;
  #endif

  #ifndef GLPRIMITIVERESTARTINDEXNV_DECL
  #define GLPRIMITIVERESTARTINDEXNV_DECL
  csGLPRIMITIVERESTARTINDEXNV glPrimitiveRestartIndexNV;
  #endif


  // GL_NV_vertex_program2

  // GL_ARB_vertex_buffer_object
  #ifndef GLBINDBUFFERARB_DECL
  #define GLBINDBUFFERARB_DECL
  csGLBINDBUFFERARB glBindBufferARB;
  #endif

  #ifndef GLDELETEBUFFERSARB_DECL
  #define GLDELETEBUFFERSARB_DECL
  csGLDELETEBUFFERSARB glDeleteBuffersARB;
  #endif

  #ifndef GLGENBUFFERSARB_DECL
  #define GLGENBUFFERSARB_DECL
  csGLGENBUFFERSARB glGenBuffersARB;
  #endif

  #ifndef GLBUFFERDATAARB_DECL
  #define GLBUFFERDATAARB_DECL
  csGLBUFFERDATAARB glBufferDataARB;
  #endif

  #ifndef GLBUFFERSUBDATAARB_DECL
  #define GLBUFFERSUBDATAARB_DECL
  csGLBUFFERSUBDATAARB glBufferSubDataARB;
  #endif

  #ifndef GLMAPBUFFERARB_DECL
  #define GLMAPBUFFERARB_DECL
  csGLMAPBUFFERARB glMapBufferARB;
  #endif

  #ifndef GLUNMAPBUFFERARB_DECL
  #define GLUNMAPBUFFERARB_DECL
  csGLUNMAPBUFFERARB glUnmapBufferARB;
  #endif

  #ifndef GLISBUFFERARB_DECL
  #define GLISBUFFERARB_DECL
  csGLISBUFFERARB glIsBufferARB;
  #endif

  #ifndef GLGETBUFFERSUBDATAARB_DECL
  #define GLGETBUFFERSUBDATAARB_DECL
  csGLGETBUFFERSUBDATAARB glGetBufferSubDataARB;
  #endif

  #ifndef GLGETBUFFERPOINTERVARB_DECL
  #define GLGETBUFFERPOINTERVARB_DECL
  csGLGETBUFFERPOINTERVARB glGetBufferPointervARB;
  #endif

  #ifndef GLGETBUFFERPARAMETERIVARB_DECL
  #define GLGETBUFFERPARAMETERIVARB_DECL
  csGLGETBUFFERPARAMETERIVARB glGetBufferParameterivARB;
  #endif


  // GL_ATI_separate_stencil
  #ifndef GLSTENCILOPSEPARATEATI_DECL
  #define GLSTENCILOPSEPARATEATI_DECL
  csGLSTENCILOPSEPARATEATI glStencilOpSeparateATI;
  #endif

  #ifndef GLSTENCILFUNCSEPARATEATI_DECL
  #define GLSTENCILFUNCSEPARATEATI_DECL
  csGLSTENCILFUNCSEPARATEATI glStencilFuncSeparateATI;
  #endif


  // GL_ARB_texture_non_power_of_two

  // GL_ARB_point_sprite

  // GL_ARB_shading_language_100

  // GL_ARB_shader_objects
  #ifndef GLDELETEOBJECTARB_DECL
  #define GLDELETEOBJECTARB_DECL
  csGLDELETEOBJECTARB glDeleteObjectARB;
  #endif

  #ifndef GLGETHANDLEARB_DECL
  #define GLGETHANDLEARB_DECL
  csGLGETHANDLEARB glGetHandleARB;
  #endif

  #ifndef GLDETACHOBJECTARB_DECL
  #define GLDETACHOBJECTARB_DECL
  csGLDETACHOBJECTARB glDetachObjectARB;
  #endif

  #ifndef GLCREATESHADEROBJECTARB_DECL
  #define GLCREATESHADEROBJECTARB_DECL
  csGLCREATESHADEROBJECTARB glCreateShaderObjectARB;
  #endif

  #ifndef GLSHADERSOURCEARB_DECL
  #define GLSHADERSOURCEARB_DECL
  csGLSHADERSOURCEARB glShaderSourceARB;
  #endif

  #ifndef GLCOMPILESHADERARB_DECL
  #define GLCOMPILESHADERARB_DECL
  csGLCOMPILESHADERARB glCompileShaderARB;
  #endif

  #ifndef GLCREATEPROGRAMOBJECTARB_DECL
  #define GLCREATEPROGRAMOBJECTARB_DECL
  csGLCREATEPROGRAMOBJECTARB glCreateProgramObjectARB;
  #endif

  #ifndef GLATTACHOBJECTARB_DECL
  #define GLATTACHOBJECTARB_DECL
  csGLATTACHOBJECTARB glAttachObjectARB;
  #endif

  #ifndef GLLINKPROGRAMARB_DECL
  #define GLLINKPROGRAMARB_DECL
  csGLLINKPROGRAMARB glLinkProgramARB;
  #endif

  #ifndef GLUSEPROGRAMOBJECTARB_DECL
  #define GLUSEPROGRAMOBJECTARB_DECL
  csGLUSEPROGRAMOBJECTARB glUseProgramObjectARB;
  #endif

  #ifndef GLVALIDATEPROGRAMARB_DECL
  #define GLVALIDATEPROGRAMARB_DECL
  csGLVALIDATEPROGRAMARB glValidateProgramARB;
  #endif

  #ifndef GLUNIFORM1FARB_DECL
  #define GLUNIFORM1FARB_DECL
  csGLUNIFORM1FARB glUniform1fARB;
  #endif

  #ifndef GLUNIFORM2FARB_DECL
  #define GLUNIFORM2FARB_DECL
  csGLUNIFORM2FARB glUniform2fARB;
  #endif

  #ifndef GLUNIFORM3FARB_DECL
  #define GLUNIFORM3FARB_DECL
  csGLUNIFORM3FARB glUniform3fARB;
  #endif

  #ifndef GLUNIFORM4FARB_DECL
  #define GLUNIFORM4FARB_DECL
  csGLUNIFORM4FARB glUniform4fARB;
  #endif

  #ifndef GLUNIFORM1IARB_DECL
  #define GLUNIFORM1IARB_DECL
  csGLUNIFORM1IARB glUniform1iARB;
  #endif

  #ifndef GLUNIFORM2IARB_DECL
  #define GLUNIFORM2IARB_DECL
  csGLUNIFORM2IARB glUniform2iARB;
  #endif

  #ifndef GLUNIFORM3IARB_DECL
  #define GLUNIFORM3IARB_DECL
  csGLUNIFORM3IARB glUniform3iARB;
  #endif

  #ifndef GLUNIFORM4IARB_DECL
  #define GLUNIFORM4IARB_DECL
  csGLUNIFORM4IARB glUniform4iARB;
  #endif

  #ifndef GLUNIFORM1FVARB_DECL
  #define GLUNIFORM1FVARB_DECL
  csGLUNIFORM1FVARB glUniform1fvARB;
  #endif

  #ifndef GLUNIFORM2FVARB_DECL
  #define GLUNIFORM2FVARB_DECL
  csGLUNIFORM2FVARB glUniform2fvARB;
  #endif

  #ifndef GLUNIFORM3FVARB_DECL
  #define GLUNIFORM3FVARB_DECL
  csGLUNIFORM3FVARB glUniform3fvARB;
  #endif

  #ifndef GLUNIFORM4FVARB_DECL
  #define GLUNIFORM4FVARB_DECL
  csGLUNIFORM4FVARB glUniform4fvARB;
  #endif

  #ifndef GLUNIFORM1IVARB_DECL
  #define GLUNIFORM1IVARB_DECL
  csGLUNIFORM1IVARB glUniform1ivARB;
  #endif

  #ifndef GLUNIFORM2IVARB_DECL
  #define GLUNIFORM2IVARB_DECL
  csGLUNIFORM2IVARB glUniform2ivARB;
  #endif

  #ifndef GLUNIFORM3IVARB_DECL
  #define GLUNIFORM3IVARB_DECL
  csGLUNIFORM3IVARB glUniform3ivARB;
  #endif

  #ifndef GLUNIFORM4IVARB_DECL
  #define GLUNIFORM4IVARB_DECL
  csGLUNIFORM4IVARB glUniform4ivARB;
  #endif

  #ifndef GLUNIFORMMATRIX2FVARB_DECL
  #define GLUNIFORMMATRIX2FVARB_DECL
  csGLUNIFORMMATRIX2FVARB glUniformMatrix2fvARB;
  #endif

  #ifndef GLUNIFORMMATRIX3FVARB_DECL
  #define GLUNIFORMMATRIX3FVARB_DECL
  csGLUNIFORMMATRIX3FVARB glUniformMatrix3fvARB;
  #endif

  #ifndef GLUNIFORMMATRIX4FVARB_DECL
  #define GLUNIFORMMATRIX4FVARB_DECL
  csGLUNIFORMMATRIX4FVARB glUniformMatrix4fvARB;
  #endif

  #ifndef GLGETOBJECTPARAMETERFVARB_DECL
  #define GLGETOBJECTPARAMETERFVARB_DECL
  csGLGETOBJECTPARAMETERFVARB glGetObjectParameterfvARB;
  #endif

  #ifndef GLGETOBJECTPARAMETERIVARB_DECL
  #define GLGETOBJECTPARAMETERIVARB_DECL
  csGLGETOBJECTPARAMETERIVARB glGetObjectParameterivARB;
  #endif

  #ifndef GLGETINFOLOGARB_DECL
  #define GLGETINFOLOGARB_DECL
  csGLGETINFOLOGARB glGetInfoLogARB;
  #endif

  #ifndef GLGETATTACHEDOBJECTSARB_DECL
  #define GLGETATTACHEDOBJECTSARB_DECL
  csGLGETATTACHEDOBJECTSARB glGetAttachedObjectsARB;
  #endif

  #ifndef GLGETUNIFORMLOCATIONARB_DECL
  #define GLGETUNIFORMLOCATIONARB_DECL
  csGLGETUNIFORMLOCATIONARB glGetUniformLocationARB;
  #endif

  #ifndef GLGETACTIVEUNIFORMARB_DECL
  #define GLGETACTIVEUNIFORMARB_DECL
  csGLGETACTIVEUNIFORMARB glGetActiveUniformARB;
  #endif

  #ifndef GLGETUNIFORMFVARB_DECL
  #define GLGETUNIFORMFVARB_DECL
  csGLGETUNIFORMFVARB glGetUniformfvARB;
  #endif

  #ifndef GLGETUNIFORMIVARB_DECL
  #define GLGETUNIFORMIVARB_DECL
  csGLGETUNIFORMIVARB glGetUniformivARB;
  #endif

  #ifndef GLGETSHADERSOURCEARB_DECL
  #define GLGETSHADERSOURCEARB_DECL
  csGLGETSHADERSOURCEARB glGetShaderSourceARB;
  #endif


  // GL_ARB_fragment_shader

  // GL_ARB_vertex_shader
  #ifndef GLBINDATTRIBLOCATIONARB_DECL
  #define GLBINDATTRIBLOCATIONARB_DECL
  csGLBINDATTRIBLOCATIONARB glBindAttribLocationARB;
  #endif

  #ifndef GLGETACTIVEATTRIBARB_DECL
  #define GLGETACTIVEATTRIBARB_DECL
  csGLGETACTIVEATTRIBARB glGetActiveAttribARB;
  #endif

  #ifndef GLGETATTRIBLOCATIONARB_DECL
  #define GLGETATTRIBLOCATIONARB_DECL
  csGLGETATTRIBLOCATIONARB glGetAttribLocationARB;
  #endif



// end of functions
};

struct csGLExtensionFlags
{
public:
  bool CS_GL_version_1_2;
  bool CS_GL_version_1_3;
  bool CS_GL_ARB_imaging;
  bool CS_GL_ARB_multitexture;
  bool CS_GL_ARB_transpose_matrix;
  bool CS_GL_ARB_multisample;
  bool CS_GL_ARB_texture_env_add;
  bool CS_WGL_ARB_extensions_string;
  bool CS_WGL_ARB_buffer_region;
  bool CS_GL_ARB_texture_cube_map;
  bool CS_GL_ARB_depth_texture;
  bool CS_GL_ARB_point_parameters;
  bool CS_GL_ARB_shadow;
  bool CS_GL_ARB_shadow_ambient;
  bool CS_GL_ARB_texture_border_clamp;
  bool CS_GL_ARB_texture_compression;
  bool CS_GL_ARB_texture_env_combine;
  bool CS_GL_ARB_texture_env_crossbar;
  bool CS_GL_ARB_texture_env_dot3;
  bool CS_GL_ARB_texture_mirrored_repeat;
  bool CS_GL_ARB_vertex_blend;
  bool CS_GL_ARB_vertex_program;
  bool CS_GL_ARB_window_pos;
  bool CS_GL_EXT_422_pixels;
  bool CS_GL_EXT_abgr;
  bool CS_GL_EXT_bgra;
  bool CS_GL_EXT_blend_color;
  bool CS_GL_EXT_blend_func_separate;
  bool CS_GL_EXT_blend_logic_op;
  bool CS_GL_EXT_blend_minmax;
  bool CS_GL_EXT_blend_subtract;
  bool CS_GL_EXT_clip_volume_hint;
  bool CS_GL_EXT_color_subtable;
  bool CS_GL_EXT_compiled_vertex_array;
  bool CS_GL_EXT_convolution;
  bool CS_GL_EXT_fog_coord;
  bool CS_GL_EXT_histogram;
  bool CS_GL_EXT_multi_draw_arrays;
  bool CS_GL_EXT_packed_pixels;
  bool CS_GL_EXT_paletted_texture;
  bool CS_GL_EXT_point_parameters;
  bool CS_GL_EXT_polygon_offset;
  bool CS_GL_EXT_secondary_color;
  bool CS_GL_EXT_separate_specular_color;
  bool CS_GL_EXT_shadow_funcs;
  bool CS_GL_EXT_shared_texture_palette;
  bool CS_GL_EXT_stencil_two_side;
  bool CS_GL_EXT_stencil_wrap;
  bool CS_GL_EXT_subtexture;
  bool CS_GL_EXT_texture3D;
  bool CS_GL_EXT_texture_compression_s3tc;
  bool CS_GL_EXT_texture_env_add;
  bool CS_GL_EXT_texture_env_combine;
  bool CS_GL_EXT_texture_env_dot3;
  bool CS_GL_EXT_texture_filter_anisotropic;
  bool CS_GL_EXT_texture_lod_bias;
  bool CS_GL_EXT_texture_object;
  bool CS_GL_EXT_vertex_array;
  bool CS_GL_EXT_vertex_shader;
  bool CS_GL_EXT_vertex_weighting;
  bool CS_GL_HP_occlusion_test;
  bool CS_GL_NV_blend_square;
  bool CS_GL_NV_copy_depth_to_color;
  bool CS_GL_NV_depth_clamp;
  bool CS_GL_NV_evaluators;
  bool CS_GL_NV_fence;
  bool CS_GL_NV_fog_distance;
  bool CS_GL_NV_light_max_exponent;
  bool CS_GL_NV_multisample_filter_hint;
  bool CS_GL_NV_occlusion_query;
  bool CS_GL_NV_packed_depth_stencil;
  bool CS_GL_NV_point_sprite;
  bool CS_GL_NV_register_combiners;
  bool CS_GL_NV_register_combiners2;
  bool CS_GL_NV_texgen_emboss;
  bool CS_GL_NV_texgen_reflection;
  bool CS_GL_NV_texture_compression_vtc;
  bool CS_GL_NV_texture_env_combine4;
  bool CS_GL_NV_texture_rectangle;
  bool CS_GL_NV_texture_shader;
  bool CS_GL_NV_texture_shader2;
  bool CS_GL_NV_texture_shader3;
  bool CS_GL_NV_vertex_array_range;
  bool CS_GL_NV_vertex_array_range2;
  bool CS_GL_NV_vertex_program;
  bool CS_GL_NV_vertex_program1_1;
  bool CS_GL_ATI_element_array;
  bool CS_GL_ATI_envmap_bumpmap;
  bool CS_GL_ATI_fragment_shader;
  bool CS_GL_ATI_pn_triangles;
  bool CS_GL_ATI_texture_mirror_once;
  bool CS_GL_ATI_vertex_array_object;
  bool CS_GL_ATI_vertex_attrib_array_object;
  bool CS_GL_ATI_vertex_streams;
  bool CS_WGL_I3D_image_buffer;
  bool CS_WGL_I3D_swap_frame_lock;
  bool CS_WGL_I3D_swap_frame_usage;
  bool CS_GL_3DFX_texture_compression_FXT1;
  bool CS_GL_IBM_cull_vertex;
  bool CS_GL_IBM_multimode_draw_arrays;
  bool CS_GL_IBM_raster_pos_clip;
  bool CS_GL_IBM_texture_mirrored_repeat;
  bool CS_GL_IBM_vertex_array_lists;
  bool CS_GL_MESA_resize_buffers;
  bool CS_GL_MESA_window_pos;
  bool CS_GL_OML_interlace;
  bool CS_GL_OML_resample;
  bool CS_GL_OML_subsample;
  bool CS_GL_SGIS_generate_mipmap;
  bool CS_GL_SGIS_multisample;
  bool CS_GL_SGIS_pixel_texture;
  bool CS_GL_SGIS_texture_border_clamp;
  bool CS_GL_SGIS_texture_color_mask;
  bool CS_GL_SGIS_texture_edge_clamp;
  bool CS_GL_SGIS_texture_lod;
  bool CS_GL_SGIS_depth_texture;
  bool CS_GL_SGIX_fog_offset;
  bool CS_GL_SGIX_interlace;
  bool CS_GL_SGIX_shadow_ambient;
  bool CS_GL_SGI_color_matrix;
  bool CS_GL_SGI_color_table;
  bool CS_GL_SGI_texture_color_table;
  bool CS_GL_SUN_vertex;
  bool CS_GL_ARB_fragment_program;
  bool CS_GL_ATI_text_fragment_shader;
  bool CS_GL_APPLE_client_storage;
  bool CS_GL_APPLE_element_array;
  bool CS_GL_APPLE_fence;
  bool CS_GL_APPLE_vertex_array_object;
  bool CS_GL_APPLE_vertex_array_range;
  bool CS_WGL_ARB_pixel_format;
  bool CS_WGL_ARB_make_current_read;
  bool CS_WGL_ARB_pbuffer;
  bool CS_WGL_EXT_swap_control;
  bool CS_WGL_ARB_render_texture;
  bool CS_WGL_EXT_extensions_string;
  bool CS_WGL_EXT_make_current_read;
  bool CS_WGL_EXT_pbuffer;
  bool CS_WGL_EXT_pixel_format;
  bool CS_WGL_I3D_digital_video_control;
  bool CS_WGL_I3D_gamma;
  bool CS_WGL_I3D_genlock;
  bool CS_GL_ARB_matrix_palette;
  bool CS_GL_NV_element_array;
  bool CS_GL_NV_float_buffer;
  bool CS_GL_NV_fragment_program;
  bool CS_GL_NV_primitive_restart;
  bool CS_GL_NV_vertex_program2;
  bool CS_GL_ARB_vertex_buffer_object;
  bool CS_GL_ATI_separate_stencil;
  bool CS_GL_ARB_texture_non_power_of_two;
  bool CS_GL_ARB_point_sprite;
  bool CS_GL_ARB_shading_language_100;
  bool CS_GL_ARB_shader_objects;
  bool CS_GL_ARB_fragment_shader;
  bool CS_GL_ARB_vertex_shader;

protected:
  bool tested_CS_GL_version_1_2;
  bool tested_CS_GL_version_1_3;
  bool tested_CS_GL_ARB_imaging;
  bool tested_CS_GL_ARB_multitexture;
  bool tested_CS_GL_ARB_transpose_matrix;
  bool tested_CS_GL_ARB_multisample;
  bool tested_CS_GL_ARB_texture_env_add;
  bool tested_CS_WGL_ARB_extensions_string;
  bool tested_CS_WGL_ARB_buffer_region;
  bool tested_CS_GL_ARB_texture_cube_map;
  bool tested_CS_GL_ARB_depth_texture;
  bool tested_CS_GL_ARB_point_parameters;
  bool tested_CS_GL_ARB_shadow;
  bool tested_CS_GL_ARB_shadow_ambient;
  bool tested_CS_GL_ARB_texture_border_clamp;
  bool tested_CS_GL_ARB_texture_compression;
  bool tested_CS_GL_ARB_texture_env_combine;
  bool tested_CS_GL_ARB_texture_env_crossbar;
  bool tested_CS_GL_ARB_texture_env_dot3;
  bool tested_CS_GL_ARB_texture_mirrored_repeat;
  bool tested_CS_GL_ARB_vertex_blend;
  bool tested_CS_GL_ARB_vertex_program;
  bool tested_CS_GL_ARB_window_pos;
  bool tested_CS_GL_EXT_422_pixels;
  bool tested_CS_GL_EXT_abgr;
  bool tested_CS_GL_EXT_bgra;
  bool tested_CS_GL_EXT_blend_color;
  bool tested_CS_GL_EXT_blend_func_separate;
  bool tested_CS_GL_EXT_blend_logic_op;
  bool tested_CS_GL_EXT_blend_minmax;
  bool tested_CS_GL_EXT_blend_subtract;
  bool tested_CS_GL_EXT_clip_volume_hint;
  bool tested_CS_GL_EXT_color_subtable;
  bool tested_CS_GL_EXT_compiled_vertex_array;
  bool tested_CS_GL_EXT_convolution;
  bool tested_CS_GL_EXT_fog_coord;
  bool tested_CS_GL_EXT_histogram;
  bool tested_CS_GL_EXT_multi_draw_arrays;
  bool tested_CS_GL_EXT_packed_pixels;
  bool tested_CS_GL_EXT_paletted_texture;
  bool tested_CS_GL_EXT_point_parameters;
  bool tested_CS_GL_EXT_polygon_offset;
  bool tested_CS_GL_EXT_secondary_color;
  bool tested_CS_GL_EXT_separate_specular_color;
  bool tested_CS_GL_EXT_shadow_funcs;
  bool tested_CS_GL_EXT_shared_texture_palette;
  bool tested_CS_GL_EXT_stencil_two_side;
  bool tested_CS_GL_EXT_stencil_wrap;
  bool tested_CS_GL_EXT_subtexture;
  bool tested_CS_GL_EXT_texture3D;
  bool tested_CS_GL_EXT_texture_compression_s3tc;
  bool tested_CS_GL_EXT_texture_env_add;
  bool tested_CS_GL_EXT_texture_env_combine;
  bool tested_CS_GL_EXT_texture_env_dot3;
  bool tested_CS_GL_EXT_texture_filter_anisotropic;
  bool tested_CS_GL_EXT_texture_lod_bias;
  bool tested_CS_GL_EXT_texture_object;
  bool tested_CS_GL_EXT_vertex_array;
  bool tested_CS_GL_EXT_vertex_shader;
  bool tested_CS_GL_EXT_vertex_weighting;
  bool tested_CS_GL_HP_occlusion_test;
  bool tested_CS_GL_NV_blend_square;
  bool tested_CS_GL_NV_copy_depth_to_color;
  bool tested_CS_GL_NV_depth_clamp;
  bool tested_CS_GL_NV_evaluators;
  bool tested_CS_GL_NV_fence;
  bool tested_CS_GL_NV_fog_distance;
  bool tested_CS_GL_NV_light_max_exponent;
  bool tested_CS_GL_NV_multisample_filter_hint;
  bool tested_CS_GL_NV_occlusion_query;
  bool tested_CS_GL_NV_packed_depth_stencil;
  bool tested_CS_GL_NV_point_sprite;
  bool tested_CS_GL_NV_register_combiners;
  bool tested_CS_GL_NV_register_combiners2;
  bool tested_CS_GL_NV_texgen_emboss;
  bool tested_CS_GL_NV_texgen_reflection;
  bool tested_CS_GL_NV_texture_compression_vtc;
  bool tested_CS_GL_NV_texture_env_combine4;
  bool tested_CS_GL_NV_texture_rectangle;
  bool tested_CS_GL_NV_texture_shader;
  bool tested_CS_GL_NV_texture_shader2;
  bool tested_CS_GL_NV_texture_shader3;
  bool tested_CS_GL_NV_vertex_array_range;
  bool tested_CS_GL_NV_vertex_array_range2;
  bool tested_CS_GL_NV_vertex_program;
  bool tested_CS_GL_NV_vertex_program1_1;
  bool tested_CS_GL_ATI_element_array;
  bool tested_CS_GL_ATI_envmap_bumpmap;
  bool tested_CS_GL_ATI_fragment_shader;
  bool tested_CS_GL_ATI_pn_triangles;
  bool tested_CS_GL_ATI_texture_mirror_once;
  bool tested_CS_GL_ATI_vertex_array_object;
  bool tested_CS_GL_ATI_vertex_attrib_array_object;
  bool tested_CS_GL_ATI_vertex_streams;
  bool tested_CS_WGL_I3D_image_buffer;
  bool tested_CS_WGL_I3D_swap_frame_lock;
  bool tested_CS_WGL_I3D_swap_frame_usage;
  bool tested_CS_GL_3DFX_texture_compression_FXT1;
  bool tested_CS_GL_IBM_cull_vertex;
  bool tested_CS_GL_IBM_multimode_draw_arrays;
  bool tested_CS_GL_IBM_raster_pos_clip;
  bool tested_CS_GL_IBM_texture_mirrored_repeat;
  bool tested_CS_GL_IBM_vertex_array_lists;
  bool tested_CS_GL_MESA_resize_buffers;
  bool tested_CS_GL_MESA_window_pos;
  bool tested_CS_GL_OML_interlace;
  bool tested_CS_GL_OML_resample;
  bool tested_CS_GL_OML_subsample;
  bool tested_CS_GL_SGIS_generate_mipmap;
  bool tested_CS_GL_SGIS_multisample;
  bool tested_CS_GL_SGIS_pixel_texture;
  bool tested_CS_GL_SGIS_texture_border_clamp;
  bool tested_CS_GL_SGIS_texture_color_mask;
  bool tested_CS_GL_SGIS_texture_edge_clamp;
  bool tested_CS_GL_SGIS_texture_lod;
  bool tested_CS_GL_SGIS_depth_texture;
  bool tested_CS_GL_SGIX_fog_offset;
  bool tested_CS_GL_SGIX_interlace;
  bool tested_CS_GL_SGIX_shadow_ambient;
  bool tested_CS_GL_SGI_color_matrix;
  bool tested_CS_GL_SGI_color_table;
  bool tested_CS_GL_SGI_texture_color_table;
  bool tested_CS_GL_SUN_vertex;
  bool tested_CS_GL_ARB_fragment_program;
  bool tested_CS_GL_ATI_text_fragment_shader;
  bool tested_CS_GL_APPLE_client_storage;
  bool tested_CS_GL_APPLE_element_array;
  bool tested_CS_GL_APPLE_fence;
  bool tested_CS_GL_APPLE_vertex_array_object;
  bool tested_CS_GL_APPLE_vertex_array_range;
  bool tested_CS_WGL_ARB_pixel_format;
  bool tested_CS_WGL_ARB_make_current_read;
  bool tested_CS_WGL_ARB_pbuffer;
  bool tested_CS_WGL_EXT_swap_control;
  bool tested_CS_WGL_ARB_render_texture;
  bool tested_CS_WGL_EXT_extensions_string;
  bool tested_CS_WGL_EXT_make_current_read;
  bool tested_CS_WGL_EXT_pbuffer;
  bool tested_CS_WGL_EXT_pixel_format;
  bool tested_CS_WGL_I3D_digital_video_control;
  bool tested_CS_WGL_I3D_gamma;
  bool tested_CS_WGL_I3D_genlock;
  bool tested_CS_GL_ARB_matrix_palette;
  bool tested_CS_GL_NV_element_array;
  bool tested_CS_GL_NV_float_buffer;
  bool tested_CS_GL_NV_fragment_program;
  bool tested_CS_GL_NV_primitive_restart;
  bool tested_CS_GL_NV_vertex_program2;
  bool tested_CS_GL_ARB_vertex_buffer_object;
  bool tested_CS_GL_ATI_separate_stencil;
  bool tested_CS_GL_ARB_texture_non_power_of_two;
  bool tested_CS_GL_ARB_point_sprite;
  bool tested_CS_GL_ARB_shading_language_100;
  bool tested_CS_GL_ARB_shader_objects;
  bool tested_CS_GL_ARB_fragment_shader;
  bool tested_CS_GL_ARB_vertex_shader;

};

struct csGLExtensionManager : public csGLExtensionFunctions,
			      public csGLExtensionFlags
{
private:
  iObjectRegistry* object_reg;
  csConfigAccess config;
  iOpenGLInterface* gl;
  
  const char* extstrGL;
  const char* msgExtRetrieveFail;
  const char* msgExtFoundAndUsed;
  const char* msgExtFoundAndNotUsed;
  const char* msgExtInitFail;
  const char* msgExtNotFound;
#ifdef __WIN32__
  const char* extstrWGL;
  
  void SetupWGLextStr (HDC hDC)
  {
    if (extstrWGL != 0) return;
  
    if (!tested_CS_WGL_ARB_extensions_string) InitWGL_ARB_extensions_string (hDC);
    if (CS_WGL_ARB_extensions_string)
    {
      extstrWGL = wglGetExtensionsStringARB (hDC);
    }
    else
    {
      extstrWGL = extstrGL;
    }
  }
#endif

  void Report (const char* msg, ...)
  {
    csRef<iCommandLineParser> cmdline (
      CS_QUERY_REGISTRY (object_reg, iCommandLineParser));
    
    if (cmdline->GetOption ("verbose") == 0)
      return;
    
    va_list arg;
    va_start (arg, msg);
    csRef<iReporter> rep (CS_QUERY_REGISTRY (object_reg, iReporter));
    if (rep)
      rep->ReportV (CS_REPORTER_SEVERITY_NOTIFY,
         "crystalspace.canvas.opengl.extmgr", msg, arg);
    else
    {
      csPrintfV (msg, arg);
      csPrintf ("\n");
    }
    va_end (arg);
  }

public:
  void Initialize (iObjectRegistry* object_reg, iGraphics2D* g2d)
  {
    csGLExtensionManager::object_reg = object_reg;
    gl = csRef<iOpenGLInterface>
      (SCF_QUERY_INTERFACE (g2d, iOpenGLInterface));
    // Low priority so canvas/renderer cfgs may override the settings
    config.AddConfig (object_reg, "/config/glext.cfg", true,
      iConfigManager::ConfigPriorityPlugin - 1);
}
  
  void Open () 
  { 
    extstrGL = (const char*)glGetString (GL_EXTENSIONS);
  }
  
  void Close () { }
public:
  void Reset ()
  {
    extstrGL = 0;
#ifdef __WIN32__
    extstrWGL = 0;
#endif

    memset ((csGLExtensionFunctions*)this, 0, 
      sizeof (csGLExtensionFunctions));
    memset ((csGLExtensionFlags*)this, 0, sizeof (csGLExtensionFlags));
  }
  
  csGLExtensionManager () : object_reg (0), gl (0)
  {
    msgExtRetrieveFail = "Failed to retrieve %s";
    msgExtFoundAndUsed = "%s Extension '%s' found and used.";
    msgExtFoundAndNotUsed = "%s Extension '%s' found, but not used.";
    msgExtInitFail = "%s Extension '%s' failed to initialize.";
    msgExtNotFound = "%s Extension '%s' not found.";
    
    Reset ();
  }
  
  void InitGL_version_1_2 ()
  {
    if (tested_CS_GL_version_1_2) return;
    tested_CS_GL_version_1_2 = true;
    const char* ext = "GL_version_1_2";
    char cfgkey[26 + 14 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_version_1_2 = true;

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_version_1_2;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glDrawRangeElements, GLDRAWRANGEELEMENTS);
      EXTMGR_FUNC_INIT(glTexImage3D, GLTEXIMAGE3D);
      EXTMGR_FUNC_INIT(glTexSubImage3D, GLTEXSUBIMAGE3D);
      EXTMGR_FUNC_INIT(glCopyTexSubImage3D, GLCOPYTEXSUBIMAGE3D);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_version_1_2)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_version_1_3 ()
  {
    if (tested_CS_GL_version_1_3) return;
    tested_CS_GL_version_1_3 = true;
    const char* ext = "GL_version_1_3";
    char cfgkey[26 + 14 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_version_1_3 = true;

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_version_1_3;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glActiveTexture, GLACTIVETEXTURE);
      EXTMGR_FUNC_INIT(glClientActiveTexture, GLCLIENTACTIVETEXTURE);
      EXTMGR_FUNC_INIT(glMultiTexCoord1d, GLMULTITEXCOORD1D);
      EXTMGR_FUNC_INIT(glMultiTexCoord1dv, GLMULTITEXCOORD1DV);
      EXTMGR_FUNC_INIT(glMultiTexCoord1f, GLMULTITEXCOORD1F);
      EXTMGR_FUNC_INIT(glMultiTexCoord1fv, GLMULTITEXCOORD1FV);
      EXTMGR_FUNC_INIT(glMultiTexCoord1i, GLMULTITEXCOORD1I);
      EXTMGR_FUNC_INIT(glMultiTexCoord1iv, GLMULTITEXCOORD1IV);
      EXTMGR_FUNC_INIT(glMultiTexCoord1s, GLMULTITEXCOORD1S);
      EXTMGR_FUNC_INIT(glMultiTexCoord1sv, GLMULTITEXCOORD1SV);
      EXTMGR_FUNC_INIT(glMultiTexCoord2d, GLMULTITEXCOORD2D);
      EXTMGR_FUNC_INIT(glMultiTexCoord2dv, GLMULTITEXCOORD2DV);
      EXTMGR_FUNC_INIT(glMultiTexCoord2f, GLMULTITEXCOORD2F);
      EXTMGR_FUNC_INIT(glMultiTexCoord2fv, GLMULTITEXCOORD2FV);
      EXTMGR_FUNC_INIT(glMultiTexCoord2i, GLMULTITEXCOORD2I);
      EXTMGR_FUNC_INIT(glMultiTexCoord2iv, GLMULTITEXCOORD2IV);
      EXTMGR_FUNC_INIT(glMultiTexCoord2s, GLMULTITEXCOORD2S);
      EXTMGR_FUNC_INIT(glMultiTexCoord2sv, GLMULTITEXCOORD2SV);
      EXTMGR_FUNC_INIT(glMultiTexCoord3d, GLMULTITEXCOORD3D);
      EXTMGR_FUNC_INIT(glMultiTexCoord3dv, GLMULTITEXCOORD3DV);
      EXTMGR_FUNC_INIT(glMultiTexCoord3f, GLMULTITEXCOORD3F);
      EXTMGR_FUNC_INIT(glMultiTexCoord3fv, GLMULTITEXCOORD3FV);
      EXTMGR_FUNC_INIT(glMultiTexCoord3i, GLMULTITEXCOORD3I);
      EXTMGR_FUNC_INIT(glMultiTexCoord3iv, GLMULTITEXCOORD3IV);
      EXTMGR_FUNC_INIT(glMultiTexCoord3s, GLMULTITEXCOORD3S);
      EXTMGR_FUNC_INIT(glMultiTexCoord3sv, GLMULTITEXCOORD3SV);
      EXTMGR_FUNC_INIT(glMultiTexCoord4d, GLMULTITEXCOORD4D);
      EXTMGR_FUNC_INIT(glMultiTexCoord4dv, GLMULTITEXCOORD4DV);
      EXTMGR_FUNC_INIT(glMultiTexCoord4f, GLMULTITEXCOORD4F);
      EXTMGR_FUNC_INIT(glMultiTexCoord4fv, GLMULTITEXCOORD4FV);
      EXTMGR_FUNC_INIT(glMultiTexCoord4i, GLMULTITEXCOORD4I);
      EXTMGR_FUNC_INIT(glMultiTexCoord4iv, GLMULTITEXCOORD4IV);
      EXTMGR_FUNC_INIT(glMultiTexCoord4s, GLMULTITEXCOORD4S);
      EXTMGR_FUNC_INIT(glMultiTexCoord4sv, GLMULTITEXCOORD4SV);
      EXTMGR_FUNC_INIT(glLoadTransposeMatrixf, GLLOADTRANSPOSEMATRIXF);
      EXTMGR_FUNC_INIT(glLoadTransposeMatrixd, GLLOADTRANSPOSEMATRIXD);
      EXTMGR_FUNC_INIT(glMultTransposeMatrixf, GLMULTTRANSPOSEMATRIXF);
      EXTMGR_FUNC_INIT(glMultTransposeMatrixd, GLMULTTRANSPOSEMATRIXD);
      EXTMGR_FUNC_INIT(glSampleCoverage, GLSAMPLECOVERAGE);
      EXTMGR_FUNC_INIT(glCompressedTexImage3D, GLCOMPRESSEDTEXIMAGE3D);
      EXTMGR_FUNC_INIT(glCompressedTexImage2D, GLCOMPRESSEDTEXIMAGE2D);
      EXTMGR_FUNC_INIT(glCompressedTexImage1D, GLCOMPRESSEDTEXIMAGE1D);
      EXTMGR_FUNC_INIT(glCompressedTexSubImage3D, GLCOMPRESSEDTEXSUBIMAGE3D);
      EXTMGR_FUNC_INIT(glCompressedTexSubImage2D, GLCOMPRESSEDTEXSUBIMAGE2D);
      EXTMGR_FUNC_INIT(glCompressedTexSubImage1D, GLCOMPRESSEDTEXSUBIMAGE1D);
      EXTMGR_FUNC_INIT(glGetCompressedTexImage, GLGETCOMPRESSEDTEXIMAGE);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_version_1_3)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_imaging ()
  {
    if (tested_CS_GL_ARB_imaging) return;
    tested_CS_GL_ARB_imaging = true;
    const char* ext = "GL_ARB_imaging";
    char cfgkey[26 + 14 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_imaging = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_imaging;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glColorTable, GLCOLORTABLE);
      EXTMGR_FUNC_INIT(glColorTableParameterfv, GLCOLORTABLEPARAMETERFV);
      EXTMGR_FUNC_INIT(glColorTableParameteriv, GLCOLORTABLEPARAMETERIV);
      EXTMGR_FUNC_INIT(glCopyColorTable, GLCOPYCOLORTABLE);
      EXTMGR_FUNC_INIT(glGetColorTable, GLGETCOLORTABLE);
      EXTMGR_FUNC_INIT(glGetColorTableParameterfv, GLGETCOLORTABLEPARAMETERFV);
      EXTMGR_FUNC_INIT(glGetColorTableParameteriv, GLGETCOLORTABLEPARAMETERIV);
      EXTMGR_FUNC_INIT(glColorSubTable, GLCOLORSUBTABLE);
      EXTMGR_FUNC_INIT(glCopyColorSubTable, GLCOPYCOLORSUBTABLE);
      EXTMGR_FUNC_INIT(glConvolutionFilter1D, GLCONVOLUTIONFILTER1D);
      EXTMGR_FUNC_INIT(glConvolutionFilter2D, GLCONVOLUTIONFILTER2D);
      EXTMGR_FUNC_INIT(glConvolutionParameterf, GLCONVOLUTIONPARAMETERF);
      EXTMGR_FUNC_INIT(glConvolutionParameterfv, GLCONVOLUTIONPARAMETERFV);
      EXTMGR_FUNC_INIT(glConvolutionParameteri, GLCONVOLUTIONPARAMETERI);
      EXTMGR_FUNC_INIT(glConvolutionParameteriv, GLCONVOLUTIONPARAMETERIV);
      EXTMGR_FUNC_INIT(glCopyConvolutionFilter1D, GLCOPYCONVOLUTIONFILTER1D);
      EXTMGR_FUNC_INIT(glCopyConvolutionFilter2D, GLCOPYCONVOLUTIONFILTER2D);
      EXTMGR_FUNC_INIT(glGetConvolutionFilter, GLGETCONVOLUTIONFILTER);
      EXTMGR_FUNC_INIT(glGetConvolutionParameterfv, GLGETCONVOLUTIONPARAMETERFV);
      EXTMGR_FUNC_INIT(glGetConvolutionParameteriv, GLGETCONVOLUTIONPARAMETERIV);
      EXTMGR_FUNC_INIT(glGetSeparableFilter, GLGETSEPARABLEFILTER);
      EXTMGR_FUNC_INIT(glSeparableFilter2D, GLSEPARABLEFILTER2D);
      EXTMGR_FUNC_INIT(glGetHistogram, GLGETHISTOGRAM);
      EXTMGR_FUNC_INIT(glGetHistogramParameterfv, GLGETHISTOGRAMPARAMETERFV);
      EXTMGR_FUNC_INIT(glGetHistogramParameteriv, GLGETHISTOGRAMPARAMETERIV);
      EXTMGR_FUNC_INIT(glGetMinmax, GLGETMINMAX);
      EXTMGR_FUNC_INIT(glGetMinmaxParameterfv, GLGETMINMAXPARAMETERFV);
      EXTMGR_FUNC_INIT(glGetMinmaxParameteriv, GLGETMINMAXPARAMETERIV);
      EXTMGR_FUNC_INIT(glHistogram, GLHISTOGRAM);
      EXTMGR_FUNC_INIT(glMinmax, GLMINMAX);
      EXTMGR_FUNC_INIT(glResetHistogram, GLRESETHISTOGRAM);
      EXTMGR_FUNC_INIT(glResetMinmax, GLRESETMINMAX);
      EXTMGR_FUNC_INIT(glBlendColor, GLBLENDCOLOR);
      EXTMGR_FUNC_INIT(glBlendEquation, GLBLENDEQUATION);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_imaging)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_multitexture ()
  {
    if (tested_CS_GL_ARB_multitexture) return;
    tested_CS_GL_ARB_multitexture = true;
    const char* ext = "GL_ARB_multitexture";
    char cfgkey[26 + 19 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_multitexture = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_multitexture;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glActiveTextureARB, GLACTIVETEXTUREARB);
      EXTMGR_FUNC_INIT(glClientActiveTextureARB, GLCLIENTACTIVETEXTUREARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord1dARB, GLMULTITEXCOORD1DARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord1dvARB, GLMULTITEXCOORD1DVARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord1fARB, GLMULTITEXCOORD1FARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord1fvARB, GLMULTITEXCOORD1FVARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord1iARB, GLMULTITEXCOORD1IARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord1ivARB, GLMULTITEXCOORD1IVARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord1sARB, GLMULTITEXCOORD1SARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord1svARB, GLMULTITEXCOORD1SVARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord2dARB, GLMULTITEXCOORD2DARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord2dvARB, GLMULTITEXCOORD2DVARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord2fARB, GLMULTITEXCOORD2FARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord2fvARB, GLMULTITEXCOORD2FVARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord2iARB, GLMULTITEXCOORD2IARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord2ivARB, GLMULTITEXCOORD2IVARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord2sARB, GLMULTITEXCOORD2SARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord2svARB, GLMULTITEXCOORD2SVARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord3dARB, GLMULTITEXCOORD3DARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord3dvARB, GLMULTITEXCOORD3DVARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord3fARB, GLMULTITEXCOORD3FARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord3fvARB, GLMULTITEXCOORD3FVARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord3iARB, GLMULTITEXCOORD3IARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord3ivARB, GLMULTITEXCOORD3IVARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord3sARB, GLMULTITEXCOORD3SARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord3svARB, GLMULTITEXCOORD3SVARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord4dARB, GLMULTITEXCOORD4DARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord4dvARB, GLMULTITEXCOORD4DVARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord4fARB, GLMULTITEXCOORD4FARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord4fvARB, GLMULTITEXCOORD4FVARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord4iARB, GLMULTITEXCOORD4IARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord4ivARB, GLMULTITEXCOORD4IVARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord4sARB, GLMULTITEXCOORD4SARB);
      EXTMGR_FUNC_INIT(glMultiTexCoord4svARB, GLMULTITEXCOORD4SVARB);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_multitexture)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_transpose_matrix ()
  {
    if (tested_CS_GL_ARB_transpose_matrix) return;
    tested_CS_GL_ARB_transpose_matrix = true;
    const char* ext = "GL_ARB_transpose_matrix";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_transpose_matrix = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_transpose_matrix;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glLoadTransposeMatrixfARB, GLLOADTRANSPOSEMATRIXFARB);
      EXTMGR_FUNC_INIT(glLoadTransposeMatrixdARB, GLLOADTRANSPOSEMATRIXDARB);
      EXTMGR_FUNC_INIT(glMultTransposeMatrixfARB, GLMULTTRANSPOSEMATRIXFARB);
      EXTMGR_FUNC_INIT(glMultTransposeMatrixdARB, GLMULTTRANSPOSEMATRIXDARB);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_transpose_matrix)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_multisample ()
  {
    if (tested_CS_GL_ARB_multisample) return;
    tested_CS_GL_ARB_multisample = true;
    const char* ext = "GL_ARB_multisample";
    char cfgkey[26 + 18 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_multisample = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_multisample;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glSampleCoverageARB, GLSAMPLECOVERAGEARB);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_multisample)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_texture_env_add ()
  {
    if (tested_CS_GL_ARB_texture_env_add) return;
    tested_CS_GL_ARB_texture_env_add = true;
    const char* ext = "GL_ARB_texture_env_add";
    char cfgkey[26 + 22 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_texture_env_add = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_texture_env_add;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_texture_env_add)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
#ifdef _WIN32
  void InitWGL_ARB_extensions_string (HDC hDC)
  {
    if (tested_CS_WGL_ARB_extensions_string) return;
    tested_CS_WGL_ARB_extensions_string = true;
    const char* ext = "WGL_ARB_extensions_string";
    char cfgkey[26 + 25 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_WGL_ARB_extensions_string = true;

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_WGL_ARB_extensions_string;
    allclear = true;
    if (init)
    {
      EXTMGR_FUNC_INIT(wglGetExtensionsStringARB, WGLGETEXTENSIONSSTRINGARB);

      EXTMGR_REPORT_INIT_RESULT("WGL", WGL_ARB_extensions_string)
      CS_WGL_ARB_extensions_string &= allclear;
    }
    else
    {
      Report (msgExtNotFound, "WGL", ext);
    }
  }
#endif

#ifdef _WIN32
  void InitWGL_ARB_buffer_region (HDC hDC)
  {
    if (tested_CS_WGL_ARB_buffer_region) return;
    tested_CS_WGL_ARB_buffer_region = true;
    const char* ext = "WGL_ARB_buffer_region";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    SetupWGLextStr (hDC);
    CS_WGL_ARB_buffer_region = (strstr (extstrWGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_WGL_ARB_buffer_region;
    allclear = true;
    if (init)
    {
      EXTMGR_FUNC_INIT(wglCreateBufferRegionARB, WGLCREATEBUFFERREGIONARB);
      EXTMGR_FUNC_INIT(wglDeleteBufferRegionARB, WGLDELETEBUFFERREGIONARB);
      EXTMGR_FUNC_INIT(wglSaveBufferRegionARB, WGLSAVEBUFFERREGIONARB);
      EXTMGR_FUNC_INIT(wglRestoreBufferRegionARB, WGLRESTOREBUFFERREGIONARB);

      EXTMGR_REPORT_INIT_RESULT("WGL", WGL_ARB_buffer_region)
      CS_WGL_ARB_buffer_region &= allclear;
    }
    else
    {
      Report (msgExtNotFound, "WGL", ext);
    }
  }
#endif

  void InitGL_ARB_texture_cube_map ()
  {
    if (tested_CS_GL_ARB_texture_cube_map) return;
    tested_CS_GL_ARB_texture_cube_map = true;
    const char* ext = "GL_ARB_texture_cube_map";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_texture_cube_map = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_texture_cube_map;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_texture_cube_map)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_depth_texture ()
  {
    if (tested_CS_GL_ARB_depth_texture) return;
    tested_CS_GL_ARB_depth_texture = true;
    const char* ext = "GL_ARB_depth_texture";
    char cfgkey[26 + 20 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_depth_texture = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_depth_texture;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_depth_texture)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_point_parameters ()
  {
    if (tested_CS_GL_ARB_point_parameters) return;
    tested_CS_GL_ARB_point_parameters = true;
    const char* ext = "GL_ARB_point_parameters";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_point_parameters = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_point_parameters;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glPointParameterfARB, GLPOINTPARAMETERFARB);
      EXTMGR_FUNC_INIT(glPointParameterfvARB, GLPOINTPARAMETERFVARB);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_point_parameters)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_shadow ()
  {
    if (tested_CS_GL_ARB_shadow) return;
    tested_CS_GL_ARB_shadow = true;
    const char* ext = "GL_ARB_shadow";
    char cfgkey[26 + 13 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_shadow = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_shadow;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_shadow)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_shadow_ambient ()
  {
    if (tested_CS_GL_ARB_shadow_ambient) return;
    tested_CS_GL_ARB_shadow_ambient = true;
    const char* ext = "GL_ARB_shadow_ambient";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_shadow_ambient = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_shadow_ambient;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_shadow_ambient)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_texture_border_clamp ()
  {
    if (tested_CS_GL_ARB_texture_border_clamp) return;
    tested_CS_GL_ARB_texture_border_clamp = true;
    const char* ext = "GL_ARB_texture_border_clamp";
    char cfgkey[26 + 27 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_texture_border_clamp = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_texture_border_clamp;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_texture_border_clamp)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_texture_compression ()
  {
    if (tested_CS_GL_ARB_texture_compression) return;
    tested_CS_GL_ARB_texture_compression = true;
    const char* ext = "GL_ARB_texture_compression";
    char cfgkey[26 + 26 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_texture_compression = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_texture_compression;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glCompressedTexImage3DARB, GLCOMPRESSEDTEXIMAGE3DARB);
      EXTMGR_FUNC_INIT(glCompressedTexImage2DARB, GLCOMPRESSEDTEXIMAGE2DARB);
      EXTMGR_FUNC_INIT(glCompressedTexImage1DARB, GLCOMPRESSEDTEXIMAGE1DARB);
      EXTMGR_FUNC_INIT(glCompressedTexSubImage3DARB, GLCOMPRESSEDTEXSUBIMAGE3DARB);
      EXTMGR_FUNC_INIT(glCompressedTexSubImage2DARB, GLCOMPRESSEDTEXSUBIMAGE2DARB);
      EXTMGR_FUNC_INIT(glCompressedTexSubImage1DARB, GLCOMPRESSEDTEXSUBIMAGE1DARB);
      EXTMGR_FUNC_INIT(glGetCompressedTexImageARB, GLGETCOMPRESSEDTEXIMAGEARB);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_texture_compression)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_texture_env_combine ()
  {
    if (tested_CS_GL_ARB_texture_env_combine) return;
    tested_CS_GL_ARB_texture_env_combine = true;
    const char* ext = "GL_ARB_texture_env_combine";
    char cfgkey[26 + 26 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_texture_env_combine = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_texture_env_combine;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_texture_env_combine)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_texture_env_crossbar ()
  {
    if (tested_CS_GL_ARB_texture_env_crossbar) return;
    tested_CS_GL_ARB_texture_env_crossbar = true;
    const char* ext = "GL_ARB_texture_env_crossbar";
    char cfgkey[26 + 27 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_texture_env_crossbar = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_texture_env_crossbar;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_texture_env_crossbar)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_texture_env_dot3 ()
  {
    if (tested_CS_GL_ARB_texture_env_dot3) return;
    tested_CS_GL_ARB_texture_env_dot3 = true;
    const char* ext = "GL_ARB_texture_env_dot3";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_texture_env_dot3 = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_texture_env_dot3;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_texture_env_dot3)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_texture_mirrored_repeat ()
  {
    if (tested_CS_GL_ARB_texture_mirrored_repeat) return;
    tested_CS_GL_ARB_texture_mirrored_repeat = true;
    const char* ext = "GL_ARB_texture_mirrored_repeat";
    char cfgkey[26 + 30 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_texture_mirrored_repeat = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_texture_mirrored_repeat;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_texture_mirrored_repeat)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_vertex_blend ()
  {
    if (tested_CS_GL_ARB_vertex_blend) return;
    tested_CS_GL_ARB_vertex_blend = true;
    const char* ext = "GL_ARB_vertex_blend";
    char cfgkey[26 + 19 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_vertex_blend = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_vertex_blend;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glWeightbvARB, GLWEIGHTBVARB);
      EXTMGR_FUNC_INIT(glWeightsvARB, GLWEIGHTSVARB);
      EXTMGR_FUNC_INIT(glWeightivARB, GLWEIGHTIVARB);
      EXTMGR_FUNC_INIT(glWeightfvARB, GLWEIGHTFVARB);
      EXTMGR_FUNC_INIT(glWeightdvARB, GLWEIGHTDVARB);
      EXTMGR_FUNC_INIT(glWeightvARB, GLWEIGHTVARB);
      EXTMGR_FUNC_INIT(glWeightubvARB, GLWEIGHTUBVARB);
      EXTMGR_FUNC_INIT(glWeightusvARB, GLWEIGHTUSVARB);
      EXTMGR_FUNC_INIT(glWeightuivARB, GLWEIGHTUIVARB);
      EXTMGR_FUNC_INIT(glWeightPointerARB, GLWEIGHTPOINTERARB);
      EXTMGR_FUNC_INIT(glVertexBlendARB, GLVERTEXBLENDARB);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_vertex_blend)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_vertex_program ()
  {
    if (tested_CS_GL_ARB_vertex_program) return;
    tested_CS_GL_ARB_vertex_program = true;
    const char* ext = "GL_ARB_vertex_program";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_vertex_program = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_vertex_program;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glVertexAttrib1sARB, GLVERTEXATTRIB1SARB);
      EXTMGR_FUNC_INIT(glVertexAttrib1fARB, GLVERTEXATTRIB1FARB);
      EXTMGR_FUNC_INIT(glVertexAttrib1dARB, GLVERTEXATTRIB1DARB);
      EXTMGR_FUNC_INIT(glVertexAttrib2sARB, GLVERTEXATTRIB2SARB);
      EXTMGR_FUNC_INIT(glVertexAttrib2fARB, GLVERTEXATTRIB2FARB);
      EXTMGR_FUNC_INIT(glVertexAttrib2dARB, GLVERTEXATTRIB2DARB);
      EXTMGR_FUNC_INIT(glVertexAttrib3sARB, GLVERTEXATTRIB3SARB);
      EXTMGR_FUNC_INIT(glVertexAttrib3fARB, GLVERTEXATTRIB3FARB);
      EXTMGR_FUNC_INIT(glVertexAttrib3dARB, GLVERTEXATTRIB3DARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4sARB, GLVERTEXATTRIB4SARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4fARB, GLVERTEXATTRIB4FARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4dARB, GLVERTEXATTRIB4DARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4NubARB, GLVERTEXATTRIB4NUBARB);
      EXTMGR_FUNC_INIT(glVertexAttrib1svARB, GLVERTEXATTRIB1SVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib1fvARB, GLVERTEXATTRIB1FVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib1dvARB, GLVERTEXATTRIB1DVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib2svARB, GLVERTEXATTRIB2SVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib2fvARB, GLVERTEXATTRIB2FVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib2dvARB, GLVERTEXATTRIB2DVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib3svARB, GLVERTEXATTRIB3SVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib3fvARB, GLVERTEXATTRIB3FVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib3dvARB, GLVERTEXATTRIB3DVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4bvARB, GLVERTEXATTRIB4BVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4svARB, GLVERTEXATTRIB4SVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4ivARB, GLVERTEXATTRIB4IVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4ubvARB, GLVERTEXATTRIB4UBVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4usvARB, GLVERTEXATTRIB4USVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4uivARB, GLVERTEXATTRIB4UIVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4fvARB, GLVERTEXATTRIB4FVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4dvARB, GLVERTEXATTRIB4DVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4NbvARB, GLVERTEXATTRIB4NBVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4NsvARB, GLVERTEXATTRIB4NSVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4NivARB, GLVERTEXATTRIB4NIVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4NubvARB, GLVERTEXATTRIB4NUBVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4NusvARB, GLVERTEXATTRIB4NUSVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4NuivARB, GLVERTEXATTRIB4NUIVARB);
      EXTMGR_FUNC_INIT(glVertexAttribPointerARB, GLVERTEXATTRIBPOINTERARB);
      EXTMGR_FUNC_INIT(glEnableVertexAttribArrayARB, GLENABLEVERTEXATTRIBARRAYARB);
      EXTMGR_FUNC_INIT(glDisableVertexAttribArrayARB, GLDISABLEVERTEXATTRIBARRAYARB);
      EXTMGR_FUNC_INIT(glProgramStringARB, GLPROGRAMSTRINGARB);
      EXTMGR_FUNC_INIT(glBindProgramARB, GLBINDPROGRAMARB);
      EXTMGR_FUNC_INIT(glDeleteProgramsARB, GLDELETEPROGRAMSARB);
      EXTMGR_FUNC_INIT(glGenProgramsARB, GLGENPROGRAMSARB);
      EXTMGR_FUNC_INIT(glProgramEnvParameter4dARB, GLPROGRAMENVPARAMETER4DARB);
      EXTMGR_FUNC_INIT(glProgramEnvParameter4dvARB, GLPROGRAMENVPARAMETER4DVARB);
      EXTMGR_FUNC_INIT(glProgramEnvParameter4fARB, GLPROGRAMENVPARAMETER4FARB);
      EXTMGR_FUNC_INIT(glProgramEnvParameter4fvARB, GLPROGRAMENVPARAMETER4FVARB);
      EXTMGR_FUNC_INIT(glProgramLocalParameter4dARB, GLPROGRAMLOCALPARAMETER4DARB);
      EXTMGR_FUNC_INIT(glProgramLocalParameter4dvARB, GLPROGRAMLOCALPARAMETER4DVARB);
      EXTMGR_FUNC_INIT(glProgramLocalParameter4fARB, GLPROGRAMLOCALPARAMETER4FARB);
      EXTMGR_FUNC_INIT(glProgramLocalParameter4fvARB, GLPROGRAMLOCALPARAMETER4FVARB);
      EXTMGR_FUNC_INIT(glGetProgramEnvParameterdvARB, GLGETPROGRAMENVPARAMETERDVARB);
      EXTMGR_FUNC_INIT(glGetProgramEnvParameterfvARB, GLGETPROGRAMENVPARAMETERFVARB);
      EXTMGR_FUNC_INIT(glGetProgramLocalParameterdvARB, GLGETPROGRAMLOCALPARAMETERDVARB);
      EXTMGR_FUNC_INIT(glGetProgramLocalParameterfvARB, GLGETPROGRAMLOCALPARAMETERFVARB);
      EXTMGR_FUNC_INIT(glGetProgramivARB, GLGETPROGRAMIVARB);
      EXTMGR_FUNC_INIT(glGetProgramStringARB, GLGETPROGRAMSTRINGARB);
      EXTMGR_FUNC_INIT(glGetVertexAttribdvARB, GLGETVERTEXATTRIBDVARB);
      EXTMGR_FUNC_INIT(glGetVertexAttribfvARB, GLGETVERTEXATTRIBFVARB);
      EXTMGR_FUNC_INIT(glGetVertexAttribivARB, GLGETVERTEXATTRIBIVARB);
      EXTMGR_FUNC_INIT(glGetVertexAttribPointervARB, GLGETVERTEXATTRIBPOINTERVARB);
      EXTMGR_FUNC_INIT(glIsProgramARB, GLISPROGRAMARB);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_vertex_program)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_window_pos ()
  {
    if (tested_CS_GL_ARB_window_pos) return;
    tested_CS_GL_ARB_window_pos = true;
    const char* ext = "GL_ARB_window_pos";
    char cfgkey[26 + 17 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_window_pos = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_window_pos;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glWindowPos2dARB, GLWINDOWPOS2DARB);
      EXTMGR_FUNC_INIT(glWindowPos2fARB, GLWINDOWPOS2FARB);
      EXTMGR_FUNC_INIT(glWindowPos2iARB, GLWINDOWPOS2IARB);
      EXTMGR_FUNC_INIT(glWindowPos2sARB, GLWINDOWPOS2SARB);
      EXTMGR_FUNC_INIT(glWindowPos2dvARB, GLWINDOWPOS2DVARB);
      EXTMGR_FUNC_INIT(glWindowPos2fvARB, GLWINDOWPOS2FVARB);
      EXTMGR_FUNC_INIT(glWindowPos2ivARB, GLWINDOWPOS2IVARB);
      EXTMGR_FUNC_INIT(glWindowPos2svARB, GLWINDOWPOS2SVARB);
      EXTMGR_FUNC_INIT(glWindowPos3dARB, GLWINDOWPOS3DARB);
      EXTMGR_FUNC_INIT(glWindowPos3fARB, GLWINDOWPOS3FARB);
      EXTMGR_FUNC_INIT(glWindowPos3iARB, GLWINDOWPOS3IARB);
      EXTMGR_FUNC_INIT(glWindowPos3sARB, GLWINDOWPOS3SARB);
      EXTMGR_FUNC_INIT(glWindowPos3dvARB, GLWINDOWPOS3DVARB);
      EXTMGR_FUNC_INIT(glWindowPos3fvARB, GLWINDOWPOS3FVARB);
      EXTMGR_FUNC_INIT(glWindowPos3ivARB, GLWINDOWPOS3IVARB);
      EXTMGR_FUNC_INIT(glWindowPos3svARB, GLWINDOWPOS3SVARB);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_window_pos)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_422_pixels ()
  {
    if (tested_CS_GL_EXT_422_pixels) return;
    tested_CS_GL_EXT_422_pixels = true;
    const char* ext = "GL_EXT_422_pixels";
    char cfgkey[26 + 17 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_422_pixels = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_422_pixels;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_422_pixels)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_abgr ()
  {
    if (tested_CS_GL_EXT_abgr) return;
    tested_CS_GL_EXT_abgr = true;
    const char* ext = "GL_EXT_abgr";
    char cfgkey[26 + 11 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_abgr = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_abgr;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_abgr)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_bgra ()
  {
    if (tested_CS_GL_EXT_bgra) return;
    tested_CS_GL_EXT_bgra = true;
    const char* ext = "GL_EXT_bgra";
    char cfgkey[26 + 11 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_bgra = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_bgra;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_bgra)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_blend_color ()
  {
    if (tested_CS_GL_EXT_blend_color) return;
    tested_CS_GL_EXT_blend_color = true;
    const char* ext = "GL_EXT_blend_color";
    char cfgkey[26 + 18 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_blend_color = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_blend_color;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glBlendColorEXT, GLBLENDCOLOREXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_blend_color)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_blend_func_separate ()
  {
    if (tested_CS_GL_EXT_blend_func_separate) return;
    tested_CS_GL_EXT_blend_func_separate = true;
    const char* ext = "GL_EXT_blend_func_separate";
    char cfgkey[26 + 26 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_blend_func_separate = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_blend_func_separate;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glBlendFuncSeparateEXT, GLBLENDFUNCSEPARATEEXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_blend_func_separate)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_blend_logic_op ()
  {
    if (tested_CS_GL_EXT_blend_logic_op) return;
    tested_CS_GL_EXT_blend_logic_op = true;
    const char* ext = "GL_EXT_blend_logic_op";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_blend_logic_op = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_blend_logic_op;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_blend_logic_op)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_blend_minmax ()
  {
    if (tested_CS_GL_EXT_blend_minmax) return;
    tested_CS_GL_EXT_blend_minmax = true;
    const char* ext = "GL_EXT_blend_minmax";
    char cfgkey[26 + 19 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_blend_minmax = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_blend_minmax;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glBlendEquationEXT, GLBLENDEQUATIONEXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_blend_minmax)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_blend_subtract ()
  {
    if (tested_CS_GL_EXT_blend_subtract) return;
    tested_CS_GL_EXT_blend_subtract = true;
    const char* ext = "GL_EXT_blend_subtract";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_blend_subtract = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_blend_subtract;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_blend_subtract)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_clip_volume_hint ()
  {
    if (tested_CS_GL_EXT_clip_volume_hint) return;
    tested_CS_GL_EXT_clip_volume_hint = true;
    const char* ext = "GL_EXT_clip_volume_hint";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_clip_volume_hint = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_clip_volume_hint;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_clip_volume_hint)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_color_subtable ()
  {
    if (tested_CS_GL_EXT_color_subtable) return;
    tested_CS_GL_EXT_color_subtable = true;
    const char* ext = "GL_EXT_color_subtable";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_color_subtable = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_color_subtable;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glColorSubTableEXT, GLCOLORSUBTABLEEXT);
      EXTMGR_FUNC_INIT(glCopyColorSubTableEXT, GLCOPYCOLORSUBTABLEEXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_color_subtable)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_compiled_vertex_array ()
  {
    if (tested_CS_GL_EXT_compiled_vertex_array) return;
    tested_CS_GL_EXT_compiled_vertex_array = true;
    const char* ext = "GL_EXT_compiled_vertex_array";
    char cfgkey[26 + 28 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_compiled_vertex_array = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_compiled_vertex_array;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glLockArraysEXT, GLLOCKARRAYSEXT);
      EXTMGR_FUNC_INIT(glUnlockArraysEXT, GLUNLOCKARRAYSEXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_compiled_vertex_array)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_convolution ()
  {
    if (tested_CS_GL_EXT_convolution) return;
    tested_CS_GL_EXT_convolution = true;
    const char* ext = "GL_EXT_convolution";
    char cfgkey[26 + 18 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_convolution = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_convolution;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glConvolutionFilter1DEXT, GLCONVOLUTIONFILTER1DEXT);
      EXTMGR_FUNC_INIT(glConvolutionFilter2DEXT, GLCONVOLUTIONFILTER2DEXT);
      EXTMGR_FUNC_INIT(glCopyConvolutionFilter1DEXT, GLCOPYCONVOLUTIONFILTER1DEXT);
      EXTMGR_FUNC_INIT(glCopyConvolutionFilter2DEXT, GLCOPYCONVOLUTIONFILTER2DEXT);
      EXTMGR_FUNC_INIT(glGetConvolutionFilterEXT, GLGETCONVOLUTIONFILTEREXT);
      EXTMGR_FUNC_INIT(glSeparableFilter2DEXT, GLSEPARABLEFILTER2DEXT);
      EXTMGR_FUNC_INIT(glGetSeparableFilterEXT, GLGETSEPARABLEFILTEREXT);
      EXTMGR_FUNC_INIT(glConvolutionParameteriEXT, GLCONVOLUTIONPARAMETERIEXT);
      EXTMGR_FUNC_INIT(glConvolutionParameterivEXT, GLCONVOLUTIONPARAMETERIVEXT);
      EXTMGR_FUNC_INIT(glConvolutionParameterfEXT, GLCONVOLUTIONPARAMETERFEXT);
      EXTMGR_FUNC_INIT(glConvolutionParameterfvEXT, GLCONVOLUTIONPARAMETERFVEXT);
      EXTMGR_FUNC_INIT(glGetConvolutionParameterivEXT, GLGETCONVOLUTIONPARAMETERIVEXT);
      EXTMGR_FUNC_INIT(glGetConvolutionParameterfvEXT, GLGETCONVOLUTIONPARAMETERFVEXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_convolution)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_fog_coord ()
  {
    if (tested_CS_GL_EXT_fog_coord) return;
    tested_CS_GL_EXT_fog_coord = true;
    const char* ext = "GL_EXT_fog_coord";
    char cfgkey[26 + 16 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_fog_coord = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_fog_coord;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glFogCoordfEXfloat, GLFOGCOORDFEXFLOAT);
      EXTMGR_FUNC_INIT(glFogCoorddEXdouble, GLFOGCOORDDEXDOUBLE);
      EXTMGR_FUNC_INIT(glFogCoordfvEXfloat, GLFOGCOORDFVEXFLOAT);
      EXTMGR_FUNC_INIT(glFogCoorddvEXdouble, GLFOGCOORDDVEXDOUBLE);
      EXTMGR_FUNC_INIT(glFogCoordPointerEXT, GLFOGCOORDPOINTEREXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_fog_coord)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_histogram ()
  {
    if (tested_CS_GL_EXT_histogram) return;
    tested_CS_GL_EXT_histogram = true;
    const char* ext = "GL_EXT_histogram";
    char cfgkey[26 + 16 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_histogram = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_histogram;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glHistogramEXT, GLHISTOGRAMEXT);
      EXTMGR_FUNC_INIT(glResetHistogramEXT, GLRESETHISTOGRAMEXT);
      EXTMGR_FUNC_INIT(glGetHistogramEXT, GLGETHISTOGRAMEXT);
      EXTMGR_FUNC_INIT(glGetHistogramParameterivEXT, GLGETHISTOGRAMPARAMETERIVEXT);
      EXTMGR_FUNC_INIT(glGetHistogramParameterfvEXT, GLGETHISTOGRAMPARAMETERFVEXT);
      EXTMGR_FUNC_INIT(glMinmaxEXT, GLMINMAXEXT);
      EXTMGR_FUNC_INIT(glResetMinmaxEXT, GLRESETMINMAXEXT);
      EXTMGR_FUNC_INIT(glGetMinmaxEXT, GLGETMINMAXEXT);
      EXTMGR_FUNC_INIT(glGetMinmaxParameterivEXT, GLGETMINMAXPARAMETERIVEXT);
      EXTMGR_FUNC_INIT(glGetMinmaxParameterfvEXT, GLGETMINMAXPARAMETERFVEXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_histogram)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_multi_draw_arrays ()
  {
    if (tested_CS_GL_EXT_multi_draw_arrays) return;
    tested_CS_GL_EXT_multi_draw_arrays = true;
    const char* ext = "GL_EXT_multi_draw_arrays";
    char cfgkey[26 + 24 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_multi_draw_arrays = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_multi_draw_arrays;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glMultiDrawArraysEXT, GLMULTIDRAWARRAYSEXT);
      EXTMGR_FUNC_INIT(glMultiDrawElementsEXT, GLMULTIDRAWELEMENTSEXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_multi_draw_arrays)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_packed_pixels ()
  {
    if (tested_CS_GL_EXT_packed_pixels) return;
    tested_CS_GL_EXT_packed_pixels = true;
    const char* ext = "GL_EXT_packed_pixels";
    char cfgkey[26 + 20 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_packed_pixels = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_packed_pixels;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_packed_pixels)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_paletted_texture ()
  {
    if (tested_CS_GL_EXT_paletted_texture) return;
    tested_CS_GL_EXT_paletted_texture = true;
    const char* ext = "GL_EXT_paletted_texture";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_paletted_texture = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_paletted_texture;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glColorTableEXT, GLCOLORTABLEEXT);
      EXTMGR_FUNC_INIT(glColorSubTableEXT, GLCOLORSUBTABLEEXT);
      EXTMGR_FUNC_INIT(glGetColorTableEXT, GLGETCOLORTABLEEXT);
      EXTMGR_FUNC_INIT(glGetColorTableParameterivEXT, GLGETCOLORTABLEPARAMETERIVEXT);
      EXTMGR_FUNC_INIT(glGetColorTableParameterfvEXT, GLGETCOLORTABLEPARAMETERFVEXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_paletted_texture)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_point_parameters ()
  {
    if (tested_CS_GL_EXT_point_parameters) return;
    tested_CS_GL_EXT_point_parameters = true;
    const char* ext = "GL_EXT_point_parameters";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_point_parameters = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_point_parameters;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glPointParameterfEXT, GLPOINTPARAMETERFEXT);
      EXTMGR_FUNC_INIT(glPointParameterfvEXT, GLPOINTPARAMETERFVEXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_point_parameters)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_polygon_offset ()
  {
    if (tested_CS_GL_EXT_polygon_offset) return;
    tested_CS_GL_EXT_polygon_offset = true;
    const char* ext = "GL_EXT_polygon_offset";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_polygon_offset = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_polygon_offset;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glPolygonOffsetEXT, GLPOLYGONOFFSETEXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_polygon_offset)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_secondary_color ()
  {
    if (tested_CS_GL_EXT_secondary_color) return;
    tested_CS_GL_EXT_secondary_color = true;
    const char* ext = "GL_EXT_secondary_color";
    char cfgkey[26 + 22 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_secondary_color = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_secondary_color;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glSecondaryColor3bEXT, GLSECONDARYCOLOR3BEXT);
      EXTMGR_FUNC_INIT(glSecondaryColor3sEXT, GLSECONDARYCOLOR3SEXT);
      EXTMGR_FUNC_INIT(glSecondaryColor3iEXT, GLSECONDARYCOLOR3IEXT);
      EXTMGR_FUNC_INIT(glSecondaryColor3fEXT, GLSECONDARYCOLOR3FEXT);
      EXTMGR_FUNC_INIT(glSecondaryColor3dEXT, GLSECONDARYCOLOR3DEXT);
      EXTMGR_FUNC_INIT(glSecondaryColor3ubEXT, GLSECONDARYCOLOR3UBEXT);
      EXTMGR_FUNC_INIT(glSecondaryColor3usEXT, GLSECONDARYCOLOR3USEXT);
      EXTMGR_FUNC_INIT(glSecondaryColor3uiEXT, GLSECONDARYCOLOR3UIEXT);
      EXTMGR_FUNC_INIT(glSecondaryColor3bvEXT, GLSECONDARYCOLOR3BVEXT);
      EXTMGR_FUNC_INIT(glSecondaryColor3svEXT, GLSECONDARYCOLOR3SVEXT);
      EXTMGR_FUNC_INIT(glSecondaryColor3ivEXT, GLSECONDARYCOLOR3IVEXT);
      EXTMGR_FUNC_INIT(glSecondaryColor3fvEXT, GLSECONDARYCOLOR3FVEXT);
      EXTMGR_FUNC_INIT(glSecondaryColor3dvEXT, GLSECONDARYCOLOR3DVEXT);
      EXTMGR_FUNC_INIT(glSecondaryColor3ubvEXT, GLSECONDARYCOLOR3UBVEXT);
      EXTMGR_FUNC_INIT(glSecondaryColor3usvEXT, GLSECONDARYCOLOR3USVEXT);
      EXTMGR_FUNC_INIT(glSecondaryColor3uivEXT, GLSECONDARYCOLOR3UIVEXT);
      EXTMGR_FUNC_INIT(glSecondaryColorPointerEXT, GLSECONDARYCOLORPOINTEREXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_secondary_color)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_separate_specular_color ()
  {
    if (tested_CS_GL_EXT_separate_specular_color) return;
    tested_CS_GL_EXT_separate_specular_color = true;
    const char* ext = "GL_EXT_separate_specular_color";
    char cfgkey[26 + 30 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_separate_specular_color = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_separate_specular_color;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_separate_specular_color)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_shadow_funcs ()
  {
    if (tested_CS_GL_EXT_shadow_funcs) return;
    tested_CS_GL_EXT_shadow_funcs = true;
    const char* ext = "GL_EXT_shadow_funcs";
    char cfgkey[26 + 19 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_shadow_funcs = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_shadow_funcs;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_shadow_funcs)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_shared_texture_palette ()
  {
    if (tested_CS_GL_EXT_shared_texture_palette) return;
    tested_CS_GL_EXT_shared_texture_palette = true;
    const char* ext = "GL_EXT_shared_texture_palette";
    char cfgkey[26 + 29 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_shared_texture_palette = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_shared_texture_palette;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_shared_texture_palette)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_stencil_two_side ()
  {
    if (tested_CS_GL_EXT_stencil_two_side) return;
    tested_CS_GL_EXT_stencil_two_side = true;
    const char* ext = "GL_EXT_stencil_two_side";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_stencil_two_side = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_stencil_two_side;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glActiveStencilFaceEXT, GLACTIVESTENCILFACEEXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_stencil_two_side)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_stencil_wrap ()
  {
    if (tested_CS_GL_EXT_stencil_wrap) return;
    tested_CS_GL_EXT_stencil_wrap = true;
    const char* ext = "GL_EXT_stencil_wrap";
    char cfgkey[26 + 19 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_stencil_wrap = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_stencil_wrap;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_stencil_wrap)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_subtexture ()
  {
    if (tested_CS_GL_EXT_subtexture) return;
    tested_CS_GL_EXT_subtexture = true;
    const char* ext = "GL_EXT_subtexture";
    char cfgkey[26 + 17 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_subtexture = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_subtexture;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glTexSubImage1DEXT, GLTEXSUBIMAGE1DEXT);
      EXTMGR_FUNC_INIT(glTexSubImage2DEXT, GLTEXSUBIMAGE2DEXT);
      EXTMGR_FUNC_INIT(glTexSubImage3DEXT, GLTEXSUBIMAGE3DEXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_subtexture)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_texture3D ()
  {
    if (tested_CS_GL_EXT_texture3D) return;
    tested_CS_GL_EXT_texture3D = true;
    const char* ext = "GL_EXT_texture3D";
    char cfgkey[26 + 16 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_texture3D = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_texture3D;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glTexImage3DEXT, GLTEXIMAGE3DEXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_texture3D)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_texture_compression_s3tc ()
  {
    if (tested_CS_GL_EXT_texture_compression_s3tc) return;
    tested_CS_GL_EXT_texture_compression_s3tc = true;
    const char* ext = "GL_EXT_texture_compression_s3tc";
    char cfgkey[26 + 31 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_texture_compression_s3tc = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_texture_compression_s3tc;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_texture_compression_s3tc)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_texture_env_add ()
  {
    if (tested_CS_GL_EXT_texture_env_add) return;
    tested_CS_GL_EXT_texture_env_add = true;
    const char* ext = "GL_EXT_texture_env_add";
    char cfgkey[26 + 22 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_texture_env_add = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_texture_env_add;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_texture_env_add)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_texture_env_combine ()
  {
    if (tested_CS_GL_EXT_texture_env_combine) return;
    tested_CS_GL_EXT_texture_env_combine = true;
    const char* ext = "GL_EXT_texture_env_combine";
    char cfgkey[26 + 26 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_texture_env_combine = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_texture_env_combine;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_texture_env_combine)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_texture_env_dot3 ()
  {
    if (tested_CS_GL_EXT_texture_env_dot3) return;
    tested_CS_GL_EXT_texture_env_dot3 = true;
    const char* ext = "GL_EXT_texture_env_dot3";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_texture_env_dot3 = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_texture_env_dot3;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_texture_env_dot3)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_texture_filter_anisotropic ()
  {
    if (tested_CS_GL_EXT_texture_filter_anisotropic) return;
    tested_CS_GL_EXT_texture_filter_anisotropic = true;
    const char* ext = "GL_EXT_texture_filter_anisotropic";
    char cfgkey[26 + 33 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_texture_filter_anisotropic = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_texture_filter_anisotropic;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_texture_filter_anisotropic)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_texture_lod_bias ()
  {
    if (tested_CS_GL_EXT_texture_lod_bias) return;
    tested_CS_GL_EXT_texture_lod_bias = true;
    const char* ext = "GL_EXT_texture_lod_bias";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_texture_lod_bias = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_texture_lod_bias;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_texture_lod_bias)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_texture_object ()
  {
    if (tested_CS_GL_EXT_texture_object) return;
    tested_CS_GL_EXT_texture_object = true;
    const char* ext = "GL_EXT_texture_object";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_texture_object = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_texture_object;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glGenTexturesEXT, GLGENTEXTURESEXT);
      EXTMGR_FUNC_INIT(glDeleteTexturesEXT, GLDELETETEXTURESEXT);
      EXTMGR_FUNC_INIT(glBindTextureEXT, GLBINDTEXTUREEXT);
      EXTMGR_FUNC_INIT(glPrioritizeTexturesEXT, GLPRIORITIZETEXTURESEXT);
      EXTMGR_FUNC_INIT(glAreTexturesResidentEXT, GLARETEXTURESRESIDENTEXT);
      EXTMGR_FUNC_INIT(glIsTextureEXT, GLISTEXTUREEXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_texture_object)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_vertex_array ()
  {
    if (tested_CS_GL_EXT_vertex_array) return;
    tested_CS_GL_EXT_vertex_array = true;
    const char* ext = "GL_EXT_vertex_array";
    char cfgkey[26 + 19 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_vertex_array = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_vertex_array;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glArrayElementEXT, GLARRAYELEMENTEXT);
      EXTMGR_FUNC_INIT(glDrawArraysEXT, GLDRAWARRAYSEXT);
      EXTMGR_FUNC_INIT(glVertexPointerEXT, GLVERTEXPOINTEREXT);
      EXTMGR_FUNC_INIT(glNormalPointerEXT, GLNORMALPOINTEREXT);
      EXTMGR_FUNC_INIT(glColorPointerEXT, GLCOLORPOINTEREXT);
      EXTMGR_FUNC_INIT(glIndexPointerEXT, GLINDEXPOINTEREXT);
      EXTMGR_FUNC_INIT(glTexCoordPointerEXT, GLTEXCOORDPOINTEREXT);
      EXTMGR_FUNC_INIT(glEdgeFlagPointerEXT, GLEDGEFLAGPOINTEREXT);
      EXTMGR_FUNC_INIT(glGetPointervEXT, GLGETPOINTERVEXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_vertex_array)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_vertex_shader ()
  {
    if (tested_CS_GL_EXT_vertex_shader) return;
    tested_CS_GL_EXT_vertex_shader = true;
    const char* ext = "GL_EXT_vertex_shader";
    char cfgkey[26 + 20 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_vertex_shader = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_vertex_shader;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glBeginVertexShaderEXT, GLBEGINVERTEXSHADEREXT);
      EXTMGR_FUNC_INIT(glEndVertexShaderEXT, GLENDVERTEXSHADEREXT);
      EXTMGR_FUNC_INIT(glBindVertexShaderEXT, GLBINDVERTEXSHADEREXT);
      EXTMGR_FUNC_INIT(glGenVertexShadersEXT, GLGENVERTEXSHADERSEXT);
      EXTMGR_FUNC_INIT(glDeleteVertexShaderEXT, GLDELETEVERTEXSHADEREXT);
      EXTMGR_FUNC_INIT(glShaderOp1EXT, GLSHADEROP1EXT);
      EXTMGR_FUNC_INIT(glShaderOp2EXT, GLSHADEROP2EXT);
      EXTMGR_FUNC_INIT(glShaderOp3EXT, GLSHADEROP3EXT);
      EXTMGR_FUNC_INIT(glSwizzleEXT, GLSWIZZLEEXT);
      EXTMGR_FUNC_INIT(glWriteMaskEXT, GLWRITEMASKEXT);
      EXTMGR_FUNC_INIT(glInsertComponentEXT, GLINSERTCOMPONENTEXT);
      EXTMGR_FUNC_INIT(glExtractComponentEXT, GLEXTRACTCOMPONENTEXT);
      EXTMGR_FUNC_INIT(glGenSymbolsEXT, GLGENSYMBOLSEXT);
      EXTMGR_FUNC_INIT(glSetInvariantEXT, GLSETINVARIANTEXT);
      EXTMGR_FUNC_INIT(glSetLocalConstantEXT, GLSETLOCALCONSTANTEXT);
      EXTMGR_FUNC_INIT(glVariantbvEXT, GLVARIANTBVEXT);
      EXTMGR_FUNC_INIT(glVariantsvEXT, GLVARIANTSVEXT);
      EXTMGR_FUNC_INIT(glVariantivEXT, GLVARIANTIVEXT);
      EXTMGR_FUNC_INIT(glVariantfvEXT, GLVARIANTFVEXT);
      EXTMGR_FUNC_INIT(glVariantdvEXT, GLVARIANTDVEXT);
      EXTMGR_FUNC_INIT(glVariantubvEXT, GLVARIANTUBVEXT);
      EXTMGR_FUNC_INIT(glVariantusvEXT, GLVARIANTUSVEXT);
      EXTMGR_FUNC_INIT(glVariantuivEXT, GLVARIANTUIVEXT);
      EXTMGR_FUNC_INIT(glVariantPointerEXT, GLVARIANTPOINTEREXT);
      EXTMGR_FUNC_INIT(glEnableVariantClientStateEXT, GLENABLEVARIANTCLIENTSTATEEXT);
      EXTMGR_FUNC_INIT(glDisableVariantClientStateEXT, GLDISABLEVARIANTCLIENTSTATEEXT);
      EXTMGR_FUNC_INIT(glBindLightParameterEXT, GLBINDLIGHTPARAMETEREXT);
      EXTMGR_FUNC_INIT(glBindMaterialParameterEXT, GLBINDMATERIALPARAMETEREXT);
      EXTMGR_FUNC_INIT(glBindTexGenParameterEXT, GLBINDTEXGENPARAMETEREXT);
      EXTMGR_FUNC_INIT(glBindTextureUnitParameterEXT, GLBINDTEXTUREUNITPARAMETEREXT);
      EXTMGR_FUNC_INIT(glBindParameterEXT, GLBINDPARAMETEREXT);
      EXTMGR_FUNC_INIT(glIsVariantEnabledEXT, GLISVARIANTENABLEDEXT);
      EXTMGR_FUNC_INIT(glGetVariantBooleanvEXT, GLGETVARIANTBOOLEANVEXT);
      EXTMGR_FUNC_INIT(glGetVariantIntegervEXT, GLGETVARIANTINTEGERVEXT);
      EXTMGR_FUNC_INIT(glGetVariantFloatvEXT, GLGETVARIANTFLOATVEXT);
      EXTMGR_FUNC_INIT(glGetVariantPointervEXT, GLGETVARIANTPOINTERVEXT);
      EXTMGR_FUNC_INIT(glGetInvariantBooleanvEXT, GLGETINVARIANTBOOLEANVEXT);
      EXTMGR_FUNC_INIT(glGetInvariantIntegervEXT, GLGETINVARIANTINTEGERVEXT);
      EXTMGR_FUNC_INIT(glGetInvariantFloatvEXT, GLGETINVARIANTFLOATVEXT);
      EXTMGR_FUNC_INIT(glGetLocalConstantBooleanvEXT, GLGETLOCALCONSTANTBOOLEANVEXT);
      EXTMGR_FUNC_INIT(glGetLocalConstantIntegervEXT, GLGETLOCALCONSTANTINTEGERVEXT);
      EXTMGR_FUNC_INIT(glGetLocalConstantFloatvEXT, GLGETLOCALCONSTANTFLOATVEXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_vertex_shader)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_EXT_vertex_weighting ()
  {
    if (tested_CS_GL_EXT_vertex_weighting) return;
    tested_CS_GL_EXT_vertex_weighting = true;
    const char* ext = "GL_EXT_vertex_weighting";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_EXT_vertex_weighting = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_EXT_vertex_weighting;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glVertexWeightfEXT, GLVERTEXWEIGHTFEXT);
      EXTMGR_FUNC_INIT(glVertexWeightfvEXT, GLVERTEXWEIGHTFVEXT);
      EXTMGR_FUNC_INIT(glVertexWeightPointerEXT, GLVERTEXWEIGHTPOINTEREXT);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_EXT_vertex_weighting)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_HP_occlusion_test ()
  {
    if (tested_CS_GL_HP_occlusion_test) return;
    tested_CS_GL_HP_occlusion_test = true;
    const char* ext = "GL_HP_occlusion_test";
    char cfgkey[26 + 20 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_HP_occlusion_test = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_HP_occlusion_test;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_HP_occlusion_test)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_blend_square ()
  {
    if (tested_CS_GL_NV_blend_square) return;
    tested_CS_GL_NV_blend_square = true;
    const char* ext = "GL_NV_blend_square";
    char cfgkey[26 + 18 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_blend_square = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_blend_square;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_blend_square)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_copy_depth_to_color ()
  {
    if (tested_CS_GL_NV_copy_depth_to_color) return;
    tested_CS_GL_NV_copy_depth_to_color = true;
    const char* ext = "GL_NV_copy_depth_to_color";
    char cfgkey[26 + 25 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_copy_depth_to_color = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_copy_depth_to_color;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_copy_depth_to_color)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_depth_clamp ()
  {
    if (tested_CS_GL_NV_depth_clamp) return;
    tested_CS_GL_NV_depth_clamp = true;
    const char* ext = "GL_NV_depth_clamp";
    char cfgkey[26 + 17 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_depth_clamp = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_depth_clamp;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_depth_clamp)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_evaluators ()
  {
    if (tested_CS_GL_NV_evaluators) return;
    tested_CS_GL_NV_evaluators = true;
    const char* ext = "GL_NV_evaluators";
    char cfgkey[26 + 16 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_evaluators = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_evaluators;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glMapControlPointsNV, GLMAPCONTROLPOINTSNV);
      EXTMGR_FUNC_INIT(glMapParameterivNV, GLMAPPARAMETERIVNV);
      EXTMGR_FUNC_INIT(glMapParameterfvNV, GLMAPPARAMETERFVNV);
      EXTMGR_FUNC_INIT(glGetMapControlPointsNV, GLGETMAPCONTROLPOINTSNV);
      EXTMGR_FUNC_INIT(glGetMapParameterivNV, GLGETMAPPARAMETERIVNV);
      EXTMGR_FUNC_INIT(glGetMapParameterfvNV, GLGETMAPPARAMETERFVNV);
      EXTMGR_FUNC_INIT(glGetMapAttribParameterivNV, GLGETMAPATTRIBPARAMETERIVNV);
      EXTMGR_FUNC_INIT(glGetMapAttribParameterfvNV, GLGETMAPATTRIBPARAMETERFVNV);
      EXTMGR_FUNC_INIT(glEvalMapsNV, GLEVALMAPSNV);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_evaluators)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_fence ()
  {
    if (tested_CS_GL_NV_fence) return;
    tested_CS_GL_NV_fence = true;
    const char* ext = "GL_NV_fence";
    char cfgkey[26 + 11 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_fence = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_fence;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glGenFencesNV, GLGENFENCESNV);
      EXTMGR_FUNC_INIT(glDeleteFencesNV, GLDELETEFENCESNV);
      EXTMGR_FUNC_INIT(glSetFenceNV, GLSETFENCENV);
      EXTMGR_FUNC_INIT(glTestFenceNV, GLTESTFENCENV);
      EXTMGR_FUNC_INIT(glFinishFenceNV, GLFINISHFENCENV);
      EXTMGR_FUNC_INIT(glIsFenceNV, GLISFENCENV);
      EXTMGR_FUNC_INIT(glGetFenceivNV, GLGETFENCEIVNV);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_fence)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_fog_distance ()
  {
    if (tested_CS_GL_NV_fog_distance) return;
    tested_CS_GL_NV_fog_distance = true;
    const char* ext = "GL_NV_fog_distance";
    char cfgkey[26 + 18 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_fog_distance = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_fog_distance;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_fog_distance)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_light_max_exponent ()
  {
    if (tested_CS_GL_NV_light_max_exponent) return;
    tested_CS_GL_NV_light_max_exponent = true;
    const char* ext = "GL_NV_light_max_exponent";
    char cfgkey[26 + 24 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_light_max_exponent = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_light_max_exponent;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_light_max_exponent)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_multisample_filter_hint ()
  {
    if (tested_CS_GL_NV_multisample_filter_hint) return;
    tested_CS_GL_NV_multisample_filter_hint = true;
    const char* ext = "GL_NV_multisample_filter_hint";
    char cfgkey[26 + 29 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_multisample_filter_hint = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_multisample_filter_hint;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_multisample_filter_hint)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_occlusion_query ()
  {
    if (tested_CS_GL_NV_occlusion_query) return;
    tested_CS_GL_NV_occlusion_query = true;
    const char* ext = "GL_NV_occlusion_query";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_occlusion_query = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_occlusion_query;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glGenOcclusionQueriesNV, GLGENOCCLUSIONQUERIESNV);
      EXTMGR_FUNC_INIT(glDeleteOcclusionQueriesNV, GLDELETEOCCLUSIONQUERIESNV);
      EXTMGR_FUNC_INIT(glIsOcclusionQueryNV, GLISOCCLUSIONQUERYNV);
      EXTMGR_FUNC_INIT(glBeginOcclusionQueryNV, GLBEGINOCCLUSIONQUERYNV);
      EXTMGR_FUNC_INIT(glEndOcclusionQueryNV, GLENDOCCLUSIONQUERYNV);
      EXTMGR_FUNC_INIT(glGetOcclusionQueryivNV, GLGETOCCLUSIONQUERYIVNV);
      EXTMGR_FUNC_INIT(glGetOcclusionQueryuivNV, GLGETOCCLUSIONQUERYUIVNV);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_occlusion_query)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_packed_depth_stencil ()
  {
    if (tested_CS_GL_NV_packed_depth_stencil) return;
    tested_CS_GL_NV_packed_depth_stencil = true;
    const char* ext = "GL_NV_packed_depth_stencil";
    char cfgkey[26 + 26 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_packed_depth_stencil = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_packed_depth_stencil;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_packed_depth_stencil)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_point_sprite ()
  {
    if (tested_CS_GL_NV_point_sprite) return;
    tested_CS_GL_NV_point_sprite = true;
    const char* ext = "GL_NV_point_sprite";
    char cfgkey[26 + 18 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_point_sprite = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_point_sprite;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glPointParameteriNV, GLPOINTPARAMETERINV);
      EXTMGR_FUNC_INIT(glPointParameterivNV, GLPOINTPARAMETERIVNV);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_point_sprite)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_register_combiners ()
  {
    if (tested_CS_GL_NV_register_combiners) return;
    tested_CS_GL_NV_register_combiners = true;
    const char* ext = "GL_NV_register_combiners";
    char cfgkey[26 + 24 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_register_combiners = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_register_combiners;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glCombinerParameterfvNV, GLCOMBINERPARAMETERFVNV);
      EXTMGR_FUNC_INIT(glCombinerParameterivNV, GLCOMBINERPARAMETERIVNV);
      EXTMGR_FUNC_INIT(glCombinerParameterfNV, GLCOMBINERPARAMETERFNV);
      EXTMGR_FUNC_INIT(glCombinerParameteriNV, GLCOMBINERPARAMETERINV);
      EXTMGR_FUNC_INIT(glCombinerInputNV, GLCOMBINERINPUTNV);
      EXTMGR_FUNC_INIT(glCombinerOutputNV, GLCOMBINEROUTPUTNV);
      EXTMGR_FUNC_INIT(glFinalCombinerInputNV, GLFINALCOMBINERINPUTNV);
      EXTMGR_FUNC_INIT(glGetCombinerInputParameterfvNV, GLGETCOMBINERINPUTPARAMETERFVNV);
      EXTMGR_FUNC_INIT(glGetCombinerInputParameterivNV, GLGETCOMBINERINPUTPARAMETERIVNV);
      EXTMGR_FUNC_INIT(glGetCombinerOutputParameterfvNV, GLGETCOMBINEROUTPUTPARAMETERFVNV);
      EXTMGR_FUNC_INIT(glGetCombinerOutputParameterivNV, GLGETCOMBINEROUTPUTPARAMETERIVNV);
      EXTMGR_FUNC_INIT(glGetFinalCombinerInputParameterfvNV, GLGETFINALCOMBINERINPUTPARAMETERFVNV);
      EXTMGR_FUNC_INIT(glGetFinalCombinerInputParameterivNV, GLGETFINALCOMBINERINPUTPARAMETERIVNV);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_register_combiners)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_register_combiners2 ()
  {
    if (tested_CS_GL_NV_register_combiners2) return;
    tested_CS_GL_NV_register_combiners2 = true;
    const char* ext = "GL_NV_register_combiners2";
    char cfgkey[26 + 25 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_register_combiners2 = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_register_combiners2;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glCombinerStageParameterfvNV, GLCOMBINERSTAGEPARAMETERFVNV);
      EXTMGR_FUNC_INIT(glGetCombinerStageParameterfvNV, GLGETCOMBINERSTAGEPARAMETERFVNV);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_register_combiners2)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_texgen_emboss ()
  {
    if (tested_CS_GL_NV_texgen_emboss) return;
    tested_CS_GL_NV_texgen_emboss = true;
    const char* ext = "GL_NV_texgen_emboss";
    char cfgkey[26 + 19 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_texgen_emboss = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_texgen_emboss;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_texgen_emboss)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_texgen_reflection ()
  {
    if (tested_CS_GL_NV_texgen_reflection) return;
    tested_CS_GL_NV_texgen_reflection = true;
    const char* ext = "GL_NV_texgen_reflection";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_texgen_reflection = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_texgen_reflection;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_texgen_reflection)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_texture_compression_vtc ()
  {
    if (tested_CS_GL_NV_texture_compression_vtc) return;
    tested_CS_GL_NV_texture_compression_vtc = true;
    const char* ext = "GL_NV_texture_compression_vtc";
    char cfgkey[26 + 29 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_texture_compression_vtc = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_texture_compression_vtc;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_texture_compression_vtc)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_texture_env_combine4 ()
  {
    if (tested_CS_GL_NV_texture_env_combine4) return;
    tested_CS_GL_NV_texture_env_combine4 = true;
    const char* ext = "GL_NV_texture_env_combine4";
    char cfgkey[26 + 26 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_texture_env_combine4 = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_texture_env_combine4;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_texture_env_combine4)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_texture_rectangle ()
  {
    if (tested_CS_GL_NV_texture_rectangle) return;
    tested_CS_GL_NV_texture_rectangle = true;
    const char* ext = "GL_NV_texture_rectangle";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_texture_rectangle = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_texture_rectangle;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_texture_rectangle)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_texture_shader ()
  {
    if (tested_CS_GL_NV_texture_shader) return;
    tested_CS_GL_NV_texture_shader = true;
    const char* ext = "GL_NV_texture_shader";
    char cfgkey[26 + 20 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_texture_shader = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_texture_shader;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_texture_shader)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_texture_shader2 ()
  {
    if (tested_CS_GL_NV_texture_shader2) return;
    tested_CS_GL_NV_texture_shader2 = true;
    const char* ext = "GL_NV_texture_shader2";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_texture_shader2 = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_texture_shader2;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_texture_shader2)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_texture_shader3 ()
  {
    if (tested_CS_GL_NV_texture_shader3) return;
    tested_CS_GL_NV_texture_shader3 = true;
    const char* ext = "GL_NV_texture_shader3";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_texture_shader3 = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_texture_shader3;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_texture_shader3)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_vertex_array_range ()
  {
    if (tested_CS_GL_NV_vertex_array_range) return;
    tested_CS_GL_NV_vertex_array_range = true;
    const char* ext = "GL_NV_vertex_array_range";
    char cfgkey[26 + 24 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_vertex_array_range = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_vertex_array_range;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glVertexArrayRangeNV, GLVERTEXARRAYRANGENV);
      EXTMGR_FUNC_INIT(glFlushVertexArrayRangeNV, GLFLUSHVERTEXARRAYRANGENV);
      EXTMGR_FUNC_INIT(wglAllocateMemoryNV, WGLALLOCATEMEMORYNV);
      EXTMGR_FUNC_INIT(wglFreeMemoryNV, WGLFREEMEMORYNV);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_vertex_array_range)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_vertex_array_range2 ()
  {
    if (tested_CS_GL_NV_vertex_array_range2) return;
    tested_CS_GL_NV_vertex_array_range2 = true;
    const char* ext = "GL_NV_vertex_array_range2";
    char cfgkey[26 + 25 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_vertex_array_range2 = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_vertex_array_range2;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_vertex_array_range2)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_vertex_program ()
  {
    if (tested_CS_GL_NV_vertex_program) return;
    tested_CS_GL_NV_vertex_program = true;
    const char* ext = "GL_NV_vertex_program";
    char cfgkey[26 + 20 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_vertex_program = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_vertex_program;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glBindProgramNV, GLBINDPROGRAMNV);
      EXTMGR_FUNC_INIT(glDeleteProgramsNV, GLDELETEPROGRAMSNV);
      EXTMGR_FUNC_INIT(glExecuteProgramNV, GLEXECUTEPROGRAMNV);
      EXTMGR_FUNC_INIT(glGenProgramsNV, GLGENPROGRAMSNV);
      EXTMGR_FUNC_INIT(glAreProgramsResidentNV, GLAREPROGRAMSRESIDENTNV);
      EXTMGR_FUNC_INIT(glRequestResidentProgramsNV, GLREQUESTRESIDENTPROGRAMSNV);
      EXTMGR_FUNC_INIT(glGetProgramParameterfvNV, GLGETPROGRAMPARAMETERFVNV);
      EXTMGR_FUNC_INIT(glGetProgramParameterdvNV, GLGETPROGRAMPARAMETERDVNV);
      EXTMGR_FUNC_INIT(glGetProgramivNV, GLGETPROGRAMIVNV);
      EXTMGR_FUNC_INIT(glGetProgramStringNV, GLGETPROGRAMSTRINGNV);
      EXTMGR_FUNC_INIT(glGetTrackMatrixivNV, GLGETTRACKMATRIXIVNV);
      EXTMGR_FUNC_INIT(glGetVertexAttribdvNV, GLGETVERTEXATTRIBDVNV);
      EXTMGR_FUNC_INIT(glGetVertexAttribfvNV, GLGETVERTEXATTRIBFVNV);
      EXTMGR_FUNC_INIT(glGetVertexAttribivNV, GLGETVERTEXATTRIBIVNV);
      EXTMGR_FUNC_INIT(glGetVertexAttribPointervNV, GLGETVERTEXATTRIBPOINTERVNV);
      EXTMGR_FUNC_INIT(glIsProgramNV, GLISPROGRAMNV);
      EXTMGR_FUNC_INIT(glLoadProgramNV, GLLOADPROGRAMNV);
      EXTMGR_FUNC_INIT(glProgramParameter4fNV, GLPROGRAMPARAMETER4FNV);
      EXTMGR_FUNC_INIT(glProgramParameter4fvNV, GLPROGRAMPARAMETER4FVNV);
      EXTMGR_FUNC_INIT(glProgramParameters4dvNV, GLPROGRAMPARAMETERS4DVNV);
      EXTMGR_FUNC_INIT(glProgramParameters4fvNV, GLPROGRAMPARAMETERS4FVNV);
      EXTMGR_FUNC_INIT(glTrackMatrixNV, GLTRACKMATRIXNV);
      EXTMGR_FUNC_INIT(glVertexAttribPointerNV, GLVERTEXATTRIBPOINTERNV);
      EXTMGR_FUNC_INIT(glVertexAttrib1sNV, GLVERTEXATTRIB1SNV);
      EXTMGR_FUNC_INIT(glVertexAttrib1fNV, GLVERTEXATTRIB1FNV);
      EXTMGR_FUNC_INIT(glVertexAttrib1dNV, GLVERTEXATTRIB1DNV);
      EXTMGR_FUNC_INIT(glVertexAttrib2sNV, GLVERTEXATTRIB2SNV);
      EXTMGR_FUNC_INIT(glVertexAttrib2fNV, GLVERTEXATTRIB2FNV);
      EXTMGR_FUNC_INIT(glVertexAttrib2dNV, GLVERTEXATTRIB2DNV);
      EXTMGR_FUNC_INIT(glVertexAttrib3sNV, GLVERTEXATTRIB3SNV);
      EXTMGR_FUNC_INIT(glVertexAttrib3fNV, GLVERTEXATTRIB3FNV);
      EXTMGR_FUNC_INIT(glVertexAttrib3dNV, GLVERTEXATTRIB3DNV);
      EXTMGR_FUNC_INIT(glVertexAttrib4sNV, GLVERTEXATTRIB4SNV);
      EXTMGR_FUNC_INIT(glVertexAttrib4fNV, GLVERTEXATTRIB4FNV);
      EXTMGR_FUNC_INIT(glVertexAttrib4dNV, GLVERTEXATTRIB4DNV);
      EXTMGR_FUNC_INIT(glVertexAttrib4ubNV, GLVERTEXATTRIB4UBNV);
      EXTMGR_FUNC_INIT(glVertexAttrib1svNV, GLVERTEXATTRIB1SVNV);
      EXTMGR_FUNC_INIT(glVertexAttrib1fvNV, GLVERTEXATTRIB1FVNV);
      EXTMGR_FUNC_INIT(glVertexAttrib1dvNV, GLVERTEXATTRIB1DVNV);
      EXTMGR_FUNC_INIT(glVertexAttrib2svNV, GLVERTEXATTRIB2SVNV);
      EXTMGR_FUNC_INIT(glVertexAttrib2fvNV, GLVERTEXATTRIB2FVNV);
      EXTMGR_FUNC_INIT(glVertexAttrib2dvNV, GLVERTEXATTRIB2DVNV);
      EXTMGR_FUNC_INIT(glVertexAttrib3svNV, GLVERTEXATTRIB3SVNV);
      EXTMGR_FUNC_INIT(glVertexAttrib3fvNV, GLVERTEXATTRIB3FVNV);
      EXTMGR_FUNC_INIT(glVertexAttrib3dvNV, GLVERTEXATTRIB3DVNV);
      EXTMGR_FUNC_INIT(glVertexAttrib4svNV, GLVERTEXATTRIB4SVNV);
      EXTMGR_FUNC_INIT(glVertexAttrib4fvNV, GLVERTEXATTRIB4FVNV);
      EXTMGR_FUNC_INIT(glVertexAttrib4dvNV, GLVERTEXATTRIB4DVNV);
      EXTMGR_FUNC_INIT(glVertexAttrib4ubvNV, GLVERTEXATTRIB4UBVNV);
      EXTMGR_FUNC_INIT(glVertexAttribs1svNV, GLVERTEXATTRIBS1SVNV);
      EXTMGR_FUNC_INIT(glVertexAttribs1fvNV, GLVERTEXATTRIBS1FVNV);
      EXTMGR_FUNC_INIT(glVertexAttribs1dvNV, GLVERTEXATTRIBS1DVNV);
      EXTMGR_FUNC_INIT(glVertexAttribs2svNV, GLVERTEXATTRIBS2SVNV);
      EXTMGR_FUNC_INIT(glVertexAttribs2fvNV, GLVERTEXATTRIBS2FVNV);
      EXTMGR_FUNC_INIT(glVertexAttribs2dvNV, GLVERTEXATTRIBS2DVNV);
      EXTMGR_FUNC_INIT(glVertexAttribs3svNV, GLVERTEXATTRIBS3SVNV);
      EXTMGR_FUNC_INIT(glVertexAttribs3fvNV, GLVERTEXATTRIBS3FVNV);
      EXTMGR_FUNC_INIT(glVertexAttribs3dvNV, GLVERTEXATTRIBS3DVNV);
      EXTMGR_FUNC_INIT(glVertexAttribs4svNV, GLVERTEXATTRIBS4SVNV);
      EXTMGR_FUNC_INIT(glVertexAttribs4fvNV, GLVERTEXATTRIBS4FVNV);
      EXTMGR_FUNC_INIT(glVertexAttribs4dvNV, GLVERTEXATTRIBS4DVNV);
      EXTMGR_FUNC_INIT(glVertexAttribs4ubvNV, GLVERTEXATTRIBS4UBVNV);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_vertex_program)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_vertex_program1_1 ()
  {
    if (tested_CS_GL_NV_vertex_program1_1) return;
    tested_CS_GL_NV_vertex_program1_1 = true;
    const char* ext = "GL_NV_vertex_program1_1";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_vertex_program1_1 = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_vertex_program1_1;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_vertex_program1_1)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ATI_element_array ()
  {
    if (tested_CS_GL_ATI_element_array) return;
    tested_CS_GL_ATI_element_array = true;
    const char* ext = "GL_ATI_element_array";
    char cfgkey[26 + 20 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ATI_element_array = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ATI_element_array;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glElementPointerATI, GLELEMENTPOINTERATI);
      EXTMGR_FUNC_INIT(glDrawElementArrayATI, GLDRAWELEMENTARRAYATI);
      EXTMGR_FUNC_INIT(glDrawRangeElementArrayATI, GLDRAWRANGEELEMENTARRAYATI);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ATI_element_array)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ATI_envmap_bumpmap ()
  {
    if (tested_CS_GL_ATI_envmap_bumpmap) return;
    tested_CS_GL_ATI_envmap_bumpmap = true;
    const char* ext = "GL_ATI_envmap_bumpmap";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ATI_envmap_bumpmap = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ATI_envmap_bumpmap;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glTexBumpParameterivATI, GLTEXBUMPPARAMETERIVATI);
      EXTMGR_FUNC_INIT(glTexBumpParameterfvATI, GLTEXBUMPPARAMETERFVATI);
      EXTMGR_FUNC_INIT(glGetTexBumpParameterivATI, GLGETTEXBUMPPARAMETERIVATI);
      EXTMGR_FUNC_INIT(glGetTexBumpParameterfvATI, GLGETTEXBUMPPARAMETERFVATI);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ATI_envmap_bumpmap)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ATI_fragment_shader ()
  {
    if (tested_CS_GL_ATI_fragment_shader) return;
    tested_CS_GL_ATI_fragment_shader = true;
    const char* ext = "GL_ATI_fragment_shader";
    char cfgkey[26 + 22 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ATI_fragment_shader = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ATI_fragment_shader;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glGenFragmentShadersATI, GLGENFRAGMENTSHADERSATI);
      EXTMGR_FUNC_INIT(glBindFragmentShaderATI, GLBINDFRAGMENTSHADERATI);
      EXTMGR_FUNC_INIT(glDeleteFragmentShaderATI, GLDELETEFRAGMENTSHADERATI);
      EXTMGR_FUNC_INIT(glBeginFragmentShaderATI, GLBEGINFRAGMENTSHADERATI);
      EXTMGR_FUNC_INIT(glEndFragmentShaderATI, GLENDFRAGMENTSHADERATI);
      EXTMGR_FUNC_INIT(glPassTexCoordATI, GLPASSTEXCOORDATI);
      EXTMGR_FUNC_INIT(glSampleMapATI, GLSAMPLEMAPATI);
      EXTMGR_FUNC_INIT(glColorFragmentOp1ATI, GLCOLORFRAGMENTOP1ATI);
      EXTMGR_FUNC_INIT(glColorFragmentOp2ATI, GLCOLORFRAGMENTOP2ATI);
      EXTMGR_FUNC_INIT(glColorFragmentOp3ATI, GLCOLORFRAGMENTOP3ATI);
      EXTMGR_FUNC_INIT(glAlphaFragmentOp1ATI, GLALPHAFRAGMENTOP1ATI);
      EXTMGR_FUNC_INIT(glAlphaFragmentOp2ATI, GLALPHAFRAGMENTOP2ATI);
      EXTMGR_FUNC_INIT(glAlphaFragmentOp3ATI, GLALPHAFRAGMENTOP3ATI);
      EXTMGR_FUNC_INIT(glSetFragmentShaderConstantATI, GLSETFRAGMENTSHADERCONSTANTATI);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ATI_fragment_shader)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ATI_pn_triangles ()
  {
    if (tested_CS_GL_ATI_pn_triangles) return;
    tested_CS_GL_ATI_pn_triangles = true;
    const char* ext = "GL_ATI_pn_triangles";
    char cfgkey[26 + 19 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ATI_pn_triangles = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ATI_pn_triangles;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glPNTrianglesiATI, GLPNTRIANGLESIATI);
      EXTMGR_FUNC_INIT(glPNTrianglesfATI, GLPNTRIANGLESFATI);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ATI_pn_triangles)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ATI_texture_mirror_once ()
  {
    if (tested_CS_GL_ATI_texture_mirror_once) return;
    tested_CS_GL_ATI_texture_mirror_once = true;
    const char* ext = "GL_ATI_texture_mirror_once";
    char cfgkey[26 + 26 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ATI_texture_mirror_once = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ATI_texture_mirror_once;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ATI_texture_mirror_once)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ATI_vertex_array_object ()
  {
    if (tested_CS_GL_ATI_vertex_array_object) return;
    tested_CS_GL_ATI_vertex_array_object = true;
    const char* ext = "GL_ATI_vertex_array_object";
    char cfgkey[26 + 26 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ATI_vertex_array_object = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ATI_vertex_array_object;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glNewObjectBufferATI, GLNEWOBJECTBUFFERATI);
      EXTMGR_FUNC_INIT(glIsObjectBufferATI, GLISOBJECTBUFFERATI);
      EXTMGR_FUNC_INIT(glUpdateObjectBufferATI, GLUPDATEOBJECTBUFFERATI);
      EXTMGR_FUNC_INIT(glGetObjectBufferfvATI, GLGETOBJECTBUFFERFVATI);
      EXTMGR_FUNC_INIT(glGetObjectBufferivATI, GLGETOBJECTBUFFERIVATI);
      EXTMGR_FUNC_INIT(glFreeObjectBufferATI, GLFREEOBJECTBUFFERATI);
      EXTMGR_FUNC_INIT(glArrayObjectATI, GLARRAYOBJECTATI);
      EXTMGR_FUNC_INIT(glGetArrayObjectfvATI, GLGETARRAYOBJECTFVATI);
      EXTMGR_FUNC_INIT(glGetArrayObjectivATI, GLGETARRAYOBJECTIVATI);
      EXTMGR_FUNC_INIT(glVariantArrayObjectATI, GLVARIANTARRAYOBJECTATI);
      EXTMGR_FUNC_INIT(glGetVariantArrayObjectfvATI, GLGETVARIANTARRAYOBJECTFVATI);
      EXTMGR_FUNC_INIT(glGetVariantArrayObjectivATI, GLGETVARIANTARRAYOBJECTIVATI);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ATI_vertex_array_object)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ATI_vertex_attrib_array_object ()
  {
    if (tested_CS_GL_ATI_vertex_attrib_array_object) return;
    tested_CS_GL_ATI_vertex_attrib_array_object = true;
    const char* ext = "GL_ATI_vertex_attrib_array_object";
    char cfgkey[26 + 33 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ATI_vertex_attrib_array_object = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ATI_vertex_attrib_array_object;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glVertexAttribArrayObjectATI, GLVERTEXATTRIBARRAYOBJECTATI);
      EXTMGR_FUNC_INIT(glGetVertexAttribArrayObjectfvATI, GLGETVERTEXATTRIBARRAYOBJECTFVATI);
      EXTMGR_FUNC_INIT(glGetVertexAttribArrayObjectivATI, GLGETVERTEXATTRIBARRAYOBJECTIVATI);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ATI_vertex_attrib_array_object)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ATI_vertex_streams ()
  {
    if (tested_CS_GL_ATI_vertex_streams) return;
    tested_CS_GL_ATI_vertex_streams = true;
    const char* ext = "GL_ATI_vertex_streams";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ATI_vertex_streams = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ATI_vertex_streams;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glVertexStream1s, GLVERTEXSTREAM1S);
      EXTMGR_FUNC_INIT(glVertexStream1i, GLVERTEXSTREAM1I);
      EXTMGR_FUNC_INIT(glVertexStream1f, GLVERTEXSTREAM1F);
      EXTMGR_FUNC_INIT(glVertexStream1d, GLVERTEXSTREAM1D);
      EXTMGR_FUNC_INIT(glVertexStream1sv, GLVERTEXSTREAM1SV);
      EXTMGR_FUNC_INIT(glVertexStream1iv, GLVERTEXSTREAM1IV);
      EXTMGR_FUNC_INIT(glVertexStream1fv, GLVERTEXSTREAM1FV);
      EXTMGR_FUNC_INIT(glVertexStream1dv, GLVERTEXSTREAM1DV);
      EXTMGR_FUNC_INIT(glVertexStream2s, GLVERTEXSTREAM2S);
      EXTMGR_FUNC_INIT(glVertexStream2i, GLVERTEXSTREAM2I);
      EXTMGR_FUNC_INIT(glVertexStream2f, GLVERTEXSTREAM2F);
      EXTMGR_FUNC_INIT(glVertexStream2d, GLVERTEXSTREAM2D);
      EXTMGR_FUNC_INIT(glVertexStream2sv, GLVERTEXSTREAM2SV);
      EXTMGR_FUNC_INIT(glVertexStream2iv, GLVERTEXSTREAM2IV);
      EXTMGR_FUNC_INIT(glVertexStream2fv, GLVERTEXSTREAM2FV);
      EXTMGR_FUNC_INIT(glVertexStream2dv, GLVERTEXSTREAM2DV);
      EXTMGR_FUNC_INIT(glVertexStream3s, GLVERTEXSTREAM3S);
      EXTMGR_FUNC_INIT(glVertexStream3i, GLVERTEXSTREAM3I);
      EXTMGR_FUNC_INIT(glVertexStream3f, GLVERTEXSTREAM3F);
      EXTMGR_FUNC_INIT(glVertexStream3d, GLVERTEXSTREAM3D);
      EXTMGR_FUNC_INIT(glVertexStream3sv, GLVERTEXSTREAM3SV);
      EXTMGR_FUNC_INIT(glVertexStream3iv, GLVERTEXSTREAM3IV);
      EXTMGR_FUNC_INIT(glVertexStream3fv, GLVERTEXSTREAM3FV);
      EXTMGR_FUNC_INIT(glVertexStream3dv, GLVERTEXSTREAM3DV);
      EXTMGR_FUNC_INIT(glVertexStream4s, GLVERTEXSTREAM4S);
      EXTMGR_FUNC_INIT(glVertexStream4i, GLVERTEXSTREAM4I);
      EXTMGR_FUNC_INIT(glVertexStream4f, GLVERTEXSTREAM4F);
      EXTMGR_FUNC_INIT(glVertexStream4d, GLVERTEXSTREAM4D);
      EXTMGR_FUNC_INIT(glVertexStream4sv, GLVERTEXSTREAM4SV);
      EXTMGR_FUNC_INIT(glVertexStream4iv, GLVERTEXSTREAM4IV);
      EXTMGR_FUNC_INIT(glVertexStream4fv, GLVERTEXSTREAM4FV);
      EXTMGR_FUNC_INIT(glVertexStream4dv, GLVERTEXSTREAM4DV);
      EXTMGR_FUNC_INIT(glNormalStream3b, GLNORMALSTREAM3B);
      EXTMGR_FUNC_INIT(glNormalStream3s, GLNORMALSTREAM3S);
      EXTMGR_FUNC_INIT(glNormalStream3i, GLNORMALSTREAM3I);
      EXTMGR_FUNC_INIT(glNormalStream3f, GLNORMALSTREAM3F);
      EXTMGR_FUNC_INIT(glNormalStream3d, GLNORMALSTREAM3D);
      EXTMGR_FUNC_INIT(glNormalStream3bv, GLNORMALSTREAM3BV);
      EXTMGR_FUNC_INIT(glNormalStream3sv, GLNORMALSTREAM3SV);
      EXTMGR_FUNC_INIT(glNormalStream3iv, GLNORMALSTREAM3IV);
      EXTMGR_FUNC_INIT(glNormalStream3fv, GLNORMALSTREAM3FV);
      EXTMGR_FUNC_INIT(glNormalStream3dv, GLNORMALSTREAM3DV);
      EXTMGR_FUNC_INIT(glClientActiveVertexStream, GLCLIENTACTIVEVERTEXSTREAM);
      EXTMGR_FUNC_INIT(glVertexBlendEnvi, GLVERTEXBLENDENVI);
      EXTMGR_FUNC_INIT(glVertexBlendEnvf, GLVERTEXBLENDENVF);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ATI_vertex_streams)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
#ifdef _WIN32
  void InitWGL_I3D_image_buffer (HDC hDC)
  {
    if (tested_CS_WGL_I3D_image_buffer) return;
    tested_CS_WGL_I3D_image_buffer = true;
    const char* ext = "WGL_I3D_image_buffer";
    char cfgkey[26 + 20 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    SetupWGLextStr (hDC);
    CS_WGL_I3D_image_buffer = (strstr (extstrWGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_WGL_I3D_image_buffer;
    allclear = true;
    if (init)
    {
      EXTMGR_FUNC_INIT(wglCreateImageBufferI3D, WGLCREATEIMAGEBUFFERI3D);
      EXTMGR_FUNC_INIT(wglDestroyImageBufferI3D, WGLDESTROYIMAGEBUFFERI3D);
      EXTMGR_FUNC_INIT(wglAssociateImageBufferEventsI3D, WGLASSOCIATEIMAGEBUFFEREVENTSI3D);
      EXTMGR_FUNC_INIT(wglReleaseImageBufferEventsI3D, WGLRELEASEIMAGEBUFFEREVENTSI3D);

      EXTMGR_REPORT_INIT_RESULT("WGL", WGL_I3D_image_buffer)
      CS_WGL_I3D_image_buffer &= allclear;
    }
    else
    {
      Report (msgExtNotFound, "WGL", ext);
    }
  }
#endif

#ifdef _WIN32
  void InitWGL_I3D_swap_frame_lock (HDC hDC)
  {
    if (tested_CS_WGL_I3D_swap_frame_lock) return;
    tested_CS_WGL_I3D_swap_frame_lock = true;
    const char* ext = "WGL_I3D_swap_frame_lock";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    SetupWGLextStr (hDC);
    CS_WGL_I3D_swap_frame_lock = (strstr (extstrWGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_WGL_I3D_swap_frame_lock;
    allclear = true;
    if (init)
    {
      EXTMGR_FUNC_INIT(wglEnableFrameLockI3D, WGLENABLEFRAMELOCKI3D);
      EXTMGR_FUNC_INIT(wglDisableFrameLockI3D, WGLDISABLEFRAMELOCKI3D);
      EXTMGR_FUNC_INIT(wglIsEnabledFrameLockI3D, WGLISENABLEDFRAMELOCKI3D);
      EXTMGR_FUNC_INIT(wglQueryFrameLockMasterI3D, WGLQUERYFRAMELOCKMASTERI3D);

      EXTMGR_REPORT_INIT_RESULT("WGL", WGL_I3D_swap_frame_lock)
      CS_WGL_I3D_swap_frame_lock &= allclear;
    }
    else
    {
      Report (msgExtNotFound, "WGL", ext);
    }
  }
#endif

#ifdef _WIN32
  void InitWGL_I3D_swap_frame_usage (HDC hDC)
  {
    if (tested_CS_WGL_I3D_swap_frame_usage) return;
    tested_CS_WGL_I3D_swap_frame_usage = true;
    const char* ext = "WGL_I3D_swap_frame_usage";
    char cfgkey[26 + 24 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    SetupWGLextStr (hDC);
    CS_WGL_I3D_swap_frame_usage = (strstr (extstrWGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_WGL_I3D_swap_frame_usage;
    allclear = true;
    if (init)
    {
      EXTMGR_FUNC_INIT(wglGetFrameUsageI3D, WGLGETFRAMEUSAGEI3D);
      EXTMGR_FUNC_INIT(wglBeginFrameTrackingI3D, WGLBEGINFRAMETRACKINGI3D);
      EXTMGR_FUNC_INIT(wglEndFrameTrackingI3D, WGLENDFRAMETRACKINGI3D);
      EXTMGR_FUNC_INIT(wglQueryFrameTrackingI3D, WGLQUERYFRAMETRACKINGI3D);

      EXTMGR_REPORT_INIT_RESULT("WGL", WGL_I3D_swap_frame_usage)
      CS_WGL_I3D_swap_frame_usage &= allclear;
    }
    else
    {
      Report (msgExtNotFound, "WGL", ext);
    }
  }
#endif

  void InitGL_3DFX_texture_compression_FXT1 ()
  {
    if (tested_CS_GL_3DFX_texture_compression_FXT1) return;
    tested_CS_GL_3DFX_texture_compression_FXT1 = true;
    const char* ext = "GL_3DFX_texture_compression_FXT1";
    char cfgkey[26 + 32 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_3DFX_texture_compression_FXT1 = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_3DFX_texture_compression_FXT1;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_3DFX_texture_compression_FXT1)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_IBM_cull_vertex ()
  {
    if (tested_CS_GL_IBM_cull_vertex) return;
    tested_CS_GL_IBM_cull_vertex = true;
    const char* ext = "GL_IBM_cull_vertex";
    char cfgkey[26 + 18 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_IBM_cull_vertex = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_IBM_cull_vertex;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_IBM_cull_vertex)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_IBM_multimode_draw_arrays ()
  {
    if (tested_CS_GL_IBM_multimode_draw_arrays) return;
    tested_CS_GL_IBM_multimode_draw_arrays = true;
    const char* ext = "GL_IBM_multimode_draw_arrays";
    char cfgkey[26 + 28 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_IBM_multimode_draw_arrays = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_IBM_multimode_draw_arrays;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glMultiModeDrawArraysIBM, GLMULTIMODEDRAWARRAYSIBM);
      EXTMGR_FUNC_INIT(glMultiModeDrawElementsIBM, GLMULTIMODEDRAWELEMENTSIBM);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_IBM_multimode_draw_arrays)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_IBM_raster_pos_clip ()
  {
    if (tested_CS_GL_IBM_raster_pos_clip) return;
    tested_CS_GL_IBM_raster_pos_clip = true;
    const char* ext = "GL_IBM_raster_pos_clip";
    char cfgkey[26 + 22 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_IBM_raster_pos_clip = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_IBM_raster_pos_clip;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_IBM_raster_pos_clip)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_IBM_texture_mirrored_repeat ()
  {
    if (tested_CS_GL_IBM_texture_mirrored_repeat) return;
    tested_CS_GL_IBM_texture_mirrored_repeat = true;
    const char* ext = "GL_IBM_texture_mirrored_repeat";
    char cfgkey[26 + 30 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_IBM_texture_mirrored_repeat = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_IBM_texture_mirrored_repeat;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_IBM_texture_mirrored_repeat)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_IBM_vertex_array_lists ()
  {
    if (tested_CS_GL_IBM_vertex_array_lists) return;
    tested_CS_GL_IBM_vertex_array_lists = true;
    const char* ext = "GL_IBM_vertex_array_lists";
    char cfgkey[26 + 25 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_IBM_vertex_array_lists = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_IBM_vertex_array_lists;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glColorPointerListIBM, GLCOLORPOINTERLISTIBM);
      EXTMGR_FUNC_INIT(glSecondaryColorPointerListIBM, GLSECONDARYCOLORPOINTERLISTIBM);
      EXTMGR_FUNC_INIT(glEdgeFlagPointerListIBM, GLEDGEFLAGPOINTERLISTIBM);
      EXTMGR_FUNC_INIT(glFogCoordPointerListIBM, GLFOGCOORDPOINTERLISTIBM);
      EXTMGR_FUNC_INIT(glNormalPointerListIBM, GLNORMALPOINTERLISTIBM);
      EXTMGR_FUNC_INIT(glTexCoordPointerListIBM, GLTEXCOORDPOINTERLISTIBM);
      EXTMGR_FUNC_INIT(glVertexPointerListIBM, GLVERTEXPOINTERLISTIBM);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_IBM_vertex_array_lists)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_MESA_resize_buffers ()
  {
    if (tested_CS_GL_MESA_resize_buffers) return;
    tested_CS_GL_MESA_resize_buffers = true;
    const char* ext = "GL_MESA_resize_buffers";
    char cfgkey[26 + 22 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_MESA_resize_buffers = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_MESA_resize_buffers;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glResizeBuffersMESA, GLRESIZEBUFFERSMESA);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_MESA_resize_buffers)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_MESA_window_pos ()
  {
    if (tested_CS_GL_MESA_window_pos) return;
    tested_CS_GL_MESA_window_pos = true;
    const char* ext = "GL_MESA_window_pos";
    char cfgkey[26 + 18 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_MESA_window_pos = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_MESA_window_pos;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glWindowPos2dMESA, GLWINDOWPOS2DMESA);
      EXTMGR_FUNC_INIT(glWindowPos2fMESA, GLWINDOWPOS2FMESA);
      EXTMGR_FUNC_INIT(glWindowPos2iMESA, GLWINDOWPOS2IMESA);
      EXTMGR_FUNC_INIT(glWindowPos2sMESA, GLWINDOWPOS2SMESA);
      EXTMGR_FUNC_INIT(glWindowPos2ivMESA, GLWINDOWPOS2IVMESA);
      EXTMGR_FUNC_INIT(glWindowPos2svMESA, GLWINDOWPOS2SVMESA);
      EXTMGR_FUNC_INIT(glWindowPos2fvMESA, GLWINDOWPOS2FVMESA);
      EXTMGR_FUNC_INIT(glWindowPos2dvMESA, GLWINDOWPOS2DVMESA);
      EXTMGR_FUNC_INIT(glWindowPos3iMESA, GLWINDOWPOS3IMESA);
      EXTMGR_FUNC_INIT(glWindowPos3sMESA, GLWINDOWPOS3SMESA);
      EXTMGR_FUNC_INIT(glWindowPos3fMESA, GLWINDOWPOS3FMESA);
      EXTMGR_FUNC_INIT(glWindowPos3dMESA, GLWINDOWPOS3DMESA);
      EXTMGR_FUNC_INIT(glWindowPos3ivMESA, GLWINDOWPOS3IVMESA);
      EXTMGR_FUNC_INIT(glWindowPos3svMESA, GLWINDOWPOS3SVMESA);
      EXTMGR_FUNC_INIT(glWindowPos3fvMESA, GLWINDOWPOS3FVMESA);
      EXTMGR_FUNC_INIT(glWindowPos3dvMESA, GLWINDOWPOS3DVMESA);
      EXTMGR_FUNC_INIT(glWindowPos4iMESA, GLWINDOWPOS4IMESA);
      EXTMGR_FUNC_INIT(glWindowPos4sMESA, GLWINDOWPOS4SMESA);
      EXTMGR_FUNC_INIT(glWindowPos4fMESA, GLWINDOWPOS4FMESA);
      EXTMGR_FUNC_INIT(glWindowPos4dMESA, GLWINDOWPOS4DMESA);
      EXTMGR_FUNC_INIT(glWindowPos4ivMESA, GLWINDOWPOS4IVMESA);
      EXTMGR_FUNC_INIT(glWindowPos4svMESA, GLWINDOWPOS4SVMESA);
      EXTMGR_FUNC_INIT(glWindowPos4fvMESA, GLWINDOWPOS4FVMESA);
      EXTMGR_FUNC_INIT(glWindowPos4dvMESA, GLWINDOWPOS4DVMESA);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_MESA_window_pos)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_OML_interlace ()
  {
    if (tested_CS_GL_OML_interlace) return;
    tested_CS_GL_OML_interlace = true;
    const char* ext = "GL_OML_interlace";
    char cfgkey[26 + 16 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_OML_interlace = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_OML_interlace;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_OML_interlace)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_OML_resample ()
  {
    if (tested_CS_GL_OML_resample) return;
    tested_CS_GL_OML_resample = true;
    const char* ext = "GL_OML_resample";
    char cfgkey[26 + 15 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_OML_resample = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_OML_resample;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_OML_resample)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_OML_subsample ()
  {
    if (tested_CS_GL_OML_subsample) return;
    tested_CS_GL_OML_subsample = true;
    const char* ext = "GL_OML_subsample";
    char cfgkey[26 + 16 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_OML_subsample = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_OML_subsample;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_OML_subsample)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_SGIS_generate_mipmap ()
  {
    if (tested_CS_GL_SGIS_generate_mipmap) return;
    tested_CS_GL_SGIS_generate_mipmap = true;
    const char* ext = "GL_SGIS_generate_mipmap";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_SGIS_generate_mipmap = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_SGIS_generate_mipmap;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_SGIS_generate_mipmap)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_SGIS_multisample ()
  {
    if (tested_CS_GL_SGIS_multisample) return;
    tested_CS_GL_SGIS_multisample = true;
    const char* ext = "GL_SGIS_multisample";
    char cfgkey[26 + 19 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_SGIS_multisample = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_SGIS_multisample;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glSampleMaskSGIS, GLSAMPLEMASKSGIS);
      EXTMGR_FUNC_INIT(glSamplePatternSGIS, GLSAMPLEPATTERNSGIS);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_SGIS_multisample)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_SGIS_pixel_texture ()
  {
    if (tested_CS_GL_SGIS_pixel_texture) return;
    tested_CS_GL_SGIS_pixel_texture = true;
    const char* ext = "GL_SGIS_pixel_texture";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_SGIS_pixel_texture = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_SGIS_pixel_texture;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glPixelTexGenParameteriSGIS, GLPIXELTEXGENPARAMETERISGIS);
      EXTMGR_FUNC_INIT(glPixelTexGenParameterfSGIS, GLPIXELTEXGENPARAMETERFSGIS);
      EXTMGR_FUNC_INIT(glGetPixelTexGenParameterivSGIS, GLGETPIXELTEXGENPARAMETERIVSGIS);
      EXTMGR_FUNC_INIT(glGetPixelTexGenParameterfvSGIS, GLGETPIXELTEXGENPARAMETERFVSGIS);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_SGIS_pixel_texture)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_SGIS_texture_border_clamp ()
  {
    if (tested_CS_GL_SGIS_texture_border_clamp) return;
    tested_CS_GL_SGIS_texture_border_clamp = true;
    const char* ext = "GL_SGIS_texture_border_clamp";
    char cfgkey[26 + 28 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_SGIS_texture_border_clamp = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_SGIS_texture_border_clamp;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_SGIS_texture_border_clamp)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_SGIS_texture_color_mask ()
  {
    if (tested_CS_GL_SGIS_texture_color_mask) return;
    tested_CS_GL_SGIS_texture_color_mask = true;
    const char* ext = "GL_SGIS_texture_color_mask";
    char cfgkey[26 + 26 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_SGIS_texture_color_mask = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_SGIS_texture_color_mask;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glTextureColorMaskSGIS, GLTEXTURECOLORMASKSGIS);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_SGIS_texture_color_mask)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_SGIS_texture_edge_clamp ()
  {
    if (tested_CS_GL_SGIS_texture_edge_clamp) return;
    tested_CS_GL_SGIS_texture_edge_clamp = true;
    const char* ext = "GL_SGIS_texture_edge_clamp";
    char cfgkey[26 + 26 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_SGIS_texture_edge_clamp = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_SGIS_texture_edge_clamp;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_SGIS_texture_edge_clamp)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_SGIS_texture_lod ()
  {
    if (tested_CS_GL_SGIS_texture_lod) return;
    tested_CS_GL_SGIS_texture_lod = true;
    const char* ext = "GL_SGIS_texture_lod";
    char cfgkey[26 + 19 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_SGIS_texture_lod = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_SGIS_texture_lod;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_SGIS_texture_lod)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_SGIS_depth_texture ()
  {
    if (tested_CS_GL_SGIS_depth_texture) return;
    tested_CS_GL_SGIS_depth_texture = true;
    const char* ext = "GL_SGIS_depth_texture";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_SGIS_depth_texture = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_SGIS_depth_texture;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_SGIS_depth_texture)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_SGIX_fog_offset ()
  {
    if (tested_CS_GL_SGIX_fog_offset) return;
    tested_CS_GL_SGIX_fog_offset = true;
    const char* ext = "GL_SGIX_fog_offset";
    char cfgkey[26 + 18 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_SGIX_fog_offset = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_SGIX_fog_offset;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_SGIX_fog_offset)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_SGIX_interlace ()
  {
    if (tested_CS_GL_SGIX_interlace) return;
    tested_CS_GL_SGIX_interlace = true;
    const char* ext = "GL_SGIX_interlace";
    char cfgkey[26 + 17 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_SGIX_interlace = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_SGIX_interlace;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_SGIX_interlace)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_SGIX_shadow_ambient ()
  {
    if (tested_CS_GL_SGIX_shadow_ambient) return;
    tested_CS_GL_SGIX_shadow_ambient = true;
    const char* ext = "GL_SGIX_shadow_ambient";
    char cfgkey[26 + 22 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_SGIX_shadow_ambient = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_SGIX_shadow_ambient;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_SGIX_shadow_ambient)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_SGI_color_matrix ()
  {
    if (tested_CS_GL_SGI_color_matrix) return;
    tested_CS_GL_SGI_color_matrix = true;
    const char* ext = "GL_SGI_color_matrix";
    char cfgkey[26 + 19 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_SGI_color_matrix = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_SGI_color_matrix;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_SGI_color_matrix)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_SGI_color_table ()
  {
    if (tested_CS_GL_SGI_color_table) return;
    tested_CS_GL_SGI_color_table = true;
    const char* ext = "GL_SGI_color_table";
    char cfgkey[26 + 18 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_SGI_color_table = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_SGI_color_table;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glColorTableSGI, GLCOLORTABLESGI);
      EXTMGR_FUNC_INIT(glCopyColorTableSGI, GLCOPYCOLORTABLESGI);
      EXTMGR_FUNC_INIT(glColorTableParameterivSGI, GLCOLORTABLEPARAMETERIVSGI);
      EXTMGR_FUNC_INIT(glColorTableParameterfvSGI, GLCOLORTABLEPARAMETERFVSGI);
      EXTMGR_FUNC_INIT(glGetColorTableSGI, GLGETCOLORTABLESGI);
      EXTMGR_FUNC_INIT(glGetColorTableParameterivSGI, GLGETCOLORTABLEPARAMETERIVSGI);
      EXTMGR_FUNC_INIT(glGetColorTableParameterfvSGI, GLGETCOLORTABLEPARAMETERFVSGI);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_SGI_color_table)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_SGI_texture_color_table ()
  {
    if (tested_CS_GL_SGI_texture_color_table) return;
    tested_CS_GL_SGI_texture_color_table = true;
    const char* ext = "GL_SGI_texture_color_table";
    char cfgkey[26 + 26 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_SGI_texture_color_table = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_SGI_texture_color_table;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_SGI_texture_color_table)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_SUN_vertex ()
  {
    if (tested_CS_GL_SUN_vertex) return;
    tested_CS_GL_SUN_vertex = true;
    const char* ext = "GL_SUN_vertex";
    char cfgkey[26 + 13 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_SUN_vertex = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_SUN_vertex;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glColor4ubVertex2fSUN, GLCOLOR4UBVERTEX2FSUN);
      EXTMGR_FUNC_INIT(glColor4ubVertex2fvSUN, GLCOLOR4UBVERTEX2FVSUN);
      EXTMGR_FUNC_INIT(glColor4ubVertex3fSUN, GLCOLOR4UBVERTEX3FSUN);
      EXTMGR_FUNC_INIT(glColor4ubVertex3fvSUN, GLCOLOR4UBVERTEX3FVSUN);
      EXTMGR_FUNC_INIT(glColor3fVertex3fSUN, GLCOLOR3FVERTEX3FSUN);
      EXTMGR_FUNC_INIT(glColor3fVertex3fvSUN, GLCOLOR3FVERTEX3FVSUN);
      EXTMGR_FUNC_INIT(glNormal3fVertex3fSUN, GLNORMAL3FVERTEX3FSUN);
      EXTMGR_FUNC_INIT(glNormal3fVertex3fvSUN, GLNORMAL3FVERTEX3FVSUN);
      EXTMGR_FUNC_INIT(glColor4fNormal3fVertex3fSUN, GLCOLOR4FNORMAL3FVERTEX3FSUN);
      EXTMGR_FUNC_INIT(glColor4fNormal3fVertex3fvSUN, GLCOLOR4FNORMAL3FVERTEX3FVSUN);
      EXTMGR_FUNC_INIT(glTexCoord2fVertex3fSUN, GLTEXCOORD2FVERTEX3FSUN);
      EXTMGR_FUNC_INIT(glTexCoord2fVertex3fvSUN, GLTEXCOORD2FVERTEX3FVSUN);
      EXTMGR_FUNC_INIT(glTexCoord4fVertex4fSUN, GLTEXCOORD4FVERTEX4FSUN);
      EXTMGR_FUNC_INIT(glTexCoord4fVertex4fvSUN, GLTEXCOORD4FVERTEX4FVSUN);
      EXTMGR_FUNC_INIT(glTexCoord2fColor4ubVertex3fSUN, GLTEXCOORD2FCOLOR4UBVERTEX3FSUN);
      EXTMGR_FUNC_INIT(glTexCoord2fColor4ubVertex3fvSUN, GLTEXCOORD2FCOLOR4UBVERTEX3FVSUN);
      EXTMGR_FUNC_INIT(glTexCoord2fColor3fVertex3fSUN, GLTEXCOORD2FCOLOR3FVERTEX3FSUN);
      EXTMGR_FUNC_INIT(glTexCoord2fColor3fVertex3fvSUN, GLTEXCOORD2FCOLOR3FVERTEX3FVSUN);
      EXTMGR_FUNC_INIT(glTexCoord2fNormal3fVertex3fSUN, GLTEXCOORD2FNORMAL3FVERTEX3FSUN);
      EXTMGR_FUNC_INIT(glTexCoord2fNormal3fVertex3fvSUN, GLTEXCOORD2FNORMAL3FVERTEX3FVSUN);
      EXTMGR_FUNC_INIT(glTexCoord2fColor4fNormal3fVertex3fSUN, GLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUN);
      EXTMGR_FUNC_INIT(glTexCoord2fColor4fNormal3fVertex3fvSUN, GLTEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUN);
      EXTMGR_FUNC_INIT(glTexCoord4fColor4fNormal3fVertex4fSUN, GLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FSUN);
      EXTMGR_FUNC_INIT(glTexCoord4fColor4fNormal3fVertex4fvSUN, GLTEXCOORD4FCOLOR4FNORMAL3FVERTEX4FVSUN);
      EXTMGR_FUNC_INIT(glReplacementCodeuiVertex3fSUN, GLREPLACEMENTCODEUIVERTEX3FSUN);
      EXTMGR_FUNC_INIT(glReplacementCodeuiVertex3fvSUN, GLREPLACEMENTCODEUIVERTEX3FVSUN);
      EXTMGR_FUNC_INIT(glReplacementCodeuiColor4ubVertex3fSUN, GLREPLACEMENTCODEUICOLOR4UBVERTEX3FSUN);
      EXTMGR_FUNC_INIT(glReplacementCodeuiColor4ubVertex3fvSUN, GLREPLACEMENTCODEUICOLOR4UBVERTEX3FVSUN);
      EXTMGR_FUNC_INIT(glReplacementCodeuiColor3fVertex3fSUN, GLREPLACEMENTCODEUICOLOR3FVERTEX3FSUN);
      EXTMGR_FUNC_INIT(glReplacementCodeuiColor3fVertex3fvSUN, GLREPLACEMENTCODEUICOLOR3FVERTEX3FVSUN);
      EXTMGR_FUNC_INIT(glReplacementCodeuiNormal3fVertex3fSUN, GLREPLACEMENTCODEUINORMAL3FVERTEX3FSUN);
      EXTMGR_FUNC_INIT(glReplacementCodeuiNormal3fVertex3fvSUN, GLREPLACEMENTCODEUINORMAL3FVERTEX3FVSUN);
      EXTMGR_FUNC_INIT(glReplacementCodeuiColor4fNormal3fVertex3fSUN, GLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FSUN);
      EXTMGR_FUNC_INIT(glReplacementCodeuiColor4fNormal3fVertex3fvSUN, GLREPLACEMENTCODEUICOLOR4FNORMAL3FVERTEX3FVSUN);
      EXTMGR_FUNC_INIT(glReplacementCodeuiTexCoord2fVertex3fSUN, GLREPLACEMENTCODEUITEXCOORD2FVERTEX3FSUN);
      EXTMGR_FUNC_INIT(glReplacementCodeuiTexCoord2fVertex3fvSUN, GLREPLACEMENTCODEUITEXCOORD2FVERTEX3FVSUN);
      EXTMGR_FUNC_INIT(glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN, GLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FSUN);
      EXTMGR_FUNC_INIT(glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN, GLREPLACEMENTCODEUITEXCOORD2FNORMAL3FVERTEX3FVSUN);
      EXTMGR_FUNC_INIT(glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN, GLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FSUN);
      EXTMGR_FUNC_INIT(glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN, GLREPLACEMENTCODEUITEXCOORD2FCOLOR4FNORMAL3FVERTEX3FVSUN);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_SUN_vertex)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_fragment_program ()
  {
    if (tested_CS_GL_ARB_fragment_program) return;
    tested_CS_GL_ARB_fragment_program = true;
    const char* ext = "GL_ARB_fragment_program";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_fragment_program = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_fragment_program;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glProgramStringARB, GLPROGRAMSTRINGARB);
      EXTMGR_FUNC_INIT(glBindProgramARB, GLBINDPROGRAMARB);
      EXTMGR_FUNC_INIT(glDeleteProgramsARB, GLDELETEPROGRAMSARB);
      EXTMGR_FUNC_INIT(glGenProgramsARB, GLGENPROGRAMSARB);
      EXTMGR_FUNC_INIT(glProgramEnvParameter4dARB, GLPROGRAMENVPARAMETER4DARB);
      EXTMGR_FUNC_INIT(glProgramEnvParameter4dvARB, GLPROGRAMENVPARAMETER4DVARB);
      EXTMGR_FUNC_INIT(glProgramEnvParameter4fARB, GLPROGRAMENVPARAMETER4FARB);
      EXTMGR_FUNC_INIT(glProgramEnvParameter4fvARB, GLPROGRAMENVPARAMETER4FVARB);
      EXTMGR_FUNC_INIT(glProgramLocalParameter4dARB, GLPROGRAMLOCALPARAMETER4DARB);
      EXTMGR_FUNC_INIT(glProgramLocalParameter4dvARB, GLPROGRAMLOCALPARAMETER4DVARB);
      EXTMGR_FUNC_INIT(glProgramLocalParameter4fARB, GLPROGRAMLOCALPARAMETER4FARB);
      EXTMGR_FUNC_INIT(glProgramLocalParameter4fvARB, GLPROGRAMLOCALPARAMETER4FVARB);
      EXTMGR_FUNC_INIT(glGetProgramEnvParameterdvARB, GLGETPROGRAMENVPARAMETERDVARB);
      EXTMGR_FUNC_INIT(glGetProgramEnvParameterfvARB, GLGETPROGRAMENVPARAMETERFVARB);
      EXTMGR_FUNC_INIT(glGetProgramLocalParameterdvARB, GLGETPROGRAMLOCALPARAMETERDVARB);
      EXTMGR_FUNC_INIT(glGetProgramLocalParameterfvARB, GLGETPROGRAMLOCALPARAMETERFVARB);
      EXTMGR_FUNC_INIT(glGetProgramivARB, GLGETPROGRAMIVARB);
      EXTMGR_FUNC_INIT(glGetProgramStringARB, GLGETPROGRAMSTRINGARB);
      EXTMGR_FUNC_INIT(glIsProgramARB, GLISPROGRAMARB);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_fragment_program)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ATI_text_fragment_shader ()
  {
    if (tested_CS_GL_ATI_text_fragment_shader) return;
    tested_CS_GL_ATI_text_fragment_shader = true;
    const char* ext = "GL_ATI_text_fragment_shader";
    char cfgkey[26 + 27 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ATI_text_fragment_shader = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ATI_text_fragment_shader;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ATI_text_fragment_shader)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_APPLE_client_storage ()
  {
    if (tested_CS_GL_APPLE_client_storage) return;
    tested_CS_GL_APPLE_client_storage = true;
    const char* ext = "GL_APPLE_client_storage";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_APPLE_client_storage = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_APPLE_client_storage;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_APPLE_client_storage)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_APPLE_element_array ()
  {
    if (tested_CS_GL_APPLE_element_array) return;
    tested_CS_GL_APPLE_element_array = true;
    const char* ext = "GL_APPLE_element_array";
    char cfgkey[26 + 22 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_APPLE_element_array = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_APPLE_element_array;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glElementPointerAPPLE, GLELEMENTPOINTERAPPLE);
      EXTMGR_FUNC_INIT(glDrawElementArrayAPPLE, GLDRAWELEMENTARRAYAPPLE);
      EXTMGR_FUNC_INIT(glDrawRangeElementArrayAPPLE, GLDRAWRANGEELEMENTARRAYAPPLE);
      EXTMGR_FUNC_INIT(glMultiDrawElementArrayAPPLE, GLMULTIDRAWELEMENTARRAYAPPLE);
      EXTMGR_FUNC_INIT(glMultiDrawRangeElementArrayAPPLE, GLMULTIDRAWRANGEELEMENTARRAYAPPLE);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_APPLE_element_array)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_APPLE_fence ()
  {
    if (tested_CS_GL_APPLE_fence) return;
    tested_CS_GL_APPLE_fence = true;
    const char* ext = "GL_APPLE_fence";
    char cfgkey[26 + 14 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_APPLE_fence = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_APPLE_fence;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glGenFencesAPPLE, GLGENFENCESAPPLE);
      EXTMGR_FUNC_INIT(glDeleteFencesAPPLE, GLDELETEFENCESAPPLE);
      EXTMGR_FUNC_INIT(glSetFenceAPPLE, GLSETFENCEAPPLE);
      EXTMGR_FUNC_INIT(glIsFenceAPPLE, GLISFENCEAPPLE);
      EXTMGR_FUNC_INIT(glTestFenceAPPLE, GLTESTFENCEAPPLE);
      EXTMGR_FUNC_INIT(glFinishFenceAPPLE, GLFINISHFENCEAPPLE);
      EXTMGR_FUNC_INIT(glTestObjectAPPLE, GLTESTOBJECTAPPLE);
      EXTMGR_FUNC_INIT(glFinishObjectAPPLE, GLFINISHOBJECTAPPLE);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_APPLE_fence)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_APPLE_vertex_array_object ()
  {
    if (tested_CS_GL_APPLE_vertex_array_object) return;
    tested_CS_GL_APPLE_vertex_array_object = true;
    const char* ext = "GL_APPLE_vertex_array_object";
    char cfgkey[26 + 28 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_APPLE_vertex_array_object = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_APPLE_vertex_array_object;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glBindVertexArrayAPPLE, GLBINDVERTEXARRAYAPPLE);
      EXTMGR_FUNC_INIT(glDeleteVertexArraysAPPLE, GLDELETEVERTEXARRAYSAPPLE);
      EXTMGR_FUNC_INIT(glGenVertexArraysAPPLE, GLGENVERTEXARRAYSAPPLE);
      EXTMGR_FUNC_INIT(glIsVertexArrayAPPLE, GLISVERTEXARRAYAPPLE);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_APPLE_vertex_array_object)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_APPLE_vertex_array_range ()
  {
    if (tested_CS_GL_APPLE_vertex_array_range) return;
    tested_CS_GL_APPLE_vertex_array_range = true;
    const char* ext = "GL_APPLE_vertex_array_range";
    char cfgkey[26 + 27 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_APPLE_vertex_array_range = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_APPLE_vertex_array_range;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glVertexArrayRangeAPPLE, GLVERTEXARRAYRANGEAPPLE);
      EXTMGR_FUNC_INIT(glFlushVertexArrayRangeAPPLE, GLFLUSHVERTEXARRAYRANGEAPPLE);
      EXTMGR_FUNC_INIT(glVertexArrayParameteriAPPLE, GLVERTEXARRAYPARAMETERIAPPLE);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_APPLE_vertex_array_range)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
#ifdef _WIN32
  void InitWGL_ARB_pixel_format (HDC hDC)
  {
    if (tested_CS_WGL_ARB_pixel_format) return;
    tested_CS_WGL_ARB_pixel_format = true;
    const char* ext = "WGL_ARB_pixel_format";
    char cfgkey[26 + 20 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    SetupWGLextStr (hDC);
    CS_WGL_ARB_pixel_format = (strstr (extstrWGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_WGL_ARB_pixel_format;
    allclear = true;
    if (init)
    {
      EXTMGR_FUNC_INIT(wglGetPixelFormatAttribivARB, WGLGETPIXELFORMATATTRIBIVARB);
      EXTMGR_FUNC_INIT(wglGetPixelFormatAttribfvARB, WGLGETPIXELFORMATATTRIBFVARB);
      EXTMGR_FUNC_INIT(wglChoosePixelFormatARB, WGLCHOOSEPIXELFORMATARB);

      EXTMGR_REPORT_INIT_RESULT("WGL", WGL_ARB_pixel_format)
      CS_WGL_ARB_pixel_format &= allclear;
    }
    else
    {
      Report (msgExtNotFound, "WGL", ext);
    }
  }
#endif

#ifdef _WIN32
  void InitWGL_ARB_make_current_read (HDC hDC)
  {
    if (tested_CS_WGL_ARB_make_current_read) return;
    tested_CS_WGL_ARB_make_current_read = true;
    const char* ext = "WGL_ARB_make_current_read";
    char cfgkey[26 + 25 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    SetupWGLextStr (hDC);
    CS_WGL_ARB_make_current_read = (strstr (extstrWGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_WGL_ARB_make_current_read;
    allclear = true;
    if (init)
    {
      EXTMGR_FUNC_INIT(wglMakeContextCurrentARB, WGLMAKECONTEXTCURRENTARB);
      EXTMGR_FUNC_INIT(wglGetCurrentReadDCARB, WGLGETCURRENTREADDCARB);

      EXTMGR_REPORT_INIT_RESULT("WGL", WGL_ARB_make_current_read)
      CS_WGL_ARB_make_current_read &= allclear;
    }
    else
    {
      Report (msgExtNotFound, "WGL", ext);
    }
  }
#endif

#ifdef _WIN32
  void InitWGL_ARB_pbuffer (HDC hDC)
  {
    if (tested_CS_WGL_ARB_pbuffer) return;
    tested_CS_WGL_ARB_pbuffer = true;
    const char* ext = "WGL_ARB_pbuffer";
    char cfgkey[26 + 15 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    SetupWGLextStr (hDC);
    CS_WGL_ARB_pbuffer = (strstr (extstrWGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_WGL_ARB_pbuffer;
    allclear = true;
    if (init)
    {
      EXTMGR_FUNC_INIT(wglCreatePbufferARB, WGLCREATEPBUFFERARB);
      EXTMGR_FUNC_INIT(wglGetPbufferDCARB, WGLGETPBUFFERDCARB);
      EXTMGR_FUNC_INIT(wglReleasePbufferDCARB, WGLRELEASEPBUFFERDCARB);
      EXTMGR_FUNC_INIT(wglDestroyPbufferARB, WGLDESTROYPBUFFERARB);
      EXTMGR_FUNC_INIT(wglQueryPbufferARB, WGLQUERYPBUFFERARB);

      EXTMGR_REPORT_INIT_RESULT("WGL", WGL_ARB_pbuffer)
      CS_WGL_ARB_pbuffer &= allclear;
    }
    else
    {
      Report (msgExtNotFound, "WGL", ext);
    }
  }
#endif

#ifdef _WIN32
  void InitWGL_EXT_swap_control (HDC hDC)
  {
    if (tested_CS_WGL_EXT_swap_control) return;
    tested_CS_WGL_EXT_swap_control = true;
    const char* ext = "WGL_EXT_swap_control";
    char cfgkey[26 + 20 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    SetupWGLextStr (hDC);
    CS_WGL_EXT_swap_control = (strstr (extstrWGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_WGL_EXT_swap_control;
    allclear = true;
    if (init)
    {
      EXTMGR_FUNC_INIT(wglSwapIntervalEXT, WGLSWAPINTERVALEXT);
      EXTMGR_FUNC_INIT(wglGetSwapIntervalEXT, WGLGETSWAPINTERVALEXT);

      EXTMGR_REPORT_INIT_RESULT("WGL", WGL_EXT_swap_control)
      CS_WGL_EXT_swap_control &= allclear;
    }
    else
    {
      Report (msgExtNotFound, "WGL", ext);
    }
  }
#endif

#ifdef _WIN32
  void InitWGL_ARB_render_texture (HDC hDC)
  {
    if (tested_CS_WGL_ARB_render_texture) return;
    tested_CS_WGL_ARB_render_texture = true;
    const char* ext = "WGL_ARB_render_texture";
    char cfgkey[26 + 22 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    SetupWGLextStr (hDC);
    CS_WGL_ARB_render_texture = (strstr (extstrWGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_WGL_ARB_render_texture;
    allclear = true;
    if (init)
    {
      EXTMGR_FUNC_INIT(wglBindTexImageARB, WGLBINDTEXIMAGEARB);
      EXTMGR_FUNC_INIT(wglReleaseTexImageARB, WGLRELEASETEXIMAGEARB);
      EXTMGR_FUNC_INIT(wglSetPbufferAttribARB, WGLSETPBUFFERATTRIBARB);

      EXTMGR_REPORT_INIT_RESULT("WGL", WGL_ARB_render_texture)
      CS_WGL_ARB_render_texture &= allclear;
    }
    else
    {
      Report (msgExtNotFound, "WGL", ext);
    }
  }
#endif

#ifdef _WIN32
  void InitWGL_EXT_extensions_string (HDC hDC)
  {
    if (tested_CS_WGL_EXT_extensions_string) return;
    tested_CS_WGL_EXT_extensions_string = true;
    const char* ext = "WGL_EXT_extensions_string";
    char cfgkey[26 + 25 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    SetupWGLextStr (hDC);
    CS_WGL_EXT_extensions_string = (strstr (extstrWGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_WGL_EXT_extensions_string;
    allclear = true;
    if (init)
    {
      EXTMGR_FUNC_INIT(wglGetExtensionsStringEXT, WGLGETEXTENSIONSSTRINGEXT);

      EXTMGR_REPORT_INIT_RESULT("WGL", WGL_EXT_extensions_string)
      CS_WGL_EXT_extensions_string &= allclear;
    }
    else
    {
      Report (msgExtNotFound, "WGL", ext);
    }
  }
#endif

#ifdef _WIN32
  void InitWGL_EXT_make_current_read (HDC hDC)
  {
    if (tested_CS_WGL_EXT_make_current_read) return;
    tested_CS_WGL_EXT_make_current_read = true;
    const char* ext = "WGL_EXT_make_current_read";
    char cfgkey[26 + 25 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    SetupWGLextStr (hDC);
    CS_WGL_EXT_make_current_read = (strstr (extstrWGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_WGL_EXT_make_current_read;
    allclear = true;
    if (init)
    {
      EXTMGR_FUNC_INIT(wglMakeContextCurrentEXT, WGLMAKECONTEXTCURRENTEXT);
      EXTMGR_FUNC_INIT(wglGetCurrentReadDCEXT, WGLGETCURRENTREADDCEXT);

      EXTMGR_REPORT_INIT_RESULT("WGL", WGL_EXT_make_current_read)
      CS_WGL_EXT_make_current_read &= allclear;
    }
    else
    {
      Report (msgExtNotFound, "WGL", ext);
    }
  }
#endif

#ifdef _WIN32
  void InitWGL_EXT_pbuffer (HDC hDC)
  {
    if (tested_CS_WGL_EXT_pbuffer) return;
    tested_CS_WGL_EXT_pbuffer = true;
    const char* ext = "WGL_EXT_pbuffer";
    char cfgkey[26 + 15 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    SetupWGLextStr (hDC);
    CS_WGL_EXT_pbuffer = (strstr (extstrWGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_WGL_EXT_pbuffer;
    allclear = true;
    if (init)
    {
      EXTMGR_FUNC_INIT(wglCreatePbufferEXT, WGLCREATEPBUFFEREXT);
      EXTMGR_FUNC_INIT(wglGetPbufferDCEXT, WGLGETPBUFFERDCEXT);
      EXTMGR_FUNC_INIT(wglReleasePbufferDCEXT, WGLRELEASEPBUFFERDCEXT);
      EXTMGR_FUNC_INIT(wglDestroyPbufferEXT, WGLDESTROYPBUFFEREXT);
      EXTMGR_FUNC_INIT(wglQueryPbufferEXT, WGLQUERYPBUFFEREXT);

      EXTMGR_REPORT_INIT_RESULT("WGL", WGL_EXT_pbuffer)
      CS_WGL_EXT_pbuffer &= allclear;
    }
    else
    {
      Report (msgExtNotFound, "WGL", ext);
    }
  }
#endif

#ifdef _WIN32
  void InitWGL_EXT_pixel_format (HDC hDC)
  {
    if (tested_CS_WGL_EXT_pixel_format) return;
    tested_CS_WGL_EXT_pixel_format = true;
    const char* ext = "WGL_EXT_pixel_format";
    char cfgkey[26 + 20 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    SetupWGLextStr (hDC);
    CS_WGL_EXT_pixel_format = (strstr (extstrWGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_WGL_EXT_pixel_format;
    allclear = true;
    if (init)
    {
      EXTMGR_FUNC_INIT(wglGetPixelFormatAttribivEXT, WGLGETPIXELFORMATATTRIBIVEXT);
      EXTMGR_FUNC_INIT(wglGetPixelFormatAttribfvEXT, WGLGETPIXELFORMATATTRIBFVEXT);
      EXTMGR_FUNC_INIT(wglChoosePixelFormatEXT, WGLCHOOSEPIXELFORMATEXT);

      EXTMGR_REPORT_INIT_RESULT("WGL", WGL_EXT_pixel_format)
      CS_WGL_EXT_pixel_format &= allclear;
    }
    else
    {
      Report (msgExtNotFound, "WGL", ext);
    }
  }
#endif

#ifdef _WIN32
  void InitWGL_I3D_digital_video_control (HDC hDC)
  {
    if (tested_CS_WGL_I3D_digital_video_control) return;
    tested_CS_WGL_I3D_digital_video_control = true;
    const char* ext = "WGL_I3D_digital_video_control";
    char cfgkey[26 + 29 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    SetupWGLextStr (hDC);
    CS_WGL_I3D_digital_video_control = (strstr (extstrWGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_WGL_I3D_digital_video_control;
    allclear = true;
    if (init)
    {
      EXTMGR_FUNC_INIT(wglGetDigitalVideoParametersI3D, WGLGETDIGITALVIDEOPARAMETERSI3D);
      EXTMGR_FUNC_INIT(wglSetDigitalVideoParametersI3D, WGLSETDIGITALVIDEOPARAMETERSI3D);

      EXTMGR_REPORT_INIT_RESULT("WGL", WGL_I3D_digital_video_control)
      CS_WGL_I3D_digital_video_control &= allclear;
    }
    else
    {
      Report (msgExtNotFound, "WGL", ext);
    }
  }
#endif

#ifdef _WIN32
  void InitWGL_I3D_gamma (HDC hDC)
  {
    if (tested_CS_WGL_I3D_gamma) return;
    tested_CS_WGL_I3D_gamma = true;
    const char* ext = "WGL_I3D_gamma";
    char cfgkey[26 + 13 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    SetupWGLextStr (hDC);
    CS_WGL_I3D_gamma = (strstr (extstrWGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_WGL_I3D_gamma;
    allclear = true;
    if (init)
    {
      EXTMGR_FUNC_INIT(wglGetGammaTableParametersI3D, WGLGETGAMMATABLEPARAMETERSI3D);
      EXTMGR_FUNC_INIT(wglSetGammaTableParametersI3D, WGLSETGAMMATABLEPARAMETERSI3D);
      EXTMGR_FUNC_INIT(wglGetGammaTableI3D, WGLGETGAMMATABLEI3D);
      EXTMGR_FUNC_INIT(wglSetGammaTableI3D, WGLSETGAMMATABLEI3D);

      EXTMGR_REPORT_INIT_RESULT("WGL", WGL_I3D_gamma)
      CS_WGL_I3D_gamma &= allclear;
    }
    else
    {
      Report (msgExtNotFound, "WGL", ext);
    }
  }
#endif

#ifdef _WIN32
  void InitWGL_I3D_genlock (HDC hDC)
  {
    if (tested_CS_WGL_I3D_genlock) return;
    tested_CS_WGL_I3D_genlock = true;
    const char* ext = "WGL_I3D_genlock";
    char cfgkey[26 + 15 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    SetupWGLextStr (hDC);
    CS_WGL_I3D_genlock = (strstr (extstrWGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_WGL_I3D_genlock;
    allclear = true;
    if (init)
    {
      EXTMGR_FUNC_INIT(wglEnableGenlockI3D, WGLENABLEGENLOCKI3D);
      EXTMGR_FUNC_INIT(wglDisableGenlockI3D, WGLDISABLEGENLOCKI3D);
      EXTMGR_FUNC_INIT(wglIsEnabledGenlockI3D, WGLISENABLEDGENLOCKI3D);
      EXTMGR_FUNC_INIT(wglGenlockSourceI3D, WGLGENLOCKSOURCEI3D);
      EXTMGR_FUNC_INIT(wglGetGenlockSourceI3D, WGLGETGENLOCKSOURCEI3D);
      EXTMGR_FUNC_INIT(wglGenlockSourceEdgeI3D, WGLGENLOCKSOURCEEDGEI3D);
      EXTMGR_FUNC_INIT(wglGetGenlockSourceEdgeI3D, WGLGETGENLOCKSOURCEEDGEI3D);
      EXTMGR_FUNC_INIT(wglGenlockSampleRateI3D, WGLGENLOCKSAMPLERATEI3D);
      EXTMGR_FUNC_INIT(wglGetGenlockSampleRateI3D, WGLGETGENLOCKSAMPLERATEI3D);
      EXTMGR_FUNC_INIT(wglGenlockSourceDelayI3D, WGLGENLOCKSOURCEDELAYI3D);
      EXTMGR_FUNC_INIT(wglGetGenlockSourceDelayI3D, WGLGETGENLOCKSOURCEDELAYI3D);
      EXTMGR_FUNC_INIT(wglQueryGenlockMaxSourceDelayI3D, WGLQUERYGENLOCKMAXSOURCEDELAYI3D);

      EXTMGR_REPORT_INIT_RESULT("WGL", WGL_I3D_genlock)
      CS_WGL_I3D_genlock &= allclear;
    }
    else
    {
      Report (msgExtNotFound, "WGL", ext);
    }
  }
#endif

  void InitGL_ARB_matrix_palette ()
  {
    if (tested_CS_GL_ARB_matrix_palette) return;
    tested_CS_GL_ARB_matrix_palette = true;
    const char* ext = "GL_ARB_matrix_palette";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_matrix_palette = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_matrix_palette;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glCurrentPaletteMatrixARB, GLCURRENTPALETTEMATRIXARB);
      EXTMGR_FUNC_INIT(glMatrixIndexubvARB, GLMATRIXINDEXUBVARB);
      EXTMGR_FUNC_INIT(glMatrixIndexusvARB, GLMATRIXINDEXUSVARB);
      EXTMGR_FUNC_INIT(glMatrixIndexuivARB, GLMATRIXINDEXUIVARB);
      EXTMGR_FUNC_INIT(glMatrixIndexPointerARB, GLMATRIXINDEXPOINTERARB);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_matrix_palette)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_element_array ()
  {
    if (tested_CS_GL_NV_element_array) return;
    tested_CS_GL_NV_element_array = true;
    const char* ext = "GL_NV_element_array";
    char cfgkey[26 + 19 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_element_array = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_element_array;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glElementPointerNV, GLELEMENTPOINTERNV);
      EXTMGR_FUNC_INIT(glDrawElementArrayNV, GLDRAWELEMENTARRAYNV);
      EXTMGR_FUNC_INIT(glDrawRangeElementArrayNV, GLDRAWRANGEELEMENTARRAYNV);
      EXTMGR_FUNC_INIT(glMultiDrawElementArrayNV, GLMULTIDRAWELEMENTARRAYNV);
      EXTMGR_FUNC_INIT(glMultiDrawRangeElementArrayNV, GLMULTIDRAWRANGEELEMENTARRAYNV);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_element_array)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_float_buffer ()
  {
    if (tested_CS_GL_NV_float_buffer) return;
    tested_CS_GL_NV_float_buffer = true;
    const char* ext = "GL_NV_float_buffer";
    char cfgkey[26 + 18 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_float_buffer = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_float_buffer;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_float_buffer)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_fragment_program ()
  {
    if (tested_CS_GL_NV_fragment_program) return;
    tested_CS_GL_NV_fragment_program = true;
    const char* ext = "GL_NV_fragment_program";
    char cfgkey[26 + 22 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_fragment_program = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_fragment_program;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glProgramNamedParameter4fNV, GLPROGRAMNAMEDPARAMETER4FNV);
      EXTMGR_FUNC_INIT(glProgramNamedParameter4dNV, GLPROGRAMNAMEDPARAMETER4DNV);
      EXTMGR_FUNC_INIT(glGetProgramNamedParameterfvNV, GLGETPROGRAMNAMEDPARAMETERFVNV);
      EXTMGR_FUNC_INIT(glGetProgramNamedParameterdvNV, GLGETPROGRAMNAMEDPARAMETERDVNV);
      EXTMGR_FUNC_INIT(glProgramLocalParameter4dARB, GLPROGRAMLOCALPARAMETER4DARB);
      EXTMGR_FUNC_INIT(glProgramLocalParameter4dvARB, GLPROGRAMLOCALPARAMETER4DVARB);
      EXTMGR_FUNC_INIT(glProgramLocalParameter4fARB, GLPROGRAMLOCALPARAMETER4FARB);
      EXTMGR_FUNC_INIT(glProgramLocalParameter4fvARB, GLPROGRAMLOCALPARAMETER4FVARB);
      EXTMGR_FUNC_INIT(glGetProgramLocalParameterdvARB, GLGETPROGRAMLOCALPARAMETERDVARB);
      EXTMGR_FUNC_INIT(glGetProgramLocalParameterfvARB, GLGETPROGRAMLOCALPARAMETERFVARB);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_fragment_program)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_primitive_restart ()
  {
    if (tested_CS_GL_NV_primitive_restart) return;
    tested_CS_GL_NV_primitive_restart = true;
    const char* ext = "GL_NV_primitive_restart";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_primitive_restart = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_primitive_restart;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glPrimitiveRestartNV, GLPRIMITIVERESTARTNV);
      EXTMGR_FUNC_INIT(glPrimitiveRestartIndexNV, GLPRIMITIVERESTARTINDEXNV);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_primitive_restart)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_NV_vertex_program2 ()
  {
    if (tested_CS_GL_NV_vertex_program2) return;
    tested_CS_GL_NV_vertex_program2 = true;
    const char* ext = "GL_NV_vertex_program2";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_NV_vertex_program2 = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_NV_vertex_program2;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_NV_vertex_program2)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_vertex_buffer_object ()
  {
    if (tested_CS_GL_ARB_vertex_buffer_object) return;
    tested_CS_GL_ARB_vertex_buffer_object = true;
    const char* ext = "GL_ARB_vertex_buffer_object";
    char cfgkey[26 + 27 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_vertex_buffer_object = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_vertex_buffer_object;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glBindBufferARB, GLBINDBUFFERARB);
      EXTMGR_FUNC_INIT(glDeleteBuffersARB, GLDELETEBUFFERSARB);
      EXTMGR_FUNC_INIT(glGenBuffersARB, GLGENBUFFERSARB);
      EXTMGR_FUNC_INIT(glBufferDataARB, GLBUFFERDATAARB);
      EXTMGR_FUNC_INIT(glBufferSubDataARB, GLBUFFERSUBDATAARB);
      EXTMGR_FUNC_INIT(glMapBufferARB, GLMAPBUFFERARB);
      EXTMGR_FUNC_INIT(glUnmapBufferARB, GLUNMAPBUFFERARB);
      EXTMGR_FUNC_INIT(glIsBufferARB, GLISBUFFERARB);
      EXTMGR_FUNC_INIT(glGetBufferSubDataARB, GLGETBUFFERSUBDATAARB);
      EXTMGR_FUNC_INIT(glGetBufferPointervARB, GLGETBUFFERPOINTERVARB);
      EXTMGR_FUNC_INIT(glGetBufferParameterivARB, GLGETBUFFERPARAMETERIVARB);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_vertex_buffer_object)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ATI_separate_stencil ()
  {
    if (tested_CS_GL_ATI_separate_stencil) return;
    tested_CS_GL_ATI_separate_stencil = true;
    const char* ext = "GL_ATI_separate_stencil";
    char cfgkey[26 + 23 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ATI_separate_stencil = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ATI_separate_stencil;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glStencilOpSeparateATI, GLSTENCILOPSEPARATEATI);
      EXTMGR_FUNC_INIT(glStencilFuncSeparateATI, GLSTENCILFUNCSEPARATEATI);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ATI_separate_stencil)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_texture_non_power_of_two ()
  {
    if (tested_CS_GL_ARB_texture_non_power_of_two) return;
    tested_CS_GL_ARB_texture_non_power_of_two = true;
    const char* ext = "GL_ARB_texture_non_power_of_two";
    char cfgkey[26 + 31 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_texture_non_power_of_two = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_texture_non_power_of_two;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_texture_non_power_of_two)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_point_sprite ()
  {
    if (tested_CS_GL_ARB_point_sprite) return;
    tested_CS_GL_ARB_point_sprite = true;
    const char* ext = "GL_ARB_point_sprite";
    char cfgkey[26 + 19 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_point_sprite = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_point_sprite;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_point_sprite)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_shading_language_100 ()
  {
    if (tested_CS_GL_ARB_shading_language_100) return;
    tested_CS_GL_ARB_shading_language_100 = true;
    const char* ext = "GL_ARB_shading_language_100";
    char cfgkey[26 + 27 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_shading_language_100 = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_shading_language_100;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_shading_language_100)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_shader_objects ()
  {
    if (tested_CS_GL_ARB_shader_objects) return;
    tested_CS_GL_ARB_shader_objects = true;
    const char* ext = "GL_ARB_shader_objects";
    char cfgkey[26 + 21 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_shader_objects = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_shader_objects;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glDeleteObjectARB, GLDELETEOBJECTARB);
      EXTMGR_FUNC_INIT(glGetHandleARB, GLGETHANDLEARB);
      EXTMGR_FUNC_INIT(glDetachObjectARB, GLDETACHOBJECTARB);
      EXTMGR_FUNC_INIT(glCreateShaderObjectARB, GLCREATESHADEROBJECTARB);
      EXTMGR_FUNC_INIT(glShaderSourceARB, GLSHADERSOURCEARB);
      EXTMGR_FUNC_INIT(glCompileShaderARB, GLCOMPILESHADERARB);
      EXTMGR_FUNC_INIT(glCreateProgramObjectARB, GLCREATEPROGRAMOBJECTARB);
      EXTMGR_FUNC_INIT(glAttachObjectARB, GLATTACHOBJECTARB);
      EXTMGR_FUNC_INIT(glLinkProgramARB, GLLINKPROGRAMARB);
      EXTMGR_FUNC_INIT(glUseProgramObjectARB, GLUSEPROGRAMOBJECTARB);
      EXTMGR_FUNC_INIT(glValidateProgramARB, GLVALIDATEPROGRAMARB);
      EXTMGR_FUNC_INIT(glUniform1fARB, GLUNIFORM1FARB);
      EXTMGR_FUNC_INIT(glUniform2fARB, GLUNIFORM2FARB);
      EXTMGR_FUNC_INIT(glUniform3fARB, GLUNIFORM3FARB);
      EXTMGR_FUNC_INIT(glUniform4fARB, GLUNIFORM4FARB);
      EXTMGR_FUNC_INIT(glUniform1iARB, GLUNIFORM1IARB);
      EXTMGR_FUNC_INIT(glUniform2iARB, GLUNIFORM2IARB);
      EXTMGR_FUNC_INIT(glUniform3iARB, GLUNIFORM3IARB);
      EXTMGR_FUNC_INIT(glUniform4iARB, GLUNIFORM4IARB);
      EXTMGR_FUNC_INIT(glUniform1fvARB, GLUNIFORM1FVARB);
      EXTMGR_FUNC_INIT(glUniform2fvARB, GLUNIFORM2FVARB);
      EXTMGR_FUNC_INIT(glUniform3fvARB, GLUNIFORM3FVARB);
      EXTMGR_FUNC_INIT(glUniform4fvARB, GLUNIFORM4FVARB);
      EXTMGR_FUNC_INIT(glUniform1ivARB, GLUNIFORM1IVARB);
      EXTMGR_FUNC_INIT(glUniform2ivARB, GLUNIFORM2IVARB);
      EXTMGR_FUNC_INIT(glUniform3ivARB, GLUNIFORM3IVARB);
      EXTMGR_FUNC_INIT(glUniform4ivARB, GLUNIFORM4IVARB);
      EXTMGR_FUNC_INIT(glUniformMatrix2fvARB, GLUNIFORMMATRIX2FVARB);
      EXTMGR_FUNC_INIT(glUniformMatrix3fvARB, GLUNIFORMMATRIX3FVARB);
      EXTMGR_FUNC_INIT(glUniformMatrix4fvARB, GLUNIFORMMATRIX4FVARB);
      EXTMGR_FUNC_INIT(glGetObjectParameterfvARB, GLGETOBJECTPARAMETERFVARB);
      EXTMGR_FUNC_INIT(glGetObjectParameterivARB, GLGETOBJECTPARAMETERIVARB);
      EXTMGR_FUNC_INIT(glGetInfoLogARB, GLGETINFOLOGARB);
      EXTMGR_FUNC_INIT(glGetAttachedObjectsARB, GLGETATTACHEDOBJECTSARB);
      EXTMGR_FUNC_INIT(glGetUniformLocationARB, GLGETUNIFORMLOCATIONARB);
      EXTMGR_FUNC_INIT(glGetActiveUniformARB, GLGETACTIVEUNIFORMARB);
      EXTMGR_FUNC_INIT(glGetUniformfvARB, GLGETUNIFORMFVARB);
      EXTMGR_FUNC_INIT(glGetUniformivARB, GLGETUNIFORMIVARB);
      EXTMGR_FUNC_INIT(glGetShaderSourceARB, GLGETSHADERSOURCEARB);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_shader_objects)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_fragment_shader ()
  {
    if (tested_CS_GL_ARB_fragment_shader) return;
    tested_CS_GL_ARB_fragment_shader = true;
    const char* ext = "GL_ARB_fragment_shader";
    char cfgkey[26 + 22 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_fragment_shader = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_fragment_shader;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_fragment_shader)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  
  void InitGL_ARB_vertex_shader ()
  {
    if (tested_CS_GL_ARB_vertex_shader) return;
    tested_CS_GL_ARB_vertex_shader = true;
    const char* ext = "GL_ARB_vertex_shader";
    char cfgkey[26 + 20 + 1];
    sprintf (cfgkey, "Video.OpenGL.UseExtension.%s", ext);
    
    CS_GL_ARB_vertex_shader = (strstr (extstrGL, ext) != 0);

    bool allclear, funcTest;
    (void)funcTest; // shut up "variable unused" warnings
    bool init = CS_GL_ARB_vertex_shader;
    allclear = true;
    if (init)	// Don't check the functions if ext isn't reported anyway
    {
      EXTMGR_FUNC_INIT(glVertexAttrib1sARB, GLVERTEXATTRIB1SARB);
      EXTMGR_FUNC_INIT(glVertexAttrib1fARB, GLVERTEXATTRIB1FARB);
      EXTMGR_FUNC_INIT(glVertexAttrib1dARB, GLVERTEXATTRIB1DARB);
      EXTMGR_FUNC_INIT(glVertexAttrib2sARB, GLVERTEXATTRIB2SARB);
      EXTMGR_FUNC_INIT(glVertexAttrib2fARB, GLVERTEXATTRIB2FARB);
      EXTMGR_FUNC_INIT(glVertexAttrib2dARB, GLVERTEXATTRIB2DARB);
      EXTMGR_FUNC_INIT(glVertexAttrib3sARB, GLVERTEXATTRIB3SARB);
      EXTMGR_FUNC_INIT(glVertexAttrib3fARB, GLVERTEXATTRIB3FARB);
      EXTMGR_FUNC_INIT(glVertexAttrib3dARB, GLVERTEXATTRIB3DARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4sARB, GLVERTEXATTRIB4SARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4fARB, GLVERTEXATTRIB4FARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4dARB, GLVERTEXATTRIB4DARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4NubARB, GLVERTEXATTRIB4NUBARB);
      EXTMGR_FUNC_INIT(glVertexAttrib1svARB, GLVERTEXATTRIB1SVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib1fvARB, GLVERTEXATTRIB1FVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib1dvARB, GLVERTEXATTRIB1DVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib2svARB, GLVERTEXATTRIB2SVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib2fvARB, GLVERTEXATTRIB2FVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib2dvARB, GLVERTEXATTRIB2DVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib3svARB, GLVERTEXATTRIB3SVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib3fvARB, GLVERTEXATTRIB3FVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib3dvARB, GLVERTEXATTRIB3DVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4bvARB, GLVERTEXATTRIB4BVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4svARB, GLVERTEXATTRIB4SVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4ivARB, GLVERTEXATTRIB4IVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4ubvARB, GLVERTEXATTRIB4UBVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4usvARB, GLVERTEXATTRIB4USVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4uivARB, GLVERTEXATTRIB4UIVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4fvARB, GLVERTEXATTRIB4FVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4dvARB, GLVERTEXATTRIB4DVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4NbvARB, GLVERTEXATTRIB4NBVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4NsvARB, GLVERTEXATTRIB4NSVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4NivARB, GLVERTEXATTRIB4NIVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4NubvARB, GLVERTEXATTRIB4NUBVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4NusvARB, GLVERTEXATTRIB4NUSVARB);
      EXTMGR_FUNC_INIT(glVertexAttrib4NuivARB, GLVERTEXATTRIB4NUIVARB);
      EXTMGR_FUNC_INIT(glVertexAttribPointerARB, GLVERTEXATTRIBPOINTERARB);
      EXTMGR_FUNC_INIT(glEnableVertexAttribArrayARB, GLENABLEVERTEXATTRIBARRAYARB);
      EXTMGR_FUNC_INIT(glDisableVertexAttribArrayARB, GLDISABLEVERTEXATTRIBARRAYARB);
      EXTMGR_FUNC_INIT(glBindAttribLocationARB, GLBINDATTRIBLOCATIONARB);
      EXTMGR_FUNC_INIT(glGetActiveAttribARB, GLGETACTIVEATTRIBARB);
      EXTMGR_FUNC_INIT(glGetAttribLocationARB, GLGETATTRIBLOCATIONARB);
      EXTMGR_FUNC_INIT(glGetVertexAttribPointervARB, GLGETVERTEXATTRIBPOINTERVARB);

      EXTMGR_REPORT_INIT_RESULT("GL", GL_ARB_vertex_shader)
    }
    else
    {
      Report (msgExtNotFound, "GL", ext);
    }
  }
  

};

#undef REPORT_MISSING_ENTRIES

#undef EXTMGR_FUNC_INIT
#undef EXTMGR_REPORT_INIT_RESULT

#endif // __CS_GLEXTENSIONMANAGER_H__

