/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#include "Pkcs12Dlg.hh"
#include "Common.hh"

#ifndef __WXMSW__
#include "pics/folder_mini.xpm"
#endif

#include <iostream>

#include <wx/statline.h>

#include "../pkcs12.hh"
#include "../error.hh"
#include "../Utils.hh"

#include "PasswordDlg.hh"

using namespace Cryptonit;

BEGIN_EVENT_TABLE (Pkcs12Dlg, CryptonitDlg)
    EVT_BUTTON (P12D_OPEN_BTN_ID, Pkcs12Dlg::onFile)
END_EVENT_TABLE()


Pkcs12Dlg::Pkcs12Dlg( wxWindow *parent, wxWindowID id, 
		      const bool askForIdentity, const wxString &title,
		      const wxPoint& pos, const wxSize& size, 
		      long style, const wxString defaultFilename,
		      const wxString defaultPassword )
    : CryptonitDlg(parent, id, title, pos, size, style)
{
  
    wxStaticBox *identitySizerSB = NULL;
    wxStaticBoxSizer *identitySizer = NULL;
    wxStaticText *identityText = NULL;
    identityName = NULL;

    if( askForIdentity ) {
	/* Identity Name */
	identitySizerSB = new wxStaticBox( this, -1, _("Enter a name for this identity"));
	identitySizer = new wxStaticBoxSizer( identitySizerSB, wxVERTICAL );
	identityText = new wxStaticText(this, -1, _("This is the name that will represents your new identity: "));
	identitySizer->Add( identityText, 0, wxEXPAND | wxLEFT | wxALL, 6 );
	identityName = new wxTextCtrl( this, -1, _T(""), wxDefaultPosition, wxSize(300,20) );
	identitySizer->Add( identityName, 1, wxLEFT | wxEXPAND | wxALL, 6 );
    }

    /*** PKCS12 IMPORT BOX ***/
    wxStaticBox *pkcs12SB = new wxStaticBox( this, -1, _("Import a pkcs12"));
    wxStaticBoxSizer *pkcs12Sizer = new wxStaticBoxSizer(pkcs12SB , wxVERTICAL);
    
    wxBoxSizer *fileSizer = new wxBoxSizer(wxHORIZONTAL);
  
    pkcs12File = new wxTextCtrl(this,-1, defaultFilename,wxDefaultPosition , wxSize(300,20),wxTE_READONLY);
    wxBitmap dirIcon = wxBITMAP(folder_mini);
#ifdef __WXMSW__
    dirIcon.SetMask( new wxMask(dirIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif
    openBtn = new wxBitmapButton(this,P12D_OPEN_BTN_ID,dirIcon);
  
    fileSizer->Add(pkcs12File,1,wxCENTER |wxALL,3);
    fileSizer->Add(openBtn,0, wxCENTER |wxALL,3 );
  
    pkcs12Sizer->Add(new wxStaticText(this,-1,_("Choose a pkcs12 file to import.")),0,wxEXPAND |wxCENTER |wxALL,3);
    pkcs12Sizer->Add(fileSizer,0,wxEXPAND |wxCENTER |wxALL,3);
  
  
    /*** Imported x509 infos***/
    wxStaticBox *certSB = new wxStaticBox(this, -1 , _("Information about the certificate contained in this pkcs12"));
    wxStaticBoxSizer *certSizer = new wxStaticBoxSizer(certSB, wxVERTICAL);
    wxFlexGridSizer *infoSizer = new  wxFlexGridSizer(2);
  
    // issuer
    issuerName = new wxStaticText(this , -1 , _T(""), wxDefaultPosition, wxSize(300,20), wxEXPAND | wxALIGN_LEFT);
    infoSizer->Add(new wxStaticText(this,-1,_("issuer name: ")),0, wxEXPAND | wxALIGN_RIGHT | wxALL,3);
    infoSizer->Add(issuerName,1, wxEXPAND |wxALIGN_RIGHT |wxALL ,3);
    
    //subject
    subjectName = new wxStaticText(this , -1 , _T(""), wxDefaultPosition, wxSize(300,20), wxEXPAND | wxALIGN_LEFT);
    infoSizer->Add(new wxStaticText(this,-1,_("subject name: ")),0,  wxEXPAND | wxALIGN_RIGHT | wxALL,3);
    infoSizer->Add(subjectName,1, wxEXPAND |wxALIGN_RIGHT |wxALL ,3);
    
    //serial number
    serialNumber = new wxStaticText(this , -1 , _T(""), wxDefaultPosition, wxSize(300,20), wxEXPAND | wxALIGN_LEFT);
    infoSizer->Add(new wxStaticText(this,-1,_("serial number: ")),0,  wxEXPAND |wxALIGN_RIGHT | wxALL,3);
    infoSizer->Add(serialNumber,1,wxEXPAND | wxALIGN_RIGHT |wxALL ,3);

    certSizer->Add(infoSizer,0,wxEXPAND |wxALL | wxALIGN_RIGHT, 3);


    if( askForIdentity )
	mainSizer->Add(identitySizer,0,wxEXPAND | wxCENTER |wxALL, 3);

    mainSizer->Add(pkcs12Sizer,0,wxEXPAND | wxCENTER |wxALL,3);
    mainSizer->Add(certSizer,0,wxEXPAND | wxCENTER |wxALL,3);

    password = defaultPassword;

    if( defaultFilename != _T("") ) {
	/* If the user entered a bad password, give 
	 * him a chance to reenter it.
	 */
	int ret;
	do {
	    ret = openPKCS12( defaultFilename );
	    if( ret == -1 )
		password = _T("");
	} while( ret == -1 );
    }
}


void Pkcs12Dlg::onFile(wxCommandEvent &WXUNUSED(event))
{
    wxString wildcard;
    wildcard << _T("PKCS#12 file") << _T(" (*.p12;*.pkcs12;*.pfx)|*.p12;*.pkcs12;*.pfx");
		
    wxFileDialog fileChooser(this, _("Choose a pkcs12 file to import"),
														 wxGetCwd(), _T(""), wildcard, wxOPEN);
		
    if(fileChooser.ShowModal() == wxID_OK) {
				
				std::string filename;
				filename = appendDir( wx2std(fileChooser.GetDirectory()),
															wx2std(fileChooser.GetFilename()));
				
				/* The user entered a bad password, give hime
				 * a chance to reenter it.
				 */
				int ret;
				do {
						ret = openPKCS12( std2wx(filename) );
						if( ret == -1 ) {
								password = _T("");
						}
				} while( ret == -1 );
    }	
}

int Pkcs12Dlg::openPKCS12( wxString filename )
{
    if( password == _T("") ) {
	PasswordDlg pd(this, -1, _T("Enter your PKCS#12 password"));
	if(pd.showModal() == wxID_OK)
	    password  = pd.getPassword();
	else
	    return -2;
    }
	    
    OpenSSL_add_all_algorithms();
#ifdef DEBUG	    
    std::cerr << "Opening PKCS12: " << filename << std::endl;    
#endif    
    pkcs12 *p12 = new pkcs12();
    int error;
    
	    
    if( (error = p12->load(wx2std(filename).c_str(), wx2std(password).c_str())) == SUCCESS ) {
				pkcs12File->SetValue(filename);
				Certificate cert = p12->getCertificate();
				wxString value = std2wx(cert.getIssuerName().getValues
																(DN_DISPLAY_SHORT | DN_DISPLAY_VALUE , ','));
				issuerName->SetLabel(value);
				value = std2wx(cert.getSubjectName().getValues
											 (DN_DISPLAY_SHORT | DN_DISPLAY_VALUE , ','));
				subjectName->SetLabel(value);
	
				value = std2wx(cert.getSerialNumber());
				serialNumber->SetLabel(value);
	
				delete p12;   //checker le destructeur de pkcs12 ...
				return 0;
    } else {
				wxString msg = _("The following error occured:\n");
				msg += std2wx(getErrorMsg(error));
				
				if(error == PKCS12_PARSE_ERROR) {
						msg+= _T(" \n"); 
						msg += _("Maybe your password is invalid.\n");
				}
				wxMessageBox(msg, _T("Error"), wxOK | wxICON_ERROR, this);
#ifdef DEBUG				
				std::cout << getErrorMsg(error) << std::endl;
#endif				
				return -1;
    }
}



wxString Pkcs12Dlg::getPkcs12Filename()
{
    return pkcs12File->GetValue();
}
  


wxString Pkcs12Dlg::getPkcs12Password()
{
    return password;
}



wxString Pkcs12Dlg::getIdentity()
{
    if( identityName != NULL )
	return identityName->GetValue();
    else
	return wxEmptyString;
}
