/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */
#include <wx/wx.h>
#include <wx/wizard.h>
#include <wx/filedlg.h>
#include <wx/filename.h>
#include <wx/file.h>

#include "Pkcs12Dlg.hh"
#include "CertificateRequestWizard.hh"
#include "AddCrlDlg.hh"
#include "Common.hh"
#include "../Utils.hh"

#include "NewUserWizard.hh"

#ifndef __WXMSW__
#include "pics/wiz1.xpm"
#include "pics/add_contact.xpm"
#include "pics/language.xpm"
#include "pics/mykeys.xpm"
#include "pics/summary.xpm"
#include "pics/import.xpm"
#endif


using namespace Cryptonit;

BEGIN_EVENT_TABLE(NewUserWizard, wxWizard)
  EVT_WIZARD_CANCEL(-1, NewUserWizard::onCancel)
  END_EVENT_TABLE()

  BEGIN_EVENT_TABLE(NewUserWizard::LoginName, wxWizardPageSimple)
  EVT_WIZARD_PAGE_CHANGING(-1, NewUserWizard::LoginName::onWizardPageChanging)
  EVT_WIZARD_CANCEL(-1, NewUserWizard::LoginName::onCancel)
  END_EVENT_TABLE()

  BEGIN_EVENT_TABLE(NewUserWizard::ImportMethod, wxWizardPageSimple)
  EVT_WIZARD_PAGE_CHANGING(-1, NewUserWizard::ImportMethod::onWizardPageChanging)
  EVT_WIZARD_CANCEL(-1, NewUserWizard::ImportMethod::onCancel)
  END_EVENT_TABLE()

  BEGIN_EVENT_TABLE(NewUserWizard::Summary, wxWizardPageSimple)
  EVT_WIZARD_PAGE_CHANGING(-1, NewUserWizard::Summary::onWizardPageChanging)
  EVT_WIZARD_PAGE_CHANGED(-1, NewUserWizard::Summary::onWizardPageChanged)
  EVT_WIZARD_CANCEL(-1, NewUserWizard::Summary::onCancel)
  END_EVENT_TABLE()



/*** Login Name ***/
  NewUserWizard::LoginName::LoginName(wxWizard* parent)
    : wxWizardPageSimple( parent )
{
  myParent = (NewUserWizard*)parent;


  wxPanel *panel = new wxPanel( this );

  wxFlexGridSizer* sizer = new wxFlexGridSizer( 2, 2 );

#ifdef USER_AUTHENTICATION

  // Login
  wxBitmap userIcon = wxBITMAP(add_contact);
#ifdef __WXMSW__
  userIcon.SetMask( new wxMask(userIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif

  sizer->Add( new wxStaticBitmap(panel, -1, userIcon ),
	      1, wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL | wxALL, 6);
  sizer->Add( new wxStaticText(panel, -1, _("Enter a login name identifying the new user.")),
	      0, wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL | wxALL, 6);

  sizer->Add( new wxStaticText(panel, -1, _("Login name")),
	      0,  wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL | wxALL, 6);

  tcLoginName = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(300, 20));
  sizer->Add( tcLoginName, 1,  wxALIGN_LEFT |  wxALIGN_CENTER_VERTICAL | wxALL, 6);
    

  sizer->Add( new wxStaticText( panel , -1 , wxEmptyString ));
  sizer->Add( new wxStaticText( panel , -1 , _("This login name will be asked at program startup.")), 
	      1, wxALIGN_LEFT | wxLEFT | wxRIGHT | wxBOTTOM, 6 );

  sizer->Add( new wxStaticText( panel, -1, wxEmptyString ), 1, wxALL,  3 );
  sizer->Add( new wxStaticText( panel, -1, wxEmptyString ), 1, wxALL,  3 );    


  // Password
  wxBitmap keyIcon = wxBITMAP(mykeys);
  keyIcon.SetMask( new wxMask(keyIcon, wxColour(0xC0,0xC0,0xC0)) );


  sizer->Add( new wxStaticBitmap(panel, -1, keyIcon ),
	      1, wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL | wxALL, 6);
  sizer->Add( new wxStaticText(panel, -1, _("Enter a password for this login.")),
	      0, wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL | wxALL, 6);

  sizer->Add( new wxStaticText(panel, -1, _("Password")),
	      0, wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL | wxALL, 6);

  tcPassword = new wxTextCtrl(panel, -1, wxEmptyString, 
			      wxDefaultPosition, wxSize(300, 20), wxTE_PASSWORD);
  sizer->Add( tcPassword, 1, wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL | wxALL, 6);


  sizer->Add( new wxStaticText( panel, -1, wxEmptyString ));
  sizer->Add( new wxStaticText( panel, -1, _("This password will protect your Cryptonit account.")), 
	      1, wxALIGN_LEFT | wxLEFT | wxRIGHT | wxBOTTOM, 6 );

  sizer->Add( new wxStaticText( panel, -1, wxEmptyString ), 1, wxALL, 3  );    
  sizer->Add( new wxStaticText( panel, -1, wxEmptyString ), 1, wxALL, 3  );

#endif

#ifndef USER_AUTHENTICATION
  tcLoginName = new wxTextCtrl(panel, -1, wxEmptyString, wxDefaultPosition, wxSize(0, 0));
  tcPassword = new wxTextCtrl(panel, -1, wxEmptyString, 
			      wxDefaultPosition, wxSize(0, 0), wxTE_PASSWORD);
  tcLoginName->SetValue(std2wx(USER_NAME));
  tcPassword->SetValue(std2wx(USER_PASSWD));
#endif
    
  //Language
  wxBitmap languageIcon = wxBITMAP(language);
  languageIcon.SetMask( new wxMask(languageIcon, wxColour(0xC0,0xC0,0xC0)) );

  sizer->Add( new wxStaticBitmap(panel, -1, languageIcon ),
	      1, wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL | wxALL, 6);
  sizer->Add( new wxStaticText(panel, -1, _("Choose your favorite language for this account.")),
	      0, wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL | wxALL, 6);

  sizer->Add( new wxStaticText(panel, -1, _("Language")),
	      0,  wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL | wxALL, 6);

  cbLanguage = new wxComboBox(panel, -1, _T(""), wxDefaultPosition, wxSize(300, 20),
			      CryptonitGui::nbLangs, CryptonitGui::langs,
			      wxCB_READONLY | wxCB_SORT);
  cbLanguage->SetSelection(0);
  sizer->Add( cbLanguage, 1, wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL | wxALL, 6);

  sizer->Add( new wxStaticText( panel, -1, wxEmptyString ));
  sizer->Add( new wxStaticText( panel, -1, _("You can change it later in the configuration panel.")), 
	      1,wxALIGN_LEFT | wxLEFT | wxRIGHT | wxBOTTOM, 6 );


  panel->SetSizer( sizer );
  sizer->Fit( panel );    
}



void NewUserWizard::LoginName::onWizardPageChanging(wxWizardEvent& event)
{
  if( tcLoginName->GetValue() == wxEmptyString || tcPassword->GetValue() == wxEmptyString ) {
    wxString msg = wxEmptyString;
    if( tcLoginName->GetValue() == wxEmptyString ){
      msg = _("You must provide a valid login name");
    }

    if( tcPassword->GetValue() == wxEmptyString ){
      if( msg != wxEmptyString ){
	msg+= _(" and a valid password");
		
      } else {
	msg = _("You must provide a valid password");
		
      }
    }
    msg+=_T(".");
    wxMessageBox( msg, _("Error"), wxICON_ERROR | wxOK, this );
    event.Veto();
  } 
  else if( tcLoginName->GetValue() != wxEmptyString
	   && tcPassword->GetValue() != wxEmptyString 
	   && User::isUserValid(wx2std(tcLoginName->GetValue())) ) {
    wxMessageBox( _("This user already exists."), _("Error"), wxICON_ERROR | wxOK, this );
    event.Veto();
  }
}


void NewUserWizard::LoginName::onCancel(wxWizardEvent& WXUNUSED(event))
{
#ifndef USER_AUTHENTICATION
  exit(0);
#endif
}

/*** ImportMethod ***/
NewUserWizard::ImportMethod::ImportMethod(wxWizard* parent, LoginName *ln)
  : wxWizardPageSimple( parent )
{

  p12 = NULL;
  myParent = (NewUserWizard*)parent;
  loginPage = ln;
  wxPanel *panel = new wxPanel( this );

  wxBoxSizer *pageSizer = new wxBoxSizer( wxVERTICAL );

  wxBitmap userIcon = wxBITMAP(add_contact);
#ifdef __WXMSW__
  userIcon.SetMask( new wxMask(userIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif

  wxBoxSizer *title = new wxBoxSizer( wxHORIZONTAL );
  title->Add( new wxStaticBitmap(panel, -1, userIcon ),
	      1, wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL | wxALL, 6);
  title->Add( new wxStaticText(panel, -1, _("Choose an import method for your certificate private key pair.")),
	      0, wxALIGN_LEFT | wxALL, 6);

  pageSizer->Add( title );


  /* Combo */
    
  blankAccount = new wxRadioButton(panel, -1, _("Blank account"),wxDefaultPosition,wxDefaultSize, wxRB_GROUP );
  rbPkcs12 = new wxRadioButton(panel, NUW_PKCS12_RADIO_ID, _("Import from a PKCS#12 file"),wxDefaultPosition,wxDefaultSize );
  rbCertificateRequest = new wxRadioButton(panel, NUW_CERTIFICATE_REQUEST_RADIO_ID, _("Create a certificate request") );
    
  blankAccount->SetValue(true);
  rbPkcs12->SetValue(false);
  rbCertificateRequest->SetValue(false);

  wxBoxSizer *radios = new wxBoxSizer( wxVERTICAL );

  radios->Add( blankAccount, 1, wxALL, 6);
  radios->Add( rbPkcs12, 1, wxALL, 6);
  radios->Add( rbCertificateRequest, 1, wxALL, 6);

  pageSizer->Add( radios );


  panel->SetSizer( pageSizer );
  pageSizer->Fit( panel );    
}


void NewUserWizard::ImportMethod::onWizardPageChanging(wxWizardEvent& event)
{

  if ( event.GetDirection() ) {
	
    User *user = new User();    

    // Import from a PKCS#12 file
    if( rbPkcs12->GetValue() == true ) {
	  
      Pkcs12Dlg p12dlg(this, -1 , true, _("Add a new identity to Cryptonit"));
	
      if( p12dlg.showModal() == wxID_OK ) {
	// Create preliminary user files and directories
	if ( !NewUserWizard::createUserFiles(loginPage->tcLoginName->GetValue(),
					     loginPage->tcPassword->GetValue(),
					     loginPage->cbLanguage->GetValue()) ) {
	  event.Veto();
	  return ;
	}
		
	
		
	method = PKCS12;
	filename = new std::string(wx2std(p12dlg.getPkcs12Filename()));
		
	int res;
	wxString errorMsg = wxEmptyString;
		
	wxString IDName = p12dlg.getIdentity();
	if( IDName == wxEmptyString )
	  IDName = _("Default");
	    
	identity =  new std::string(wx2std(IDName).c_str());
	// Reload the User with the updated values
	user = new User( wx2std(loginPage->tcLoginName->GetValue()) );
	    
	// Add identity to th user from the PKCS 12
	res = user->addIdentityFromP12( *identity, 
					wx2std(p12dlg.getPkcs12Filename()),
					wx2std(p12dlg.getPkcs12Password()) );
	    
	//delete user;

	switch( res ) {
	case 0:  errorMsg = wxEmptyString;
	  break;
	case -1: errorMsg = _("Cannot load PKCS#12.");
	  break;
	case -2: errorMsg = _("This PKCS#12 file already exist for this user.");
	  break;
	case -3: errorMsg = _("This identity is already in the list, please use a different name.");
	  break;
	case -4: errorMsg = _("An error occured while writing certificate on disk.");
	  break;
	case -5: errorMsg = _("Cannot add identity information into the addressbook.");
	  break;
	case -6: errorMsg = _("Cannot write on disk a CA certificate included in the PKCS#12.");
	  break;
	case -7: errorMsg = _("Cannot copy PKCS#12 in your user directory.");
	  break;
	default: errorMsg = _("Unknown error!");
	  break;
	}

	if( errorMsg != wxEmptyString ) {
	  wxMessageBox(errorMsg, _("Error"), wxOK | wxICON_ERROR, this);
	  event.Veto();
	  return;
	}
	    

	pkcs12 p12;
	Certificate cert;
	p12.load( wx2std(p12dlg.getPkcs12Filename()).c_str(),
		  wx2std(p12dlg.getPkcs12Password()).c_str() );
	cert = p12.getCertificate();
	//downloading CRL for this p12 certificate and CA
	//CA
	std::vector<Certificate> CA;
	std::vector<Certificate>::iterator it;
	CA = p12.getCA();
	for( it = CA.begin(); it != CA.end(); it++ ) {
	  std::string uri = it->extractCrlUri();
	  if( uri != "" ){
	    wxString newCrlFile = AddCrlDlg::fetchCrl( std2wx(uri) );
	    Crl newCrl;
	    if( newCrl.load( wx2std(newCrlFile).c_str()) == SUCCESS ){
	      Certificate newCert( *it );
	      AddCrlDlg::saveCrl( std2wx(uri) , &newCrl , newCert , user ); 
	    } 
	  }
	}
	//certificate
	std::string uri = cert.extractCrlUri();
	if( uri != "") {
	  wxString newCrlFile = AddCrlDlg::fetchCrl( std2wx(uri) );
	  Crl newCrl;
	  if( newCrl.load( wx2std(newCrlFile).c_str()) == SUCCESS ){
	    AddCrlDlg::saveCrl( std2wx(uri) , &newCrl , cert , user ); 
	  } 
	}


      }
      else {
	event.Veto();
	return;
      }
    }
    // Certificate request
    else if( rbCertificateRequest->GetValue() == true ) {
      method = REQUEST;
      if ( ! NewUserWizard::createUserFiles(loginPage->tcLoginName->GetValue(),
					    loginPage->tcPassword->GetValue(),
					    loginPage->cbLanguage->GetValue()) ) {
	event.Veto();
	return ;
      }
      // Reload the User with the updated values
      user = new User( wx2std(loginPage->tcLoginName->GetValue()) );

      // Launch the CertificateRequestWizard
      CertificateRequestWizard* wizi = new CertificateRequestWizard( user , this );
      if( !wizi->getSuccess() ){
	delete wizi;
	event.Veto();
	return ;
      }
      delete wizi;
    }
    // Blank account
    else if ( blankAccount->GetValue() == true ){
      method = BLANK;
      if ( ! NewUserWizard::createUserFiles(loginPage->tcLoginName->GetValue(),
					    loginPage->tcPassword->GetValue(),
					    loginPage->cbLanguage->GetValue()) ) {
	event.Veto();
	return ;
      }
      // Reload the User with the updated values
      user = new User( wx2std(loginPage->tcLoginName->GetValue()) );
    }


    // Backup all user's files
    if( user->addressBook != NULL ) {
      if( ! (user->addressBook->save()) ){
	wxString msg = _("An error occured while saving address book");
	wxMessageBox(msg, _("Error"), wxOK | wxICON_ERROR, this);
      }
    }

    if( user->authorities != NULL ) {
      if( ! (user->authorities->save()) ){
	wxString msg = _("An error occured while saving the authorities data base");
	wxMessageBox(msg, _("Error"), wxOK | wxICON_ERROR, this);
      }
    }
	
    if( ! (user->saveToFile()) ){
      wxString msg = _("An error occured while saving user's preferences");
      wxMessageBox(msg, _("Error"), wxOK | wxICON_ERROR, this);
    }

    delete user;
  }
#ifdef DEBUG  
  else std::cerr << "Back" << std::endl;
#endif  
}

void NewUserWizard::ImportMethod::onCancel(wxWizardEvent& WXUNUSED(event))
{ 
#ifdef USER_AUTHENTICATION
  User user = User( wx2std(loginPage->tcLoginName->GetValue()) );
#else
  User user = User( USER_NAME );
#endif
  user.remove();
#ifndef USER_AUTHENTICATION
  exit(0);
#endif
}


/*** Summary ***/
NewUserWizard::Summary::Summary( wxWizard* parent , LoginName *ln ,ImportMethod *im)
  : wxWizardPageSimple( parent )
{
  myParent = (NewUserWizard*)parent;
  loginPage = ln ;
  imPage = im;
}

void NewUserWizard::Summary::onWizardPageChanging(wxWizardEvent& event){
  if ( event.GetDirection() == false ) { //we go backward
    User user = User( wx2std(loginPage->tcLoginName->GetValue()) );
    user.remove();
  }
}

void NewUserWizard::Summary::onWizardPageChanged(wxWizardEvent& event)
{
  wxPanel *panel = new wxPanel( this );

  wxFlexGridSizer *sizer = new wxFlexGridSizer(2);

  wxBitmap summaryIcon = wxBITMAP(summary);
#ifdef __WXMSW__
  summaryIcon.SetMask( new wxMask(summaryIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif

  sizer->Add( new wxStaticBitmap(panel, -1, summaryIcon ),
	      1, wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL | wxALL, 6);
  sizer->Add( new wxStaticText(panel, -1, _("Summary:\nPlease check that informations displayed below are correct.")),
	      1, wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL | wxALL, 6);

  sizer->Add( new wxStaticText( panel , -1 , wxEmptyString ) , 1 , wxALL , 3);
  sizer->Add( new wxStaticText( panel , -1 , wxEmptyString ) , 1 , wxALL , 3);

#ifdef USER_AUTHENTICATION
  //login
  wxBitmap userIcon = wxBITMAP(add_contact);
#ifdef __WXMSW__
  userIcon.SetMask( new wxMask(userIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif

  sizer->Add( new wxStaticBitmap(panel, -1, userIcon ),
	      1, wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL | wxALL, 6);
    
  sizer->Add( new wxStaticText( panel , -1 ,  _("Login name: ") + loginPage->tcLoginName->GetValue() ), 
	      0, wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL | wxALL, 6);
    
#endif

  //importation method
  //login
  wxBitmap importIcon = wxBITMAP(import);
#ifdef __WXMSW__
  importIcon.SetMask( new wxMask(importIcon, wxColour(0xC0,0xC0,0xC0)) );
#endif

  sizer->Add( new wxStaticBitmap(panel, -1, importIcon ),
	      1, wxALIGN_CENTER_HORIZONTAL | wxALIGN_CENTER_VERTICAL | wxALL, 6);
    

  if( imPage->method == ImportMethod::PKCS12 ){
    sizer->Add( new wxStaticText( panel , -1 ,  _("Create account from PKCS #12 file:")), 
		0, wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL | wxALL, 6);

    if( imPage->filename  ){
      sizer->Add( new wxStaticText( panel , -1 , wxEmptyString ) ,
		  0 , wxBOTTOM | wxLEFT | wxRIGHT , 6);
      sizer->Add( new wxStaticText( panel , -1 , std2wx( *(imPage->filename)) ) ,
		  0 , wxBOTTOM | wxLEFT | wxRIGHT , 6);
    }
	
    if( imPage->identity  ){
      sizer->Add( new wxStaticText( panel , -1 , wxEmptyString ) ,
		  0 , wxBOTTOM | wxLEFT | wxRIGHT , 6);
      sizer->Add( new wxStaticText( panel , -1 ,  _("Identity name: ") 
				    + std2wx( *(imPage->identity) ) ) ,
		  0 , wxBOTTOM | wxLEFT | wxRIGHT , 6);
    }
	
  } else if( imPage->method == ImportMethod::REQUEST ) {
    sizer->Add( new wxStaticText( panel , -1 ,  _("Create account with a certificate request: ")), 
		0, wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL | wxALL, 6);
	
    sizer->Add( new wxStaticText( panel , -1 , wxEmptyString ) ,
		0 , wxBOTTOM | wxLEFT | wxRIGHT , 6);
    sizer->Add( new wxStaticText( panel , -1 , _("You need to send this request to the registration authority" )) ,
		0 , wxBOTTOM | wxLEFT | wxRIGHT , 6);
	
  } else if( imPage->method == ImportMethod::BLANK ) {
    sizer->Add( new wxStaticText( panel , -1 ,  _("Create a blank account: ")), 
		0, wxALIGN_LEFT | wxALIGN_CENTER_VERTICAL | wxALL, 6);
	
    sizer->Add( new wxStaticText( panel , -1 , wxEmptyString ) ,
		0 , wxBOTTOM | wxLEFT | wxRIGHT , 6);
    sizer->Add( new wxStaticText( panel , -1 , _("You can only make self-decrypting and check signatures, \nyou may add an identity later in the configuration panel." )) ,
		0 , wxBOTTOM | wxLEFT | wxRIGHT , 6);
  }

  panel->SetSizer( sizer );
  sizer->Fit( panel );    
}


void NewUserWizard::Summary::onCancel(wxWizardEvent& WXUNUSED(event))
{ 
#ifdef USER_AUTHENTICATION
  User user = User( loginPage->tcLoginName->GetValue().c_str() );
#else
  User user = User( USER_NAME );
#endif
  user.remove();
#ifndef USER_AUTHENTICATION
  exit(0);
#endif
}




NewUserWizard::NewUserWizard( wxWindow* parent )
{
  wizard = new wxWizard( parent, -1, _("New user wizard"), wxBITMAP(wiz1) );
  loginName = new LoginName( wizard );
  importMethod = new ImportMethod( wizard , loginName);
  summary = new Summary( wizard , loginName , importMethod);
  
  wxWizardPageSimple::Chain( loginName, importMethod );
  wxWizardPageSimple::Chain( importMethod, summary );
  wizard->FitToPage( loginName );
  wizard->RunWizard( loginName );
}

NewUserWizard::~NewUserWizard()
{
  wizard->Destroy();
}

void NewUserWizard::onCancel(wxWizardEvent& WXUNUSED(event))
{
#ifndef USER_AUTHENTICATION
  exit(0);
#endif
}

wxString NewUserWizard::getNewUserLogin()
{
  return loginName->tcLoginName->GetValue();
}

bool NewUserWizard::createUserFiles(wxString login , wxString password, wxString lang)
{
  User *user = new User();
#ifdef DEBUG
  std::cerr << "createUserFile => login = " << wx2std(login) << " + password = " << wx2std(password) << std::endl;
#endif  
  

  user->create( wx2std(login) );
#if 0
  if( user->create( wx2std(login) ) == false ) {
    wxMessageBox( _("Cannot create initials files for this new user."),
		  _("Error"), wxOK | wxICON_ERROR, NULL);
    return false;
  }
#endif

  user->setLogin( wx2std(login) );
    
  // Encrypt and store password into the User structure
  char *c;
  c = encryptPassword( wx2std(password).c_str(), "1", generateSalt() );

  Entry *pass = new Entry();
  pass->append("Password", new Attribute(c, strlen(c), AttributeString));
  user->setUserInfo(pass);

  // Store the choosen language 
  user->setInfo( "Language", wx2std(lang) );

  // Add default values for the addressbook
  std::vector<std::string> fields;
  fields.push_back("cn");
  fields.push_back("mail");
  fields.push_back("sn");
  user->setInfos( "AddressBookFields", fields );
    
  // Use the same fields for the LDAP import frame
  user->setInfos( "LdapFields", fields );

  // Save on disk the user preferences file
  std::string prefs = appendDir( getCryptonitHome(), 
				 wx2std(login) );
  prefs = appendDir( prefs, PREFERENCES_FILENAME );
    
  if( user->saveToFile(prefs) == false ) {
    wxMessageBox( _("Cannot create initials files for this new user."),
		  _("Error"), wxOK | wxICON_ERROR, NULL);
    return false;
  }

  return true;
}
