/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#include "error.hh"

namespace Cryptonit{
  
  std::string &getErrorMsg(int errorCode){
    std::string *s;
    switch(errorCode){
      
    case SUCCESS:
	s = new std::string("");
      break;

      /* CERTIFICATE RELATED ERRORS */
    case CERTIFICATE_FILE_NOT_FOUND:
      s = new std::string("Certificate File not found");
      break;
      
      
    case CERTIFICATE_PEM_LOAD_ERROR:
      s = new std::string("Error while loading pem format Certificate");
      break;
      
    case CERTIFICATE_DER_LOAD_ERROR:
      s = new std::string("Error while loading der format Certificate");
      break;

    case  CERTIFICATE_PKCS12_LOAD_ERROR :
      s = new std::string("Error while loading pkcs12 format Certificate");
      break;

    case CERTIFICATE_LOAD_ERROR:
      s = new std::string("Error while loading Certificate");
      break;

      /* PKCS7 RELATED ERRORS */
    case PKCS7_CREATE_ERROR :
      s = new std::string("PKCS7 : Error while creating pkcs7 object");
      break;
    
    case PKCS7_FILE_CREATE_ERROR:
      s = new std::string("PKCS7 : Error while creating file");
      break;

    case  PKCS7_FILE_NOT_FOUND:
      s = new std::string("PKCS7 : File not found");
      break;

    case PKCS7_BIO_NEW_ERROR:
      s = new std::string("PKCS7 : Unable to create BIO.");
      break;
      
    case PKCS7_BAD_CONTENT_TYPE:
      s = new std::string("PKCS7 : Bad content type.");
      break;
      
    case PKCS7_BAD_FORMAT:
      s = new std::string("PKCS7 : Bad file format");
      break;

    case PKCS7_READ_ERROR:
      s = new std::string("PKCS7 : Can't read file.");
      break;

    case PKCS7_SIGN_ERROR:
      s = new std::string("PKCS7 : Error while signing.");
      break;

    case PKCS7_SET_CIPHER_ERROR:
      s = new std::string("PKCS7 : Can't set cipher.");
      break;

    case PKCS7_ADD_RECIPIENT_ERROR:
      s = new std::string("PKCS7 : Error while adding recipient.");
      break;

    case PKCS7_ADD_SIGN_ERROR:
      s = new std::string("PKCS7 : Can't add signature info");
      break;

    case PKCS7_DATAINIT_ERROR:
      s = new std::string("PKCS7 : error initiating bio (PKCS7_dataInit).");
      break;

    case PKCS7_DATAFINAL_ERROR:
      s = new std::string("PKCS7 : error in PKCS7_dataFinal");
      break;

    case PKCS7_EXTRACT_ERROR:
      s = new std::string("PKCS7 : error extracting file from signed pkcs7.");
      break;

    case PKCS7_DECRYPT_ERROR:
      s = new std::string("PKCS7 : error decrypting file.");
      break;

    case PKCS7_ENCRYPT_ERROR:
      s = new std::string("PKCS7 : error encrypting file");
      break;

    case  PKCS7_CERT_OR_KEY_NULL:
      s = new std::string("PKCS7 : Certificate or Private Key are null.");
      break;


      /** PKCS12 related errors**/
    case    PKCS12_FILE_NOT_FOUND:
      s = new std::string("PKCS12 : File not found.");
      break;
      
    case  PKCS12_LOAD_ERROR:
      s = new std::string("PKCS12 : Load Error.");
      break;
      
      
    case PKCS12_PARSE_ERROR:
      s = new std::string("PKCS12 : Parse error.");
      break;
      
    
    case PKCS12_BIO_READ_ERROR:
      s = new std::string("PKCS12 : Bio read error.");
      break;
      
    case PKCS12_LOAD_BIO_ERROR:
       s = new std::string("PKCS12 : Bio load error.");
      break;


      
    default: 
       s = new std::string("Unknown error!");
      break;
    }
    
    return *s;
  }
}
