/*
 * The Cryptonit security software suite is developped by IDEALX
 * Cryptonit Team (http://IDEALX.org/ and http://cryptonit.org).
 *
 * Copyright 2003-2006 IDEALX
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License version
 * 2 as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA. 
 *
 * In addition, as two special exceptions:
 *
 * 1) IDEALX S.A.S gives permission to:
 *  * link the code of portions of his program with the OpenSSL library under
 *    certain conditions described in each source file
 *  * distribute linked combinations including the two, with respect to the
 *    OpenSSL license and with the GPL
 *
 * You must obey the GNU General Public License in all respects for all of the
 * code used other than OpenSSL. If you modify file(s) with this exception,
 * you may extend this exception to your version of the file(s), but you are
 * not obligated to do so. If you do not wish to do so, delete this exception
 * statement from your version, in all files (this very one along with all
 * source files).

 * 2) IDEALX S.A.S acknowledges that portions of his sourcecode uses (by the
 * way of headers inclusion) some work published by 'RSA Security Inc.'. Those
 * portions are "derived from the RSA Security Inc. PKCS #11Cryptographic
 * Token Interface (Cryptoki)" as described in each individual source file.
 */

#ifndef _ContactInfo_hh_
#define _ContactInfo_hh_

#include "config.h"
#if defined(HAVE_EXT_HASH_MAP)
#include <ext/hash_map>
using namespace __gnu_cxx;
#else
#if defined(HAVE_HASH_MAP)
#include <hash_map>
#else
#error Cannot find hash_map header !
#endif
#endif

#include "Entry.hh"
#include "Attribute.hh"

namespace Cryptonit
{
   /** Defines the Contact Informations.
    *
    */
    class ContactInfo 
    {

    private:
	
	Entry* info;

    public:


	/** Attribute list recognized by the ContactInfo object.
	 *  See ContactInfo.cpp for its initialization.
	 */
	static const char* AttributeList[][3];
	static const unsigned int AttributeListLength = 81;

	/** Creates a new empty ContactInfo object.
	 */
	ContactInfo();


	/** Copy constructor
	 *
	 *  @param src : source object
	 */
	ContactInfo( const ContactInfo& src );


	/** Creates a new ContactInfo instance, from a
	 *  Entry object. All attributes are
	 *  copied only if they are in the 'AttributeList'.
	 *
	 *  @param dsEntry : Entry source object
	 */
	ContactInfo( Entry& dsEntry );

	
	/** Destruct a ContactInfo object.
	 */
	~ContactInfo();


	/** Adds information of 'name' with value 'value'. Only informations
	 *  from the 'AttributeList' could be added.
	 *  If information 'name' already exists, the 'value' is appended.
	 *
	 *  @param name : information name
	 *  @param value : information value
	 */
	bool addValue( const std::string name, const std::string& value );	
// 	bool addInfo( std::string name, std::string& value, TYPE );


	/** Adds informations of 'name' with a vector of values 'values'.
	 *  Only informations from the 'AttributeList' could be added.
	 *  If information 'name' already exists, the orignale set of values
	 *  is replaced with 'values'.
	 *
	 *  @param name : information name
	 *  @param values : vector of information values
	 */
	bool addValues( const std::string name, const std::vector<std::string>& values );	
// 	bool addInfos( std::string name, std::vector<std::string>& values, TYPE );

	
	/** Adds informations values from a Attribute pointer to a
	 *  info.
	 *
	 *  @param name : information name
	 *  @param attribute : Attribute pointer containing the values
	 */
	bool addValues( const std::string name, Attribute* attribute );


	std::vector<std::string> getValues( std::string name );

	std::string getFirstValue( std::string name );
	std::string getLastValue( std::string name );
	

	/** Tells is 'infoName' is supported by the ContactInfo class.
	 *  @return true if 'infoName' is supported.
	 *  @param infoName : information name, eg: "givenName"
	 */
	static bool isInfoSupported( const std::string infoName );

    };



}
#endif
