/*
 *  declarations for filesytem-related utilities for cryptmount
 *  $Revision: 222 $, $Date: 2008-10-03 12:31:16 +0100 (Fri, 03 Oct 2008) $
 *  (C)Copyright 2005-2008, RW Penney
 */

/*
    This file is part of cryptmount

    cryptmount is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    cryptmount is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */


#ifndef _FSUTILS_H
#define _FSUTILS_H

struct cment;

int parse_fsoptions(const char *buff, unsigned long *mflags);
int fs_check(const char *dev, const struct cment *ent);
int fs_mount(const char *dev, const struct cment *ent);
int fs_unmount(const struct cment *ent);
int fs_swapon(const char *dev, const struct cment *ent);
int fs_swapoff(const struct cment *ent);
int is_mounted(const struct cment *ent);
int is_readonlyfs(const char *path);

#endif  /* _FSUTILS_H */

/*
 *  fsutils.h
 *  (C)Copyright 2005-2008, RW Penney
 */
