/*
 *  declarations for miscellaneous utilities for cryptmount
 *  $Revision: 134 $, $Date: 2007-02-19 17:18:07 +0000 (Mon, 19 Feb 2007) $
 *  Copyright 2005-2007, RW Penney
 */

/*
    This file is part of cryptmount

    cryptmount is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exemption, permission is granted to link cryptmount
    with the OpenSSL project's "OpenSSL" library and distribute
    the linked code without invoking clause 2(b) of the GNU GPL version 2.

    cryptmount is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with cryptmount; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef _UTILS_H
#define _UTILS_H

#include <inttypes.h>

int cm_path(char **buff, const char *file);
char *cm_strdup(const char *orig);

void *sec_realloc(void *ptr, size_t size);
void mem_cleanse(unsigned char *addr, size_t sz);
void sec_free(void *ptr);

int get_randkey(unsigned char *key, size_t len);
int km_get_passwd(const char *ident, char **passwd, int isnew, int verify);
unsigned km_aug_keysz(unsigned keylen, unsigned blksz);
unsigned char *km_aug_key(const unsigned char *key, unsigned keylen,
                    unsigned blocksz, size_t *buffsz);
int km_aug_verify(const unsigned char *buff, unsigned keylen,
                uint32_t *expected, uint32_t *actual);

enum { CM_SHA1_SIZE = 20 };
typedef struct cm_sha1_ctxt {
    uint32_t msglen;
    uint32_t buffpos;
    uint32_t H[5];
    uint32_t buff[16];
} cm_sha1_ctxt_t;

cm_sha1_ctxt_t *cm_sha1_init(void);
void cm_sha1_block(cm_sha1_ctxt_t *ctxt, const unsigned char *buff, size_t len);
void cm_sha1_final(cm_sha1_ctxt_t *ctxt, unsigned char **mdval, size_t *mdlen);
void cm_sha1_free(cm_sha1_ctxt_t *ctxt);

#endif  /* _UTILS_H */

/*
 *  utils.h
 *  (C)Copyright 2005-2007, RW Penney
 */
