#
# rpm spec-file for cryptmount
# $Revision: 158 $, $Date: 2007-04-10 07:27:01 +0100 (Tue, 10 Apr 2007) $
# Copyright 2006, Holger Mueller & RW Penney
#
Summary:	Let ordinary users mount an encrypted file system
Name:		cryptmount
Version: 	2.0
Release:	1
License:	GPL
URL:		http://cryptmount.sourceforge.net
Group:		Applications/System
Source0:	%{name}-%{version}.tar.gz
BuildRequires:  openssl-devel 
Requires:	openssl device-mapper
BuildRoot:	%{_tmppath}/%{name}-%{version}-root

%description
cryptmount is a utility for the GNU/Linux operating system which allows
an ordinary user to mount an encrypted filing system without requiring
superuser privileges. Filesystems can reside on raw disk partitions or
ordinary files, with cryptmount automatically configuring 
device-mapper and loopback devices before mounting.


%prep
%setup -n %{name}-%{version}
for mkfile in Makefile.am Makefile.in Makefile; do
  if test -f ${mkfile}; then ed -s ${mkfile} - <<EOF
/^install-exec-hook:/
/^	chown root.root/d
/^install-modules:/
/^		chown root.root/d
w
q
EOF
  fi; done


%build
%configure --enable-delegation --enable-fsck
make


%install
rm -rf %{buildroot}
mkdir -p %{buildroot}/etc/init.d %{buildroot}/etc/default
make DESTDIR=%{buildroot} install
## directory structure for rc?.d scripts doesn't seem to be standardized:
#ln -s /etc/init.d/cryptmount %{buildroot}/etc/rc0.d/K10cryptmount
#ln -s /etc/init.d/cryptmount %{buildroot}/etc/rc3.d/S10cryptmount
#ln -s /etc/init.d/cryptmount %{buildroot}/etc/rc6.d/K10cryptmount


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(644,root,root)
%doc AUTHORS ChangeLog COPYING NEWS README RELNOTES ToDo
%attr(4751,root,root) %{_bindir}/%{name}
%dir %{_sysconfdir}/cryptmount
%attr(751,root,root) %{_sysconfdir}/cryptmount
%config %{_sysconfdir}/cryptmount/*
%dir %{_libdir}/cryptmount
%attr(751,root,root) %{_libdir}/cryptmount
%{_libdir}/cryptmount/*
/etc/init.d/*
%attr(0754,root,root) /etc/init.d/cryptmount
/etc/default/*
%config /etc/default/cryptmount
%{_mandir}/man5/*
%{_mandir}/man8/*
%{_mandir}/*/man5/*
%{_mandir}/*/man8/*
%{_datadir}/locale/*/LC_MESSAGES/*


%changelog
* Sat Apr 07 2007 RW Penney <cryptmount@rwpenney.org.uk> - 2.0
* Sun Oct 15 2006 RW Penney <cryptmount@rwpenney.org.uk> - 1.2
* Sun Jul 16 2006 RW Penney <cryptmount@rwpenney.org.uk> - 1.1
* Mon May 29 2006 RW Penney <cryptmount@rwpenney.org.uk> - 1.0
* Sat Apr 07 2006 RW Penney <cryptmount@rwpenney.org.uk> - 0.4
* Sun Mar 05 2006 RW Penney <cryptmount@rwpenney.org.uk> - 0.3
* Sun Jan 22 2006 RW Penney <cryptmount@rwpenney.org.uk> - 0.2
* Sun Jan 22 2006 Holger Mueller <holger@MAPS.euhm.de> - 0.1-1mr
- RPM spec created
