/*
 *  declarations for unit-test utilities for cryptmoumt
 *  $Revision: 158 $, $Date: 2007-04-10 07:27:01 +0100 (Tue, 10 Apr 2007) $
 *  Copyright 2006-2007, RW Penney
 */

/*
    This file is part of cryptmount

    cryptmount is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    As a special exemption, permission is granted to link cryptmount
    with the OpenSSL project's "OpenSSL" library and distribute
    the linked code without invoking clause 2(b) of the GNU GPL version 2.

    cryptmount is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with cryptmount; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef _CMTEST_H
#define _CMTEST_H

#include <config.h>


enum {
    CM_TEST_PASSED = 0,
    CM_TEST_FAILED,
    CM_TEST_ABORTED,
    CM_TEST_LAST
};


typedef struct cm_testinfo {
    const char *current;                /* name of current test */
    int tests_run;                      /* total number of tests initiated */
    int test_stats[CM_TEST_LAST];       /* statistics of test outcomes */

    const char *argconfigdir;           /* adjustable config-directory */
    const char *argpassword[2];         /* adjustable password arguments */
} cm_testinfo_t;
extern cm_testinfo_t *test_ctxtptr;


#define CM_TEST_START(name) \
    { \
        fprintf(stderr, "starting test \"%s\"...", name); \
        ++test_ctxtptr->tests_run; \
        test_ctxtptr->current = NULL; \
    }

#define CM_TEST_IDENT(ident) \
    { \
        test_ctxtptr->current = (const char*)ident; \
    }

#define CM_ASSERT_EQUAL(expected, actual) \
    if ((expected) != (actual)) { \
        fprintf(stderr, "  test failed %s:%d\n", __FILE__, __LINE__); \
        if (test_ctxtptr->current != NULL) { \
            fprintf(stderr, "    [%s]\n", test_ctxtptr->current); } \
        ++test_ctxtptr->test_stats[CM_TEST_FAILED]; \
        return CM_TEST_FAILED; \
    }

#define CM_ASSERT_DIFFERENT(expected, actual) \
    if ((expected) == (actual)) { \
        fprintf(stderr, "  test failed %s:%d\n", __FILE__, __LINE__); \
        if (test_ctxtptr->current != NULL) { \
            fprintf(stderr, "    [%s]\n", test_ctxtptr->current); } \
        ++test_ctxtptr->test_stats[CM_TEST_FAILED]; \
        return CM_TEST_FAILED; \
    }

#define CM_TEST_OK(TI) \
    { \
        fprintf(stderr, " ok\n"); \
        ++test_ctxtptr->test_stats[CM_TEST_PASSED]; \
        return CM_TEST_PASSED; \
    }

#define CM_TEST_FAIL(TI) \
    { \
        fprintf(stderr, " FAILED\n"); \
        if (test_ctxtptr->current != NULL) { \
            fprintf(stderr, "    [%s]\n", test_ctxtptr->current); } \
        ++test_ctxtptr->test_stats[CM_TEST_FAILED]; \
        return CM_TEST_FAILED; \
    }

#define CM_TEST_ABORT(TI) \
    { \
        fprintf(stderr, " ABORTED\n"); \
        if (test_ctxtptr->current != NULL) { \
            fprintf(stderr, "    [%s]\n", test_ctxtptr->current); } \
        ++test_ctxtptr->test_stats[CM_TEST_ABORTED]; \
        return CM_TEST_ABORTED; \
    }


int cm_run_tests();


#endif  /* _CMTEST_H */

/*
 *  (C)Copyright 2006-2007, RW Penney
 */
