/* account.c */
extern void hide_all_login_windows(void);
extern gboolean on_window_delete_event(GtkWidget *window, gpointer *user_data);
extern void create_new_character_failure(char *message);
extern void on_button_create_new_char_clicked(GtkButton *button, gpointer user_data);
extern void on_entry_new_character_name(GtkEntry *entry, gpointer user_data);
extern void on_button_new_char_cancel_clicked(GtkButton *button, gpointer user_data);
extern void account_add_character_failure(char *message);
extern void on_button_do_add_character_clicked(GtkButton *button, gpointer user_data);
extern void on_button_return_character_select_clicked(GtkButton *button, gpointer user_data);
extern void on_kb_scope_togglebutton_character_toggled(GtkToggleButton *toggle_button, gpointer user_data);
extern void on_kb_scope_togglebutton_global_toggled(GtkToggleButton *toggle_button, gpointer user_data);
extern void on_entry_character(GtkEntry *entry, gpointer user_data);
extern void choose_character_init(void);
extern void on_button_play_character_clicked(GtkButton *button, gpointer user_data);
extern void on_button_create_character_clicked(GtkButton *button, gpointer user_data);
extern void on_button_add_character_clicked(GtkButton *button, gpointer user_data);
extern void on_button_return_login_clicked(GtkButton *button, gpointer user_data);
extern void update_character_choose(const char *name, const char *class, const char *race, const char *face, const char *party, const char *map, int level, int faceno);
extern void on_treeview_choose_character_activated(GtkTreeView *treeview, GtkTreePath *path, GtkTreeViewColumn *column, gpointer user_data);
extern void account_creation_failure(char *message);
extern void on_button_new_create_account_clicked(GtkButton *button, gpointer user_data);
extern void on_button_new_cancel_clicked(GtkButton *button, gpointer user_data);
extern void on_entry_new_account(GtkEntry *entry, gpointer user_data);
extern void account_login_failure(char *message);
extern void on_button_create_account_clicked(GtkButton *button, gpointer user_data);
extern void on_button_go_metaserver_clicked(GtkButton *button, gpointer user_data);
extern void on_button_exit_client_clicked(GtkButton *button, gpointer user_data);
extern void on_button_login_clicked(GtkButton *button, gpointer user_data);
extern void on_entry_account_name_activate(GtkEntry *entry, gpointer user_data);
extern void on_entry_account_password_activate(GtkEntry *entry, gpointer user_data);
extern void update_login_info(int type);
extern void start_login(int method);
extern void choose_char_window_show();
/* config.c */
extern void load_theme(int reload);
extern void config_check();
extern void config_load(void);
extern void save_defaults(void);
extern void config_init(GtkWidget *window_root);
extern void on_config_button_save_clicked(GtkButton *button, gpointer user_data);
extern void on_config_button_apply_clicked(GtkButton *button, gpointer user_data);
extern void on_config_button_close_clicked(GtkButton *button, gpointer user_data);
extern void on_configure_activate(GtkWidget *menuitem, gpointer user_data);
extern void save_winpos(void);
extern void on_save_window_position_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void load_window_positions(GtkWidget *window_root);
extern void init_theme();
/* create_char.c */
extern void create_character_window_show();
extern void create_character_window_hide();
extern void init_create_character_window();
/* image.c */
extern int create_and_rescale_image_from_data(Cache_Entry *ce, int pixmap_num, guint8 *rgba_data, int width, int height);
extern void addsmooth(guint16 face, guint16 smooth_face);
extern int associate_cache_entry(Cache_Entry *ce, int pixnum);
extern void reset_image_data(void);
extern void image_update_download_status(int start, int end, int total);
extern void get_map_image_size(int face, guint8 *w, guint8 *h);
extern void init_image_cache_data(void);
/* info.c */
extern void set_text_tag_from_style(GtkTextTag *tag, GtkStyle *style, GtkStyle *base_style);
extern void add_tags_to_textbuffer(Info_Pane *pane, GtkTextBuffer *textbuf);
extern void add_style_to_textbuffer(Info_Pane *pane, GtkStyle *base_style);
extern void info_get_styles(void);
extern void info_init(GtkWidget *window_root);
extern void add_marked_text_to_pane(Info_Pane *pane, const char *message, int type, int subtype, int orig_color);
extern void draw_ext_info(int orig_color, int type, int subtype, const char *message);
extern void info_buffer_init(void);
extern void info_buffer_flush(const int id);
extern void info_buffer_tick(void);
extern void menu_clear(void);
extern void msgctrl_init(GtkWidget *window_root);
extern void update_msgctrl_configuration(void);
extern void save_msgctrl_configuration(void);
extern void load_msgctrl_configuration(void);
extern void default_msgctrl_configuration(void);
extern void read_msgctrl_configuration(void);
extern void on_msgctrl_button_save_clicked(GtkButton *button, gpointer user_data);
extern void on_msgctrl_button_load_clicked(GtkButton *button, gpointer user_data);
extern void on_msgctrl_button_defaults_clicked(GtkButton *button, gpointer user_data);
extern void on_msgctrl_button_apply_clicked(GtkButton *button, gpointer user_data);
extern void on_msgctrl_button_close_clicked(GtkButton *button, gpointer user_data);
extern void on_msgctrl_activate(GtkMenuItem *menuitem, gpointer user_data);
/* inventory.c */
extern void inventory_get_styles(void);
extern void inventory_init(GtkWidget *window_root);
extern void close_container(item *op);
extern void open_container(item *op);
extern void command_show(const char *params);
extern void set_weight_limit(guint32 wlim);
extern void item_event_item_deleting(item *it);
extern void item_event_container_clearing(item *container);
extern void item_event_item_changed(item *it);
extern void draw_look_list(void);
extern void draw_lists(void);
extern void inventory_tick(void);
/* keys.c */
extern void keybindings_init(const char *character_name);
extern void keys_init(GtkWidget *window_root);
extern void bind_key(char *params);
extern void unbind_key(const char *params);
extern void focusoutfunc(GtkWidget *widget, GdkEventKey *event, GtkWidget *window);
extern void keyrelfunc(GtkWidget *widget, GdkEventKey *event, GtkWidget *window);
extern void keyfunc(GtkWidget *widget, GdkEventKey *event, GtkWidget *window);
extern void x_set_echo(void);
extern void draw_prompt(const char *str);
extern void gtk_command_history(int direction);
extern void gtk_complete_command(void);
extern void on_entry_commands_activate(GtkEntry *entry, gpointer user_data);
extern void update_keybinding_list(void);
extern void on_keybindings_activate(GtkMenuItem *menuitem, gpointer user_data);
extern gboolean on_keybinding_entry_key_key_press_event(GtkWidget *widget, GdkEventKey *event, gpointer user_data);
extern void on_keybinding_button_remove_clicked(GtkButton *button, gpointer user_data);
extern void on_keybinding_button_bind_clicked(GtkButton *button, gpointer user_data);
extern void on_keybinding_button_update_clicked(GtkButton *button, gpointer user_data);
extern void on_keybinding_button_close_clicked(GtkButton *button, gpointer user_data);
extern void on_keybinding_checkbutton_any_clicked(GtkCheckButton *cb, gpointer user_data);
extern gboolean keybinding_selection_func(GtkTreeSelection *selection, GtkTreeModel *model, GtkTreePath *path, gboolean path_currently_selected, gpointer userdata);
extern void reset_keybinding_status(void);
extern void on_keybinding_button_clear_clicked(GtkButton *button, gpointer user_data);
/* main.c */
extern void client_tick(guint32 tick);
extern void on_window_destroy_event(GtkObject *object, gpointer user_data);
extern void error_dialog(char *description, char *information);
extern void my_log_handler(const gchar *log_domain, GLogLevelFlags log_level, const gchar *message, gpointer user_data);
extern int main(int argc, char *argv[]);
extern void get_window_coord(GtkWidget *win, int *x, int *y, int *wx, int *wy, int *w, int *h);
/* map.c */
extern void map_init(GtkWidget *window_root);
extern int display_mapscroll(int dx, int dy);
extern void resize_map_window(int x, int y);
extern void draw_map(int redraw);
extern void display_map_doneupdate(int redraw, int notice);
/* magicmap.c */
extern void draw_magic_map(void);
extern void magic_map_flash_pos(void);
extern gboolean on_drawingarea_magic_map_expose_event(GtkWidget *widget, GdkEventExpose *event, gpointer user_data);
/* menubar.c */
extern void init_menu_items();
/* metaserver.c */
extern void metaserver_ui_init();
extern void metaserver_show_prompt(void);
extern void on_metaserver_select_clicked(GtkButton *button, gpointer user_data);
extern void on_button_metaserver_quit_pressed(GtkButton *button, gpointer user_data);
/* opengl.c */
extern void init_glx_opengl(GtkWidget *drawingarea);
extern void init_opengl(GtkWidget *drawingarea);
extern void opengl_gen_map(int redraw);
extern void create_opengl_map_image(guint8 *data, PixmapInfo *pi);
extern void opengl_free_pixmap(PixmapInfo *pi);
extern void create_opengl_question_mark(void);
/* pickup.c */
extern void on_menu_dont_pickup_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_stop_before_pickup_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_body_armor_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_boots_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_cloaks_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_gloves_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_helmets_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_shields_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_skillscrolls_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_normal_book_scrolls_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_spellbooks_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_drinks_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_food_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_keys_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_magical_items_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_potions_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_valuables_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_wands_rods_horns_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_not_cursed_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_jewels_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_containers_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_flesh_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_all_weapons_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_missile_weapons_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_bows_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_arrows_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_ratio_pickup_off_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_ratio_5_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_ratio_10_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_ratio_15_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_ratio_20_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_ratio_25_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_ratio_30_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_ratio_35_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_ratio_40_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_ratio_45_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_menu_ratio_50_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void pickup_init(GtkWidget *window_root);
extern void client_pickup(guint32 pickup);
/* png.c */
extern guint8 *png_to_data(guint8 *data, int len, guint32 *width, guint32 *height);
extern guint8 *rescale_rgba_data(guint8 *data, int *width, int *height, int scale);
extern GdkPixbuf *rgba_to_gdkpixbuf(guint8 *data, int width, int height);
extern cairo_surface_t *rgba_to_cairo_surface(guint8 *data, int width, int height);
/* sdl.c */
extern void init_SDL(GtkWidget *sdl_window, int just_lightmap);
extern void drawquarterlightmap_sdl(int tl, int tr, int bl, int br, int width, int height, int startx, int starty, int endx, int endy, int destx, int desty);
extern void sdl_gen_map(int redraw);
extern int sdl_mapscroll(int dx, int dy);
/* skills.c */
extern void update_skill_information(void);
extern void on_skills_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void trigger_skill(GtkTreeIter iter, GtkTreeModel *model, int use_skill);
extern void on_skill_treeview_row_activated(GtkTreeView *treeview, GtkTreePath *path, GtkTreeViewColumn *column, gpointer user_data);
extern void on_skill_ready_clicked(GtkButton *button, gpointer user_data);
extern void on_skill_use_clicked(GtkButton *button, gpointer user_data);
extern void on_skill_close_clicked(GtkButton *button, gpointer user_data);
/* sound.c */
extern int init_sounds(void);
extern void play_sound_effect(gint8 x, gint8 y, guint8 dir, guint8 vol, guint8 type, const char *sound, const char *source);
extern void Sound2Cmd(unsigned char *data, int len);
extern void MusicCmd(const char *data, int len);
/* spells.c */
extern void spell_get_styles(void);
extern void on_spell_window_size_allocate(GtkWidget *widget, gpointer user_data);
extern void update_spell_information(void);
extern void on_spells_activate(GtkMenuItem *menuitem, gpointer user_data);
extern void on_spell_treeview_row_activated(GtkTreeView *treeview, GtkTreePath *path, GtkTreeViewColumn *column, gpointer user_data);
extern void on_spell_cast_clicked(GtkButton *button, gpointer user_data);
extern void on_spell_invoke_clicked(GtkButton *button, gpointer user_data);
extern void on_spell_close_clicked(GtkButton *button, gpointer user_data);
/* stats.c */
extern void stats_get_styles(void);
extern void stats_init(GtkWidget *window_root);
extern void update_stat(int stat_no, gint64 max_stat, gint64 current_stat, gint64 statbar_max, gint64 statbar_stat, int can_alert);
extern void draw_message_window(int redraw);
extern void draw_stats(int redraw);
extern void clear_stat_mapping(void);
