# -*- coding: utf-8 -*-

import sys
import os
import time

try:
    import sphinx_rtd_theme
except ImportError:
    sphinx_rtd_theme = None

try:
    from sphinxcontrib import spelling
except ImportError:
    spelling = None

# Check if we are building on readthedocs
RTD_BUILD = os.environ.get('READTHEDOCS', None) == 'True'

from crossbar import __version__

# -- Project information -----------------------------------------------------

project = 'Crossbar.io Application Router'
this_year = u'{0}'.format(time.strftime('%Y'))
copyright_since = u'2013'
if this_year != copyright_since:
    copyright = u'{0}-{1}, Crossbar.io Technologies GmbH'.format(copyright_since, this_year)
else:
    copyright = u'{0}, Crossbar.io Technologies GmbH'.format(copyright_since)

author = 'Crossbar.io Technologies GmbH'
version = release = __version__


# -- General configuration ---------------------------------------------------

extensions = [
    'sphinxcontrib.spelling',
    'sphinx.ext.autodoc',
    'sphinx.ext.intersphinx',

    # Usage: .. thumbnail:: picture.png
    'sphinxcontrib.images',
]

# https://pythonhosted.org/sphinxcontrib-images/#how-to-configure
images_config = {
    'override_image_directive': False
}

# extensions not available on RTD
if spelling is not None:
    extensions.append('sphinxcontrib.spelling')
    spelling_lang = 'en_US'
    spelling_show_suggestions = False
    spelling_word_list_filename = 'spelling_wordlist.txt'

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = 'en'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path .
exclude_patterns = ['_build', '_work', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
#pygments_style = 'sphinx'
#pygments_style = 'monokai'
#pygments_style = 'native'
#pygments_style = 'pastie'
#pygments_style = 'friendly'
pygments_style = 'sphinx'


# -- Options for HTML output -------------------------------------------------

# the following trickery is to make it build both locally and on RTD
#
# see: https://blog.deimos.fr/2014/10/02/sphinxdoc-and-readthedocs-theme-tricks-2/
#
if RTD_BUILD:
    html_context = {
        'css_files': [
            'https://media.readthedocs.org/css/sphinx_rtd_theme.css',
            'https://media.readthedocs.org/css/readthedocs-doc-embed.css',
            '_static/custom.css'
        ]
    }
else:
    if sphinx_rtd_theme:
        html_theme = 'sphinx_rtd_theme'
        html_theme_path = [sphinx_rtd_theme.get_html_theme_path()]

        # add custom CSS on top of Sphinx RTD standard CSS
        def setup(app):
            app.add_stylesheet('css/custom.css')
    else:
        html_theme = 'default'

html_logo = '_static/img/crossbar.svg'
full_logo = True

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = {
    'collapse_navigation': False,
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

html_favicon = '_static/favicon.ico'

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}


# -- Extension configuration -------------------------------------------------

# -- Options for intersphinx extension ---------------------------------------

intersphinx_mapping = {
    'https://docs.python.org/': None,
    'py2': ('https://docs.python.org/2', None),
    'py3': ('https://docs.python.org/3', None),

    # 404 Client Error: Not Found for url: https://pythonhosted.org/six/objects.inv
    # 'six': ('https://pythonhosted.org/six/', None),
}

rst_epilog = """
"""

rst_prolog = """
"""

# http://stackoverflow.com/questions/5599254/how-to-use-sphinxs-autodoc-to-document-a-classs-init-self-method
autoclass_content = 'both'

# http://www.sphinx-doc.org/en/stable/ext/autodoc.html#confval-autodoc_member_order
autodoc_member_order = 'bysource'
