title: Installation
toc: [Documentation, Installation]

# Installing Crossbar.io

Below are different ways of installing Crossbar.io. **We recommend our [Docker images](#docker-images).**

If you have an installation related question, please also check the [Installation FAQ](Installation FAQ).

## Docker Images

We provide official Docker images for Crossbar.io in different flavors. This is both a quick way getting started with Crossbar.io and a good approach going to production:

* [Getting Started](Getting Started)

## Other Platforms

We provide installation instructions for setting up Crossbar.io on your own systems for different operating systems or environments.

* [Installation on (generic) Linux](Installation on Linux)
* [Installation on Mac OS X](Installation on Mac OS X)
* [Installation on Windows](Installation on Windows)

## Setup in the Cloud

Crossbar.io runs great on *Infrastructure-as-a-Service (Iaas)* providers like [Amazon EC2](http://aws.amazon.com/ec2/) or [Microsoft Azure](http://azure.microsoft.com/). As an example, there's

* [Setup on Amazon EC2](Setup-on-Amazon-EC2)

Additionally, Crossbar.io can be run on *Platform-as-a-Service (PaaS)* providers:

* [Setup on Heroku](Setup-on-Heroku)
* [Setup on OpenShift](Setup-on-OpenShift)


## Demo Instance

For light-weight testing purposes, you might also use our public demo instances of Crossbar.io:

* [Demo Instance](Demo Instance)

> The public demo instances of Crossbar.io is provided as a convenience, and for free. Please only use it for development and testing purposes. We don't make any guarantees whatsoever, and the service might be restricted in the future.
