title: Administration
toc: [Documentation, Administration]

# Administration Manual

This is the Crossbar.io **Administration Manual**. The documentation here discusses the configuration and administration of the different features that come with Crossbar.io.

> For developers, we provide a [Programming Guide](Programming Guide) that provides documentation about programming aspects related to Crossbar.io.

### Node Configuration

A Crossbar.io node runs from a [Node Configuration](Node Configuration) and starts a number of [Processes](Processes) which can be configured:

* [Router Configuration](Router Configuration)
    * [Router Realms](Router Realms)
    * [Router Components](Router Components)
* [Container Configuration](Container Configuration)
* [Guest Configuration](Guest Configuration)
* [Controller Configuration](Controller Configuration)

The router processes run [Router Transports](Router Transports)

* [Transport Endpoints](Transport Endpoints)
* [Web Transport and Services](Web Transport and Services)
* [WebSocket Transport](WebSocket Transport)
* [RawSocket Transport](RawSocket Transport)
* [MQTT Broker](MQTT Broker)

### Authentication and Authorization

* [Authentication](Authentication)
* [Authorization](Authorization)

### Web Services

* [Web Transport and Services](Web Transport and Services)
* [Web Services](Web Services)
* [HTTP Bridge](HTTP Bridge)

### More

* [The Command Line](Command Line)
* [Logging](Logging) - Logging in Crossbar.io
* [Going to Production](Going-to-Production)
